// Learn cc.Class:RedCircle
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        graphics:cc.Graphics,
        color:cc.color(),
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad:function() {
        console.log('RedCircle onLoad');
        this.circleRadius=30;
        this.graphics.fillColor = new cc.Color().fromHEX('#0000ff');
        this.graphics.circle(0, 0, this.circleRadius);
        this.graphics.fill();
    },

    start:function() {

    },
    // 只在两个碰撞体开始接触时被调用一次
    onBeginContact: function (contact, selfCollider, otherCollider) {
        var worldManifold = contact.getWorldManifold();
        var points = worldManifold.points;
        console.log('RedCircle onBeginContact',points);
    },
    // 每次处理完碰撞体接触逻辑时被调用
    onPostSolve: function (contact, selfCollider, otherCollider) {
        console.log('RedCircle onPostSolve',contact);
    },
    // update (dt) {},
});
