"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.onAfterMake = exports.onBeforeMake = exports.onError = exports.unload = exports.onAfterBuild = exports.onAfterCompressSettings = exports.onBeforeCompressSettings = exports.onBeforeBuild = exports.load = exports.throwError = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const xxtea_1 = require("./xxtea");
const encrypt_sign = "GboVCgAqKsXz";
const encrypt_password = "FQw47RHgOR1fEtel";
const PACKAGE_NAME = 'build-encrypt-image';
function log(...arg) {
    return console.log(`[${PACKAGE_NAME}] `, ...arg);
}
let allAssets = [];
exports.throwError = true;
const load = function () {
    return __awaiter(this, void 0, void 0, function* () {
        console.log(`[${PACKAGE_NAME}] Load cocos plugin example in builder.`);
        allAssets = yield Editor.Message.request('asset-db', 'query-assets');
    });
};
exports.load = load;
const onBeforeBuild = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        // Todo some thing
        log(`${PACKAGE_NAME}.webTestOption`, 'onBeforeBuild');
    });
};
exports.onBeforeBuild = onBeforeBuild;
const onBeforeCompressSettings = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
               console.log("加密 onBeforeBuild ：");
        const pkgOptions = options.packages[PACKAGE_NAME];
        // if (pkgOptions.webTestOption) {
        //     console.debug('webTestOption', true);
        // }
        // Todo some thing
        console.debug('get settings PACKAGE_NAME', PACKAGE_NAME, pkgOptions);
        console.debug('get settings test', result.settings);
    });
};
exports.onBeforeCompressSettings = onBeforeCompressSettings;
const onAfterCompressSettings = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        // Todo some thing
        console.log('webTestOption', 'onAfterCompressSettings');
    });
};
exports.onAfterCompressSettings = onAfterCompressSettings;
const flagImageEncrypt = true;
const flagTextEncrypt = true;
const flagAudioEncrypt = false;
const onAfterBuild = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        //执行加密逻辑
        console.log("加密 onAfterBuild ：");
        if (options.platform == 'android' || options.platform == 'ios' || options.platform == 'windows') {
            let logStr = "";
            if (flagImageEncrypt)
                logStr += '  图像';
            if (flagTextEncrypt)
                logStr += '  文本';
            if (flagAudioEncrypt)
                logStr += '  音频';
            console.log("正在加密资源：" + logStr, options.outputName);
            let assetsPath = Editor.Project.path + "/build" + `/${options.outputName}` + '/assets';
            fs_1.default.stat(assetsPath, (err, data) => {
                if (err) {
                    console.log("加密 onAfterBuild ：", err);
                }
                else {
                    encryptionDirFileByPath(assetsPath);
                    console.log("加密资源：" + logStr + " 完成！");
                }
            });
        }
    });
};
exports.onAfterBuild = onAfterBuild;
const unload = function () {
    return __awaiter(this, void 0, void 0, function* () {
        console.log(`[${PACKAGE_NAME}] Unload cocos plugin example in builder.`);
    });
};
exports.unload = unload;
const onError = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        // Todo some thing
        console.warn(`${PACKAGE_NAME} run onError`);
    });
};
exports.onError = onError;
const onBeforeMake = function (root, options) {
    return __awaiter(this, void 0, void 0, function* () {
        console.log(`onBeforeMake: root: ${root}, options: ${options}`);
    });
};
exports.onBeforeMake = onBeforeMake;
const onAfterMake = function (root, options) {
    return __awaiter(this, void 0, void 0, function* () {
        console.log(`onAfterMake: root: ${root}, options: ${options}`);
    });
};
exports.onAfterMake = onAfterMake;
/**
 * 加密逻辑处理
 */
function encryptionDirFileByPath(filePath) {
    fs_1.default.readdirSync(filePath).forEach((node, index) => {
        let newPath = filePath + '/' + node;
        let info = fs_1.default.statSync(newPath);
        if (info.isDirectory()) {
            encryptionDirFileByPath(newPath);
        }
        else {
            let extName = path_1.default.extname(node);
            switch (extName) {
                case '.png':
                case '.jpg':
                    if (flagImageEncrypt) {
                        encryptionScheme1(newPath);
                    }
                    break;
                case '.json':
                case '.txt':
                    if (flagTextEncrypt) {
                        encryptionScheme2(newPath);
                    }
                    break;
                case '.mp3':
                case '.wav':
                case '.ogg':
                    if (flagAudioEncrypt) {
                        audioEncryption(newPath);
                    }
                    break;
            }
        }
    });
}
/**加密 png-jpg */
function encryptionScheme1(filePath) {
    try {
        let fileData = fs_1.default.readFileSync(filePath);
        let writeData = encryption(fileData);
        fs_1.default.writeFileSync(filePath, writeData);
    }
    catch (e) {
        console.error("encryptionScheme1 error ：", filePath, e);
    }
}
function encryptionScheme2(filePath) {
    try {
        let fileData = fs_1.default.readFileSync(filePath);
        let dataStr = fileData.toString();
        if (dataStr.indexOf('cc.TextAsset') != -1 || dataStr.indexOf('cc.JsonAsset') != -1) {
            console.log("========>加密json和txt资源：", filePath);
            let writeData = encryption(fileData);
            fs_1.default.writeFileSync(filePath, writeData);
        }
    }
    catch (e) {
        console.error("encryptionScheme2 error ：", e);
    }
}
function audioEncryption(filePath) {
    try {
        //当文件数据大小大于等于skipLength时，跳过加密，skipLength单位是字节
        const skipLength = 128000;
        let states = fs_1.default.statSync(filePath);
        if (states.size >= skipLength) {
            return;
        }
        let fileData = fs_1.default.readFileSync(filePath);
        let writeData = encryption(fileData);
        fs_1.default.writeFileSync(filePath, writeData);
    }
    catch (e) {
        console.error("audioEncryption error ：", e);
    }
}
function encryption(fileData) {
    let encrypt_data = xxtea_1.xxtea_ts.ins.encrypt(fileData, encrypt_password);
    let encryptHead = xxtea_1.xxtea_ts.ins.toUint8Array(xxtea_1.xxtea_ts.ins.toUint32Array(xxtea_1.xxtea_ts.ins.toBytes(encrypt_sign), true), false);
    let encryptHeadLength = encrypt_sign.length;
    let writeData = new Uint8Array(encryptHeadLength + encrypt_data.length);
    for (let i = 0; i < writeData.length; i++) {
        if (i < encryptHeadLength) {
            writeData[i] = encryptHead[i];
        }
        else {
            writeData[i] = encrypt_data[i - encryptHeadLength];
        }
    }
    return writeData;
}
