import { IBuildTaskOption, BuildHook, IBuildResult } from '../@types';

import fs from "fs";
import path from "path";
import { xxtea_ts } from './xxtea';

const encrypt_sign: string = "GboVCgAqKsXz"
const encrypt_password: string = "FQw47RHgOR1fEtel";


interface IOptions {
    remoteAddress: string;
    enterCocos: string;
    selectTest: string;
    objectTest: {
        number: number;
        string: string;
        boolean: boolean
    },
    arrayTest: [number, string, boolean];
}

const PACKAGE_NAME = 'build-encrypt-image';

interface ITaskOptions extends IBuildTaskOption {
    packages: {
        'cocos-plugin-template': IOptions;
    };
}

function log(...arg: any[]) {
    return console.log(`[${PACKAGE_NAME}] `, ...arg);
}

let allAssets = [];

export const throwError: BuildHook.throwError = true;

export const load: BuildHook.load = async function () {
    console.log(`[${PACKAGE_NAME}] Load cocos plugin example in builder.`);
    allAssets = await Editor.Message.request('asset-db', 'query-assets');
};

export const onBeforeBuild: BuildHook.onBeforeBuild = async function (options: ITaskOptions, result: IBuildResult) {
    // Todo some thing
                   console.log("加密 onBeforeBuild ：");
    log(`${PACKAGE_NAME}.webTestOption`, 'onBeforeBuild');
};

export const onBeforeCompressSettings: BuildHook.onBeforeCompressSettings = async function (options: ITaskOptions, result: IBuildResult) {
    const pkgOptions = options.packages[PACKAGE_NAME];
    // if (pkgOptions.webTestOption) {
    //     console.debug('webTestOption', true);
    // }
    // Todo some thing
    console.debug('get settings PACKAGE_NAME', PACKAGE_NAME, pkgOptions);
    console.debug('get settings test', result.settings);
};

export const onAfterCompressSettings: BuildHook.onAfterCompressSettings = async function (options: ITaskOptions, result: IBuildResult) {
    // Todo some thing
    console.log('webTestOption', 'onAfterCompressSettings');
};

const flagImageEncrypt: boolean = true;
const flagTextEncrypt: boolean = true;
const flagAudioEncrypt: boolean = false;
export const onAfterBuild: BuildHook.onAfterBuild = async function (options: ITaskOptions, result: IBuildResult) {
    console.log("加密 onAfterBuild ：");

    //执行加密逻辑
    if (options.platform == 'android' || options.platform == 'ios' || options.platform == 'windows') {
        let logStr = "";
        if (flagImageEncrypt)
            logStr += '  图像';
        if (flagTextEncrypt)
            logStr += '  文本';
        if (flagAudioEncrypt)
            logStr += '  音频';

        console.log("正在加密资源：" + logStr, options.outputName);
        let assetsPath = Editor.Project.path + "/build" + `/${options.outputName}` + '/assets';
        fs.stat(assetsPath, (err, data) => {
            if (err) {
                console.log("加密 onAfterBuild ：", err);
            } else {
                encryptionDirFileByPath(assetsPath);
                console.log("加密资源：" + logStr + " 完成！");
            }
        });
    }
};

export const unload: BuildHook.unload = async function () {
    console.log(`[${PACKAGE_NAME}] Unload cocos plugin example in builder.`);
};

export const onError: BuildHook.onError = async function (options, result) {
    // Todo some thing
    console.warn(`${PACKAGE_NAME} run onError`);
};

export const onBeforeMake: BuildHook.onBeforeMake = async function (root, options) {
    console.log(`onBeforeMake: root: ${root}, options: ${options}`);
};

export const onAfterMake: BuildHook.onAfterMake = async function (root, options) {
    console.log(`onAfterMake: root: ${root}, options: ${options}`);
};

/**
 * 加密逻辑处理
 */
function encryptionDirFileByPath(filePath) {
    fs.readdirSync(filePath).forEach((node, index) => {
        let newPath = filePath + '/' + node;
        let info = fs.statSync(newPath);
        if (info.isDirectory()) {
            encryptionDirFileByPath(newPath);

        } else {
            let extName = path.extname(node);
            switch (extName) {
                case '.png':
                case '.jpg':
                    if (flagImageEncrypt) {
                        encryptionScheme1(newPath);
                    }
                    break;
                case '.json':
                case '.txt':
                    if (flagTextEncrypt) {
                        encryptionScheme2(newPath);
                    }
                    break;
                case '.mp3':
                case '.wav':
                case '.ogg':
                    if (flagAudioEncrypt) {
                        audioEncryption(newPath);
                    }
                    break;
            }
        }
    });
}
/**加密 png-jpg */
function encryptionScheme1(filePath) {
    try {
        let fileData = fs.readFileSync(filePath);
        let writeData = encryption(fileData);
        fs.writeFileSync(filePath, writeData);
    } catch (e) {
        console.error("encryptionScheme1 error ：", filePath, e);
    }
}

function encryptionScheme2(filePath) {
    try {
        let fileData = fs.readFileSync(filePath);
        let dataStr = fileData.toString();
        if (dataStr.indexOf('cc.TextAsset') != -1 || dataStr.indexOf('cc.JsonAsset') != -1) {
            console.log("========>加密json和txt资源：", filePath);
            let writeData = encryption(fileData);
            fs.writeFileSync(filePath, writeData);
        }
    } catch (e) {
        console.error("encryptionScheme2 error ：", e);
    }
}

function audioEncryption(filePath) {
    try {
        //当文件数据大小大于等于skipLength时，跳过加密，skipLength单位是字节
        const skipLength = 128000;
        let states = fs.statSync(filePath);
        if (states.size >= skipLength) {
            return;
        }

        let fileData = fs.readFileSync(filePath);
        let writeData = encryption(fileData);
        fs.writeFileSync(filePath, writeData);

    } catch (e) {
        console.error("audioEncryption error ：", e);
    }
}

function encryption(fileData) {
    let encrypt_data = xxtea_ts.ins.encrypt(fileData, encrypt_password);
    let encryptHead = xxtea_ts.ins.toUint8Array(xxtea_ts.ins.toUint32Array(xxtea_ts.ins.toBytes(encrypt_sign), true), false);
    let encryptHeadLength = encrypt_sign.length;
    let writeData = new Uint8Array(encryptHeadLength + encrypt_data.length);
    for (let i = 0; i < writeData.length; i++) {
        if (i < encryptHeadLength) {
            writeData[i] = encryptHead[i];
        } else {
            writeData[i] = encrypt_data[i - encryptHeadLength];
        }
    }
    return writeData;
}