import ServerConfig from "./ServerConfig"

class Host {
    constructor() {
        this.isWechat = cc.sys.platform === cc.sys.WECHAT_GAME
        this.isQQ = this.isWechat && ServerConfig.subPlatform === 'qq'
        this.isJkw = cc.sys.platform === cc.sys.JKW_GAME
        this.isAndroid = cc.sys.platform === cc.sys.OS_ANDROID || cc.sys.platform === 3
    }

    // 基础-系统-系统信息
    getSystemInfoSync() {
        if (this.isWechat) {
            return wx.getSystemInfoSync()
        } else if (this.isJkw) {
            cc.log('host.getSystemInfoSync')
            if (CC_PREVIEW || CC_BUILD) {
                return loadRuntime().getSystemInfoSync()
            }
        } else if (this.isAndroid) {
            return {
                screenWidth: cc.view.getDesignResolutionSize().width,
                screenHeight: cc.view.getDesignResolutionSize().height,
                safeArea: cc.sys.getSafeAreaRect()
            }
        }
    }

    getSystemInfo(object) {
        if (this.isWechat) {
            return wx.getSystemInfo(object)
        } else if (this.isJkw) {
            cc.log('host.getSystemInfo')
            if (CC_PREVIEW || CC_BUILD) {
                return loadRuntime().getSystemInfo()
            }
        } else if (this.isAndroid) {
            cc.log('host.getSystemInfo')
        }
    }

    // 基础-更新
    getUpdateManager() {
        if (this.isWechat) {
            return wx.getUpdateManager()
        } else if (this.isJkw) {
            cc.log('host.getUpdateManager')
            return {
                onCheckForUpdate: (callback) => { },
                onUpdateFailed: (callback) => { },
                onUpdateReady: (callback) => { },
            }
        } else if (this.isAndroid) {
            cc.log('host.getUpdateManager')
            return {
                onCheckForUpdate: (callback) => { },
                onUpdateFailed: (callback) => { },
                onUpdateReady: (callback) => { },
            }
        }
    }

    // 基础-生命周期
    exitMiniProgram(object) {
        if (this.isWechat) {
            return wx.exitMiniProgram(object)
        } else if (this.isJkw) {
            cc.log('host.exitMiniProgram')
        } else if (this.isAndroid) {
            cc.log('host.exitMiniProgram')
        }
    }

    // 基础-应用级事件
    onAudioInterruptionEnd(callback) {
        if (this.isWechat) {
            return wx.onAudioInterruptionEnd(callback)
        } else if (this.isJkw) {
            cc.log('host.onAudioInterruptionBegin')
        } else if (this.isAndroid) {
            cc.log('host.onAudioInterruptionBegin')
        }
    }

    onAudioInterruptionBegin(callback) {
        if (this.isWechat) {
            return wx.onAudioInterruptionBegin(callback)
        } else if (this.isJkw) {
            cc.log('host.onAudioInterruptionBegin')
        } else if (this.isAndroid) {
            cc.log('host.onAudioInterruptionBegin')
        }
    }

    offAudioInterruptionEnd(callback) {
        if (this.isWechat) {
            return wx.offAudioInterruptionEnd(callback)
        } else if (this.isJkw) {
            cc.log('host.onAudioInterruptionBegin')
        } else if (this.isAndroid) {
            cc.log('host.onAudioInterruptionBegin')
        }
    }

    offAudioInterruptionBegin(callback) {
        if (this.isWechat) {
            return wx.offAudioInterruptionBegin(callback)
        } else if (this.isJkw) {
            cc.log('host.onAudioInterruptionBegin')
        } else if (this.isAndroid) {
            cc.log('host.onAudioInterruptionBegin')
        }
    }

    // 基础-订阅消息
    requestSubscribeSystemMessage(object) {
        if (this.isWechat) {
            return wx.requestSubscribeSystemMessage(object)
        } else if (this.isJkw) {
            cc.log('host.requestSubscribeSystemMessage')
        } else if (this.isAndroid) {
            cc.log('host.requestSubscribeSystemMessage')
        }
    }

    requestSubscribeMessage(object) {
        if (this.isWechat) {
            return wx.requestSubscribeMessage(object)
        } else if (this.isJkw) {
            cc.log('host.requestSubscribeMessage')
        } else if (this.isAndroid) {
            cc.log('host.requestSubscribeMessage')
        }
    }

    // 渲染-帧率
    setPreferredFramesPerSecond(fps) {
        if (this.isWechat) {
            return wx.setPreferredFramesPerSecond(fps)
        } else if (this.isJkw) {
            cc.log('host.setPreferredFramesPerSecond')
        } else if (this.isAndroid) {
            cc.log('host.setPreferredFramesPerSecond')
        }
    }


    // 广告
    createRewardedVideoAd(object) {
        if (this.isWechat) {
            return wx.createRewardedVideoAd(object)
        } else if (this.isJkw) {
            return AdSDK.createRewardedVideoAd(object.adUnitId, ServerConfig.videoAdId, 2)
        } else if (this.isAndroid) {
            cc.log('host.createRewardedVideoAd')
            return {
                destroy: () => { },
                load: () => { },
                offClose: (callback) => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onClose: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
                hide: () => { },
            }
        }
    }

    createInterstitialAd(object) {
        if (this.isWechat) {
            return wx.createInterstitialAd(object)
        } else if (this.isJkw) {        
            let obj = AdSDK.createInterstitialAd(object.adUnitId, ServerConfig.interstitialAdId, 2)
            obj.onClose = obj.onResize
            obj.offClose = obj.offResize
            return obj
        } else if (this.isAndroid) {
            cc.log('host.createInterstitialAd')
            return {
                destroy: () => { },
                load: () => { },
                offClose: (callback) => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onClose: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
                hide: () => { },
            }
        }
    }

    createBannerAd(object) {
        if (this.isWechat) {
            return wx.createBannerAd(object)
        } else if (this.isJkw) {
            cc.log('host.createBannerAd')
            return {
                destroy: () => { },
                load: () => { },
                offClose: (callback) => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onClose: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
                hide: () => { },
            }
        } else if (this.isAndroid) {
            cc.log('host.createBannerAd')
            return {
                destroy: () => { },
                load: () => { },
                offClose: (callback) => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onClose: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
                hide: () => { },
            }
        }
    }

    // 界面-交互
    showToast(object) {
        if (this.isWechat) {
            return wx.showToast(object)
        } else if (this.isJkw) {
            cc.log('host.showToast')
        } else if (this.isAndroid) {
            cc.log('host.showToast')
        }
    }

    showModal(object) {
        if (this.isWechat) {
            return wx.showModal(object)
        } else if (this.isJkw) {
            cc.log('host.showModal')
        } else if (this.isAndroid) {
            cc.log('host.showModal')
        }
    }

    showLoading(object) {
        if (this.isWechat) {
            return wx.showLoading(object)
        } else if (this.isJkw) {
            cc.log('host.showLoading')
        } else if (this.isAndroid) {
            cc.log('host.showLoading')
        }
    }

    showActionSheet(object) {
        if (this.isWechat) {
            return wx.showActionSheet(object)
        } else if (this.isJkw) {
            cc.log('host.showActionSheet')
        } else if (this.isAndroid) {
            cc.log('host.showActionSheet')
        }
    }

    hideToast(object) {
        if (this.isWechat) {
            return wx.hideToast(object)
        } else if (this.isJkw) {
            cc.log('host.hideToast')
        } else if (this.isAndroid) {
            cc.log('host.hideToast')
        }
    }

    hideLoading(object) {
        if (this.isWechat) {
            return wx.hideLoading(object)
        } else if (this.isJkw) {
            cc.log('host.hideLoading')
        } else if (this.isAndroid) {
            cc.log('host.hideLoading')
        }
    }

    connectSocket(object) {
        if (this.isWechat) {
            return wx.connectSocket(object)
        } else if (this.isJkw) {
            cc.log('host.connectSocket')
            if (CC_PREVIEW || CC_BUILD) {
                return new WebSocket(object.url)
            }
        } else if (this.isAndroid) {
            cc.log('host.connectSocket')
            if (CC_PREVIEW || CC_BUILD) {
                return new WebSocket(object.url)
            }
        }
    }

    request(object) {
        if (this.isWechat) {
            return wx.request(object)
        } else if (this.isJkw) {
            cc.log('host.request')
            if (CC_PREVIEW || CC_BUILD) {
                let xhr = cc.loader.getXMLHttpRequest();
                xhr.onreadystatechange = () => {
                    if (xhr.readyState == 4) {
                        cc.log('response:', xhr.status, xhr.responseURL)
                        if (xhr.status >= 200 && xhr.status < 400) {
                            let data = {
                                data: xhr.status === 204 ? '' : JSON.parse(xhr.responseText),
                                errMsg: "request:ok",
                                statusCode: xhr.status,
                            }
                            object.success && object.success(data)
                        } else {
                            object.fail && object.fail(xhr.status)
                        }
                    }
                };
                cc.log('request:', object.method, object.url)
                if (object.method.toUpperCase() === 'GET') {
                    let url = object.url
                    if (object.data) {
                        let first = true
                        Object.keys(object.data).forEach(key => {
                            if (first) {
                                url += '?' + key + '=' + encodeURIComponent(object.data[key])
                            } else {
                                url += '&' + key + '=' + encodeURIComponent(object.data[key])
                                first = false
                            }
                        })
                    }
                    xhr.open(object.method, url, true)
                    Object.keys(object.header).forEach(key => xhr.setRequestHeader(key, object.header[key]))
                    xhr.send()    
                } else {
                    xhr.open(object.method, object.url, true)
                    xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
                    Object.keys(object.header).forEach(key => xhr.setRequestHeader(key, object.header[key]))
                    xhr.send(JSON.stringify(object.data))
                }
            }
        } else if (this.isAndroid) {
            cc.log('host.request')
            if (CC_PREVIEW || CC_BUILD) {
                let xhr = cc.loader.getXMLHttpRequest();
                xhr.onreadystatechange = () => {
                    if (xhr.readyState == 4) {
                        cc.log('response:', xhr.status, xhr.responseURL)
                        if (xhr.status >= 200 && xhr.status < 400) {
                            let data = {
                                data: xhr.status === 204 ? '' : JSON.parse(xhr.responseText),
                                errMsg: "request:ok",
                                statusCode: xhr.status,
                            }
                            object.success && object.success(data)
                        } else {
                            object.fail && object.fail(xhr.status)
                        }
                    }
                };
                cc.log('request:', object.method, object.url)
                if (object.method.toUpperCase() === 'GET') {
                    let url = object.url
                    if (object.data) {
                        let first = true
                        Object.keys(object.data).forEach(key => {
                            if (first) {
                                url += '?' + key + '=' + encodeURIComponent(object.data[key])
                            } else {
                                url += '&' + key + '=' + encodeURIComponent(object.data[key])
                                first = false
                            }
                        })
                    }
                    xhr.open(object.method, url, true)
                    Object.keys(object.header).forEach(key => xhr.setRequestHeader(key, object.header[key]))
                    xhr.send()    
                } else {
                    xhr.open(object.method, object.url, true)
                    xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
                    Object.keys(object.header).forEach(key => xhr.setRequestHeader(key, object.header[key]))
                    xhr.send(JSON.stringify(object.data))
                }
            }
        }
    }


    showShareMenu(object = {}) {
        if (this.isWechat) {
            return wx.showShareMenu(object)
        } else if (this.isJkw) {
            cc.log('host.showShareMenu')
        } else if (this.isAndroid) {
            cc.log('host.showShareMenu')
        }
    }

    request(object) {
        if (this.isWechat) {
            return wx.request(object)
        } else if (this.isJkw) {
            cc.log('host.request')
            if (CC_PREVIEW || CC_BUILD) {
                let xhr = cc.loader.getXMLHttpRequest();
                xhr.onreadystatechange = () => {
                    if (xhr.readyState == 4) {
                        cc.log('response:', xhr.status, xhr.responseURL)
                        if (xhr.status >= 200 && xhr.status < 400) {
                            let data = {
                                data: xhr.status === 204 ? '' : JSON.parse(xhr.responseText),
                                errMsg: "request:ok",
                                statusCode: xhr.status,
                            }
                            object.success && object.success(data)
                        } else {
                            object.fail && object.fail(xhr.status)
                        }
                    }
                };
                cc.log('request:', object.method, object.url)
                xhr.open(object.method, object.url, true)
                xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
                Object.keys(object.header).forEach(key => xhr.setRequestHeader(key, object.header[key]))
                xhr.send(JSON.stringify(object.data))
            }
        }
    }


    setStorageSync(key, data) {
        if (this.isWechat) {
            return wx.setStorageSync(key, data)
        } else if (this.isJkw) {
            cc.log('host.setStorageSync')
            return cc.sys.localStorage.setItem(key, JSON.stringify(data))
        } else if (this.isAndroid) {
            cc.log('host.setStorageSync')
            return cc.sys.localStorage.setItem(key, JSON.stringify(data))
        }
    }

    setStorage(object) {
        if (this.isWechat) {
            return wx.setStorage(object)
        } else if (this.isJkw) {
            cc.log('host.setStorage')
            try {
                cc.sys.localStorage.setItem(object.key, JSON.stringify(object.data))
                object.success && object.success()
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        } else if (this.isAndroid) {
            cc.log('host.setStorage')
            try {
                cc.sys.localStorage.setItem(object.key, JSON.stringify(object.data))
                object.success && object.success()
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        }

    }

    removeStorageSync(key) {
        if (this.isWechat) {
            return wx.removeStorageSync(key)
        } else if (this.isJkw) {
            cc.log('host.removeStorageSync')
            return cc.sys.localStorage.removeItem(key)
        } else if (this.isAndroid) {
            cc.log('host.removeStorageSync')
            return cc.sys.localStorage.removeItem(key)
        }
    }

    removeStorage(object) {
        if (this.isWechat) {
            return wx.removeStorage(object)
        } else if (this.isJkw) {
            cc.log('host.removeStorage')
            try {
                result = cc.sys.localStorage.removeItem(object.key)
                if (object.success) {
                    object.success()
                }
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        } else if (this.isAndroid) {
            cc.log('host.removeStorage')
            try {
                result = cc.sys.localStorage.removeItem(object.key)
                if (object.success) {
                    object.success()
                }
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        }
    }

    getStorageSync(key) {
        if (this.isWechat) {
            return wx.getStorageSync(key)
        } else if (this.isJkw) {
            cc.log('host.getStorageSync')
            let result = cc.sys.localStorage.getItem(key)
            result = result === null ? '' : JSON.parse(result)
            return result
        } else if (this.isAndroid) {
            cc.log('host.getStorageSync')
            let result = cc.sys.localStorage.getItem(key)
            result = result === null ? '' : JSON.parse(result)
            return result
        }
    }

    getStorageInfoSync(object) {
        if (this.isWechat) {
            return wx.getStorageInfoSync(object)
        } else if (this.isJkw) {
            cc.log('host.getStorageInfoSync')
            let result = {
                keys: [],
                currentSize: -1,
                limitSize: -1,
            }
            for (let i = 0; i < cc.sys.localStorage.length; i++) {
                let value = cc.sys.localStorage.key(i)
                result.keys[i] = value === null ? '' : JSON.parse(value)
            }
            return result
        } else if (this.isAndroid) {
            cc.log('host.getStorageInfoSync')
            let result = {
                keys: [],
                currentSize: -1,
                limitSize: -1,
            }
            for (let i = 0; i < cc.sys.localStorage.length; i++) {
                let value = cc.sys.localStorage.key(i)
                result.keys[i] = value === null ? '' : JSON.parse(value)
            }
            return result
        }
    }

    getStorageInfo(object) {
        if (this.isWechat) {
            return wx.getStorageInfo(object)
        } else if (this.isJkw) {
            cc.log('host.getStorageInfo')
            try {
                let result = {
                    keys: [],
                    currentSize: -1,
                    limitSize: -1,
                }
                for (let i = 0; i < cc.sys.localStorage.length; i++) {
                    let value = cc.sys.localStorage.key(i)
                    result.keys[i] = value === null ? '' : JSON.parse(value)
                }
                object.success && object.success(result)
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        } else if (this.isAndroid) {
            cc.log('host.getStorageInfo')
            try {
                let result = {
                    keys: [],
                    currentSize: -1,
                    limitSize: -1,
                }
                for (let i = 0; i < cc.sys.localStorage.length; i++) {
                    let value = cc.sys.localStorage.key(i)
                    result.keys[i] = value === null ? '' : JSON.parse(value)
                }
                object.success && object.success(result)
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        }
    }

    getStorage(object) {
        if (this.isWechat) {
            return wx.getStorage(object)
        } else if (this.isJkw) {
            cc.log('host.getStorage')
            try {
                let result = cc.sys.localStorage.getItem(key)
                result = result === null ? '' : JSON.parse(result)
                object.success && object.success(result)
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        } else if (this.isAndroid) {
            cc.log('host.getStorage')
            try {
                let result = cc.sys.localStorage.getItem(key)
                result = result === null ? '' : JSON.parse(result)
                object.success && object.success(result)
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        }
    }

    clearStorageSync() {
        if (this.isWechat) {
            return wx.clearStorageSync()
        } else if (this.isJkw) {
            cc.log('host.clearStorageSync')
            cc.sys.localStorage.clear()
        } else if (this.isAndroid) {
            cc.log('host.clearStorageSync')
            cc.sys.localStorage.clear()
        }
    }

    clearStorage(object) {
        if (this.isWechat) {
            return wx.clearStorage(object)
        } else if (this.isJkw) {
            cc.log('host.clearStorage')
            try {
                let result = cc.sys.localStorage.clear()
                object.success && object.success(result)
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        } else if (this.isAndroid) {
            cc.log('host.clearStorage')
            try {
                let result = cc.sys.localStorage.clear()
                object.success && object.success(result)
            } catch (error) {
                object.fail && object.fail(error)
            }
            object.complete && object.complete()
        }
    }

    getLaunchOptionsSync() {
        if (this.isWechat) {
            return wx.getLaunchOptionsSync()
        } else if (this.isJkw) {
            cc.log('host.getLaunchOptionsSync')
            return {
                query: {},
                scene: -1,
                referrerInfo: {
                    appId: 0,
                }
            }
        } else if (this.isAndroid) {
            cc.log('host.getLaunchOptionsSync')
            return {
                query: {},
                scene: -1,
                referrerInfo: {
                    appId: 0,
                }
            }
        }
    }

    // 设备-剪切板
    setClipboardData(object) {
        if (this.isWechat) {
            return wx.setClipboardData(object)
        } else if (this.isJkw) {
            cc.log('host.setClipboardData')
        } else if (this.isAndroid) {
            cc.log('host.setClipboardData')
        }
    }

    getClipboardData(object) {
        if (this.isWechat) {
            return wx.getClipboardData(object)
        } else if (this.isJkw) {
            cc.log('host.getClipboardData')
        } else if (this.isAndroid) {
            cc.log('host.getClipboardData')
        }
    }

    // 开放接口-小程序跳转
    navigateToMiniProgram(object) {
        if (this.isWechat) {
            return wx.navigateToMiniProgram(object)
        } else if (this.isJkw) {
            cc.log('host.navigateToMiniProgram')
        } else if (this.isAndroid) {
            cc.log('host.navigateToMiniProgram')
        }
    }

    // 开放接口-用户信息
    getUserInfo(object) {
        if (this.isWechat) {
            return wx.getUserInfo(object)
        } else if (this.isJkw) {
            cc.log('host.getUserInfo')
            if (CC_PREVIEW || CC_BUILD) {
                return loadRuntime().getUserInfo(object)
            }
        } else if (this.isAndroid) {
            cc.log('host.getUserInfo')
        }
    }

    getUserGameLabel(object) {
        if (this.isWechat) {
            return wx.getUserGameLabel(object)
        } else if (this.isJkw) {
            cc.log('host.getUserGameLabel')
        } else if (this.isAndroid) {
            cc.log('host.getUserGameLabel')
        }
    }

    createUserInfoButton(object) {
        if (this.isWechat) {
            return wx.createUserInfoButton(object)
        } else if (this.isJkw) {
            cc.log('host.createUserInfoButton')
            return {
                destory: () => { },
                hide: () => { },
                offTap: (callback) => { },
                onTap: (callback) => { },
                show: () => { },
            }
        } else if (this.isAndroid) {
            cc.log('host.createUserInfoButton')
            return {
                destory: () => { },
                hide: () => { },
                offTap: (callback) => { },
                onTap: (callback) => { },
                show: () => { },
            }
        }
    }

    // 开放接口-登陆
    login(object) {
        if (this.isWechat) {
            return wx.login(object)
        } else if (this.isJkw) {
            cc.log('host.login')
            return object.success({
                code: '123'
            })
        } else if (this.isAndroid) {
            cc.log('host.login')
            return object.success({
                code: '123'
            })
        }
    }

    checkSession(object) {
        if (this.isWechat) {
            return wx.checkSession(object)
        } else if (this.isJkw) {
            cc.log('host.checkSession')
        } else if (this.isAndroid) {
            cc.log('host.checkSession')
        }
    }

    // 开放接口-授权
    authorize(object) {
        if (this.isWechat) {
            return wx.authorize(object)
        } else if (this.isJkw) {
            cc.log('host.authorize')
            if (CC_PREVIEW || CC_BUILD) {
                return loadRuntime().authorize(object)
            }
        } else if (this.isAndroid) {
            cc.log('host.authorize')
        }
    }

    // 开放接口-开放数据域
    onMessage(callback) {
        if (this.isWechat) {
            return wx.onMessage(callback)
        } else if (this.isJkw) {
            cc.log('host.onMessage')
        } else if (this.isAndroid) {
            cc.log('host.onMessage')
        }
    }

    getOpenDataContext() {
        if (this.isWechat) {
            return wx.getOpenDataContext()
        } else if (this.isJkw) {
            cc.log('host.getOpenDataContext')
            return {
                postMessage: (message) => { }
            }
        } else if (this.isAndroid) {
            cc.log('host.getOpenDataContext')
            return {
                postMessage: (message) => { }
            }
        }
    }

    shareMessageToFriend(object) {
        if (this.isWechat) {
            return wx.shareMessageToFriend(object)
        } else if (this.isJkw) {
            cc.log('host.shareMessageToFriend')
        } else if (this.isAndroid) {
            cc.log('host.shareMessageToFriend')
        }
    }
    shareAppMessage(object) {
        if (this.isWechat) {
            return wx.shareAppMessage(object)
        } else if (this.isJkw) {
            cc.log('host.shareAppMessage')
        } else if (this.isAndroid) {
            cc.log('host.shareAppMessage')
        }
    }

    setUserCloudStorage(object) {
        if (this.isWechat) {
            return wx.setUserCloudStorage(object)
        } else if (this.isJkw) {
            cc.log('host.setUserCloudStorage')
        } else if (this.isAndroid) {
            cc.log('host.setUserCloudStorage')
        }
    }

    setMessageToFriendQuery(object) {
        if (this.isWechat) {
            return wx.setMessageToFriendQuery(object)
        } else if (this.isJkw) {
            cc.log('host.setMessageToFriendQuery')
        } else if (this.isAndroid) {
            cc.log('host.setMessageToFriendQuery')
        }
    }

    onShareMessageToFriend(object) {
        if (this.isWechat) {
            return wx.onShareMessageToFriend(object)
        } else if (this.isJkw) {
            cc.log('host.onShareMessageToFriend')
        } else if (this.isAndroid) {
            cc.log('host.onShareMessageToFriend')
        }
    }


    removeUserCloudStorage(object) {
        if (this.isWechat) {
            return wx.removeUserCloudStorage(object)
        } else if (this.isJkw) {
            cc.log('host.removeUserCloudStorage')
        } else if (this.isAndroid) {
            cc.log('host.removeUserCloudStorage')
        }
    }

    onInteractiveStorageModified(callback) {
        if (this.isWechat) {
            return wx.onInteractiveStorageModified(callback)
        } else if (this.isJkw) {
            cc.log('host.onInteractiveStorageModified')
        } else if (this.isAndroid) {
            cc.log('host.onInteractiveStorageModified')
        }
    }

    modifyFriendInteractiveStorage(object) {
        if (this.isWechat) {
            return wx.modifyFriendInteractiveStorage(object)
        } else if (this.isJkw) {
            cc.log('host.modifyFriendInteractiveStorage')
        } else if (this.isAndroid) {
            cc.log('host.modifyFriendInteractiveStorage')
        }
    }

    getUserInteractiveStorage(object) {
        if (this.isWechat) {
            return wx.getUserInteractiveStorage(object)
        } else if (this.isJkw) {
            cc.log('host.getUserInteractiveStorage')
        } else if (this.isAndroid) {
            cc.log('host.getUserInteractiveStorage')
        }
    }

    getUserCloudStorage(object) {
        if (this.isWechat) {
            return wx.getUserCloudStorage(object)
        } else if (this.isJkw) {
            cc.log('host.getUserCloudStorage')
        } else if (this.isAndroid) {
            cc.log('host.getUserCloudStorage')
        }
    }

    getSharedCanvas() {
        if (this.isWechat) {
            return wx.getSharedCanvas()
        } else if (this.isJkw) {
            cc.log('host.getSharedCanvas')
        } else if (this.isAndroid) {
            cc.log('host.getSharedCanvas')
        }
    }

    getPotentialFriendList(object) {
        if (this.isWechat) {
            return wx.getPotentialFriendList(object)
        } else if (this.isJkw) {
            cc.log('host.getPotentialFriendList')
        } else if (this.isAndroid) {
            cc.log('host.getPotentialFriendList')
        }
    }

    getGroupCloudStorage(object) {
        if (this.isWechat) {
            return wx.getGroupCloudStorage(object)
        } else if (this.isJkw) {
            cc.log('host.getGroupCloudStorage')
        } else if (this.isAndroid) {
            cc.log('host.getGroupCloudStorage')
        }
    }

    getFriendCloudStorage(object) {
        if (this.isWechat) {
            return wx.getFriendCloudStorage(object)
        } else if (this.isJkw) {
            cc.log('host.getFriendCloudStorage')
        } else if (this.isAndroid) {
            cc.log('host.getFriendCloudStorage')
        }
    }

    // 开放接口-设置
    openSetting(object) {
        if (this.isWechat) {
            return wx.openSetting(object)
        } else if (this.isJkw) {
            cc.log('host.openSetting')
            if (CC_PREVIEW || CC_BUILD) {
                return loadRuntime().openSetting(object)
            }
        } else if (this.isAndroid) {
            cc.log('host.openSetting')
        }
    }

    getSetting(object) {
        if (this.isWechat) {
            return wx.getSetting(object)
        } else if (this.isJkw) {
            cc.log('host.getSetting')
            if (CC_PREVIEW || CC_BUILD) {
                return loadRuntime().getSetting(object)
            }
        } else if (this.isAndroid) {
            cc.log('host.getSetting')
        }
    }

    createOpenSettingButton(object) {
        if (this.isWechat) {
            return wx.createOpenSettingButton(object)
        } else if (this.isJkw) {
            cc.log('host.createOpenSettingButton')
        } else if (this.isAndroid) {
            cc.log('host.createOpenSettingButton')
        }
    }

    // 开放接口-客服消息
    openCustomerServiceConversation(object) {
        if (this.isWechat) {
            return wx.openCustomerServiceConversation(object)
        } else if (this.isJkw) {
            cc.log('host.openCustomerServiceConversation')
        } else if (this.isAndroid) {
            cc.log('host.openCustomerServiceConversation')
        }
    }

    // 开放组件-游戏圈
    createGameClubButton(object) {
        if (this.isWechat) {
            return wx.createGameClubButton(object)
        } else if (this.isJkw) {
            cc.log('host.createGameClubButton')
            return {
                destroy: () => { },
                hide: () => { },
                offTap: (callback) => { },
                onTap: (callback) => { },
                show: () => { },
            }
        } else if (this.isAndroid) {
            cc.log('host.createGameClubButton')
            return {
                destroy: () => { },
                hide: () => { },
                offTap: (callback) => { },
                onTap: (callback) => { },
                show: () => { },
            }
        }
    }

    // 推荐组件
    createGamePortal(object) {
        if (this.isWechat) {
            return wx.createGamePortal(object)
        } else if (this.isJkw) {
            cc.log('host.createGamePortal')
            return {
                destroy: () => { },
                load: () => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
            }
        } else if (this.isAndroid) {
            cc.log('host.createGamePortal')
            return {
                destroy: () => { },
                load: () => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
            }
        }
    }

    createGameIcon(object) {
        if (this.isWechat) {
            return wx.createGameIcon(object)
        } else if (this.isJkw) {
            cc.log('host.createGameIcon')
            return {
                destroy: () => { },
                load: () => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
            }
        } else if (this.isAndroid) {
            cc.log('host.createGameIcon')
            return {
                destroy: () => { },
                load: () => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
            }
        }
    }

    createGameBanner(object) {
        if (this.isWechat) {
            return wx.createGameBanner(object)
        } else if (this.isJkw) {
            cc.log('host.createGameBanner')
            return {
                destroy: () => { },
                load: () => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
                hide: () => { },
            }
        } else if (this.isAndroid) {
            cc.log('host.createGameBanner')
            return {
                destroy: () => { },
                load: () => { },
                offError: (callback) => { },
                offLoad: (callback) => { },
                offResize: (callback) => { },
                onError: (callback) => { },
                onLoad: (callback) => { },
                onResize: (callback) => { },
                show: () => { },
                hide: () => { },
            }
        }
    }

    // 媒体-音频
    createInnerAudioContext() {
        if (this.isWechat) {
            return wx.createInnerAudioContext()
        } else if (this.isJkw) {
            cc.log('host.createInnerAudioContext')
        } else if (this.isAndroid) {
            cc.log('host.createInnerAudioContext')
        }
    }

    // 非官方-版本号比较
    compareVersion(v1, v2) {
        v1 = v1.split('.')
        v2 = v2.split('.')
        const len = Math.max(v1.length, v2.length)
        while (v1.length < len) {
            v1.push('0')
        }
        while (v2.length < len) {
            v2.push('0')
        }
        for (let i = 0; i < len; i++) {
            const num1 = parseInt(v1[i])
            const num2 = parseInt(v2[i])
            if (num1 > num2) {
                return 1
            } else if (num1 < num2) {
                return -1
            }
        }
        return 0
    }

    /**
     * 判断微信版本号是否和给定值相等
     * @param {String} version 版本号
     * @param {Callback} success 成功回调
     * @param {Callback} fail 失败回调
     */
    veq(version, success = () => { }, fail = () => { }) {
        if (this.isWechat) {
            if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) === 0) {
                return success()
            } else {
                return fail()
            }
        }
    }

    /**
     * 判断微信版本号是否和给定值不等
     * @param {String} version 版本号
     * @param {Callback} success 成功回调
     * @param {Callback} fail 失败回调
     */
    vne(version, success = () => { }, fail = () => { }) {
        if (this.isWechat) {
            if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) !== 0) {
                return success()
            } else {
                return fail()
            }
        }
    }

    /**
     * 判断微信版本号是否大于给定值
     * @param {String} version 版本号
     * @param {Callback} success 成功回调
     * @param {Callback} fail 失败回调
     */
    vgt(version, success = () => { }, fail = () => { }) {
        if (this.isWechat) {
            if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) > 0) {
                return success()
            } else {
                return fail()
            }
        }
    }

    /**
     * 判断微信版本号是否小于于给定值
     * @param {String} version 版本号
     * @param {Callback} success 成功回调
     * @param {Callback} fail 失败回调
     */
    vlt(version, success = () => { }, fail = () => { }) {
        if (this.isWechat) {
            if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) < 0) {
                return success()
            } else {
                return fail()
            }
        }
    }

    /**
     * 判断微信版本号是否大于等于给定值
     * @param {String} version 版本号
     * @param {Callback} success 成功回调
     * @param {Callback} fail 失败回调
     */
    vge(version, success = () => { }, fail = () => { }) {
        if (this.isWechat) {
            if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) >= 0) {
                return success()
            } else {
                return fail()
            }
        }
    }

    /**
     * 判断微信版本号是否小于等于给定值
     * @param {String} version 版本号
     * @param {Callback} success 成功回调
     * @param {Callback} fail 失败回调
     */
    vle(version, success = () => { }, fail = () => { }) {
        if (this.isWechat) {
            if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) <= 0) {
                return success()
            } else {
                return fail()
            }
        }
    }

    vsm() {
        if (cc.sys.platform === cc.sys.WECHAT_GAME) {
            wx.showModal({
                title: '提示',
                content: '当前微信版本过低，无法使用该功能，请升级到最新微信版本后重试。'
            })
        }
    }

    vibrateShort(obj) {
        if (cc.sys.platform === cc.sys.WECHAT_GAME) {
            wx.vibrateShort()
        }
    }

    onShareAppMessage(fn) {
        if (cc.sys.platform === cc.sys.WECHAT_GAME) {
            if (typeof fn === 'function') {
                wx.onShareAppMessage(fn)
            } else {
                wx.onShareAppMessage()
            }
        }
    }

    promiseLoadBundle(nameOrUrl) {
        if (this.isQQ) {
            return new Promise((resolve, reject) => {
                qq.loadSubpackage({
                    name: nameOrUrl,
                    success(res) {
                        resolve()
                    },
                    fail(res) {
                        console.warn(`${nameOrUrl} Rejected!`, res)
                        reject()
                    }
                })
            })
        } else {
            return new Promise((resolve, reject) => {
                cc.assetManager.loadBundle(nameOrUrl, (err, bundle) => {
                    if (err) {
                        reject()
                    }
                    resolve()
                })      
            })
        }
    }
}

export default new Host()
