import host from './Host'
cc.Class({
    extends: cc.Component,

    properties: {
        wxSubContextView: {
            default: null,
            type: cc.Node
        }
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
    },

    init() {

        this.initShareCanvas()
        this.initSubContext()
    },

    initSubContext() {
        //设置定向分享参数（这里假设1代表的是邀请新玩家场景值）
        host.vge('2.9.0', () => {
            host.setMessageToFriendQuery({
                shareMessageToFriendScene: 1
            })
        })

        host.vge('2.9.4', () => {
            host.onShareMessageToFriend(res => {
                let tips = res.success ? '分享成功' : '分享失败'
                host.showToast({
                    title: tips,
                    icon: 'none',
                    duration: 2000
                })
            })
        })

        let openDataContext = host.getOpenDataContext()
        console.log('test')
        openDataContext.postMessage({
            type: 'showInviteUI'
        })
        this.wxSubContextView.active = true

        this.wxSubContextView.getComponent(cc.WXSubContextView).enabled = true
        this.wxSubContextView.getComponent(cc.WXSubContextView).updateSubContextViewport()
    },

    /**
     * 隐藏分享界面
     */
    hideInvite() {
        let openDataContext = host.getOpenDataContext()
        openDataContext.postMessage({
            type: 'hideInviteUI'
        })
        this.wxSubContextView.active = false
        this.wxSubContextView.getComponent(cc.WXSubContextView).enabled = false
        this.wxSubContextView.getComponent(cc.WXSubContextView).updateSubContextViewport()
    },

    start() {},

    getUserInteractiveData() {
        // 获取用户的加密交互数据
        host.vge('2.7.7', () => {
            host.getUserInteractiveStorage({
                keyList: ['2'],
                success: res => {
                    let encryptedData = res.encryptedData
                    let iv = res.iv
                    api.shareToFriend(encryptedData, iv)
                }
            })
        })
    },

    initShareCanvas() {
        let openDataContext = host.getOpenDataContext()
        this.sharedCanvas = openDataContext.canvas

        let { windowWidth, windowHeight} = host.getSystemInfoSync()
        //WxSubContextView节点尺寸
        let width = 750
        let height = 1334

        //画布尺寸
        let canvasWidth = 750
        let canvasHeight = 1334

        let x = 0
        let y = 0

        let realWidth = (width / canvasWidth) * windowWidth
        let realHeight = (height / canvasHeight) * windowHeight

        let realX = (x / canvasWidth) * windowWidth
        let realY = (y / canvasHeight) * windowHeight

        openDataContext.postMessage({
            type: 'updateViewPort',
            box: {
                width: realWidth,
                height: realHeight,
                x: realX,
                y: realY
            }
        })
    },

    /**
     * 带参分享
     */
    inviteWeChatFriend() {
        wx.shareAppMessage({
            title: '点一下，玩一年，装备不花一分钱！',
            imageUrl: '',
            success: function (res) {
                // 转发成功
            },
            fail: function (res) {
                // 转发失败
            }
        })
        this.hideInvite()
    }
})
