(function outer(modules, cache, entry) {
  function newRequire(name, jumped) {
    var module = cache[name];
    if (!module) {
      var moduleData = modules[name];
      if (!moduleData) return;
      var exports = {};
      module = cache[name] = {
        exports: exports
      };
      moduleData[0]((function(x) {
        return newRequire(moduleData[1][x] || x);
      }), module, exports);
    }
    return module.exports;
  }
  for (var i = 0; i < entry.length; i++) newRequire(entry[i]);
  return newRequire;
})({
  1: [ (function(require, module, exports) {
    module.exports = {
      1001: "cocos2d: removeAction: Target not found",
      1002: "cc.ActionManager.removeActionByTag(): an invalid tag",
      1003: "cc.ActionManager.removeActionByTag(): target must be non-null",
      1004: "cc.ActionManager.getActionByTag(): an invalid tag",
      1005: "cocos2d : getActionByTag(tag = %s): Action not found",
      1006: "[Action step]. override me",
      1007: "[Action update]. override me",
      1008: "cocos2d: FiniteTimeAction#reverse: Implement me",
      1009: "cc.EaseElastic.reverse(): it should be overridden in subclass.",
      1010: "cc.IntervalAction: reverse not implemented.",
      1011: "cc.ActionInterval.setAmplitudeRate(): it should be overridden in subclass.",
      1012: "cc.ActionInterval.getAmplitudeRate(): it should be overridden in subclass.",
      1013: "The speed parameter error",
      1014: "The repeat parameter error",
      1015: "parameters should not be ending with null in Javascript",
      1016: "cc.RotateTo.reverse(): it should be overridden in subclass.",
      1019: "Failed to construct, Sequence construction needs two or more actions.",
      1020: "Failed to construct, Spawn construction needs two or more actions.",
      1021: "cc.Speed.initWithAction(): action must be non nil",
      1022: "cc.Follow.initWithAction(): followedNode must be non nil",
      1023: "cc.ActionEase.initWithAction(): action must be non nil",
      1024: "Invalid configuration. It must at least have one control point",
      1025: "cc.Sequence.initWithTwoActions(): arguments must all be non nil",
      1026: "cc.RepeatForever.initWithAction(): action must be non null",
      1027: "cc.Spawn.initWithTwoActions(): arguments must all be non null",
      1028: "cc.ReverseTime.initWithAction(): action must be non null",
      1029: "cc.ReverseTime.initWithAction(): the action was already passed in.",
      1030: "cc.Animate.initWithAnimation(): animation must be non-NULL",
      1031: "Illegal parameter get passed in cc.tween: %s.",
      1100: "Expected 'data' dict, but not found. Config file: %s",
      1101: "Please load the resource first : %s",
      1200: "cocos2d: Director: Error in gettimeofday",
      1201: "cocos2d: Director: unrecognized projection",
      1203: "cocos2d: Director: Error in gettimeofday",
      1204: "running scene should not null",
      1205: "the scene should not null",
      1206: "loadScene: The scene index to load (%s) is out of range.",
      1207: "loadScene: Unknown name type to load: '%s'",
      1208: "loadScene: Failed to load scene '%s' because '%s' is already being loaded.",
      1209: "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      1210: "Failed to preload '%s', %s",
      1211: "loadScene: The scene index to load (%s) is out of range.",
      1212: "loadScene: Unknown name type to load: '%s'",
      1213: "loadScene: Failed to load scene '%s' because '%s' is already loading",
      1214: "loadScene: Can not load the scene '%s' because it was not in the build settings before playing.",
      1215: "Failed to preload '%s', %s",
      1216: "Director.runSceneImmediate: scene is not valid",
      1300: "element type is wrong!",
      1400: "'%s' is deprecated, please use '%s' instead.",
      1404: "cc.spriteFrameCache is removed, please use cc.loader to load and cache sprite frames of atlas format.",
      1405: "The '%s' has been removed, please use '%s' instead.",
      1406: "'%s.%s' is removed",
      1408: "'%s' is not support in the '%s', please use '%s' instead.",
      1502: "cc.scheduler.scheduleCallbackForTarget(): target should be non-null.",
      1503: "cc.Scheduler.pauseTarget():target should be non-null",
      1504: "cc.Scheduler.resumeTarget():target should be non-null",
      1505: "cc.Scheduler.isTargetPaused():target should be non-null",
      1506: "warning: you CANNOT change update priority in scheduled function",
      1507: 'CCScheduler#scheduleSelector. Selector already scheduled. Updating interval from: %s to %s"',
      1508: "Argument callback must not be empty",
      1509: "Argument target must be non-nullptr",
      1510: "cc.Scheduler: Illegal target which doesn't have uuid or instanceId.",
      1511: "cc.Scheduler: pause state of the scheduled task doesn't match the element pause state in Scheduler, the given paused state will be ignored.",
      1513: "cc.Scheduler: scheduler stopped using `__instanceId` as id since v2.0, you should do scheduler.enableForTarget(target) before all scheduler API usage on target",
      1605: "child already added. It can't be added again",
      1606: "child must be non-null",
      1610: "cocos2d: removeChildByTag(tag = %s): child not found!",
      1612: "cc.Node.stopActionBy(): argument tag an invalid tag",
      1613: "cc.Node.getActionByTag(): argument tag is an invalid tag",
      1617: "child must be non-null",
      1618: "cc.Node.runAction(): action must be non-null",
      1619: "callback function must be non-null",
      1620: "interval must be positive",
      1623: "Set '%s' to normal node (not persist root node).",
      1624: "Replacing with the same sgNode",
      1625: "The replacement sgNode should not contain any child.",
      1626: "Should not set alpha via 'color', set 'opacity' please.",
      1627: "Not support for asynchronous creating node in SG",
      1632: "Node name can not include '/'.",
      1633: "Internal error, should not remove unknown node from parent.",
      1634: "addChild: The child to add must be instance of cc.Node, not %s.",
      1635: "reorderChild: this child is not in children list.",
      1636: "Node's zIndex value can't be greater than cc.macro.MAX_ZINDEX, setting to the maximum value",
      1637: "Node's zIndex value can't be smaller than cc.macro.MIN_ZINDEX, setting to the minimum value",
      1638: "Private node's zIndex can't be set, it will keep cc.macro.MIN_ZINDEX as its value",
      1639: "cc.Action is deprecated, please use cc.TweenAction instead",
      1800: "cc._EventListenerKeyboard.checkAvailable(): Invalid EventListenerKeyboard!",
      1801: "cc._EventListenerTouchOneByOne.checkAvailable(): Invalid EventListenerTouchOneByOne!",
      1802: "cc._EventListenerTouchAllAtOnce.checkAvailable(): Invalid EventListenerTouchAllAtOnce!",
      1803: "cc._EventListenerAcceleration.checkAvailable(): _onAccelerationEvent must be non-nil",
      1900: "Invalid parameter.",
      2000: "Don't call this method if the event is for touch.",
      2200: "Design resolution not valid",
      2201: "should set resolutionPolicy",
      2300: "The touches is more than MAX_TOUCHES, nUnusedIndex = %s",
      2400: "WebGL error %s",
      2602: "cc.Sprite.setDisplayFrameWithAnimationName(): Frame not found",
      2603: "cc.Sprite.setDisplayFrameWithAnimationName(): Invalid frame index",
      2606: "cc.Sprite.initWithSpriteFrame(): spriteFrame should be non-null",
      2607: "cc.Sprite.initWithSpriteFrameName(): spriteFrameName should be non-null",
      2608: "%s is null, please check.",
      2609: "cc.Sprite.initWithFile(): filename should be non-null",
      2610: "cc.Sprite.setDisplayFrameWithAnimationName(): animationName must be non-null",
      2614: "cc.Sprite.addChild(): child should be non-null",
      2616: "cc.SpriteBatchNode.updateQuadFromSprite(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2617: "cc.SpriteBatchNode.insertQuadFromSprite(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2618: "cc.SpriteBatchNode.addChild(): cc.SpriteBatchNode only supports cc.Sprites as children",
      2619: "cc.SpriteBatchNode.addChild(): cc.Sprite is not using the same texture",
      2623: "cc.SpriteBatchNode.updateQuadFromSprite(): sprite should be non-null",
      2625: "too many tiles, only 16384 tiles will be show",
      2626: "Unrecognized fill type in bar fill",
      2627: "Can not generate quad",
      2628: "%s does not exist",
      2712: "Invalid spriteFrameName",
      3005: "cocos2d: '%s' id=%s %s x %s",
      3006: "cocos2d: '%s' id= HTMLCanvasElement %s x %s",
      3007: "cocos2d: TextureCache dumpDebugInfo: %s textures, HTMLCanvasElement for %s KB (%s MB)",
      3103: "cc.Texture.addImage(): path should be non-null",
      3112: "cc.Texture.addImage(): path should be non-null",
      3113: "NSInternalInconsistencyException",
      3116: "WebGLRenderingContext.CLAMP_TO_EDGE should be used in NPOT textures",
      3117: "Mimpap texture only works in POT textures",
      3119: "Lazy init texture with image element failed due to image loading failure: %s",
      3120: "Loading texture from '%s' with unsupported type: '%s'. Add '%s' into 'cc.macro.SUPPORT_TEXTURE_FORMATS' please.",
      3300: "Rect width exceeds maximum margin: %s",
      3400: "Rect height exceeds maximum margin: %s",
      3401: "Set texture with a url of image is not supported anymore. Please use cc.assetManager.loadRemote to load a texture first.",
      3500: "0 priority is forbidden for fixed priority since it's used for scene graph based priority.",
      3501: "Invalid listener type!",
      3502: "Can't set fixed priority with scene graph based listener.",
      3503: "Invalid parameters.",
      3504: "listener must be a cc.EventListener object when adding a fixed priority listener",
      3505: "The listener has been registered, please don't register it again.",
      3506: "Unsupported listener target.",
      3507: "Invalid scene graph priority!",
      3508: "If program goes here, there should be event in dispatch.",
      3509: "_inDispatch should be 1 here.",
      3510: "%s's scene graph node not contains in the parent's children",
      3511: "event is undefined",
      3600: "cc.Class will automatically call super constructor of %s, you should not call it manually.",
      3601: "The editor property 'playOnFocus' should be used with 'executeInEditMode' in class '%s'",
      3602: "Unknown editor property '%s' in class '%s'.",
      3603: "Use 'cc.Float' or 'cc.Integer' instead of 'cc.Number' please.",
      3604: "Can only indicate one type attribute for %s.",
      3605: "The default value of %s is not instance of %s.",
      3606: "No needs to indicate the '%s' attribute for %s, which its default value is type of %s.",
      3607: "The default value of %s must be an empty string.",
      3608: "The type of %s must be cc.String, not String.",
      3609: "The type of %s must be cc.Boolean, not Boolean.",
      3610: "The type of %s must be cc.Float or cc.Integer, not Number.",
      3611: "Can not indicate the '%s' attribute for %s, which its default value is type of %s.",
      3612: "%s Just set the default value to 'new %s()' and it will be handled properly.",
      3613: "'No need to use 'serializable: false' or 'editorOnly: true' for the getter of '%s.%s', every getter is actually non-serialized.",
      3614: "Should not define constructor for cc.Component %s.",
      3615: "Each script can have at most one Component.",
      3616: "Should not specify class name %s for Component which defines in project.",
      3617: "Can not instantiate CCClass '%s' with arguments.",
      3618: "ctor of '%s' can not be another CCClass",
      3619: "ctor of '%s' must be function type",
      3620: "this._super declared in '%s.%s' but no super method defined",
      3621: "Unknown type of %s.%s, maybe you want is '%s'.",
      3622: "Unknown type of %s.%s, property should be defined in 'properties' or 'ctor'",
      3623: "Can not use 'editor' attribute, '%s' not inherits from Components.",
      3624: "'%s' overrided '%s' but '%s' is defined as 'false' so the super method will not be called. You can set '%s' to null to disable this warning.",
      3625: "[isChildClassOf] superclass should be function type, not",
      3626: "Can't remove '%s' because '%s' depends on it.",
      3627: "Should not add renderer component (%s) to a Canvas node.",
      3628: "Should not add %s to a node which size is already used by its other component.",
      3633: "Properties function of '%s' should return an object!",
      3634: "Disallow to use '.' in property name",
      3635: "Default array must be empty, set default value of %s.%s to [], and initialize in 'onLoad' or 'ctor' please. (just like 'this.%s = [...];')",
      3636: "Do not set default value to non-empty object, unless the object defines its own 'clone' function. Set default value of %s.%s to null or {}, and initialize in 'onLoad' or 'ctor' please. (just like 'this.%s = {foo: bar};')",
      3637: "Can not declare %s.%s, it is already defined in the prototype of %s",
      3638: "'%s': the getter of '%s' is already defined!",
      3639: "Can not apply the specified attribute to the getter of '%s.%s', attribute index: %s",
      3640: "'%s': the setter of '%s' is already defined!",
      3641: "Can not construct %s because it contains object property.",
      3642: "Cannot define %s.%s because static member name can not be '%s'.",
      3643: "Can not define a member called 'constructor' in the class '%s', please use 'ctor' instead.",
      3644: "Please define 'type' parameter of %s.%s as the actual constructor.",
      3645: "Please define 'type' parameter of %s.%s as the constructor of %s.",
      3646: "Unknown 'type' parameter of %s.%s\uff1a%s",
      3647: "The length of range array must be equal or greater than 2",
      3648: "Can not declare %s.%s method, it is already defined in the properties of %s.",
      3649: "CCClass %s have conflict between its ctor and __ctor__.",
      3651: 'Can not call `_super` or `prototype.ctor` in ES6 Classes "%s", use `super` instead please.',
      3652: "Failed to `new %s()` under the hood, %s\nIt is used for getting default values declared in TypeScript in the first place.\nPlease ensure the constructor can be called during the script's initialization.",
      3653: 'Please do not specifiy "default" attribute in decorator of "%s" property in "%s" class.  \nDefault value must be initialized at their declaration:\n \n// Before:\n@property({\n  type: cc.Integer\n  default: 0  // <--\n})\nmyProp;\n// After:\n@property({\n  type: cc.Integer\n})\nmyProp = 0;   // <--',
      3654: 'Please specifiy a default value for "%s.%s" at its declaration:\n \n// Before:\n@property(...)\nmyProp;\n// After:\n@property(...)\nmyProp = 0;',
      3655: 'Can not specifiy "get" or "set"  attribute in decorator for "%s" property in "%s" class.  \nPlease use:\n \n@property(...)\nget %s () {\n    ...\n}\n@property\nset %s (value) {\n    ...\n}',
      3700: "internal error: _prefab is undefined",
      3701: "Failed to load prefab asset for node '%s'",
      3800: "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      3801: "The node can not be made persist because it's not under root node.",
      3802: "The node can not be made persist because it's not in current scene.",
      3803: "The target can not be made persist because it's not a cc.Node or it doesn't have _id property.",
      3804: "getComponent: Type must be non-nil",
      3805: "Can't add component '%s' because %s already contains the same component.",
      3806: "Can't add component '%s' to %s because it conflicts with the existing '%s' derived component.",
      3807: "addComponent: Failed to get class '%s'",
      3808: "addComponent: Should not add component ('%s') when the scripts are still loading.",
      3809: "addComponent: The component to add must be a constructor",
      3810: "addComponent: The component to add must be child class of cc.Component",
      3811: "_addComponentAt: The component to add must be a constructor",
      3812: "_addComponentAt: Index out of range",
      3813: "removeComponent: Component must be non-nil",
      3814: "Argument must be non-nil",
      3815: "Component not owned by this entity",
      3816: "Node '%s' is already activating",
      3817: "Sorry, the component of '%s' which with an index of %s is corrupted! It has been removed.",
      3818: "Failed to read or parse project.json",
      3819: "Warning: target element is not a DIV or CANVAS",
      3820: "The renderer doesn't support the renderMode %s",
      3821: "Cannot change hierarchy while activating or deactivating the parent.",
      3900: "Invalid clip to add",
      3901: "Invalid clip to remove",
      3902: "clip is defaultClip, set force to true to force remove clip and animation state",
      3903: "animation state is playing, set force to true to force stop and remove clip and animation state",
      3904: "motion path of target [%s] in prop [%s] frame [%s] is not valid",
      3905: "sprite frames must be an Array.",
      3906: "Can't find easing type [%s]",
      3907: "animator not added or already removed",
      3912: "already-playing",
      4003: "Label font size can't be shirnked less than 0!",
      4004: "force notify all fonts loaded!",
      4011: "Property spriteFrame of Font '%s' is invalid. Using system font instead.",
      4012: "The texture of Font '%s' must be already loaded on JSB. Using system font instead.",
      4013: "Sorry, lineHeight of system font not supported on JSB.",
      4200: "MaskType: IMAGE_STENCIL only support WebGL mode.",
      4201: "The alphaThreshold invalid in Canvas Mode.",
      4202: "The inverted invalid in Canvas Mode.",
      4300: "can not found the %s page.",
      4400: "Invalid RichText img tag! The sprite frame name can't be found in the ImageAtlas!",
      4600: "Script attached to '%s' is missing or invalid.",
      4700: "The dom control is not created!",
      4800: "unknown asset type",
      4901: "loadRes: should not specify the extname in %s %s",
      4902: "No need to release non-cached asset.",
      4903: "Can not get class '%s'",
      4914: "Resources url '%s' does not exist.",
      4915: "Pack indices and data do not match in size",
      4916: "Failed to download package for %s",
      4921: "Invalid pipe or invalid index provided!",
      4922: "The pipe to be inserted is already in the pipeline!",
      4923: "Uuid Loader: Parse asset [ %s ] failed : %s",
      4924: "JSON Loader: Input item doesn't contain string content",
      4925: "Uuid Loader: Deserialize asset [ %s ] failed : %s",
      4926: "Audio Downloader: no web audio context.",
      4927: "Audio Downloader: audio not supported on this browser!",
      4928: "Load %s failed!",
      4929: "Load Webp ( %s ) failed",
      4930: "Load image ( %s ) failed",
      4932: 'Since v1.10, for any atlas ("%s") in the "resources" directory, it is not possible to find the contained SpriteFrames via `loadRes`, `getRes` or `releaseRes`. Load the SpriteAtlas first and then use `spriteAtlas.getSpriteFrame(name)` instead please.',
      4933: "Download Font [ %s ] failed, using Arial or system default font instead",
      5000: "object already destroyed",
      5001: "object not yet destroyed",
      5100: "Not a plist file!",
      5200: "Warning: localStorage isn't enabled. Please confirm browser cookie or privacy option",
      5201: "browser don't support web audio",
      5202: "This feature supports WebGL render mode only.",
      5300: "Type of target to deserialize not matched with data: target is %s, data is %s",
      5301: "Can not find script '%s'",
      5302: "Can not find class '%s'",
      5402: "cc.js.addon called on non-object:",
      5403: "cc.js.mixin: arguments must be type object:",
      5404: "The base class to extend from must be non-nil",
      5405: "The class to extend must be non-nil",
      5406: "Class should be extended before assigning any prototype members.",
      5500: "'notify' can not be used in 'get/set' !",
      5501: "'notify' must be used with 'default' !",
      5507: "The 'default' attribute of '%s.%s' must be an array",
      5508: "Invalid type of %s.%s",
      5510: "The 'type' attribute of '%s.%s' can not be 'Number', use cc.Float or cc.Integer instead please.",
      5511: "The 'type' attribute of '%s.%s' is undefined when loading script",
      5512: "Can not serialize '%s.%s' because the specified type is anonymous, please provide a class name or set the 'serializable' attribute of '%s.%s' to 'false'.",
      5513: "The 'default' value of '%s.%s' should not be used with a 'get' function.",
      5514: "The 'default' value of '%s.%s' should not be used with a 'set' function.",
      5515: "The 'default' value of '%s.%s' can not be an constructor. Set default to null please.",
      5516: "Property '%s.%s' must define at least one of 'default', 'get' or 'set'.",
      5517: "'%s.%s' hides inherited property '%s.%s'. To make the current property override that implementation, add the `override: true` attribute please.",
      5601: "Can not get current scene.",
      5602: "Scene is destroyed",
      5603: "reference node is destroyed",
      5700: "no %s or %s on %s",
      5800: "%s.lerp not yet implemented.",
      5801: "%s.clone not yet implemented.",
      5802: "%s.equals not yet implemented.",
      5900: "MotionStreak only support WebGL mode.",
      5901: "cc.MotionStreak.getOpacity has not been supported.",
      5902: "cc.MotionStreak.setOpacity has not been supported.",
      6000: "Custom should not be false if file is not specified.",
      6001: "The new %s must not be NaN",
      6017: "Incomplete or corrupt PNG file",
      6018: "Invalid filter algorithm: %s",
      6019: "Invalid byte order value.",
      6020: "You forgot your towel!",
      6021: "Unknown Field Tag: %s",
      6022: "Too many bits requested",
      6023: "No bits requested",
      6024: "Cannot recover from missing StripByteCounts",
      6025: "Cannot handle sub-byte bits per sample",
      6026: "Cannot handle sub-byte bits per pixel",
      6027: "Palette image missing color map",
      6028: "Unknown Photometric Interpretation: %s",
      6029: "Unkown error",
      6030: "cc.ParticleSystem: error decoding or ungzipping textureImageData",
      6031: "cc.ParticleSystem: unknown image format with Data",
      6032: "cc.ParticleSystem.initWithDictionary() : error loading the texture",
      6400: "asset.url is not usable in core process",
      6402: "AssetLibrary has already been initialized!",
      6500: "Widget target must be one of the parent nodes of it",
      6600: "collider not added or already removed",
      6601: "Can't find testFunc for (%s, $s).",
      6700: "Can't init canvas '%s' because it conflicts with the existing '%s', the scene should only have one active canvas at the same time.",
      6800: "Callback of event must be non-nil",
      6801: "The message must be provided",
      6900: "The thing you want to instantiate must be an object",
      6901: "The thing you want to instantiate is nil",
      6902: "The thing you want to instantiate is destroyed",
      6903: "The instantiate method for given asset do not implemented",
      6904: "Can not instantiate array",
      6905: "Can not instantiate DOM element",
      7100: "%s already defined in Enum.",
      7101: "Sorry, 'cc.Enum' not available on this platform, please report this error here: https://github.com/cocos-creator/engine/issues/new",
      7200: "Method 'initWithTMXFile' is no effect now, please set property 'tmxAsset' instead.",
      7201: "Method 'initWithXML' is no effect now, please set property 'tmxAsset' instead.",
      7202: "Add component TiledLayer into node failed.",
      7203: "Property 'mapLoaded' is unused now. Please write the logic to the callback 'start'.",
      7210: "TMX Hexa zOrder not supported",
      7211: "TMX invalid value",
      7215: "cocos2d: Warning: TMX Layer %s has no tiles",
      7216: "cocos2d: TMXFormat: Unsupported TMX version: %s",
      7217: "cocos2d: TMXFomat: Unsupported orientation: %s",
      7218: "cc.TMXMapInfo.parseXMLFile(): unsupported compression method",
      7219: "cc.TMXMapInfo.parseXMLFile(): Only base64 and/or gzip/zlib maps are supported",
      7221: "cc.TMXMapInfo.parseXMLFile(): Texture '%s' not found.",
      7222: "Parse %s failed.",
      7236: "cc.TMXLayer.getTileAt(): TMXLayer: the tiles map has been released",
      7237: "cc.TMXLayer.getTileGIDAt(): TMXLayer: the tiles map has been released",
      7238: "cc.TMXLayer.setTileGID(): TMXLayer: the tiles map has been released",
      7239: "cc.TMXLayer.setTileGID(): invalid gid: %s",
      7240: "cc.TMXLayer.getTileFlagsAt(): TMXLayer: the tiles map has been released",
      7241: "cc.TiledMap.initWithXML(): Map not found. Please check the filename.",
      7401: "Failed to set _defaultArmatureIndex for '%s' because the index is out of range.",
      7402: "Failed to set _animationIndex for '%s' because the index is out of range.",
      7501: "Failed to set _defaultSkinIndex for '%s' because the index is out of range.",
      7502: "Failed to set _animationIndex for '%s' because its skeletonData is invalid.",
      7503: "Failed to set _animationIndex for '%s' because the index is out of range.",
      7504: "Can not render dynamic created SkeletonData",
      7506: "Failed to load spine atlas '$s'",
      7507: "Please re-import '%s' because its textures is not initialized! (This workflow will be improved in the future.)",
      7508: "The atlas asset of '%s' is not exists!",
      7509: "Spine: Animation not found: %s",
      7510: "Spine: Animation not found: %s",
      7600: "The context of RenderTexture is invalid.",
      7601: "cc.RenderTexture._initWithWidthAndHeightForWebGL() : only RGB and RGBA formats are valid for a render texture;",
      7602: "Could not attach texture to the framebuffer",
      7603: "clearDepth isn't supported on Cocos2d-Html5",
      7604: "saveToFile isn't supported on Cocos2d-Html5",
      7605: "newCCImage isn't supported on Cocos2d-Html5",
      7700: "On the web is always keep the aspect ratio",
      7701: "Can't know status",
      7702: "Video player's duration is not ready to get now!",
      7800: "Web does not support loading",
      7801: "Web does not support query history",
      7802: "Web does not support query history",
      7803: "The current browser does not support the GoBack",
      7804: "The current browser does not support the GoForward",
      7805: "Web does not support zoom",
      7900: "cc.math.Matrix3.assign(): current matrix equals matIn",
      7901: "cc.math.mat4Assign(): pOut equals pIn",
      7902: "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      7903: "cc.math.Matrix4 equal: pMat1 and pMat2 are same object.",
      7904: "cc.math.Matrix4.extractPlane: Invalid plane index",
      7905: "cc.math.mat4Assign(): pOut equals pIn",
      7906: "cc.mat.Matrix4.assignFrom(): mat4 equals current matrix",
      7907: "cc.math.Matrix4 equals: pMat1 and pMat2 are same object.",
      7908: "Invalid matrix mode specified",
      7909: "current quaternion is an invalid value",
      8000: "Can't handle this field type or size",
      8001: "No bytes requested",
      8002: "Too many bytes requested",
      8003: "Missing StripByteCounts!",
      8103: "cc.GLProgram.link(): Cannot link invalid program",
      8104: "cocos2d: ERROR: Failed to link program: %s",
      8105: "cocos2d: cc.shaderCache._loadDefaultShader, error shader type",
      8106: "Please load the resource firset : %s",
      8107: "cc.GLProgram.getUniformLocationForName(): uniform name should be non-null",
      8108: "cc.GLProgram.getUniformLocationForName(): Invalid operation. Cannot get uniform location when program is not initialized",
      8109: "modelView matrix is undefined.",
      8200: "Please set node's active instead of rigidbody's enabled.",
      8300: "Should only one camera exists, please check your project.",
      8301: "Camera does not support Canvas Mode.",
      8400: "Wrong type arguments, 'filePath' must be a String.",
      8401: "Since 1.10, `%s` accept %s instance directly, not a URL string. Please directly reference the %s object in your script, or load %s by loader first. Don't use %s's URL anymore.",
      9000: "Stencil manager does not support level bigger than %d in this device.",
      9001: "Stencil manager is already empty, cannot pop any mask.",
      9100: "LabelAtlas '%s' cannot be loaded, raw texture does not exist.",
      9101: "LabelAtlas '%s' cannot be loaded, fnt data does not exist.",
      9102: "Program not support highp precision, will change to mediump.",
      9103: "%s : Failed to set property [%s], property not found.",
      9104: "%s : Failed to define [%s], define not found.",
      9105: "%s : Failed to set property [%s], property length not correct.",
      9106: "%s : Set property [%s] warning : should transform object to ArrayBuffer.",
      9107: "%s : illegal property: [%s], myabe defined an unused property;",
      9200: "cc.view.enableAntiAlias is deprecated, please use cc.Texture2D.setFilters instead",
      "0100": "%s not yet implemented."
    };
  }), {} ],
  2: [ (function(require, module, exports) {
    "use strict";
    require("../core/platform/CCClass");
    var misc = require("../core/utils/misc");
    cc.Action = cc.Class({
      name: "cc.Action",
      ctor: function ctor() {
        this.originalTarget = null;
        this.target = null;
        this.tag = cc.Action.TAG_INVALID;
      },
      clone: function clone() {
        var action = new cc.Action();
        action.originalTarget = null;
        action.target = null;
        action.tag = this.tag;
        return action;
      },
      isDone: function isDone() {
        return true;
      },
      startWithTarget: function startWithTarget(target) {
        this.originalTarget = target;
        this.target = target;
      },
      stop: function stop() {
        this.target = null;
      },
      step: function step(dt) {
        cc.logID(1006);
      },
      update: function update(dt) {
        cc.logID(1007);
      },
      getTarget: function getTarget() {
        return this.target;
      },
      setTarget: function setTarget(target) {
        this.target = target;
      },
      getOriginalTarget: function getOriginalTarget() {
        return this.originalTarget;
      },
      setOriginalTarget: function setOriginalTarget(originalTarget) {
        this.originalTarget = originalTarget;
      },
      getTag: function getTag() {
        return this.tag;
      },
      setTag: function setTag(tag) {
        this.tag = tag;
      },
      retain: function retain() {},
      release: function release() {}
    });
    cc.Action.TAG_INVALID = -1;
    cc.FiniteTimeAction = cc.Class({
      name: "cc.FiniteTimeAction",
      extends: cc.Action,
      ctor: function ctor() {
        this._duration = 0;
      },
      getDuration: function getDuration() {
        return this._duration * (this._timesForRepeat || 1);
      },
      setDuration: function setDuration(duration) {
        this._duration = duration;
      },
      reverse: function reverse() {
        cc.logID(1008);
        return null;
      },
      clone: function clone() {
        return new cc.FiniteTimeAction();
      }
    });
    cc.Speed = cc.Class({
      name: "cc.Speed",
      extends: cc.Action,
      ctor: function ctor(action, speed) {
        this._speed = 0;
        this._innerAction = null;
        action && this.initWithAction(action, speed);
      },
      getSpeed: function getSpeed() {
        return this._speed;
      },
      setSpeed: function setSpeed(speed) {
        this._speed = speed;
      },
      initWithAction: function initWithAction(action, speed) {
        if (!action) {
          cc.errorID(1021);
          return false;
        }
        this._innerAction = action;
        this._speed = speed;
        return true;
      },
      clone: function clone() {
        var action = new cc.Speed();
        action.initWithAction(this._innerAction.clone(), this._speed);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.Action.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      stop: function stop() {
        this._innerAction.stop();
        cc.Action.prototype.stop.call(this);
      },
      step: function step(dt) {
        this._innerAction.step(dt * this._speed);
      },
      isDone: function isDone() {
        return this._innerAction.isDone();
      },
      reverse: function reverse() {
        return new cc.Speed(this._innerAction.reverse(), this._speed);
      },
      setInnerAction: function setInnerAction(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function getInnerAction() {
        return this._innerAction;
      }
    });
    cc.speed = function(action, speed) {
      return new cc.Speed(action, speed);
    };
    cc.Follow = cc.Class({
      name: "cc.Follow",
      extends: cc.Action,
      ctor: function ctor(followedNode, rect) {
        this._followedNode = null;
        this._boundarySet = false;
        this._boundaryFullyCovered = false;
        this._halfScreenSize = null;
        this._fullScreenSize = null;
        this.leftBoundary = 0;
        this.rightBoundary = 0;
        this.topBoundary = 0;
        this.bottomBoundary = 0;
        this._worldRect = cc.rect(0, 0, 0, 0);
        followedNode && (rect ? this.initWithTarget(followedNode, rect) : this.initWithTarget(followedNode));
      },
      clone: function clone() {
        var action = new cc.Follow();
        var locRect = this._worldRect;
        var rect = new cc.Rect(locRect.x, locRect.y, locRect.width, locRect.height);
        action.initWithTarget(this._followedNode, rect);
        return action;
      },
      isBoundarySet: function isBoundarySet() {
        return this._boundarySet;
      },
      setBoudarySet: function setBoudarySet(value) {
        this._boundarySet = value;
      },
      initWithTarget: function initWithTarget(followedNode, rect) {
        if (!followedNode) {
          cc.errorID(1022);
          return false;
        }
        var _this = this;
        rect = rect || cc.rect(0, 0, 0, 0);
        _this._followedNode = followedNode;
        _this._worldRect = rect;
        _this._boundarySet = !(0 === rect.width && 0 === rect.height);
        _this._boundaryFullyCovered = false;
        var winSize = cc.winSize;
        _this._fullScreenSize = cc.v2(winSize.width, winSize.height);
        _this._halfScreenSize = _this._fullScreenSize.mul(.5);
        if (_this._boundarySet) {
          _this.leftBoundary = -(rect.x + rect.width - _this._fullScreenSize.x);
          _this.rightBoundary = -rect.x;
          _this.topBoundary = -rect.y;
          _this.bottomBoundary = -(rect.y + rect.height - _this._fullScreenSize.y);
          _this.rightBoundary < _this.leftBoundary && (_this.rightBoundary = _this.leftBoundary = (_this.leftBoundary + _this.rightBoundary) / 2);
          _this.topBoundary < _this.bottomBoundary && (_this.topBoundary = _this.bottomBoundary = (_this.topBoundary + _this.bottomBoundary) / 2);
          _this.topBoundary === _this.bottomBoundary && _this.leftBoundary === _this.rightBoundary && (_this._boundaryFullyCovered = true);
        }
        return true;
      },
      step: function step(dt) {
        var targetWorldPos = this.target.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var followedWorldPos = this._followedNode.convertToWorldSpaceAR(cc.Vec2.ZERO);
        var delta = targetWorldPos.sub(followedWorldPos);
        var tempPos = this.target.parent.convertToNodeSpaceAR(delta.add(this._halfScreenSize));
        if (this._boundarySet) {
          if (this._boundaryFullyCovered) return;
          this.target.setPosition(misc.clampf(tempPos.x, this.leftBoundary, this.rightBoundary), misc.clampf(tempPos.y, this.bottomBoundary, this.topBoundary));
        } else this.target.setPosition(tempPos.x, tempPos.y);
      },
      isDone: function isDone() {
        return !this._followedNode.activeInHierarchy;
      },
      stop: function stop() {
        this.target = null;
        cc.Action.prototype.stop.call(this);
      }
    });
    cc.follow = function(followedNode, rect) {
      return new cc.Follow(followedNode, rect);
    };
  }), {
    "../core/platform/CCClass": 138,
    "../core/utils/misc": 209
  } ],
  3: [ (function(require, module, exports) {
    "use strict";
    function cardinalSplineAt(p0, p1, p2, p3, tension, t) {
      var t2 = t * t;
      var t3 = t2 * t;
      var s = (1 - tension) / 2;
      var b1 = s * (2 * t2 - t3 - t);
      var b2 = s * (-t3 + t2) + (2 * t3 - 3 * t2 + 1);
      var b3 = s * (t3 - 2 * t2 + t) + (-2 * t3 + 3 * t2);
      var b4 = s * (t3 - t2);
      var x = p0.x * b1 + p1.x * b2 + p2.x * b3 + p3.x * b4;
      var y = p0.y * b1 + p1.y * b2 + p2.y * b3 + p3.y * b4;
      return cc.v2(x, y);
    }
    function getControlPointAt(controlPoints, pos) {
      var p = Math.min(controlPoints.length - 1, Math.max(pos, 0));
      return controlPoints[p];
    }
    function reverseControlPoints(controlPoints) {
      var newArray = [];
      for (var i = controlPoints.length - 1; i >= 0; i--) newArray.push(cc.v2(controlPoints[i].x, controlPoints[i].y));
      return newArray;
    }
    function cloneControlPoints(controlPoints) {
      var newArray = [];
      for (var i = 0; i < controlPoints.length; i++) newArray.push(cc.v2(controlPoints[i].x, controlPoints[i].y));
      return newArray;
    }
    cc.CardinalSplineTo = cc.Class({
      name: "cc.CardinalSplineTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, points, tension) {
        this._points = [];
        this._deltaT = 0;
        this._tension = 0;
        this._previousPosition = null;
        this._accumulatedDiff = null;
        void 0 !== tension && cc.CardinalSplineTo.prototype.initWithDuration.call(this, duration, points, tension);
      },
      initWithDuration: function initWithDuration(duration, points, tension) {
        if (!points || 0 === points.length) {
          cc.errorID(1024);
          return false;
        }
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this.setPoints(points);
          this._tension = tension;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.CardinalSplineTo();
        action.initWithDuration(this._duration, cloneControlPoints(this._points), this._tension);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._deltaT = 1 / (this._points.length - 1);
        this._previousPosition = cc.v2(this.target.x, this.target.y);
        this._accumulatedDiff = cc.v2(0, 0);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        var p, lt;
        var ps = this._points;
        if (1 === dt) {
          p = ps.length - 1;
          lt = 1;
        } else {
          var locDT = this._deltaT;
          p = 0 | dt / locDT;
          lt = (dt - locDT * p) / locDT;
        }
        var newPos = cardinalSplineAt(getControlPointAt(ps, p - 1), getControlPointAt(ps, p - 0), getControlPointAt(ps, p + 1), getControlPointAt(ps, p + 2), this._tension, lt);
        if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
          var tempX, tempY;
          tempX = this.target.x - this._previousPosition.x;
          tempY = this.target.y - this._previousPosition.y;
          if (0 !== tempX || 0 !== tempY) {
            var locAccDiff = this._accumulatedDiff;
            tempX = locAccDiff.x + tempX;
            tempY = locAccDiff.y + tempY;
            locAccDiff.x = tempX;
            locAccDiff.y = tempY;
            newPos.x += tempX;
            newPos.y += tempY;
          }
        }
        this.updatePosition(newPos);
      },
      reverse: function reverse() {
        var reversePoints = reverseControlPoints(this._points);
        return cc.cardinalSplineTo(this._duration, reversePoints, this._tension);
      },
      updatePosition: function updatePosition(newPos) {
        this.target.setPosition(newPos);
        this._previousPosition = newPos;
      },
      getPoints: function getPoints() {
        return this._points;
      },
      setPoints: function setPoints(points) {
        this._points = points;
      }
    });
    cc.cardinalSplineTo = function(duration, points, tension) {
      return new cc.CardinalSplineTo(duration, points, tension);
    };
    cc.CardinalSplineBy = cc.Class({
      name: "cc.CardinalSplineBy",
      extends: cc.CardinalSplineTo,
      ctor: function ctor(duration, points, tension) {
        this._startPosition = cc.v2(0, 0);
        void 0 !== tension && this.initWithDuration(duration, points, tension);
      },
      startWithTarget: function startWithTarget(target) {
        cc.CardinalSplineTo.prototype.startWithTarget.call(this, target);
        this._startPosition.x = target.x;
        this._startPosition.y = target.y;
      },
      reverse: function reverse() {
        var copyConfig = this._points.slice();
        var current;
        var p = copyConfig[0];
        for (var i = 1; i < copyConfig.length; ++i) {
          current = copyConfig[i];
          copyConfig[i] = current.sub(p);
          p = current;
        }
        var reverseArray = reverseControlPoints(copyConfig);
        p = reverseArray[reverseArray.length - 1];
        reverseArray.pop();
        p.x = -p.x;
        p.y = -p.y;
        reverseArray.unshift(p);
        for (var i = 1; i < reverseArray.length; ++i) {
          current = reverseArray[i];
          current.x = -current.x;
          current.y = -current.y;
          current.x += p.x;
          current.y += p.y;
          reverseArray[i] = current;
          p = current;
        }
        return cc.cardinalSplineBy(this._duration, reverseArray, this._tension);
      },
      updatePosition: function updatePosition(newPos) {
        var pos = this._startPosition;
        var posX = newPos.x + pos.x;
        var posY = newPos.y + pos.y;
        this._previousPosition.x = posX;
        this._previousPosition.y = posY;
        this.target.setPosition(posX, posY);
      },
      clone: function clone() {
        var a = new cc.CardinalSplineBy();
        a.initWithDuration(this._duration, cloneControlPoints(this._points), this._tension);
        return a;
      }
    });
    cc.cardinalSplineBy = function(duration, points, tension) {
      return new cc.CardinalSplineBy(duration, points, tension);
    };
    cc.CatmullRomTo = cc.Class({
      name: "cc.CatmullRomTo",
      extends: cc.CardinalSplineTo,
      ctor: function ctor(dt, points) {
        points && this.initWithDuration(dt, points);
      },
      initWithDuration: function initWithDuration(dt, points) {
        return cc.CardinalSplineTo.prototype.initWithDuration.call(this, dt, points, .5);
      },
      clone: function clone() {
        var action = new cc.CatmullRomTo();
        action.initWithDuration(this._duration, cloneControlPoints(this._points));
        return action;
      }
    });
    cc.catmullRomTo = function(dt, points) {
      return new cc.CatmullRomTo(dt, points);
    };
    cc.CatmullRomBy = cc.Class({
      name: "cc.CatmullRomBy",
      extends: cc.CardinalSplineBy,
      ctor: function ctor(dt, points) {
        points && this.initWithDuration(dt, points);
      },
      initWithDuration: function initWithDuration(dt, points) {
        return cc.CardinalSplineTo.prototype.initWithDuration.call(this, dt, points, .5);
      },
      clone: function clone() {
        var action = new cc.CatmullRomBy();
        action.initWithDuration(this._duration, cloneControlPoints(this._points));
        return action;
      }
    });
    cc.catmullRomBy = function(dt, points) {
      return new cc.CatmullRomBy(dt, points);
    };
  }), {} ],
  4: [ (function(require, module, exports) {
    "use strict";
    cc.easeIn = function(rate) {
      return {
        _rate: rate,
        easing: function easing(dt) {
          return Math.pow(dt, this._rate);
        },
        reverse: function reverse() {
          return cc.easeIn(1 / this._rate);
        }
      };
    };
    cc.easeOut = function(rate) {
      return {
        _rate: rate,
        easing: function easing(dt) {
          return Math.pow(dt, 1 / this._rate);
        },
        reverse: function reverse() {
          return cc.easeOut(1 / this._rate);
        }
      };
    };
    cc.easeInOut = function(rate) {
      return {
        _rate: rate,
        easing: function easing(dt) {
          dt *= 2;
          return dt < 1 ? .5 * Math.pow(dt, this._rate) : 1 - .5 * Math.pow(2 - dt, this._rate);
        },
        reverse: function reverse() {
          return cc.easeInOut(this._rate);
        }
      };
    };
    var _easeExponentialInObj = {
      easing: function easing(dt) {
        return 0 === dt ? 0 : Math.pow(2, 10 * (dt - 1));
      },
      reverse: function reverse() {
        return _easeExponentialOutObj;
      }
    };
    cc.easeExponentialIn = function() {
      return _easeExponentialInObj;
    };
    var _easeExponentialOutObj = {
      easing: function easing(dt) {
        return 1 === dt ? 1 : 1 - Math.pow(2, -10 * dt);
      },
      reverse: function reverse() {
        return _easeExponentialInObj;
      }
    };
    cc.easeExponentialOut = function() {
      return _easeExponentialOutObj;
    };
    var _easeExponentialInOutObj = {
      easing: function easing(dt) {
        if (1 !== dt && 0 !== dt) {
          dt *= 2;
          return dt < 1 ? .5 * Math.pow(2, 10 * (dt - 1)) : .5 * (2 - Math.pow(2, -10 * (dt - 1)));
        }
        return dt;
      },
      reverse: function reverse() {
        return _easeExponentialInOutObj;
      }
    };
    cc.easeExponentialInOut = function() {
      return _easeExponentialInOutObj;
    };
    var _easeSineInObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : -1 * Math.cos(dt * Math.PI / 2) + 1;
      },
      reverse: function reverse() {
        return _easeSineOutObj;
      }
    };
    cc.easeSineIn = function() {
      return _easeSineInObj;
    };
    var _easeSineOutObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : Math.sin(dt * Math.PI / 2);
      },
      reverse: function reverse() {
        return _easeSineInObj;
      }
    };
    cc.easeSineOut = function() {
      return _easeSineOutObj;
    };
    var _easeSineInOutObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : -.5 * (Math.cos(Math.PI * dt) - 1);
      },
      reverse: function reverse() {
        return _easeSineInOutObj;
      }
    };
    cc.easeSineInOut = function() {
      return _easeSineInOutObj;
    };
    var _easeElasticInObj = {
      easing: function easing(dt) {
        if (0 === dt || 1 === dt) return dt;
        dt -= 1;
        return -Math.pow(2, 10 * dt) * Math.sin((dt - .075) * Math.PI * 2 / .3);
      },
      reverse: function reverse() {
        return _easeElasticOutObj;
      }
    };
    cc.easeElasticIn = function(period) {
      if (period && .3 !== period) return {
        _period: period,
        easing: function easing(dt) {
          if (0 === dt || 1 === dt) return dt;
          dt -= 1;
          return -Math.pow(2, 10 * dt) * Math.sin((dt - this._period / 4) * Math.PI * 2 / this._period);
        },
        reverse: function reverse() {
          return cc.easeElasticOut(this._period);
        }
      };
      return _easeElasticInObj;
    };
    var _easeElasticOutObj = {
      easing: function easing(dt) {
        return 0 === dt || 1 === dt ? dt : Math.pow(2, -10 * dt) * Math.sin((dt - .075) * Math.PI * 2 / .3) + 1;
      },
      reverse: function reverse() {
        return _easeElasticInObj;
      }
    };
    cc.easeElasticOut = function(period) {
      if (period && .3 !== period) return {
        _period: period,
        easing: function easing(dt) {
          return 0 === dt || 1 === dt ? dt : Math.pow(2, -10 * dt) * Math.sin((dt - this._period / 4) * Math.PI * 2 / this._period) + 1;
        },
        reverse: function reverse() {
          return cc.easeElasticIn(this._period);
        }
      };
      return _easeElasticOutObj;
    };
    cc.easeElasticInOut = function(period) {
      period = period || .3;
      return {
        _period: period,
        easing: function easing(dt) {
          var newT = 0;
          var locPeriod = this._period;
          if (0 === dt || 1 === dt) newT = dt; else {
            dt *= 2;
            locPeriod || (locPeriod = this._period = .3 * 1.5);
            var s = locPeriod / 4;
            dt -= 1;
            newT = dt < 0 ? -.5 * Math.pow(2, 10 * dt) * Math.sin((dt - s) * Math.PI * 2 / locPeriod) : Math.pow(2, -10 * dt) * Math.sin((dt - s) * Math.PI * 2 / locPeriod) * .5 + 1;
          }
          return newT;
        },
        reverse: function reverse() {
          return cc.easeElasticInOut(this._period);
        }
      };
    };
    function _bounceTime(time1) {
      if (time1 < 1 / 2.75) return 7.5625 * time1 * time1;
      if (time1 < 2 / 2.75) {
        time1 -= 1.5 / 2.75;
        return 7.5625 * time1 * time1 + .75;
      }
      if (time1 < 2.5 / 2.75) {
        time1 -= 2.25 / 2.75;
        return 7.5625 * time1 * time1 + .9375;
      }
      time1 -= 2.625 / 2.75;
      return 7.5625 * time1 * time1 + .984375;
    }
    var _easeBounceInObj = {
      easing: function easing(dt) {
        return 1 - _bounceTime(1 - dt);
      },
      reverse: function reverse() {
        return _easeBounceOutObj;
      }
    };
    cc.easeBounceIn = function() {
      return _easeBounceInObj;
    };
    var _easeBounceOutObj = {
      easing: function easing(dt) {
        return _bounceTime(dt);
      },
      reverse: function reverse() {
        return _easeBounceInObj;
      }
    };
    cc.easeBounceOut = function() {
      return _easeBounceOutObj;
    };
    var _easeBounceInOutObj = {
      easing: function easing(time1) {
        var newT;
        if (time1 < .5) {
          time1 *= 2;
          newT = .5 * (1 - _bounceTime(1 - time1));
        } else newT = .5 * _bounceTime(2 * time1 - 1) + .5;
        return newT;
      },
      reverse: function reverse() {
        return _easeBounceInOutObj;
      }
    };
    cc.easeBounceInOut = function() {
      return _easeBounceInOutObj;
    };
    var _easeBackInObj = {
      easing: function easing(time1) {
        var overshoot = 1.70158;
        return 0 === time1 || 1 === time1 ? time1 : time1 * time1 * ((overshoot + 1) * time1 - overshoot);
      },
      reverse: function reverse() {
        return _easeBackOutObj;
      }
    };
    cc.easeBackIn = function() {
      return _easeBackInObj;
    };
    var _easeBackOutObj = {
      easing: function easing(time1) {
        if (0 === time1) return 0;
        var overshoot = 1.70158;
        time1 -= 1;
        return time1 * time1 * ((overshoot + 1) * time1 + overshoot) + 1;
      },
      reverse: function reverse() {
        return _easeBackInObj;
      }
    };
    cc.easeBackOut = function() {
      return _easeBackOutObj;
    };
    var _easeBackInOutObj = {
      easing: function easing(time1) {
        var overshoot = 2.5949095;
        time1 *= 2;
        if (time1 < 1) return time1 * time1 * ((overshoot + 1) * time1 - overshoot) / 2;
        time1 -= 2;
        return time1 * time1 * ((overshoot + 1) * time1 + overshoot) / 2 + 1;
      },
      reverse: function reverse() {
        return _easeBackInOutObj;
      }
    };
    cc.easeBackInOut = function() {
      return _easeBackInOutObj;
    };
    cc.easeBezierAction = function(a, b, c, d) {
      return {
        easing: function easing(t) {
          return Math.pow(1 - t, 3) * a + 3 * t * Math.pow(1 - t, 2) * b + 3 * Math.pow(t, 2) * (1 - t) * c + Math.pow(t, 3) * d;
        },
        reverse: function reverse() {
          return cc.easeBezierAction(d, c, b, a);
        }
      };
    };
    var _easeQuadraticActionIn = {
      easing: function easing(time) {
        return Math.pow(time, 2);
      },
      reverse: function reverse() {
        return _easeQuadraticActionIn;
      }
    };
    cc.easeQuadraticActionIn = function() {
      return _easeQuadraticActionIn;
    };
    var _easeQuadraticActionOut = {
      easing: function easing(time) {
        return -time * (time - 2);
      },
      reverse: function reverse() {
        return _easeQuadraticActionOut;
      }
    };
    cc.easeQuadraticActionOut = function() {
      return _easeQuadraticActionOut;
    };
    var _easeQuadraticActionInOut = {
      easing: function easing(time) {
        var resultTime = time;
        time *= 2;
        if (time < 1) resultTime = time * time * .5; else {
          --time;
          resultTime = -.5 * (time * (time - 2) - 1);
        }
        return resultTime;
      },
      reverse: function reverse() {
        return _easeQuadraticActionInOut;
      }
    };
    cc.easeQuadraticActionInOut = function() {
      return _easeQuadraticActionInOut;
    };
    var _easeQuarticActionIn = {
      easing: function easing(time) {
        return time * time * time * time;
      },
      reverse: function reverse() {
        return _easeQuarticActionIn;
      }
    };
    cc.easeQuarticActionIn = function() {
      return _easeQuarticActionIn;
    };
    var _easeQuarticActionOut = {
      easing: function easing(time) {
        time -= 1;
        return -(time * time * time * time - 1);
      },
      reverse: function reverse() {
        return _easeQuarticActionOut;
      }
    };
    cc.easeQuarticActionOut = function() {
      return _easeQuarticActionOut;
    };
    var _easeQuarticActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time * time;
        time -= 2;
        return -.5 * (time * time * time * time - 2);
      },
      reverse: function reverse() {
        return _easeQuarticActionInOut;
      }
    };
    cc.easeQuarticActionInOut = function() {
      return _easeQuarticActionInOut;
    };
    var _easeQuinticActionIn = {
      easing: function easing(time) {
        return time * time * time * time * time;
      },
      reverse: function reverse() {
        return _easeQuinticActionIn;
      }
    };
    cc.easeQuinticActionIn = function() {
      return _easeQuinticActionIn;
    };
    var _easeQuinticActionOut = {
      easing: function easing(time) {
        time -= 1;
        return time * time * time * time * time + 1;
      },
      reverse: function reverse() {
        return _easeQuinticActionOut;
      }
    };
    cc.easeQuinticActionOut = function() {
      return _easeQuinticActionOut;
    };
    var _easeQuinticActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time * time * time;
        time -= 2;
        return .5 * (time * time * time * time * time + 2);
      },
      reverse: function reverse() {
        return _easeQuinticActionInOut;
      }
    };
    cc.easeQuinticActionInOut = function() {
      return _easeQuinticActionInOut;
    };
    var _easeCircleActionIn = {
      easing: function easing(time) {
        return -1 * (Math.sqrt(1 - time * time) - 1);
      },
      reverse: function reverse() {
        return _easeCircleActionIn;
      }
    };
    cc.easeCircleActionIn = function() {
      return _easeCircleActionIn;
    };
    var _easeCircleActionOut = {
      easing: function easing(time) {
        time -= 1;
        return Math.sqrt(1 - time * time);
      },
      reverse: function reverse() {
        return _easeCircleActionOut;
      }
    };
    cc.easeCircleActionOut = function() {
      return _easeCircleActionOut;
    };
    var _easeCircleActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return -.5 * (Math.sqrt(1 - time * time) - 1);
        time -= 2;
        return .5 * (Math.sqrt(1 - time * time) + 1);
      },
      reverse: function reverse() {
        return _easeCircleActionInOut;
      }
    };
    cc.easeCircleActionInOut = function() {
      return _easeCircleActionInOut;
    };
    var _easeCubicActionIn = {
      easing: function easing(time) {
        return time * time * time;
      },
      reverse: function reverse() {
        return _easeCubicActionIn;
      }
    };
    cc.easeCubicActionIn = function() {
      return _easeCubicActionIn;
    };
    var _easeCubicActionOut = {
      easing: function easing(time) {
        time -= 1;
        return time * time * time + 1;
      },
      reverse: function reverse() {
        return _easeCubicActionOut;
      }
    };
    cc.easeCubicActionOut = function() {
      return _easeCubicActionOut;
    };
    var _easeCubicActionInOut = {
      easing: function easing(time) {
        time *= 2;
        if (time < 1) return .5 * time * time * time;
        time -= 2;
        return .5 * (time * time * time + 2);
      },
      reverse: function reverse() {
        return _easeCubicActionInOut;
      }
    };
    cc.easeCubicActionInOut = function() {
      return _easeCubicActionInOut;
    };
  }), {} ],
  5: [ (function(require, module, exports) {
    "use strict";
    cc.ActionInstant = cc.Class({
      name: "cc.ActionInstant",
      extends: cc.FiniteTimeAction,
      isDone: function isDone() {
        return true;
      },
      step: function step(dt) {
        this.update(1);
      },
      update: function update(dt) {},
      reverse: function reverse() {
        return this.clone();
      },
      clone: function clone() {
        return new cc.ActionInstant();
      }
    });
    cc.Show = cc.Class({
      name: "cc.Show",
      extends: cc.ActionInstant,
      update: function update(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = true;
        }
      },
      reverse: function reverse() {
        return new cc.Hide();
      },
      clone: function clone() {
        return new cc.Show();
      }
    });
    cc.show = function() {
      return new cc.Show();
    };
    cc.Hide = cc.Class({
      name: "cc.Hide",
      extends: cc.ActionInstant,
      update: function update(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = false;
        }
      },
      reverse: function reverse() {
        return new cc.Show();
      },
      clone: function clone() {
        return new cc.Hide();
      }
    });
    cc.hide = function() {
      return new cc.Hide();
    };
    cc.ToggleVisibility = cc.Class({
      name: "cc.ToggleVisibility",
      extends: cc.ActionInstant,
      update: function update(dt) {
        var _renderComps = this.target.getComponentsInChildren(cc.RenderComponent);
        for (var i = 0; i < _renderComps.length; ++i) {
          var render = _renderComps[i];
          render.enabled = !render.enabled;
        }
      },
      reverse: function reverse() {
        return new cc.ToggleVisibility();
      },
      clone: function clone() {
        return new cc.ToggleVisibility();
      }
    });
    cc.toggleVisibility = function() {
      return new cc.ToggleVisibility();
    };
    cc.RemoveSelf = cc.Class({
      name: "cc.RemoveSelf",
      extends: cc.ActionInstant,
      ctor: function ctor(isNeedCleanUp) {
        this._isNeedCleanUp = true;
        void 0 !== isNeedCleanUp && this.init(isNeedCleanUp);
      },
      update: function update(dt) {
        this.target.removeFromParent(this._isNeedCleanUp);
      },
      init: function init(isNeedCleanUp) {
        this._isNeedCleanUp = isNeedCleanUp;
        return true;
      },
      reverse: function reverse() {
        return new cc.RemoveSelf(this._isNeedCleanUp);
      },
      clone: function clone() {
        return new cc.RemoveSelf(this._isNeedCleanUp);
      }
    });
    cc.removeSelf = function(isNeedCleanUp) {
      return new cc.RemoveSelf(isNeedCleanUp);
    };
    cc.DestroySelf = cc.Class({
      name: "cc.DestroySelf",
      extends: cc.ActionInstant,
      update: function update() {
        this.target.destroy();
      },
      reverse: function reverse() {
        return new cc.DestroySelf();
      },
      clone: function clone() {
        return new cc.DestroySelf();
      }
    });
    cc.destroySelf = function() {
      return new cc.DestroySelf();
    };
    cc.FlipX = cc.Class({
      name: "cc.FlipX",
      extends: cc.ActionInstant,
      ctor: function ctor(flip) {
        this._flippedX = false;
        void 0 !== flip && this.initWithFlipX(flip);
      },
      initWithFlipX: function initWithFlipX(flip) {
        this._flippedX = flip;
        return true;
      },
      update: function update(dt) {
        this.target.scaleX = Math.abs(this.target.scaleX) * (this._flippedX ? -1 : 1);
      },
      reverse: function reverse() {
        return new cc.FlipX(!this._flippedX);
      },
      clone: function clone() {
        var action = new cc.FlipX();
        action.initWithFlipX(this._flippedX);
        return action;
      }
    });
    cc.flipX = function(flip) {
      return new cc.FlipX(flip);
    };
    cc.FlipY = cc.Class({
      name: "cc.FlipY",
      extends: cc.ActionInstant,
      ctor: function ctor(flip) {
        this._flippedY = false;
        void 0 !== flip && this.initWithFlipY(flip);
      },
      initWithFlipY: function initWithFlipY(flip) {
        this._flippedY = flip;
        return true;
      },
      update: function update(dt) {
        this.target.scaleY = Math.abs(this.target.scaleY) * (this._flippedY ? -1 : 1);
      },
      reverse: function reverse() {
        return new cc.FlipY(!this._flippedY);
      },
      clone: function clone() {
        var action = new cc.FlipY();
        action.initWithFlipY(this._flippedY);
        return action;
      }
    });
    cc.flipY = function(flip) {
      return new cc.FlipY(flip);
    };
    cc.Place = cc.Class({
      name: "cc.Place",
      extends: cc.ActionInstant,
      ctor: function ctor(pos, y) {
        this._x = 0;
        this._y = 0;
        if (void 0 !== pos) {
          if (void 0 !== pos.x) {
            y = pos.y;
            pos = pos.x;
          }
          this.initWithPosition(pos, y);
        }
      },
      initWithPosition: function initWithPosition(x, y) {
        this._x = x;
        this._y = y;
        return true;
      },
      update: function update(dt) {
        this.target.setPosition(this._x, this._y);
      },
      clone: function clone() {
        var action = new cc.Place();
        action.initWithPosition(this._x, this._y);
        return action;
      }
    });
    cc.place = function(pos, y) {
      return new cc.Place(pos, y);
    };
    cc.CallFunc = cc.Class({
      name: "cc.CallFunc",
      extends: cc.ActionInstant,
      ctor: function ctor(selector, selectorTarget, data) {
        this._selectorTarget = null;
        this._function = null;
        this._data = null;
        this.initWithFunction(selector, selectorTarget, data);
      },
      initWithFunction: function initWithFunction(selector, selectorTarget, data) {
        selector && (this._function = selector);
        selectorTarget && (this._selectorTarget = selectorTarget);
        void 0 !== data && (this._data = data);
        return true;
      },
      execute: function execute() {
        this._function && this._function.call(this._selectorTarget, this.target, this._data);
      },
      update: function update(dt) {
        this.execute();
      },
      getTargetCallback: function getTargetCallback() {
        return this._selectorTarget;
      },
      setTargetCallback: function setTargetCallback(sel) {
        if (sel !== this._selectorTarget) {
          this._selectorTarget && (this._selectorTarget = null);
          this._selectorTarget = sel;
        }
      },
      clone: function clone() {
        var action = new cc.CallFunc();
        action.initWithFunction(this._function, this._selectorTarget, this._data);
        return action;
      }
    });
    cc.callFunc = function(selector, selectorTarget, data) {
      return new cc.CallFunc(selector, selectorTarget, data);
    };
  }), {} ],
  6: [ (function(require, module, exports) {
    "use strict";
    cc.ActionInterval = cc.Class({
      name: "cc.ActionInterval",
      extends: cc.FiniteTimeAction,
      ctor: function ctor(d) {
        this.MAX_VALUE = 2;
        this._elapsed = 0;
        this._firstTick = false;
        this._easeList = null;
        this._speed = 1;
        this._timesForRepeat = 1;
        this._repeatForever = false;
        this._repeatMethod = false;
        this._speedMethod = false;
        void 0 !== d && cc.ActionInterval.prototype.initWithDuration.call(this, d);
      },
      getElapsed: function getElapsed() {
        return this._elapsed;
      },
      initWithDuration: function initWithDuration(d) {
        this._duration = 0 === d ? cc.macro.FLT_EPSILON : d;
        this._elapsed = 0;
        this._firstTick = true;
        return true;
      },
      isDone: function isDone() {
        return this._elapsed >= this._duration;
      },
      _cloneDecoration: function _cloneDecoration(action) {
        action._repeatForever = this._repeatForever;
        action._speed = this._speed;
        action._timesForRepeat = this._timesForRepeat;
        action._easeList = this._easeList;
        action._speedMethod = this._speedMethod;
        action._repeatMethod = this._repeatMethod;
      },
      _reverseEaseList: function _reverseEaseList(action) {
        if (this._easeList) {
          action._easeList = [];
          for (var i = 0; i < this._easeList.length; i++) action._easeList.push(this._easeList[i].reverse());
        }
      },
      clone: function clone() {
        var action = new cc.ActionInterval(this._duration);
        this._cloneDecoration(action);
        return action;
      },
      easing: function easing(easeObj) {
        this._easeList ? this._easeList.length = 0 : this._easeList = [];
        for (var i = 0; i < arguments.length; i++) this._easeList.push(arguments[i]);
        return this;
      },
      _computeEaseTime: function _computeEaseTime(dt) {
        var locList = this._easeList;
        if (!locList || 0 === locList.length) return dt;
        for (var i = 0, n = locList.length; i < n; i++) dt = locList[i].easing(dt);
        return dt;
      },
      step: function step(dt) {
        if (this._firstTick) {
          this._firstTick = false;
          this._elapsed = 0;
        } else this._elapsed += dt;
        var t = this._elapsed / (this._duration > 1.192092896e-7 ? this._duration : 1.192092896e-7);
        t = 1 > t ? t : 1;
        this.update(t > 0 ? t : 0);
        if (this._repeatMethod && this._timesForRepeat > 1 && this.isDone()) {
          this._repeatForever || this._timesForRepeat--;
          this.startWithTarget(this.target);
          this.step(this._elapsed - this._duration);
        }
      },
      startWithTarget: function startWithTarget(target) {
        cc.Action.prototype.startWithTarget.call(this, target);
        this._elapsed = 0;
        this._firstTick = true;
      },
      reverse: function reverse() {
        cc.logID(1010);
        return null;
      },
      setAmplitudeRate: function setAmplitudeRate(amp) {
        cc.logID(1011);
      },
      getAmplitudeRate: function getAmplitudeRate() {
        cc.logID(1012);
        return 0;
      },
      speed: function speed(_speed) {
        if (_speed <= 0) {
          cc.logID(1013);
          return this;
        }
        this._speedMethod = true;
        this._speed *= _speed;
        return this;
      },
      getSpeed: function getSpeed() {
        return this._speed;
      },
      setSpeed: function setSpeed(speed) {
        this._speed = speed;
        return this;
      },
      repeat: function repeat(times) {
        times = Math.round(times);
        if (isNaN(times) || times < 1) {
          cc.logID(1014);
          return this;
        }
        this._repeatMethod = true;
        this._timesForRepeat *= times;
        return this;
      },
      repeatForever: function repeatForever() {
        this._repeatMethod = true;
        this._timesForRepeat = this.MAX_VALUE;
        this._repeatForever = true;
        return this;
      }
    });
    cc.actionInterval = function(d) {
      return new cc.ActionInterval(d);
    };
    cc.Sequence = cc.Class({
      name: "cc.Sequence",
      extends: cc.ActionInterval,
      ctor: function ctor(tempArray) {
        this._actions = [];
        this._split = null;
        this._last = 0;
        this._reversed = false;
        var paramArray = tempArray instanceof Array ? tempArray : arguments;
        if (1 === paramArray.length) {
          cc.errorID(1019);
          return;
        }
        var last = paramArray.length - 1;
        last >= 0 && null == paramArray[last] && cc.logID(1015);
        if (last >= 0) {
          var prev = paramArray[0], action1;
          for (var i = 1; i < last; i++) if (paramArray[i]) {
            action1 = prev;
            prev = cc.Sequence._actionOneTwo(action1, paramArray[i]);
          }
          this.initWithTwoActions(prev, paramArray[last]);
        }
      },
      initWithTwoActions: function initWithTwoActions(actionOne, actionTwo) {
        if (!actionOne || !actionTwo) {
          cc.errorID(1025);
          return false;
        }
        var durationOne = actionOne._duration, durationTwo = actionTwo._duration;
        durationOne *= actionOne._repeatMethod ? actionOne._timesForRepeat : 1;
        durationTwo *= actionTwo._repeatMethod ? actionTwo._timesForRepeat : 1;
        var d = durationOne + durationTwo;
        this.initWithDuration(d);
        this._actions[0] = actionOne;
        this._actions[1] = actionTwo;
        return true;
      },
      clone: function clone() {
        var action = new cc.Sequence();
        this._cloneDecoration(action);
        action.initWithTwoActions(this._actions[0].clone(), this._actions[1].clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._split = this._actions[0]._duration / this._duration;
        this._split *= this._actions[0]._repeatMethod ? this._actions[0]._timesForRepeat : 1;
        this._last = -1;
      },
      stop: function stop() {
        -1 !== this._last && this._actions[this._last].stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function update(dt) {
        var new_t, found = 0;
        var locSplit = this._split, locActions = this._actions, locLast = this._last, actionFound;
        dt = this._computeEaseTime(dt);
        if (dt < locSplit) {
          new_t = 0 !== locSplit ? dt / locSplit : 1;
          if (0 === found && 1 === locLast && this._reversed) {
            locActions[1].update(0);
            locActions[1].stop();
          }
        } else {
          found = 1;
          new_t = 1 === locSplit ? 1 : (dt - locSplit) / (1 - locSplit);
          if (-1 === locLast) {
            locActions[0].startWithTarget(this.target);
            locActions[0].update(1);
            locActions[0].stop();
          }
          if (0 === locLast) {
            locActions[0].update(1);
            locActions[0].stop();
          }
        }
        actionFound = locActions[found];
        if (locLast === found && actionFound.isDone()) return;
        locLast !== found && actionFound.startWithTarget(this.target);
        new_t *= actionFound._timesForRepeat;
        actionFound.update(new_t > 1 ? new_t % 1 : new_t);
        this._last = found;
      },
      reverse: function reverse() {
        var action = cc.Sequence._actionOneTwo(this._actions[1].reverse(), this._actions[0].reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        action._reversed = true;
        return action;
      }
    });
    cc.sequence = function(tempArray) {
      var paramArray = tempArray instanceof Array ? tempArray : arguments;
      if (1 === paramArray.length) {
        cc.errorID(1019);
        return null;
      }
      var last = paramArray.length - 1;
      last >= 0 && null == paramArray[last] && cc.logID(1015);
      var result = null;
      if (last >= 0) {
        result = paramArray[0];
        for (var i = 1; i <= last; i++) paramArray[i] && (result = cc.Sequence._actionOneTwo(result, paramArray[i]));
      }
      return result;
    };
    cc.Sequence._actionOneTwo = function(actionOne, actionTwo) {
      var sequence = new cc.Sequence();
      sequence.initWithTwoActions(actionOne, actionTwo);
      return sequence;
    };
    cc.Repeat = cc.Class({
      name: "cc.Repeat",
      extends: cc.ActionInterval,
      ctor: function ctor(action, times) {
        this._times = 0;
        this._total = 0;
        this._nextDt = 0;
        this._actionInstant = false;
        this._innerAction = null;
        void 0 !== times && this.initWithAction(action, times);
      },
      initWithAction: function initWithAction(action, times) {
        var duration = action._duration * times;
        if (this.initWithDuration(duration)) {
          this._times = times;
          this._innerAction = action;
          if (action instanceof cc.ActionInstant) {
            this._actionInstant = true;
            this._times -= 1;
          }
          this._total = 0;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.Repeat();
        this._cloneDecoration(action);
        action.initWithAction(this._innerAction.clone(), this._times);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        this._total = 0;
        this._nextDt = this._innerAction._duration / this._duration;
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      stop: function stop() {
        this._innerAction.stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        var locInnerAction = this._innerAction;
        var locDuration = this._duration;
        var locTimes = this._times;
        var locNextDt = this._nextDt;
        if (dt >= locNextDt) {
          while (dt > locNextDt && this._total < locTimes) {
            locInnerAction.update(1);
            this._total++;
            locInnerAction.stop();
            locInnerAction.startWithTarget(this.target);
            locNextDt += locInnerAction._duration / locDuration;
            this._nextDt = locNextDt > 1 ? 1 : locNextDt;
          }
          if (dt >= 1 && this._total < locTimes) {
            locInnerAction.update(1);
            this._total++;
          }
          this._actionInstant || (this._total === locTimes ? locInnerAction.stop() : locInnerAction.update(dt - (locNextDt - locInnerAction._duration / locDuration)));
        } else locInnerAction.update(dt * locTimes % 1);
      },
      isDone: function isDone() {
        return this._total === this._times;
      },
      reverse: function reverse() {
        var action = new cc.Repeat(this._innerAction.reverse(), this._times);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      setInnerAction: function setInnerAction(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function getInnerAction() {
        return this._innerAction;
      }
    });
    cc.repeat = function(action, times) {
      return new cc.Repeat(action, times);
    };
    cc.RepeatForever = cc.Class({
      name: "cc.RepeatForever",
      extends: cc.ActionInterval,
      ctor: function ctor(action) {
        this._innerAction = null;
        action && this.initWithAction(action);
      },
      initWithAction: function initWithAction(action) {
        if (!action) {
          cc.errorID(1026);
          return false;
        }
        this._innerAction = action;
        return true;
      },
      clone: function clone() {
        var action = new cc.RepeatForever();
        this._cloneDecoration(action);
        action.initWithAction(this._innerAction.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._innerAction.startWithTarget(target);
      },
      step: function step(dt) {
        var locInnerAction = this._innerAction;
        locInnerAction.step(dt);
        if (locInnerAction.isDone()) {
          locInnerAction.startWithTarget(this.target);
          locInnerAction.step(locInnerAction.getElapsed() - locInnerAction._duration);
        }
      },
      isDone: function isDone() {
        return false;
      },
      reverse: function reverse() {
        var action = new cc.RepeatForever(this._innerAction.reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      setInnerAction: function setInnerAction(action) {
        this._innerAction !== action && (this._innerAction = action);
      },
      getInnerAction: function getInnerAction() {
        return this._innerAction;
      }
    });
    cc.repeatForever = function(action) {
      return new cc.RepeatForever(action);
    };
    cc.Spawn = cc.Class({
      name: "cc.Spawn",
      extends: cc.ActionInterval,
      ctor: function ctor(tempArray) {
        this._one = null;
        this._two = null;
        var paramArray = tempArray instanceof Array ? tempArray : arguments;
        if (1 === paramArray.length) {
          cc.errorID(1020);
          return;
        }
        var last = paramArray.length - 1;
        last >= 0 && null == paramArray[last] && cc.logID(1015);
        if (last >= 0) {
          var prev = paramArray[0], action1;
          for (var i = 1; i < last; i++) if (paramArray[i]) {
            action1 = prev;
            prev = cc.Spawn._actionOneTwo(action1, paramArray[i]);
          }
          this.initWithTwoActions(prev, paramArray[last]);
        }
      },
      initWithTwoActions: function initWithTwoActions(action1, action2) {
        if (!action1 || !action2) {
          cc.errorID(1027);
          return false;
        }
        var ret = false;
        var d1 = action1._duration;
        var d2 = action2._duration;
        if (this.initWithDuration(Math.max(d1, d2))) {
          this._one = action1;
          this._two = action2;
          d1 > d2 ? this._two = cc.Sequence._actionOneTwo(action2, cc.delayTime(d1 - d2)) : d1 < d2 && (this._one = cc.Sequence._actionOneTwo(action1, cc.delayTime(d2 - d1)));
          ret = true;
        }
        return ret;
      },
      clone: function clone() {
        var action = new cc.Spawn();
        this._cloneDecoration(action);
        action.initWithTwoActions(this._one.clone(), this._two.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._one.startWithTarget(target);
        this._two.startWithTarget(target);
      },
      stop: function stop() {
        this._one.stop();
        this._two.stop();
        cc.Action.prototype.stop.call(this);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this._one && this._one.update(dt);
        this._two && this._two.update(dt);
      },
      reverse: function reverse() {
        var action = cc.Spawn._actionOneTwo(this._one.reverse(), this._two.reverse());
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.spawn = function(tempArray) {
      var paramArray = tempArray instanceof Array ? tempArray : arguments;
      if (1 === paramArray.length) {
        cc.errorID(1020);
        return null;
      }
      paramArray.length > 0 && null == paramArray[paramArray.length - 1] && cc.logID(1015);
      var prev = paramArray[0];
      for (var i = 1; i < paramArray.length; i++) null != paramArray[i] && (prev = cc.Spawn._actionOneTwo(prev, paramArray[i]));
      return prev;
    };
    cc.Spawn._actionOneTwo = function(action1, action2) {
      var pSpawn = new cc.Spawn();
      pSpawn.initWithTwoActions(action1, action2);
      return pSpawn;
    };
    cc.RotateTo = cc.Class({
      name: "cc.RotateTo",
      extends: cc.ActionInterval,
      statics: {
        _reverse: false
      },
      ctor: function ctor(duration, dstAngle) {
        this._startAngle = 0;
        this._dstAngle = 0;
        this._angle = 0;
        void 0 !== dstAngle && this.initWithDuration(duration, dstAngle);
      },
      initWithDuration: function initWithDuration(duration, dstAngle) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._dstAngle = dstAngle;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.RotateTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._dstAngle);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var startAngle = target.angle % 360;
        var angle = cc.RotateTo._reverse ? this._dstAngle - startAngle : this._dstAngle + startAngle;
        angle > 180 && (angle -= 360);
        angle < -180 && (angle += 360);
        this._startAngle = startAngle;
        this._angle = cc.RotateTo._reverse ? angle : -angle;
      },
      reverse: function reverse() {
        cc.logID(1016);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target && (this.target.angle = this._startAngle + this._angle * dt);
      }
    });
    cc.rotateTo = function(duration, dstAngle) {
      return new cc.RotateTo(duration, dstAngle);
    };
    cc.RotateBy = cc.Class({
      name: "cc.RotateBy",
      extends: cc.ActionInterval,
      statics: {
        _reverse: false
      },
      ctor: function ctor(duration, deltaAngle) {
        deltaAngle *= cc.RotateBy._reverse ? 1 : -1;
        this._deltaAngle = 0;
        this._startAngle = 0;
        void 0 !== deltaAngle && this.initWithDuration(duration, deltaAngle);
      },
      initWithDuration: function initWithDuration(duration, deltaAngle) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._deltaAngle = deltaAngle;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.RotateBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._deltaAngle);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startAngle = target.angle;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target && (this.target.angle = this._startAngle + this._deltaAngle * dt);
      },
      reverse: function reverse() {
        var action = new cc.RotateBy();
        action.initWithDuration(this._duration, -this._deltaAngle);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.rotateBy = function(duration, deltaAngle) {
      return new cc.RotateBy(duration, deltaAngle);
    };
    cc.MoveBy = cc.Class({
      name: "cc.MoveBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, deltaPos, deltaY) {
        this._positionDelta = cc.v2(0, 0);
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        void 0 !== deltaPos && cc.MoveBy.prototype.initWithDuration.call(this, duration, deltaPos, deltaY);
      },
      initWithDuration: function initWithDuration(duration, position, y) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          if (void 0 !== position.x) {
            y = position.y;
            position = position.x;
          }
          this._positionDelta.x = position;
          this._positionDelta.y = y;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.MoveBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._positionDelta);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var x = this._positionDelta.x * dt;
          var y = this._positionDelta.y * dt;
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function reverse() {
        var action = new cc.MoveBy(this._duration, cc.v2(-this._positionDelta.x, -this._positionDelta.y));
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.moveBy = function(duration, deltaPos, deltaY) {
      return new cc.MoveBy(duration, deltaPos, deltaY);
    };
    cc.MoveTo = cc.Class({
      name: "cc.MoveTo",
      extends: cc.MoveBy,
      ctor: function ctor(duration, position, y) {
        this._endPosition = cc.v2(0, 0);
        void 0 !== position && this.initWithDuration(duration, position, y);
      },
      initWithDuration: function initWithDuration(duration, position, y) {
        if (cc.MoveBy.prototype.initWithDuration.call(this, duration, position, y)) {
          if (void 0 !== position.x) {
            y = position.y;
            position = position.x;
          }
          this._endPosition.x = position;
          this._endPosition.y = y;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.MoveTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endPosition);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.MoveBy.prototype.startWithTarget.call(this, target);
        this._positionDelta.x = this._endPosition.x - target.x;
        this._positionDelta.y = this._endPosition.y - target.y;
      }
    });
    cc.moveTo = function(duration, position, y) {
      return new cc.MoveTo(duration, position, y);
    };
    cc.SkewTo = cc.Class({
      name: "cc.SkewTo",
      extends: cc.ActionInterval,
      ctor: function ctor(t, sx, sy) {
        this._skewX = 0;
        this._skewY = 0;
        this._startSkewX = 0;
        this._startSkewY = 0;
        this._endSkewX = 0;
        this._endSkewY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        void 0 !== sy && cc.SkewTo.prototype.initWithDuration.call(this, t, sx, sy);
      },
      initWithDuration: function initWithDuration(t, sx, sy) {
        var ret = false;
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._endSkewX = sx;
          this._endSkewY = sy;
          ret = true;
        }
        return ret;
      },
      clone: function clone() {
        var action = new cc.SkewTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endSkewX, this._endSkewY);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startSkewX = target.skewX % 180;
        this._deltaX = this._endSkewX - this._startSkewX;
        this._deltaX > 180 && (this._deltaX -= 360);
        this._deltaX < -180 && (this._deltaX += 360);
        this._startSkewY = target.skewY % 360;
        this._deltaY = this._endSkewY - this._startSkewY;
        this._deltaY > 180 && (this._deltaY -= 360);
        this._deltaY < -180 && (this._deltaY += 360);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target.skewX = this._startSkewX + this._deltaX * dt;
        this.target.skewY = this._startSkewY + this._deltaY * dt;
      }
    });
    cc.skewTo = function(t, sx, sy) {
      return new cc.SkewTo(t, sx, sy);
    };
    cc.SkewBy = cc.Class({
      name: "cc.SkewBy",
      extends: cc.SkewTo,
      ctor: function ctor(t, sx, sy) {
        void 0 !== sy && this.initWithDuration(t, sx, sy);
      },
      initWithDuration: function initWithDuration(t, deltaSkewX, deltaSkewY) {
        var ret = false;
        if (cc.SkewTo.prototype.initWithDuration.call(this, t, deltaSkewX, deltaSkewY)) {
          this._skewX = deltaSkewX;
          this._skewY = deltaSkewY;
          ret = true;
        }
        return ret;
      },
      clone: function clone() {
        var action = new cc.SkewBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._skewX, this._skewY);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.SkewTo.prototype.startWithTarget.call(this, target);
        this._deltaX = this._skewX;
        this._deltaY = this._skewY;
        this._endSkewX = this._startSkewX + this._deltaX;
        this._endSkewY = this._startSkewY + this._deltaY;
      },
      reverse: function reverse() {
        var action = new cc.SkewBy(this._duration, -this._skewX, -this._skewY);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.skewBy = function(t, sx, sy) {
      return new cc.SkewBy(t, sx, sy);
    };
    cc.JumpBy = cc.Class({
      name: "cc.JumpBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, position, y, height, jumps) {
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        this._delta = cc.v2(0, 0);
        this._height = 0;
        this._jumps = 0;
        void 0 !== height && cc.JumpBy.prototype.initWithDuration.call(this, duration, position, y, height, jumps);
      },
      initWithDuration: function initWithDuration(duration, position, y, height, jumps) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          if (void 0 === jumps) {
            jumps = height;
            height = y;
            y = position.y;
            position = position.x;
          }
          this._delta.x = position;
          this._delta.y = y;
          this._height = height;
          this._jumps = jumps;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.JumpBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._delta, this._height, this._jumps);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var frac = dt * this._jumps % 1;
          var y = 4 * this._height * frac * (1 - frac);
          y += this._delta.y * dt;
          var x = this._delta.x * dt;
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function reverse() {
        var action = new cc.JumpBy(this._duration, cc.v2(-this._delta.x, -this._delta.y), this._height, this._jumps);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.jumpBy = function(duration, position, y, height, jumps) {
      return new cc.JumpBy(duration, position, y, height, jumps);
    };
    cc.JumpTo = cc.Class({
      name: "cc.JumpTo",
      extends: cc.JumpBy,
      ctor: function ctor(duration, position, y, height, jumps) {
        this._endPosition = cc.v2(0, 0);
        void 0 !== height && this.initWithDuration(duration, position, y, height, jumps);
      },
      initWithDuration: function initWithDuration(duration, position, y, height, jumps) {
        if (cc.JumpBy.prototype.initWithDuration.call(this, duration, position, y, height, jumps)) {
          if (void 0 === jumps) {
            y = position.y;
            position = position.x;
          }
          this._endPosition.x = position;
          this._endPosition.y = y;
          return true;
        }
        return false;
      },
      startWithTarget: function startWithTarget(target) {
        cc.JumpBy.prototype.startWithTarget.call(this, target);
        this._delta.x = this._endPosition.x - this._startPosition.x;
        this._delta.y = this._endPosition.y - this._startPosition.y;
      },
      clone: function clone() {
        var action = new cc.JumpTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endPosition, this._height, this._jumps);
        return action;
      }
    });
    cc.jumpTo = function(duration, position, y, height, jumps) {
      return new cc.JumpTo(duration, position, y, height, jumps);
    };
    function bezierAt(a, b, c, d, t) {
      return Math.pow(1 - t, 3) * a + 3 * t * Math.pow(1 - t, 2) * b + 3 * Math.pow(t, 2) * (1 - t) * c + Math.pow(t, 3) * d;
    }
    cc.BezierBy = cc.Class({
      name: "cc.BezierBy",
      extends: cc.ActionInterval,
      ctor: function ctor(t, c) {
        this._config = [];
        this._startPosition = cc.v2(0, 0);
        this._previousPosition = cc.v2(0, 0);
        c && cc.BezierBy.prototype.initWithDuration.call(this, t, c);
      },
      initWithDuration: function initWithDuration(t, c) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._config = c;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.BezierBy();
        this._cloneDecoration(action);
        var newConfigs = [];
        for (var i = 0; i < this._config.length; i++) {
          var selConf = this._config[i];
          newConfigs.push(cc.v2(selConf.x, selConf.y));
        }
        action.initWithDuration(this._duration, newConfigs);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var locPosX = target.x;
        var locPosY = target.y;
        this._previousPosition.x = locPosX;
        this._previousPosition.y = locPosY;
        this._startPosition.x = locPosX;
        this._startPosition.y = locPosY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          var locConfig = this._config;
          var xa = 0;
          var xb = locConfig[0].x;
          var xc = locConfig[1].x;
          var xd = locConfig[2].x;
          var ya = 0;
          var yb = locConfig[0].y;
          var yc = locConfig[1].y;
          var yd = locConfig[2].y;
          var x = bezierAt(xa, xb, xc, xd, dt);
          var y = bezierAt(ya, yb, yc, yd, dt);
          var locStartPosition = this._startPosition;
          if (cc.macro.ENABLE_STACKABLE_ACTIONS) {
            var targetX = this.target.x;
            var targetY = this.target.y;
            var locPreviousPosition = this._previousPosition;
            locStartPosition.x = locStartPosition.x + targetX - locPreviousPosition.x;
            locStartPosition.y = locStartPosition.y + targetY - locPreviousPosition.y;
            x += locStartPosition.x;
            y += locStartPosition.y;
            locPreviousPosition.x = x;
            locPreviousPosition.y = y;
            this.target.setPosition(x, y);
          } else this.target.setPosition(locStartPosition.x + x, locStartPosition.y + y);
        }
      },
      reverse: function reverse() {
        var locConfig = this._config;
        var x0 = locConfig[0].x, y0 = locConfig[0].y;
        var x1 = locConfig[1].x, y1 = locConfig[1].y;
        var x2 = locConfig[2].x, y2 = locConfig[2].y;
        var r = [ cc.v2(x1 - x2, y1 - y2), cc.v2(x0 - x2, y0 - y2), cc.v2(-x2, -y2) ];
        var action = new cc.BezierBy(this._duration, r);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.bezierBy = function(t, c) {
      return new cc.BezierBy(t, c);
    };
    cc.BezierTo = cc.Class({
      name: "cc.BezierTo",
      extends: cc.BezierBy,
      ctor: function ctor(t, c) {
        this._toConfig = [];
        c && this.initWithDuration(t, c);
      },
      initWithDuration: function initWithDuration(t, c) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, t)) {
          this._toConfig = c;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.BezierTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toConfig);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.BezierBy.prototype.startWithTarget.call(this, target);
        var locStartPos = this._startPosition;
        var locToConfig = this._toConfig;
        var locConfig = this._config;
        locConfig[0] = locToConfig[0].sub(locStartPos);
        locConfig[1] = locToConfig[1].sub(locStartPos);
        locConfig[2] = locToConfig[2].sub(locStartPos);
      }
    });
    cc.bezierTo = function(t, c) {
      return new cc.BezierTo(t, c);
    };
    cc.ScaleTo = cc.Class({
      name: "cc.ScaleTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, sx, sy) {
        this._scaleX = 1;
        this._scaleY = 1;
        this._startScaleX = 1;
        this._startScaleY = 1;
        this._endScaleX = 0;
        this._endScaleY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        void 0 !== sx && cc.ScaleTo.prototype.initWithDuration.call(this, duration, sx, sy);
      },
      initWithDuration: function initWithDuration(duration, sx, sy) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._endScaleX = sx;
          this._endScaleY = null != sy ? sy : sx;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.ScaleTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endScaleX, this._endScaleY);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._startScaleX = target.scaleX;
        this._startScaleY = target.scaleY;
        this._deltaX = this._endScaleX - this._startScaleX;
        this._deltaY = this._endScaleY - this._startScaleY;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target) {
          this.target.scaleX = this._startScaleX + this._deltaX * dt;
          this.target.scaleY = this._startScaleY + this._deltaY * dt;
        }
      }
    });
    cc.scaleTo = function(duration, sx, sy) {
      return new cc.ScaleTo(duration, sx, sy);
    };
    cc.ScaleBy = cc.Class({
      name: "cc.ScaleBy",
      extends: cc.ScaleTo,
      startWithTarget: function startWithTarget(target) {
        cc.ScaleTo.prototype.startWithTarget.call(this, target);
        this._deltaX = this._startScaleX * this._endScaleX - this._startScaleX;
        this._deltaY = this._startScaleY * this._endScaleY - this._startScaleY;
      },
      reverse: function reverse() {
        var action = new cc.ScaleBy(this._duration, 1 / this._endScaleX, 1 / this._endScaleY);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.ScaleBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._endScaleX, this._endScaleY);
        return action;
      }
    });
    cc.scaleBy = function(duration, sx, sy) {
      return new cc.ScaleBy(duration, sx, sy);
    };
    cc.Blink = cc.Class({
      name: "cc.Blink",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, blinks) {
        this._times = 0;
        this._originalState = false;
        void 0 !== blinks && this.initWithDuration(duration, blinks);
      },
      initWithDuration: function initWithDuration(duration, blinks) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._times = blinks;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.Blink();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._times);
        return action;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        if (this.target && !this.isDone()) {
          var slice = 1 / this._times;
          var m = dt % slice;
          this.target.opacity = m > slice / 2 ? 255 : 0;
        }
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._originalState = target.opacity;
      },
      stop: function stop() {
        this.target.opacity = this._originalState;
        cc.ActionInterval.prototype.stop.call(this);
      },
      reverse: function reverse() {
        var action = new cc.Blink(this._duration, this._times);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.blink = function(duration, blinks) {
      return new cc.Blink(duration, blinks);
    };
    cc.FadeTo = cc.Class({
      name: "cc.FadeTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, opacity) {
        this._toOpacity = 0;
        this._fromOpacity = 0;
        void 0 !== opacity && cc.FadeTo.prototype.initWithDuration.call(this, duration, opacity);
      },
      initWithDuration: function initWithDuration(duration, opacity) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._toOpacity = opacity;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.FadeTo();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      },
      update: function update(time) {
        time = this._computeEaseTime(time);
        var fromOpacity = void 0 !== this._fromOpacity ? this._fromOpacity : 255;
        this.target.opacity = fromOpacity + (this._toOpacity - fromOpacity) * time;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._fromOpacity = target.opacity;
      }
    });
    cc.fadeTo = function(duration, opacity) {
      return new cc.FadeTo(duration, opacity);
    };
    cc.FadeIn = cc.Class({
      name: "cc.FadeIn",
      extends: cc.FadeTo,
      ctor: function ctor(duration) {
        null == duration && (duration = 0);
        this._reverseAction = null;
        this.initWithDuration(duration, 255);
      },
      reverse: function reverse() {
        var action = new cc.FadeOut();
        action.initWithDuration(this._duration, 0);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.FadeIn();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        this._reverseAction && (this._toOpacity = this._reverseAction._fromOpacity);
        cc.FadeTo.prototype.startWithTarget.call(this, target);
      }
    });
    cc.fadeIn = function(duration) {
      return new cc.FadeIn(duration);
    };
    cc.FadeOut = cc.Class({
      name: "cc.FadeOut",
      extends: cc.FadeTo,
      ctor: function ctor(duration) {
        null == duration && (duration = 0);
        this._reverseAction = null;
        this.initWithDuration(duration, 0);
      },
      reverse: function reverse() {
        var action = new cc.FadeIn();
        action._reverseAction = this;
        action.initWithDuration(this._duration, 255);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.FadeOut();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._toOpacity);
        return action;
      }
    });
    cc.fadeOut = function(d) {
      return new cc.FadeOut(d);
    };
    cc.TintTo = cc.Class({
      name: "cc.TintTo",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, red, green, blue) {
        this._to = cc.color(0, 0, 0);
        this._from = cc.color(0, 0, 0);
        if (red instanceof cc.Color) {
          blue = red.b;
          green = red.g;
          red = red.r;
        }
        void 0 !== blue && this.initWithDuration(duration, red, green, blue);
      },
      initWithDuration: function initWithDuration(duration, red, green, blue) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._to = cc.color(red, green, blue);
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.TintTo();
        this._cloneDecoration(action);
        var locTo = this._to;
        action.initWithDuration(this._duration, locTo.r, locTo.g, locTo.b);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._from = this.target.color;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        var locFrom = this._from, locTo = this._to;
        locFrom && (this.target.color = cc.color(locFrom.r + (locTo.r - locFrom.r) * dt, locFrom.g + (locTo.g - locFrom.g) * dt, locFrom.b + (locTo.b - locFrom.b) * dt));
      }
    });
    cc.tintTo = function(duration, red, green, blue) {
      return new cc.TintTo(duration, red, green, blue);
    };
    cc.TintBy = cc.Class({
      name: "cc.TintBy",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, deltaRed, deltaGreen, deltaBlue) {
        this._deltaR = 0;
        this._deltaG = 0;
        this._deltaB = 0;
        this._fromR = 0;
        this._fromG = 0;
        this._fromB = 0;
        void 0 !== deltaBlue && this.initWithDuration(duration, deltaRed, deltaGreen, deltaBlue);
      },
      initWithDuration: function initWithDuration(duration, deltaRed, deltaGreen, deltaBlue) {
        if (cc.ActionInterval.prototype.initWithDuration.call(this, duration)) {
          this._deltaR = deltaRed;
          this._deltaG = deltaGreen;
          this._deltaB = deltaBlue;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.TintBy();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration, this._deltaR, this._deltaG, this._deltaB);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var color = target.color;
        this._fromR = color.r;
        this._fromG = color.g;
        this._fromB = color.b;
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this.target.color = cc.color(this._fromR + this._deltaR * dt, this._fromG + this._deltaG * dt, this._fromB + this._deltaB * dt);
      },
      reverse: function reverse() {
        var action = new cc.TintBy(this._duration, -this._deltaR, -this._deltaG, -this._deltaB);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      }
    });
    cc.tintBy = function(duration, deltaRed, deltaGreen, deltaBlue) {
      return new cc.TintBy(duration, deltaRed, deltaGreen, deltaBlue);
    };
    cc.DelayTime = cc.Class({
      name: "cc.DelayTime",
      extends: cc.ActionInterval,
      update: function update(dt) {},
      reverse: function reverse() {
        var action = new cc.DelayTime(this._duration);
        this._cloneDecoration(action);
        this._reverseEaseList(action);
        return action;
      },
      clone: function clone() {
        var action = new cc.DelayTime();
        this._cloneDecoration(action);
        action.initWithDuration(this._duration);
        return action;
      }
    });
    cc.delayTime = function(d) {
      return new cc.DelayTime(d);
    };
    cc.ReverseTime = cc.Class({
      name: "cc.ReverseTime",
      extends: cc.ActionInterval,
      ctor: function ctor(action) {
        this._other = null;
        action && this.initWithAction(action);
      },
      initWithAction: function initWithAction(action) {
        if (!action) {
          cc.errorID(1028);
          return false;
        }
        if (action === this._other) {
          cc.errorID(1029);
          return false;
        }
        if (cc.ActionInterval.prototype.initWithDuration.call(this, action._duration)) {
          this._other = action;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.ReverseTime();
        this._cloneDecoration(action);
        action.initWithAction(this._other.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._other.startWithTarget(target);
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this._other && this._other.update(1 - dt);
      },
      reverse: function reverse() {
        return this._other.clone();
      },
      stop: function stop() {
        this._other.stop();
        cc.Action.prototype.stop.call(this);
      }
    });
    cc.reverseTime = function(action) {
      return new cc.ReverseTime(action);
    };
    cc.TargetedAction = cc.Class({
      name: "cc.TargetedAction",
      extends: cc.ActionInterval,
      ctor: function ctor(target, action) {
        this._action = null;
        this._forcedTarget = null;
        action && this.initWithTarget(target, action);
      },
      initWithTarget: function initWithTarget(target, action) {
        if (this.initWithDuration(action._duration)) {
          this._forcedTarget = target;
          this._action = action;
          return true;
        }
        return false;
      },
      clone: function clone() {
        var action = new cc.TargetedAction();
        this._cloneDecoration(action);
        action.initWithTarget(this._forcedTarget, this._action.clone());
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        this._action.startWithTarget(this._forcedTarget);
      },
      stop: function stop() {
        this._action.stop();
      },
      update: function update(dt) {
        dt = this._computeEaseTime(dt);
        this._action.update(dt);
      },
      getForcedTarget: function getForcedTarget() {
        return this._forcedTarget;
      },
      setForcedTarget: function setForcedTarget(forcedTarget) {
        this._forcedTarget !== forcedTarget && (this._forcedTarget = forcedTarget);
      }
    });
    cc.targetedAction = function(target, action) {
      return new cc.TargetedAction(target, action);
    };
  }), {} ],
  7: [ (function(require, module, exports) {
    "use strict";
    require("../core/platform/CCClass");
    var js = require("../core/platform/js");
    var HashElement = function HashElement() {
      this.actions = [];
      this.target = null;
      this.actionIndex = 0;
      this.currentAction = null;
      this.paused = false;
      this.lock = false;
    };
    cc.ActionManager = function() {
      this._hashTargets = js.createMap(true);
      this._arrayTargets = [];
      this._currentTarget = null;
      cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
    };
    cc.ActionManager.prototype = {
      constructor: cc.ActionManager,
      _elementPool: [],
      _searchElementByTarget: function _searchElementByTarget(arr, target) {
        for (var k = 0; k < arr.length; k++) if (target === arr[k].target) return arr[k];
        return null;
      },
      _getElement: function _getElement(target, paused) {
        var element = this._elementPool.pop();
        element || (element = new HashElement());
        element.target = target;
        element.paused = !!paused;
        return element;
      },
      _putElement: function _putElement(element) {
        element.actions.length = 0;
        element.actionIndex = 0;
        element.currentAction = null;
        element.paused = false;
        element.target = null;
        element.lock = false;
        this._elementPool.push(element);
      },
      addAction: function addAction(action, target, paused) {
        if (!action || !target) {
          cc.errorID(1e3);
          return;
        }
        var element = this._hashTargets[target._id];
        if (element) element.actions || (element.actions = []); else {
          element = this._getElement(target, paused);
          this._hashTargets[target._id] = element;
          this._arrayTargets.push(element);
        }
        element.actions.push(action);
        action.startWithTarget(target);
      },
      removeAllActions: function removeAllActions() {
        var locTargets = this._arrayTargets;
        for (var i = 0; i < locTargets.length; i++) {
          var element = locTargets[i];
          element && this._putElement(element);
        }
        this._arrayTargets.length = 0;
        this._hashTargets = js.createMap(true);
      },
      removeAllActionsFromTarget: function removeAllActionsFromTarget(target, forceDelete) {
        if (null == target) return;
        var element = this._hashTargets[target._id];
        if (element) {
          element.actions.length = 0;
          this._deleteHashElement(element);
        }
      },
      removeAction: function removeAction(action) {
        if (!action) return;
        var target = action.getOriginalTarget();
        var element = this._hashTargets[target._id];
        if (!element) return;
        for (var i = 0; i < element.actions.length; i++) if (element.actions[i] === action) {
          element.actions.splice(i, 1);
          element.actionIndex >= i && element.actionIndex--;
          break;
        }
      },
      _removeActionByTag: function _removeActionByTag(tag, element, target) {
        for (var i = 0, l = element.actions.length; i < l; ++i) {
          var action = element.actions[i];
          if (action && action.getTag() === tag) {
            if (target && action.getOriginalTarget() !== target) continue;
            this._removeActionAtIndex(i, element);
            break;
          }
        }
      },
      removeActionByTag: function removeActionByTag(tag, target) {
        tag === cc.Action.TAG_INVALID && cc.logID(1002);
        var hashTargets = this._hashTargets;
        if (target) {
          var element = hashTargets[target._id];
          element && this._removeActionByTag(tag, element, target);
        } else for (var name in hashTargets) {
          var _element = hashTargets[name];
          this._removeActionByTag(tag, _element);
        }
      },
      getActionByTag: function getActionByTag(tag, target) {
        tag === cc.Action.TAG_INVALID && cc.logID(1004);
        var element = this._hashTargets[target._id];
        if (element) {
          if (null != element.actions) for (var i = 0; i < element.actions.length; ++i) {
            var action = element.actions[i];
            if (action && action.getTag() === tag) return action;
          }
          cc.logID(1005, tag);
        }
        return null;
      },
      getNumberOfRunningActionsInTarget: function getNumberOfRunningActionsInTarget(target) {
        var element = this._hashTargets[target._id];
        if (element) return element.actions ? element.actions.length : 0;
        return 0;
      },
      pauseTarget: function pauseTarget(target) {
        var element = this._hashTargets[target._id];
        element && (element.paused = true);
      },
      resumeTarget: function resumeTarget(target) {
        var element = this._hashTargets[target._id];
        element && (element.paused = false);
      },
      pauseAllRunningActions: function pauseAllRunningActions() {
        var idsWithActions = [];
        var locTargets = this._arrayTargets;
        for (var i = 0; i < locTargets.length; i++) {
          var element = locTargets[i];
          if (element && !element.paused) {
            element.paused = true;
            idsWithActions.push(element.target);
          }
        }
        return idsWithActions;
      },
      resumeTargets: function resumeTargets(targetsToResume) {
        if (!targetsToResume) return;
        for (var i = 0; i < targetsToResume.length; i++) targetsToResume[i] && this.resumeTarget(targetsToResume[i]);
      },
      pauseTargets: function pauseTargets(targetsToPause) {
        if (!targetsToPause) return;
        for (var i = 0; i < targetsToPause.length; i++) targetsToPause[i] && this.pauseTarget(targetsToPause[i]);
      },
      purgeSharedManager: function purgeSharedManager() {
        cc.director.getScheduler().unscheduleUpdate(this);
      },
      _removeActionAtIndex: function _removeActionAtIndex(index, element) {
        var action = element.actions[index];
        element.actions.splice(index, 1);
        element.actionIndex >= index && element.actionIndex--;
        0 === element.actions.length && this._deleteHashElement(element);
      },
      _deleteHashElement: function _deleteHashElement(element) {
        var ret = false;
        if (element && !element.lock && this._hashTargets[element.target._id]) {
          delete this._hashTargets[element.target._id];
          var targets = this._arrayTargets;
          for (var i = 0, l = targets.length; i < l; i++) if (targets[i] === element) {
            targets.splice(i, 1);
            break;
          }
          this._putElement(element);
          ret = true;
        }
        return ret;
      },
      update: function update(dt) {
        var locTargets = this._arrayTargets, locCurrTarget;
        for (var elt = 0; elt < locTargets.length; elt++) {
          this._currentTarget = locTargets[elt];
          locCurrTarget = this._currentTarget;
          if (!locCurrTarget.paused && locCurrTarget.actions) {
            locCurrTarget.lock = true;
            for (locCurrTarget.actionIndex = 0; locCurrTarget.actionIndex < locCurrTarget.actions.length; locCurrTarget.actionIndex++) {
              locCurrTarget.currentAction = locCurrTarget.actions[locCurrTarget.actionIndex];
              if (!locCurrTarget.currentAction) continue;
              locCurrTarget.currentAction.step(dt * (locCurrTarget.currentAction._speedMethod ? locCurrTarget.currentAction._speed : 1));
              if (locCurrTarget.currentAction && locCurrTarget.currentAction.isDone()) {
                locCurrTarget.currentAction.stop();
                var action = locCurrTarget.currentAction;
                locCurrTarget.currentAction = null;
                this.removeAction(action);
              }
              locCurrTarget.currentAction = null;
            }
            locCurrTarget.lock = false;
          }
          0 === locCurrTarget.actions.length && this._deleteHashElement(locCurrTarget) && elt--;
        }
      }
    };
    false;
  }), {
    "../core/platform/CCClass": 138,
    "../core/platform/js": 158
  } ],
  8: [ (function(require, module, exports) {
    "use strict";
    require("./CCActionManager");
    require("./CCAction");
    require("./CCActionInterval");
    require("./CCActionInstant");
    require("./CCActionEase");
    require("./CCActionCatmullRom");
    require("./tween");
  }), {
    "./CCAction": 2,
    "./CCActionCatmullRom": 3,
    "./CCActionEase": 4,
    "./CCActionInstant": 5,
    "./CCActionInterval": 6,
    "./CCActionManager": 7,
    "./tween": 9
  } ],
  9: [ (function(require, module, exports) {
    "use strict";
    var _bezier = require("../animation/bezier");
    var _tweenID = 0;
    var TweenAction = cc.Class({
      name: "cc.TweenAction",
      extends: cc.ActionInterval,
      ctor: function ctor(duration, props, opts) {
        this._opts = opts = opts || Object.create(null);
        this._props = Object.create(null);
        opts.progress = opts.progress || this.progress;
        if (opts.easing && "string" === typeof opts.easing) {
          var easingName = opts.easing;
          opts.easing = cc.easing[easingName];
          !opts.easing && cc.warnID(1031, easingName);
        }
        var relative = this._opts.relative;
        for (var name in props) {
          var value = props[name];
          var easing = void 0, progress = void 0;
          if (void 0 !== value.value && (value.easing || value.progress)) {
            if ("string" === typeof value.easing) {
              easing = cc.easing[value.easing];
              !easing && cc.warnID(1031, value.easing);
            } else easing = value.easing;
            progress = value.progress;
            value = value.value;
          }
          var isNumber = "number" === typeof value;
          if (!isNumber && (!value.lerp || relative && !value.add && !value.mul || !value.clone)) {
            cc.warn("Can not animate " + name + " property, because it do not have [lerp, (add|mul), clone] function.");
            continue;
          }
          var prop = Object.create(null);
          prop.value = value;
          prop.easing = easing;
          prop.progress = progress;
          this._props[name] = prop;
        }
        this._originProps = props;
        this.initWithDuration(duration);
      },
      clone: function clone() {
        var action = new TweenAction(this._duration, this._originProps, this._opts);
        this._cloneDecoration(action);
        return action;
      },
      startWithTarget: function startWithTarget(target) {
        cc.ActionInterval.prototype.startWithTarget.call(this, target);
        var relative = !!this._opts.relative;
        var props = this._props;
        for (var name in props) {
          var value = target[name];
          var prop = props[name];
          if ("number" === typeof value) {
            prop.start = value;
            prop.current = value;
            prop.end = relative ? value + prop.value : prop.value;
          } else {
            prop.start = value.clone();
            prop.current = value.clone();
            prop.end = relative ? (value.add || value.mul).call(value, prop.value) : prop.value;
          }
        }
      },
      update: function update(t) {
        var opts = this._opts;
        var easingTime = t;
        opts.easing && (easingTime = opts.easing(t));
        var target = this.target;
        if (!target) return;
        var props = this._props;
        var progress = this._opts.progress;
        for (var name in props) {
          var prop = props[name];
          var time = prop.easing ? prop.easing(t) : easingTime;
          var current = prop.current = (prop.progress || progress)(prop.start, prop.end, prop.current, time);
          target[name] = current;
        }
      },
      progress: function progress(start, end, current, t) {
        "number" === typeof start ? current = start + (end - start) * t : start.lerp(end, t, current);
        return current;
      }
    });
    var SetAction = cc.Class({
      name: "cc.SetAction",
      extends: cc.ActionInstant,
      ctor: function ctor(props) {
        this._props = {};
        void 0 !== props && this.init(props);
      },
      init: function init(props) {
        for (var name in props) this._props[name] = props[name];
        return true;
      },
      update: function update() {
        var props = this._props;
        var target = this.target;
        for (var name in props) target[name] = props[name];
      },
      clone: function clone() {
        var action = new SetAction();
        action.init(this._props);
        return action;
      }
    });
    function Tween(target) {
      this._actions = [];
      this._finalAction = null;
      this._target = target;
      this._tag = cc.Action.TAG_INVALID;
    }
    Tween.stopAll = function() {
      cc.director.getActionManager().removeAllActions();
    };
    Tween.stopAllByTag = function(tag) {
      cc.director.getActionManager().removeActionByTag(tag);
    };
    Tween.stopAllByTarget = function(target) {
      cc.director.getActionManager().removeAllActionsFromTarget(target);
    };
    Tween.prototype.then = function(other) {
      other instanceof cc.Action ? this._actions.push(other.clone()) : this._actions.push(other._union());
      return this;
    };
    Tween.prototype.target = function(target) {
      this._target = target;
      return this;
    };
    Tween.prototype.start = function() {
      var target = this._target;
      if (!target) {
        cc.warn("Please set target to tween first");
        return this;
      }
      if (target instanceof cc.Object && !target.isValid) return;
      this._finalAction && cc.director.getActionManager().removeAction(this._finalAction);
      this._finalAction = this._union();
      void 0 === target._id && (target._id = ++_tweenID);
      this._finalAction.setTag(this._tag);
      cc.director.getActionManager().addAction(this._finalAction, target, false);
      return this;
    };
    Tween.prototype.stop = function() {
      this._finalAction && cc.director.getActionManager().removeAction(this._finalAction);
      return this;
    };
    Tween.prototype.tag = function(tag) {
      this._tag = tag;
      return this;
    };
    Tween.prototype.clone = function(target) {
      var action = this._union();
      return cc.tween(target).then(action.clone());
    };
    Tween.prototype.union = function() {
      var action = this._union();
      this._actions.length = 0;
      this._actions.push(action);
      return this;
    };
    Tween.prototype._union = function() {
      var actions = this._actions;
      actions = 1 === actions.length ? actions[0] : cc.sequence(actions);
      return actions;
    };
    Object.assign(Tween.prototype, {
      bezierTo: function bezierTo(duration, c1, c2, to, opts) {
        var c0x = c1.x, c0y = c1.y, c1x = c2.x, c1y = c2.y;
        opts = opts || Object.create(null);
        opts.progress = function(start, end, current, t) {
          current.x = (0, _bezier.bezier)(start.x, c0x, c1x, end.x, t);
          current.y = (0, _bezier.bezier)(start.y, c0y, c1y, end.y, t);
          return current;
        };
        return this.to(duration, {
          position: to
        }, opts);
      },
      bezierBy: function bezierBy(duration, c1, c2, to, opts) {
        var c0x = c1.x, c0y = c1.y, c1x = c2.x, c1y = c2.y;
        opts = opts || Object.create(null);
        opts.progress = function(start, end, current, t) {
          var sx = start.x, sy = start.y;
          current.x = (0, _bezier.bezier)(sx, c0x + sx, c1x + sx, end.x, t);
          current.y = (0, _bezier.bezier)(sy, c0y + sy, c1y + sy, end.y, t);
          return current;
        };
        return this.by(duration, {
          position: to
        }, opts);
      },
      flipX: function flipX() {
        var _this = this;
        return this.call((function() {
          _this._target.scaleX *= -1;
        }), this);
      },
      flipY: function flipY() {
        var _this2 = this;
        return this.call((function() {
          _this2._target.scaleY *= -1;
        }), this);
      },
      blink: function blink(duration, times, opts) {
        var slice = 1 / times;
        opts = opts || Object.create(null);
        opts.progress = function(start, end, current, t) {
          if (t >= 1) return start;
          var m = t % slice;
          return m > slice / 2 ? 255 : 0;
        };
        return this.to(duration, {
          opacity: 1
        }, opts);
      }
    });
    var tmp_args = [];
    function wrapAction(action) {
      return function() {
        tmp_args.length = 0;
        for (var l = arguments.length, i = 0; i < l; i++) {
          var arg = tmp_args[i] = arguments[i];
          arg instanceof Tween && (tmp_args[i] = arg._union());
        }
        return action.apply(this, tmp_args);
      };
    }
    var actions = {
      to: function to(duration, props, opts) {
        opts = opts || Object.create(null);
        opts.relative = false;
        return new TweenAction(duration, props, opts);
      },
      by: function by(duration, props, opts) {
        opts = opts || Object.create(null);
        opts.relative = true;
        return new TweenAction(duration, props, opts);
      },
      set: function set(props) {
        return new SetAction(props);
      },
      delay: cc.delayTime,
      call: cc.callFunc,
      hide: cc.hide,
      show: cc.show,
      removeSelf: cc.removeSelf,
      sequence: wrapAction(cc.sequence),
      parallel: wrapAction(cc.spawn)
    };
    var previousAsInputActions = {
      repeat: cc.repeat,
      repeatForever: function repeatForever(action) {
        return cc.repeat(action, 1e9);
      },
      reverseTime: cc.reverseTime
    };
    var keys = Object.keys(actions);
    var _loop = function _loop(i) {
      var key = keys[i];
      Tween.prototype[key] = function() {
        var action = actions[key].apply(this, arguments);
        this._actions.push(action);
        return this;
      };
    };
    for (var i = 0; i < keys.length; i++) _loop(i);
    keys = Object.keys(previousAsInputActions);
    var _loop2 = function _loop2(_i) {
      var key = keys[_i];
      Tween.prototype[key] = function() {
        var actions = this._actions;
        var action = arguments[arguments.length - 1];
        var length = arguments.length - 1;
        if (action instanceof cc.Tween) action = action._union(); else if (!(action instanceof cc.Action)) {
          action = actions[actions.length - 1];
          actions.length -= 1;
          length += 1;
        }
        var args = [ action ];
        for (var _i2 = 0; _i2 < length; _i2++) args.push(arguments[_i2]);
        action = previousAsInputActions[key].apply(this, args);
        actions.push(action);
        return this;
      };
    };
    for (var _i = 0; _i < keys.length; _i++) _loop2(_i);
    cc.tween = function(target) {
      return new Tween(target);
    };
    cc.Tween = Tween;
  }), {
    "../animation/bezier": 15
  } ],
  10: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var Playable = require("./playable");
    var _require = require("./animation-curves"), EventAnimCurve = _require.EventAnimCurve, EventInfo = _require.EventInfo;
    var WrapModeMask = require("./types").WrapModeMask;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    function AnimationAnimator(target, animation) {
      Playable.call(this);
      this.target = target;
      this.animation = animation;
      this._anims = new js.array.MutableForwardIterator([]);
    }
    js.extend(AnimationAnimator, Playable);
    var p = AnimationAnimator.prototype;
    p.playState = function(state, startTime) {
      if (!state.clip) return;
      state.curveLoaded || initClipData(this.target, state);
      state.animator = this;
      state.play();
      "number" === typeof startTime && state.setTime(startTime);
      this.play();
    };
    p.stopStatesExcept = function(state) {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        if (anim === state) continue;
        this.stopState(anim);
      }
    };
    p.addAnimation = function(anim) {
      var index = this._anims.array.indexOf(anim);
      -1 === index && this._anims.push(anim);
      anim._setEventTarget(this.animation);
    };
    p.removeAnimation = function(anim) {
      var index = this._anims.array.indexOf(anim);
      if (index >= 0) {
        this._anims.fastRemoveAt(index);
        0 === this._anims.array.length && this.stop();
      } else cc.errorID(3907);
      anim.animator = null;
    };
    p.sample = function() {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        anim.sample();
      }
    };
    p.stopState = function(state) {
      state && state.stop();
    };
    p.pauseState = function(state) {
      state && state.pause();
    };
    p.resumeState = function(state) {
      state && state.resume();
      this.isPaused && this.resume();
    };
    p.setStateTime = function(state, time) {
      if (void 0 !== time) {
        if (state) {
          state.setTime(time);
          state.sample();
        }
      } else {
        time = state;
        var array = this._anims.array;
        for (var i = 0; i < array.length; ++i) {
          var anim = array[i];
          anim.setTime(time);
          anim.sample();
        }
      }
    };
    p.onStop = function() {
      var iterator = this._anims;
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var anim = array[iterator.i];
        anim.stop();
      }
    };
    p.onPause = function() {
      var array = this._anims.array;
      for (var i = 0; i < array.length; ++i) {
        var anim = array[i];
        anim.pause();
        anim.animator = null;
      }
    };
    p.onResume = function() {
      var array = this._anims.array;
      for (var i = 0; i < array.length; ++i) {
        var anim = array[i];
        anim.animator = this;
        anim.resume();
      }
    };
    p._reloadClip = function(state) {
      initClipData(this.target, state);
    };
    function createBatchedProperty(propPath, firstDotIndex, mainValue, animValue) {
      mainValue = mainValue.clone();
      var nextValue = mainValue;
      var leftIndex = firstDotIndex + 1;
      var rightIndex = propPath.indexOf(".", leftIndex);
      while (-1 !== rightIndex) {
        var nextName = propPath.slice(leftIndex, rightIndex);
        nextValue = nextValue[nextName];
        leftIndex = rightIndex + 1;
        rightIndex = propPath.indexOf(".", leftIndex);
      }
      var lastPropName = propPath.slice(leftIndex);
      nextValue[lastPropName] = animValue;
      return mainValue;
    }
    false;
    function initClipData(root, state) {
      var clip = state.clip;
      state.duration = clip.duration;
      state.speed = clip.speed;
      state.wrapMode = clip.wrapMode;
      state.frameRate = clip.sample;
      (state.wrapMode & WrapModeMask.Loop) === WrapModeMask.Loop ? state.repeatCount = Infinity : state.repeatCount = 1;
      var curves = state.curves = clip.createCurves(state, root);
      var events = clip.events;
      if (true, events) {
        var curve;
        for (var i = 0, l = events.length; i < l; i++) {
          if (!curve) {
            curve = new EventAnimCurve();
            curve.target = root;
            curves.push(curve);
          }
          var eventData = events[i];
          var ratio = eventData.frame / state.duration;
          var eventInfo = void 0;
          var index = binarySearch(curve.ratios, ratio);
          if (index >= 0) eventInfo = curve.events[index]; else {
            eventInfo = new EventInfo();
            curve.ratios.push(ratio);
            curve.events.push(eventInfo);
          }
          eventInfo.add(eventData.func, eventData.params);
        }
      }
    }
    false;
    module.exports = AnimationAnimator;
  }), {
    "../core/utils/binary-search": 202,
    "./animation-curves": 12,
    "./playable": 19,
    "./types": 20
  } ],
  11: [ (function(require, module, exports) {
    "use strict";
    var WrapMode = require("./types").WrapMode;
    var _require = require("./animation-curves"), DynamicAnimCurve = _require.DynamicAnimCurve, quickFindIndex = _require.quickFindIndex;
    var sampleMotionPaths = require("./motion-path-helper").sampleMotionPaths;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var AnimationClip = cc.Class({
      name: "cc.AnimationClip",
      extends: cc.Asset,
      properties: {
        _duration: {
          default: 0,
          type: cc.Float
        },
        duration: {
          get: function get() {
            return this._duration;
          }
        },
        sample: {
          default: 60
        },
        speed: {
          default: 1
        },
        wrapMode: {
          default: WrapMode.Normal
        },
        curveData: {
          default: {},
          visible: false
        },
        events: {
          default: [],
          visible: false
        }
      },
      statics: {
        createWithSpriteFrames: function createWithSpriteFrames(spriteFrames, sample) {
          if (!Array.isArray(spriteFrames)) {
            cc.errorID(3905);
            return null;
          }
          var clip = new AnimationClip();
          clip.sample = sample || clip.sample;
          clip._duration = spriteFrames.length / clip.sample;
          var frames = [];
          var step = 1 / clip.sample;
          for (var i = 0, l = spriteFrames.length; i < l; i++) frames[i] = {
            frame: i * step,
            value: spriteFrames[i]
          };
          clip.curveData = {
            comps: {
              "cc.Sprite": {
                spriteFrame: frames
              }
            }
          };
          return clip;
        }
      },
      onLoad: function onLoad() {
        this._duration = Number.parseFloat(this.duration);
        this.speed = Number.parseFloat(this.speed);
        this.wrapMode = Number.parseInt(this.wrapMode);
        this.frameRate = Number.parseFloat(this.sample);
      },
      createPropCurve: function createPropCurve(target, propPath, keyframes) {
        var motionPaths = [];
        var isMotionPathProp = target instanceof cc.Node && "position" === propPath;
        var curve = new DynamicAnimCurve();
        curve.target = target;
        curve.prop = propPath;
        for (var i = 0, l = keyframes.length; i < l; i++) {
          var keyframe = keyframes[i];
          var ratio = keyframe.frame / this.duration;
          curve.ratios.push(ratio);
          isMotionPathProp && motionPaths.push(keyframe.motionPath);
          var curveValue = keyframe.value;
          curve.values.push(curveValue);
          var curveTypes = keyframe.curve;
          if (curveTypes) {
            if ("string" === typeof curveTypes) {
              curve.types.push(curveTypes);
              continue;
            }
            if (Array.isArray(curveTypes)) {
              curveTypes[0] === curveTypes[1] && curveTypes[2] === curveTypes[3] ? curve.types.push(DynamicAnimCurve.Linear) : curve.types.push(DynamicAnimCurve.Bezier(curveTypes));
              continue;
            }
          }
          curve.types.push(DynamicAnimCurve.Linear);
        }
        isMotionPathProp && sampleMotionPaths(motionPaths, curve, this.duration, this.sample, target);
        var ratios = curve.ratios;
        var currRatioDif, lastRatioDif;
        var canOptimize = true;
        var EPSILON = 1e-6;
        for (var _i = 1, _l = ratios.length; _i < _l; _i++) {
          currRatioDif = ratios[_i] - ratios[_i - 1];
          if (1 === _i) lastRatioDif = currRatioDif; else if (Math.abs(currRatioDif - lastRatioDif) > EPSILON) {
            canOptimize = false;
            break;
          }
        }
        curve._findFrameIndex = canOptimize ? quickFindIndex : binarySearch;
        var firstValue = curve.values[0];
        void 0 === firstValue || null === firstValue || curve._lerp || ("number" === typeof firstValue ? curve._lerp = DynamicAnimCurve.prototype._lerpNumber : firstValue instanceof cc.Quat ? curve._lerp = DynamicAnimCurve.prototype._lerpQuat : firstValue instanceof cc.Vec2 ? curve._lerp = DynamicAnimCurve.prototype._lerpVector2 : firstValue instanceof cc.Vec3 ? curve._lerp = DynamicAnimCurve.prototype._lerpVector3 : firstValue.lerp && (curve._lerp = DynamicAnimCurve.prototype._lerpObject));
        return curve;
      },
      createTargetCurves: function createTargetCurves(target, curveData, curves) {
        var propsData = curveData.props;
        var compsData = curveData.comps;
        if (propsData) for (var propPath in propsData) {
          var data = propsData[propPath];
          var curve = this.createPropCurve(target, propPath, data);
          curves.push(curve);
        }
        if (compsData) for (var compName in compsData) {
          var comp = target.getComponent(compName);
          if (!comp) continue;
          var compData = compsData[compName];
          for (var _propPath in compData) {
            var _data = compData[_propPath];
            var _curve = this.createPropCurve(comp, _propPath, _data);
            curves.push(_curve);
          }
        }
      },
      createCurves: function createCurves(state, root) {
        var curveData = this.curveData;
        var childrenCurveDatas = curveData.paths;
        var curves = [];
        this.createTargetCurves(root, curveData, curves);
        for (var namePath in childrenCurveDatas) {
          var target = cc.find(namePath, root);
          if (!target) continue;
          var childCurveDatas = childrenCurveDatas[namePath];
          this.createTargetCurves(target, childCurveDatas, curves);
        }
        return curves;
      }
    });
    cc.AnimationClip = module.exports = AnimationClip;
  }), {
    "../core/utils/binary-search": 202,
    "./animation-curves": 12,
    "./motion-path-helper": 18,
    "./types": 20
  } ],
  12: [ (function(require, module, exports) {
    "use strict";
    var bezierByTime = require("./bezier").bezierByTime;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var WrapModeMask = require("./types").WrapModeMask;
    var WrappedInfo = require("./types").WrappedInfo;
    function computeRatioByType(ratio, type) {
      if ("string" === typeof type) {
        var func = cc.easing[type];
        func ? ratio = func(ratio) : cc.errorID(3906, type);
      } else Array.isArray(type) && (ratio = bezierByTime(type, ratio));
      return ratio;
    }
    var AnimCurve = cc.Class({
      name: "cc.AnimCurve",
      sample: function sample(time, ratio, state) {},
      onTimeChangedManually: void 0
    });
    function quickFindIndex(ratios, ratio) {
      var length = ratios.length - 1;
      if (0 === length) return 0;
      var start = ratios[0];
      if (ratio < start) return 0;
      var end = ratios[length];
      if (ratio > end) return ~ratios.length;
      ratio = (ratio - start) / (end - start);
      var eachLength = 1 / length;
      var index = ratio / eachLength;
      var floorIndex = 0 | index;
      var EPSILON = 1e-6;
      if (index - floorIndex < EPSILON) return floorIndex;
      if (floorIndex + 1 - index < EPSILON) return floorIndex + 1;
      return ~(floorIndex + 1);
    }
    var DynamicAnimCurve = cc.Class({
      name: "cc.DynamicAnimCurve",
      extends: AnimCurve,
      ctor: function ctor() {
        this._cachedIndex = 0;
      },
      properties: {
        target: null,
        prop: "",
        values: [],
        ratios: [],
        types: []
      },
      _findFrameIndex: binarySearch,
      _lerp: void 0,
      _lerpNumber: function _lerpNumber(from, to, t) {
        return from + (to - from) * t;
      },
      _lerpObject: function _lerpObject(from, to, t) {
        return from.lerp(to, t);
      },
      _lerpQuat: (function() {
        var out = cc.quat();
        return function(from, to, t) {
          return from.lerp(to, t, out);
        };
      })(),
      _lerpVector2: (function() {
        var out = cc.v2();
        return function(from, to, t) {
          return from.lerp(to, t, out);
        };
      })(),
      _lerpVector3: (function() {
        var out = cc.v3();
        return function(from, to, t) {
          return from.lerp(to, t, out);
        };
      })(),
      sample: function sample(time, ratio, state) {
        var values = this.values;
        var ratios = this.ratios;
        var frameCount = ratios.length;
        if (0 === frameCount) return;
        var shoudRefind = true;
        var cachedIndex = this._cachedIndex;
        if (cachedIndex < 0) {
          cachedIndex = ~cachedIndex;
          if (cachedIndex > 0 && cachedIndex < ratios.length) {
            var _fromRatio = ratios[cachedIndex - 1];
            var _toRatio = ratios[cachedIndex];
            ratio > _fromRatio && ratio < _toRatio && (shoudRefind = false);
          }
        }
        shoudRefind && (this._cachedIndex = this._findFrameIndex(ratios, ratio));
        var value;
        var index = this._cachedIndex;
        if (index < 0) {
          index = ~index;
          if (index <= 0) value = values[0]; else if (index >= frameCount) value = values[frameCount - 1]; else {
            var fromVal = values[index - 1];
            if (this._lerp) {
              var fromRatio = ratios[index - 1];
              var toRatio = ratios[index];
              var type = this.types[index - 1];
              var ratioBetweenFrames = (ratio - fromRatio) / (toRatio - fromRatio);
              type && (ratioBetweenFrames = computeRatioByType(ratioBetweenFrames, type));
              var toVal = values[index];
              value = this._lerp(fromVal, toVal, ratioBetweenFrames);
            } else value = fromVal;
          }
        } else value = values[index];
        this.target[this.prop] = value;
      }
    });
    DynamicAnimCurve.Linear = null;
    DynamicAnimCurve.Bezier = function(controlPoints) {
      return controlPoints;
    };
    var EventInfo = function EventInfo() {
      this.events = [];
    };
    EventInfo.prototype.add = function(func, params) {
      this.events.push({
        func: func || "",
        params: params || []
      });
    };
    var EventAnimCurve = cc.Class({
      name: "cc.EventAnimCurve",
      extends: AnimCurve,
      properties: {
        target: null,
        ratios: [],
        events: [],
        _wrappedInfo: {
          default: function _default() {
            return new WrappedInfo();
          }
        },
        _lastWrappedInfo: null,
        _ignoreIndex: NaN
      },
      _wrapIterations: function _wrapIterations(iterations) {
        iterations - (0 | iterations) === 0 && (iterations -= 1);
        return 0 | iterations;
      },
      sample: function sample(time, ratio, state) {
        var length = this.ratios.length;
        var currentWrappedInfo = state.getWrappedInfo(state.time, this._wrappedInfo);
        var direction = currentWrappedInfo.direction;
        var currentIndex = binarySearch(this.ratios, currentWrappedInfo.ratio);
        if (currentIndex < 0) {
          currentIndex = ~currentIndex - 1;
          direction < 0 && (currentIndex += 1);
        }
        this._ignoreIndex !== currentIndex && (this._ignoreIndex = NaN);
        currentWrappedInfo.frameIndex = currentIndex;
        if (!this._lastWrappedInfo) {
          this._fireEvent(currentIndex);
          this._lastWrappedInfo = new WrappedInfo(currentWrappedInfo);
          return;
        }
        var wrapMode = state.wrapMode;
        var currentIterations = this._wrapIterations(currentWrappedInfo.iterations);
        var lastWrappedInfo = this._lastWrappedInfo;
        var lastIterations = this._wrapIterations(lastWrappedInfo.iterations);
        var lastIndex = lastWrappedInfo.frameIndex;
        var lastDirection = lastWrappedInfo.direction;
        var interationsChanged = -1 !== lastIterations && currentIterations !== lastIterations;
        if (lastIndex === currentIndex && interationsChanged && 1 === length) this._fireEvent(0); else if (lastIndex !== currentIndex || interationsChanged) {
          direction = lastDirection;
          do {
            if (lastIndex !== currentIndex) {
              if (-1 === direction && 0 === lastIndex && currentIndex > 0) {
                (wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong ? direction *= -1 : lastIndex = length;
                lastIterations++;
              } else if (1 === direction && lastIndex === length - 1 && currentIndex < length - 1) {
                (wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong ? direction *= -1 : lastIndex = -1;
                lastIterations++;
              }
              if (lastIndex === currentIndex) break;
              if (lastIterations > currentIterations) break;
            }
            lastIndex += direction;
            cc.director.getAnimationManager().pushDelayEvent(this, "_fireEvent", [ lastIndex ]);
          } while (lastIndex !== currentIndex && lastIndex > -1 && lastIndex < length);
        }
        this._lastWrappedInfo.set(currentWrappedInfo);
      },
      _fireEvent: function _fireEvent(index) {
        if (index < 0 || index >= this.events.length || this._ignoreIndex === index) return;
        var eventInfo = this.events[index];
        var events = eventInfo.events;
        if (!this.target.isValid) return;
        var components = this.target._components;
        for (var i = 0; i < events.length; i++) {
          var event = events[i];
          var funcName = event.func;
          for (var j = 0; j < components.length; j++) {
            var component = components[j];
            var func = component[funcName];
            func && func.apply(component, event.params);
          }
        }
      },
      onTimeChangedManually: function onTimeChangedManually(time, state) {
        this._lastWrappedInfo = null;
        this._ignoreIndex = NaN;
        var info = state.getWrappedInfo(time, this._wrappedInfo);
        var direction = info.direction;
        var frameIndex = binarySearch(this.ratios, info.ratio);
        if (frameIndex < 0) {
          frameIndex = ~frameIndex - 1;
          direction < 0 && (frameIndex += 1);
          this._ignoreIndex = frameIndex;
        }
      }
    });
    false;
    module.exports = {
      AnimCurve: AnimCurve,
      DynamicAnimCurve: DynamicAnimCurve,
      EventAnimCurve: EventAnimCurve,
      EventInfo: EventInfo,
      computeRatioByType: computeRatioByType,
      quickFindIndex: quickFindIndex
    };
  }), {
    "../core/utils/binary-search": 202,
    "./bezier": 15,
    "./types": 20
  } ],
  13: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var AnimationManager = cc.Class({
      ctor: function ctor() {
        this._anims = new js.array.MutableForwardIterator([]);
        this._delayEvents = [];
        cc.director._scheduler && cc.director._scheduler.enableForTarget(this);
      },
      update: function update(dt) {
        var iterator = this._anims;
        var array = iterator.array;
        for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
          var anim = array[iterator.i];
          anim._isPlaying && !anim._isPaused && anim.update(dt);
        }
        var events = this._delayEvents;
        for (var i = 0; i < events.length; i++) {
          var event = events[i];
          event.target[event.func].apply(event.target, event.args);
        }
        events.length = 0;
      },
      destruct: function destruct() {},
      addAnimation: function addAnimation(anim) {
        var index = this._anims.array.indexOf(anim);
        -1 === index && this._anims.push(anim);
      },
      removeAnimation: function removeAnimation(anim) {
        var index = this._anims.array.indexOf(anim);
        index >= 0 ? this._anims.fastRemoveAt(index) : cc.errorID(3907);
      },
      pushDelayEvent: function pushDelayEvent(target, func, args) {
        this._delayEvents.push({
          target: target,
          func: func,
          args: args
        });
      }
    });
    cc.AnimationManager = module.exports = AnimationManager;
  }), {} ],
  14: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var Playable = require("./playable");
    var Types = require("./types");
    var WrappedInfo = Types.WrappedInfo;
    var WrapMode = Types.WrapMode;
    var WrapModeMask = Types.WrapModeMask;
    function AnimationState(clip, name) {
      Playable.call(this);
      this._currentFramePlayed = false;
      this._delay = 0;
      this._delayTime = 0;
      this._wrappedInfo = new WrappedInfo();
      this._lastWrappedInfo = null;
      this._process = process;
      this._clip = clip;
      this._name = name || clip && clip.name;
      this.animator = null;
      this.curves = [];
      this.delay = 0;
      this.repeatCount = 1;
      this.duration = 1;
      this.speed = 1;
      this.wrapMode = WrapMode.Normal;
      this.time = 0;
      this._target = null;
      this._lastframeEventOn = false;
      this.emit = function() {
        var args = new Array(arguments.length);
        for (var i = 0, l = args.length; i < l; i++) args[i] = arguments[i];
        cc.director.getAnimationManager().pushDelayEvent(this, "_emit", args);
      };
    }
    js.extend(AnimationState, Playable);
    var proto = AnimationState.prototype;
    proto._emit = function(type, state) {
      this._target && this._target.isValid && this._target.emit(type, type, state);
    };
    proto.on = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._lastframeEventOn = true);
        return this._target.on(type, callback, target);
      }
      return null;
    };
    proto.once = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._lastframeEventOn = true);
        var self = this;
        return this._target.once(type, (function(event) {
          callback.call(target, event);
          self._lastframeEventOn = false;
        }));
      }
      return null;
    };
    proto.off = function(type, callback, target) {
      if (this._target && this._target.isValid) {
        "lastframe" === type && (this._target.hasEventListener(type) || (this._lastframeEventOn = false));
        this._target.off(type, callback, target);
      }
    };
    proto._setEventTarget = function(target) {
      this._target = target;
    };
    proto.onPlay = function() {
      this.setTime(0);
      this._delayTime = this._delay;
      cc.director.getAnimationManager().addAnimation(this);
      this.animator && this.animator.addAnimation(this);
      this.emit("play", this);
    };
    proto.onStop = function() {
      this.isPaused || cc.director.getAnimationManager().removeAnimation(this);
      this.animator && this.animator.removeAnimation(this);
      this.emit("stop", this);
    };
    proto.onResume = function() {
      cc.director.getAnimationManager().addAnimation(this);
      this.emit("resume", this);
    };
    proto.onPause = function() {
      cc.director.getAnimationManager().removeAnimation(this);
      this.emit("pause", this);
    };
    proto.setTime = function(time) {
      this._currentFramePlayed = false;
      this.time = time || 0;
      var curves = this.curves;
      for (var i = 0, l = curves.length; i < l; i++) {
        var curve = curves[i];
        curve.onTimeChangedManually && curve.onTimeChangedManually(time, this);
      }
    };
    function process() {
      var info = this.sample();
      if (this._lastframeEventOn) {
        var lastInfo;
        lastInfo = this._lastWrappedInfo ? this._lastWrappedInfo : this._lastWrappedInfo = new WrappedInfo(info);
        this.repeatCount > 1 && (0 | info.iterations) > (0 | lastInfo.iterations) && this.emit("lastframe", this);
        lastInfo.set(info);
      }
      if (info.stopped) {
        this.stop();
        this.emit("finished", this);
      }
    }
    function simpleProcess() {
      var time = this.time;
      var duration = this.duration;
      if (time > duration) {
        time %= duration;
        0 === time && (time = duration);
      } else if (time < 0) {
        time %= duration;
        0 !== time && (time += duration);
      }
      var ratio = time / duration;
      var curves = this.curves;
      for (var i = 0, len = curves.length; i < len; i++) {
        var curve = curves[i];
        curve.sample(time, ratio, this);
      }
      if (this._lastframeEventOn) {
        void 0 === this._lastIterations && (this._lastIterations = ratio);
        (this.time > 0 && this._lastIterations > ratio || this.time < 0 && this._lastIterations < ratio) && this.emit("lastframe", this);
        this._lastIterations = ratio;
      }
    }
    proto.update = function(delta) {
      if (this._delayTime > 0) {
        this._delayTime -= delta;
        if (this._delayTime > 0) return;
      }
      this._currentFramePlayed ? this.time += delta * this.speed : this._currentFramePlayed = true;
      this._process();
    };
    proto._needRevers = function(currentIterations) {
      var wrapMode = this.wrapMode;
      var needRevers = false;
      if ((wrapMode & WrapModeMask.PingPong) === WrapModeMask.PingPong) {
        var isEnd = currentIterations - (0 | currentIterations) === 0;
        isEnd && currentIterations > 0 && (currentIterations -= 1);
        var isOddIteration = 1 & currentIterations;
        isOddIteration && (needRevers = !needRevers);
      }
      (wrapMode & WrapModeMask.Reverse) === WrapModeMask.Reverse && (needRevers = !needRevers);
      return needRevers;
    };
    proto.getWrappedInfo = function(time, info) {
      info = info || new WrappedInfo();
      var stopped = false;
      var duration = this.duration;
      var repeatCount = this.repeatCount;
      var currentIterations = time > 0 ? time / duration : -time / duration;
      if (currentIterations >= repeatCount) {
        currentIterations = repeatCount;
        stopped = true;
        var tempRatio = repeatCount - (0 | repeatCount);
        0 === tempRatio && (tempRatio = 1);
        time = tempRatio * duration * (time > 0 ? 1 : -1);
      }
      if (time > duration) {
        var tempTime = time % duration;
        time = 0 === tempTime ? duration : tempTime;
      } else if (time < 0) {
        time %= duration;
        0 !== time && (time += duration);
      }
      var needRevers = false;
      var shouldWrap = this._wrapMode & WrapModeMask.ShouldWrap;
      shouldWrap && (needRevers = this._needRevers(currentIterations));
      var direction = needRevers ? -1 : 1;
      this.speed < 0 && (direction *= -1);
      shouldWrap && needRevers && (time = duration - time);
      info.ratio = time / duration;
      info.time = time;
      info.direction = direction;
      info.stopped = stopped;
      info.iterations = currentIterations;
      return info;
    };
    proto.sample = function() {
      var info = this.getWrappedInfo(this.time, this._wrappedInfo);
      var curves = this.curves;
      for (var i = 0, len = curves.length; i < len; i++) {
        var curve = curves[i];
        curve.sample(info.time, info.ratio, this);
      }
      return info;
    };
    js.get(proto, "clip", (function() {
      return this._clip;
    }));
    js.get(proto, "name", (function() {
      return this._name;
    }));
    js.obsolete(proto, "AnimationState.length", "duration");
    js.getset(proto, "curveLoaded", (function() {
      return this.curves.length > 0;
    }), (function() {
      this.curves.length = 0;
    }));
    js.getset(proto, "wrapMode", (function() {
      return this._wrapMode;
    }), (function(value) {
      this._wrapMode = value;
      false;
      this.time = 0;
      value & WrapModeMask.Loop ? this.repeatCount = Infinity : this.repeatCount = 1;
    }));
    js.getset(proto, "repeatCount", (function() {
      return this._repeatCount;
    }), (function(value) {
      this._repeatCount = value;
      var shouldWrap = this._wrapMode & WrapModeMask.ShouldWrap;
      var reverse = (this.wrapMode & WrapModeMask.Reverse) === WrapModeMask.Reverse;
      this._process = Infinity !== value || shouldWrap || reverse ? process : simpleProcess;
    }));
    js.getset(proto, "delay", (function() {
      return this._delay;
    }), (function(value) {
      this._delayTime = this._delay = value;
    }));
    cc.AnimationState = module.exports = AnimationState;
  }), {
    "./playable": 19,
    "./types": 20
  } ],
  15: [ (function(require, module, exports) {
    "use strict";
    function bezier(C1, C2, C3, C4, t) {
      var t1 = 1 - t;
      return t1 * (t1 * (C1 + (3 * C2 - C1) * t) + 3 * C3 * t * t) + C4 * t * t * t;
    }
    var cos = Math.cos, acos = Math.acos, max = Math.max, pi = Math.PI, tau = 2 * pi, sqrt = Math.sqrt;
    function crt(v) {
      return v < 0 ? -Math.pow(-v, 1 / 3) : Math.pow(v, 1 / 3);
    }
    function cardano(curve, x) {
      var pa = x - 0;
      var pb = x - curve[0];
      var pc = x - curve[2];
      var pd = x - 1;
      var pa3 = 3 * pa;
      var pb3 = 3 * pb;
      var pc3 = 3 * pc;
      var d = -pa + pb3 - pc3 + pd, rd = 1 / d, r3 = 1 / 3, a = (pa3 - 6 * pb + pc3) * rd, a3 = a * r3, b = (-pa3 + pb3) * rd, c = pa * rd, p = (3 * b - a * a) * r3, p3 = p * r3, q = (2 * a * a * a - 9 * a * b + 27 * c) / 27, q2 = q / 2, discriminant = q2 * q2 + p3 * p3 * p3, u1, v1, x1, x2, x3;
      if (discriminant < 0) {
        var mp3 = -p * r3, mp33 = mp3 * mp3 * mp3, r = sqrt(mp33), t = -q / (2 * r), cosphi = t < -1 ? -1 : t > 1 ? 1 : t, phi = acos(cosphi), crtr = crt(r), t1 = 2 * crtr;
        x1 = t1 * cos(phi * r3) - a3;
        x2 = t1 * cos((phi + tau) * r3) - a3;
        x3 = t1 * cos((phi + 2 * tau) * r3) - a3;
        return 0 <= x1 && x1 <= 1 ? 0 <= x2 && x2 <= 1 ? 0 <= x3 && x3 <= 1 ? max(x1, x2, x3) : max(x1, x2) : 0 <= x3 && x3 <= 1 ? max(x1, x3) : x1 : 0 <= x2 && x2 <= 1 ? 0 <= x3 && x3 <= 1 ? max(x2, x3) : x2 : x3;
      }
      if (0 === discriminant) {
        u1 = q2 < 0 ? crt(-q2) : -crt(q2);
        x1 = 2 * u1 - a3;
        x2 = -u1 - a3;
        return 0 <= x1 && x1 <= 1 ? 0 <= x2 && x2 <= 1 ? max(x1, x2) : x1 : x2;
      }
      var sd = sqrt(discriminant);
      u1 = crt(-q2 + sd);
      v1 = crt(q2 + sd);
      x1 = u1 - v1 - a3;
      return x1;
    }
    function bezierByTime(controlPoints, x) {
      var percent = cardano(controlPoints, x);
      var p1y = controlPoints[1];
      var p2y = controlPoints[3];
      return ((1 - percent) * (p1y + (p2y - p1y) * percent) * 3 + percent * percent) * percent;
    }
    false;
    module.exports = {
      bezier: bezier,
      bezierByTime: bezierByTime
    };
  }), {} ],
  16: [ (function(require, module, exports) {
    "use strict";
    var easing = {
      constant: function constant() {
        return 0;
      },
      linear: function linear(k) {
        return k;
      },
      quadIn: function quadIn(k) {
        return k * k;
      },
      quadOut: function quadOut(k) {
        return k * (2 - k);
      },
      quadInOut: function quadInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k;
        return -.5 * (--k * (k - 2) - 1);
      },
      cubicIn: function cubicIn(k) {
        return k * k * k;
      },
      cubicOut: function cubicOut(k) {
        return --k * k * k + 1;
      },
      cubicInOut: function cubicInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k * k;
        return .5 * ((k -= 2) * k * k + 2);
      },
      quartIn: function quartIn(k) {
        return k * k * k * k;
      },
      quartOut: function quartOut(k) {
        return 1 - --k * k * k * k;
      },
      quartInOut: function quartInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k * k * k;
        return -.5 * ((k -= 2) * k * k * k - 2);
      },
      quintIn: function quintIn(k) {
        return k * k * k * k * k;
      },
      quintOut: function quintOut(k) {
        return --k * k * k * k * k + 1;
      },
      quintInOut: function quintInOut(k) {
        if ((k *= 2) < 1) return .5 * k * k * k * k * k;
        return .5 * ((k -= 2) * k * k * k * k + 2);
      },
      sineIn: function sineIn(k) {
        return 1 - Math.cos(k * Math.PI / 2);
      },
      sineOut: function sineOut(k) {
        return Math.sin(k * Math.PI / 2);
      },
      sineInOut: function sineInOut(k) {
        return .5 * (1 - Math.cos(Math.PI * k));
      },
      expoIn: function expoIn(k) {
        return 0 === k ? 0 : Math.pow(1024, k - 1);
      },
      expoOut: function expoOut(k) {
        return 1 === k ? 1 : 1 - Math.pow(2, -10 * k);
      },
      expoInOut: function expoInOut(k) {
        if (0 === k) return 0;
        if (1 === k) return 1;
        if ((k *= 2) < 1) return .5 * Math.pow(1024, k - 1);
        return .5 * (2 - Math.pow(2, -10 * (k - 1)));
      },
      circIn: function circIn(k) {
        return 1 - Math.sqrt(1 - k * k);
      },
      circOut: function circOut(k) {
        return Math.sqrt(1 - --k * k);
      },
      circInOut: function circInOut(k) {
        if ((k *= 2) < 1) return -.5 * (Math.sqrt(1 - k * k) - 1);
        return .5 * (Math.sqrt(1 - (k -= 2) * k) + 1);
      },
      elasticIn: function elasticIn(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        return -a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p);
      },
      elasticOut: function elasticOut(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        return a * Math.pow(2, -10 * k) * Math.sin((k - s) * (2 * Math.PI) / p) + 1;
      },
      elasticInOut: function elasticInOut(k) {
        var s, a = .1, p = .4;
        if (0 === k) return 0;
        if (1 === k) return 1;
        if (!a || a < 1) {
          a = 1;
          s = p / 4;
        } else s = p * Math.asin(1 / a) / (2 * Math.PI);
        if ((k *= 2) < 1) return a * Math.pow(2, 10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * -.5;
        return a * Math.pow(2, -10 * (k -= 1)) * Math.sin((k - s) * (2 * Math.PI) / p) * .5 + 1;
      },
      backIn: function backIn(k) {
        var s = 1.70158;
        return k * k * ((s + 1) * k - s);
      },
      backOut: function backOut(k) {
        var s = 1.70158;
        return --k * k * ((s + 1) * k + s) + 1;
      },
      backInOut: function backInOut(k) {
        var s = 2.5949095;
        if ((k *= 2) < 1) return k * k * ((s + 1) * k - s) * .5;
        return .5 * ((k -= 2) * k * ((s + 1) * k + s) + 2);
      },
      bounceIn: function bounceIn(k) {
        return 1 - easing.bounceOut(1 - k);
      },
      bounceOut: function bounceOut(k) {
        return k < 1 / 2.75 ? 7.5625 * k * k : k < 2 / 2.75 ? 7.5625 * (k -= 1.5 / 2.75) * k + .75 : k < 2.5 / 2.75 ? 7.5625 * (k -= 2.25 / 2.75) * k + .9375 : 7.5625 * (k -= 2.625 / 2.75) * k + .984375;
      },
      bounceInOut: function bounceInOut(k) {
        if (k < .5) return .5 * easing.bounceIn(2 * k);
        return .5 * easing.bounceOut(2 * k - 1) + .5;
      },
      smooth: function smooth(t) {
        if (t <= 0) return 0;
        if (t >= 1) return 1;
        return t * t * (3 - 2 * t);
      },
      fade: function fade(t) {
        if (t <= 0) return 0;
        if (t >= 1) return 1;
        return t * t * t * (t * (6 * t - 15) + 10);
      }
    };
    function _makeOutIn(fnIn, fnOut) {
      return function(k) {
        if (k < .5) return fnOut(2 * k) / 2;
        return fnIn(2 * k - 1) / 2 + .5;
      };
    }
    easing.quadOutIn = _makeOutIn(easing.quadIn, easing.quadOut);
    easing.cubicOutIn = _makeOutIn(easing.cubicIn, easing.cubicOut);
    easing.quartOutIn = _makeOutIn(easing.quartIn, easing.quartOut);
    easing.quintOutIn = _makeOutIn(easing.quintIn, easing.quintOut);
    easing.sineOutIn = _makeOutIn(easing.sineIn, easing.sineOut);
    easing.expoOutIn = _makeOutIn(easing.expoIn, easing.expoOut);
    easing.circOutIn = _makeOutIn(easing.circIn, easing.circOut);
    easing.backOutIn = _makeOutIn(easing.backIn, easing.backOut);
    easing.bounceIn = function(k) {
      return 1 - easing.bounceOut(1 - k);
    };
    easing.bounceInOut = function(k) {
      if (k < .5) return .5 * easing.bounceIn(2 * k);
      return .5 * easing.bounceOut(2 * k - 1) + .5;
    };
    easing.bounceOutIn = _makeOutIn(easing.bounceIn, easing.bounceOut);
    cc.easing = module.exports = easing;
  }), {} ],
  17: [ (function(require, module, exports) {
    "use strict";
    require("./bezier");
    require("./easing");
    require("./types");
    require("./motion-path-helper");
    require("./animation-curves");
    require("./animation-clip");
    require("./animation-manager");
    require("./animation-state");
    require("./animation-animator");
  }), {
    "./animation-animator": 10,
    "./animation-clip": 11,
    "./animation-curves": 12,
    "./animation-manager": 13,
    "./animation-state": 14,
    "./bezier": 15,
    "./easing": 16,
    "./motion-path-helper": 18,
    "./types": 20
  } ],
  18: [ (function(require, module, exports) {
    "use strict";
    var DynamicAnimCurve = require("./animation-curves").DynamicAnimCurve;
    var computeRatioByType = require("./animation-curves").computeRatioByType;
    var bezier = require("./bezier").bezier;
    var binarySearch = require("../core/utils/binary-search").binarySearchEpsilon;
    var v2 = cc.v2;
    function Curve(points) {
      this.points = points || [];
      this.beziers = [];
      this.ratios = [];
      this.progresses = [];
      this.length = 0;
      this.computeBeziers();
    }
    Curve.prototype.computeBeziers = function() {
      this.beziers.length = 0;
      this.ratios.length = 0;
      this.progresses.length = 0;
      this.length = 0;
      var bezier;
      for (var i = 1; i < this.points.length; i++) {
        var startPoint = this.points[i - 1];
        var endPoint = this.points[i];
        bezier = new Bezier();
        bezier.start = startPoint.pos;
        bezier.startCtrlPoint = startPoint.out;
        bezier.end = endPoint.pos;
        bezier.endCtrlPoint = endPoint["in"];
        this.beziers.push(bezier);
        this.length += bezier.getLength();
      }
      var current = 0;
      for (var i = 0; i < this.beziers.length; i++) {
        bezier = this.beziers[i];
        this.ratios[i] = bezier.getLength() / this.length;
        this.progresses[i] = current += this.ratios[i];
      }
      return this.beziers;
    };
    function Bezier() {
      this.start = v2();
      this.end = v2();
      this.startCtrlPoint = v2();
      this.endCtrlPoint = v2();
    }
    Bezier.prototype.getPointAt = function(u) {
      var t = this.getUtoTmapping(u);
      return this.getPoint(t);
    };
    Bezier.prototype.getPoint = function(t) {
      var x = bezier(this.start.x, this.startCtrlPoint.x, this.endCtrlPoint.x, this.end.x, t);
      var y = bezier(this.start.y, this.startCtrlPoint.y, this.endCtrlPoint.y, this.end.y, t);
      return new v2(x, y);
    };
    Bezier.prototype.getLength = function() {
      var lengths = this.getLengths();
      return lengths[lengths.length - 1];
    };
    Bezier.prototype.getLengths = function(divisions) {
      divisions || (divisions = this.__arcLengthDivisions ? this.__arcLengthDivisions : 200);
      if (this.cacheArcLengths && this.cacheArcLengths.length === divisions + 1) return this.cacheArcLengths;
      var cache = [];
      var current, last = this.getPoint(0), vector = v2();
      var p, sum = 0;
      cache.push(0);
      for (p = 1; p <= divisions; p++) {
        current = this.getPoint(p / divisions);
        vector.x = last.x - current.x;
        vector.y = last.y - current.y;
        sum += vector.mag();
        cache.push(sum);
        last = current;
      }
      this.cacheArcLengths = cache;
      return cache;
    };
    Bezier.prototype.getUtoTmapping = function(u, distance) {
      var arcLengths = this.getLengths();
      var i = 0, il = arcLengths.length;
      var targetArcLength;
      targetArcLength = distance || u * arcLengths[il - 1];
      var low = 0, high = il - 1, comparison;
      while (low <= high) {
        i = Math.floor(low + (high - low) / 2);
        comparison = arcLengths[i] - targetArcLength;
        if (comparison < 0) {
          low = i + 1;
          continue;
        }
        if (comparison > 0) {
          high = i - 1;
          continue;
        }
        high = i;
        break;
      }
      i = high;
      if (arcLengths[i] === targetArcLength) {
        var t = i / (il - 1);
        return t;
      }
      var lengthBefore = arcLengths[i];
      var lengthAfter = arcLengths[i + 1];
      var segmentLength = lengthAfter - lengthBefore;
      var segmentFraction = (targetArcLength - lengthBefore) / segmentLength;
      var t = (i + segmentFraction) / (il - 1);
      return t;
    };
    function checkMotionPath(motionPath) {
      if (!Array.isArray(motionPath)) return false;
      for (var i = 0, l = motionPath.length; i < l; i++) {
        var controls = motionPath[i];
        if (!Array.isArray(controls) || 6 !== controls.length) return false;
      }
      return true;
    }
    function sampleMotionPaths(motionPaths, data, duration, fps, target) {
      function createControlPoints(array) {
        if (array instanceof cc.Vec2) return {
          in: array,
          pos: array,
          out: array
        };
        if (Array.isArray(array) && 6 === array.length) return {
          in: v2(array[2], array[3]),
          pos: v2(array[0], array[1]),
          out: v2(array[4], array[5])
        };
        return {
          in: cc.Vec2.ZERO,
          pos: cc.Vec2.ZERO,
          out: cc.Vec2.ZERO
        };
      }
      var values = data.values = data.values.map((function(value) {
        Array.isArray(value) && (value = 2 === value.length ? cc.v2(value[0], value[1]) : cc.v3(value[0], value[1], value[2]));
        return value;
      }));
      if (0 === motionPaths.length || 0 === values.length) return;
      var motionPathValid = false;
      for (var _i = 0; _i < motionPaths.length; _i++) {
        var _motionPath = motionPaths[_i];
        if (_motionPath && !checkMotionPath(_motionPath)) {
          cc.errorID(3904, target ? target.name : "", "position", _i);
          _motionPath = null;
        }
        if (_motionPath && _motionPath.length > 0) {
          motionPathValid = true;
          break;
        }
      }
      if (!motionPathValid) return;
      if (1 === values.length) return;
      var types = data.types;
      var ratios = data.ratios;
      var newValues = data.values = [];
      var newTypes = data.types = [];
      var newRatios = data.ratios = [];
      function addNewDatas(value, type, ratio) {
        newValues.push(value);
        newTypes.push(type);
        newRatios.push(ratio);
      }
      var startRatioOffset = 0;
      var EPSILON = 1e-6;
      var newType = DynamicAnimCurve.Linear;
      for (var i = 0, l = motionPaths.length; i < l - 1; i++) {
        var motionPath = motionPaths[i];
        var ratio = ratios[i];
        var nextRatio = ratios[i + 1];
        var betweenRatio = nextRatio - ratio;
        var value = values[i];
        var nextValue = values[i + 1];
        var type = types[i];
        var results = [];
        var progress = startRatioOffset / betweenRatio;
        var speed = 1 / (betweenRatio * duration * fps);
        var finalProgress;
        if (motionPath && motionPath.length > 0) {
          var points = [];
          points.push(createControlPoints(value));
          for (var j = 0, l2 = motionPath.length; j < l2; j++) {
            var controlPoints = createControlPoints(motionPath[j]);
            points.push(controlPoints);
          }
          points.push(createControlPoints(nextValue));
          var curve = new Curve(points);
          curve.computeBeziers();
          var progresses = curve.progresses;
          while (1 - progress > EPSILON) {
            finalProgress = progress;
            finalProgress = computeRatioByType(finalProgress, type);
            var pos, bezier, normal, length;
            if (finalProgress < 0) {
              bezier = curve.beziers[0];
              length = (0 - finalProgress) * bezier.getLength();
              normal = bezier.start.sub(bezier.endCtrlPoint).normalize();
              pos = bezier.start.add(normal.mul(length));
            } else if (finalProgress > 1) {
              bezier = curve.beziers[curve.beziers.length - 1];
              length = (finalProgress - 1) * bezier.getLength();
              normal = bezier.end.sub(bezier.startCtrlPoint).normalize();
              pos = bezier.end.add(normal.mul(length));
            } else {
              var bezierIndex = binarySearch(progresses, finalProgress);
              bezierIndex < 0 && (bezierIndex = ~bezierIndex);
              finalProgress -= bezierIndex > 0 ? progresses[bezierIndex - 1] : 0;
              finalProgress /= curve.ratios[bezierIndex];
              pos = curve.beziers[bezierIndex].getPointAt(finalProgress);
            }
            results.push(pos);
            progress += speed;
          }
        } else while (1 - progress > EPSILON) {
          finalProgress = progress;
          finalProgress = computeRatioByType(finalProgress, type);
          results.push(value.lerp(nextValue, finalProgress));
          progress += speed;
        }
        newType = "constant" === type ? type : DynamicAnimCurve.Linear;
        for (var j = 0, l2 = results.length; j < l2; j++) {
          var newRatio = ratio + startRatioOffset + speed * j * betweenRatio;
          addNewDatas(results[j], newType, newRatio);
        }
        startRatioOffset = Math.abs(progress - 1) > EPSILON ? (progress - 1) * betweenRatio : 0;
      }
      ratios[ratios.length - 1] !== newRatios[newRatios.length - 1] && addNewDatas(values[values.length - 1], newType, ratios[ratios.length - 1]);
    }
    false;
    module.exports = {
      sampleMotionPaths: sampleMotionPaths,
      Curve: Curve,
      Bezier: Bezier
    };
  }), {
    "../core/utils/binary-search": 202,
    "./animation-curves": 12,
    "./bezier": 15
  } ],
  19: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var debug = require("../core/CCDebug");
    function Playable() {
      this._isPlaying = false;
      this._isPaused = false;
      this._stepOnce = false;
    }
    var prototype = Playable.prototype;
    js.get(prototype, "isPlaying", (function() {
      return this._isPlaying;
    }), true);
    js.get(prototype, "isPaused", (function() {
      return this._isPaused;
    }), true);
    var virtual = function virtual() {};
    prototype.onPlay = virtual;
    prototype.onPause = virtual;
    prototype.onResume = virtual;
    prototype.onStop = virtual;
    prototype.onError = virtual;
    prototype.play = function() {
      if (this._isPlaying) if (this._isPaused) {
        this._isPaused = false;
        this.onResume();
      } else this.onError(debug.getError(3912)); else {
        this._isPlaying = true;
        this.onPlay();
      }
    };
    prototype.stop = function() {
      if (this._isPlaying) {
        this._isPlaying = false;
        this.onStop();
        this._isPaused = false;
      }
    };
    prototype.pause = function() {
      if (this._isPlaying && !this._isPaused) {
        this._isPaused = true;
        this.onPause();
      }
    };
    prototype.resume = function() {
      if (this._isPlaying && this._isPaused) {
        this._isPaused = false;
        this.onResume();
      }
    };
    prototype.step = function() {
      this.pause();
      this._stepOnce = true;
      this._isPlaying || this.play();
    };
    module.exports = Playable;
  }), {
    "../core/CCDebug": 23
  } ],
  20: [ (function(require, module, exports) {
    "use strict";
    var WrapModeMask = {
      Loop: 2,
      ShouldWrap: 4,
      PingPong: 22,
      Reverse: 36
    };
    var WrapMode = cc.Enum({
      Default: 0,
      Normal: 1,
      Reverse: WrapModeMask.Reverse,
      Loop: WrapModeMask.Loop,
      LoopReverse: WrapModeMask.Loop | WrapModeMask.Reverse,
      PingPong: WrapModeMask.PingPong,
      PingPongReverse: WrapModeMask.PingPong | WrapModeMask.Reverse
    });
    cc.WrapMode = WrapMode;
    function WrappedInfo(info) {
      if (info) {
        this.set(info);
        return;
      }
      this.ratio = 0;
      this.time = 0;
      this.direction = 1;
      this.stopped = true;
      this.iterations = 0;
      this.frameIndex = void 0;
    }
    WrappedInfo.prototype.set = function(info) {
      this.ratio = info.ratio;
      this.time = info.time;
      this.direction = info.direction;
      this.stopped = info.stopped;
      this.iterations = info.iterations;
      this.frameIndex = info.frameIndex;
    };
    module.exports = {
      WrapModeMask: WrapModeMask,
      WrapMode: WrapMode,
      WrappedInfo: WrappedInfo
    };
  }), {} ],
  21: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../core/event/event-target");
    var sys = require("../core/platform/CCSys");
    var LoadMode = require("../core/assets/CCAudioClip").LoadMode;
    var touchBinded = false;
    var touchPlayList = [];
    var Audio = function Audio(src) {
      EventTarget.call(this);
      this._shouldRecycleOnEnded = false;
      this._src = src;
      this._element = null;
      this.id = 0;
      this._state = Audio.State.INITIALZING;
      this._onended = function() {
        this._state = Audio.State.STOPPED;
        this.emit("ended");
      }.bind(this);
    };
    cc.js.extend(Audio, EventTarget);
    Audio.State = {
      ERROR: -1,
      INITIALZING: 0,
      PLAYING: 1,
      PAUSED: 2,
      STOPPED: 3
    };
    (function(proto) {
      proto._bindEnded = function(callback) {
        callback = callback || this._onended;
        var elem = this._element;
        this._src && elem instanceof HTMLAudioElement ? elem.addEventListener("ended", callback) : elem.onended = callback;
      };
      proto._unbindEnded = function() {
        var elem = this._element;
        elem instanceof HTMLAudioElement ? elem.removeEventListener("ended", this._onended) : elem && (elem.onended = null);
      };
      proto._onLoaded = function() {
        this._createElement();
        this._state = Audio.State.INITIALZING;
        this.setVolume(1);
        this.setLoop(false);
      };
      proto._createElement = function() {
        var elem = this._src._nativeAsset;
        if (elem instanceof HTMLAudioElement) {
          this._element || (this._element = document.createElement("audio"));
          this._element.src = elem.src;
        } else this._element = new WebAudioElement(elem, this);
      };
      proto.play = function() {
        var self = this;
        this._src && this._src._ensureLoaded((function() {
          self._state = Audio.State.PLAYING;
          self._bindEnded();
          var playPromise = self._element.play();
          window.Promise && playPromise instanceof Promise && playPromise["catch"]((function(err) {}));
          self._touchToPlay();
        }));
      };
      proto._touchToPlay = function() {
        this._src && this._src.loadMode === LoadMode.DOM_AUDIO && this._element.paused && touchPlayList.push({
          instance: this,
          offset: 0,
          audio: this._element
        });
        if (touchBinded) return;
        touchBinded = true;
        var touchEventName = "ontouchend" in window ? "touchend" : "mousedown";
        cc.game.canvas.addEventListener(touchEventName, (function() {
          var item;
          while (item = touchPlayList.pop()) item.audio.play(item.offset);
        }));
      };
      proto.destroy = function() {
        this._element = null;
      };
      proto.pause = function() {
        if (this.getState() !== Audio.State.PLAYING) return;
        var self = this;
        this._src && this._src._ensureLoaded((function() {
          self._unbindEnded();
          self._element.pause();
          self._state = Audio.State.PAUSED;
        }));
      };
      proto.resume = function() {
        if (this.getState() !== Audio.State.PAUSED) return;
        var self = this;
        this._src && this._src._ensureLoaded((function() {
          self._bindEnded();
          self._element.play();
          self._state = Audio.State.PLAYING;
        }));
      };
      proto.stop = function() {
        var self = this;
        this._src && this._src._ensureLoaded((function() {
          self._element.pause();
          self._element.currentTime = 0;
          for (var i = 0; i < touchPlayList.length; i++) if (touchPlayList[i].instance === self) {
            touchPlayList.splice(i, 1);
            break;
          }
          self._unbindEnded();
          self.emit("stop");
          self._state = Audio.State.STOPPED;
        }));
      };
      proto.setLoop = function(loop) {
        var self = this;
        this._src && this._src._ensureLoaded((function() {
          self._element.loop = loop;
        }));
      };
      proto.getLoop = function() {
        return !!this._element && this._element.loop;
      };
      proto.setVolume = function(num) {
        var self = this;
        this._src && this._src._ensureLoaded((function() {
          self._element.volume = num;
        }));
      };
      proto.getVolume = function() {
        return this._element ? this._element.volume : 1;
      };
      proto.setCurrentTime = function(num) {
        var self = this;
        this._src && this._src._ensureLoaded((function() {
          self._unbindEnded();
          self._bindEnded((function() {
            self._bindEnded();
          }));
          self._element.currentTime = num;
        }));
      };
      proto.getCurrentTime = function() {
        return this._element ? this._element.currentTime : 0;
      };
      proto.getDuration = function() {
        return this._src ? this._src.duration : 0;
      };
      proto.getState = function(forceUpdating) {
        void 0 === forceUpdating && (forceUpdating = true);
        forceUpdating && this._forceUpdatingState();
        return this._state;
      };
      proto._forceUpdatingState = function() {
        var elem = this._element;
        elem && (Audio.State.PLAYING === this._state && elem.paused ? this._state = Audio.State.STOPPED : Audio.State.STOPPED !== this._state || elem.paused || (this._state = Audio.State.PLAYING));
      };
      Object.defineProperty(proto, "src", {
        get: function get() {
          return this._src;
        },
        set: function set(clip) {
          this._unbindEnded();
          if (clip) {
            this._src = clip;
            var self = this;
            clip._ensureLoaded((function() {
              clip === self._src && self._onLoaded();
            }));
          } else {
            this._src = null;
            this._element instanceof WebAudioElement ? this._element = null : this._element && (this._element.src = "");
            this._state = Audio.State.INITIALZING;
          }
          return clip;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "paused", {
        get: function get() {
          return !this._element || this._element.paused;
        },
        enumerable: true,
        configurable: true
      });
    })(Audio.prototype);
    var TIME_CONSTANT;
    TIME_CONSTANT = cc.sys.browserType === cc.sys.BROWSER_TYPE_EDGE || cc.sys.browserType === cc.sys.BROWSER_TYPE_BAIDU || cc.sys.browserType === cc.sys.BROWSER_TYPE_UC ? .01 : 0;
    var WebAudioElement = function WebAudioElement(buffer, audio) {
      this._audio = audio;
      this._context = sys.__audioSupport.context;
      this._buffer = buffer;
      this._gainObj = this._context["createGain"]();
      this.volume = 1;
      this._gainObj["connect"](this._context["destination"]);
      this._loop = false;
      this._startTime = -1;
      this._currentSource = null;
      this.playedLength = 0;
      this._currentTimer = null;
      this._endCallback = function() {
        this.onended && this.onended(this);
      }.bind(this);
    };
    (function(proto) {
      proto.play = function(offset) {
        if (this._currentSource && !this.paused) {
          this._currentSource.onended = null;
          this._currentSource.stop(0);
          this.playedLength = 0;
        }
        var audio = this._context["createBufferSource"]();
        audio.buffer = this._buffer;
        audio["connect"](this._gainObj);
        audio.loop = this._loop;
        this._startTime = this._context.currentTime;
        offset = offset || this.playedLength;
        offset && (this._startTime -= offset);
        var duration = this._buffer.duration;
        var startTime = offset;
        var endTime;
        if (this._loop) audio.start ? audio.start(0, startTime) : audio["notoGrainOn"] ? audio["noteGrainOn"](0, startTime) : audio["noteOn"](0, startTime); else {
          endTime = duration - offset;
          audio.start ? audio.start(0, startTime, endTime) : audio["noteGrainOn"] ? audio["noteGrainOn"](0, startTime, endTime) : audio["noteOn"](0, startTime, endTime);
        }
        this._currentSource = audio;
        audio.onended = this._endCallback;
        if ((!audio.context.state || "suspended" === audio.context.state) && 0 === this._context.currentTime) {
          var self = this;
          clearTimeout(this._currentTimer);
          this._currentTimer = setTimeout((function() {
            0 === self._context.currentTime && touchPlayList.push({
              instance: self._audio,
              offset: offset,
              audio: self
            });
          }), 10);
        }
        var sys = cc.sys;
        sys.os === sys.OS_IOS && sys.isBrowser && sys.isMobile && ("suspended" === audio.context.state && 0 !== this._context.currentTime || "interrupted" === audio.context.state) && audio.context.resume();
      };
      proto.pause = function() {
        clearTimeout(this._currentTimer);
        if (this.paused) return;
        this.playedLength = this._context.currentTime - this._startTime;
        this.playedLength %= this._buffer.duration;
        var audio = this._currentSource;
        this._currentSource = null;
        this._startTime = -1;
        audio && audio.stop(0);
      };
      Object.defineProperty(proto, "paused", {
        get: function get() {
          if (this._currentSource && this._currentSource.loop) return false;
          if (-1 === this._startTime) return true;
          return this._context.currentTime - this._startTime > this._buffer.duration;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "loop", {
        get: function get() {
          return this._loop;
        },
        set: function set(bool) {
          this._currentSource && (this._currentSource.loop = bool);
          return this._loop = bool;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "volume", {
        get: function get() {
          return this._volume;
        },
        set: function set(num) {
          this._volume = num;
          if (this._gainObj.gain.setTargetAtTime) try {
            this._gainObj.gain.setTargetAtTime(num, this._context.currentTime, TIME_CONSTANT);
          } catch (e) {
            this._gainObj.gain.setTargetAtTime(num, this._context.currentTime, .01);
          } else this._gainObj.gain.value = num;
          if (sys.os === sys.OS_IOS && !this.paused && this._currentSource) {
            this._currentSource.onended = null;
            this.pause();
            this.play();
          }
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "currentTime", {
        get: function get() {
          if (this.paused) return this.playedLength;
          this.playedLength = this._context.currentTime - this._startTime;
          this.playedLength %= this._buffer.duration;
          return this.playedLength;
        },
        set: function set(num) {
          if (this.paused) this.playedLength = num; else {
            this.pause();
            this.playedLength = num;
            this.play();
          }
          return num;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(proto, "duration", {
        get: function get() {
          return this._buffer.duration;
        },
        enumerable: true,
        configurable: true
      });
    })(WebAudioElement.prototype);
    module.exports = cc._Audio = Audio;
  }), {
    "../core/assets/CCAudioClip": 60,
    "../core/event/event-target": 121,
    "../core/platform/CCSys": 147
  } ],
  22: [ (function(require, module, exports) {
    "use strict";
    var Audio = require("./CCAudio");
    var AudioClip = require("../core/assets/CCAudioClip");
    var js = cc.js;
    var _instanceId = 0;
    var _id2audio = js.createMap(true);
    var _url2id = {};
    var _audioPool = [];
    var recycleAudio = function recycleAudio(audio) {
      if (!audio._shouldRecycleOnEnded) return;
      audio._finishCallback = null;
      audio.off("ended");
      audio.off("stop");
      audio.src = null;
      _audioPool.includes(audio) || (_audioPool.length < 32 ? _audioPool.push(audio) : audio.destroy());
      audio._shouldRecycleOnEnded = false;
    };
    var getAudioFromPath = function getAudioFromPath(path) {
      var id = _instanceId++;
      var list = _url2id[path];
      list || (list = _url2id[path] = []);
      if (audioEngine._maxAudioInstance <= list.length) {
        var oldId = list.shift();
        var oldAudio = getAudioFromId(oldId);
        oldAudio.stop();
      }
      var audio = _audioPool.pop() || new Audio();
      var callback = function callback() {
        var audioInList = getAudioFromId(this.id);
        if (audioInList) {
          delete _id2audio[this.id];
          var index = list.indexOf(this.id);
          cc.js.array.fastRemoveAt(list, index);
        }
        recycleAudio(this);
      };
      audio.on("ended", (function() {
        this._finishCallback && this._finishCallback();
        callback.call(this);
      }), audio);
      audio.on("stop", callback, audio);
      audio.id = id;
      _id2audio[id] = audio;
      list.push(id);
      return audio;
    };
    var getAudioFromId = function getAudioFromId(id) {
      return _id2audio[id];
    };
    var handleVolume = function handleVolume(volume) {
      void 0 === volume ? volume = 1 : "string" === typeof volume && (volume = Number.parseFloat(volume));
      return volume;
    };
    var audioEngine = {
      AudioState: Audio.State,
      _maxAudioInstance: 24,
      _id2audio: _id2audio,
      play: function play(clip, loop, volume) {
        if (!(clip instanceof AudioClip)) return cc.error("Wrong type of AudioClip.");
        var path = clip.nativeUrl;
        var audio = getAudioFromPath(path);
        audio.src = clip;
        audio._shouldRecycleOnEnded = true;
        audio.setLoop(loop || false);
        volume = handleVolume(volume);
        audio.setVolume(volume);
        audio.play();
        return audio.id;
      },
      setLoop: function setLoop(audioID, loop) {
        var audio = getAudioFromId(audioID);
        if (!audio || !audio.setLoop) return;
        audio.setLoop(loop);
      },
      isLoop: function isLoop(audioID) {
        var audio = getAudioFromId(audioID);
        if (!audio || !audio.getLoop) return false;
        return audio.getLoop();
      },
      setVolume: function setVolume(audioID, volume) {
        var audio = getAudioFromId(audioID);
        audio && audio.setVolume(volume);
      },
      getVolume: function getVolume(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getVolume() : 1;
      },
      setCurrentTime: function setCurrentTime(audioID, sec) {
        var audio = getAudioFromId(audioID);
        if (audio) {
          audio.setCurrentTime(sec);
          return true;
        }
        return false;
      },
      getCurrentTime: function getCurrentTime(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getCurrentTime() : 0;
      },
      getDuration: function getDuration(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getDuration() : 0;
      },
      getState: function getState(audioID) {
        var audio = getAudioFromId(audioID);
        return audio ? audio.getState() : this.AudioState.ERROR;
      },
      setFinishCallback: function setFinishCallback(audioID, callback) {
        var audio = getAudioFromId(audioID);
        if (!audio) return;
        audio._finishCallback = callback;
      },
      pause: function pause(audioID) {
        var audio = getAudioFromId(audioID);
        if (audio) {
          audio.pause();
          return true;
        }
        return false;
      },
      _pauseIDCache: [],
      pauseAll: function pauseAll() {
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          var state = audio.getState();
          if (state === Audio.State.PLAYING) {
            this._pauseIDCache.push(id);
            audio.pause();
          }
        }
      },
      resume: function resume(audioID) {
        var audio = getAudioFromId(audioID);
        audio && audio.resume();
      },
      resumeAll: function resumeAll() {
        for (var i = 0; i < this._pauseIDCache.length; ++i) {
          var id = this._pauseIDCache[i];
          var audio = getAudioFromId(id);
          audio && audio.resume();
        }
        this._pauseIDCache.length = 0;
      },
      stop: function stop(audioID) {
        var audio = getAudioFromId(audioID);
        if (audio) {
          audio.stop();
          return true;
        }
        return false;
      },
      stopAll: function stopAll() {
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          audio && audio.stop();
        }
      },
      setMaxAudioInstance: function setMaxAudioInstance(num) {
        true;
        cc.warn("Since v2.4.0, maxAudioInstance has become a read only property.\naudioEngine.setMaxAudioInstance() method will be removed in the future");
      },
      getMaxAudioInstance: function getMaxAudioInstance() {
        return this._maxAudioInstance;
      },
      uncache: function uncache(clip) {
        var filePath = clip;
        if ("string" === typeof clip) {
          cc.warnID(8401, "cc.audioEngine", "cc.AudioClip", "AudioClip", "cc.AudioClip", "audio");
          filePath = clip;
        } else {
          if (!clip) return;
          filePath = clip.nativeUrl;
        }
        var list = _url2id[filePath];
        if (!list) return;
        while (list.length > 0) {
          var id = list.pop();
          var audio = _id2audio[id];
          if (audio) {
            audio.stop();
            delete _id2audio[id];
          }
        }
      },
      uncacheAll: function uncacheAll() {
        this.stopAll();
        var audio;
        for (var id in _id2audio) {
          audio = _id2audio[id];
          audio && audio.destroy();
        }
        while (audio = _audioPool.pop()) audio.destroy();
        _id2audio = js.createMap(true);
        _url2id = {};
      },
      _breakCache: null,
      _break: function _break() {
        this._breakCache = [];
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          var state = audio.getState();
          if (state === Audio.State.PLAYING) {
            this._breakCache.push(id);
            audio.pause();
          }
        }
      },
      _restore: function _restore() {
        if (!this._breakCache) return;
        while (this._breakCache.length > 0) {
          var id = this._breakCache.pop();
          var audio = getAudioFromId(id);
          audio && audio.resume && audio.resume();
        }
        this._breakCache = null;
      },
      _music: {
        id: -1,
        loop: false,
        volume: 1
      },
      _effect: {
        volume: 1,
        pauseCache: []
      },
      playMusic: function playMusic(clip, loop) {
        var music = this._music;
        this.stop(music.id);
        music.id = this.play(clip, loop, music.volume);
        music.loop = loop;
        return music.id;
      },
      stopMusic: function stopMusic() {
        this.stop(this._music.id);
      },
      pauseMusic: function pauseMusic() {
        this.pause(this._music.id);
        return this._music.id;
      },
      resumeMusic: function resumeMusic() {
        this.resume(this._music.id);
        return this._music.id;
      },
      getMusicVolume: function getMusicVolume() {
        return this._music.volume;
      },
      setMusicVolume: function setMusicVolume(volume) {
        volume = handleVolume(volume);
        var music = this._music;
        music.volume = volume;
        this.setVolume(music.id, music.volume);
        return music.volume;
      },
      isMusicPlaying: function isMusicPlaying() {
        return this.getState(this._music.id) === this.AudioState.PLAYING;
      },
      playEffect: function playEffect(clip, loop) {
        return this.play(clip, loop || false, this._effect.volume);
      },
      setEffectsVolume: function setEffectsVolume(volume) {
        volume = handleVolume(volume);
        var musicId = this._music.id;
        this._effect.volume = volume;
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          if (!audio || audio.id === musicId) continue;
          audioEngine.setVolume(id, volume);
        }
      },
      getEffectsVolume: function getEffectsVolume() {
        return this._effect.volume;
      },
      pauseEffect: function pauseEffect(audioID) {
        return this.pause(audioID);
      },
      pauseAllEffects: function pauseAllEffects() {
        var musicId = this._music.id;
        var effect = this._effect;
        effect.pauseCache.length = 0;
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          if (!audio || audio.id === musicId) continue;
          var state = audio.getState();
          if (state === this.AudioState.PLAYING) {
            effect.pauseCache.push(id);
            audio.pause();
          }
        }
      },
      resumeEffect: function resumeEffect(id) {
        this.resume(id);
      },
      resumeAllEffects: function resumeAllEffects() {
        var pauseIDCache = this._effect.pauseCache;
        for (var i = 0; i < pauseIDCache.length; ++i) {
          var id = pauseIDCache[i];
          var audio = _id2audio[id];
          audio && audio.resume();
        }
      },
      stopEffect: function stopEffect(audioID) {
        return this.stop(audioID);
      },
      stopAllEffects: function stopAllEffects() {
        var musicId = this._music.id;
        for (var id in _id2audio) {
          var audio = _id2audio[id];
          if (!audio || audio.id === musicId) continue;
          var state = audio.getState();
          state === audioEngine.AudioState.PLAYING && audio.stop();
        }
      }
    };
    module.exports = cc.audioEngine = audioEngine;
  }), {
    "../core/assets/CCAudioClip": 60,
    "./CCAudio": 21
  } ],
  23: [ (function(require, module, exports) {
    "use strict";
    var utils = require("./platform/utils");
    var debugInfos = require("../../DebugInfos") || {};
    var ERROR_MAP_URL = "https://github.com/cocos-creator/engine/blob/master/EngineErrorMap.md";
    var logList;
    cc.log = cc.warn = cc.error = cc.assert = console.log.bind ? console.log.bind(console) : console.log;
    var resetDebugSetting = function resetDebugSetting(mode) {
      cc.log = cc.warn = cc.error = cc.assert = function() {};
      if (mode === DebugMode.NONE) return;
      if (mode > DebugMode.ERROR) {
        var logToWebPage = function logToWebPage(msg) {
          if (!cc.game.canvas) return;
          if (!logList) {
            var logDiv = document.createElement("Div");
            logDiv.setAttribute("id", "logInfoDiv");
            logDiv.setAttribute("width", "200");
            logDiv.setAttribute("height", cc.game.canvas.height);
            var logDivStyle = logDiv.style;
            logDivStyle.zIndex = "99999";
            logDivStyle.position = "absolute";
            logDivStyle.top = logDivStyle.left = "0";
            logList = document.createElement("textarea");
            logList.setAttribute("rows", "20");
            logList.setAttribute("cols", "30");
            logList.setAttribute("disabled", "true");
            var logListStyle = logList.style;
            logListStyle.backgroundColor = "transparent";
            logListStyle.borderBottom = "1px solid #cccccc";
            logListStyle.borderTopWidth = logListStyle.borderLeftWidth = logListStyle.borderRightWidth = "0px";
            logListStyle.borderTopStyle = logListStyle.borderLeftStyle = logListStyle.borderRightStyle = "none";
            logListStyle.padding = "0px";
            logListStyle.margin = 0;
            logDiv.appendChild(logList);
            cc.game.canvas.parentNode.appendChild(logDiv);
          }
          logList.value = logList.value + msg + "\r\n";
          logList.scrollTop = logList.scrollHeight;
        };
        cc.error = function() {
          logToWebPage("ERROR :  " + cc.js.formatStr.apply(null, arguments));
        };
        cc.assert = function(cond, msg) {
          if (!cond && msg) {
            msg = cc.js.formatStr.apply(null, cc.js.shiftArguments.apply(null, arguments));
            logToWebPage("ASSERT: " + msg);
          }
        };
        mode !== DebugMode.ERROR_FOR_WEB_PAGE && (cc.warn = function() {
          logToWebPage("WARN :  " + cc.js.formatStr.apply(null, arguments));
        });
        mode === DebugMode.INFO_FOR_WEB_PAGE && (cc.log = function() {
          logToWebPage(cc.js.formatStr.apply(null, arguments));
        });
      } else if (console && console.log.apply) {
        console.error || (console.error = console.log);
        console.warn || (console.warn = console.log);
        false;
        console.error.bind ? cc.error = console.error.bind(console) : cc.error = (false, 
        function() {
          return console.error.apply(console, arguments);
        });
        cc.assert = function(cond, msg) {
          if (!cond) {
            msg && (msg = cc.js.formatStr.apply(null, cc.js.shiftArguments.apply(null, arguments)));
            false;
            false;
            throw new Error(msg);
          }
        };
      }
      if (mode !== DebugMode.ERROR) {
        false;
        console.warn.bind ? cc.warn = console.warn.bind(console) : cc.warn = (false, function() {
          return console.warn.apply(console, arguments);
        });
      }
      false;
      if (mode === DebugMode.INFO) {
        false, false;
        console.log.bind ? cc.log = console.log.bind(console) : cc.log = function() {
          return console.log.apply(console, arguments);
        };
      }
    };
    cc._throw = function(error) {
      utils.callInNextTick((function() {
        throw error;
      }));
    };
    function getTypedFormatter(type) {
      return function() {
        var id = arguments[0];
        var msg = debugInfos[id] || "unknown id";
        if (1 === arguments.length) return msg;
        if (2 === arguments.length) return cc.js.formatStr(msg, arguments[1]);
        var argsArray = cc.js.shiftArguments.apply(null, arguments);
        return cc.js.formatStr.apply(null, [ msg ].concat(argsArray));
      };
    }
    var logFormatter = getTypedFormatter("Log");
    cc.logID = function() {
      cc.log(logFormatter.apply(null, arguments));
    };
    var warnFormatter = getTypedFormatter("Warning");
    cc.warnID = function() {
      cc.warn(warnFormatter.apply(null, arguments));
    };
    var errorFormatter = getTypedFormatter("Error");
    cc.errorID = function() {
      cc.error(errorFormatter.apply(null, arguments));
    };
    var assertFormatter = getTypedFormatter("Assert");
    cc.assertID = function(cond) {
      if (cond) return;
      cc.assert(false, assertFormatter.apply(null, cc.js.shiftArguments.apply(null, arguments)));
    };
    var DebugMode = cc.Enum({
      NONE: 0,
      INFO: 1,
      WARN: 2,
      ERROR: 3,
      INFO_FOR_WEB_PAGE: 4,
      WARN_FOR_WEB_PAGE: 5,
      ERROR_FOR_WEB_PAGE: 6
    });
    module.exports = cc.debug = {
      DebugMode: DebugMode,
      _resetDebugSetting: resetDebugSetting,
      getError: getTypedFormatter("ERROR"),
      isDisplayStats: function isDisplayStats() {
        return !!cc.profiler && cc.profiler.isShowingStats();
      },
      setDisplayStats: function setDisplayStats(displayStats) {
        if (cc.profiler && cc.game.renderType !== cc.game.RENDER_TYPE_CANVAS) {
          displayStats ? cc.profiler.showStats() : cc.profiler.hideStats();
          cc.game.config.showFPS = !!displayStats;
        }
      }
    };
  }), {
    "../../DebugInfos": 1,
    "./platform/utils": 161
  } ],
  24: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("./event/event-target");
    var ComponentScheduler = require("./component-scheduler");
    var NodeActivator = require("./node-activator");
    var Obj = require("./platform/CCObject");
    var game = require("./CCGame");
    var renderer = require("./renderer");
    var eventManager = require("./event-manager");
    var Scheduler = require("./CCScheduler");
    cc.Director = function() {
      EventTarget.call(this);
      this._paused = false;
      this._purgeDirectorInNextLoop = false;
      this._winSizeInPoints = null;
      this._scene = null;
      this._loadingScene = "";
      this._totalFrames = 0;
      this._lastUpdate = 0;
      this._deltaTime = 0;
      this._startTime = 0;
      this._maxParticleDeltaTime = 0;
      this._scheduler = null;
      this._compScheduler = null;
      this._nodeActivator = null;
      this._actionManager = null;
      var self = this;
      game.on(game.EVENT_SHOW, (function() {
        self._lastUpdate = performance.now();
      }));
      game.once(game.EVENT_ENGINE_INITED, this.init, this);
    };
    cc.Director.prototype = {
      constructor: cc.Director,
      init: function init() {
        this._totalFrames = 0;
        this._lastUpdate = performance.now();
        this._startTime = this._lastUpdate;
        this._paused = false;
        this._purgeDirectorInNextLoop = false;
        this._winSizeInPoints = cc.size(0, 0);
        this._scheduler = new Scheduler();
        if (cc.ActionManager) {
          this._actionManager = new cc.ActionManager();
          this._scheduler.scheduleUpdate(this._actionManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._actionManager = null;
        this.sharedInit();
        return true;
      },
      sharedInit: function sharedInit() {
        this._compScheduler = new ComponentScheduler();
        this._nodeActivator = new NodeActivator();
        eventManager && eventManager.setEnabled(true);
        if (cc.AnimationManager) {
          this._animationManager = new cc.AnimationManager();
          this._scheduler.scheduleUpdate(this._animationManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._animationManager = null;
        if (cc.CollisionManager) {
          this._collisionManager = new cc.CollisionManager();
          this._scheduler.scheduleUpdate(this._collisionManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._collisionManager = null;
        if (cc.PhysicsManager) {
          this._physicsManager = new cc.PhysicsManager();
          this._scheduler.scheduleUpdate(this._physicsManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._physicsManager = null;
        if (cc.Physics3DManager) {
          this._physics3DManager = new cc.Physics3DManager();
          this._scheduler.scheduleUpdate(this._physics3DManager, Scheduler.PRIORITY_SYSTEM, false);
        } else this._physics3DManager = null;
        cc._widgetManager && cc._widgetManager.init(this);
      },
      calculateDeltaTime: function calculateDeltaTime(now) {
        now || (now = performance.now());
        this._deltaTime = now > this._lastUpdate ? (now - this._lastUpdate) / 1e3 : 0;
        (true, this._deltaTime > 1) && (this._deltaTime = 1 / 60);
        this._lastUpdate = now;
      },
      convertToGL: function convertToGL(uiPoint) {
        var container = game.container;
        var view = cc.view;
        var box = container.getBoundingClientRect();
        var left = box.left + window.pageXOffset - container.clientLeft;
        var top = box.top + window.pageYOffset - container.clientTop;
        var x = view._devicePixelRatio * (uiPoint.x - left);
        var y = view._devicePixelRatio * (top + box.height - uiPoint.y);
        return view._isRotated ? cc.v2(view._viewportRect.width - y, x) : cc.v2(x, y);
      },
      convertToUI: function convertToUI(glPoint) {
        var container = game.container;
        var view = cc.view;
        var box = container.getBoundingClientRect();
        var left = box.left + window.pageXOffset - container.clientLeft;
        var top = box.top + window.pageYOffset - container.clientTop;
        var uiPoint = cc.v2(0, 0);
        if (view._isRotated) {
          uiPoint.x = left + glPoint.y / view._devicePixelRatio;
          uiPoint.y = top + box.height - (view._viewportRect.width - glPoint.x) / view._devicePixelRatio;
        } else {
          uiPoint.x = left + glPoint.x * view._devicePixelRatio;
          uiPoint.y = top + box.height - glPoint.y * view._devicePixelRatio;
        }
        return uiPoint;
      },
      end: function end() {
        this._purgeDirectorInNextLoop = true;
      },
      getWinSize: function getWinSize() {
        return cc.size(cc.winSize);
      },
      getWinSizeInPixels: function getWinSizeInPixels() {
        return cc.size(cc.winSize);
      },
      pause: function pause() {
        if (this._paused) return;
        this._paused = true;
      },
      purgeCachedData: function purgeCachedData() {
        cc.assetManager.releaseAll();
      },
      purgeDirector: function purgeDirector() {
        this._scheduler.unscheduleAll();
        this._compScheduler.unscheduleAll();
        this._nodeActivator.reset();
        eventManager && eventManager.setEnabled(false);
        true;
        cc.isValid(this._scene) && this._scene.destroy();
        this._scene = null;
        cc.renderer.clear();
        cc.assetManager.builtins.clear();
        cc.game.pause();
        cc.assetManager.releaseAll();
      },
      reset: function reset() {
        this.purgeDirector();
        eventManager && eventManager.setEnabled(true);
        this._actionManager && this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._animationManager && this._scheduler.scheduleUpdate(this._animationManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._collisionManager && this._scheduler.scheduleUpdate(this._collisionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        this._physicsManager && this._scheduler.scheduleUpdate(this._physicsManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        cc.game.resume();
      },
      runSceneImmediate: function runSceneImmediate(scene, onBeforeLoadScene, onLaunched) {
        cc.assertID(scene instanceof cc.Scene || scene instanceof cc.SceneAsset, 1216);
        scene instanceof cc.SceneAsset && (scene = scene.scene);
        (true, true) && console.time("InitScene");
        scene._load();
        (true, true) && console.timeEnd("InitScene");
        (true, true) && console.time("AttachPersist");
        var persistNodeList = Object.keys(game._persistRootNodes).map((function(x) {
          return game._persistRootNodes[x];
        }));
        for (var i = 0; i < persistNodeList.length; i++) {
          var node = persistNodeList[i];
          var existNode = scene.getChildByUuid(node.uuid);
          if (existNode) {
            var index = existNode.getSiblingIndex();
            existNode._destroyImmediate();
            scene.insertChild(node, index);
          } else node.parent = scene;
        }
        (true, true) && console.timeEnd("AttachPersist");
        var oldScene = this._scene;
        true;
        (true, true) && console.time("AutoRelease");
        cc.assetManager._releaseManager._autoRelease(oldScene, scene, persistNodeList);
        (true, true) && console.timeEnd("AutoRelease");
        (true, true) && console.time("Destroy");
        cc.isValid(oldScene) && oldScene.destroy();
        this._scene = null;
        Obj._deferredDestroy();
        (true, true) && console.timeEnd("Destroy");
        onBeforeLoadScene && onBeforeLoadScene();
        this.emit(cc.Director.EVENT_BEFORE_SCENE_LAUNCH, scene);
        this._scene = scene;
        (true, true) && console.time("Activate");
        scene._activate();
        (true, true) && console.timeEnd("Activate");
        cc.game.resume();
        onLaunched && onLaunched(null, scene);
        this.emit(cc.Director.EVENT_AFTER_SCENE_LAUNCH, scene);
      },
      runScene: function runScene(scene, onBeforeLoadScene, onLaunched) {
        cc.assertID(scene, 1205);
        cc.assertID(scene instanceof cc.Scene || scene instanceof cc.SceneAsset, 1216);
        scene instanceof cc.SceneAsset && (scene = scene.scene);
        scene._load();
        this.once(cc.Director.EVENT_AFTER_DRAW, (function() {
          this.runSceneImmediate(scene, onBeforeLoadScene, onLaunched);
        }), this);
      },
      loadScene: function loadScene(sceneName, onLaunched, _onUnloaded) {
        if (this._loadingScene) {
          cc.warnID(1208, sceneName, this._loadingScene);
          return false;
        }
        var bundle = cc.assetManager.bundles.find((function(bundle) {
          return bundle.getSceneInfo(sceneName);
        }));
        if (bundle) {
          this.emit(cc.Director.EVENT_BEFORE_SCENE_LOADING, sceneName);
          this._loadingScene = sceneName;
          var self = this;
          console.time("LoadScene " + sceneName);
          bundle.loadScene(sceneName, (function(err, scene) {
            console.timeEnd("LoadScene " + sceneName);
            self._loadingScene = "";
            if (!err) {
              self.runSceneImmediate(scene, _onUnloaded, onLaunched);
              return;
            }
            err = "Failed to load scene: " + err;
            cc.error(err);
            onLaunched && onLaunched(err);
          }));
          return true;
        }
        cc.errorID(1209, sceneName);
        return false;
      },
      preloadScene: function preloadScene(sceneName, onProgress, onLoaded) {
        var bundle = cc.assetManager.bundles.find((function(bundle) {
          return bundle.getSceneInfo(sceneName);
        }));
        if (!bundle) {
          cc.errorID(1209, sceneName);
          return null;
        }
        bundle.preloadScene(sceneName, null, onProgress, onLoaded);
      },
      resume: function resume() {
        if (!this._paused) return;
        this._lastUpdate = performance.now();
        this._lastUpdate || cc.logID(1200);
        this._paused = false;
        this._deltaTime = 0;
      },
      setDepthTest: function setDepthTest(value) {
        if (!cc.Camera.main) return;
        cc.Camera.main.depth = !!value;
      },
      setClearColor: function setClearColor(clearColor) {
        if (!cc.Camera.main) return;
        cc.Camera.main.backgroundColor = clearColor;
      },
      getRunningScene: function getRunningScene() {
        return this._scene;
      },
      getScene: function getScene() {
        return this._scene;
      },
      getAnimationInterval: function getAnimationInterval() {
        return 1e3 / game.getFrameRate();
      },
      setAnimationInterval: function setAnimationInterval(value) {
        game.setFrameRate(Math.round(1e3 / value));
      },
      getDeltaTime: function getDeltaTime() {
        return this._deltaTime;
      },
      getTotalTime: function getTotalTime() {
        return performance.now() - this._startTime;
      },
      getTotalFrames: function getTotalFrames() {
        return this._totalFrames;
      },
      isPaused: function isPaused() {
        return this._paused;
      },
      getScheduler: function getScheduler() {
        return this._scheduler;
      },
      setScheduler: function setScheduler(scheduler) {
        this._scheduler !== scheduler && (this._scheduler = scheduler);
      },
      getActionManager: function getActionManager() {
        return this._actionManager;
      },
      setActionManager: function setActionManager(actionManager) {
        if (this._actionManager !== actionManager) {
          this._actionManager && this._scheduler.unscheduleUpdate(this._actionManager);
          this._actionManager = actionManager;
          this._scheduler.scheduleUpdate(this._actionManager, cc.Scheduler.PRIORITY_SYSTEM, false);
        }
      },
      getAnimationManager: function getAnimationManager() {
        return this._animationManager;
      },
      getCollisionManager: function getCollisionManager() {
        return this._collisionManager;
      },
      getPhysicsManager: function getPhysicsManager() {
        return this._physicsManager;
      },
      getPhysics3DManager: function getPhysics3DManager() {
        return this._physics3DManager;
      },
      startAnimation: function startAnimation() {
        cc.game.resume();
      },
      stopAnimation: function stopAnimation() {
        cc.game.pause();
      },
      _resetDeltaTime: function _resetDeltaTime() {
        this._lastUpdate = performance.now();
        this._deltaTime = 0;
      },
      mainLoop: function(now) {
        if (this._purgeDirectorInNextLoop) {
          this._purgeDirectorInNextLoop = false;
          this.purgeDirector();
        } else {
          this.calculateDeltaTime(now);
          if (!this._paused) {
            this.emit(cc.Director.EVENT_BEFORE_UPDATE);
            this._compScheduler.startPhase();
            this._compScheduler.updatePhase(this._deltaTime);
            this._scheduler.update(this._deltaTime);
            this._compScheduler.lateUpdatePhase(this._deltaTime);
            this.emit(cc.Director.EVENT_AFTER_UPDATE);
            Obj._deferredDestroy();
          }
          this.emit(cc.Director.EVENT_BEFORE_DRAW);
          renderer.render(this._scene, this._deltaTime);
          this.emit(cc.Director.EVENT_AFTER_DRAW);
          eventManager.frameUpdateListeners();
          this._totalFrames++;
        }
      },
      __fastOn: function __fastOn(type, callback, target) {
        this.on(type, callback, target);
      },
      __fastOff: function __fastOff(type, callback, target) {
        this.off(type, callback, target);
      }
    };
    cc.js.addon(cc.Director.prototype, EventTarget.prototype);
    cc.Director.EVENT_PROJECTION_CHANGED = "director_projection_changed";
    cc.Director.EVENT_BEFORE_SCENE_LOADING = "director_before_scene_loading";
    cc.Director.EVENT_BEFORE_SCENE_LAUNCH = "director_before_scene_launch";
    cc.Director.EVENT_AFTER_SCENE_LAUNCH = "director_after_scene_launch";
    cc.Director.EVENT_BEFORE_UPDATE = "director_before_update";
    cc.Director.EVENT_AFTER_UPDATE = "director_after_update";
    cc.Director.EVENT_BEFORE_VISIT = "director_before_draw";
    cc.Director.EVENT_AFTER_VISIT = "director_before_draw";
    cc.Director.EVENT_BEFORE_DRAW = "director_before_draw";
    cc.Director.EVENT_AFTER_DRAW = "director_after_draw";
    cc.Director.PROJECTION_2D = 0;
    cc.Director.PROJECTION_3D = 1;
    cc.Director.PROJECTION_CUSTOM = 3;
    cc.Director.PROJECTION_DEFAULT = cc.Director.PROJECTION_2D;
    cc.Director.EVENT_BEFORE_PHYSICS = "director_before_physics";
    cc.Director.EVENT_AFTER_PHYSICS = "director_after_physics";
    cc.director = new cc.Director();
    module.exports = cc.director;
  }), {
    "./CCGame": 25,
    "./CCScheduler": 29,
    "./component-scheduler": 88,
    "./event-manager": 119,
    "./event/event-target": 121,
    "./node-activator": 137,
    "./platform/CCObject": 144,
    "./renderer": 168
  } ],
  25: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("./event/event-target");
    require("../audio/CCAudioEngine");
    var debug = require("./CCDebug");
    var renderer = require("./renderer/index.js");
    var dynamicAtlasManager = require("../core/renderer/utils/dynamic-atlas/manager");
    var game = {
      EVENT_HIDE: "game_on_hide",
      EVENT_SHOW: "game_on_show",
      EVENT_RESTART: "game_on_restart",
      EVENT_GAME_INITED: "game_inited",
      EVENT_ENGINE_INITED: "engine_inited",
      EVENT_RENDERER_INITED: "engine_inited",
      RENDER_TYPE_CANVAS: 0,
      RENDER_TYPE_WEBGL: 1,
      RENDER_TYPE_OPENGL: 2,
      _persistRootNodes: {},
      _paused: true,
      _configLoaded: false,
      _isCloning: false,
      _prepared: false,
      _rendererInitialized: false,
      _renderContext: null,
      _intervalId: null,
      _lastTime: null,
      _frameTime: null,
      frame: null,
      container: null,
      canvas: null,
      renderType: -1,
      config: null,
      onStart: null,
      setFrameRate: function setFrameRate(frameRate) {
        var config = this.config;
        config.frameRate = frameRate;
        this._intervalId && window.cancelAnimFrame(this._intervalId);
        this._intervalId = 0;
        this._paused = true;
        this._setAnimFrame();
        this._runMainLoop();
      },
      getFrameRate: function getFrameRate() {
        return this.config.frameRate;
      },
      step: function step() {
        cc.director.mainLoop();
      },
      pause: function pause() {
        if (this._paused) return;
        this._paused = true;
        cc.audioEngine && cc.audioEngine._break();
        this._intervalId && window.cancelAnimFrame(this._intervalId);
        this._intervalId = 0;
      },
      resume: function resume() {
        if (!this._paused) return;
        this._paused = false;
        cc.audioEngine && cc.audioEngine._restore();
        cc.director._resetDeltaTime();
        this._runMainLoop();
      },
      isPaused: function isPaused() {
        return this._paused;
      },
      restart: function restart() {
        cc.director.once(cc.Director.EVENT_AFTER_DRAW, (function() {
          for (var id in game._persistRootNodes) game.removePersistRootNode(game._persistRootNodes[id]);
          cc.director.getScene().destroy();
          cc.Object._deferredDestroy();
          cc.audioEngine && cc.audioEngine.uncacheAll();
          cc.director.reset();
          game.pause();
          cc.assetManager.builtins.init((function() {
            game.onStart();
            game.emit(game.EVENT_RESTART);
          }));
        }));
      },
      end: function end() {
        close();
      },
      _initEngine: function _initEngine() {
        if (this._rendererInitialized) return;
        this._initRenderer();
        true;
        this._initEvents();
        this.emit(this.EVENT_ENGINE_INITED);
      },
      _loadPreviewScript: function _loadPreviewScript(cb) {
        false;
        cb();
      },
      _prepareFinished: function _prepareFinished(cb) {
        var _this = this;
        this._initEngine();
        this._setAnimFrame();
        cc.assetManager.builtins.init((function() {
          console.log("Cocos Creator v" + cc.ENGINE_VERSION);
          _this._prepared = true;
          _this._runMainLoop();
          _this.emit(_this.EVENT_GAME_INITED);
          cb && cb();
        }));
      },
      eventTargetOn: EventTarget.prototype.on,
      eventTargetOnce: EventTarget.prototype.once,
      on: function on(type, callback, target, once) {
        this._prepared && type === this.EVENT_ENGINE_INITED || !this._paused && type === this.EVENT_GAME_INITED ? callback.call(target) : this.eventTargetOn(type, callback, target, once);
      },
      once: function once(type, callback, target) {
        this._prepared && type === this.EVENT_ENGINE_INITED || !this._paused && type === this.EVENT_GAME_INITED ? callback.call(target) : this.eventTargetOnce(type, callback, target);
      },
      prepare: function prepare(cb) {
        var _this2 = this;
        if (this._prepared) {
          cb && cb();
          return;
        }
        this._loadPreviewScript((function() {
          _this2._prepareFinished(cb);
        }));
      },
      run: function run(config, onStart) {
        this._initConfig(config);
        this.onStart = onStart;
        this.prepare(game.onStart && game.onStart.bind(game));
      },
      addPersistRootNode: function addPersistRootNode(node) {
        if (!cc.Node.isNode(node) || !node.uuid) {
          cc.warnID(3800);
          return;
        }
        var id = node.uuid;
        if (!this._persistRootNodes[id]) {
          var scene = cc.director._scene;
          if (cc.isValid(scene)) if (node.parent) {
            if (!(node.parent instanceof cc.Scene)) {
              cc.warnID(3801);
              return;
            }
            if (node.parent !== scene) {
              cc.warnID(3802);
              return;
            }
          } else node.parent = scene;
          this._persistRootNodes[id] = node;
          node._persistNode = true;
          cc.assetManager._releaseManager._addPersistNodeRef(node);
        }
      },
      removePersistRootNode: function removePersistRootNode(node) {
        var id = node.uuid || "";
        if (node === this._persistRootNodes[id]) {
          delete this._persistRootNodes[id];
          node._persistNode = false;
          cc.assetManager._releaseManager._removePersistNodeRef(node);
        }
      },
      isPersistRootNode: function isPersistRootNode(node) {
        return node._persistNode;
      },
      _setAnimFrame: function _setAnimFrame() {
        this._lastTime = performance.now();
        var frameRate = game.config.frameRate;
        this._frameTime = 1e3 / frameRate;
        cc.director._maxParticleDeltaTime = this._frameTime / 1e3 * 2;
        false, false;
        if (60 !== frameRate && 30 !== frameRate) {
          window.requestAnimFrame = this._stTime;
          window.cancelAnimFrame = this._ctTime;
        } else {
          window.requestAnimFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || this._stTime;
          window.cancelAnimFrame = window.cancelAnimationFrame || window.cancelRequestAnimationFrame || window.msCancelRequestAnimationFrame || window.mozCancelRequestAnimationFrame || window.oCancelRequestAnimationFrame || window.webkitCancelRequestAnimationFrame || window.msCancelAnimationFrame || window.mozCancelAnimationFrame || window.webkitCancelAnimationFrame || window.oCancelAnimationFrame || this._ctTime;
        }
      },
      _stTime: function _stTime(callback) {
        var currTime = performance.now();
        var timeToCall = Math.max(0, game._frameTime - (currTime - game._lastTime));
        var id = window.setTimeout((function() {
          callback();
        }), timeToCall);
        game._lastTime = currTime + timeToCall;
        return id;
      },
      _ctTime: function _ctTime(id) {
        window.clearTimeout(id);
      },
      _runMainLoop: function _runMainLoop() {
        false;
        if (!this._prepared) return;
        var self = this, _callback, config = self.config, director = cc.director, skip = true, frameRate = config.frameRate;
        debug.setDisplayStats(config.showFPS);
        _callback = function callback(now) {
          if (!self._paused) {
            self._intervalId = window.requestAnimFrame(_callback);
            if ((true, true) && 30 === frameRate && (skip = !skip)) return;
            director.mainLoop(now);
          }
        };
        self._intervalId = window.requestAnimFrame(_callback);
        self._paused = false;
      },
      _initConfig: function _initConfig(config) {
        "number" !== typeof config.debugMode && (config.debugMode = 0);
        config.exposeClassName = !!config.exposeClassName;
        "number" !== typeof config.frameRate && (config.frameRate = 60);
        var renderMode = config.renderMode;
        ("number" !== typeof renderMode || renderMode > 2 || renderMode < 0) && (config.renderMode = 0);
        "boolean" !== typeof config.registerSystemEvent && (config.registerSystemEvent = true);
        config.showFPS = 1 !== renderMode && !!config.showFPS;
        this.collisionMatrix = config.collisionMatrix || [];
        this.groupList = config.groupList || [];
        debug._resetDebugSetting(config.debugMode);
        this.config = config;
        this._configLoaded = true;
      },
      _determineRenderType: function _determineRenderType() {
        var config = this.config, userRenderMode = parseInt(config.renderMode) || 0;
        this.renderType = this.RENDER_TYPE_CANVAS;
        var supportRender = false;
        if (0 === userRenderMode) {
          if (cc.sys.capabilities["opengl"]) {
            this.renderType = this.RENDER_TYPE_WEBGL;
            supportRender = true;
          } else if (cc.sys.capabilities["canvas"]) {
            this.renderType = this.RENDER_TYPE_CANVAS;
            supportRender = true;
          }
        } else if (1 === userRenderMode && cc.sys.capabilities["canvas"]) {
          this.renderType = this.RENDER_TYPE_CANVAS;
          supportRender = true;
        } else if (2 === userRenderMode && cc.sys.capabilities["opengl"]) {
          this.renderType = this.RENDER_TYPE_WEBGL;
          supportRender = true;
        }
        if (!supportRender) throw new Error(debug.getError(3820, userRenderMode));
      },
      _initRenderer: function _initRenderer() {
        if (this._rendererInitialized) return;
        var el = this.config.id, width, height, localCanvas, localContainer;
        false, false;
        var addClass = function addClass(element, name) {
          var hasClass = (" " + element.className + " ").indexOf(" " + name + " ") > -1;
          if (!hasClass) {
            element.className && (element.className += " ");
            element.className += name;
          }
        };
        var element = el instanceof HTMLElement ? el : document.querySelector(el) || document.querySelector("#" + el);
        if ("CANVAS" === element.tagName) {
          width = element.width;
          height = element.height;
          this.canvas = localCanvas = element;
          this.container = localContainer = document.createElement("DIV");
          localCanvas.parentNode && localCanvas.parentNode.insertBefore(localContainer, localCanvas);
        } else {
          "DIV" !== element.tagName && cc.warnID(3819);
          width = element.clientWidth;
          height = element.clientHeight;
          this.canvas = localCanvas = document.createElement("CANVAS");
          this.container = localContainer = document.createElement("DIV");
          element.appendChild(localContainer);
        }
        localContainer.setAttribute("id", "Cocos2dGameContainer");
        localContainer.appendChild(localCanvas);
        this.frame = localContainer.parentNode === document.body ? document.documentElement : localContainer.parentNode;
        addClass(localCanvas, "gameCanvas");
        localCanvas.setAttribute("width", width || 480);
        localCanvas.setAttribute("height", height || 320);
        localCanvas.setAttribute("tabindex", 99);
        this._determineRenderType();
        if (this.renderType === this.RENDER_TYPE_WEBGL) {
          var opts = {
            stencil: true,
            antialias: cc.macro.ENABLE_WEBGL_ANTIALIAS,
            alpha: cc.macro.ENABLE_TRANSPARENT_CANVAS
          };
          renderer.initWebGL(localCanvas, opts);
          this._renderContext = renderer.device._gl;
          !cc.macro.CLEANUP_IMAGE_CACHE && dynamicAtlasManager && (dynamicAtlasManager.enabled = true);
        }
        if (!this._renderContext) {
          this.renderType = this.RENDER_TYPE_CANVAS;
          renderer.initCanvas(localCanvas);
          this._renderContext = renderer.device._ctx;
        }
        this.canvas.oncontextmenu = function() {
          if (!cc._isContextMenuEnable) return false;
        };
        this._rendererInitialized = true;
      },
      _initEvents: function _initEvents() {
        var win = window, hiddenPropName;
        this.config.registerSystemEvent && cc.internal.inputManager.registerSystemEvent(this.canvas);
        "undefined" !== typeof document.hidden ? hiddenPropName = "hidden" : "undefined" !== typeof document.mozHidden ? hiddenPropName = "mozHidden" : "undefined" !== typeof document.msHidden ? hiddenPropName = "msHidden" : "undefined" !== typeof document.webkitHidden && (hiddenPropName = "webkitHidden");
        var hidden = false;
        function onHidden() {
          if (!hidden) {
            hidden = true;
            game.emit(game.EVENT_HIDE);
          }
        }
        function onShown(arg0, arg1, arg2, arg3, arg4) {
          if (hidden) {
            hidden = false;
            game.emit(game.EVENT_SHOW, arg0, arg1, arg2, arg3, arg4);
          }
        }
        if (hiddenPropName) {
          var changeList = [ "visibilitychange", "mozvisibilitychange", "msvisibilitychange", "webkitvisibilitychange", "qbrowserVisibilityChange" ];
          for (var i = 0; i < changeList.length; i++) document.addEventListener(changeList[i], (function(event) {
            var visible = document[hiddenPropName];
            visible = visible || event["hidden"];
            visible ? onHidden() : onShown();
          }));
        } else {
          win.addEventListener("blur", onHidden);
          win.addEventListener("focus", onShown);
        }
        navigator.userAgent.indexOf("MicroMessenger") > -1 && (win.onfocus = onShown);
        if ("onpageshow" in window && "onpagehide" in window) {
          win.addEventListener("pagehide", onHidden);
          win.addEventListener("pageshow", onShown);
          document.addEventListener("pagehide", onHidden);
          document.addEventListener("pageshow", onShown);
        }
        this.on(game.EVENT_HIDE, (function() {
          game.pause();
        }));
        this.on(game.EVENT_SHOW, (function() {
          game.resume();
        }));
      }
    };
    EventTarget.call(game);
    cc.js.addon(game, EventTarget.prototype);
    cc.game = module.exports = game;
  }), {
    "../audio/CCAudioEngine": 22,
    "../core/renderer/utils/dynamic-atlas/manager": void 0,
    "./CCDebug": 23,
    "./event/event-target": 121,
    "./renderer/index.js": 168
  } ],
  26: [ (function(require, module, exports) {
    "use strict";
    var _valueTypes = require("./value-types");
    var BaseNode = require("./utils/base-node");
    var PrefabHelper = require("./utils/prefab-helper");
    var nodeMemPool = require("./utils/trans-pool").NodeMemPool;
    var AffineTrans = require("./utils/affine-transform");
    var eventManager = require("./event-manager");
    var macro = require("./platform/CCMacro");
    var js = require("./platform/js");
    var Event = require("./event/event");
    var EventTarget = require("./event/event-target");
    var RenderFlow = require("./renderer/render-flow");
    var Flags = cc.Object.Flags;
    var Destroying = Flags.Destroying;
    var ERR_INVALID_NUMBER = false;
    var ONE_DEGREE = Math.PI / 180;
    var ActionManagerExist = !!cc.ActionManager;
    var emptyFunc = function emptyFunc() {};
    var _gwpVec3 = new _valueTypes.Vec3();
    var _gwpQuat = new _valueTypes.Quat();
    var _tpVec3a = new _valueTypes.Vec3();
    var _tpVec3b = new _valueTypes.Vec3();
    var _tpQuata = new _valueTypes.Quat();
    var _tpQuatb = new _valueTypes.Quat();
    var _swpVec3 = new _valueTypes.Vec3();
    var _gwsVec3 = new _valueTypes.Vec3();
    var _swsVec3 = new _valueTypes.Vec3();
    var _gwrtVec3a = new _valueTypes.Vec3();
    var _gwrtVec3b = new _valueTypes.Vec3();
    var _gwrtQuata = new _valueTypes.Quat();
    var _gwrtQuatb = new _valueTypes.Quat();
    var _laVec3 = new _valueTypes.Vec3();
    var _laQuat = new _valueTypes.Quat();
    var _urfVec3 = new _valueTypes.Vec3();
    var _urfQuat = new _valueTypes.Quat();
    var _htVec3a = new _valueTypes.Vec3();
    var _htVec3b = new _valueTypes.Vec3();
    var _gwrQuat = new _valueTypes.Quat();
    var _swrQuat = new _valueTypes.Quat();
    var _quata = new _valueTypes.Quat();
    var _mat4_temp = cc.mat4();
    var _vec3_temp = new _valueTypes.Vec3();
    var _cachedArray = new Array(16);
    _cachedArray.length = 0;
    var POSITION_ON = 1;
    var SCALE_ON = 2;
    var ROTATION_ON = 4;
    var SIZE_ON = 8;
    var ANCHOR_ON = 16;
    var COLOR_ON = 32;
    var BuiltinGroupIndex = cc.Enum({
      DEBUG: 31
    });
    var LocalDirtyFlag = cc.Enum({
      POSITION: 1,
      SCALE: 2,
      ROTATION: 4,
      SKEW: 8,
      TRS: 7,
      RS: 6,
      TRSS: 15,
      PHYSICS_POSITION: 16,
      PHYSICS_SCALE: 32,
      PHYSICS_ROTATION: 64,
      PHYSICS_TRS: 112,
      PHYSICS_RS: 96,
      ALL_POSITION: 17,
      ALL_SCALE: 34,
      ALL_ROTATION: 68,
      ALL_TRS: 119,
      ALL: 65535
    });
    var EventType = cc.Enum({
      TOUCH_START: "touchstart",
      TOUCH_MOVE: "touchmove",
      TOUCH_END: "touchend",
      TOUCH_CANCEL: "touchcancel",
      MOUSE_DOWN: "mousedown",
      MOUSE_MOVE: "mousemove",
      MOUSE_ENTER: "mouseenter",
      MOUSE_LEAVE: "mouseleave",
      MOUSE_UP: "mouseup",
      MOUSE_WHEEL: "mousewheel",
      POSITION_CHANGED: "position-changed",
      ROTATION_CHANGED: "rotation-changed",
      SCALE_CHANGED: "scale-changed",
      SIZE_CHANGED: "size-changed",
      ANCHOR_CHANGED: "anchor-changed",
      COLOR_CHANGED: "color-changed",
      CHILD_ADDED: "child-added",
      CHILD_REMOVED: "child-removed",
      CHILD_REORDER: "child-reorder",
      GROUP_CHANGED: "group-changed",
      SIBLING_ORDER_CHANGED: "sibling-order-changed"
    });
    var _touchEvents = [ EventType.TOUCH_START, EventType.TOUCH_MOVE, EventType.TOUCH_END, EventType.TOUCH_CANCEL ];
    var _mouseEvents = [ EventType.MOUSE_DOWN, EventType.MOUSE_ENTER, EventType.MOUSE_MOVE, EventType.MOUSE_LEAVE, EventType.MOUSE_UP, EventType.MOUSE_WHEEL ];
    var _skewNeedWarn = true;
    var _skewWarn = function _skewWarn(value, node) {
      if (0 !== value) {
        var nodePath = "";
        var NodeUtils;
        false;
        _skewNeedWarn && cc.warn("`cc.Node.skewX/Y` is deprecated since v2.2.1, please use 3D node instead.", nodePath);
        true, _skewNeedWarn = false;
      }
    };
    var _currentHovered = null;
    var _touchStartHandler = function _touchStartHandler(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.TOUCH_START;
        event.touch = touch;
        event.bubbles = true;
        node.dispatchEvent(event);
        return true;
      }
      return false;
    };
    var _touchMoveHandler = function _touchMoveHandler(touch, event) {
      var node = this.owner;
      event.type = EventType.TOUCH_MOVE;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _touchEndHandler = function _touchEndHandler(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      node._hitTest(pos, this) ? event.type = EventType.TOUCH_END : event.type = EventType.TOUCH_CANCEL;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _touchCancelHandler = function _touchCancelHandler(touch, event) {
      var pos = touch.getLocation();
      var node = this.owner;
      event.type = EventType.TOUCH_CANCEL;
      event.touch = touch;
      event.bubbles = true;
      node.dispatchEvent(event);
    };
    var _mouseDownHandler = function _mouseDownHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_DOWN;
        event.bubbles = true;
        node.dispatchEvent(event);
      }
    };
    var _mouseMoveHandler = function _mouseMoveHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      var hit = node._hitTest(pos, this);
      if (hit) {
        if (!this._previousIn) {
          if (_currentHovered && _currentHovered._mouseListener) {
            event.type = EventType.MOUSE_LEAVE;
            _currentHovered.dispatchEvent(event);
            _currentHovered._mouseListener._previousIn = false;
          }
          _currentHovered = this.owner;
          event.type = EventType.MOUSE_ENTER;
          node.dispatchEvent(event);
          this._previousIn = true;
        }
        event.type = EventType.MOUSE_MOVE;
        event.bubbles = true;
        node.dispatchEvent(event);
      } else {
        if (!this._previousIn) return;
        event.type = EventType.MOUSE_LEAVE;
        node.dispatchEvent(event);
        this._previousIn = false;
        _currentHovered = null;
      }
      event.stopPropagation();
    };
    var _mouseUpHandler = function _mouseUpHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_UP;
        event.bubbles = true;
        node.dispatchEvent(event);
        event.stopPropagation();
      }
    };
    var _mouseWheelHandler = function _mouseWheelHandler(event) {
      var pos = event.getLocation();
      var node = this.owner;
      if (node._hitTest(pos, this)) {
        event.type = EventType.MOUSE_WHEEL;
        event.bubbles = true;
        node.dispatchEvent(event);
        event.stopPropagation();
      }
    };
    function _searchComponentsInParent(node, comp) {
      if (comp) {
        var index = 0;
        var list = null;
        for (var curr = node; curr && cc.Node.isNode(curr); curr = curr._parent, ++index) if (curr.getComponent(comp)) {
          var next = {
            index: index,
            node: curr
          };
          list ? list.push(next) : list = [ next ];
        }
        return list;
      }
      return null;
    }
    function _checkListeners(node, events) {
      if (!(node._objFlags & Destroying)) {
        if (node._bubblingListeners) for (var i = 0, l = events.length; i < l; ++i) if (node._bubblingListeners.hasEventListener(events[i])) return true;
        if (node._capturingListeners) for (var _i = 0, _l = events.length; _i < _l; ++_i) if (node._capturingListeners.hasEventListener(events[_i])) return true;
        return false;
      }
      return true;
    }
    function _doDispatchEvent(owner, event) {
      var target, i;
      event.target = owner;
      _cachedArray.length = 0;
      owner._getCapturingTargets(event.type, _cachedArray);
      event.eventPhase = 1;
      for (i = _cachedArray.length - 1; i >= 0; --i) {
        target = _cachedArray[i];
        if (target._capturingListeners) {
          event.currentTarget = target;
          target._capturingListeners.emit(event.type, event, _cachedArray);
          if (event._propagationStopped) {
            _cachedArray.length = 0;
            return;
          }
        }
      }
      _cachedArray.length = 0;
      event.eventPhase = 2;
      event.currentTarget = owner;
      owner._capturingListeners && owner._capturingListeners.emit(event.type, event);
      !event._propagationImmediateStopped && owner._bubblingListeners && owner._bubblingListeners.emit(event.type, event);
      if (!event._propagationStopped && event.bubbles) {
        owner._getBubblingTargets(event.type, _cachedArray);
        event.eventPhase = 3;
        for (i = 0; i < _cachedArray.length; ++i) {
          target = _cachedArray[i];
          if (target._bubblingListeners) {
            event.currentTarget = target;
            target._bubblingListeners.emit(event.type, event);
            if (event._propagationStopped) {
              _cachedArray.length = 0;
              return;
            }
          }
        }
      }
      _cachedArray.length = 0;
    }
    function _getActualGroupIndex(node) {
      var groupIndex = node.groupIndex;
      0 === groupIndex && node.parent && (groupIndex = _getActualGroupIndex(node.parent));
      return groupIndex;
    }
    function _updateCullingMask(node) {
      var index = _getActualGroupIndex(node);
      node._cullingMask = 1 << index;
      false;
      for (var i = 0; i < node._children.length; i++) _updateCullingMask(node._children[i]);
    }
    function updateLocalMatrix3D() {
      if (this._localMatDirty & LocalDirtyFlag.TRSS) {
        var t = this._matrix;
        var tm = t.m;
        _valueTypes.Trs.toMat4(t, this._trs);
        if (this._skewX || this._skewY) {
          var a = tm[0], b = tm[1], c = tm[4], d = tm[5];
          var skx = Math.tan(this._skewX * ONE_DEGREE);
          var sky = Math.tan(this._skewY * ONE_DEGREE);
          Infinity === skx && (skx = 99999999);
          Infinity === sky && (sky = 99999999);
          tm[0] = a + c * sky;
          tm[1] = b + d * sky;
          tm[4] = c + a * skx;
          tm[5] = d + b * skx;
        }
        this._localMatDirty &= ~LocalDirtyFlag.TRSS;
        this._worldMatDirty = true;
      }
    }
    function updateLocalMatrix2D() {
      var dirtyFlag = this._localMatDirty;
      if (!(dirtyFlag & LocalDirtyFlag.TRSS)) return;
      var t = this._matrix;
      var tm = t.m;
      var trs = this._trs;
      if (dirtyFlag & (LocalDirtyFlag.RS | LocalDirtyFlag.SKEW)) {
        var rotation = -this._eulerAngles.z;
        var hasSkew = this._skewX || this._skewY;
        var sx = trs[7], sy = trs[8];
        if (rotation || hasSkew) {
          var a = 1, b = 0, c = 0, d = 1;
          if (rotation) {
            var rotationRadians = rotation * ONE_DEGREE;
            c = Math.sin(rotationRadians);
            d = Math.cos(rotationRadians);
            a = d;
            b = -c;
          }
          tm[0] = a *= sx;
          tm[1] = b *= sx;
          tm[4] = c *= sy;
          tm[5] = d *= sy;
          if (hasSkew) {
            var _a = tm[0], _b = tm[1], _c = tm[4], _d = tm[5];
            var skx = Math.tan(this._skewX * ONE_DEGREE);
            var sky = Math.tan(this._skewY * ONE_DEGREE);
            Infinity === skx && (skx = 99999999);
            Infinity === sky && (sky = 99999999);
            tm[0] = _a + _c * sky;
            tm[1] = _b + _d * sky;
            tm[4] = _c + _a * skx;
            tm[5] = _d + _b * skx;
          }
        } else {
          tm[0] = sx;
          tm[1] = 0;
          tm[4] = 0;
          tm[5] = sy;
        }
      }
      tm[12] = trs[0];
      tm[13] = trs[1];
      this._localMatDirty &= ~LocalDirtyFlag.TRSS;
      this._worldMatDirty = true;
    }
    function calculWorldMatrix3D() {
      this._localMatDirty & LocalDirtyFlag.TRSS && this._updateLocalMatrix();
      if (this._parent) {
        var parentMat = this._parent._worldMatrix;
        _valueTypes.Mat4.mul(this._worldMatrix, parentMat, this._matrix);
      } else _valueTypes.Mat4.copy(this._worldMatrix, this._matrix);
      this._worldMatDirty = false;
    }
    function calculWorldMatrix2D() {
      this._localMatDirty & LocalDirtyFlag.TRSS && this._updateLocalMatrix();
      var parent = this._parent;
      parent ? this._mulMat(this._worldMatrix, parent._worldMatrix, this._matrix) : _valueTypes.Mat4.copy(this._worldMatrix, this._matrix);
      this._worldMatDirty = false;
    }
    function mulMat2D(out, a, b) {
      var am = a.m, bm = b.m, outm = out.m;
      var aa = am[0], ab = am[1], ac = am[4], ad = am[5], atx = am[12], aty = am[13];
      var ba = bm[0], bb = bm[1], bc = bm[4], bd = bm[5], btx = bm[12], bty = bm[13];
      if (0 !== ab || 0 !== ac) {
        outm[0] = ba * aa + bb * ac;
        outm[1] = ba * ab + bb * ad;
        outm[4] = bc * aa + bd * ac;
        outm[5] = bc * ab + bd * ad;
        outm[12] = aa * btx + ac * bty + atx;
        outm[13] = ab * btx + ad * bty + aty;
      } else {
        outm[0] = ba * aa;
        outm[1] = bb * ad;
        outm[4] = bc * aa;
        outm[5] = bd * ad;
        outm[12] = aa * btx + atx;
        outm[13] = ad * bty + aty;
      }
    }
    var mulMat3D = _valueTypes.Mat4.mul;
    var NodeDefines = {
      name: "cc.Node",
      extends: BaseNode,
      properties: {
        _opacity: 255,
        _color: cc.Color.WHITE,
        _contentSize: cc.Size,
        _anchorPoint: cc.v2(.5, .5),
        _position: void 0,
        _scale: void 0,
        _trs: null,
        _eulerAngles: cc.Vec3,
        _skewX: 0,
        _skewY: 0,
        _zIndex: {
          default: void 0,
          type: cc.Integer
        },
        _localZOrder: {
          default: 0,
          serializable: false
        },
        _is3DNode: false,
        _groupIndex: {
          default: 0,
          formerlySerializedAs: "groupIndex"
        },
        groupIndex: {
          get: function get() {
            return this._groupIndex;
          },
          set: function set(value) {
            this._groupIndex = value;
            _updateCullingMask(this);
            this.emit(EventType.GROUP_CHANGED, this);
          }
        },
        group: {
          get: function get() {
            return cc.game.groupList[this.groupIndex] || "";
          },
          set: function set(value) {
            this.groupIndex = cc.game.groupList.indexOf(value);
          }
        },
        x: {
          get: function get() {
            return this._trs[0];
          },
          set: function set(value) {
            var trs = this._trs;
            if (value !== trs[0]) {
              true;
              var oldValue;
              false;
              trs[0] = value;
              this.setLocalDirty(LocalDirtyFlag.ALL_POSITION);
              if (this._eventMask & POSITION_ON) {
                false;
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          }
        },
        y: {
          get: function get() {
            return this._trs[1];
          },
          set: function set(value) {
            var trs = this._trs;
            if (value !== trs[1]) {
              true;
              var oldValue;
              false;
              trs[1] = value;
              this.setLocalDirty(LocalDirtyFlag.ALL_POSITION);
              if (this._eventMask & POSITION_ON) {
                false;
                this.emit(EventType.POSITION_CHANGED);
              }
            }
          }
        },
        z: {
          get: function get() {
            return this._trs[2];
          },
          set: function set(value) {
            var trs = this._trs;
            if (value !== trs[2]) {
              true;
              trs[2] = value;
              this.setLocalDirty(LocalDirtyFlag.ALL_POSITION);
              true, this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
              this._eventMask & POSITION_ON && this.emit(EventType.POSITION_CHANGED);
            }
          }
        },
        rotation: {
          get: function get() {
            true;
            cc.warn("`cc.Node.rotation` is deprecated since v2.1.0, please use `-angle` instead. (`this.node.rotation` -> `-this.node.angle`)");
            return -this.angle;
          },
          set: function set(value) {
            true;
            cc.warn("`cc.Node.rotation` is deprecated since v2.1.0, please set `-angle` instead. (`this.node.rotation = x` -> `this.node.angle = -x`)");
            this.angle = -value;
          }
        },
        angle: {
          get: function get() {
            return this._eulerAngles.z;
          },
          set: function set(value) {
            _valueTypes.Vec3.set(this._eulerAngles, 0, 0, value);
            _valueTypes.Trs.fromAngleZ(this._trs, value);
            this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);
            this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
          }
        },
        rotationX: {
          get: function get() {
            true;
            cc.warn("`cc.Node.rotationX` is deprecated since v2.1.0, please use `eulerAngles.x` instead. (`this.node.rotationX` -> `this.node.eulerAngles.x`)");
            return this._eulerAngles.x;
          },
          set: function set(value) {
            true;
            cc.warn("`cc.Node.rotationX` is deprecated since v2.1.0, please set `eulerAngles` instead. (`this.node.rotationX = x` -> `this.node.is3DNode = true; this.node.eulerAngles = cc.v3(x, 0, 0)`");
            if (this._eulerAngles.x !== value) {
              this._eulerAngles.x = value;
              this._eulerAngles.x === this._eulerAngles.y ? _valueTypes.Trs.fromAngleZ(this._trs, -value) : _valueTypes.Trs.fromEulerNumber(this._trs, value, this._eulerAngles.y, 0);
              this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);
              this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            }
          }
        },
        rotationY: {
          get: function get() {
            true;
            cc.warn("`cc.Node.rotationY` is deprecated since v2.1.0, please use `eulerAngles.y` instead. (`this.node.rotationY` -> `this.node.eulerAngles.y`)");
            return this._eulerAngles.y;
          },
          set: function set(value) {
            true;
            cc.warn("`cc.Node.rotationY` is deprecated since v2.1.0, please set `eulerAngles` instead. (`this.node.rotationY = y` -> `this.node.is3DNode = true; this.node.eulerAngles = cc.v3(0, y, 0)`");
            if (this._eulerAngles.y !== value) {
              this._eulerAngles.y = value;
              this._eulerAngles.x === this._eulerAngles.y ? _valueTypes.Trs.fromAngleZ(this._trs, -value) : _valueTypes.Trs.fromEulerNumber(this._trs, this._eulerAngles.x, value, 0);
              this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);
              this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            }
          }
        },
        eulerAngles: {
          get: function get() {
            false;
            return _valueTypes.Trs.toEuler(this._eulerAngles, this._trs);
          },
          set: function set(v) {
            false;
            _valueTypes.Trs.fromEuler(this._trs, v);
            this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);
            true, this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
            this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
          }
        },
        quat: {
          get: function get() {
            var trs = this._trs;
            return new _valueTypes.Quat(trs[3], trs[4], trs[5], trs[6]);
          },
          set: function set(v) {
            this.setRotation(v);
          }
        },
        scale: {
          get: function get() {
            return this._trs[7];
          },
          set: function set(v) {
            this.setScale(v);
          }
        },
        scaleX: {
          get: function get() {
            return this._trs[7];
          },
          set: function set(value) {
            if (this._trs[7] !== value) {
              this._trs[7] = value;
              this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);
              this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
            }
          }
        },
        scaleY: {
          get: function get() {
            return this._trs[8];
          },
          set: function set(value) {
            if (this._trs[8] !== value) {
              this._trs[8] = value;
              this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);
              this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
            }
          }
        },
        scaleZ: {
          get: function get() {
            return this._trs[9];
          },
          set: function set(value) {
            if (this._trs[9] !== value) {
              this._trs[9] = value;
              this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);
              true, this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
              this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
            }
          }
        },
        skewX: {
          get: function get() {
            return this._skewX;
          },
          set: function set(value) {
            _skewWarn(value, this);
            this._skewX = value;
            this.setLocalDirty(LocalDirtyFlag.SKEW);
            false;
          }
        },
        skewY: {
          get: function get() {
            return this._skewY;
          },
          set: function set(value) {
            _skewWarn(value, this);
            this._skewY = value;
            this.setLocalDirty(LocalDirtyFlag.SKEW);
            false;
          }
        },
        opacity: {
          get: function get() {
            return this._opacity;
          },
          set: function set(value) {
            value = cc.misc.clampf(value, 0, 255);
            if (this._opacity !== value) {
              this._opacity = value;
              false;
              this._renderFlag |= RenderFlow.FLAG_OPACITY_COLOR;
            }
          },
          range: [ 0, 255 ]
        },
        color: {
          get: function get() {
            return this._color.clone();
          },
          set: function set(value) {
            if (!this._color.equals(value)) {
              this._color.set(value);
              false;
              this._renderFlag |= RenderFlow.FLAG_COLOR;
              this._eventMask & COLOR_ON && this.emit(EventType.COLOR_CHANGED, value);
            }
          }
        },
        anchorX: {
          get: function get() {
            return this._anchorPoint.x;
          },
          set: function set(value) {
            var anchorPoint = this._anchorPoint;
            if (anchorPoint.x !== value) {
              anchorPoint.x = value;
              this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
            }
          }
        },
        anchorY: {
          get: function get() {
            return this._anchorPoint.y;
          },
          set: function set(value) {
            var anchorPoint = this._anchorPoint;
            if (anchorPoint.y !== value) {
              anchorPoint.y = value;
              this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
            }
          }
        },
        width: {
          get: function get() {
            return this._contentSize.width;
          },
          set: function set(value) {
            if (value !== this._contentSize.width) {
              var clone;
              false;
              this._contentSize.width = value;
              if (this._eventMask & SIZE_ON) {
                false;
                this.emit(EventType.SIZE_CHANGED);
              }
            }
          }
        },
        height: {
          get: function get() {
            return this._contentSize.height;
          },
          set: function set(value) {
            if (value !== this._contentSize.height) {
              var clone;
              false;
              this._contentSize.height = value;
              if (this._eventMask & SIZE_ON) {
                false;
                this.emit(EventType.SIZE_CHANGED);
              }
            }
          }
        },
        zIndex: {
          get: function get() {
            return this._localZOrder >> 16;
          },
          set: function set(value) {
            if (value > macro.MAX_ZINDEX) {
              cc.warnID(1636);
              value = macro.MAX_ZINDEX;
            } else if (value < macro.MIN_ZINDEX) {
              cc.warnID(1637);
              value = macro.MIN_ZINDEX;
            }
            if (this.zIndex !== value) {
              this._localZOrder = 65535 & this._localZOrder | value << 16;
              this.emit(EventType.SIBLING_ORDER_CHANGED);
              this._onSiblingIndexChanged();
            }
          }
        },
        is3DNode: {
          get: function get() {
            return this._is3DNode;
          },
          set: function set(v) {
            this._is3DNode = v;
            this._update3DFunction();
          }
        },
        up: {
          get: function get() {
            var _up = _valueTypes.Vec3.transformQuat(_urfVec3, _valueTypes.Vec3.UP, this.getWorldRotation(_urfQuat));
            return _up.clone();
          }
        },
        right: {
          get: function get() {
            var _right = _valueTypes.Vec3.transformQuat(_urfVec3, _valueTypes.Vec3.RIGHT, this.getWorldRotation(_urfQuat));
            return _right.clone();
          }
        },
        forward: {
          get: function get() {
            var _forward = _valueTypes.Vec3.transformQuat(_urfVec3, _valueTypes.Vec3.FORWARD, this.getWorldRotation(_urfQuat));
            return _forward.clone();
          }
        }
      },
      ctor: function ctor() {
        this._reorderChildDirty = false;
        this._widget = null;
        this._renderComponent = null;
        this._capturingListeners = null;
        this._bubblingListeners = null;
        this._touchListener = null;
        this._mouseListener = null;
        this._initDataFromPool();
        this._eventMask = 0;
        this._cullingMask = 1;
        this._childArrivalOrder = 1;
        false;
        this._renderFlag = RenderFlow.FLAG_TRANSFORM | RenderFlow.FLAG_OPACITY_COLOR;
      },
      statics: {
        EventType: EventType,
        _LocalDirtyFlag: LocalDirtyFlag,
        isNode: function isNode(obj) {
          return obj instanceof Node && (obj.constructor === Node || !(obj instanceof cc.Scene));
        },
        BuiltinGroupIndex: BuiltinGroupIndex
      },
      _onSiblingIndexChanged: function _onSiblingIndexChanged() {
        this._parent && this._parent._delaySort();
      },
      _onPreDestroy: function _onPreDestroy() {
        var destroyByParent = this._onPreDestroyBase();
        ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this);
        _currentHovered === this && (_currentHovered = null);
        if (this._touchListener || this._mouseListener) {
          eventManager.removeListeners(this);
          if (this._touchListener) {
            this._touchListener.owner = null;
            this._touchListener.mask = null;
            this._touchListener = null;
          }
          if (this._mouseListener) {
            this._mouseListener.owner = null;
            this._mouseListener.mask = null;
            this._mouseListener = null;
          }
        }
        false;
        this._backDataIntoPool();
        this._reorderChildDirty && cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        destroyByParent || false;
      },
      _onPostActivated: function _onPostActivated(active) {
        var actionManager = ActionManagerExist ? cc.director.getActionManager() : null;
        if (active) {
          this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
          actionManager && actionManager.resumeTarget(this);
          eventManager.resumeTarget(this);
          this._checkListenerMask();
        } else {
          actionManager && actionManager.pauseTarget(this);
          eventManager.pauseTarget(this);
        }
      },
      _onHierarchyChanged: function _onHierarchyChanged(oldParent) {
        this._updateOrderOfArrival();
        _updateCullingMask(this);
        this._parent && this._parent._delaySort();
        this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
        this._onHierarchyChangedBase(oldParent);
        cc._widgetManager && (cc._widgetManager._nodesOrderDirty = true);
        oldParent && this._activeInHierarchy && this._checkListenerMask();
        false;
      },
      _update3DFunction: function _update3DFunction() {
        if (this._is3DNode) {
          this._updateLocalMatrix = updateLocalMatrix3D;
          this._calculWorldMatrix = calculWorldMatrix3D;
          this._mulMat = mulMat3D;
        } else {
          this._updateLocalMatrix = updateLocalMatrix2D;
          this._calculWorldMatrix = calculWorldMatrix2D;
          this._mulMat = mulMat2D;
        }
        this._renderComponent && this._renderComponent._on3DNodeChanged && this._renderComponent._on3DNodeChanged();
        this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
        this._localMatDirty = LocalDirtyFlag.ALL;
        false;
      },
      _initDataFromPool: function _initDataFromPool() {
        if (!this._spaceInfo) {
          false, false;
          this._spaceInfo = nodeMemPool.pop();
        }
        var spaceInfo = this._spaceInfo;
        this._matrix = cc.mat4(spaceInfo.localMat);
        _valueTypes.Mat4.identity(this._matrix);
        this._worldMatrix = cc.mat4(spaceInfo.worldMat);
        _valueTypes.Mat4.identity(this._worldMatrix);
        this._localMatDirty = LocalDirtyFlag.ALL;
        this._worldMatDirty = true;
        var trs = this._trs = spaceInfo.trs;
        trs[0] = 0;
        trs[1] = 0;
        trs[2] = 0;
        trs[3] = 0;
        trs[4] = 0;
        trs[5] = 0;
        trs[6] = 1;
        trs[7] = 1;
        trs[8] = 1;
        trs[9] = 1;
      },
      _backDataIntoPool: function _backDataIntoPool() {
        if (!(false, false)) {
          nodeMemPool.push(this._spaceInfo);
          this._matrix = null;
          this._worldMatrix = null;
          this._trs = null;
          this._spaceInfo = null;
        }
      },
      _toEuler: function _toEuler() {
        if (this.is3DNode) _valueTypes.Trs.toEuler(this._eulerAngles, this._trs); else {
          var z = Math.asin(this._trs[5]) / ONE_DEGREE * 2;
          _valueTypes.Vec3.set(this._eulerAngles, 0, 0, z);
        }
      },
      _fromEuler: function _fromEuler() {
        this.is3DNode ? _valueTypes.Trs.fromEuler(this._trs, this._eulerAngles) : _valueTypes.Trs.fromAngleZ(this._trs, this._eulerAngles.z);
      },
      _upgrade_1x_to_2x: function _upgrade_1x_to_2x() {
        this._is3DNode && this._update3DFunction();
        var trs = this._trs;
        if (trs) {
          var desTrs = trs;
          trs = this._trs = this._spaceInfo.trs;
          11 === desTrs.length ? trs.set(desTrs.subarray(1)) : trs.set(desTrs);
        } else trs = this._trs = this._spaceInfo.trs;
        if (void 0 !== this._zIndex) {
          this._localZOrder = this._zIndex << 16;
          this._zIndex = void 0;
        }
        var NodeUtils;
        false;
        this._fromEuler();
        0 !== this._localZOrder && (this._zIndex = (4294901760 & this._localZOrder) >> 16);
        if (this._color.a < 255 && 255 === this._opacity) {
          this._opacity = this._color.a;
          this._color.a = 255;
        }
        false;
      },
      _onBatchCreated: function _onBatchCreated() {
        var prefabInfo = this._prefab;
        if (prefabInfo && prefabInfo.sync && prefabInfo.root === this) {
          false;
          PrefabHelper.syncWithPrefab(this);
        }
        this._upgrade_1x_to_2x();
        this._updateOrderOfArrival();
        this._cullingMask = 1 << _getActualGroupIndex(this);
        false;
        if (!this._activeInHierarchy) {
          ActionManagerExist && cc.director.getActionManager().pauseTarget(this);
          eventManager.pauseTarget(this);
        }
        var children = this._children;
        for (var i = 0, len = children.length; i < len; i++) children[i]._onBatchCreated();
        children.length > 0 && (this._renderFlag |= RenderFlow.FLAG_CHILDREN);
        false;
      },
      _onBatchRestored: function _onBatchRestored() {
        this._upgrade_1x_to_2x();
        this._cullingMask = 1 << _getActualGroupIndex(this);
        false;
        if (!this._activeInHierarchy) {
          var manager = cc.director.getActionManager();
          manager && manager.pauseTarget(this);
          eventManager.pauseTarget(this);
        }
        var children = this._children;
        for (var i = 0, len = children.length; i < len; i++) children[i]._onBatchRestored();
        children.length > 0 && (this._renderFlag |= RenderFlow.FLAG_CHILDREN);
        false;
      },
      _checkListenerMask: function _checkListenerMask() {
        if (this._touchListener) {
          var mask = this._touchListener.mask = _searchComponentsInParent(this, cc.Mask);
          this._mouseListener && (this._mouseListener.mask = mask);
        } else this._mouseListener && (this._mouseListener.mask = _searchComponentsInParent(this, cc.Mask));
      },
      _checknSetupSysEvent: function _checknSetupSysEvent(type) {
        var newAdded = false;
        var forDispatch = false;
        if (-1 !== _touchEvents.indexOf(type)) {
          if (!this._touchListener) {
            this._touchListener = cc.EventListener.create({
              event: cc.EventListener.TOUCH_ONE_BY_ONE,
              swallowTouches: true,
              owner: this,
              mask: _searchComponentsInParent(this, cc.Mask),
              onTouchBegan: _touchStartHandler,
              onTouchMoved: _touchMoveHandler,
              onTouchEnded: _touchEndHandler,
              onTouchCancelled: _touchCancelHandler
            });
            eventManager.addListener(this._touchListener, this);
            newAdded = true;
          }
          forDispatch = true;
        } else if (-1 !== _mouseEvents.indexOf(type)) {
          if (!this._mouseListener) {
            this._mouseListener = cc.EventListener.create({
              event: cc.EventListener.MOUSE,
              _previousIn: false,
              owner: this,
              mask: _searchComponentsInParent(this, cc.Mask),
              onMouseDown: _mouseDownHandler,
              onMouseMove: _mouseMoveHandler,
              onMouseUp: _mouseUpHandler,
              onMouseScroll: _mouseWheelHandler
            });
            eventManager.addListener(this._mouseListener, this);
            newAdded = true;
          }
          forDispatch = true;
        }
        newAdded && !this._activeInHierarchy && cc.director.getScheduler().schedule((function() {
          this._activeInHierarchy || eventManager.pauseTarget(this);
        }), this, 0, 0, 0, false);
        return forDispatch;
      },
      on: function on(type, callback, target, useCapture) {
        var forDispatch = this._checknSetupSysEvent(type);
        if (forDispatch) return this._onDispatch(type, callback, target, useCapture);
        switch (type) {
         case EventType.POSITION_CHANGED:
          this._eventMask |= POSITION_ON;
          break;

         case EventType.SCALE_CHANGED:
          this._eventMask |= SCALE_ON;
          break;

         case EventType.ROTATION_CHANGED:
          this._eventMask |= ROTATION_ON;
          break;

         case EventType.SIZE_CHANGED:
          this._eventMask |= SIZE_ON;
          break;

         case EventType.ANCHOR_CHANGED:
          this._eventMask |= ANCHOR_ON;
          break;

         case EventType.COLOR_CHANGED:
          this._eventMask |= COLOR_ON;
        }
        this._bubblingListeners || (this._bubblingListeners = new EventTarget());
        return this._bubblingListeners.on(type, callback, target);
      },
      once: function once(type, callback, target, useCapture) {
        var forDispatch = this._checknSetupSysEvent(type);
        var listeners = null;
        listeners = forDispatch && useCapture ? this._capturingListeners = this._capturingListeners || new EventTarget() : this._bubblingListeners = this._bubblingListeners || new EventTarget();
        listeners.once(type, callback, target);
      },
      _onDispatch: function _onDispatch(type, callback, target, useCapture) {
        if ("boolean" === typeof target) {
          useCapture = target;
          target = void 0;
        } else useCapture = !!useCapture;
        if (!callback) {
          cc.errorID(6800);
          return;
        }
        var listeners = null;
        listeners = useCapture ? this._capturingListeners = this._capturingListeners || new EventTarget() : this._bubblingListeners = this._bubblingListeners || new EventTarget();
        if (!listeners.hasEventListener(type, callback, target)) {
          listeners.on(type, callback, target);
          target && target.__eventTargets && target.__eventTargets.push(this);
        }
        return callback;
      },
      off: function off(type, callback, target, useCapture) {
        var touchEvent = -1 !== _touchEvents.indexOf(type);
        var mouseEvent = !touchEvent && -1 !== _mouseEvents.indexOf(type);
        if (touchEvent || mouseEvent) {
          this._offDispatch(type, callback, target, useCapture);
          if (touchEvent) {
            if (this._touchListener && !_checkListeners(this, _touchEvents)) {
              eventManager.removeListener(this._touchListener);
              this._touchListener = null;
            }
          } else if (mouseEvent && this._mouseListener && !_checkListeners(this, _mouseEvents)) {
            eventManager.removeListener(this._mouseListener);
            this._mouseListener = null;
          }
        } else if (this._bubblingListeners) {
          this._bubblingListeners.off(type, callback, target);
          var hasListeners = this._bubblingListeners.hasEventListener(type);
          if (!hasListeners) switch (type) {
           case EventType.POSITION_CHANGED:
            this._eventMask &= ~POSITION_ON;
            break;

           case EventType.SCALE_CHANGED:
            this._eventMask &= ~SCALE_ON;
            break;

           case EventType.ROTATION_CHANGED:
            this._eventMask &= ~ROTATION_ON;
            break;

           case EventType.SIZE_CHANGED:
            this._eventMask &= ~SIZE_ON;
            break;

           case EventType.ANCHOR_CHANGED:
            this._eventMask &= ~ANCHOR_ON;
            break;

           case EventType.COLOR_CHANGED:
            this._eventMask &= ~COLOR_ON;
          }
        }
      },
      _offDispatch: function _offDispatch(type, callback, target, useCapture) {
        if ("boolean" === typeof target) {
          useCapture = target;
          target = void 0;
        } else useCapture = !!useCapture;
        if (callback) {
          var listeners = useCapture ? this._capturingListeners : this._bubblingListeners;
          if (listeners) {
            listeners.off(type, callback, target);
            target && target.__eventTargets && js.array.fastRemove(target.__eventTargets, this);
          }
        } else {
          this._capturingListeners && this._capturingListeners.removeAll(type);
          this._bubblingListeners && this._bubblingListeners.removeAll(type);
        }
      },
      targetOff: function targetOff(target) {
        var listeners = this._bubblingListeners;
        if (listeners) {
          listeners.targetOff(target);
          this._eventMask & POSITION_ON && !listeners.hasEventListener(EventType.POSITION_CHANGED) && (this._eventMask &= ~POSITION_ON);
          this._eventMask & SCALE_ON && !listeners.hasEventListener(EventType.SCALE_CHANGED) && (this._eventMask &= ~SCALE_ON);
          this._eventMask & ROTATION_ON && !listeners.hasEventListener(EventType.ROTATION_CHANGED) && (this._eventMask &= ~ROTATION_ON);
          this._eventMask & SIZE_ON && !listeners.hasEventListener(EventType.SIZE_CHANGED) && (this._eventMask &= ~SIZE_ON);
          this._eventMask & ANCHOR_ON && !listeners.hasEventListener(EventType.ANCHOR_CHANGED) && (this._eventMask &= ~ANCHOR_ON);
          this._eventMask & COLOR_ON && !listeners.hasEventListener(EventType.COLOR_CHANGED) && (this._eventMask &= ~COLOR_ON);
        }
        this._capturingListeners && this._capturingListeners.targetOff(target);
        target && target.__eventTargets && js.array.fastRemove(target.__eventTargets, this);
        if (this._touchListener && !_checkListeners(this, _touchEvents)) {
          eventManager.removeListener(this._touchListener);
          this._touchListener = null;
        }
        if (this._mouseListener && !_checkListeners(this, _mouseEvents)) {
          eventManager.removeListener(this._mouseListener);
          this._mouseListener = null;
        }
      },
      hasEventListener: function hasEventListener(type) {
        var has = false;
        this._bubblingListeners && (has = this._bubblingListeners.hasEventListener(type));
        !has && this._capturingListeners && (has = this._capturingListeners.hasEventListener(type));
        return has;
      },
      emit: function emit(type, arg1, arg2, arg3, arg4, arg5) {
        this._bubblingListeners && this._bubblingListeners.emit(type, arg1, arg2, arg3, arg4, arg5);
      },
      dispatchEvent: function dispatchEvent(event) {
        _doDispatchEvent(this, event);
        _cachedArray.length = 0;
      },
      pauseSystemEvents: function pauseSystemEvents(recursive) {
        eventManager.pauseTarget(this, recursive);
      },
      resumeSystemEvents: function resumeSystemEvents(recursive) {
        eventManager.resumeTarget(this, recursive);
      },
      _hitTest: function _hitTest(point, listener) {
        var w = this._contentSize.width, h = this._contentSize.height, cameraPt = _htVec3a, testPt = _htVec3b;
        var camera = cc.Camera.findCamera(this);
        camera ? camera.getScreenToWorldPoint(point, cameraPt) : cameraPt.set(point);
        this._updateWorldMatrix();
        if (!_valueTypes.Mat4.invert(_mat4_temp, this._worldMatrix)) return false;
        _valueTypes.Vec2.transformMat4(testPt, cameraPt, _mat4_temp);
        testPt.x += this._anchorPoint.x * w;
        testPt.y += this._anchorPoint.y * h;
        var hit = false;
        if (testPt.x >= 0 && testPt.y >= 0 && testPt.x <= w && testPt.y <= h) {
          hit = true;
          if (listener && listener.mask) {
            var mask = listener.mask;
            var parent = this;
            var length = mask ? mask.length : 0;
            for (var i = 0, j = 0; parent && j < length; ++i, parent = parent.parent) {
              var temp = mask[j];
              if (i === temp.index) {
                if (parent !== temp.node) {
                  mask.length = j;
                  break;
                }
                var comp = parent.getComponent(cc.Mask);
                if (comp && comp._enabled && !comp._hitTest(cameraPt)) {
                  hit = false;
                  break;
                }
                j++;
              } else if (i > temp.index) {
                mask.length = j;
                break;
              }
            }
          }
        }
        return hit;
      },
      _getCapturingTargets: function _getCapturingTargets(type, array) {
        var parent = this.parent;
        while (parent) {
          parent._capturingListeners && parent._capturingListeners.hasEventListener(type) && array.push(parent);
          parent = parent.parent;
        }
      },
      _getBubblingTargets: function _getBubblingTargets(type, array) {
        var parent = this.parent;
        while (parent) {
          parent._bubblingListeners && parent._bubblingListeners.hasEventListener(type) && array.push(parent);
          parent = parent.parent;
        }
      },
      runAction: ActionManagerExist ? function(action) {
        if (!this.active) return;
        cc.assertID(action, 1618);
        var am = cc.director.getActionManager();
        if (!am._suppressDeprecation) {
          am._suppressDeprecation = true;
          cc.warnID(1639);
        }
        am.addAction(action, this, false);
        return action;
      } : emptyFunc,
      pauseAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().pauseTarget(this);
      } : emptyFunc,
      resumeAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().resumeTarget(this);
      } : emptyFunc,
      stopAllActions: ActionManagerExist ? function() {
        cc.director.getActionManager().removeAllActionsFromTarget(this);
      } : emptyFunc,
      stopAction: ActionManagerExist ? function(action) {
        cc.director.getActionManager().removeAction(action);
      } : emptyFunc,
      stopActionByTag: ActionManagerExist ? function(tag) {
        if (tag === cc.Action.TAG_INVALID) {
          cc.logID(1612);
          return;
        }
        cc.director.getActionManager().removeActionByTag(tag, this);
      } : emptyFunc,
      getActionByTag: ActionManagerExist ? function(tag) {
        if (tag === cc.Action.TAG_INVALID) {
          cc.logID(1613);
          return null;
        }
        return cc.director.getActionManager().getActionByTag(tag, this);
      } : function() {
        return null;
      },
      getNumberOfRunningActions: ActionManagerExist ? function() {
        return cc.director.getActionManager().getNumberOfRunningActionsInTarget(this);
      } : function() {
        return 0;
      },
      getPosition: function getPosition(out) {
        out = out || new _valueTypes.Vec3();
        return _valueTypes.Trs.toPosition(out, this._trs);
      },
      setPosition: function setPosition(newPosOrX, y, z) {
        var x;
        if (void 0 === y) {
          x = newPosOrX.x;
          y = newPosOrX.y;
          z = newPosOrX.z || 0;
        } else {
          x = newPosOrX;
          z = z || 0;
        }
        var trs = this._trs;
        if (trs[0] === x && trs[1] === y && trs[2] === z) return;
        var oldPosition;
        false;
        trs[0] = x;
        trs[1] = y;
        trs[2] = z;
        this.setLocalDirty(LocalDirtyFlag.ALL_POSITION);
        true, this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM;
        if (this._eventMask & POSITION_ON) {
          false;
          this.emit(EventType.POSITION_CHANGED);
        }
      },
      getScale: function getScale(out) {
        if (void 0 !== out) return _valueTypes.Trs.toScale(out, this._trs);
        cc.errorID(1400, "cc.Node.getScale", "cc.Node.scale or cc.Node.getScale(cc.Vec3)");
        return this._trs[7];
      },
      setScale: function setScale(x, y, z) {
        if (x && "number" !== typeof x) {
          y = x.y;
          z = void 0 === x.z ? 1 : x.z;
          x = x.x;
        } else if (void 0 !== x && void 0 === y) {
          y = x;
          z = x;
        } else void 0 === z && (z = 1);
        var trs = this._trs;
        if (trs[7] !== x || trs[8] !== y || trs[9] !== z) {
          trs[7] = x;
          trs[8] = y;
          trs[9] = z;
          this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);
          true, this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
          this._eventMask & SCALE_ON && this.emit(EventType.SCALE_CHANGED);
        }
      },
      getRotation: function getRotation(out) {
        if (out instanceof _valueTypes.Quat) return _valueTypes.Trs.toRotation(out, this._trs);
        true;
        cc.warn("`cc.Node.getRotation()` is deprecated since v2.1.0, please use `-cc.Node.angle` instead. (`this.node.getRotation()` -> `-this.node.angle`)");
        return -this.angle;
      },
      setRotation: function setRotation(rotation, y, z, w) {
        if ("number" === typeof rotation && void 0 === y) {
          true;
          cc.warn("`cc.Node.setRotation(degree)` is deprecated since v2.1.0, please set `-cc.Node.angle` instead. (`this.node.setRotation(x)` -> `this.node.angle = -x`)");
          this.angle = -rotation;
        } else {
          var x = rotation;
          if (void 0 === y) {
            x = rotation.x;
            y = rotation.y;
            z = rotation.z;
            w = rotation.w;
          }
          var trs = this._trs;
          if (trs[3] !== x || trs[4] !== y || trs[5] !== z || trs[6] !== w) {
            trs[3] = x;
            trs[4] = y;
            trs[5] = z;
            trs[6] = w;
            this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);
            this._eventMask & ROTATION_ON && this.emit(EventType.ROTATION_CHANGED);
            false;
          }
        }
      },
      getContentSize: function getContentSize() {
        return cc.size(this._contentSize.width, this._contentSize.height);
      },
      setContentSize: function setContentSize(size, height) {
        var locContentSize = this._contentSize;
        var clone;
        if (void 0 === height) {
          if (size.width === locContentSize.width && size.height === locContentSize.height) return;
          false;
          locContentSize.width = size.width;
          locContentSize.height = size.height;
        } else {
          if (size === locContentSize.width && height === locContentSize.height) return;
          false;
          locContentSize.width = size;
          locContentSize.height = height;
        }
        if (this._eventMask & SIZE_ON) {
          false;
          this.emit(EventType.SIZE_CHANGED);
        }
      },
      getAnchorPoint: function getAnchorPoint() {
        return cc.v2(this._anchorPoint);
      },
      setAnchorPoint: function setAnchorPoint(point, y) {
        var locAnchorPoint = this._anchorPoint;
        if (void 0 === y) {
          if (point.x === locAnchorPoint.x && point.y === locAnchorPoint.y) return;
          locAnchorPoint.x = point.x;
          locAnchorPoint.y = point.y;
        } else {
          if (point === locAnchorPoint.x && y === locAnchorPoint.y) return;
          locAnchorPoint.x = point;
          locAnchorPoint.y = y;
        }
        this.setLocalDirty(LocalDirtyFlag.ALL_POSITION);
        this._eventMask & ANCHOR_ON && this.emit(EventType.ANCHOR_CHANGED);
      },
      _invTransformPoint: function _invTransformPoint(out, pos) {
        this._parent ? this._parent._invTransformPoint(out, pos) : _valueTypes.Vec3.copy(out, pos);
        var ltrs = this._trs;
        _valueTypes.Trs.toPosition(_tpVec3a, ltrs);
        _valueTypes.Vec3.sub(out, out, _tpVec3a);
        _valueTypes.Trs.toRotation(_tpQuata, ltrs);
        _valueTypes.Quat.conjugate(_tpQuatb, _tpQuata);
        _valueTypes.Vec3.transformQuat(out, out, _tpQuatb);
        _valueTypes.Trs.toScale(_tpVec3a, ltrs);
        _valueTypes.Vec3.inverseSafe(_tpVec3b, _tpVec3a);
        _valueTypes.Vec3.mul(out, out, _tpVec3b);
        return out;
      },
      getWorldPosition: function getWorldPosition(out) {
        _valueTypes.Trs.toPosition(out, this._trs);
        var curr = this._parent;
        var ltrs;
        while (curr) {
          ltrs = curr._trs;
          _valueTypes.Trs.toScale(_gwpVec3, ltrs);
          _valueTypes.Vec3.mul(out, out, _gwpVec3);
          _valueTypes.Trs.toRotation(_gwpQuat, ltrs);
          _valueTypes.Vec3.transformQuat(out, out, _gwpQuat);
          _valueTypes.Trs.toPosition(_gwpVec3, ltrs);
          _valueTypes.Vec3.add(out, out, _gwpVec3);
          curr = curr._parent;
        }
        return out;
      },
      setWorldPosition: function setWorldPosition(pos) {
        var ltrs = this._trs;
        var oldPosition;
        false;
        this._parent ? this._parent._invTransformPoint(_swpVec3, pos) : _valueTypes.Vec3.copy(_swpVec3, pos);
        _valueTypes.Trs.fromPosition(ltrs, _swpVec3);
        this.setLocalDirty(LocalDirtyFlag.ALL_POSITION);
        if (this._eventMask & POSITION_ON) {
          false;
          this.emit(EventType.POSITION_CHANGED);
        }
      },
      getWorldRotation: function getWorldRotation(out) {
        _valueTypes.Trs.toRotation(_gwrQuat, this._trs);
        _valueTypes.Quat.copy(out, _gwrQuat);
        var curr = this._parent;
        while (curr) {
          _valueTypes.Trs.toRotation(_gwrQuat, curr._trs);
          _valueTypes.Quat.mul(out, _gwrQuat, out);
          curr = curr._parent;
        }
        return out;
      },
      setWorldRotation: function setWorldRotation(val) {
        if (this._parent) {
          this._parent.getWorldRotation(_swrQuat);
          _valueTypes.Quat.conjugate(_swrQuat, _swrQuat);
          _valueTypes.Quat.mul(_swrQuat, _swrQuat, val);
        } else _valueTypes.Quat.copy(_swrQuat, val);
        _valueTypes.Trs.fromRotation(this._trs, _swrQuat);
        false;
        this.setLocalDirty(LocalDirtyFlag.ALL_ROTATION);
      },
      getWorldScale: function getWorldScale(out) {
        _valueTypes.Trs.toScale(_gwsVec3, this._trs);
        _valueTypes.Vec3.copy(out, _gwsVec3);
        var curr = this._parent;
        while (curr) {
          _valueTypes.Trs.toScale(_gwsVec3, curr._trs);
          _valueTypes.Vec3.mul(out, out, _gwsVec3);
          curr = curr._parent;
        }
        return out;
      },
      setWorldScale: function setWorldScale(scale) {
        if (this._parent) {
          this._parent.getWorldScale(_swsVec3);
          _valueTypes.Vec3.div(_swsVec3, scale, _swsVec3);
        } else _valueTypes.Vec3.copy(_swsVec3, scale);
        _valueTypes.Trs.fromScale(this._trs, _swsVec3);
        this.setLocalDirty(LocalDirtyFlag.ALL_SCALE);
      },
      getWorldRT: function getWorldRT(out) {
        var opos = _gwrtVec3a;
        var orot = _gwrtQuata;
        var ltrs = this._trs;
        _valueTypes.Trs.toPosition(opos, ltrs);
        _valueTypes.Trs.toRotation(orot, ltrs);
        var curr = this._parent;
        while (curr) {
          ltrs = curr._trs;
          _valueTypes.Trs.toScale(_gwrtVec3b, ltrs);
          _valueTypes.Vec3.mul(opos, opos, _gwrtVec3b);
          _valueTypes.Trs.toRotation(_gwrtQuatb, ltrs);
          _valueTypes.Vec3.transformQuat(opos, opos, _gwrtQuatb);
          _valueTypes.Trs.toPosition(_gwrtVec3b, ltrs);
          _valueTypes.Vec3.add(opos, opos, _gwrtVec3b);
          _valueTypes.Quat.mul(orot, _gwrtQuatb, orot);
          curr = curr._parent;
        }
        _valueTypes.Mat4.fromRT(out, orot, opos);
        return out;
      },
      lookAt: function lookAt(pos, up) {
        this.getWorldPosition(_laVec3);
        _valueTypes.Vec3.sub(_laVec3, _laVec3, pos);
        _valueTypes.Vec3.normalize(_laVec3, _laVec3);
        _valueTypes.Quat.fromViewUp(_laQuat, _laVec3, up);
        this.setWorldRotation(_laQuat);
      },
      _updateLocalMatrix: updateLocalMatrix2D,
      _calculWorldMatrix: function _calculWorldMatrix() {
        this._localMatDirty & LocalDirtyFlag.TRSS && this._updateLocalMatrix();
        var parent = this._parent;
        parent ? this._mulMat(this._worldMatrix, parent._worldMatrix, this._matrix) : _valueTypes.Mat4.copy(this._worldMatrix, this._matrix);
        this._worldMatDirty = false;
      },
      _mulMat: mulMat2D,
      _updateWorldMatrix: function _updateWorldMatrix() {
        this._parent && this._parent._updateWorldMatrix();
        if (this._worldMatDirty) {
          this._calculWorldMatrix();
          var children = this._children;
          for (var i = 0, l = children.length; i < l; i++) children[i]._worldMatDirty = true;
        }
      },
      setLocalDirty: function setLocalDirty(flag) {
        this._localMatDirty |= flag;
        this._worldMatDirty = true;
        flag === LocalDirtyFlag.ALL_POSITION || flag === LocalDirtyFlag.POSITION ? this._renderFlag |= RenderFlow.FLAG_WORLD_TRANSFORM : this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
      },
      setWorldDirty: function setWorldDirty() {
        this._worldMatDirty = true;
      },
      getLocalMatrix: function getLocalMatrix(out) {
        this._updateLocalMatrix();
        return _valueTypes.Mat4.copy(out, this._matrix);
      },
      getWorldMatrix: function getWorldMatrix(out) {
        this._updateWorldMatrix();
        return _valueTypes.Mat4.copy(out, this._worldMatrix);
      },
      convertToNodeSpaceAR: function convertToNodeSpaceAR(worldPoint, out) {
        this._updateWorldMatrix();
        _valueTypes.Mat4.invert(_mat4_temp, this._worldMatrix);
        if (worldPoint instanceof cc.Vec2) {
          out = out || new cc.Vec2();
          return _valueTypes.Vec2.transformMat4(out, worldPoint, _mat4_temp);
        }
        out = out || new cc.Vec3();
        return _valueTypes.Vec3.transformMat4(out, worldPoint, _mat4_temp);
      },
      convertToWorldSpaceAR: function convertToWorldSpaceAR(nodePoint, out) {
        this._updateWorldMatrix();
        if (nodePoint instanceof cc.Vec2) {
          out = out || new cc.Vec2();
          return _valueTypes.Vec2.transformMat4(out, nodePoint, this._worldMatrix);
        }
        out = out || new cc.Vec3();
        return _valueTypes.Vec3.transformMat4(out, nodePoint, this._worldMatrix);
      },
      convertToNodeSpace: function convertToNodeSpace(worldPoint) {
        this._updateWorldMatrix();
        _valueTypes.Mat4.invert(_mat4_temp, this._worldMatrix);
        var out = new cc.Vec2();
        _valueTypes.Vec2.transformMat4(out, worldPoint, _mat4_temp);
        out.x += this._anchorPoint.x * this._contentSize.width;
        out.y += this._anchorPoint.y * this._contentSize.height;
        return out;
      },
      convertToWorldSpace: function convertToWorldSpace(nodePoint) {
        this._updateWorldMatrix();
        var out = new cc.Vec2(nodePoint.x - this._anchorPoint.x * this._contentSize.width, nodePoint.y - this._anchorPoint.y * this._contentSize.height);
        return _valueTypes.Vec2.transformMat4(out, out, this._worldMatrix);
      },
      getNodeToParentTransform: function getNodeToParentTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        var contentSize = this._contentSize;
        _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
        _vec3_temp.y = -this._anchorPoint.y * contentSize.height;
        _valueTypes.Mat4.copy(_mat4_temp, this._matrix);
        _valueTypes.Mat4.transform(_mat4_temp, _mat4_temp, _vec3_temp);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getNodeToParentTransformAR: function getNodeToParentTransformAR(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        return AffineTrans.fromMat4(out, this._matrix);
      },
      getNodeToWorldTransform: function getNodeToWorldTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        var contentSize = this._contentSize;
        _vec3_temp.x = -this._anchorPoint.x * contentSize.width;
        _vec3_temp.y = -this._anchorPoint.y * contentSize.height;
        _valueTypes.Mat4.copy(_mat4_temp, this._worldMatrix);
        _valueTypes.Mat4.transform(_mat4_temp, _mat4_temp, _vec3_temp);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getNodeToWorldTransformAR: function getNodeToWorldTransformAR(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        return AffineTrans.fromMat4(out, this._worldMatrix);
      },
      getParentToNodeTransform: function getParentToNodeTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateLocalMatrix();
        _valueTypes.Mat4.invert(_mat4_temp, this._matrix);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      getWorldToNodeTransform: function getWorldToNodeTransform(out) {
        out || (out = AffineTrans.identity());
        this._updateWorldMatrix();
        _valueTypes.Mat4.invert(_mat4_temp, this._worldMatrix);
        return AffineTrans.fromMat4(out, _mat4_temp);
      },
      convertTouchToNodeSpace: function convertTouchToNodeSpace(touch) {
        return this.convertToNodeSpace(touch.getLocation());
      },
      convertTouchToNodeSpaceAR: function convertTouchToNodeSpaceAR(touch) {
        return this.convertToNodeSpaceAR(touch.getLocation());
      },
      getBoundingBox: function getBoundingBox() {
        this._updateLocalMatrix();
        var width = this._contentSize.width;
        var height = this._contentSize.height;
        var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);
        return rect.transformMat4(rect, this._matrix);
      },
      getBoundingBoxToWorld: function getBoundingBoxToWorld() {
        if (this._parent) {
          this._parent._updateWorldMatrix();
          return this._getBoundingBoxTo();
        }
        return this.getBoundingBox();
      },
      _getBoundingBoxTo: function _getBoundingBoxTo() {
        var width = this._contentSize.width;
        var height = this._contentSize.height;
        var rect = cc.rect(-this._anchorPoint.x * width, -this._anchorPoint.y * height, width, height);
        this._calculWorldMatrix();
        rect.transformMat4(rect, this._worldMatrix);
        if (!this._children) return rect;
        var locChildren = this._children;
        for (var i = 0; i < locChildren.length; i++) {
          var child = locChildren[i];
          if (child && child.active) {
            var childRect = child._getBoundingBoxTo();
            childRect && rect.union(rect, childRect);
          }
        }
        return rect;
      },
      _updateOrderOfArrival: function _updateOrderOfArrival() {
        var arrivalOrder = this._parent ? ++this._parent._childArrivalOrder : 0;
        this._localZOrder = 4294901760 & this._localZOrder | arrivalOrder;
        this.emit(EventType.SIBLING_ORDER_CHANGED);
      },
      addChild: function addChild(child, zIndex, name) {
        false;
        cc.assertID(child, 1606);
        cc.assertID(null === child._parent, 1605);
        child.parent = this;
        void 0 !== zIndex && (child.zIndex = zIndex);
        void 0 !== name && (child.name = name);
      },
      cleanup: function cleanup() {
        ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this);
        eventManager.removeListeners(this);
        var i, len = this._children.length, node;
        for (i = 0; i < len; ++i) {
          node = this._children[i];
          node && node.cleanup();
        }
      },
      sortAllChildren: function sortAllChildren() {
        if (this._reorderChildDirty) {
          this._reorderChildDirty = false;
          var _children = this._children, child;
          this._childArrivalOrder = 1;
          for (var i = 0, len = _children.length; i < len; i++) {
            child = _children[i];
            child._updateOrderOfArrival();
          }
          eventManager._setDirtyForNode(this);
          if (_children.length > 1) {
            var _child, child2;
            for (var _i2 = 1, count = _children.length; _i2 < count; _i2++) {
              _child = _children[_i2];
              var j = _i2;
              for (;j > 0 && (child2 = _children[j - 1])._localZOrder > _child._localZOrder; j--) _children[j] = child2;
              _children[j] = _child;
            }
            this.emit(EventType.CHILD_REORDER, this);
          }
          cc.director.__fastOff(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        }
      },
      _delaySort: function _delaySort() {
        if (!this._reorderChildDirty) {
          this._reorderChildDirty = true;
          cc.director.__fastOn(cc.Director.EVENT_AFTER_UPDATE, this.sortAllChildren, this);
        }
      },
      _restoreProperties: false,
      onRestore: false
    };
    false;
    var Node = cc.Class(NodeDefines);
    var _p = Node.prototype;
    js.getset(_p, "position", _p.getPosition, _p.setPosition, false, true);
    var vec3_tmp;
    false;
    cc.Node = module.exports = Node;
  }), {
    "./event-manager": 119,
    "./event/event": 122,
    "./event/event-target": 121,
    "./platform/CCMacro": 143,
    "./platform/js": 158,
    "./renderer/render-flow": 169,
    "./utils/affine-transform": 200,
    "./utils/base-node": 201,
    "./utils/prefab-helper": 212,
    "./utils/trans-pool": 218,
    "./value-types": 224
  } ],
  27: [ (function(require, module, exports) {
    "use strict";
    var Node = require("./CCNode");
    var RenderFlow = require("./renderer/render-flow");
    var HideInHierarchy = cc.Object.Flags.HideInHierarchy;
    var LocalDirtyFlag = Node._LocalDirtyFlag;
    var POSITION_ON = 1;
    var PrivateNode = cc.Class({
      name: "cc.PrivateNode",
      extends: Node,
      properties: {
        x: {
          get: function get() {
            return this._originPos.x;
          },
          set: function set(value) {
            var localPosition = this._originPos;
            if (value !== localPosition.x) {
              localPosition.x = value;
              this._posDirty(true);
            }
          },
          override: true
        },
        y: {
          get: function get() {
            return this._originPos.y;
          },
          set: function set(value) {
            var localPosition = this._originPos;
            if (value !== localPosition.y) {
              localPosition.y = value;
              this._posDirty(true);
            }
          },
          override: true
        },
        zIndex: {
          get: function get() {
            return cc.macro.MIN_ZINDEX;
          },
          set: function set() {
            cc.warnID(1638);
          },
          override: true
        },
        showInEditor: {
          default: false,
          editorOnly: true,
          override: true
        }
      },
      ctor: function ctor(name) {
        this._localZOrder = cc.macro.MIN_ZINDEX << 16;
        this._originPos = cc.v2();
        false;
      },
      _posDirty: function _posDirty(sendEvent) {
        this.setLocalDirty(LocalDirtyFlag.POSITION);
        true, this._renderFlag |= RenderFlow.FLAG_TRANSFORM;
        true === sendEvent && this._eventMask & POSITION_ON && this.emit(Node.EventType.POSITION_CHANGED);
      },
      _updateLocalMatrix: function _updateLocalMatrix() {
        if (!this._localMatDirty) return;
        var parent = this.parent;
        if (parent) {
          this._trs[0] = this._originPos.x - (parent._anchorPoint.x - .5) * parent._contentSize.width;
          this._trs[1] = this._originPos.y - (parent._anchorPoint.y - .5) * parent._contentSize.height;
        }
        this._super();
      },
      getPosition: function getPosition() {
        return new cc.Vec2(this._originPos);
      },
      setPosition: function setPosition(x, y) {
        if (void 0 === y) {
          x = x.x;
          y = x.y;
        }
        var pos = this._originPos;
        if (pos.x === x && pos.y === y) return;
        pos.x = x;
        pos.y = y;
        this._posDirty(true);
      },
      setParent: function setParent(value) {
        var oldParent = this._parent;
        this._super(value);
        if (oldParent !== value) {
          oldParent && oldParent.off(Node.EventType.ANCHOR_CHANGED, this._posDirty, this);
          value && value.on(Node.EventType.ANCHOR_CHANGED, this._posDirty, this);
        }
      },
      _updateOrderOfArrival: function _updateOrderOfArrival() {}
    });
    cc.js.getset(PrivateNode.prototype, "parent", PrivateNode.prototype.getParent, PrivateNode.prototype.setParent);
    cc.js.getset(PrivateNode.prototype, "position", PrivateNode.prototype.getPosition, PrivateNode.prototype.setPosition);
    cc.PrivateNode = module.exports = PrivateNode;
  }), {
    "./CCNode": 26,
    "./renderer/render-flow": 169
  } ],
  28: [ (function(require, module, exports) {
    "use strict";
    var NIL = function NIL() {};
    cc.Scene = cc.Class({
      name: "cc.Scene",
      extends: require("./CCNode"),
      properties: {
        _is3DNode: {
          default: true,
          override: true
        },
        autoReleaseAssets: true
      },
      ctor: function ctor() {
        this._anchorPoint.x = 0;
        this._anchorPoint.y = 0;
        this._activeInHierarchy = false;
        this._inited = !cc.game._isCloning;
        false;
        this.dependAssets = null;
      },
      destroy: function destroy() {
        if (cc.Object.prototype.destroy.call(this)) {
          var children = this._children;
          for (var i = 0; i < children.length; ++i) children[i].active = false;
        }
        this._active = false;
        this._activeInHierarchy = false;
      },
      _onHierarchyChanged: NIL,
      _instantiate: null,
      _load: function _load() {
        if (!this._inited) {
          false;
          false;
          this._onBatchCreated();
          this._inited = true;
        }
      },
      _activate: function _activate(active) {
        active = false !== active;
        false, false;
        cc.director._nodeActivator.activateNode(this, active);
      }
    });
    module.exports = cc.Scene;
  }), {
    "./CCNode": 26
  } ],
  29: [ (function(require, module, exports) {
    "use strict";
    var js = require("./platform/js");
    var IdGenerater = require("./platform/id-generater");
    var MAX_POOL_SIZE = 20;
    var idGenerater = new IdGenerater("Scheduler");
    var ListEntry = function ListEntry(target, priority, paused, markedForDeletion) {
      this.target = target;
      this.priority = priority;
      this.paused = paused;
      this.markedForDeletion = markedForDeletion;
    };
    var _listEntries = [];
    ListEntry.get = function(target, priority, paused, markedForDeletion) {
      var result = _listEntries.pop();
      if (result) {
        result.target = target;
        result.priority = priority;
        result.paused = paused;
        result.markedForDeletion = markedForDeletion;
      } else result = new ListEntry(target, priority, paused, markedForDeletion);
      return result;
    };
    ListEntry.put = function(entry) {
      if (_listEntries.length < MAX_POOL_SIZE) {
        entry.target = null;
        _listEntries.push(entry);
      }
    };
    var HashUpdateEntry = function HashUpdateEntry(list, entry, target, callback) {
      this.list = list;
      this.entry = entry;
      this.target = target;
      this.callback = callback;
    };
    var _hashUpdateEntries = [];
    HashUpdateEntry.get = function(list, entry, target, callback) {
      var result = _hashUpdateEntries.pop();
      if (result) {
        result.list = list;
        result.entry = entry;
        result.target = target;
        result.callback = callback;
      } else result = new HashUpdateEntry(list, entry, target, callback);
      return result;
    };
    HashUpdateEntry.put = function(entry) {
      if (_hashUpdateEntries.length < MAX_POOL_SIZE) {
        entry.list = entry.entry = entry.target = entry.callback = null;
        _hashUpdateEntries.push(entry);
      }
    };
    var HashTimerEntry = function HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
      var _t = this;
      _t.timers = timers;
      _t.target = target;
      _t.timerIndex = timerIndex;
      _t.currentTimer = currentTimer;
      _t.currentTimerSalvaged = currentTimerSalvaged;
      _t.paused = paused;
    };
    var _hashTimerEntries = [];
    HashTimerEntry.get = function(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused) {
      var result = _hashTimerEntries.pop();
      if (result) {
        result.timers = timers;
        result.target = target;
        result.timerIndex = timerIndex;
        result.currentTimer = currentTimer;
        result.currentTimerSalvaged = currentTimerSalvaged;
        result.paused = paused;
      } else result = new HashTimerEntry(timers, target, timerIndex, currentTimer, currentTimerSalvaged, paused);
      return result;
    };
    HashTimerEntry.put = function(entry) {
      if (_hashTimerEntries.length < MAX_POOL_SIZE) {
        entry.timers = entry.target = entry.currentTimer = null;
        _hashTimerEntries.push(entry);
      }
    };
    function CallbackTimer() {
      this._lock = false;
      this._scheduler = null;
      this._elapsed = -1;
      this._runForever = false;
      this._useDelay = false;
      this._timesExecuted = 0;
      this._repeat = 0;
      this._delay = 0;
      this._interval = 0;
      this._target = null;
      this._callback = null;
    }
    var proto = CallbackTimer.prototype;
    proto.initWithCallback = function(scheduler, callback, target, seconds, repeat, delay) {
      this._lock = false;
      this._scheduler = scheduler;
      this._target = target;
      this._callback = callback;
      this._elapsed = -1;
      this._interval = seconds;
      this._delay = delay;
      this._useDelay = this._delay > 0;
      this._repeat = repeat;
      this._runForever = this._repeat === cc.macro.REPEAT_FOREVER;
      return true;
    };
    proto.getInterval = function() {
      return this._interval;
    };
    proto.setInterval = function(interval) {
      this._interval = interval;
    };
    proto.update = function(dt) {
      if (-1 === this._elapsed) {
        this._elapsed = 0;
        this._timesExecuted = 0;
      } else {
        this._elapsed += dt;
        if (this._runForever && !this._useDelay) {
          if (this._elapsed >= this._interval) {
            this.trigger();
            this._elapsed = 0;
          }
        } else {
          if (this._useDelay) {
            if (this._elapsed >= this._delay) {
              this.trigger();
              this._elapsed -= this._delay;
              this._timesExecuted += 1;
              this._useDelay = false;
            }
          } else if (this._elapsed >= this._interval) {
            this.trigger();
            this._elapsed = 0;
            this._timesExecuted += 1;
          }
          this._callback && !this._runForever && this._timesExecuted > this._repeat && this.cancel();
        }
      }
    };
    proto.getCallback = function() {
      return this._callback;
    };
    proto.trigger = function() {
      if (this._target && this._callback) {
        this._lock = true;
        this._callback.call(this._target, this._elapsed);
        this._lock = false;
      }
    };
    proto.cancel = function() {
      this._scheduler.unschedule(this._callback, this._target);
    };
    var _timers = [];
    CallbackTimer.get = function() {
      return _timers.pop() || new CallbackTimer();
    };
    CallbackTimer.put = function(timer) {
      if (_timers.length < MAX_POOL_SIZE && !timer._lock) {
        timer._scheduler = timer._target = timer._callback = null;
        _timers.push(timer);
      }
    };
    cc.Scheduler = function() {
      this._timeScale = 1;
      this._updatesNegList = [];
      this._updates0List = [];
      this._updatesPosList = [];
      this._hashForUpdates = js.createMap(true);
      this._hashForTimers = js.createMap(true);
      this._currentTarget = null;
      this._currentTargetSalvaged = false;
      this._updateHashLocked = false;
      this._arrayForTimers = [];
    };
    cc.Scheduler.prototype = {
      constructor: cc.Scheduler,
      _removeHashElement: function _removeHashElement(element) {
        delete this._hashForTimers[element.target._id];
        var arr = this._arrayForTimers;
        for (var i = 0, l = arr.length; i < l; i++) if (arr[i] === element) {
          arr.splice(i, 1);
          break;
        }
        HashTimerEntry.put(element);
      },
      _removeUpdateFromHash: function _removeUpdateFromHash(entry) {
        var targetId = entry.target._id;
        var self = this, element = self._hashForUpdates[targetId];
        if (element) {
          var list = element.list, listEntry = element.entry;
          for (var i = 0, l = list.length; i < l; i++) if (list[i] === listEntry) {
            list.splice(i, 1);
            break;
          }
          delete self._hashForUpdates[targetId];
          ListEntry.put(listEntry);
          HashUpdateEntry.put(element);
        }
      },
      _priorityIn: function _priorityIn(ppList, listElement, priority) {
        for (var i = 0; i < ppList.length; i++) if (priority < ppList[i].priority) {
          ppList.splice(i, 0, listElement);
          return;
        }
        ppList.push(listElement);
      },
      _appendIn: function _appendIn(ppList, listElement) {
        ppList.push(listElement);
      },
      enableForTarget: function enableForTarget(target) {
        target._id || (target.__instanceId ? cc.warnID(1513) : target._id = idGenerater.getNewId());
      },
      setTimeScale: function setTimeScale(timeScale) {
        this._timeScale = timeScale;
      },
      getTimeScale: function getTimeScale() {
        return this._timeScale;
      },
      update: function update(dt) {
        this._updateHashLocked = true;
        1 !== this._timeScale && (dt *= this._timeScale);
        var i, list, len, entry;
        for (i = 0, list = this._updatesNegList, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        for (i = 0, list = this._updates0List, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        for (i = 0, list = this._updatesPosList, len = list.length; i < len; i++) {
          entry = list[i];
          entry.paused || entry.markedForDeletion || entry.target.update(dt);
        }
        var elt, arr = this._arrayForTimers;
        for (i = 0; i < arr.length; i++) {
          elt = arr[i];
          this._currentTarget = elt;
          this._currentTargetSalvaged = false;
          if (!elt.paused) for (elt.timerIndex = 0; elt.timerIndex < elt.timers.length; ++elt.timerIndex) {
            elt.currentTimer = elt.timers[elt.timerIndex];
            elt.currentTimerSalvaged = false;
            elt.currentTimer.update(dt);
            elt.currentTimer = null;
          }
          if (this._currentTargetSalvaged && 0 === this._currentTarget.timers.length) {
            this._removeHashElement(this._currentTarget);
            --i;
          }
        }
        for (i = 0, list = this._updatesNegList; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        for (i = 0, list = this._updates0List; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        for (i = 0, list = this._updatesPosList; i < list.length; ) {
          entry = list[i];
          entry.markedForDeletion ? this._removeUpdateFromHash(entry) : i++;
        }
        this._updateHashLocked = false;
        this._currentTarget = null;
      },
      schedule: function schedule(callback, target, interval, repeat, delay, paused) {
        if ("function" !== typeof callback) {
          var tmp = callback;
          callback = target;
          target = tmp;
        }
        if (4 === arguments.length || 5 === arguments.length) {
          paused = !!repeat;
          repeat = cc.macro.REPEAT_FOREVER;
          delay = 0;
        }
        cc.assertID(target, 1502);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) element.paused !== paused && cc.warnID(1511); else {
          element = HashTimerEntry.get(null, target, 0, null, null, paused);
          this._arrayForTimers.push(element);
          this._hashForTimers[targetId] = element;
        }
        var timer, i;
        if (null == element.timers) element.timers = []; else for (i = 0; i < element.timers.length; ++i) {
          timer = element.timers[i];
          if (timer && callback === timer._callback) {
            cc.logID(1507, timer.getInterval(), interval);
            timer._interval = interval;
            return;
          }
        }
        timer = CallbackTimer.get();
        timer.initWithCallback(this, callback, target, interval, repeat, delay);
        element.timers.push(timer);
        this._currentTarget === element && this._currentTargetSalvaged && (this._currentTargetSalvaged = false);
      },
      scheduleUpdate: function scheduleUpdate(target, priority, paused) {
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var hashElement = this._hashForUpdates[targetId];
        if (hashElement && hashElement.entry) {
          if (hashElement.entry.priority === priority) {
            hashElement.entry.markedForDeletion = false;
            hashElement.entry.paused = paused;
            return;
          }
          if (this._updateHashLocked) {
            cc.logID(1506);
            hashElement.entry.markedForDeletion = false;
            hashElement.entry.paused = paused;
            return;
          }
          this.unscheduleUpdate(target);
        }
        var listElement = ListEntry.get(target, priority, paused, false);
        var ppList;
        if (0 === priority) {
          ppList = this._updates0List;
          this._appendIn(ppList, listElement);
        } else {
          ppList = priority < 0 ? this._updatesNegList : this._updatesPosList;
          this._priorityIn(ppList, listElement, priority);
        }
        this._hashForUpdates[targetId] = HashUpdateEntry.get(ppList, listElement, target, null);
      },
      unschedule: function unschedule(callback, target) {
        if (!target || !callback) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        if (element) {
          var timers = element.timers;
          for (var i = 0, li = timers.length; i < li; i++) {
            var timer = timers[i];
            if (callback === timer._callback) {
              timer !== element.currentTimer || element.currentTimerSalvaged || (element.currentTimerSalvaged = true);
              timers.splice(i, 1);
              CallbackTimer.put(timer);
              element.timerIndex >= i && element.timerIndex--;
              0 === timers.length && (self._currentTarget === element ? self._currentTargetSalvaged = true : self._removeHashElement(element));
              return;
            }
          }
        }
      },
      unscheduleUpdate: function unscheduleUpdate(target) {
        if (!target) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForUpdates[targetId];
        element && (this._updateHashLocked ? element.entry.markedForDeletion = true : this._removeUpdateFromHash(element.entry));
      },
      unscheduleAllForTarget: function unscheduleAllForTarget(target) {
        if (!target) return;
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) {
          var timers = element.timers;
          timers.indexOf(element.currentTimer) > -1 && !element.currentTimerSalvaged && (element.currentTimerSalvaged = true);
          for (var i = 0, l = timers.length; i < l; i++) CallbackTimer.put(timers[i]);
          timers.length = 0;
          this._currentTarget === element ? this._currentTargetSalvaged = true : this._removeHashElement(element);
        }
        this.unscheduleUpdate(target);
      },
      unscheduleAll: function unscheduleAll() {
        this.unscheduleAllWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
      },
      unscheduleAllWithMinPriority: function unscheduleAllWithMinPriority(minPriority) {
        var i, element, arr = this._arrayForTimers;
        for (i = arr.length - 1; i >= 0; i--) {
          element = arr[i];
          this.unscheduleAllForTarget(element.target);
        }
        var entry;
        var temp_length = 0;
        if (minPriority < 0) for (i = 0; i < this._updatesNegList.length; ) {
          temp_length = this._updatesNegList.length;
          entry = this._updatesNegList[i];
          entry && entry.priority >= minPriority && this.unscheduleUpdate(entry.target);
          temp_length == this._updatesNegList.length && i++;
        }
        if (minPriority <= 0) for (i = 0; i < this._updates0List.length; ) {
          temp_length = this._updates0List.length;
          entry = this._updates0List[i];
          entry && this.unscheduleUpdate(entry.target);
          temp_length == this._updates0List.length && i++;
        }
        for (i = 0; i < this._updatesPosList.length; ) {
          temp_length = this._updatesPosList.length;
          entry = this._updatesPosList[i];
          entry && entry.priority >= minPriority && this.unscheduleUpdate(entry.target);
          temp_length == this._updatesPosList.length && i++;
        }
      },
      isScheduled: function isScheduled(callback, target) {
        cc.assertID(callback, 1508);
        cc.assertID(target, 1509);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (!element) return false;
        if (null == element.timers) return false;
        var timers = element.timers;
        for (var i = 0; i < timers.length; ++i) {
          var timer = timers[i];
          if (callback === timer._callback) return true;
        }
        return false;
      },
      pauseAllTargets: function pauseAllTargets() {
        return this.pauseAllTargetsWithMinPriority(cc.Scheduler.PRIORITY_SYSTEM);
      },
      pauseAllTargetsWithMinPriority: function pauseAllTargetsWithMinPriority(minPriority) {
        var idsWithSelectors = [];
        var self = this, element, locArrayForTimers = self._arrayForTimers;
        var i, li;
        for (i = 0, li = locArrayForTimers.length; i < li; i++) {
          element = locArrayForTimers[i];
          if (element) {
            element.paused = true;
            idsWithSelectors.push(element.target);
          }
        }
        var entry;
        if (minPriority < 0) for (i = 0; i < this._updatesNegList.length; i++) {
          entry = this._updatesNegList[i];
          if (entry && entry.priority >= minPriority) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        if (minPriority <= 0) for (i = 0; i < this._updates0List.length; i++) {
          entry = this._updates0List[i];
          if (entry) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        for (i = 0; i < this._updatesPosList.length; i++) {
          entry = this._updatesPosList[i];
          if (entry && entry.priority >= minPriority) {
            entry.paused = true;
            idsWithSelectors.push(entry.target);
          }
        }
        return idsWithSelectors;
      },
      resumeTargets: function resumeTargets(targetsToResume) {
        if (!targetsToResume) return;
        for (var i = 0; i < targetsToResume.length; i++) this.resumeTarget(targetsToResume[i]);
      },
      pauseTarget: function pauseTarget(target) {
        cc.assertID(target, 1503);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        element && (element.paused = true);
        var elementUpdate = self._hashForUpdates[targetId];
        elementUpdate && (elementUpdate.entry.paused = true);
      },
      resumeTarget: function resumeTarget(target) {
        cc.assertID(target, 1504);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var self = this, element = self._hashForTimers[targetId];
        element && (element.paused = false);
        var elementUpdate = self._hashForUpdates[targetId];
        elementUpdate && (elementUpdate.entry.paused = false);
      },
      isTargetPaused: function isTargetPaused(target) {
        cc.assertID(target, 1505);
        var targetId = target._id;
        if (!targetId) if (target.__instanceId) {
          cc.warnID(1513);
          targetId = target._id = target.__instanceId;
        } else cc.errorID(1510);
        var element = this._hashForTimers[targetId];
        if (element) return element.paused;
        var elementUpdate = this._hashForUpdates[targetId];
        if (elementUpdate) return elementUpdate.entry.paused;
        return false;
      }
    };
    cc.Scheduler.PRIORITY_SYSTEM = 1 << 31;
    cc.Scheduler.PRIORITY_NON_SYSTEM = cc.Scheduler.PRIORITY_SYSTEM + 1;
    module.exports = cc.Scheduler;
  }), {
    "./platform/id-generater": 154,
    "./platform/js": 158
  } ],
  30: [ (function(require, module, exports) {
    "use strict";
    var preprocess = require("./preprocess");
    var fetch = require("./fetch");
    var Cache = require("./cache");
    var helper = require("./helper");
    var releaseManager = require("./releaseManager");
    var dependUtil = require("./depend-util");
    var load = require("./load");
    var Pipeline = require("./pipeline");
    var Task = require("./task");
    var RequestItem = require("./request-item");
    var downloader = require("./downloader");
    var parser = require("./parser");
    var packManager = require("./pack-manager");
    var Bundle = require("./bundle");
    var builtins = require("./builtins");
    var factory = require("./factory");
    var _require = require("./urlTransformer"), parse = _require.parse, combine = _require.combine;
    var _require2 = require("./utilities"), parseParameters = _require2.parseParameters, asyncify = _require2.asyncify;
    var _require3 = require("./shared"), assets = _require3.assets, files = _require3.files, parsed = _require3.parsed, pipeline = _require3.pipeline, transformPipeline = _require3.transformPipeline, fetchPipeline = _require3.fetchPipeline, RequestType = _require3.RequestType, bundles = _require3.bundles, BuiltinBundleName = _require3.BuiltinBundleName;
    function AssetManager() {
      this._preprocessPipe = preprocess;
      this._fetchPipe = fetch;
      this._loadPipe = load;
      this.pipeline = pipeline.append(preprocess).append(load);
      this.fetchPipeline = fetchPipeline.append(preprocess).append(fetch);
      this.transformPipeline = transformPipeline.append(parse).append(combine);
      this.bundles = bundles;
      this.assets = assets;
      this._files = files;
      this._parsed = parsed;
      this.generalImportBase = "";
      this.generalNativeBase = "";
      this.dependUtil = dependUtil;
      this._releaseManager = releaseManager;
      this.cacheAsset = true;
      this.force = false;
      this.utils = helper;
      this.downloader = downloader;
      this.parser = parser;
      this.builtins = builtins;
      this.packManager = packManager;
      this.factory = factory;
      this.cacheManager = null;
      this.presets = {
        default: {
          priority: 0
        },
        preload: {
          maxConcurrency: 2,
          maxRequestsPerFrame: 2,
          priority: -1
        },
        scene: {
          maxConcurrency: 8,
          maxRequestsPerFrame: 8,
          priority: 1
        },
        bundle: {
          maxConcurrency: 8,
          maxRequestsPerFrame: 8,
          priority: 2
        },
        remote: {
          maxRetryCount: 4
        },
        script: {
          priority: 2
        }
      };
    }
    AssetManager.Pipeline = Pipeline;
    AssetManager.Task = Task;
    AssetManager.Cache = Cache;
    AssetManager.RequestItem = RequestItem;
    AssetManager.Bundle = Bundle;
    AssetManager.BuiltinBundleName = BuiltinBundleName;
    AssetManager.prototype = {
      constructor: AssetManager,
      get main() {
        return bundles.get(BuiltinBundleName.MAIN);
      },
      get resources() {
        return bundles.get(BuiltinBundleName.RESOURCES);
      },
      get internal() {
        return bundles.get(BuiltinBundleName.INTERNAL);
      },
      init: function init(options) {
        options = options || Object.create(null);
        this._files.clear();
        this._parsed.clear();
        this._releaseManager.init();
        this.assets.clear();
        this.bundles.clear();
        this.packManager.init();
        this.downloader.init(options.bundleVers);
        this.parser.init();
        this.dependUtil.init();
        this.generalImportBase = options.importBase;
        this.generalNativeBase = options.nativeBase;
      },
      getBundle: function getBundle(name) {
        return bundles.get(name);
      },
      removeBundle: function removeBundle(bundle) {
        bundle._destroy();
        bundles.remove(bundle.name);
      },
      loadAny: function loadAny(requests, options, onProgress, onComplete) {
        var _parseParameters = parseParameters(options, onProgress, onComplete), options = _parseParameters.options, onProgress = _parseParameters.onProgress, onComplete = _parseParameters.onComplete;
        options.preset = options.preset || "default";
        var task = new Task({
          input: requests,
          onProgress: onProgress,
          onComplete: asyncify(onComplete),
          options: options
        });
        pipeline.async(task);
      },
      preloadAny: function preloadAny(requests, options, onProgress, onComplete) {
        var _parseParameters2 = parseParameters(options, onProgress, onComplete), options = _parseParameters2.options, onProgress = _parseParameters2.onProgress, onComplete = _parseParameters2.onComplete;
        options.preset = options.preset || "preload";
        var task = new Task({
          input: requests,
          onProgress: onProgress,
          onComplete: asyncify(onComplete),
          options: options
        });
        fetchPipeline.async(task);
      },
      postLoadNative: function postLoadNative(asset, options, onComplete) {
        if (!(asset instanceof cc.Asset)) throw new Error("input is not asset");
        var _parseParameters3 = parseParameters(options, void 0, onComplete), options = _parseParameters3.options, onComplete = _parseParameters3.onComplete;
        if (!asset._native || asset._nativeAsset) return asyncify(onComplete)(null);
        var depend = dependUtil.getNativeDep(asset._uuid);
        if (depend) {
          if (!bundles.has(depend.bundle)) {
            var bundle = bundles.find((function(bundle) {
              return bundle.getAssetInfo(asset._uuid);
            }));
            bundle && (depend.bundle = bundle.name);
          }
          this.loadAny(depend, options, (function(err, _native) {
            err ? cc.error(err.message, err.stack) : asset._nativeAsset = _native;
            onComplete && onComplete(err);
          }));
        }
      },
      loadRemote: function loadRemote(url, options, onComplete) {
        var _parseParameters4 = parseParameters(options, void 0, onComplete), options = _parseParameters4.options, onComplete = _parseParameters4.onComplete;
        options.__isNative__ = true;
        options.preset = options.preset || "remote";
        this.loadAny({
          url: url
        }, options, null, (function(err, data) {
          if (err) {
            cc.error(err.message, err.stack);
            onComplete && onComplete(err, null);
          } else factory.create(url, data, options.ext || cc.path.extname(url), options, onComplete);
        }));
      },
      loadScript: function loadScript(url, options, onComplete) {
        var _parseParameters5 = parseParameters(options, void 0, onComplete), options = _parseParameters5.options, onComplete = _parseParameters5.onComplete;
        options.__requestType__ = RequestType.URL;
        options.preset = options.preset || "script";
        this.loadAny(url, options, onComplete);
      },
      loadBundle: function loadBundle(nameOrUrl, options, onComplete) {
        var _parseParameters6 = parseParameters(options, void 0, onComplete), options = _parseParameters6.options, onComplete = _parseParameters6.onComplete;
        var bundleName = cc.path.basename(nameOrUrl);
        if (this.bundles.has(bundleName)) return asyncify(onComplete)(null, this.getBundle(bundleName));
        options.preset = options.preset || "bundle";
        options.ext = "bundle";
        this.loadRemote(nameOrUrl, options, onComplete);
      },
      releaseAsset: function releaseAsset(asset) {
        releaseManager.tryRelease(asset, true);
      },
      releaseUnusedAssets: function releaseUnusedAssets() {
        assets.forEach((function(asset) {
          releaseManager.tryRelease(asset);
        }));
      },
      releaseAll: function releaseAll() {
        assets.forEach((function(asset) {
          releaseManager.tryRelease(asset, true);
        }));
      },
      _transform: function _transform(input, options) {
        var subTask = Task.create({
          input: input,
          options: options
        });
        var urls = [];
        try {
          var result = transformPipeline.sync(subTask);
          for (var i = 0, l = result.length; i < l; i++) {
            var item = result[i];
            var url = item.url;
            item.recycle();
            urls.push(url);
          }
        } catch (e) {
          for (var i = 0, l = subTask.output.length; i < l; i++) subTask.output[i].recycle();
          cc.error(e.message, e.stack);
        }
        subTask.recycle();
        return urls.length > 1 ? urls : urls[0];
      }
    };
    cc.AssetManager = AssetManager;
    cc.assetManager = new AssetManager();
    Object.defineProperty(cc, "resources", {
      get: function get() {
        return bundles.get(BuiltinBundleName.RESOURCES);
      }
    });
    module.exports = cc.assetManager;
  }), {
    "./builtins": 31,
    "./bundle": 32,
    "./cache": 33,
    "./depend-util": 35,
    "./downloader": 42,
    "./factory": 43,
    "./fetch": 44,
    "./helper": 46,
    "./load": 48,
    "./pack-manager": 49,
    "./parser": 50,
    "./pipeline": 51,
    "./preprocess": 52,
    "./releaseManager": 53,
    "./request-item": 54,
    "./shared": 55,
    "./task": 56,
    "./urlTransformer": 57,
    "./utilities": 58
  } ],
  31: [ (function(require, module, exports) {
    "use strict";
    var Cache = require("./cache");
    var releaseManager = require("./releaseManager");
    var _require = require("./shared"), BuiltinBundleName = _require.BuiltinBundleName;
    var builtins = {
      _assets: new Cache({
        material: new Cache(),
        effect: new Cache()
      }),
      _loadBuiltins: function _loadBuiltins(name, cb) {
        var dirname = name + "s";
        var builtin = this._assets.get(name);
        return cc.assetManager.internal.loadDir(dirname, null, null, (function(err, assets) {
          if (err) cc.error(err.message, err.stack); else for (var i = 0; i < assets.length; i++) {
            var asset = assets[i];
            builtin.add(asset.name, asset.addRef());
          }
          cb();
        }));
      },
      init: function init(cb) {
        var _this = this;
        this.clear();
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS || !cc.assetManager.bundles.has(BuiltinBundleName.INTERNAL)) return cb && cb();
        this._loadBuiltins("effect", (function() {
          _this._loadBuiltins("material", cb);
        }));
      },
      getBuiltin: function getBuiltin(type, name) {
        return 0 === arguments.length ? this._assets : 1 === arguments.length ? this._assets.get(type) : this._assets.get(type).get(name);
      },
      clear: function clear() {
        this._assets.forEach((function(assets) {
          assets.forEach((function(asset) {
            releaseManager.tryRelease(asset, true);
          }));
          assets.clear();
        }));
      }
    };
    module.exports = builtins;
  }), {
    "./cache": 33,
    "./releaseManager": 53,
    "./shared": 55
  } ],
  32: [ (function(require, module, exports) {
    "use strict";
    var Config = require("./config");
    var releaseManager = require("./releaseManager");
    var _require = require("./utilities"), parseParameters = _require.parseParameters, parseLoadResArgs = _require.parseLoadResArgs;
    var _require2 = require("./shared"), RequestType = _require2.RequestType, assets = _require2.assets, bundles = _require2.bundles;
    function Bundle() {
      this._config = new Config();
    }
    Bundle.prototype = {
      constructor: Bundle,
      get name() {
        return this._config.name;
      },
      get deps() {
        return this._config.deps;
      },
      get base() {
        return this._config.base;
      },
      getInfoWithPath: function getInfoWithPath(path, type) {
        return this._config.getInfoWithPath(path, type);
      },
      getDirWithPath: function getDirWithPath(path, type, out) {
        return this._config.getDirWithPath(path, type, out);
      },
      getAssetInfo: function getAssetInfo(uuid) {
        return this._config.getAssetInfo(uuid);
      },
      getSceneInfo: function getSceneInfo(name) {
        return this._config.getSceneInfo(name);
      },
      init: function init(options) {
        this._config.init(options);
        bundles.add(options.name, this);
      },
      load: function load(paths, type, onProgress, onComplete) {
        var _parseLoadResArgs = parseLoadResArgs(type, onProgress, onComplete), type = _parseLoadResArgs.type, onProgress = _parseLoadResArgs.onProgress, onComplete = _parseLoadResArgs.onComplete;
        cc.assetManager.loadAny(paths, {
          __requestType__: RequestType.PATH,
          type: type,
          bundle: this.name
        }, onProgress, onComplete);
      },
      preload: function preload(paths, type, onProgress, onComplete) {
        var _parseLoadResArgs2 = parseLoadResArgs(type, onProgress, onComplete), type = _parseLoadResArgs2.type, onProgress = _parseLoadResArgs2.onProgress, onComplete = _parseLoadResArgs2.onComplete;
        cc.assetManager.preloadAny(paths, {
          __requestType__: RequestType.PATH,
          type: type,
          bundle: this.name
        }, onProgress, onComplete);
      },
      loadDir: function loadDir(dir, type, onProgress, onComplete) {
        var _parseLoadResArgs3 = parseLoadResArgs(type, onProgress, onComplete), type = _parseLoadResArgs3.type, onProgress = _parseLoadResArgs3.onProgress, onComplete = _parseLoadResArgs3.onComplete;
        cc.assetManager.loadAny(dir, {
          __requestType__: RequestType.DIR,
          type: type,
          bundle: this.name,
          __outputAsArray__: true
        }, onProgress, onComplete);
      },
      preloadDir: function preloadDir(dir, type, onProgress, onComplete) {
        var _parseLoadResArgs4 = parseLoadResArgs(type, onProgress, onComplete), type = _parseLoadResArgs4.type, onProgress = _parseLoadResArgs4.onProgress, onComplete = _parseLoadResArgs4.onComplete;
        cc.assetManager.preloadAny(dir, {
          __requestType__: RequestType.DIR,
          type: type,
          bundle: this.name
        }, onProgress, onComplete);
      },
      loadScene: function loadScene(sceneName, options, onProgress, onComplete) {
        var _parseParameters = parseParameters(options, onProgress, onComplete), options = _parseParameters.options, onProgress = _parseParameters.onProgress, onComplete = _parseParameters.onComplete;
        options.preset = options.preset || "scene";
        options.bundle = this.name;
        cc.assetManager.loadAny({
          scene: sceneName
        }, options, onProgress, (function(err, sceneAsset) {
          if (err) {
            cc.error(err.message, err.stack);
            onComplete && onComplete(err);
          } else if (sceneAsset instanceof cc.SceneAsset) {
            var scene = sceneAsset.scene;
            scene._id = sceneAsset._uuid;
            scene._name = sceneAsset._name;
            onComplete && onComplete(null, sceneAsset);
          } else onComplete && onComplete(new Error("The asset " + sceneAsset._uuid + " is not a scene"));
        }));
      },
      preloadScene: function preloadScene(sceneName, options, onProgress, onComplete) {
        var _parseParameters2 = parseParameters(options, onProgress, onComplete), options = _parseParameters2.options, onProgress = _parseParameters2.onProgress, onComplete = _parseParameters2.onComplete;
        options.bundle = this.name;
        cc.assetManager.preloadAny({
          scene: sceneName
        }, options, onProgress, (function(err) {
          err && cc.errorID(1210, sceneName, err.message);
          onComplete && onComplete(err);
        }));
      },
      get: function get(path, type) {
        var info = this.getInfoWithPath(path, type);
        return assets.get(info && info.uuid);
      },
      release: function release(path, type) {
        releaseManager.tryRelease(this.get(path, type), true);
      },
      releaseUnusedAssets: function releaseUnusedAssets() {
        var self = this;
        assets.forEach((function(asset) {
          var info = self.getAssetInfo(asset._uuid);
          info && !info.redirect && releaseManager.tryRelease(asset);
        }));
      },
      releaseAll: function releaseAll() {
        var self = this;
        assets.forEach((function(asset) {
          var info = self.getAssetInfo(asset._uuid);
          info && !info.redirect && releaseManager.tryRelease(asset, true);
        }));
      },
      _destroy: function _destroy() {
        this._config.destroy();
      }
    };
    module.exports = Bundle;
  }), {
    "./config": 34,
    "./releaseManager": 53,
    "./shared": 55,
    "./utilities": 58
  } ],
  33: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    function Cache(map) {
      if (map) {
        this._map = map;
        this._count = Object.keys(map).length;
      } else {
        this._map = js.createMap(true);
        this._count = 0;
      }
    }
    Cache.prototype = {
      constructor: Cache,
      add: function add(key, val) {
        key in this._map || this._count++;
        return this._map[key] = val;
      },
      get: function get(key) {
        return this._map[key];
      },
      has: function has(key) {
        return key in this._map;
      },
      remove: function remove(key) {
        var out = this._map[key];
        if (key in this._map) {
          delete this._map[key];
          this._count--;
        }
        return out;
      },
      clear: function clear() {
        if (0 !== this._count) {
          this._map = js.createMap(true);
          this._count = 0;
        }
      },
      forEach: function forEach(func) {
        for (var key in this._map) func(this._map[key], key);
      },
      find: function find(predicate) {
        for (var key in this._map) if (predicate(this._map[key], key)) return this._map[key];
        return null;
      },
      get count() {
        return this._count;
      },
      destroy: function destroy() {
        this._map = null;
      }
    };
    module.exports = Cache;
  }), {
    "../platform/js": 158
  } ],
  34: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var Cache = require("./cache");
    var _require = require("./helper"), normalize = _require.normalize;
    var _require2 = require("./utilities"), processOptions = _require2.processOptions;
    function Config() {
      this.name = "";
      this.base = "";
      this.importBase = "";
      this.nativeBase = "";
      this.deps = null;
      this.assetInfos = new Cache();
      this.scenes = new Cache();
      this.paths = new Cache();
    }
    Config.prototype = {
      constructor: Config,
      init: function init(options) {
        processOptions(options);
        this.importBase = options.importBase || "";
        this.nativeBase = options.nativeBase || "";
        this.base = options.base || "";
        this.name = options.name || "";
        this.deps = options.deps || [];
        this._initUuid(options.uuids);
        this._initPath(options.paths);
        this._initScene(options.scenes);
        this._initPackage(options.packs);
        this._initVersion(options.versions);
        this._initRedirect(options.redirect);
      },
      _initUuid: function _initUuid(uuidList) {
        if (!uuidList) return;
        this.assetInfos.clear();
        for (var i = 0, l = uuidList.length; i < l; i++) {
          var uuid = uuidList[i];
          this.assetInfos.add(uuid, {
            uuid: uuid
          });
        }
      },
      _initPath: function _initPath(pathList) {
        if (!pathList) return;
        var paths = this.paths;
        paths.clear();
        for (var uuid in pathList) {
          var info = pathList[uuid];
          var path = info[0];
          var type = info[1];
          var isSubAsset = 3 === info.length;
          var assetInfo = this.assetInfos.get(uuid);
          assetInfo.path = path;
          assetInfo.ctor = js._getClassById(type);
          paths.has(path) ? isSubAsset ? paths.get(path).push(assetInfo) : paths.get(path).splice(0, 0, assetInfo) : paths.add(path, [ assetInfo ]);
        }
      },
      _initScene: function _initScene(sceneList) {
        if (!sceneList) return;
        var scenes = this.scenes;
        scenes.clear();
        var assetInfos = this.assetInfos;
        for (var sceneName in sceneList) {
          var uuid = sceneList[sceneName];
          var assetInfo = assetInfos.get(uuid);
          assetInfo.url = sceneName;
          scenes.add(sceneName, assetInfo);
        }
      },
      _initPackage: function _initPackage(packageList) {
        if (!packageList) return;
        var assetInfos = this.assetInfos;
        for (var packUuid in packageList) {
          var uuids = packageList[packUuid];
          var pack = {
            uuid: packUuid,
            packs: uuids,
            ext: ".json"
          };
          assetInfos.add(packUuid, pack);
          for (var i = 0, l = uuids.length; i < l; i++) {
            var uuid = uuids[i];
            var assetInfo = assetInfos.get(uuid);
            var assetPacks = assetInfo.packs;
            assetPacks ? 1 === l ? assetPacks.splice(0, 0, pack) : assetPacks.push(pack) : assetInfo.packs = [ pack ];
          }
        }
      },
      _initVersion: function _initVersion(versions) {
        if (!versions) return;
        var assetInfos = this.assetInfos;
        var entries = versions["import"];
        if (entries) for (var i = 0, l = entries.length; i < l; i += 2) {
          var uuid = entries[i];
          var assetInfo = assetInfos.get(uuid);
          assetInfo.ver = entries[i + 1];
        }
        entries = versions["native"];
        if (entries) for (var i = 0, l = entries.length; i < l; i += 2) {
          var uuid = entries[i];
          var assetInfo = assetInfos.get(uuid);
          assetInfo.nativeVer = entries[i + 1];
        }
      },
      _initRedirect: function _initRedirect(redirect) {
        if (!redirect) return;
        var assetInfos = this.assetInfos;
        for (var i = 0, l = redirect.length; i < l; i += 2) {
          var uuid = redirect[i];
          var assetInfo = assetInfos.get(uuid);
          assetInfo.redirect = redirect[i + 1];
        }
      },
      getInfoWithPath: function getInfoWithPath(path, type) {
        if (!path) return null;
        path = normalize(path);
        var items = this.paths.get(path);
        if (items) {
          if (!type) return items[0];
          for (var i = 0, l = items.length; i < l; i++) {
            var assetInfo = items[i];
            if (js.isChildClassOf(assetInfo.ctor, type)) return assetInfo;
          }
        }
        return null;
      },
      getDirWithPath: function getDirWithPath(path, type, out) {
        path = normalize(path);
        "/" === path[path.length - 1] && (path = path.slice(0, -1));
        var infos = out || [];
        function isMatchByWord(path, test) {
          if (path.length > test.length) {
            var nextAscii = path.charCodeAt(test.length);
            return 47 === nextAscii;
          }
          return true;
        }
        this.paths.forEach((function(items, p) {
          if (p.startsWith(path) && isMatchByWord(p, path) || !path) for (var i = 0, l = items.length; i < l; i++) {
            var entry = items[i];
            type && !js.isChildClassOf(entry.ctor, type) || infos.push(entry);
          }
        }));
        return infos;
      },
      getAssetInfo: function getAssetInfo(uuid) {
        return this.assetInfos.get(uuid);
      },
      getSceneInfo: function getSceneInfo(name) {
        name.endsWith(".fire") || (name += ".fire");
        "/" === name[0] || name.startsWith("db://") || (name = "/" + name);
        var info = this.scenes.find((function(val, key) {
          return key.endsWith(name);
        }));
        return info;
      },
      destroy: function destroy() {
        this.paths.destroy();
        this.scenes.destroy();
        this.assetInfos.destroy();
      }
    };
    false;
    module.exports = Config;
  }), {
    "../platform/js": 158,
    "./cache": 33,
    "./helper": 46,
    "./utilities": 58
  } ],
  35: [ (function(require, module, exports) {
    "use strict";
    var Cache = require("./cache");
    var js = require("../platform/js");
    var dependUtil = {
      _depends: new Cache(),
      init: function init() {
        this._depends.clear();
      },
      getNativeDep: function getNativeDep(uuid) {
        if (this._depends.has(uuid)) return this._depends.get(uuid).nativeDep;
        return null;
      },
      getDeps: function getDeps(uuid) {
        if (this._depends.has(uuid)) return this._depends.get(uuid).deps;
        return [];
      },
      getDepsRecursively: function getDepsRecursively(uuid) {
        var exclude = Object.create(null), depends = [];
        this._descend(uuid, exclude, depends);
        return depends;
      },
      _descend: function _descend(uuid, exclude, depends) {
        var deps = this.getDeps(uuid);
        for (var i = 0; i < deps.length; i++) {
          var depend = deps[i];
          if (!exclude[depend]) {
            exclude[depend] = true;
            depends.push(depend);
            this._descend(depend, exclude, depends);
          }
        }
      },
      remove: function remove(uuid) {
        this._depends.remove(uuid);
      },
      parse: function parse(uuid, json) {
        var out = null;
        if (Array.isArray(json)) {
          if (this._depends.has(uuid)) return this._depends.get(uuid);
          out = {
            deps: cc.Asset._parseDepsFromJson(json),
            asyncLoadAssets: json[0].asyncLoadAssets
          };
        } else if (json.__type__) {
          if (this._depends.has(uuid)) return this._depends.get(uuid);
          var ctor = js._getClassById(json.__type__);
          out = {
            preventPreloadNativeObject: ctor.preventPreloadNativeObject,
            preventDeferredLoadDependents: ctor.preventDeferredLoadDependents,
            deps: ctor._parseDepsFromJson(json),
            nativeDep: ctor._parseNativeDepFromJson(json)
          };
          out.nativeDep && (out.nativeDep.uuid = uuid);
        } else {
          if ((true, out = this._depends.get(uuid)) && out.parsedFromExistAsset) return out;
          var asset = json;
          out = {
            deps: [],
            parsedFromExistAsset: true,
            preventPreloadNativeObject: asset.constructor.preventPreloadNativeObject,
            preventDeferredLoadDependents: asset.constructor.preventDeferredLoadDependents
          };
          var deps = asset.__depends__;
          for (var i = 0, l = deps.length; i < l; i++) {
            var dep = deps[i].uuid;
            out.deps.push(dep);
          }
          asset.__nativeDepend__ && (out.nativeDep = asset._nativeDep);
        }
        this._depends.add(uuid, out);
        return out;
      }
    };
    module.exports = dependUtil;
  }), {
    "../platform/js": 158,
    "./cache": 33
  } ],
  36: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    require("../CCDirector");
    var utilities = require("./utilities");
    var dependUtil = require("./depend-util");
    var releaseManager = require("./releaseManager");
    var downloader = require("./downloader");
    var ImageFmts = [ ".png", ".jpg", ".bmp", ".jpeg", ".gif", ".ico", ".tiff", ".webp", ".image", ".pvr", ".pkm" ];
    var AudioFmts = [ ".mp3", ".ogg", ".wav", ".m4a" ];
    function GetTrue() {
      return true;
    }
    var md5Pipe = {
      transformURL: function transformURL(url) {
        url = url.replace(/.*[/\\][0-9a-fA-F]{2}[/\\]([0-9a-fA-F-]{8,})/, (function(match, uuid) {
          var bundle = cc.assetManager.bundles.find((function(bundle) {
            return bundle.getAssetInfo(uuid);
          }));
          var hashValue = "";
          if (bundle) {
            var info = bundle.getAssetInfo(uuid);
            hashValue = url.startsWith(bundle.base + bundle._config.nativeBase) ? info.nativeVer : info.ver;
          }
          return hashValue ? match + "." + hashValue : match;
        }));
        return url;
      }
    };
    var loader = {
      onProgress: null,
      _autoReleaseSetting: Object.create(null),
      get _cache() {
        return cc.assetManager.assets._map;
      },
      load: function load(resources, progressCallback, completeCallback) {
        if (void 0 === completeCallback && void 0 !== progressCallback) {
          completeCallback = progressCallback;
          progressCallback = null;
        }
        resources = Array.isArray(resources) ? resources : [ resources ];
        for (var i = 0; i < resources.length; i++) {
          var item = resources[i];
          if ("string" === typeof item) resources[i] = {
            url: item,
            __isNative__: true
          }; else {
            if (item.type) {
              item.ext = "." + item.type;
              item.type = void 0;
            }
            item.url && (item.__isNative__ = true);
          }
        }
        var images = [];
        var audios = [];
        cc.assetManager.loadAny(resources, null, (function(finish, total, item) {
          item.content && (ImageFmts.includes(item.ext) ? images.push(item.content) : AudioFmts.includes(item.ext) && audios.push(item.content));
          progressCallback && progressCallback(finish, total, item);
        }), (function(err, _native) {
          var res = null;
          if (!err) {
            _native = Array.isArray(_native) ? _native : [ _native ];
            for (var i = 0; i < _native.length; i++) {
              var item = _native[i];
              if (!(item instanceof cc.Asset)) {
                var asset = item;
                var url = resources[i].url;
                if (images.includes(asset)) {
                  asset = new cc.Texture2D();
                  asset._nativeUrl = url;
                  asset._nativeAsset = item;
                  _native[i] = asset;
                  asset._uuid = url;
                } else if (audios.includes(asset)) {
                  asset = new cc.AudioClip();
                  asset._nativeUrl = url;
                  asset._nativeAsset = item;
                  _native[i] = asset;
                  asset._uuid = url;
                }
                cc.assetManager.assets.add(url, asset);
              }
            }
            if (_native.length > 1) {
              var map = Object.create(null);
              _native.forEach((function(asset) {
                map[asset._uuid] = asset;
              }));
              res = {
                isCompleted: GetTrue,
                _map: map
              };
            } else res = _native[0];
          }
          completeCallback && completeCallback(err, res);
        }));
      },
      getXMLHttpRequest: function getXMLHttpRequest() {
        return new XMLHttpRequest();
      },
      _parseLoadResArgs: utilities.parseLoadResArgs,
      getItem: function getItem(key) {
        return cc.assetManager.assets.has(key) ? {
          content: cc.assetManager.assets.get(key)
        } : null;
      },
      loadRes: function loadRes(url, type, progressCallback, completeCallback) {
        var _this$_parseLoadResAr = this._parseLoadResArgs(type, progressCallback, completeCallback), type = _this$_parseLoadResAr.type, onProgress = _this$_parseLoadResAr.onProgress, onComplete = _this$_parseLoadResAr.onComplete;
        var extname = cc.path.extname(url);
        extname && (url = url.slice(0, -extname.length));
        cc.resources.load(url, type, onProgress, onComplete);
      },
      loadResArray: function loadResArray(urls, type, progressCallback, completeCallback) {
        var _this$_parseLoadResAr2 = this._parseLoadResArgs(type, progressCallback, completeCallback), type = _this$_parseLoadResAr2.type, onProgress = _this$_parseLoadResAr2.onProgress, onComplete = _this$_parseLoadResAr2.onComplete;
        urls.forEach((function(url, i) {
          var extname = cc.path.extname(url);
          extname && (urls[i] = url.slice(0, -extname.length));
        }));
        cc.resources.load(urls, type, onProgress, onComplete);
      },
      loadResDir: function loadResDir(url, type, progressCallback, completeCallback) {
        var _this$_parseLoadResAr3 = this._parseLoadResArgs(type, progressCallback, completeCallback), type = _this$_parseLoadResAr3.type, onProgress = _this$_parseLoadResAr3.onProgress, onComplete = _this$_parseLoadResAr3.onComplete;
        cc.resources.loadDir(url, type, onProgress, (function(err, assets) {
          var urls = [];
          if (!err) {
            var infos = cc.resources.getDirWithPath(url, type);
            urls = infos.map((function(info) {
              return info.path;
            }));
          }
          onComplete && onComplete(err, assets, urls);
        }));
      },
      getRes: function getRes(url, type) {
        return cc.assetManager.assets.has(url) ? cc.assetManager.assets.get(url) : cc.resources.get(url, type);
      },
      getResCount: function getResCount() {
        return cc.assetManager.assets.count;
      },
      getDependsRecursively: function getDependsRecursively(owner) {
        if (!owner) return [];
        return dependUtil.getDepsRecursively("string" === typeof owner ? owner : owner._uuid).concat([ owner._uuid ]);
      },
      get assetLoader() {
        true;
        cc.error("cc.loader.assetLoader was removed, assetLoader and md5Pipe were merged into cc.assetManager.transformPipeline");
      },
      get md5Pipe() {
        return md5Pipe;
      },
      get downloader() {
        return cc.assetManager.downloader;
      },
      get loader() {
        return cc.assetManager.parser;
      },
      addDownloadHandlers: function addDownloadHandlers(extMap) {
        true;
        cc.warn("`cc.loader.addDownloadHandlers` is deprecated, please use `cc.assetManager.downloader.register` instead");
        var handler = Object.create(null);
        for (var type in extMap) {
          var func = extMap[type];
          handler["." + type] = function(url, options, onComplete) {
            func({
              url: url
            }, onComplete);
          };
        }
        cc.assetManager.downloader.register(handler);
      },
      addLoadHandlers: function addLoadHandlers(extMap) {
        true;
        cc.warn("`cc.loader.addLoadHandlers` is deprecated, please use `cc.assetManager.parser.register` instead");
        var handler = Object.create(null);
        for (var type in extMap) {
          var func = extMap[type];
          handler["." + type] = function(file, options, onComplete) {
            func({
              content: file
            }, onComplete);
          };
        }
        cc.assetManager.parser.register(handler);
      },
      flowInDeps: function flowInDeps() {
        true;
        cc.error("cc.loader.flowInDeps was removed");
      },
      release: function release(asset) {
        if (Array.isArray(asset)) for (var i = 0; i < asset.length; i++) {
          var key = asset[i];
          "string" === typeof key && (key = cc.assetManager.assets.get(key));
          var isBuiltin = cc.assetManager.builtins._assets.find((function(assets) {
            return assets.find((function(builtinAsset) {
              return builtinAsset === key;
            }));
          }));
          if (isBuiltin) continue;
          cc.assetManager.releaseAsset(key);
        } else if (asset) {
          "string" === typeof asset && (asset = cc.assetManager.assets.get(asset));
          var _isBuiltin = cc.assetManager.builtins._assets.find((function(assets) {
            return assets.find((function(builtinAsset) {
              return builtinAsset === asset;
            }));
          }));
          if (_isBuiltin) return;
          cc.assetManager.releaseAsset(asset);
        }
      },
      releaseAsset: function releaseAsset(asset) {
        cc.assetManager.releaseAsset(asset);
      },
      releaseRes: function releaseRes(url, type) {
        cc.resources.release(url, type);
      },
      releaseResDir: function releaseResDir() {
        true;
        cc.error("cc.loader.releaseResDir was removed, please use cc.assetManager.releaseAsset instead");
      },
      releaseAll: function releaseAll() {
        cc.assetManager.releaseAll();
        cc.assetManager.assets.clear();
      },
      removeItem: function removeItem(key) {
        cc.assetManager.assets.remove(key);
      },
      setAutoRelease: function setAutoRelease(asset, autoRelease) {
        "object" === typeof asset && (asset = asset._uuid);
        this._autoReleaseSetting[asset] = !!autoRelease;
      },
      setAutoReleaseRecursively: function setAutoReleaseRecursively(asset, autoRelease) {
        "object" === typeof asset && (asset = asset._uuid);
        autoRelease = !!autoRelease;
        this._autoReleaseSetting[asset] = autoRelease;
        var depends = dependUtil.getDepsRecursively(asset);
        for (var i = 0; i < depends.length; i++) {
          var depend = depends[i];
          this._autoReleaseSetting[depend] = autoRelease;
        }
      },
      isAutoRelease: function isAutoRelease(asset) {
        "object" === typeof asset && (asset = asset._uuid);
        return !!this._autoReleaseSetting[asset];
      }
    };
    downloader.loadSubpackage = function(name, completeCallback) {
      cc.assetManager.loadBundle(name, null, completeCallback);
    };
    var AssetLibrary = {
      init: function init(options) {
        options.importBase = options.libraryPath;
        options.nativeBase = options.rawAssetsBase;
        cc.assetManager.init(options);
        if (options.rawAssets) {
          var resources = new cc.AssetManager.Bundle();
          resources.init({
            name: cc.AssetManager.BuiltinBundleName.RESOURCES,
            importBase: options.importBase,
            nativeBase: options.nativeBase,
            paths: options.rawAssets.assets,
            uuids: Object.keys(options.rawAssets.assets)
          });
        }
      },
      loadAsset: function loadAsset(uuid, onComplete) {
        cc.assetManager.loadAny(uuid, onComplete);
      },
      getLibUrlNoExt: function getLibUrlNoExt() {
        true;
        cc.error("cc.AssetLibrary.getLibUrlNoExt was removed, if you want to transform url, please use cc.assetManager.helper.getUrlWithUuid instead");
      },
      queryAssetInfo: function queryAssetInfo() {
        true;
        cc.error("cc.AssetLibrary.queryAssetInfo was removed, only available in the editor by using cc.assetManager.editorExtend.queryAssetInfo");
      }
    };
    cc.url = {
      normalize: function normalize(url) {
        cc.warnID(1400, "cc.url.normalize", "cc.assetManager.utils.normalize");
        return cc.assetManager.utils.normalize(url);
      },
      raw: function raw(url) {
        cc.warnID(1400, "cc.url.raw", "cc.resources.load");
        if (url.startsWith("resources/")) return cc.assetManager._transform({
          path: cc.path.changeExtname(url.substr(10)),
          bundle: cc.AssetManager.BuiltinBundleName.RESOURCES,
          __isNative__: true,
          ext: cc.path.extname(url)
        });
        return "";
      }
    };
    var onceWarns = {
      loader: true,
      assetLibrary: true
    };
    Object.defineProperties(cc, {
      loader: {
        get: function get() {
          true;
          if (onceWarns.loader) {
            onceWarns.loader = false;
            cc.log("cc.loader is deprecated, use cc.assetManager instead please. See https://docs.cocos.com/creator/manual/zh/release-notes/asset-manager-upgrade-guide.html");
          }
          return loader;
        }
      },
      AssetLibrary: {
        get: function get() {
          true;
          if (onceWarns.assetLibrary) {
            onceWarns.assetLibrary = false;
            cc.log("cc.AssetLibrary is deprecated, use cc.assetManager instead please. See https://docs.cocos.com/creator/manual/zh/release-notes/asset-manager-upgrade-guide.html");
          }
          return AssetLibrary;
        }
      },
      LoadingItems: {
        get: function get() {
          cc.warnID(1400, "cc.LoadingItems", "cc.AssetManager.Task");
          return cc.AssetManager.Task;
        }
      },
      Pipeline: {
        get: function get() {
          cc.warnID(1400, "cc.Pipeline", "cc.AssetManager.Pipeline");
          return cc.AssetManager.Pipeline;
        }
      }
    });
    js.obsolete(cc, "cc.RawAsset", "cc.Asset");
    js.obsolete(cc.Asset.prototype, "cc.Asset.url", "nativeUrl");
    Object.defineProperties(cc.macro, {
      DOWNLOAD_MAX_CONCURRENT: {
        get: function get() {
          return cc.assetManager.downloader.maxConcurrency;
        },
        set: function set(val) {
          cc.assetManager.downloader.maxConcurrency = val;
        }
      }
    });
    Object.assign(cc.director, {
      _getSceneUuid: function _getSceneUuid(sceneName) {
        cc.assetManager.main.getSceneInfo(sceneName);
      }
    });
    Object.defineProperties(cc.game, {
      _sceneInfos: {
        get: function get() {
          var scenes = [];
          cc.assetManager.main._config.scenes.forEach((function(val) {
            scenes.push(val);
          }));
          return scenes;
        }
      }
    });
    var parseParameters = utilities.parseParameters;
    utilities.parseParameters = function(options, onProgress, onComplete) {
      var result = parseParameters(options, onProgress, onComplete);
      result.onProgress = result.onProgress || loader.onProgress;
      return result;
    };
    var autoRelease = releaseManager._autoRelease;
    releaseManager._autoRelease = function() {
      autoRelease.apply(this, arguments);
      var releaseSettings = loader._autoReleaseSetting;
      var keys = Object.keys(releaseSettings);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        if (true === releaseSettings[key]) {
          var asset = cc.assetManager.assets.get(key);
          asset && releaseManager.tryRelease(asset);
        }
      }
    };
  }), {
    "../CCDirector": 24,
    "../platform/js": 158,
    "./depend-util": 35,
    "./downloader": 42,
    "./releaseManager": 53,
    "./utilities": 58
  } ],
  37: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var helper = require("./helper");
    var MissingClass = false;
    require("../platform/deserialize");
    function deserialize(json, options) {
      var classFinder, missingClass;
      var isScene = helper.isSceneObj(json);
      if (isScene) {
        false;
        classFinder = cc._MissingScript.safeFindClass;
      } else classFinder = function classFinder(id) {
        var cls = js._getClassById(id);
        if (cls) return cls;
        cc.warnID(4903, id);
        return Object;
      };
      var tdInfo = cc.deserialize.Details.pool.get();
      var asset;
      try {
        asset = cc.deserialize(json, tdInfo, {
          classFinder: classFinder,
          customEnv: options
        });
      } catch (e) {
        cc.deserialize.Details.pool.put(tdInfo);
        throw e;
      }
      false;
      var uuidList = tdInfo.uuidList;
      var objList = tdInfo.uuidObjList;
      var propList = tdInfo.uuidPropList;
      var depends = [];
      for (var i = 0; i < uuidList.length; i++) {
        var dependUuid = uuidList[i];
        depends[i] = {
          uuid: helper.decodeUuid(dependUuid),
          owner: objList[i],
          prop: propList[i]
        };
      }
      asset.__depends__ = depends;
      asset._native && (asset.__nativeDepend__ = true);
      cc.deserialize.Details.pool.put(tdInfo);
      return asset;
    }
    module.exports = deserialize;
  }), {
    "../platform/deserialize": 153,
    "../platform/js": 158,
    "./helper": 46
  } ],
  38: [ (function(require, module, exports) {
    "use strict";
    var __audioSupport = cc.sys.__audioSupport;
    var _require = require("./utilities"), parseParameters = _require.parseParameters;
    function downloadDomAudio(url, options, onComplete) {
      var _parseParameters = parseParameters(options, void 0, onComplete), options = _parseParameters.options, onComplete = _parseParameters.onComplete;
      var dom = document.createElement("audio");
      dom.src = url;
      var clearEvent = function clearEvent() {
        clearTimeout(timer);
        dom.removeEventListener("canplaythrough", success, false);
        dom.removeEventListener("error", failure, false);
        __audioSupport.USE_LOADER_EVENT && dom.removeEventListener(__audioSupport.USE_LOADER_EVENT, success, false);
      };
      var timer = setTimeout((function() {
        0 === dom.readyState ? failure() : success();
      }), 8e3);
      var success = function success() {
        clearEvent();
        onComplete && onComplete(null, dom);
      };
      var failure = function failure() {
        clearEvent();
        var message = "load audio failure - " + url;
        cc.log(message);
        onComplete && onComplete(new Error(message));
      };
      dom.addEventListener("canplaythrough", success, false);
      dom.addEventListener("error", failure, false);
      __audioSupport.USE_LOADER_EVENT && dom.addEventListener(__audioSupport.USE_LOADER_EVENT, success, false);
      return dom;
    }
    module.exports = downloadDomAudio;
  }), {
    "./utilities": 58
  } ],
  39: [ (function(require, module, exports) {
    "use strict";
    var _require = require("./utilities"), parseParameters = _require.parseParameters;
    function downloadDomImage(url, options, onComplete) {
      var _parseParameters = parseParameters(options, void 0, onComplete), options = _parseParameters.options, onComplete = _parseParameters.onComplete;
      var img = new Image();
      "file:" !== window.location.protocol && (img.crossOrigin = "anonymous");
      function loadCallback() {
        img.removeEventListener("load", loadCallback);
        img.removeEventListener("error", errorCallback);
        onComplete && onComplete(null, img);
      }
      function errorCallback() {
        img.removeEventListener("load", loadCallback);
        img.removeEventListener("error", errorCallback);
        onComplete && onComplete(new Error(cc.debug.getError(4930, url)));
      }
      img.addEventListener("load", loadCallback);
      img.addEventListener("error", errorCallback);
      img.src = url;
      return img;
    }
    module.exports = downloadDomImage;
  }), {
    "./utilities": 58
  } ],
  40: [ (function(require, module, exports) {
    "use strict";
    var _require = require("./utilities"), parseParameters = _require.parseParameters;
    function downloadFile(url, options, onProgress, onComplete) {
      var _parseParameters = parseParameters(options, onProgress, onComplete), options = _parseParameters.options, onProgress = _parseParameters.onProgress, onComplete = _parseParameters.onComplete;
      var xhr = new XMLHttpRequest(), errInfo = "download failed: " + url + ", status: ";
      xhr.open("GET", url, true);
      void 0 !== options.responseType && (xhr.responseType = options.responseType);
      void 0 !== options.withCredentials && (xhr.withCredentials = options.withCredentials);
      void 0 !== options.mimeType && xhr.overrideMimeType && xhr.overrideMimeType(options.mimeType);
      void 0 !== options.timeout && (xhr.timeout = options.timeout);
      if (options.header) for (var header in options.header) xhr.setRequestHeader(header, options.header[header]);
      xhr.onload = function() {
        200 === xhr.status || 0 === xhr.status ? onComplete && onComplete(null, xhr.response) : onComplete && onComplete(new Error(errInfo + xhr.status + "(no response)"));
      };
      onProgress && (xhr.onprogress = function(e) {
        e.lengthComputable && onProgress(e.loaded, e.total);
      });
      xhr.onerror = function() {
        onComplete && onComplete(new Error(errInfo + xhr.status + "(error)"));
      };
      xhr.ontimeout = function() {
        onComplete && onComplete(new Error(errInfo + xhr.status + "(time out)"));
      };
      xhr.onabort = function() {
        onComplete && onComplete(new Error(errInfo + xhr.status + "(abort)"));
      };
      xhr.send(null);
      return xhr;
    }
    module.exports = downloadFile;
  }), {
    "./utilities": 58
  } ],
  41: [ (function(require, module, exports) {
    "use strict";
    var _require = require("./utilities"), parseParameters = _require.parseParameters;
    var downloaded = {};
    function downloadScript(url, options, onComplete) {
      var _parseParameters = parseParameters(options, void 0, onComplete), options = _parseParameters.options, onComplete = _parseParameters.onComplete;
      if (downloaded[url]) return onComplete && onComplete(null);
      var d = document, s = document.createElement("script");
      "file:" !== window.location.protocol && (s.crossOrigin = "anonymous");
      s.async = void 0 === options.isAsync || options.isAsync;
      s.src = url;
      function loadHandler() {
        s.parentNode.removeChild(s);
        s.removeEventListener("load", loadHandler, false);
        s.removeEventListener("error", errorHandler, false);
        downloaded[url] = true;
        onComplete && onComplete(null);
      }
      function errorHandler() {
        s.parentNode.removeChild(s);
        s.removeEventListener("load", loadHandler, false);
        s.removeEventListener("error", errorHandler, false);
        onComplete && onComplete(new Error(cc.debug.getError(4928, url)));
      }
      s.addEventListener("load", loadHandler, false);
      s.addEventListener("error", errorHandler, false);
      d.body.appendChild(s);
    }
    module.exports = downloadScript;
  }), {
    "./utilities": 58
  } ],
  42: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var debug = require("../CCDebug");
    var _require = require("./font-loader"), loadFont = _require.loadFont;
    var callInNextTick = require("../platform/utils").callInNextTick;
    var downloadDomImage = require("./download-dom-image");
    var downloadDomAudio = require("./download-dom-audio");
    var downloadFile = require("./download-file");
    var downloadScript = require("./download-script.js");
    var Cache = require("./cache");
    var _require2 = require("./shared"), files = _require2.files;
    var _require3 = require("../platform/CCSys"), __audioSupport = _require3.__audioSupport, capabilities = _require3.capabilities;
    var _require4 = require("./utilities"), urlAppendTimestamp = _require4.urlAppendTimestamp, retry = _require4.retry;
    var REGEX = /^\w+:\/\/.*/;
    var formatSupport = __audioSupport.format || [];
    var unsupported = function unsupported(url, options, onComplete) {
      onComplete(new Error(debug.getError(4927)));
    };
    var downloadAudio = function downloadAudio(url, options, onComplete) {
      options.audioLoadMode !== cc.AudioClip.LoadMode.DOM_AUDIO ? downloadArrayBuffer(url, options, onComplete) : downloadDomAudio(url, options, onComplete);
    };
    var downloadAudio = 0 === formatSupport.length ? unsupported : __audioSupport.WEB_AUDIO ? downloadAudio : downloadDomAudio;
    var downloadImage = function downloadImage(url, options, onComplete) {
      var func = capabilities.imageBitmap && cc.macro.ALLOW_IMAGE_BITMAP ? downloadBlob : downloadDomImage;
      func.apply(this, arguments);
    };
    var downloadBlob = function downloadBlob(url, options, onComplete) {
      options.responseType = "blob";
      downloadFile(url, options, options.onFileProgress, onComplete);
    };
    var downloadJson = function downloadJson(url, options, onComplete) {
      options.responseType = "json";
      downloadFile(url, options, options.onFileProgress, (function(err, data) {
        if (!err && "string" === typeof data) try {
          data = JSON.parse(data);
        } catch (e) {
          err = e;
        }
        onComplete && onComplete(err, data);
      }));
    };
    var downloadArrayBuffer = function downloadArrayBuffer(url, options, onComplete) {
      options.responseType = "arraybuffer";
      downloadFile(url, options, options.onFileProgress, onComplete);
    };
    var downloadText = function downloadText(url, options, onComplete) {
      options.responseType = "text";
      downloadFile(url, options, options.onFileProgress, onComplete);
    };
    var downloadVideo = function downloadVideo(url, options, onComplete) {
      onComplete(null, url);
    };
    var downloadBundle = function downloadBundle(nameOrUrl, options, onComplete) {
      var bundleName = cc.path.basename(nameOrUrl);
      var url = nameOrUrl;
      REGEX.test(url) || (url = "assets/" + bundleName);
      var version = options.version || downloader.bundleVers[bundleName];
      var count = 0;
      var config = url + "/config." + (version ? version + "." : "") + "json";
      var out = null, error = null;
      downloadJson(config, options, (function(err, response) {
        err && (error = err);
        out = response;
        out && (out.base = url + "/");
        count++;
        2 === count && onComplete(error, out);
      }));
      var js = url + "/index." + (version ? version + "." : "") + "js";
      downloadScript(js, options, (function(err) {
        err && (error = err);
        count++;
        2 === count && onComplete(error, out);
      }));
    };
    var _downloading = new Cache();
    var _queue = [];
    var _queueDirty = false;
    var _totalNum = 0;
    var _totalNumThisPeriod = 0;
    var _lastDate = -1;
    var _checkNextPeriod = false;
    var updateTime = function updateTime() {
      var now = Date.now();
      if (now - _lastDate > 1e3 * cc.director._deltaTime) {
        _totalNumThisPeriod = 0;
        _lastDate = now;
      }
    };
    var handleQueue = function handleQueue(maxConcurrency, maxRequestsPerFrame) {
      _checkNextPeriod = false;
      updateTime();
      while (_queue.length > 0 && _totalNum < maxConcurrency && _totalNumThisPeriod < maxRequestsPerFrame) {
        if (_queueDirty) {
          _queue.sort((function(a, b) {
            return a.priority - b.priority;
          }));
          _queueDirty = false;
        }
        var nextOne = _queue.pop();
        if (!nextOne) break;
        _totalNum++;
        _totalNumThisPeriod++;
        nextOne.invoke();
      }
      if (_queue.length > 0 && _totalNum < maxConcurrency) {
        callInNextTick(handleQueue, maxConcurrency, maxRequestsPerFrame);
        _checkNextPeriod = true;
      }
    };
    var downloader = {
      maxConcurrency: 6,
      maxRequestsPerFrame: 6,
      maxRetryCount: 3,
      appendTimeStamp: false,
      limited: true,
      retryInterval: 2e3,
      bundleVers: null,
      downloadDomImage: downloadDomImage,
      downloadDomAudio: downloadDomAudio,
      downloadFile: downloadFile,
      downloadScript: downloadScript,
      init: function init(bundleVers) {
        _downloading.clear();
        _queue.length = 0;
        this.bundleVers = bundleVers || Object.create(null);
      },
      register: function register(type, handler) {
        "object" === typeof type ? js.mixin(downloaders, type) : downloaders[type] = handler;
      },
      download: function download(id, url, type, options, onComplete) {
        var func = downloaders[type] || downloaders["default"];
        var self = this;
        var file, downloadCallbacks;
        if (file = files.get(id)) onComplete(null, file); else if (downloadCallbacks = _downloading.get(id)) {
          downloadCallbacks.push(onComplete);
          for (var i = 0, l = _queue.length; i < l; i++) {
            var item = _queue[i];
            if (item.id === id) {
              var priority = options.priority || 0;
              if (item.priority < priority) {
                item.priority = priority;
                _queueDirty = true;
              }
              return;
            }
          }
        } else {
          var process = function process(index, callback) {
            0 === index && _downloading.add(id, [ onComplete ]);
            if (!self.limited) return func(urlAppendTimestamp(url), options, callback);
            updateTime();
            function invoke() {
              func(urlAppendTimestamp(url), options, (function() {
                _totalNum--;
                if (!_checkNextPeriod && _queue.length > 0) {
                  callInNextTick(handleQueue, maxConcurrency, maxRequestsPerFrame);
                  _checkNextPeriod = true;
                }
                callback.apply(this, arguments);
              }));
            }
            if (_totalNum < maxConcurrency && _totalNumThisPeriod < maxRequestsPerFrame) {
              invoke();
              _totalNum++;
              _totalNumThisPeriod++;
            } else {
              _queue.push({
                id: id,
                priority: options.priority || 0,
                invoke: invoke
              });
              _queueDirty = true;
              if (!_checkNextPeriod && _totalNum < maxConcurrency) {
                callInNextTick(handleQueue, maxConcurrency, maxRequestsPerFrame);
                _checkNextPeriod = true;
              }
            }
          };
          var finale = function finale(err, result) {
            err || files.add(id, result);
            var callbacks = _downloading.remove(id);
            for (var _i = 0, _l = callbacks.length; _i < _l; _i++) callbacks[_i](err, result);
          };
          var maxRetryCount = options.maxRetryCount || this.maxRetryCount;
          var maxConcurrency = options.maxConcurrency || this.maxConcurrency;
          var maxRequestsPerFrame = options.maxRequestsPerFrame || this.maxRequestsPerFrame;
          retry(process, maxRetryCount, this.retryInterval, finale);
        }
      }
    };
    var downloaders = {
      ".png": downloadImage,
      ".jpg": downloadImage,
      ".bmp": downloadImage,
      ".jpeg": downloadImage,
      ".gif": downloadImage,
      ".ico": downloadImage,
      ".tiff": downloadImage,
      ".webp": downloadImage,
      ".image": downloadImage,
      ".pvr": downloadArrayBuffer,
      ".pkm": downloadArrayBuffer,
      ".mp3": downloadAudio,
      ".ogg": downloadAudio,
      ".wav": downloadAudio,
      ".m4a": downloadAudio,
      ".txt": downloadText,
      ".xml": downloadText,
      ".vsh": downloadText,
      ".fsh": downloadText,
      ".atlas": downloadText,
      ".tmx": downloadText,
      ".tsx": downloadText,
      ".json": downloadJson,
      ".ExportJson": downloadJson,
      ".plist": downloadText,
      ".fnt": downloadText,
      ".font": loadFont,
      ".eot": loadFont,
      ".ttf": loadFont,
      ".woff": loadFont,
      ".svg": loadFont,
      ".ttc": loadFont,
      ".mp4": downloadVideo,
      ".avi": downloadVideo,
      ".mov": downloadVideo,
      ".mpg": downloadVideo,
      ".mpeg": downloadVideo,
      ".rm": downloadVideo,
      ".rmvb": downloadVideo,
      ".binary": downloadArrayBuffer,
      ".bin": downloadArrayBuffer,
      ".dbbin": downloadArrayBuffer,
      ".skel": downloadArrayBuffer,
      ".js": downloadScript,
      bundle: downloadBundle,
      default: downloadText
    };
    module.exports = downloader;
  }), {
    "../CCDebug": 23,
    "../platform/CCSys": 147,
    "../platform/js": 158,
    "../platform/utils": 161,
    "./cache": 33,
    "./download-dom-audio": 38,
    "./download-dom-image": 39,
    "./download-file": 40,
    "./download-script.js": 41,
    "./font-loader": 45,
    "./shared": 55,
    "./utilities": 58
  } ],
  43: [ (function(require, module, exports) {
    "use strict";
    var Bundle = require("./bundle");
    function createTexture(id, data, options, onComplete) {
      var out = null, err = null;
      try {
        out = new cc.Texture2D();
        out._uuid = id;
        out._nativeUrl = id;
        out._nativeAsset = data;
      } catch (e) {
        err = e;
      }
      onComplete && onComplete(err, out);
    }
    function createAudioClip(id, data, options, onComplete) {
      var out = new cc.AudioClip();
      out._uuid = id;
      out._nativeUrl = id;
      out._nativeAsset = data;
      out.duration = data.duration;
      onComplete && onComplete(null, out);
    }
    function createJsonAsset(id, data, options, onComplete) {
      var out = new cc.JsonAsset();
      out._uuid = id;
      out.json = data;
      onComplete && onComplete(null, out);
    }
    function createTextAsset(id, data, options, onComplete) {
      var out = new cc.TextAsset();
      out._uuid = id;
      out.text = data;
      onComplete && onComplete(null, out);
    }
    function createFont(id, data, options, onComplete) {
      var out = new cc.TTFFont();
      out._uuid = id;
      out._nativeUrl = id;
      out._nativeAsset = data;
      onComplete && onComplete(null, out);
    }
    function createBufferAsset(id, data, options, onComplete) {
      var out = new cc.BufferAsset();
      out._uuid = id;
      out._nativeUrl = id;
      out._nativeAsset = data;
      onComplete && onComplete(null, out);
    }
    function createAsset(id, data, options, onComplete) {
      var out = new cc.Asset();
      out._uuid = id;
      out._nativeUrl = id;
      out._nativeAsset = data;
      onComplete && onComplete(null, out);
    }
    function createBundle(id, data, options, onComplete) {
      var bundle = new Bundle();
      data.base = data.base || id + "/";
      bundle.init(data);
      onComplete && onComplete(null, bundle);
    }
    var factory = {
      register: function register(type, handler) {
        "object" === typeof type ? cc.js.mixin(producers, type) : producers[type] = handler;
      },
      create: function create(id, data, type, options, onComplete) {
        var func = producers[type] || producers["default"];
        func(id, data, options, onComplete);
      }
    };
    var producers = {
      ".png": createTexture,
      ".jpg": createTexture,
      ".bmp": createTexture,
      ".jpeg": createTexture,
      ".gif": createTexture,
      ".ico": createTexture,
      ".tiff": createTexture,
      ".webp": createTexture,
      ".image": createTexture,
      ".pvr": createTexture,
      ".pkm": createTexture,
      ".mp3": createAudioClip,
      ".ogg": createAudioClip,
      ".wav": createAudioClip,
      ".m4a": createAudioClip,
      ".txt": createTextAsset,
      ".xml": createTextAsset,
      ".vsh": createTextAsset,
      ".fsh": createTextAsset,
      ".atlas": createTextAsset,
      ".tmx": createTextAsset,
      ".tsx": createTextAsset,
      ".fnt": createTextAsset,
      ".json": createJsonAsset,
      ".ExportJson": createJsonAsset,
      ".font": createFont,
      ".eot": createFont,
      ".ttf": createFont,
      ".woff": createFont,
      ".svg": createFont,
      ".ttc": createFont,
      ".binary": createBufferAsset,
      ".bin": createBufferAsset,
      ".dbbin": createBufferAsset,
      ".skel": createBufferAsset,
      bundle: createBundle,
      default: createAsset
    };
    module.exports = factory;
  }), {
    "./bundle": 32
  } ],
  44: [ (function(require, module, exports) {
    "use strict";
    var packManager = require("./pack-manager");
    var Task = require("./task");
    var _require = require("./utilities"), getDepends = _require.getDepends, clear = _require.clear, forEach = _require.forEach;
    var _require2 = require("./shared"), assets = _require2.assets, fetchPipeline = _require2.fetchPipeline;
    function fetch(task, done) {
      var firstTask = false;
      if (!task.progress) {
        task.progress = {
          finish: 0,
          total: task.input.length
        };
        firstTask = true;
      }
      var options = task.options, depends = [], progress = task.progress, total = progress.total;
      options.__exclude__ = options.__exclude__ || Object.create(null);
      task.output = [];
      forEach(task.input, (function(item, cb) {
        if (!item.isNative && assets.has(item.uuid)) {
          var asset = assets.get(item.uuid);
          asset.addRef();
          handle(item, task, asset, null, asset.__asyncLoadAssets__, depends, total, done);
          return cb();
        }
        packManager.load(item, task.options, (function(err, data) {
          if (err) {
            if (!task.isFinish) if (cc.assetManager.force) handle(item, task, null, null, false, depends, total, done); else {
              cc.error(err.message, err.stack);
              done(err);
            }
          } else task.isFinish || handle(item, task, null, data, !item.isNative, depends, total, done);
          cb();
        }));
      }), (function() {
        if (task.isFinish) {
          clear(task, true);
          return task.dispatch("error");
        }
        if (depends.length > 0) {
          var subTask = Task.create({
            name: task.name + " dependencies",
            input: depends,
            progress: progress,
            options: options,
            onProgress: task.onProgress,
            onError: Task.prototype.recycle,
            onComplete: function onComplete(err) {
              if (!err) {
                task.output.push.apply(task.output, this.output);
                subTask.recycle();
              }
              firstTask && decreaseRef(task);
              done(err);
            }
          });
          fetchPipeline.async(subTask);
          return;
        }
        firstTask && decreaseRef(task);
        done();
      }));
    }
    function decreaseRef(task) {
      var output = task.output;
      for (var i = 0, l = output.length; i < l; i++) output[i].content && output[i].content.decRef(false);
    }
    function handle(item, task, content, file, loadDepends, depends, last, done) {
      var exclude = task.options.__exclude__;
      var progress = task.progress;
      item.content = content;
      item.file = file;
      task.output.push(item);
      if (loadDepends) {
        exclude[item.uuid] = true;
        var err = getDepends(item.uuid, file || content, exclude, depends, true, false, item.config);
        if (err) {
          if (!cc.assetManager.force) {
            cc.error(err.message, err.stack);
            return done(err);
          }
          item.file = null;
        }
        progress.total = last + depends.length;
      }
      task.dispatch("progress", ++progress.finish, progress.total, item);
    }
    module.exports = fetch;
  }), {
    "./pack-manager": 49,
    "./shared": 55,
    "./task": 56,
    "./utilities": 58
  } ],
  45: [ (function(require, module, exports) {
    "use strict";
    var textUtils = require("../utils/text-utils");
    var _canvasContext = null;
    var _testString = "BES bswy:->@123\u4e01\u3041\u1101";
    var _fontFaces = Object.create(null);
    var _intervalId = -1;
    var _loadingFonts = [];
    var _timeout = 3e3;
    var useNativeCheck = (function() {
      var nativeCheck = void 0;
      return function() {
        if (void 0 === nativeCheck) if (!window.FontFace) nativeCheck = false; else {
          var match = /Gecko.*Firefox\/(\d+)/.exec(window.navigator.userAgent);
          var safari10Match = /OS X.*Version\/10\..*Safari/.exec(window.navigator.userAgent) && /Apple/.exec(window.navigator.vendor);
          nativeCheck = match ? parseInt(match[1], 10) > 42 : !safari10Match;
        }
        return nativeCheck;
      };
    })();
    function _checkFontLoaded() {
      var allFontsLoaded = true;
      var now = Date.now();
      for (var i = _loadingFonts.length - 1; i >= 0; i--) {
        var fontLoadHandle = _loadingFonts[i];
        var fontFamily = fontLoadHandle.fontFamilyName;
        if (now - fontLoadHandle.startTime > _timeout) {
          cc.warnID(4933, fontFamily);
          fontLoadHandle.onComplete(null, fontFamily);
          _loadingFonts.splice(i, 1);
          continue;
        }
        var oldWidth = fontLoadHandle.refWidth;
        var fontDesc = "40px " + fontFamily;
        _canvasContext.font = fontDesc;
        var newWidth = textUtils.safeMeasureText(_canvasContext, _testString, fontDesc);
        if (oldWidth !== newWidth) {
          _loadingFonts.splice(i, 1);
          fontLoadHandle.onComplete(null, fontFamily);
        } else allFontsLoaded = false;
      }
      if (allFontsLoaded) {
        clearInterval(_intervalId);
        _intervalId = -1;
      }
    }
    function nativeCheckFontLoaded(start, font, callback) {
      var loader = new Promise(function(resolve, reject) {
        var check = function check() {
          var now = Date.now();
          now - start >= _timeout ? reject() : document.fonts.load("40px " + font).then((function(fonts) {
            fonts.length >= 1 ? resolve() : setTimeout(check, 100);
          }), (function() {
            reject();
          }));
        };
        check();
      });
      var timeoutId = null, timer = new Promise(function(resolve, reject) {
        timeoutId = setTimeout(reject, _timeout);
      });
      Promise.race([ timer, loader ]).then((function() {
        if (timeoutId) {
          clearTimeout(timeoutId);
          timeoutId = null;
        }
        callback(null, font);
      }), (function() {
        cc.warnID(4933, font);
        callback(null, font);
      }));
    }
    var fontLoader = {
      loadFont: function loadFont(url, options, onComplete) {
        var fontFamilyName = fontLoader._getFontFamily(url);
        if (_fontFaces[fontFamilyName]) return onComplete(null, fontFamilyName);
        if (!_canvasContext) {
          var labelCanvas = document.createElement("canvas");
          labelCanvas.width = 100;
          labelCanvas.height = 100;
          _canvasContext = labelCanvas.getContext("2d");
        }
        var fontDesc = "40px " + fontFamilyName;
        _canvasContext.font = fontDesc;
        var refWidth = textUtils.safeMeasureText(_canvasContext, _testString, fontDesc);
        var fontStyle = document.createElement("style");
        fontStyle.type = "text/css";
        var fontStr = "";
        isNaN(fontFamilyName - 0) ? fontStr += "@font-face { font-family:" + fontFamilyName + "; src:" : fontStr += "@font-face { font-family:'" + fontFamilyName + "'; src:";
        fontStr += "url('" + url + "');";
        fontStyle.textContent = fontStr + "}";
        document.body.appendChild(fontStyle);
        var preloadDiv = document.createElement("div");
        var divStyle = preloadDiv.style;
        divStyle.fontFamily = fontFamilyName;
        preloadDiv.innerHTML = ".";
        divStyle.position = "absolute";
        divStyle.left = "-100px";
        divStyle.top = "-100px";
        document.body.appendChild(preloadDiv);
        if (useNativeCheck()) nativeCheckFontLoaded(Date.now(), fontFamilyName, onComplete); else {
          var fontLoadHandle = {
            fontFamilyName: fontFamilyName,
            refWidth: refWidth,
            onComplete: onComplete,
            startTime: Date.now()
          };
          _loadingFonts.push(fontLoadHandle);
          -1 === _intervalId && (_intervalId = setInterval(_checkFontLoaded, 100));
        }
        _fontFaces[fontFamilyName] = fontStyle;
      },
      _getFontFamily: function _getFontFamily(fontHandle) {
        var ttfIndex = fontHandle.lastIndexOf(".ttf");
        if (-1 === ttfIndex) return fontHandle;
        var slashPos = fontHandle.lastIndexOf("/");
        var fontFamilyName;
        fontFamilyName = -1 === slashPos ? fontHandle.substring(0, ttfIndex) + "_LABEL" : fontHandle.substring(slashPos + 1, ttfIndex) + "_LABEL";
        -1 !== fontFamilyName.indexOf(" ") && (fontFamilyName = '"' + fontFamilyName + '"');
        return fontFamilyName;
      }
    };
    module.exports = fontLoader;
  }), {
    "../utils/text-utils": 216
  } ],
  46: [ (function(require, module, exports) {
    "use strict";
    var _require = require("./shared"), bundles = _require.bundles;
    var helper = {
      decodeUuid: require("../utils/decode-uuid"),
      getUuidFromURL: (function() {
        var _uuidRegex = /.*[/\\][0-9a-fA-F]{2}[/\\]([0-9a-fA-F-]{8,})/;
        return function(url) {
          var matches = url.match(_uuidRegex);
          if (matches) return matches[1];
          return "";
        };
      })(),
      getUrlWithUuid: function getUrlWithUuid(uuid, options) {
        options = options || Object.create(null);
        options.__isNative__ = options.isNative;
        var bundle = bundles.find((function(bundle) {
          return bundle.getAssetInfo(uuid);
        }));
        bundle && (options.bundle = bundle.name);
        return cc.assetManager._transform(uuid, options);
      },
      isSceneObj: function isSceneObj(json) {
        var SCENE_ID = "cc.Scene", PREFAB_ID = "cc.Prefab";
        return json && (json[0] && json[0].__type__ === SCENE_ID || json[1] && json[1].__type__ === SCENE_ID || json[0] && json[0].__type__ === PREFAB_ID);
      },
      isScene: function isScene(asset) {
        return asset && (asset.constructor === cc.SceneAsset || asset instanceof cc.Scene);
      },
      normalize: function normalize(url) {
        url && (46 === url.charCodeAt(0) && 47 === url.charCodeAt(1) ? url = url.slice(2) : 47 === url.charCodeAt(0) && (url = url.slice(1)));
        return url;
      }
    };
    module.exports = helper;
  }), {
    "../utils/decode-uuid": 204,
    "./shared": 55
  } ],
  47: [ (function(require, module, exports) {
    "use strict";
    require("./deprecated");
    require("./CCAssetManager");
  }), {
    "./CCAssetManager": 30,
    "./deprecated": 36
  } ],
  48: [ (function(require, module, exports) {
    "use strict";
    var packManager = require("./pack-manager");
    var Pipeline = require("./pipeline");
    var parser = require("./parser");
    var _require = require("./utilities"), getDepends = _require.getDepends, cache = _require.cache, gatherAsset = _require.gatherAsset, setProperties = _require.setProperties, forEach = _require.forEach, clear = _require.clear, checkCircleReference = _require.checkCircleReference;
    var _require2 = require("./shared"), assets = _require2.assets, files = _require2.files, parsed = _require2.parsed, pipeline = _require2.pipeline;
    var Task = require("./task");
    function load(task, done) {
      task.progress || (task.progress = {
        finish: 0,
        total: task.input.length
      });
      var options = task.options, progress = task.progress;
      options.__exclude__ = options.__exclude__ || Object.create(null);
      task.output = [];
      forEach(task.input, (function(item, cb) {
        var subTask = Task.create({
          input: item,
          onProgress: task.onProgress,
          options: options,
          progress: progress,
          onComplete: function onComplete(err, item) {
            !err || task.isFinish || cc.assetManager.force || done(err);
            task.output.push(item);
            subTask.recycle();
            cb();
          }
        });
        loadOneAssetPipeline.async(subTask);
      }), (function() {
        options.__exclude__ = null;
        if (task.isFinish) {
          clear(task, true);
          return task.dispatch("error");
        }
        gatherAsset(task);
        clear(task, true);
        done();
      }));
    }
    var loadOneAssetPipeline = new Pipeline("loadOneAsset", [ function fetch(task, done) {
      var item = task.output = task.input;
      var options = item.options, isNative = item.isNative, uuid = item.uuid, file = item.file;
      var reload = options.reload;
      if (file || !reload && !isNative && assets.has(uuid)) return done();
      packManager.load(item, task.options, (function(err, data) {
        if (err) {
          cc.assetManager.force ? err = null : cc.error(err.message, err.stack);
          data = null;
        }
        item.file = data;
        done(err);
      }));
    }, function parse(task, done) {
      var item = task.output = task.input, progress = task.progress, exclude = task.options.__exclude__;
      var id = item.id, file = item.file, options = item.options;
      if (item.isNative) parser.parse(id, file, item.ext, options, (function(err, asset) {
        if (err && !cc.assetManager.force) {
          cc.error(err.message, err.stack);
          return done(err);
        }
        item.content = asset;
        task.dispatch("progress", ++progress.finish, progress.total, item);
        files.remove(id);
        parsed.remove(id);
        done();
      })); else {
        var uuid = item.uuid;
        if (uuid in exclude) {
          var _exclude$uuid = exclude[uuid], finish = _exclude$uuid.finish, content = _exclude$uuid.content, err = _exclude$uuid.err, callbacks = _exclude$uuid.callbacks;
          task.dispatch("progress", ++progress.finish, progress.total, item);
          if (finish || checkCircleReference(uuid, uuid, exclude)) {
            content && content.addRef();
            item.content = content;
            done(err);
          } else callbacks.push({
            done: done,
            item: item
          });
        } else if (!options.reload && assets.has(uuid)) {
          var asset = assets.get(uuid);
          if (options.__asyncLoadAssets__ || !asset.__asyncLoadAssets__) {
            item.content = asset.addRef();
            task.dispatch("progress", ++progress.finish, progress.total, item);
            done();
          } else loadDepends(task, asset, done, false);
        } else parser.parse(id, file, "import", options, (function(err, asset) {
          if (err) {
            cc.assetManager.force ? err = null : cc.error(err.message, err.stack);
            return done(err);
          }
          asset._uuid = uuid;
          loadDepends(task, asset, done, true);
        }));
      }
    } ]);
    function loadDepends(task, asset, done, init) {
      var item = task.input, progress = task.progress;
      var uuid = item.uuid, id = item.id, options = item.options, config = item.config;
      var __asyncLoadAssets__ = options.__asyncLoadAssets__, cacheAsset = options.cacheAsset;
      var depends = [];
      asset.addRef && asset.addRef();
      getDepends(uuid, asset, Object.create(null), depends, false, __asyncLoadAssets__, config);
      task.dispatch("progress", ++progress.finish, progress.total += depends.length, item);
      var repeatItem = task.options.__exclude__[uuid] = {
        content: asset,
        finish: false,
        callbacks: [ {
          done: done,
          item: item
        } ]
      };
      var subTask = Task.create({
        input: depends,
        options: task.options,
        onProgress: task.onProgress,
        onError: Task.prototype.recycle,
        progress: progress,
        onComplete: function onComplete(err) {
          asset.decRef && asset.decRef(false);
          asset.__asyncLoadAssets__ = __asyncLoadAssets__;
          repeatItem.finish = true;
          repeatItem.err = err;
          if (!err) {
            var assets = Array.isArray(subTask.output) ? subTask.output : [ subTask.output ];
            var map = Object.create(null);
            for (var _i = 0, _l = assets.length; _i < _l; _i++) {
              var dependAsset = assets[_i];
              dependAsset && (map[dependAsset instanceof cc.Asset ? dependAsset._uuid + "@import" : uuid + "@native"] = dependAsset);
            }
            if (init) {
              var missingAsset = setProperties(uuid, asset, map);
              if (!missingAsset) try {
                asset.onLoad && asset.onLoad();
              } catch (e) {
                cc.error(e.message, e.stack);
              }
              files.remove(id);
              parsed.remove(id);
              cache(uuid, asset, void 0 !== cacheAsset ? cacheAsset : cc.assetManager.cacheAsset);
            } else if (asset.__nativeDepend__ && !asset._nativeAsset) {
              var missingAsset = setProperties(uuid, asset, map);
              if (!missingAsset) try {
                asset.onLoad && asset.onLoad();
              } catch (e) {
                cc.error(e.message, e.stack);
              }
            }
            subTask.recycle();
          }
          var callbacks = repeatItem.callbacks;
          for (var i = 0, l = callbacks.length; i < l; i++) {
            var cb = callbacks[i];
            asset.addRef && asset.addRef();
            cb.item.content = asset;
            cb.done(err);
          }
          callbacks.length = 0;
        }
      });
      pipeline.async(subTask);
    }
    module.exports = load;
  }), {
    "./pack-manager": 49,
    "./parser": 50,
    "./pipeline": 51,
    "./shared": 55,
    "./task": 56,
    "./utilities": 58
  } ],
  49: [ (function(require, module, exports) {
    "use strict";
    var downloader = require("./downloader");
    var Cache = require("./cache");
    var js = require("../platform/js");
    var _require = require("./shared"), files = _require.files;
    var _loading = new Cache();
    function isLoading(val) {
      return _loading.has(val.uuid);
    }
    var packManager = {
      unpackJson: function unpackJson(pack, json, options, onComplete) {
        var out = Object.create(null), err = null;
        if (Array.isArray(json)) {
          json.length !== pack.length && cc.errorID(4915);
          for (var i = 0; i < pack.length; i++) {
            var key = pack[i] + "@import";
            out[key] = json[i];
          }
        } else if (json.type === js._getClassId(cc.Texture2D)) {
          if (json.data) {
            var datas = json.data.split("|");
            datas.length !== pack.length && cc.errorID(4915);
            for (var _i = 0; _i < pack.length; _i++) out[pack[_i] + "@import"] = {
              __type__: json.type,
              content: datas[_i]
            };
          }
        } else {
          err = new Error("unmatched type pack!");
          out = null;
        }
        onComplete && onComplete(err, out);
      },
      init: function init() {
        _loading.clear();
      },
      register: function register(type, handler) {
        "object" === typeof type ? js.mixin(unpackers, type) : unpackers[type] = handler;
      },
      unpack: function unpack(pack, data, type, options, onComplete) {
        if (!data) {
          onComplete && onComplete(new Error("package data is wrong!"));
          return;
        }
        var unpacker = unpackers[type];
        unpacker(pack, data, options, onComplete);
      },
      load: function load(item, options, onComplete) {
        if (item.isNative || !item.info || !item.info.packs) return downloader.download(item.id, item.url, item.ext, item.options, onComplete);
        if (files.has(item.id)) return onComplete(null, files.get(item.id));
        var packs = item.info.packs;
        var pack = packs.find(isLoading);
        if (pack) return _loading.get(pack.uuid).push({
          onComplete: onComplete,
          id: item.id
        });
        pack = packs[0];
        _loading.add(pack.uuid, [ {
          onComplete: onComplete,
          id: item.id
        } ]);
        var url = cc.assetManager._transform(pack.uuid, {
          ext: pack.ext,
          bundle: item.config.name
        });
        downloader.download(pack.uuid, url, pack.ext, item.options, (function(err, data) {
          files.remove(pack.uuid);
          err && cc.error(err.message, err.stack);
          packManager.unpack(pack.packs, data, pack.ext, item.options, (function(err, result) {
            if (!err) for (var id in result) files.add(id, result[id]);
            var callbacks = _loading.remove(pack.uuid);
            for (var i = 0, l = callbacks.length; i < l; i++) {
              var cb = callbacks[i];
              if (err) {
                cb.onComplete(err);
                continue;
              }
              var data = result[cb.id];
              data ? cb.onComplete(null, data) : cb.onComplete(new Error("can not retrieve data from package"));
            }
          }));
        }));
      }
    };
    var unpackers = {
      ".json": packManager.unpackJson
    };
    module.exports = packManager;
  }), {
    "../platform/js": 158,
    "./cache": 33,
    "./downloader": 42,
    "./shared": 55
  } ],
  50: [ (function(require, module, exports) {
    "use strict";
    var plistParser = require("../platform/CCSAXParser").plistParser;
    var js = require("../platform/js");
    var deserialize = require("./deserialize");
    var Cache = require("./cache");
    var _require = require("./helper"), isScene = _require.isScene;
    var _require2 = require("./shared"), parsed = _require2.parsed, files = _require2.files;
    var _require3 = require("../platform/CCSys"), __audioSupport = _require3.__audioSupport, capabilities = _require3.capabilities;
    var _parsing = new Cache();
    var parser = {
      parseImage: function parseImage(file, options, onComplete) {
        if (capabilities.imageBitmap && file instanceof Blob) {
          var imageOptions = {};
          imageOptions.imageOrientation = options.__flipY__ ? "flipY" : "none";
          imageOptions.premultiplyAlpha = options.__premultiplyAlpha__ ? "premultiply" : "none";
          createImageBitmap(file, imageOptions).then((function(result) {
            result.flipY = !!options.__flipY__;
            result.premultiplyAlpha = !!options.__premultiplyAlpha__;
            onComplete && onComplete(null, result);
          }), (function(err) {
            onComplete && onComplete(err, null);
          }));
        } else onComplete && onComplete(null, file);
      },
      parseAudio: function parseAudio(file, options, onComplete) {
        file instanceof ArrayBuffer ? __audioSupport.context.decodeAudioData(file, (function(buffer) {
          onComplete && onComplete(null, buffer);
        }), (function(e) {
          onComplete && onComplete(e, null);
        })) : onComplete && onComplete(null, file);
      },
      parsePVRTex: (function() {
        var PVR_HEADER_LENGTH = 13;
        var PVR_MAGIC = 55727696;
        var PVR_HEADER_MAGIC = 0;
        var PVR_HEADER_FORMAT = 2;
        var PVR_HEADER_HEIGHT = 6;
        var PVR_HEADER_WIDTH = 7;
        var PVR_HEADER_MIPMAPCOUNT = 11;
        var PVR_HEADER_METADATA = 12;
        return function(file, options, onComplete) {
          var err = null, out = null;
          try {
            var buffer = file instanceof ArrayBuffer ? file : file.buffer;
            var header = new Int32Array(buffer, 0, PVR_HEADER_LENGTH);
            if (header[PVR_HEADER_MAGIC] != PVR_MAGIC) throw new Error("Invalid magic number in PVR header");
            var width = header[PVR_HEADER_WIDTH];
            var height = header[PVR_HEADER_HEIGHT];
            var dataOffset = header[PVR_HEADER_METADATA] + 52;
            var pvrtcData = new Uint8Array(buffer, dataOffset);
            out = {
              _data: pvrtcData,
              _compressed: true,
              width: width,
              height: height
            };
          } catch (e) {
            err = e;
          }
          onComplete && onComplete(err, out);
        };
      })(),
      parsePKMTex: (function() {
        var ETC_PKM_HEADER_SIZE = 16;
        var ETC_PKM_FORMAT_OFFSET = 6;
        var ETC_PKM_ENCODED_WIDTH_OFFSET = 8;
        var ETC_PKM_ENCODED_HEIGHT_OFFSET = 10;
        var ETC_PKM_WIDTH_OFFSET = 12;
        var ETC_PKM_HEIGHT_OFFSET = 14;
        var ETC1_RGB_NO_MIPMAPS = 0;
        var ETC2_RGB_NO_MIPMAPS = 1;
        var ETC2_RGBA_NO_MIPMAPS = 3;
        function readBEUint16(header, offset) {
          return header[offset] << 8 | header[offset + 1];
        }
        return function(file, options, onComplete) {
          var err = null, out = null;
          try {
            var buffer = file instanceof ArrayBuffer ? file : file.buffer;
            var header = new Uint8Array(buffer);
            var format = readBEUint16(header, ETC_PKM_FORMAT_OFFSET);
            if (format !== ETC1_RGB_NO_MIPMAPS && format !== ETC2_RGB_NO_MIPMAPS && format !== ETC2_RGBA_NO_MIPMAPS) return new Error("Invalid magic number in ETC header");
            var width = readBEUint16(header, ETC_PKM_WIDTH_OFFSET);
            var height = readBEUint16(header, ETC_PKM_HEIGHT_OFFSET);
            var encodedWidth = readBEUint16(header, ETC_PKM_ENCODED_WIDTH_OFFSET);
            var encodedHeight = readBEUint16(header, ETC_PKM_ENCODED_HEIGHT_OFFSET);
            var etcData = new Uint8Array(buffer, ETC_PKM_HEADER_SIZE);
            out = {
              _data: etcData,
              _compressed: true,
              width: width,
              height: height
            };
          } catch (e) {
            err = e;
          }
          onComplete && onComplete(err, out);
        };
      })(),
      parsePlist: function parsePlist(file, options, onComplete) {
        var err = null;
        var result = plistParser.parse(file);
        result || (err = new Error("parse failed"));
        onComplete && onComplete(err, result);
      },
      parseImport: function parseImport(file, options, onComplete) {
        if (!file) return onComplete && onComplete(new Error("Json is empty"));
        var result, err = null;
        try {
          result = deserialize(file, options);
        } catch (e) {
          err = e;
        }
        onComplete && onComplete(err, result);
      },
      init: function init() {
        _parsing.clear();
      },
      register: function register(type, handler) {
        "object" === typeof type ? js.mixin(parsers, type) : parsers[type] = handler;
      },
      parse: function parse(id, file, type, options, onComplete) {
        var parsedAsset, parsing, parseHandler;
        if (parsedAsset = parsed.get(id)) onComplete(null, parsedAsset); else if (parsing = _parsing.get(id)) parsing.push(onComplete); else if (parseHandler = parsers[type]) {
          _parsing.add(id, [ onComplete ]);
          parseHandler(file, options, (function(err, data) {
            err ? files.remove(id) : isScene(data) || parsed.add(id, data);
            var callbacks = _parsing.remove(id);
            for (var i = 0, l = callbacks.length; i < l; i++) callbacks[i](err, data);
          }));
        } else onComplete(null, file);
      }
    };
    var parsers = {
      ".png": parser.parseImage,
      ".jpg": parser.parseImage,
      ".bmp": parser.parseImage,
      ".jpeg": parser.parseImage,
      ".gif": parser.parseImage,
      ".ico": parser.parseImage,
      ".tiff": parser.parseImage,
      ".webp": parser.parseImage,
      ".image": parser.parseImage,
      ".pvr": parser.parsePVRTex,
      ".pkm": parser.parsePKMTex,
      ".mp3": parser.parseAudio,
      ".ogg": parser.parseAudio,
      ".wav": parser.parseAudio,
      ".m4a": parser.parseAudio,
      ".plist": parser.parsePlist,
      import: parser.parseImport
    };
    module.exports = parser;
  }), {
    "../platform/CCSAXParser": 145,
    "../platform/CCSys": 147,
    "../platform/js": 158,
    "./cache": 33,
    "./deserialize": 37,
    "./helper": 46,
    "./shared": 55
  } ],
  51: [ (function(require, module, exports) {
    "use strict";
    var Task = require("./task");
    var _pipelineId = 0;
    function Pipeline(name, funcs) {
      if (!Array.isArray(funcs)) {
        cc.warn("funcs must be an array");
        return;
      }
      this.id = _pipelineId++;
      this.name = name;
      this.pipes = [];
      for (var i = 0, l = funcs.length; i < l; i++) "function" === typeof funcs[i] && this.pipes.push(funcs[i]);
    }
    Pipeline.prototype = {
      constructor: Pipeline,
      insert: function insert(func, index) {
        if ("function" !== typeof func || index > this.pipes.length) {
          cc.warnID(4921);
          return;
        }
        this.pipes.splice(index, 0, func);
        return this;
      },
      append: function append(func) {
        if ("function" !== typeof func) return;
        this.pipes.push(func);
        return this;
      },
      remove: function remove(index) {
        if ("number" !== typeof index) return;
        this.pipes.splice(index, 1);
        return this;
      },
      sync: function sync(task) {
        var pipes = this.pipes;
        if (!(task instanceof Task) || 0 === pipes.length) return;
        if (null != task.output) {
          task.input = task.output;
          task.output = null;
        }
        task._isFinish = false;
        for (var i = 0, l = pipes.length; i < l; ) {
          var pipe = pipes[i];
          var result = pipe(task);
          if (result) {
            task._isFinish = true;
            return result;
          }
          i++;
          if (i !== l) {
            task.input = task.output;
            task.output = null;
          }
        }
        task._isFinish = true;
        return task.output;
      },
      async: function async(task) {
        var pipes = this.pipes;
        if (!(task instanceof Task) || 0 === pipes.length) return;
        if (null != task.output) {
          task.input = task.output;
          task.output = null;
        }
        task._isFinish = false;
        this._flow(0, task);
      },
      _flow: function _flow(index, task) {
        var self = this;
        var pipe = this.pipes[index];
        pipe(task, (function(result) {
          if (result) {
            task._isFinish = true;
            task.onComplete && task.onComplete(result);
          } else {
            index++;
            if (index < self.pipes.length) {
              task.input = task.output;
              task.output = null;
              self._flow(index, task);
            } else {
              task._isFinish = true;
              task.onComplete && task.onComplete(result, task.output);
            }
          }
        }));
      }
    };
    module.exports = Pipeline;
  }), {
    "./task": 56
  } ],
  52: [ (function(require, module, exports) {
    "use strict";
    var Task = require("./task");
    var _require = require("./shared"), transformPipeline = _require.transformPipeline, RequestType = _require.RequestType;
    function preprocess(task, done) {
      var options = task.options, subOptions = Object.create(null), leftOptions = Object.create(null);
      for (var op in options) switch (op) {
       case RequestType.PATH:
       case RequestType.UUID:
       case RequestType.DIR:
       case RequestType.SCENE:
       case RequestType.URL:
        break;

       case "__requestType__":
       case "__isNative__":
       case "ext":
       case "type":
       case "__nativeName__":
       case "audioLoadMode":
       case "bundle":
        subOptions[op] = options[op];
        break;

       case "__exclude__":
       case "__outputAsArray__":
        leftOptions[op] = options[op];
        break;

       default:
        subOptions[op] = options[op];
        leftOptions[op] = options[op];
      }
      task.options = leftOptions;
      var subTask = Task.create({
        input: task.input,
        options: subOptions
      });
      var err = null;
      try {
        task.output = task.source = transformPipeline.sync(subTask);
      } catch (e) {
        err = e;
        for (var i = 0, l = subTask.output.length; i < l; i++) subTask.output[i].recycle();
      }
      subTask.recycle();
      done(err);
    }
    module.exports = preprocess;
  }), {
    "./shared": 55,
    "./task": 56
  } ],
  53: [ (function(require, module, exports) {
    "use strict";
    var dependUtil = require("./depend-util");
    var Cache = require("./cache");
    require("../assets/CCAsset");
    var _require = require("./shared"), assets = _require.assets;
    function visitAsset(asset, deps) {
      if (!asset._uuid) return;
      deps.push(asset._uuid);
    }
    function visitComponent(comp, deps) {
      var props = Object.getOwnPropertyNames(comp);
      for (var i = 0; i < props.length; i++) {
        var propName = props[i];
        if ("node" === propName || "__eventTargets" === propName) continue;
        var value = comp[propName];
        if ("object" === typeof value && value) if (Array.isArray(value)) for (var j = 0; j < value.length; j++) {
          var val = value[j];
          val instanceof cc.Asset && visitAsset(val, deps);
        } else if (value.constructor && value.constructor !== Object) value instanceof cc.Asset && visitAsset(value, deps); else {
          var keys = Object.getOwnPropertyNames(value);
          for (var _j = 0; _j < keys.length; _j++) {
            var _val = value[keys[_j]];
            _val instanceof cc.Asset && visitAsset(_val, deps);
          }
        }
      }
    }
    var _temp = [];
    function visitNode(node, deps) {
      for (var i = 0; i < node._components.length; i++) visitComponent(node._components[i], deps);
      for (var _i = 0; _i < node._children.length; _i++) visitNode(node._children[_i], deps);
    }
    function descendOpRef(asset, refs, exclude, op) {
      exclude.push(asset._uuid);
      var depends = dependUtil.getDeps(asset._uuid);
      for (var i = 0, l = depends.length; i < l; i++) {
        var dependAsset = assets.get(depends[i]);
        if (dependAsset) {
          var uuid = dependAsset._uuid;
          uuid in refs ? refs[uuid] += op : refs[uuid] = dependAsset.refCount + op;
          if (exclude.includes(uuid)) continue;
          descendOpRef(dependAsset, refs, exclude, op);
        }
      }
    }
    function checkCircularReference(asset) {
      var refs = Object.create(null);
      refs[asset._uuid] = asset.refCount;
      descendOpRef(asset, refs, _temp, -1);
      _temp.length = 0;
      if (0 !== refs[asset._uuid]) return refs[asset._uuid];
      for (var uuid in refs) 0 !== refs[uuid] && descendOpRef(assets.get(uuid), refs, _temp, 1);
      _temp.length = 0;
      return refs[asset._uuid];
    }
    var _persistNodeDeps = new Cache();
    var _toDelete = new Cache();
    var eventListener = false;
    function freeAssets() {
      eventListener = false;
      _toDelete.forEach((function(asset) {
        releaseManager._free(asset);
      }));
      _toDelete.clear();
    }
    var releaseManager = {
      init: function init() {
        _persistNodeDeps.clear();
        _toDelete.clear();
      },
      _addPersistNodeRef: function _addPersistNodeRef(node) {
        var deps = [];
        visitNode(node, deps);
        for (var i = 0, l = deps.length; i < l; i++) {
          var dependAsset = assets.get(deps[i]);
          dependAsset && dependAsset.addRef();
        }
        _persistNodeDeps.add(node.uuid, deps);
      },
      _removePersistNodeRef: function _removePersistNodeRef(node) {
        if (_persistNodeDeps.has(node.uuid)) {
          var deps = _persistNodeDeps.get(node.uuid);
          for (var i = 0, l = deps.length; i < l; i++) {
            var dependAsset = assets.get(deps[i]);
            dependAsset && dependAsset.decRef();
          }
          _persistNodeDeps.remove(node.uuid);
        }
      },
      _autoRelease: function _autoRelease(oldScene, newScene, persistNodes) {
        for (var i = 0, l = persistNodes.length; i < l; i++) {
          var node = persistNodes[i];
          var sceneDeps = dependUtil._depends.get(newScene._id);
          var deps = _persistNodeDeps.get(node.uuid);
          for (var _i2 = 0, _l = deps.length; _i2 < _l; _i2++) {
            var dependAsset = assets.get(deps[_i2]);
            dependAsset && dependAsset.addRef();
          }
          if (sceneDeps) {
            !sceneDeps.persistDeps && (sceneDeps.persistDeps = []);
            sceneDeps.persistDeps.push.apply(sceneDeps.persistDeps, deps);
          }
        }
        if (oldScene) {
          var childs = dependUtil.getDeps(oldScene._id);
          for (var _i3 = 0, _l2 = childs.length; _i3 < _l2; _i3++) {
            var asset = assets.get(childs[_i3]);
            asset && asset.decRef((false, oldScene.autoReleaseAssets));
          }
          var dependencies = dependUtil._depends.get(oldScene._id);
          if (dependencies && dependencies.persistDeps) {
            var persistDeps = dependencies.persistDeps;
            for (var _i4 = 0, _l3 = persistDeps.length; _i4 < _l3; _i4++) {
              var _asset = assets.get(persistDeps[_i4]);
              _asset && _asset.decRef((false, oldScene.autoReleaseAssets));
            }
          }
          dependUtil.remove(oldScene._id);
        }
      },
      _free: function _free(asset, force) {
        _toDelete.remove(asset._uuid);
        if (!cc.isValid(asset, true)) return;
        if (!force && asset.refCount > 0 && checkCircularReference(asset) > 0) return;
        assets.remove(asset._uuid);
        var depends = dependUtil.getDeps(asset._uuid);
        for (var i = 0, l = depends.length; i < l; i++) {
          var dependAsset = assets.get(depends[i]);
          if (dependAsset) {
            dependAsset.decRef(false);
            releaseManager._free(dependAsset, false);
          }
        }
        asset.destroy();
        dependUtil.remove(asset._uuid);
      },
      tryRelease: function tryRelease(asset, force) {
        if (!(asset instanceof cc.Asset)) return;
        if (force) releaseManager._free(asset, force); else {
          _toDelete.add(asset._uuid, asset);
          if (!eventListener) {
            eventListener = true;
            cc.director.once(cc.Director.EVENT_AFTER_DRAW, freeAssets);
          }
        }
      }
    };
    module.exports = releaseManager;
  }), {
    "../assets/CCAsset": 59,
    "./cache": 33,
    "./depend-util": 35,
    "./shared": 55
  } ],
  54: [ (function(require, module, exports) {
    "use strict";
    var MAX_DEAD_NUM = 500;
    var _deadPool = [];
    function RequestItem() {
      this._id = "";
      this.uuid = "";
      this.url = "";
      this.ext = ".json";
      this.content = null;
      this.file = null;
      this.info = null;
      this.config = null;
      this.isNative = false;
      this.options = Object.create(null);
    }
    RequestItem.prototype = {
      constructor: RequestItem,
      get id() {
        this._id || (this._id = this.uuid + "@" + (this.isNative ? "native" : "import"));
        return this._id;
      },
      recycle: function recycle() {
        if (_deadPool.length === MAX_DEAD_NUM) return;
        this._id = "";
        this.uuid = "";
        this.url = "";
        this.ext = ".json";
        this.content = null;
        this.file = null;
        this.info = null;
        this.config = null;
        this.isNative = false;
        this.options = Object.create(null);
        _deadPool.push(this);
      }
    };
    RequestItem.create = function() {
      var out = null;
      out = 0 !== _deadPool.length ? _deadPool.pop() : new RequestItem();
      return out;
    };
    module.exports = RequestItem;
  }), {} ],
  55: [ (function(require, module, exports) {
    "use strict";
    var Cache = require("./cache");
    var Pipeline = require("./pipeline");
    var assets = new Cache();
    var files = new Cache();
    var parsed = new Cache();
    var bundles = new Cache();
    var pipeline = new Pipeline("normal load", []);
    var fetchPipeline = new Pipeline("fetch", []);
    var transformPipeline = new Pipeline("transform url", []);
    var RequestType = {
      UUID: "uuid",
      PATH: "path",
      DIR: "dir",
      URL: "url",
      SCENE: "scene"
    };
    var BuiltinBundleName = {
      RESOURCES: "resources",
      INTERNAL: "internal",
      MAIN: "main",
      START_SCENE: "start-scene"
    };
    module.exports = {
      assets: assets,
      files: files,
      parsed: parsed,
      pipeline: pipeline,
      fetchPipeline: fetchPipeline,
      transformPipeline: transformPipeline,
      RequestType: RequestType,
      bundles: bundles,
      BuiltinBundleName: BuiltinBundleName
    };
  }), {
    "./cache": 33,
    "./pipeline": 51
  } ],
  56: [ (function(require, module, exports) {
    "use strict";
    var _taskId = 0;
    var MAX_DEAD_NUM = 500;
    var _deadPool = [];
    function Task(options) {
      this.id = _taskId++;
      this._isFinish = true;
      this.onComplete = null;
      this.onProgress = null;
      this.onError = null;
      this.source = null;
      this.output = null;
      this.input = null;
      this.progress = null;
      this.options = null;
      this.set(options);
    }
    Task.prototype = {
      constructor: Task,
      set: function set(options) {
        options = options || Object.create(null);
        this.onComplete = options.onComplete;
        this.onProgress = options.onProgress;
        this.onError = options.onError;
        this.source = this.input = options.input;
        this.output = null;
        this.progress = options.progress;
        this.options = options.options || Object.create(null);
      },
      dispatch: function dispatch(event, param1, param2, param3, param4) {
        switch (event) {
         case "complete":
          this.onComplete && this.onComplete(param1, param2, param3, param4);
          break;

         case "progress":
          this.onProgress && this.onProgress(param1, param2, param3, param4);
          break;

         case "error":
          this.onError && this.onError(param1, param2, param3, param4);
          break;

         default:
          var str = "on" + event[0].toUpperCase() + event.substr(1);
          "function" === typeof this[str] && this[str](param1, param2, param3, param4);
        }
      },
      recycle: function recycle() {
        if (_deadPool.length === MAX_DEAD_NUM) return;
        this.onComplete = null;
        this.onProgress = null;
        this.onError = null;
        this.source = this.output = this.input = null;
        this.progress = null;
        this.options = null;
        _deadPool.push(this);
      },
      get isFinish() {
        return this._isFinish;
      }
    };
    Task.create = function(options) {
      var out = null;
      if (0 !== _deadPool.length) {
        out = _deadPool.pop();
        out.set(options);
      } else out = new Task(options);
      return out;
    };
    module.exports = Task;
  }), {} ],
  57: [ (function(require, module, exports) {
    "use strict";
    var _require = require("./helper"), decodeUuid = _require.decodeUuid;
    var RequestItem = require("./request-item");
    var _require2 = require("./shared"), RequestType = _require2.RequestType, bundles = _require2.bundles;
    function parse(task) {
      var input = task.input, options = task.options;
      input = Array.isArray(input) ? input : [ input ];
      task.output = [];
      for (var i = 0; i < input.length; i++) {
        var item = input[i];
        var out = RequestItem.create();
        if ("string" === typeof item) {
          item = Object.create(null);
          item[options.__requestType__ || RequestType.UUID] = input[i];
        }
        if ("object" === typeof item) {
          cc.js.addon(item, options);
          item.preset && cc.js.addon(item, cc.assetManager.presets[item.preset]);
          for (var key in item) {
            switch (key) {
             case RequestType.UUID:
              var uuid = out.uuid = decodeUuid(item.uuid);
              if (bundles.has(item.bundle)) {
                var config = bundles.get(item.bundle)._config;
                var info = config.getAssetInfo(uuid);
                if (info && info.redirect) {
                  if (!bundles.has(info.redirect)) throw new Error("Please load bundle " + info.redirect + " first");
                  config = bundles.get(info.redirect)._config;
                  info = config.getAssetInfo(uuid);
                }
                out.config = config;
                out.info = info;
              }
              out.ext = item.ext || ".json";
              break;

             case "__requestType__":
             case "ext":
             case "bundle":
             case "preset":
             case "type":
              break;

             case RequestType.DIR:
              if (bundles.has(item.bundle)) {
                var infos = [];
                bundles.get(item.bundle)._config.getDirWithPath(item.dir, item.type, infos);
                for (var _i = 0, l = infos.length; _i < l; _i++) {
                  var info = infos[_i];
                  input.push({
                    uuid: info.uuid,
                    __isNative__: false,
                    ext: ".json",
                    bundle: item.bundle
                  });
                }
              }
              out.recycle();
              out = null;
              break;

             case RequestType.PATH:
              if (bundles.has(item.bundle)) {
                var config = bundles.get(item.bundle)._config;
                var info = config.getInfoWithPath(item.path, item.type);
                if (info && info.redirect) {
                  if (!bundles.has(info.redirect)) throw new Error("you need to load bundle " + info.redirect + " first");
                  config = bundles.get(info.redirect)._config;
                  info = config.getAssetInfo(info.uuid);
                }
                if (!info) {
                  out.recycle();
                  throw new Error("Bundle " + item.bundle + " doesn't contain " + item.path);
                }
                out.config = config;
                out.uuid = info.uuid;
                out.info = info;
              }
              out.ext = item.ext || ".json";
              break;

             case RequestType.SCENE:
              if (bundles.has(item.bundle)) {
                var config = bundles.get(item.bundle)._config;
                var info = config.getSceneInfo(item.scene);
                if (info && info.redirect) {
                  if (!bundles.has(info.redirect)) throw new Error("you need to load bundle " + info.redirect + " first");
                  config = bundles.get(info.redirect)._config;
                  info = config.getAssetInfo(info.uuid);
                }
                if (!info) {
                  out.recycle();
                  throw new Error("Bundle " + config.name + " doesn't contain scene " + item.scene);
                }
                out.config = config;
                out.uuid = info.uuid;
                out.info = info;
              }
              break;

             case "__isNative__":
              out.isNative = item.__isNative__;
              break;

             case RequestType.URL:
              out.url = item.url;
              out.uuid = item.uuid || item.url;
              out.ext = item.ext || cc.path.extname(item.url);
              out.isNative = void 0 === item.__isNative__ || item.__isNative__;
              break;

             default:
              out.options[key] = item[key];
            }
            if (!out) break;
          }
        }
        if (!out) continue;
        task.output.push(out);
        if (!out.uuid && !out.url) throw new Error("unknown input:" + item.toString());
      }
      return null;
    }
    function combine(task) {
      var input = task.output = task.input;
      for (var i = 0; i < input.length; i++) {
        var item = input[i];
        if (item.url) continue;
        var url = "", base = "";
        var config = item.config;
        base = item.isNative ? config && config.nativeBase ? config.base + config.nativeBase : cc.assetManager.generalNativeBase : config && config.importBase ? config.base + config.importBase : cc.assetManager.generalImportBase;
        var uuid = item.uuid;
        var ver = "";
        item.info && (ver = item.isNative ? item.info.nativeVer ? "." + item.info.nativeVer : "" : item.info.ver ? "." + item.info.ver : "");
        url = ".ttf" === item.ext ? base + "/" + uuid.slice(0, 2) + "/" + uuid + ver + "/" + item.options.__nativeName__ : base + "/" + uuid.slice(0, 2) + "/" + uuid + ver + item.ext;
        item.url = url;
      }
      return null;
    }
    module.exports = {
      parse: parse,
      combine: combine
    };
  }), {
    "./helper": 46,
    "./request-item": 54,
    "./shared": 55
  } ],
  58: [ (function(require, module, exports) {
    "use strict";
    var dependUtil = require("./depend-util");
    var _require = require("./helper"), isScene = _require.isScene, decodeUuid = _require.decodeUuid;
    var _require2 = require("./shared"), assets = _require2.assets;
    var _require3 = require("../platform/utils"), callInNextTick = _require3.callInNextTick;
    var MissingObjectReporter = false;
    require("../assets/CCAsset");
    var utils = {
      processOptions: function processOptions(options) {
        false;
        var uuids = options.uuids;
        var paths = options.paths;
        var types = options.types;
        var bundles = options.deps;
        var realEntries = options.paths = Object.create(null);
        if (false === options.debug) {
          for (var i = 0, l = uuids.length; i < l; i++) uuids[i] = decodeUuid(uuids[i]);
          for (var id in paths) {
            var entry = paths[id];
            var type = entry[1];
            entry[1] = types[type];
          }
        } else {
          var out = Object.create(null);
          for (var _i = 0, _l = uuids.length; _i < _l; _i++) {
            var uuid = uuids[_i];
            uuids[_i] = out[uuid] = decodeUuid(uuid);
          }
          uuids = out;
        }
        for (var _id in paths) {
          var _entry = paths[_id];
          realEntries[uuids[_id]] = _entry;
        }
        var scenes = options.scenes;
        for (var name in scenes) {
          var _uuid = scenes[name];
          scenes[name] = uuids[_uuid];
        }
        var packs = options.packs;
        for (var packId in packs) {
          var packedIds = packs[packId];
          for (var j = 0; j < packedIds.length; ++j) packedIds[j] = uuids[packedIds[j]];
        }
        var versions = options.versions;
        if (versions) for (var folder in versions) {
          var entries = versions[folder];
          for (var _i2 = 0; _i2 < entries.length; _i2 += 2) {
            var _uuid2 = entries[_i2];
            entries[_i2] = uuids[_uuid2] || _uuid2;
          }
        }
        var redirect = options.redirect;
        if (redirect) for (var _i3 = 0; _i3 < redirect.length; _i3 += 2) {
          redirect[_i3] = uuids[redirect[_i3]];
          redirect[_i3 + 1] = bundles[redirect[_i3 + 1]];
        }
      },
      clear: function clear(task, clearRef) {
        for (var i = 0, l = task.input.length; i < l; i++) {
          var item = task.input[i];
          clearRef && !item.isNative && item.content && item.content.decRef && item.content.decRef(false);
          item.recycle();
        }
        task.input = null;
      },
      urlAppendTimestamp: function urlAppendTimestamp(url) {
        if (cc.assetManager.downloader.appendTimeStamp && "string" === typeof url) return /\?/.test(url) ? url + "&_t=" + (new Date() - 0) : url + "?_t=" + (new Date() - 0);
        return url;
      },
      retry: function retry(process, times, wait, onComplete, index) {
        index = index || 0;
        process(index, (function(err, result) {
          index++;
          !err || index > times ? onComplete && onComplete(err, result) : setTimeout((function() {
            utils.retry(process, times, wait, onComplete, index);
          }), wait);
        }));
      },
      getDepends: function getDepends(uuid, data, exclude, depends, preload, asyncLoadAssets, config) {
        var err = null;
        try {
          var info = dependUtil.parse(uuid, data);
          var includeNative = true;
          data instanceof cc.Asset && (!data.__nativeDepend__ || data._nativeAsset) && (includeNative = false);
          if (preload) {
            for (var _i4 = 0, _l2 = info.deps.length; _i4 < _l2; _i4++) {
              var _dep = info.deps[_i4];
              if (!(_dep in exclude)) {
                exclude[_dep] = true;
                depends.push({
                  uuid: _dep,
                  bundle: config && config.name
                });
              }
            }
            if (includeNative && info.nativeDep) {
              config && (info.nativeDep.bundle = config.name);
              depends.push(info.nativeDep);
            }
          } else {
            asyncLoadAssets = (true, !!data.asyncLoadAssets || asyncLoadAssets && !info.preventDeferredLoadDependents);
            for (var i = 0, l = info.deps.length; i < l; i++) {
              var dep = info.deps[i];
              if (!(dep in exclude)) {
                exclude[dep] = true;
                depends.push({
                  uuid: dep,
                  __asyncLoadAssets__: asyncLoadAssets,
                  bundle: config && config.name
                });
              }
            }
            if (includeNative && !asyncLoadAssets && !info.preventPreloadNativeObject && info.nativeDep) {
              config && (info.nativeDep.bundle = config.name);
              depends.push(info.nativeDep);
            }
          }
        } catch (e) {
          err = e;
        }
        return err;
      },
      cache: function cache(id, asset, cacheAsset) {
        if (!asset) return;
        var _isScene = isScene(asset);
        !_isScene && cacheAsset && assets.add(id, asset);
        _isScene && false;
      },
      setProperties: function setProperties(uuid, asset, assetsMap) {
        var missingAsset = false;
        var depends = asset.__depends__;
        if (depends) {
          var missingAssetReporter = null;
          for (var i = 0, l = depends.length; i < l; i++) {
            var depend = depends[i];
            var dependAsset = assetsMap[depend.uuid + "@import"];
            if (dependAsset) depend.owner[depend.prop] = dependAsset.addRef(); else {
              false;
              cc.error("The asset " + depend.uuid + " is missing!");
              missingAsset = true;
            }
          }
          missingAssetReporter && missingAssetReporter.reportByOwner();
          asset.__depends__ = void 0;
        }
        if (asset.__nativeDepend__) {
          if (!asset._nativeAsset) if (assetsMap[uuid + "@native"]) asset._nativeAsset = assetsMap[uuid + "@native"]; else {
            missingAsset = true;
            false;
          }
          asset.__nativeDepend__ = void 0;
        }
        return missingAsset;
      },
      gatherAsset: function gatherAsset(task) {
        var source = task.source;
        if (task.options.__outputAsArray__ || 1 !== source.length) {
          var output = task.output = [];
          for (var i = 0, l = source.length; i < l; i++) output.push(source[i].content);
        } else task.output = source[0].content;
      },
      forEach: function forEach(array, process, onComplete) {
        var count = 0;
        var errs = [];
        0 === array.length && onComplete && onComplete(errs);
        for (var i = 0, l = array.length; i < l; i++) process(array[i], (function(err) {
          err && errs.push(err);
          count++;
          count === l && onComplete && onComplete(errs);
        }));
      },
      parseParameters: function parseParameters(options, onProgress, onComplete) {
        if (void 0 === onComplete) {
          var isCallback = "function" === typeof options;
          if (onProgress) {
            onComplete = onProgress;
            isCallback || (onProgress = null);
          } else if (void 0 === onProgress && isCallback) {
            onComplete = options;
            options = null;
            onProgress = null;
          }
          if (void 0 !== onProgress && isCallback) {
            onProgress = options;
            options = null;
          }
        }
        options = options || Object.create(null);
        return {
          options: options,
          onProgress: onProgress,
          onComplete: onComplete
        };
      },
      parseLoadResArgs: function parseLoadResArgs(type, onProgress, onComplete) {
        if (void 0 === onComplete) {
          var isValidType = cc.js.isChildClassOf(type, cc.Asset);
          if (onProgress) {
            onComplete = onProgress;
            isValidType && (onProgress = null);
          } else if (void 0 === onProgress && !isValidType) {
            onComplete = type;
            onProgress = null;
            type = null;
          }
          if (void 0 !== onProgress && !isValidType) {
            onProgress = type;
            type = null;
          }
        }
        return {
          type: type,
          onProgress: onProgress,
          onComplete: onComplete
        };
      },
      checkCircleReference: function checkCircleReference(owner, uuid, map, checked) {
        checked || (checked = Object.create(null));
        var item = map[uuid];
        if (!item || checked[uuid]) return false;
        checked[uuid] = true;
        var result = false;
        var deps = item.content && item.content.__depends__;
        if (deps) for (var i = 0, l = deps.length; i < l; i++) {
          var dep = deps[i];
          if (dep.uuid === owner || utils.checkCircleReference(owner, dep.uuid, map, checked)) {
            result = true;
            break;
          }
        }
        return result;
      },
      asyncify: function asyncify(cb) {
        return function(p1, p2) {
          cb && callInNextTick(cb, p1, p2);
        };
      }
    };
    module.exports = utils;
  }), {
    "../assets/CCAsset": 59,
    "../platform/utils": 161,
    "./depend-util": 35,
    "./helper": 46,
    "./shared": 55
  } ],
  59: [ (function(require, module, exports) {
    "use strict";
    var CCObject = require("../platform/CCObject");
    cc.Asset = cc.Class({
      name: "cc.Asset",
      extends: CCObject,
      ctor: function ctor() {
        Object.defineProperty(this, "_uuid", {
          value: "",
          writable: true
        });
        this.loaded = true;
        this._nativeUrl = "";
        this._ref = 0;
      },
      properties: {
        nativeUrl: {
          get: function get() {
            if (!this._nativeUrl && this._native) {
              var name = this._native;
              if (47 === name.charCodeAt(0)) return name.slice(1);
              46 === name.charCodeAt(0) ? this._nativeUrl = cc.assetManager.utils.getUrlWithUuid(this._uuid, {
                ext: name,
                isNative: true
              }) : this._nativeUrl = cc.assetManager.utils.getUrlWithUuid(this._uuid, {
                __nativeName__: name,
                ext: cc.path.extname(name),
                isNative: true
              });
            }
            return this._nativeUrl;
          },
          visible: false
        },
        refCount: {
          get: function get() {
            return this._ref;
          }
        },
        _native: "",
        _nativeAsset: {
          get: function get() {
            return this._$nativeAsset;
          },
          set: function set(obj) {
            this._$nativeAsset = obj;
          }
        },
        _nativeDep: {
          get: function get() {
            if (this._native) return {
              __isNative__: true,
              uuid: this._uuid,
              ext: this._native
            };
          }
        }
      },
      statics: {
        deserialize: false,
        preventDeferredLoadDependents: false,
        preventPreloadNativeObject: false,
        _parseDepsFromJson: function _parseDepsFromJson(json) {
          var depends = [];
          parseDependRecursively(json, depends);
          return depends;
        },
        _parseNativeDepFromJson: function _parseNativeDepFromJson(json) {
          if (json._native) return {
            __isNative__: true,
            ext: json._native
          };
          return null;
        }
      },
      toString: function toString() {
        return this.nativeUrl;
      },
      serialize: false,
      createNode: null,
      _setRawAsset: function _setRawAsset(filename, inLibrary) {
        this._native = false !== inLibrary ? filename || void 0 : "/" + filename;
      },
      addRef: function addRef() {
        this._ref++;
        return this;
      },
      decRef: function decRef(autoRelease) {
        this._ref--;
        false !== autoRelease && cc.assetManager._releaseManager.tryRelease(this);
        return this;
      }
    });
    function parseDependRecursively(data, out) {
      if (!data || "object" !== typeof data || data.__id__) return;
      var uuid = data.__uuid__;
      if (Array.isArray(data)) for (var i = 0, l = data.length; i < l; i++) parseDependRecursively(data[i], out); else if (uuid) out.push(cc.assetManager.utils.decodeUuid(uuid)); else for (var prop in data) parseDependRecursively(data[prop], out);
    }
    module.exports = cc.Asset;
  }), {
    "../platform/CCObject": 144
  } ],
  60: [ (function(require, module, exports) {
    "use strict";
    var Asset = require("./CCAsset");
    var EventTarget = require("../event/event-target");
    var LoadMode = cc.Enum({
      WEB_AUDIO: 0,
      DOM_AUDIO: 1
    });
    var AudioClip = cc.Class({
      name: "cc.AudioClip",
      extends: Asset,
      mixins: [ EventTarget ],
      ctor: function ctor() {
        this._loading = false;
        this.loaded = false;
        this._audio = null;
      },
      properties: {
        duration: 0,
        loadMode: {
          default: LoadMode.WEB_AUDIO,
          type: LoadMode
        },
        _nativeAsset: {
          get: function get() {
            return this._audio;
          },
          set: function set(value) {
            value instanceof cc.AudioClip ? this._audio = value._nativeAsset : this._audio = value;
            if (this._audio) {
              this.loaded = true;
              this.emit("load");
            }
          },
          override: true
        },
        _nativeDep: {
          get: function get() {
            return {
              uuid: this._uuid,
              audioLoadMode: this.loadMode,
              ext: cc.path.extname(this._native),
              __isNative__: true
            };
          },
          override: true
        }
      },
      statics: {
        LoadMode: LoadMode,
        _loadByUrl: function _loadByUrl(url, callback) {
          var audioClip = cc.assetManager.assets.get(url);
          audioClip ? callback(null, audioClip) : cc.assetManager.loadRemote(url, (function(error, data) {
            if (error) return callback(error);
            callback(null, data);
          }));
        },
        _parseDepsFromJson: function _parseDepsFromJson() {
          return [];
        },
        _parseNativeDepFromJson: function _parseNativeDepFromJson(json) {
          return {
            audioLoadMode: json.loadMode,
            ext: cc.path.extname(json._native),
            __isNative__: true
          };
        }
      },
      _ensureLoaded: function _ensureLoaded(onComplete) {
        if (this.loaded) return onComplete && onComplete();
        onComplete && this.once("load", onComplete);
        if (!this._loading) {
          this._loading = true;
          var self = this;
          cc.assetManager.postLoadNative(this, (function(err) {
            self._loading = false;
          }));
        }
      },
      destroy: function destroy() {
        cc.audioEngine.uncache(this);
        this._super();
      }
    });
    cc.AudioClip = AudioClip;
    module.exports = AudioClip;
  }), {
    "../event/event-target": 121,
    "./CCAsset": 59
  } ],
  61: [ (function(require, module, exports) {
    "use strict";
    var FontLetterDefinition = function FontLetterDefinition() {
      this.u = 0;
      this.v = 0;
      this.w = 0;
      this.h = 0;
      this.offsetX = 0;
      this.offsetY = 0;
      this.textureID = 0;
      this.valid = false;
      this.xAdvance = 0;
    };
    var FontAtlas = function FontAtlas(texture) {
      this._letterDefinitions = {};
      this._texture = texture;
    };
    FontAtlas.prototype = {
      constructor: FontAtlas,
      addLetterDefinitions: function addLetterDefinitions(letter, letterDefinition) {
        this._letterDefinitions[letter] = letterDefinition;
      },
      cloneLetterDefinition: function cloneLetterDefinition() {
        var copyLetterDefinitions = {};
        for (var key in this._letterDefinitions) {
          var value = new FontLetterDefinition();
          cc.js.mixin(value, this._letterDefinitions[key]);
          copyLetterDefinitions[key] = value;
        }
        return copyLetterDefinitions;
      },
      getTexture: function getTexture() {
        return this._texture;
      },
      getLetter: function getLetter(key) {
        return this._letterDefinitions[key];
      },
      getLetterDefinitionForChar: function getLetterDefinitionForChar(_char) {
        var key = _char.charCodeAt(0);
        var hasKey = this._letterDefinitions.hasOwnProperty(key);
        var letter;
        letter = hasKey ? this._letterDefinitions[key] : null;
        return letter;
      },
      clear: function clear() {
        this._letterDefinitions = {};
      }
    };
    var BitmapFont = cc.Class({
      name: "cc.BitmapFont",
      extends: cc.Font,
      properties: {
        fntDataStr: {
          default: ""
        },
        spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        fontSize: {
          default: -1
        },
        _fntConfig: null,
        _fontDefDictionary: null
      },
      onLoad: function onLoad() {
        var spriteFrame = this.spriteFrame;
        !this._fontDefDictionary && spriteFrame && (this._fontDefDictionary = new FontAtlas(spriteFrame._texture));
        var fntConfig = this._fntConfig;
        if (!fntConfig) return;
        var fontDict = fntConfig.fontDefDictionary;
        for (var fontDef in fontDict) {
          var letter = new FontLetterDefinition();
          var rect = fontDict[fontDef].rect;
          letter.offsetX = fontDict[fontDef].xOffset;
          letter.offsetY = fontDict[fontDef].yOffset;
          letter.w = rect.width;
          letter.h = rect.height;
          letter.u = rect.x;
          letter.v = rect.y;
          letter.textureID = 0;
          letter.valid = true;
          letter.xAdvance = fontDict[fontDef].xAdvance;
          this._fontDefDictionary.addLetterDefinitions(fontDef, letter);
        }
      }
    });
    cc.BitmapFont = BitmapFont;
    cc.BitmapFont.FontLetterDefinition = FontLetterDefinition;
    cc.BitmapFont.FontAtlas = FontAtlas;
    module.exports = BitmapFont;
  }), {} ],
  62: [ (function(require, module, exports) {
    "use strict";
    var BufferAsset = cc.Class({
      name: "cc.BufferAsset",
      extends: cc.Asset,
      ctor: function ctor() {
        this._buffer = null;
      },
      properties: {
        _nativeAsset: {
          get: function get() {
            return this._buffer;
          },
          set: function set(bin) {
            this._buffer = bin.buffer || bin;
          },
          override: true
        },
        buffer: function buffer() {
          return this._buffer;
        }
      }
    });
    cc.BufferAsset = module.exports = BufferAsset;
  }), {} ],
  63: [ (function(require, module, exports) {
    "use strict";
    var Font = cc.Class({
      name: "cc.Font",
      extends: cc.Asset
    });
    cc.Font = module.exports = Font;
  }), {} ],
  64: [ (function(require, module, exports) {
    "use strict";
    var JsonAsset = cc.Class({
      name: "cc.JsonAsset",
      extends: cc.Asset,
      properties: {
        json: null
      }
    });
    module.exports = cc.JsonAsset = JsonAsset;
  }), {} ],
  65: [ (function(require, module, exports) {
    "use strict";
    var LabelAtlas = cc.Class({
      name: "cc.LabelAtlas",
      extends: cc.BitmapFont,
      onLoad: function onLoad() {
        if (!this.spriteFrame) {
          cc.warnID(9100, this.name);
          return;
        }
        if (!this._fntConfig) {
          cc.warnID(9101, this.name);
          return;
        }
        this._super();
      }
    });
    cc.LabelAtlas = LabelAtlas;
    module.exports = LabelAtlas;
  }), {} ],
  66: [ (function(require, module, exports) {
    "use strict";
    var OptimizationPolicy = cc.Enum({
      AUTO: 0,
      SINGLE_INSTANCE: 1,
      MULTI_INSTANCE: 2
    });
    var Prefab = cc.Class({
      name: "cc.Prefab",
      extends: cc.Asset,
      ctor: function ctor() {
        this._createFunction = null;
        this._instantiatedTimes = 0;
      },
      properties: {
        data: null,
        optimizationPolicy: OptimizationPolicy.AUTO,
        asyncLoadAssets: false,
        readonly: {
          default: false,
          editorOnly: true
        }
      },
      statics: {
        OptimizationPolicy: OptimizationPolicy,
        OptimizationPolicyThreshold: 3
      },
      createNode: false,
      compileCreateFunction: function compileCreateFunction() {
        var jit = require("../platform/instantiate-jit");
        this._createFunction = jit.compile(this.data);
      },
      _doInstantiate: function _doInstantiate(rootToRedirect) {
        this.data._prefab ? this.data._prefab._synced = true : cc.warnID(3700);
        this._createFunction || this.compileCreateFunction();
        return this._createFunction(rootToRedirect);
      },
      _instantiate: function _instantiate() {
        var node, useJit = false;
        false;
        if (useJit) {
          node = this._doInstantiate();
          this.data._instantiate(node);
        } else {
          this.data._prefab._synced = true;
          node = this.data._instantiate();
        }
        ++this._instantiatedTimes;
        var PrefabUtils;
        false, false;
        return node;
      },
      destroy: function destroy() {
        this.data && this.data.destroy();
        this._super();
      }
    });
    cc.Prefab = module.exports = Prefab;
    cc.js.obsolete(cc, "cc._Prefab", "Prefab");
  }), {
    "../platform/instantiate-jit": 156
  } ],
  67: [ (function(require, module, exports) {
    "use strict";
    var _gfx = _interopRequireDefault(require("../../renderer/gfx"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var renderer = require("../renderer");
    var Texture2D = require("./CCTexture2D");
    var DepthStencilFormat = cc.Enum({
      RB_FMT_D24S8: _gfx["default"].RB_FMT_D24S8,
      RB_FMT_S8: _gfx["default"].RB_FMT_S8,
      RB_FMT_D16: _gfx["default"].RB_FMT_D16
    });
    var RenderTexture = cc.Class({
      name: "cc.RenderTexture",
      extends: Texture2D,
      statics: {
        DepthStencilFormat: DepthStencilFormat
      },
      ctor: function ctor() {
        this._framebuffer = null;
      },
      initWithSize: function initWithSize(width, height, depthStencilFormat) {
        this.width = Math.floor(width || cc.visibleRect.width);
        this.height = Math.floor(height || cc.visibleRect.height);
        this._resetUnderlyingMipmaps();
        var opts = {
          colors: [ this._texture ]
        };
        this._depthStencilBuffer && this._depthStencilBuffer.destroy();
        var depthStencilBuffer;
        if (depthStencilFormat) {
          depthStencilBuffer = new _gfx["default"].RenderBuffer(renderer.device, depthStencilFormat, width, height);
          depthStencilFormat === _gfx["default"].RB_FMT_D24S8 ? opts.depthStencil = depthStencilBuffer : depthStencilFormat === _gfx["default"].RB_FMT_S8 ? opts.stencil = depthStencilBuffer : depthStencilFormat === _gfx["default"].RB_FMT_D16 && (opts.depth = depthStencilBuffer);
        }
        this._depthStencilBuffer = depthStencilBuffer;
        this._framebuffer && this._framebuffer.destroy();
        this._framebuffer = new _gfx["default"].FrameBuffer(renderer.device, width, height, opts);
        this._packable = false;
        this.loaded = true;
        this.emit("load");
      },
      updateSize: function updateSize(width, height) {
        this.width = Math.floor(width || cc.visibleRect.width);
        this.height = Math.floor(height || cc.visibleRect.height);
        this._resetUnderlyingMipmaps();
        var rbo = this._depthStencilBuffer;
        rbo && rbo.update(this.width, this.height);
        this._framebuffer._width = width;
        this._framebuffer._height = height;
      },
      drawTextureAt: function drawTextureAt(texture, x, y) {
        if (!texture._image || 0 === texture._image.width) return;
        this._texture.updateSubImage({
          x: x,
          y: y,
          image: texture._image,
          width: texture.width,
          height: texture.height,
          level: 0,
          flipY: false,
          premultiplyAlpha: texture._premultiplyAlpha
        });
      },
      readPixels: function readPixels(data, x, y, w, h) {
        if (!this._framebuffer || !this._texture) return data;
        x = x || 0;
        y = y || 0;
        var width = w || this.width;
        var height = h || this.height;
        data = data || new Uint8Array(width * height * 4);
        var gl = cc.game._renderContext;
        var oldFBO = gl.getParameter(gl.FRAMEBUFFER_BINDING);
        gl.bindFramebuffer(gl.FRAMEBUFFER, this._framebuffer.getHandle());
        gl.readPixels(x, y, width, height, gl.RGBA, gl.UNSIGNED_BYTE, data);
        gl.bindFramebuffer(gl.FRAMEBUFFER, oldFBO);
        return data;
      },
      destroy: function destroy() {
        this._super();
        if (this._framebuffer) {
          this._framebuffer.destroy();
          this._framebuffer = null;
        }
      }
    });
    cc.RenderTexture = module.exports = RenderTexture;
  }), {
    "../../renderer/gfx": 251,
    "../renderer": 168,
    "./CCTexture2D": 74
  } ],
  68: [ (function(require, module, exports) {
    "use strict";
    var Scene = cc.Class({
      name: "cc.SceneAsset",
      extends: cc.Asset,
      properties: {
        scene: null,
        asyncLoadAssets: void 0
      }
    });
    cc.SceneAsset = Scene;
    module.exports = Scene;
  }), {} ],
  69: [ (function(require, module, exports) {
    "use strict";
    var Script = cc.Class({
      name: "cc.Script",
      extends: cc.Asset
    });
    cc._Script = Script;
    var JavaScript = cc.Class({
      name: "cc.JavaScript",
      extends: Script
    });
    cc._JavaScript = JavaScript;
    var TypeScript = cc.Class({
      name: "cc.TypeScript",
      extends: Script
    });
    cc._TypeScript = TypeScript;
  }), {} ],
  70: [ (function(require, module, exports) {
    "use strict";
    var SpriteAtlas = cc.Class({
      name: "cc.SpriteAtlas",
      extends: cc.Asset,
      properties: {
        _spriteFrames: {
          default: {}
        }
      },
      getTexture: function getTexture() {
        var keys = Object.keys(this._spriteFrames);
        if (keys.length > 0) {
          var spriteFrame = this._spriteFrames[keys[0]];
          return spriteFrame ? spriteFrame.getTexture() : null;
        }
        return null;
      },
      getSpriteFrame: function getSpriteFrame(key) {
        var sf = this._spriteFrames[key];
        if (!sf) return null;
        sf.name || (sf.name = key);
        return sf;
      },
      getSpriteFrames: function getSpriteFrames() {
        var frames = [];
        var spriteFrames = this._spriteFrames;
        for (var key in spriteFrames) frames.push(this.getSpriteFrame(key));
        return frames;
      }
    });
    cc.SpriteAtlas = SpriteAtlas;
    module.exports = SpriteAtlas;
  }), {} ],
  71: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../event/event-target");
    var textureUtil = require("../utils/texture-util");
    var INSET_LEFT = 0;
    var INSET_TOP = 1;
    var INSET_RIGHT = 2;
    var INSET_BOTTOM = 3;
    var temp_uvs = [ {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    }, {
      u: 0,
      v: 0
    } ];
    var SpriteFrame = cc.Class({
      name: "cc.SpriteFrame",
      extends: require("../assets/CCAsset"),
      mixins: [ EventTarget ],
      properties: {
        _textureSetter: {
          set: function set(texture) {
            if (texture) {
              false;
              this._texture !== texture && this._refreshTexture(texture);
            }
          }
        },
        insetTop: {
          get: function get() {
            return this._capInsets[INSET_TOP];
          },
          set: function set(value) {
            this._capInsets[INSET_TOP] = value;
            this._texture && this._calculateSlicedUV();
          }
        },
        insetBottom: {
          get: function get() {
            return this._capInsets[INSET_BOTTOM];
          },
          set: function set(value) {
            this._capInsets[INSET_BOTTOM] = value;
            this._texture && this._calculateSlicedUV();
          }
        },
        insetLeft: {
          get: function get() {
            return this._capInsets[INSET_LEFT];
          },
          set: function set(value) {
            this._capInsets[INSET_LEFT] = value;
            this._texture && this._calculateSlicedUV();
          }
        },
        insetRight: {
          get: function get() {
            return this._capInsets[INSET_RIGHT];
          },
          set: function set(value) {
            this._capInsets[INSET_RIGHT] = value;
            this._texture && this._calculateSlicedUV();
          }
        }
      },
      statics: {
        _parseDepsFromJson: function _parseDepsFromJson(json) {
          return [ cc.assetManager.utils.decodeUuid(json.content.texture) ];
        }
      },
      ctor: function ctor() {
        EventTarget.call(this);
        var filename = arguments[0];
        var rect = arguments[1];
        var rotated = arguments[2];
        var offset = arguments[3];
        var originalSize = arguments[4];
        this._rect = null;
        this.uv = [];
        this._texture = null;
        this._original = null;
        this._offset = null;
        this._originalSize = null;
        this._rotated = false;
        this._flipX = false;
        this._flipY = false;
        this.vertices = null;
        this._capInsets = [ 0, 0, 0, 0 ];
        this.uvSliced = [];
        false;
        void 0 !== filename && this.setTexture(filename, rect, rotated, offset, originalSize);
      },
      textureLoaded: function textureLoaded() {
        return this._texture && this._texture.loaded;
      },
      onTextureLoaded: function onTextureLoaded(callback, target) {
        if (!this.textureLoaded()) {
          this.once("load", callback, target);
          this.ensureLoadTexture();
          return false;
        }
        callback.call(target);
        return true;
      },
      isRotated: function isRotated() {
        return this._rotated;
      },
      setRotated: function setRotated(bRotated) {
        this._rotated = bRotated;
        this._texture && this._calculateUV();
      },
      isFlipX: function isFlipX() {
        return this._flipX;
      },
      isFlipY: function isFlipY() {
        return this._flipY;
      },
      setFlipX: function setFlipX(flipX) {
        this._flipX = flipX;
        this._texture && this._calculateUV();
      },
      setFlipY: function setFlipY(flipY) {
        this._flipY = flipY;
        this._texture && this._calculateUV();
      },
      getRect: function getRect() {
        return cc.rect(this._rect);
      },
      setRect: function setRect(rect) {
        this._rect = rect;
        this._texture && this._calculateUV();
      },
      getOriginalSize: function getOriginalSize() {
        return cc.size(this._originalSize);
      },
      setOriginalSize: function setOriginalSize(size) {
        if (this._originalSize) {
          this._originalSize.width = size.width;
          this._originalSize.height = size.height;
        } else this._originalSize = cc.size(size);
      },
      getTexture: function getTexture() {
        return this._texture;
      },
      _textureLoadedCallback: function _textureLoadedCallback() {
        var self = this;
        var texture = this._texture;
        if (!texture) return;
        var w = texture.width, h = texture.height;
        self._rect ? self._checkRect(self._texture) : self._rect = cc.rect(0, 0, w, h);
        self._originalSize || self.setOriginalSize(cc.size(w, h));
        self._offset || self.setOffset(cc.v2(0, 0));
        self._calculateUV();
        self.emit("load");
      },
      _refreshTexture: function _refreshTexture(texture) {
        this._texture = texture;
        texture.loaded ? this._textureLoadedCallback() : texture.once("load", this._textureLoadedCallback, this);
      },
      getOffset: function getOffset() {
        return cc.v2(this._offset);
      },
      setOffset: function setOffset(offsets) {
        this._offset = cc.v2(offsets);
      },
      clone: function clone() {
        return new SpriteFrame(this._texture, this._rect, this._rotated, this._offset, this._originalSize);
      },
      setTexture: function setTexture(texture, rect, rotated, offset, originalSize) {
        this._rect = rect || null;
        offset ? this.setOffset(offset) : this._offset = null;
        originalSize ? this.setOriginalSize(originalSize) : this._originalSize = null;
        this._rotated = rotated || false;
        if ("string" === typeof texture) {
          cc.errorID(3401);
          return;
        }
        texture instanceof cc.Texture2D && this._texture !== texture && this._refreshTexture(texture);
        return true;
      },
      ensureLoadTexture: function ensureLoadTexture() {
        if (this._texture && !this._texture.loaded) {
          this._refreshTexture(this._texture);
          cc.assetManager.postLoadNative(this._texture);
        }
      },
      _checkRect: function _checkRect(texture) {
        var rect = this._rect;
        var maxX = rect.x, maxY = rect.y;
        if (this._rotated) {
          maxX += rect.height;
          maxY += rect.width;
        } else {
          maxX += rect.width;
          maxY += rect.height;
        }
        maxX > texture.width && cc.errorID(3300, texture.nativeUrl + "/" + this.name, maxX, texture.width);
        maxY > texture.height && cc.errorID(3400, texture.nativeUrl + "/" + this.name, maxY, texture.height);
      },
      _flipXY: function _flipXY(uvs) {
        if (this._flipX) {
          var tempVal = uvs[0];
          uvs[0] = uvs[1];
          uvs[1] = tempVal;
          tempVal = uvs[2];
          uvs[2] = uvs[3];
          uvs[3] = tempVal;
        }
        if (this._flipY) {
          var _tempVal = uvs[0];
          uvs[0] = uvs[2];
          uvs[2] = _tempVal;
          _tempVal = uvs[1];
          uvs[1] = uvs[3];
          uvs[3] = _tempVal;
        }
      },
      _calculateSlicedUV: function _calculateSlicedUV() {
        var rect = this._rect;
        var atlasWidth = this._texture.width;
        var atlasHeight = this._texture.height;
        var leftWidth = this._capInsets[INSET_LEFT];
        var rightWidth = this._capInsets[INSET_RIGHT];
        var centerWidth = rect.width - leftWidth - rightWidth;
        var topHeight = this._capInsets[INSET_TOP];
        var bottomHeight = this._capInsets[INSET_BOTTOM];
        var centerHeight = rect.height - topHeight - bottomHeight;
        var uvSliced = this.uvSliced;
        uvSliced.length = 0;
        if (this._rotated) {
          temp_uvs[0].u = rect.x / atlasWidth;
          temp_uvs[1].u = (rect.x + bottomHeight) / atlasWidth;
          temp_uvs[2].u = (rect.x + bottomHeight + centerHeight) / atlasWidth;
          temp_uvs[3].u = (rect.x + rect.height) / atlasWidth;
          temp_uvs[3].v = rect.y / atlasHeight;
          temp_uvs[2].v = (rect.y + leftWidth) / atlasHeight;
          temp_uvs[1].v = (rect.y + leftWidth + centerWidth) / atlasHeight;
          temp_uvs[0].v = (rect.y + rect.width) / atlasHeight;
          this._flipXY(temp_uvs);
          for (var row = 0; row < 4; ++row) {
            var rowD = temp_uvs[row];
            for (var col = 0; col < 4; ++col) {
              var colD = temp_uvs[3 - col];
              uvSliced.push({
                u: rowD.u,
                v: colD.v
              });
            }
          }
        } else {
          temp_uvs[0].u = rect.x / atlasWidth;
          temp_uvs[1].u = (rect.x + leftWidth) / atlasWidth;
          temp_uvs[2].u = (rect.x + leftWidth + centerWidth) / atlasWidth;
          temp_uvs[3].u = (rect.x + rect.width) / atlasWidth;
          temp_uvs[3].v = rect.y / atlasHeight;
          temp_uvs[2].v = (rect.y + topHeight) / atlasHeight;
          temp_uvs[1].v = (rect.y + topHeight + centerHeight) / atlasHeight;
          temp_uvs[0].v = (rect.y + rect.height) / atlasHeight;
          this._flipXY(temp_uvs);
          for (var _row = 0; _row < 4; ++_row) {
            var _rowD = temp_uvs[_row];
            for (var _col = 0; _col < 4; ++_col) {
              var _colD = temp_uvs[_col];
              uvSliced.push({
                u: _colD.u,
                v: _rowD.v
              });
            }
          }
        }
      },
      _setDynamicAtlasFrame: function _setDynamicAtlasFrame(frame) {
        if (!frame) return;
        this._original = {
          _texture: this._texture,
          _x: this._rect.x,
          _y: this._rect.y
        };
        this._texture = frame.texture;
        this._rect.x = frame.x;
        this._rect.y = frame.y;
        this._calculateUV();
      },
      _resetDynamicAtlasFrame: function _resetDynamicAtlasFrame() {
        if (!this._original) return;
        this._rect.x = this._original._x;
        this._rect.y = this._original._y;
        this._texture = this._original._texture;
        this._original = null;
        this._calculateUV();
      },
      _calculateUV: function _calculateUV() {
        var rect = this._rect, texture = this._texture, uv = this.uv, texw = texture.width, texh = texture.height;
        if (this._rotated) {
          var l = 0 === texw ? 0 : rect.x / texw;
          var r = 0 === texw ? 0 : (rect.x + rect.height) / texw;
          var b = 0 === texh ? 0 : (rect.y + rect.width) / texh;
          var t = 0 === texh ? 0 : rect.y / texh;
          uv[0] = l;
          uv[1] = t;
          uv[2] = l;
          uv[3] = b;
          uv[4] = r;
          uv[5] = t;
          uv[6] = r;
          uv[7] = b;
        } else {
          var _l = 0 === texw ? 0 : rect.x / texw;
          var _r = 0 === texw ? 0 : (rect.x + rect.width) / texw;
          var _b = 0 === texh ? 0 : (rect.y + rect.height) / texh;
          var _t = 0 === texh ? 0 : rect.y / texh;
          uv[0] = _l;
          uv[1] = _b;
          uv[2] = _r;
          uv[3] = _b;
          uv[4] = _l;
          uv[5] = _t;
          uv[6] = _r;
          uv[7] = _t;
        }
        if (this._flipX) {
          var tempVal = uv[0];
          uv[0] = uv[2];
          uv[2] = tempVal;
          tempVal = uv[1];
          uv[1] = uv[3];
          uv[3] = tempVal;
          tempVal = uv[4];
          uv[4] = uv[6];
          uv[6] = tempVal;
          tempVal = uv[5];
          uv[5] = uv[7];
          uv[7] = tempVal;
        }
        if (this._flipY) {
          var _tempVal2 = uv[0];
          uv[0] = uv[4];
          uv[4] = _tempVal2;
          _tempVal2 = uv[1];
          uv[1] = uv[5];
          uv[5] = _tempVal2;
          _tempVal2 = uv[2];
          uv[2] = uv[6];
          uv[6] = _tempVal2;
          _tempVal2 = uv[3];
          uv[3] = uv[7];
          uv[7] = _tempVal2;
        }
        var vertices = this.vertices;
        if (vertices) {
          vertices.nu.length = 0;
          vertices.nv.length = 0;
          for (var i = 0; i < vertices.u.length; i++) {
            vertices.nu[i] = vertices.u[i] / texw;
            vertices.nv[i] = vertices.v[i] / texh;
          }
        }
        this._calculateSlicedUV();
      },
      _serialize: false,
      _deserialize: function _deserialize(data, handle) {
        var rect = data.rect;
        rect && (this._rect = new cc.Rect(rect[0], rect[1], rect[2], rect[3]));
        data.offset && this.setOffset(new cc.Vec2(data.offset[0], data.offset[1]));
        data.originalSize && this.setOriginalSize(new cc.Size(data.originalSize[0], data.originalSize[1]));
        this._rotated = 1 === data.rotated;
        this._name = data.name;
        var capInsets = data.capInsets;
        if (capInsets) {
          this._capInsets[INSET_LEFT] = capInsets[INSET_LEFT];
          this._capInsets[INSET_TOP] = capInsets[INSET_TOP];
          this._capInsets[INSET_RIGHT] = capInsets[INSET_RIGHT];
          this._capInsets[INSET_BOTTOM] = capInsets[INSET_BOTTOM];
        }
        false;
        this.vertices = data.vertices;
        if (this.vertices) {
          this.vertices.nu = [];
          this.vertices.nv = [];
        }
        var textureUuid = data.texture;
        textureUuid && handle.result.push(this, "_textureSetter", textureUuid);
      }
    });
    var proto = SpriteFrame.prototype;
    proto.copyWithZone = proto.clone;
    proto.copy = proto.clone;
    proto.initWithTexture = proto.setTexture;
    cc.SpriteFrame = SpriteFrame;
    module.exports = SpriteFrame;
  }), {
    "../assets/CCAsset": 59,
    "../event/event-target": 121,
    "../utils/texture-util": 217
  } ],
  72: [ (function(require, module, exports) {
    "use strict";
    var Font = require("./CCFont");
    var TTFFont = cc.Class({
      name: "cc.TTFFont",
      extends: Font,
      properties: {
        _fontFamily: null,
        _nativeAsset: {
          type: cc.String,
          get: function get() {
            return this._fontFamily;
          },
          set: function set(value) {
            this._fontFamily = value || "Arial";
          },
          override: true
        },
        _nativeDep: {
          get: function get() {
            return {
              uuid: this._uuid,
              __nativeName__: this._native,
              ext: cc.path.extname(this._native),
              __isNative__: true
            };
          },
          override: true
        }
      },
      statics: {
        _parseDepsFromJson: function _parseDepsFromJson() {
          return [];
        },
        _parseNativeDepFromJson: function _parseNativeDepFromJson(json) {
          return {
            __nativeName__: json._native,
            ext: cc.path.extname(json._native),
            __isNative__: true
          };
        }
      }
    });
    cc.TTFFont = module.exports = TTFFont;
  }), {
    "./CCFont": 63
  } ],
  73: [ (function(require, module, exports) {
    "use strict";
    var TextAsset = cc.Class({
      name: "cc.TextAsset",
      extends: cc.Asset,
      properties: {
        text: ""
      },
      toString: function toString() {
        return this.text;
      }
    });
    module.exports = cc.TextAsset = TextAsset;
  }), {} ],
  74: [ (function(require, module, exports) {
    "use strict";
    var _gfx = _interopRequireDefault(require("../../renderer/gfx"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var EventTarget = require("../event/event-target");
    var renderer = require("../renderer");
    require("../platform/CCClass");
    var GL_NEAREST = 9728;
    var GL_LINEAR = 9729;
    var GL_REPEAT = 10497;
    var GL_CLAMP_TO_EDGE = 33071;
    var GL_MIRRORED_REPEAT = 33648;
    var GL_RGBA = 6408;
    var CHAR_CODE_0 = 48;
    var CHAR_CODE_1 = 49;
    var idGenerater = new (require("../platform/id-generater"))("Tex");
    var CUSTOM_PIXEL_FORMAT = 1024;
    var PixelFormat = cc.Enum({
      RGB565: _gfx["default"].TEXTURE_FMT_R5_G6_B5,
      RGB5A1: _gfx["default"].TEXTURE_FMT_R5_G5_B5_A1,
      RGBA4444: _gfx["default"].TEXTURE_FMT_R4_G4_B4_A4,
      RGB888: _gfx["default"].TEXTURE_FMT_RGB8,
      RGBA8888: _gfx["default"].TEXTURE_FMT_RGBA8,
      RGBA32F: _gfx["default"].TEXTURE_FMT_RGBA32F,
      A8: _gfx["default"].TEXTURE_FMT_A8,
      I8: _gfx["default"].TEXTURE_FMT_L8,
      AI8: _gfx["default"].TEXTURE_FMT_L8_A8,
      RGB_PVRTC_2BPPV1: _gfx["default"].TEXTURE_FMT_RGB_PVRTC_2BPPV1,
      RGBA_PVRTC_2BPPV1: _gfx["default"].TEXTURE_FMT_RGBA_PVRTC_2BPPV1,
      RGB_A_PVRTC_2BPPV1: CUSTOM_PIXEL_FORMAT++,
      RGB_PVRTC_4BPPV1: _gfx["default"].TEXTURE_FMT_RGB_PVRTC_4BPPV1,
      RGBA_PVRTC_4BPPV1: _gfx["default"].TEXTURE_FMT_RGBA_PVRTC_4BPPV1,
      RGB_A_PVRTC_4BPPV1: CUSTOM_PIXEL_FORMAT++,
      RGB_ETC1: _gfx["default"].TEXTURE_FMT_RGB_ETC1,
      RGBA_ETC1: CUSTOM_PIXEL_FORMAT++,
      RGB_ETC2: _gfx["default"].TEXTURE_FMT_RGB_ETC2,
      RGBA_ETC2: _gfx["default"].TEXTURE_FMT_RGBA_ETC2
    });
    var WrapMode = cc.Enum({
      REPEAT: GL_REPEAT,
      CLAMP_TO_EDGE: GL_CLAMP_TO_EDGE,
      MIRRORED_REPEAT: GL_MIRRORED_REPEAT
    });
    var Filter = cc.Enum({
      LINEAR: GL_LINEAR,
      NEAREST: GL_NEAREST
    });
    var FilterIndex = {
      9728: 0,
      9729: 1
    };
    var _images = [];
    var _sharedOpts = {
      width: void 0,
      height: void 0,
      minFilter: void 0,
      magFilter: void 0,
      wrapS: void 0,
      wrapT: void 0,
      format: void 0,
      genMipmaps: void 0,
      images: void 0,
      image: void 0,
      flipY: void 0,
      premultiplyAlpha: void 0
    };
    function _getSharedOptions() {
      for (var key in _sharedOpts) _sharedOpts[key] = void 0;
      _images.length = 0;
      _sharedOpts.images = _images;
      return _sharedOpts;
    }
    var Texture2D = cc.Class({
      name: "cc.Texture2D",
      extends: require("../assets/CCAsset"),
      mixins: [ EventTarget ],
      properties: {
        _nativeAsset: {
          get: function get() {
            return this._image;
          },
          set: function set(data) {
            data._data ? this.initWithData(data._data, this._format, data.width, data.height) : this.initWithElement(data);
          },
          override: true
        },
        _format: PixelFormat.RGBA8888,
        _premultiplyAlpha: false,
        _flipY: false,
        _minFilter: Filter.LINEAR,
        _magFilter: Filter.LINEAR,
        _mipFilter: Filter.LINEAR,
        _wrapS: WrapMode.CLAMP_TO_EDGE,
        _wrapT: WrapMode.CLAMP_TO_EDGE,
        _isAlphaAtlas: false,
        _genMipmaps: false,
        genMipmaps: {
          get: function get() {
            return this._genMipmaps;
          },
          set: function set(genMipmaps) {
            if (this._genMipmaps !== genMipmaps) {
              var opts = _getSharedOptions();
              opts.genMipmaps = genMipmaps;
              this.update(opts);
            }
          }
        },
        _packable: true,
        packable: {
          get: function get() {
            return this._packable;
          },
          set: function set(val) {
            this._packable = val;
          }
        },
        _nativeDep: {
          get: function get() {
            return {
              __isNative__: true,
              uuid: this._uuid,
              ext: this._native,
              __flipY__: this._flipY,
              __premultiplyAlpha__: this._premultiplyAlpha
            };
          },
          override: true
        }
      },
      statics: {
        PixelFormat: PixelFormat,
        WrapMode: WrapMode,
        Filter: Filter,
        _FilterIndex: FilterIndex,
        extnames: [ ".png", ".jpg", ".jpeg", ".bmp", ".webp", ".pvr", ".pkm" ],
        _parseNativeDepFromJson: function _parseNativeDepFromJson(json) {
          var data = json.content;
          var fields = data.split(",");
          var extIdStr = fields[0];
          var ext = "";
          if (extIdStr) {
            var result = Texture2D._parseExt(extIdStr, PixelFormat.RGBA8888);
            ext = result.bestExt || result.defaultExt;
          }
          return {
            __isNative__: true,
            ext: ext,
            __flipY__: false,
            __premultiplyAlpha__: fields[5] && fields[5].charCodeAt(0) === CHAR_CODE_1
          };
        },
        _parseExt: function _parseExt(extIdStr, defaultFormat) {
          var device = cc.renderer.device;
          var extIds = extIdStr.split("_");
          var defaultExt = "";
          var bestExt = "";
          var bestIndex = 999;
          var bestFormat = defaultFormat;
          var SupportTextureFormats = cc.macro.SUPPORT_TEXTURE_FORMATS;
          for (var i = 0; i < extIds.length; i++) {
            var extFormat = extIds[i].split("@");
            var tmpExt = extFormat[0];
            tmpExt = Texture2D.extnames[tmpExt.charCodeAt(0) - CHAR_CODE_0] || tmpExt;
            var index = SupportTextureFormats.indexOf(tmpExt);
            if (-1 !== index && index < bestIndex) {
              var tmpFormat = extFormat[1] ? parseInt(extFormat[1]) : defaultFormat;
              if (".pvr" === tmpExt && !device.ext("WEBGL_compressed_texture_pvrtc")) continue;
              if (!(tmpFormat !== PixelFormat.RGB_ETC1 && tmpFormat !== PixelFormat.RGBA_ETC1 || device.ext("WEBGL_compressed_texture_etc1"))) continue;
              if (!(tmpFormat !== PixelFormat.RGB_ETC2 && tmpFormat !== PixelFormat.RGBA_ETC2 || device.ext("WEBGL_compressed_texture_etc"))) continue;
              if (".webp" === tmpExt && !cc.sys.capabilities.webp) continue;
              bestIndex = index;
              bestExt = tmpExt;
              bestFormat = tmpFormat;
            } else defaultExt || (defaultExt = tmpExt);
          }
          return {
            bestExt: bestExt,
            bestFormat: bestFormat,
            defaultExt: defaultExt
          };
        },
        _parseDepsFromJson: function _parseDepsFromJson() {
          return [];
        }
      },
      ctor: function ctor() {
        this._id = idGenerater.getNewId();
        this.loaded = false;
        this.width = 0;
        this.height = 0;
        this._hashDirty = true;
        this._hash = 0;
        this._texture = null;
        false;
      },
      getImpl: function getImpl() {
        return this._texture;
      },
      getId: function getId() {
        return this._id;
      },
      toString: function toString() {
        return this.nativeUrl || "";
      },
      update: function update(options) {
        if (options) {
          var updateImg = false;
          void 0 !== options.width && (this.width = options.width);
          void 0 !== options.height && (this.height = options.height);
          if (void 0 !== options.minFilter) {
            this._minFilter = options.minFilter;
            options.minFilter = FilterIndex[options.minFilter];
          }
          if (void 0 !== options.magFilter) {
            this._magFilter = options.magFilter;
            options.magFilter = FilterIndex[options.magFilter];
          }
          if (void 0 !== options.mipFilter) {
            this._mipFilter = options.mipFilter;
            options.mipFilter = FilterIndex[options.mipFilter];
          }
          void 0 !== options.wrapS && (this._wrapS = options.wrapS);
          void 0 !== options.wrapT && (this._wrapT = options.wrapT);
          void 0 !== options.format && (this._format = options.format);
          if (void 0 !== options.flipY) {
            this._flipY = options.flipY;
            updateImg = true;
          }
          if (void 0 !== options.premultiplyAlpha) {
            this._premultiplyAlpha = options.premultiplyAlpha;
            updateImg = true;
          }
          void 0 !== options.genMipmaps && (this._genMipmaps = options.genMipmaps);
          cc.sys.capabilities.imageBitmap && this._image instanceof ImageBitmap ? this._checkImageBitmap(this._upload.bind(this, options, updateImg)) : this._upload(options, updateImg);
        }
      },
      _upload: function _upload(options, updateImg) {
        updateImg && this._image && (options.image = this._image);
        if (options.images && options.images.length > 0) this._image = options.images[0]; else if (void 0 !== options.image) {
          this._image = options.image;
          if (!options.images) {
            _images.length = 0;
            options.images = _images;
          }
          options.images.push(options.image);
        }
        this._texture && this._texture.update(options);
        this._hashDirty = true;
      },
      initWithElement: function initWithElement(element) {
        if (!element) return;
        this._image = element;
        if (element.complete || element instanceof HTMLCanvasElement) this.handleLoadedTexture(); else if (cc.sys.capabilities.imageBitmap && element instanceof ImageBitmap) this._checkImageBitmap(this.handleLoadedTexture.bind(this)); else {
          var self = this;
          element.addEventListener("load", (function() {
            self.handleLoadedTexture();
          }));
          element.addEventListener("error", (function(err) {
            cc.warnID(3119, err.message);
          }));
        }
      },
      initWithData: function initWithData(data, pixelFormat, pixelsWidth, pixelsHeight) {
        var opts = _getSharedOptions();
        opts.image = data;
        opts.images = [ opts.image ];
        opts.genMipmaps = this._genMipmaps;
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        opts.format = this._getGFXPixelFormat(pixelFormat);
        opts.width = pixelsWidth;
        opts.height = pixelsHeight;
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
        this.width = pixelsWidth;
        this.height = pixelsHeight;
        this._updateFormat();
        this._checkPackable();
        this.loaded = true;
        this.emit("load");
        return true;
      },
      getHtmlElementObj: function getHtmlElementObj() {
        return this._image;
      },
      destroy: function destroy() {
        cc.sys.capabilities.imageBitmap && this._image instanceof ImageBitmap && this._image.close && this._image.close();
        this._packable && cc.dynamicAtlasManager && cc.dynamicAtlasManager.deleteAtlasTexture(this);
        this._image = null;
        this._texture && this._texture.destroy();
        this._super();
      },
      getPixelFormat: function getPixelFormat() {
        return this._format;
      },
      hasPremultipliedAlpha: function hasPremultipliedAlpha() {
        return this._premultiplyAlpha || false;
      },
      isAlphaAtlas: function isAlphaAtlas() {
        return this._isAlphaAtlas;
      },
      handleLoadedTexture: function handleLoadedTexture() {
        if (!this._image || !this._image.width || !this._image.height) return;
        this.width = this._image.width;
        this.height = this._image.height;
        var opts = _getSharedOptions();
        opts.image = this._image;
        opts.images = [ opts.image ];
        opts.width = this.width;
        opts.height = this.height;
        opts.genMipmaps = this._genMipmaps;
        opts.format = this._getGFXPixelFormat(this._format);
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
        this._updateFormat();
        this._checkPackable();
        this.loaded = true;
        this.emit("load");
        cc.macro.CLEANUP_IMAGE_CACHE && (this._image instanceof HTMLImageElement ? this._clearImage() : cc.sys.capabilities.imageBitmap && this._image instanceof ImageBitmap && this._image.close && this._image.close());
      },
      description: function description() {
        return "<cc.Texture2D | Name = " + this.nativeUrl + " | Dimensions = " + this.width + " x " + this.height + ">";
      },
      releaseTexture: function releaseTexture() {
        this._image = null;
        this._texture && this._texture.destroy();
      },
      setWrapMode: function setWrapMode(wrapS, wrapT) {
        if (this._wrapS !== wrapS || this._wrapT !== wrapT) {
          var opts = _getSharedOptions();
          opts.wrapS = wrapS;
          opts.wrapT = wrapT;
          this.update(opts);
        }
      },
      setFilters: function setFilters(minFilter, magFilter) {
        if (this._minFilter !== minFilter || this._magFilter !== magFilter) {
          var opts = _getSharedOptions();
          opts.minFilter = minFilter;
          opts.magFilter = magFilter;
          this.update(opts);
        }
      },
      setFlipY: function setFlipY(flipY) {
        if (this._flipY !== flipY) {
          var opts = _getSharedOptions();
          opts.flipY = flipY;
          opts.premultiplyAlpha = this._premultiplyAlpha;
          this.update(opts);
        }
      },
      setPremultiplyAlpha: function setPremultiplyAlpha(premultiply) {
        if (this._premultiplyAlpha !== premultiply) {
          var opts = _getSharedOptions();
          opts.flipY = this._flipY;
          opts.premultiplyAlpha = premultiply;
          this.update(opts);
        }
      },
      _updateFormat: function _updateFormat() {
        this._isAlphaAtlas = this._format === PixelFormat.RGBA_ETC1 || this._format === PixelFormat.RGB_A_PVRTC_4BPPV1 || this._format === PixelFormat.RGB_A_PVRTC_2BPPV1;
        false;
      },
      _checkPackable: function _checkPackable() {
        var dynamicAtlas = cc.dynamicAtlasManager;
        if (!dynamicAtlas) return;
        if (this._isCompressed()) {
          this._packable = false;
          return;
        }
        var w = this.width, h = this.height;
        if (!this._image || w > dynamicAtlas.maxFrameSize || h > dynamicAtlas.maxFrameSize || this._getHash() !== dynamicAtlas.Atlas.DEFAULT_HASH) {
          this._packable = false;
          return;
        }
        this._image && this._image instanceof HTMLCanvasElement && (this._packable = true);
      },
      _getOpts: function _getOpts() {
        var opts = _getSharedOptions();
        opts.width = this.width;
        opts.height = this.height;
        opts.genMipmaps = this._genMipmaps;
        opts.format = this._format;
        opts.premultiplyAlpha = this._premultiplyAlpha;
        opts.anisotropy = this._anisotropy;
        opts.flipY = this._flipY;
        opts.minFilter = FilterIndex[this._minFilter];
        opts.magFilter = FilterIndex[this._magFilter];
        opts.mipFilter = FilterIndex[this._mipFilter];
        opts.wrapS = this._wrapS;
        opts.wrapT = this._wrapT;
        return opts;
      },
      _getGFXPixelFormat: function _getGFXPixelFormat(format) {
        format === PixelFormat.RGBA_ETC1 ? format = PixelFormat.RGB_ETC1 : format === PixelFormat.RGB_A_PVRTC_4BPPV1 ? format = PixelFormat.RGB_PVRTC_4BPPV1 : format === PixelFormat.RGB_A_PVRTC_2BPPV1 && (format = PixelFormat.RGB_PVRTC_2BPPV1);
        return format;
      },
      _resetUnderlyingMipmaps: function _resetUnderlyingMipmaps(mipmapSources) {
        var opts = this._getOpts();
        opts.images = mipmapSources || [ null ];
        this._texture ? this._texture.update(opts) : this._texture = new renderer.Texture2D(renderer.device, opts);
      },
      _serialize: (false, false) && function() {
        var extId = "";
        var exportedExts = this._exportedExts;
        !exportedExts && this._native && (exportedExts = [ this._native ]);
        if (exportedExts) {
          var exts = [];
          for (var i = 0; i < exportedExts.length; i++) {
            var _extId = "";
            var ext = exportedExts[i];
            if (ext) {
              var extFormat = ext.split("@");
              _extId = Texture2D.extnames.indexOf(extFormat[0]);
              _extId < 0 && (_extId = ext);
              extFormat[1] && (_extId += "@" + extFormat[1]);
            }
            exts.push(_extId);
          }
          extId = exts.join("_");
        }
        var asset = extId + "," + this._minFilter + "," + this._magFilter + "," + this._wrapS + "," + this._wrapT + "," + (this._premultiplyAlpha ? 1 : 0) + "," + (this._genMipmaps ? 1 : 0) + "," + (this._packable ? 1 : 0);
        return asset;
      },
      _deserialize: function _deserialize(data, handle) {
        var fields = data.split(",");
        var extIdStr = fields[0];
        if (extIdStr) {
          var result = Texture2D._parseExt(extIdStr, this._format);
          if (result.bestExt) {
            this._setRawAsset(result.bestExt);
            this._format = result.bestFormat;
          } else {
            this._setRawAsset(result.defaultExt);
            cc.warnID(3120, handle.customEnv.url, result.defaultExt, result.defaultExt);
          }
        }
        if (8 === fields.length) {
          this._minFilter = parseInt(fields[1]);
          this._magFilter = parseInt(fields[2]);
          this._wrapS = parseInt(fields[3]);
          this._wrapT = parseInt(fields[4]);
          this._premultiplyAlpha = fields[5].charCodeAt(0) === CHAR_CODE_1;
          this._genMipmaps = fields[6].charCodeAt(0) === CHAR_CODE_1;
          this._packable = fields[7].charCodeAt(0) === CHAR_CODE_1;
        }
      },
      _getHash: function _getHash() {
        if (!this._hashDirty) return this._hash;
        var genMipmaps = this._genMipmaps ? 1 : 0;
        var premultiplyAlpha = this._premultiplyAlpha ? 1 : 0;
        var flipY = this._flipY ? 1 : 0;
        var minFilter = this._minFilter === Filter.LINEAR ? 1 : 2;
        var magFilter = this._magFilter === Filter.LINEAR ? 1 : 2;
        var wrapS = this._wrapS === WrapMode.REPEAT ? 1 : this._wrapS === WrapMode.CLAMP_TO_EDGE ? 2 : 3;
        var wrapT = this._wrapT === WrapMode.REPEAT ? 1 : this._wrapT === WrapMode.CLAMP_TO_EDGE ? 2 : 3;
        var pixelFormat = this._format;
        var image = this._image;
        false;
        this._hash = Number("" + minFilter + magFilter + pixelFormat + wrapS + wrapT + genMipmaps + premultiplyAlpha + flipY);
        this._hashDirty = false;
        return this._hash;
      },
      _isCompressed: function _isCompressed() {
        return this._format < PixelFormat.A8 || this._format > PixelFormat.RGBA32F;
      },
      _clearImage: function _clearImage() {
        this._image.src = "";
      },
      _checkImageBitmap: function _checkImageBitmap(cb) {
        var _this = this;
        var image = this._image;
        var flipY = this._flipY;
        var premultiplyAlpha = this._premultiplyAlpha;
        this._flipY !== image.flipY || this._premultiplyAlpha !== image.premultiplyAlpha ? createImageBitmap(image, {
          imageOrientation: flipY !== image.flipY ? "flipY" : "none",
          premultiplyAlpha: premultiplyAlpha ? "premultiply" : "none"
        }).then((function(result) {
          image.close && image.close();
          result.flipY = flipY;
          result.premultiplyAlpha = premultiplyAlpha;
          _this._image = result;
          cb();
        }), (function(err) {
          cc.error(err.message);
        })) : cb();
      }
    });
    cc.Texture2D = module.exports = Texture2D;
  }), {
    "../../renderer/gfx": 251,
    "../assets/CCAsset": 59,
    "../event/event-target": 121,
    "../platform/CCClass": 138,
    "../platform/id-generater": 154,
    "../renderer": 168
  } ],
  75: [ (function(require, module, exports) {
    "use strict";
    require("./CCAsset");
    require("./CCFont");
    require("./CCPrefab");
    require("./CCAudioClip");
    require("./CCScripts");
    require("./CCSceneAsset");
    require("./CCSpriteFrame");
    require("./CCTexture2D");
    require("./CCRenderTexture");
    require("./CCTTFFont");
    require("./CCSpriteAtlas");
    require("./CCBitmapFont");
    require("./CCLabelAtlas");
    require("./CCTextAsset");
    require("./CCJsonAsset");
    require("./CCBufferAsset");
    require("./material");
  }), {
    "./CCAsset": 59,
    "./CCAudioClip": 60,
    "./CCBitmapFont": 61,
    "./CCBufferAsset": 62,
    "./CCFont": 63,
    "./CCJsonAsset": 64,
    "./CCLabelAtlas": 65,
    "./CCPrefab": 66,
    "./CCRenderTexture": 67,
    "./CCSceneAsset": 68,
    "./CCScripts": 69,
    "./CCSpriteAtlas": 70,
    "./CCSpriteFrame": 71,
    "./CCTTFFont": 72,
    "./CCTextAsset": 73,
    "./CCTexture2D": 74,
    "./material": 82
  } ],
  76: [ (function(require, module, exports) {
    "use strict";
    var _CCAsset = _interopRequireDefault(require("../CCAsset"));
    var _effectParser = require("./effect-parser");
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var EffectAsset = cc.Class({
      name: "cc.EffectAsset",
      extends: _CCAsset["default"],
      ctor: function ctor() {
        this._effect = null;
      },
      properties: {
        properties: Object,
        techniques: [],
        shaders: []
      },
      onLoad: function onLoad() {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;
        var lib = cc.renderer._forward._programLib;
        for (var i = 0; i < this.shaders.length; i++) lib.define(this.shaders[i]);
        this._initEffect();
      },
      _initEffect: function _initEffect() {
        if (this._effect) return;
        this._effect = (0, _effectParser.parseEffect)(this);
        Object.freeze(this._effect);
      },
      getInstantiatedEffect: function getInstantiatedEffect() {
        this._initEffect();
        return this._effect.clone();
      },
      getEffect: function getEffect() {
        this._initEffect();
        return this._effect;
      }
    });
    module.exports = cc.EffectAsset = EffectAsset;
  }), {
    "../CCAsset": 59,
    "./effect-parser": 79
  } ],
  77: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var Asset = require("../CCAsset");
    var Texture = require("../CCTexture2D");
    var PixelFormat = Texture.PixelFormat;
    var EffectAsset = require("./CCEffectAsset");
    var textureUtil = require("../../utils/texture-util");
    var gfx = cc.gfx;
    var BUILTIN_NAME = cc.Enum({
      SPRITE: "2d-sprite",
      GRAY_SPRITE: "2d-gray-sprite",
      UNLIT: "unlit"
    });
    var Material = cc.Class({
      name: "cc.Material",
      extends: Asset,
      ctor: function ctor() {
        this.loaded = false;
        this._manualHash = false;
        this._dirty = true;
        this._effect = null;
      },
      properties: {
        _defines: {
          default: void 0,
          type: Object
        },
        _props: {
          default: void 0,
          type: Object
        },
        _effectAsset: {
          type: EffectAsset,
          default: null
        },
        _techniqueIndex: 0,
        _techniqueData: Object,
        effectName: void 0,
        effectAsset: {
          get: function get() {
            return this._effectAsset;
          },
          set: function set(asset) {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;
            this._effectAsset = asset;
            if (!asset) {
              cc.error("Can not set an empty effect asset.");
              return;
            }
            this._effect = this._effectAsset.getInstantiatedEffect();
          }
        },
        effect: {
          get: function get() {
            return this._effect;
          }
        },
        techniqueIndex: {
          get: function get() {
            return this._techniqueIndex;
          },
          set: function set(v) {
            this._techniqueIndex = v;
            this._effect.switchTechnique(v);
          }
        }
      },
      statics: {
        getBuiltinMaterial: function getBuiltinMaterial(name) {
          if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return new cc.Material();
          return cc.assetManager.builtins.getBuiltin("material", "builtin-" + name);
        },
        BUILTIN_NAME: BUILTIN_NAME,
        createWithBuiltin: function createWithBuiltin(effectName, techniqueIndex) {
          void 0 === techniqueIndex && (techniqueIndex = 0);
          var effectAsset = cc.assetManager.builtins.getBuiltin("effect", "builtin-" + effectName);
          return Material.create(effectAsset, techniqueIndex);
        },
        create: function create(effectAsset, techniqueIndex) {
          void 0 === techniqueIndex && (techniqueIndex = 0);
          if (!effectAsset) return null;
          var material = new Material();
          material.effectAsset = effectAsset;
          material.techniqueIndex = techniqueIndex;
          return material;
        }
      },
      setProperty: function setProperty(name, val, passIdx, directly) {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;
        "string" === typeof passIdx && (passIdx = parseInt(passIdx));
        if (val instanceof Texture) {
          var loaded = function loaded() {
            this._effect.setProperty(name, val, passIdx);
          };
          var isAlphaAtlas = val.isAlphaAtlas();
          var key = "CC_USE_ALPHA_ATLAS_" + name;
          var def = this.getDefine(key, passIdx);
          (isAlphaAtlas || def) && this.define(key, isAlphaAtlas);
          if (!val.loaded) {
            val.once("load", loaded, this);
            cc.assetManager.postLoadNative(val);
            return;
          }
        }
        this._effect.setProperty(name, val, passIdx, directly);
      },
      getProperty: function getProperty(name, passIdx) {
        "string" === typeof passIdx && (passIdx = parseInt(passIdx));
        return this._effect.getProperty(name, passIdx);
      },
      define: function define(name, val, passIdx, force) {
        if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) return;
        "string" === typeof passIdx && (passIdx = parseInt(passIdx));
        this._effect.define(name, val, passIdx, force);
      },
      getDefine: function getDefine(name, passIdx) {
        "string" === typeof passIdx && (passIdx = parseInt(passIdx));
        return this._effect.getDefine(name, passIdx);
      },
      setCullMode: function setCullMode(cullMode, passIdx) {
        void 0 === cullMode && (cullMode = gfx.CULL_BACK);
        this._effect.setCullMode(cullMode, passIdx);
      },
      setDepth: function setDepth(depthTest, depthWrite, depthFunc, passIdx) {
        void 0 === depthTest && (depthTest = false);
        void 0 === depthWrite && (depthWrite = false);
        void 0 === depthFunc && (depthFunc = gfx.DS_FUNC_LESS);
        this._effect.setDepth(depthTest, depthWrite, depthFunc, passIdx);
      },
      setBlend: function setBlend(enabled, blendEq, blendSrc, blendDst, blendAlphaEq, blendSrcAlpha, blendDstAlpha, blendColor, passIdx) {
        void 0 === enabled && (enabled = false);
        void 0 === blendEq && (blendEq = gfx.BLEND_FUNC_ADD);
        void 0 === blendSrc && (blendSrc = gfx.BLEND_SRC_ALPHA);
        void 0 === blendDst && (blendDst = gfx.BLEND_ONE_MINUS_SRC_ALPHA);
        void 0 === blendAlphaEq && (blendAlphaEq = gfx.BLEND_FUNC_ADD);
        void 0 === blendSrcAlpha && (blendSrcAlpha = gfx.BLEND_SRC_ALPHA);
        void 0 === blendDstAlpha && (blendDstAlpha = gfx.BLEND_ONE_MINUS_SRC_ALPHA);
        void 0 === blendColor && (blendColor = 4294967295);
        this._effect.setBlend(enabled, blendEq, blendSrc, blendDst, blendAlphaEq, blendSrcAlpha, blendDstAlpha, blendColor, passIdx);
      },
      setStencilEnabled: function setStencilEnabled(stencilTest, passIdx) {
        void 0 === stencilTest && (stencilTest = gfx.STENCIL_INHERIT);
        this._effect.setStencilEnabled(stencilTest, passIdx);
      },
      setStencil: function setStencil(stencilTest, stencilFunc, stencilRef, stencilMask, stencilFailOp, stencilZFailOp, stencilZPassOp, stencilWriteMask, passIdx) {
        void 0 === stencilTest && (stencilTest = gfx.STENCIL_INHERIT);
        void 0 === stencilFunc && (stencilFunc = gfx.DS_FUNC_ALWAYS);
        void 0 === stencilRef && (stencilRef = 0);
        void 0 === stencilMask && (stencilMask = 255);
        void 0 === stencilFailOp && (stencilFailOp = gfx.STENCIL_OP_KEEP);
        void 0 === stencilZFailOp && (stencilZFailOp = gfx.STENCIL_OP_KEEP);
        void 0 === stencilZPassOp && (stencilZPassOp = gfx.STENCIL_OP_KEEP);
        void 0 === stencilWriteMask && (stencilWriteMask = 255);
        this._effect.setStencil(stencilTest, stencilFunc, stencilRef, stencilMask, stencilFailOp, stencilZFailOp, stencilZPassOp, stencilWriteMask, passIdx);
      },
      updateHash: function updateHash(hash) {
        this._manualHash = hash;
        this._effect && this._effect.updateHash(hash);
      },
      getHash: function getHash() {
        return this._manualHash || this._effect && this._effect.getHash();
      },
      onLoad: function onLoad() {
        this.effectAsset = this._effectAsset;
        if (!this._effect) return;
        this._techniqueIndex && this._effect.switchTechnique(this._techniqueIndex);
        this._techniqueData = this._techniqueData || {};
        var passDatas = this._techniqueData;
        for (var index in passDatas) {
          index = parseInt(index);
          var passData = passDatas[index];
          if (!passData) continue;
          for (var def in passData.defines) this.define(def, passData.defines[def], index);
          for (var prop in passData.props) this.setProperty(prop, passData.props[prop], index);
        }
      }
    });
    var _default = Material;
    exports["default"] = _default;
    cc.Material = Material;
    module.exports = exports["default"];
  }), {
    "../../utils/texture-util": 217,
    "../CCAsset": 59,
    "../CCTexture2D": 74,
    "./CCEffectAsset": 76
  } ],
  78: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _pass = _interopRequireDefault(require("../../../renderer/core/pass"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        "value" in descriptor && (descriptor.writable = true);
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      protoProps && _defineProperties(Constructor.prototype, protoProps);
      staticProps && _defineProperties(Constructor, staticProps);
      return Constructor;
    }
    var gfx = cc.gfx;
    var EffectBase = (function() {
      function EffectBase() {
        this._dirty = true;
        this._name = "";
        this._technique = null;
      }
      var _proto = EffectBase.prototype;
      _proto._createPassProp = function _createPassProp(name, pass) {
        var prop = pass._properties[name];
        if (!prop) return;
        var uniform = Object.create(null);
        uniform.name = name;
        uniform.type = prop.type;
        prop.value instanceof Float32Array ? uniform.value = new Float32Array(prop.value) : uniform.value = prop.value;
        pass._properties[name] = uniform;
        return uniform;
      };
      _proto._setPassProperty = function _setPassProperty(name, value, pass, directly) {
        var properties = pass._properties;
        var uniform = properties.hasOwnProperty(name);
        if (uniform) {
          if (uniform.value === value) return;
        } else uniform = this._createPassProp(name, pass);
        this._dirty = true;
        return _pass["default"].prototype.setProperty.call(pass, name, value, directly);
      };
      _proto.setProperty = function setProperty(name, value, passIdx, directly) {
        var success = false;
        var passes = this.passes;
        var start = 0, end = passes.length;
        void 0 !== passIdx && (start = passIdx, end = passIdx + 1);
        for (var i = start; i < end; i++) this._setPassProperty(name, value, passes[i], directly) && (success = true);
        success || cc.warnID(9103, this.name, name);
      };
      _proto.getProperty = function getProperty(name, passIdx) {
        var passes = this.passes;
        if (passIdx >= passes.length) return;
        var start = 0, end = passes.length;
        void 0 !== passIdx && (start = passIdx, end = passIdx + 1);
        for (var i = start; i < end; i++) {
          var value = passes[i].getProperty(name);
          if (void 0 !== value) return value;
        }
      };
      _proto.define = function define(name, value, passIdx, force) {
        var success = false;
        var passes = this.passes;
        var start = 0, end = passes.length;
        void 0 !== passIdx && (start = passIdx, end = passIdx + 1);
        for (var i = start; i < end; i++) passes[i].define(name, value, force) && (success = true);
        success || cc.warnID(9104, this.name, name);
      };
      _proto.getDefine = function getDefine(name, passIdx) {
        var passes = this.passes;
        if (passIdx >= passes.length) return;
        var start = 0, end = passes.length;
        void 0 !== passIdx && (start = passIdx, end = passIdx + 1);
        for (var i = start; i < end; i++) {
          var value = passes[i].getDefine(name);
          if (void 0 !== value) return value;
        }
      };
      _proto.setCullMode = function setCullMode(cullMode, passIdx) {
        void 0 === cullMode && (cullMode = gfx.CULL_BACK);
        var passes = this.passes;
        var start = 0, end = passes.length;
        void 0 !== passIdx && (start = passIdx, end = passIdx + 1);
        for (var i = start; i < end; i++) passes[i].setCullMode(cullMode);
        this._dirty = true;
      };
      _proto.setDepth = function setDepth(depthTest, depthWrite, depthFunc, passIdx) {
        var passes = this.passes;
        var start = 0, end = passes.length;
        void 0 !== passIdx && (start = passIdx, end = passIdx + 1);
        for (var i = start; i < end; i++) passes[i].setDepth(depthTest, depthWrite, depthFunc);
        this._dirty = true;
      };
      _proto.setBlend = function setBlend(enabled, blendEq, blendSrc, blendDst, blendAlphaEq, blendSrcAlpha, blendDstAlpha, blendColor, passIdx) {
        var passes = this.passes;
        var start = 0, end = passes.length;
        void 0 !== passIdx && (start = passIdx, end = passIdx + 1);
        for (var i = start; i < end; i++) passes[i].setBlend(enabled, blendEq, blendSrc, blendDst, blendAlphaEq, blendSrcAlpha, blendDstAlpha, blendColor);
        this._dirty = true;
      };
      _proto.setStencilEnabled = function setStencilEnabled(stencilTest, passIdx) {
        void 0 === stencilTest && (stencilTest = gfx.STENCIL_INHERIT);
        var passes = this.passes;
        var start = 0, end = passes.length;
        void 0 !== passIdx && (start = passIdx, end = passIdx + 1);
        for (var i = start; i < end; i++) passes[i].setStencilEnabled(stencilTest);
        this._dirty = true;
      };
      _proto.setStencil = function setStencil(enabled, stencilFunc, stencilRef, stencilMask, stencilFailOp, stencilZFailOp, stencilZPassOp, stencilWriteMask, passIdx) {
        var passes = this.passes;
        var start = 0, end = passes.length;
        void 0 !== passIdx && (start = passIdx, end = passIdx + 1);
        for (var i = start; i < end; i++) {
          var pass = passes[i];
          pass.setStencilFront(enabled, stencilFunc, stencilRef, stencilMask, stencilFailOp, stencilZFailOp, stencilZPassOp, stencilWriteMask);
          pass.setStencilBack(enabled, stencilFunc, stencilRef, stencilMask, stencilFailOp, stencilZFailOp, stencilZPassOp, stencilWriteMask);
        }
        this._dirty = true;
      };
      _createClass(EffectBase, [ {
        key: "name",
        get: function get() {
          return this._name;
        }
      }, {
        key: "technique",
        get: function get() {
          return this._technique;
        }
      }, {
        key: "passes",
        get: function get() {
          return [];
        }
      } ]);
      return EffectBase;
    })();
    exports["default"] = EffectBase;
    cc.EffectBase = EffectBase;
    module.exports = exports["default"];
  }), {
    "../../../renderer/core/pass": 242
  } ],
  79: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.parseEffect = parseEffect;
    var _pass = _interopRequireDefault(require("../../../renderer/core/pass"));
    var _types = require("../../../renderer/types");
    var _enums = _interopRequireDefault(require("../../../renderer/enums"));
    var _effect = _interopRequireDefault(require("./effect"));
    var _technique = _interopRequireDefault(require("../../../renderer/core/technique"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function getInvolvedProgram(programName) {
      var lib = cc.renderer._forward._programLib;
      return lib.getTemplate(programName);
    }
    function parseProperties(effectAsset, passJson) {
      var propertiesJson = passJson.properties || {};
      var program = getInvolvedProgram(passJson.program);
      var _loop = function _loop(prop) {
        var uniformInfo = program.uniforms.find((function(u) {
          return u.name === prop;
        }));
        if (!uniformInfo) {
          cc.warnID(9107, effectAsset.name, prop);
          return "continue";
        }
      };
      for (var prop in propertiesJson) {
        var _ret = _loop(prop);
        if ("continue" === _ret) continue;
      }
      var properties = {};
      program.uniforms.forEach((function(u) {
        var name = u.name, prop = properties[name] = Object.assign({}, u), propInfo = propertiesJson[name];
        var value = _types.enums2default[u.type];
        value = propInfo ? propInfo.type === _enums["default"].PARAM_TEXTURE_2D ? null : propInfo.type === _enums["default"].PARAM_INT || propInfo.type === _enums["default"].PARAM_FLOAT ? Array.isArray(propInfo.value) ? propInfo.value[0] : propInfo.value : new Float32Array(propInfo.value) : _types.enums2default[u.type];
        prop.value = value;
      }));
      return properties;
    }
    function passDefines(pass) {
      var defines = {};
      var program = getInvolvedProgram(pass.program);
      program.defines.forEach((function(d) {
        defines[d.name] = _types.enums2default[d.type];
      }));
      return defines;
    }
    function parseTechniques(effectAsset) {
      var techNum = effectAsset.techniques.length;
      var techniques = new Array(techNum);
      for (var j = 0; j < techNum; ++j) {
        var tech = effectAsset.techniques[j];
        var techName = tech.name || j;
        var passNum = tech.passes.length;
        var passes = new Array(passNum);
        for (var k = 0; k < passNum; ++k) {
          var pass = tech.passes[k];
          var passName = pass.name || k;
          var detailName = effectAsset.name + "-" + techName + "-" + passName;
          var stage = pass.stage || "opaque";
          var properties = parseProperties(effectAsset, pass);
          var defines = passDefines(pass);
          var newPass = passes[k] = new _pass["default"](passName, detailName, pass.program, stage, properties, defines);
          pass.rasterizerState && newPass.setCullMode(pass.rasterizerState.cullMode);
          var blendState = pass.blendState && pass.blendState.targets[0];
          blendState && newPass.setBlend(blendState.blend, blendState.blendEq, blendState.blendSrc, blendState.blendDst, blendState.blendAlphaEq, blendState.blendSrcAlpha, blendState.blendDstAlpha, blendState.blendColor);
          var depthStencilState = pass.depthStencilState;
          if (depthStencilState) {
            newPass.setDepth(depthStencilState.depthTest, depthStencilState.depthWrite, depthStencilState.depthFunc);
            newPass.setStencilFront(depthStencilState.stencilTest, depthStencilState.stencilFuncFront, depthStencilState.stencilRefFront, depthStencilState.stencilMaskFront, depthStencilState.stencilFailOpFront, depthStencilState.stencilZFailOpFront, depthStencilState.stencilZPassOpFront, depthStencilState.stencilWriteMaskFront);
            newPass.setStencilBack(depthStencilState.stencilTest, depthStencilState.stencilFuncBack, depthStencilState.stencilRefBack, depthStencilState.stencilMaskBack, depthStencilState.stencilFailOpBack, depthStencilState.stencilZFailOpBack, depthStencilState.stencilZPassOpBack, depthStencilState.stencilWriteMaskBack);
          }
        }
        techniques[j] = new _technique["default"](techName, passes);
      }
      return techniques;
    }
    function parseEffect(effect) {
      var techniques = parseTechniques(effect);
      return new _effect["default"](effect.name, techniques, 0, effect);
    }
    false;
  }), {
    "../../../renderer/core/pass": 242,
    "../../../renderer/core/technique": 244,
    "../../../renderer/enums": 246,
    "../../../renderer/types": 274,
    "./effect": 81
  } ],
  80: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _murmurhash2_gc = _interopRequireDefault(require("../../../renderer/murmurhash2_gc"));
    var _utils = _interopRequireDefault(require("./utils"));
    var _effectBase = _interopRequireDefault(require("./effect-base"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        "value" in descriptor && (descriptor.writable = true);
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      protoProps && _defineProperties(Constructor.prototype, protoProps);
      staticProps && _defineProperties(Constructor, staticProps);
      return Constructor;
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      subClass.__proto__ = superClass;
    }
    var gfx = cc.gfx;
    var EffectVariant = (function(_EffectBase) {
      _inheritsLoose(EffectVariant, _EffectBase);
      _createClass(EffectVariant, [ {
        key: "effect",
        get: function get() {
          return this._effect;
        }
      }, {
        key: "name",
        get: function get() {
          return this._effect && this._effect.name + " (variant)";
        }
      }, {
        key: "passes",
        get: function get() {
          return this._passes;
        }
      }, {
        key: "stagePasses",
        get: function get() {
          return this._stagePasses;
        }
      } ]);
      function EffectVariant(effect) {
        var _this;
        _this = _EffectBase.call(this) || this;
        _this._effect = void 0;
        _this._passes = [];
        _this._stagePasses = {};
        _this._hash = 0;
        _this.init(effect);
        return _this;
      }
      var _proto = EffectVariant.prototype;
      _proto._onEffectChanged = function _onEffectChanged() {};
      _proto.init = function init(effect) {
        effect instanceof EffectVariant && (effect = effect.effect);
        this._effect = effect;
        this._dirty = true;
        if (effect) {
          var passes = effect.passes;
          var variantPasses = this._passes;
          variantPasses.length = 0;
          var stagePasses = this._stagePasses = {};
          for (var i = 0; i < passes.length; i++) {
            var variant = variantPasses[i] = Object.setPrototypeOf({}, passes[i]);
            variant._properties = Object.setPrototypeOf({}, passes[i]._properties);
            variant._defines = Object.setPrototypeOf({}, passes[i]._defines);
            stagePasses[variant._stage] || (stagePasses[variant._stage] = []);
            stagePasses[variant._stage].push(variant);
          }
        }
      };
      _proto.updateHash = function updateHash(hash) {};
      _proto.getHash = function getHash() {
        if (!this._dirty) return this._hash;
        this._dirty = false;
        var hash = "";
        hash += _utils["default"].serializePasses(this._passes);
        var effect = this._effect;
        effect && (hash += _utils["default"].serializePasses(effect.passes));
        this._hash = (0, _murmurhash2_gc["default"])(hash, 666);
        this.updateHash(this._hash);
        return this._hash;
      };
      return EffectVariant;
    })(_effectBase["default"]);
    exports["default"] = EffectVariant;
    cc.EffectVariant = EffectVariant;
    module.exports = exports["default"];
  }), {
    "../../../renderer/murmurhash2_gc": 269,
    "./effect-base": 78,
    "./utils": 85
  } ],
  81: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _effectBase = _interopRequireDefault(require("./effect-base"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        "value" in descriptor && (descriptor.writable = true);
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      protoProps && _defineProperties(Constructor.prototype, protoProps);
      staticProps && _defineProperties(Constructor, staticProps);
      return Constructor;
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      subClass.__proto__ = superClass;
    }
    var Effect = (function(_EffectBase) {
      _inheritsLoose(Effect, _EffectBase);
      _createClass(Effect, [ {
        key: "technique",
        get: function get() {
          return this._technique;
        }
      }, {
        key: "passes",
        get: function get() {
          return this._technique.passes;
        }
      } ]);
      function Effect(name, techniques, techniqueIndex, asset) {
        var _this;
        _this = _EffectBase.call(this) || this;
        _this._techniques = [];
        _this._asset = null;
        _this.init(name, techniques, techniqueIndex, asset, true);
        return _this;
      }
      var _proto = Effect.prototype;
      _proto.init = function init(name, techniques, techniqueIndex, asset, createNative) {
        this._name = name;
        this._techniques = techniques;
        this._technique = techniques[techniqueIndex];
        this._asset = asset;
      };
      _proto.switchTechnique = function switchTechnique(index) {
        if (index >= this._techniques.length) {
          cc.warn("Can not switch to technique with index [" + index + "]");
          return;
        }
        this._technique = this._techniques[index];
      };
      _proto.clear = function clear() {
        this._techniques = [];
      };
      _proto.clone = function clone() {
        var techniques = [];
        for (var i = 0; i < this._techniques.length; i++) techniques.push(this._techniques[i].clone());
        var techniqueIndex = this._techniques.indexOf(this._technique);
        return new Effect(this._name, techniques, techniqueIndex, this._asset);
      };
      return Effect;
    })(_effectBase["default"]);
    exports["default"] = Effect;
    cc.Effect = Effect;
    module.exports = exports["default"];
  }), {
    "./effect-base": 78
  } ],
  82: [ (function(require, module, exports) {
    "use strict";
    require("./CCEffectAsset");
    require("./CCMaterial");
    require("./material-variant");
  }), {
    "./CCEffectAsset": 76,
    "./CCMaterial": 77,
    "./material-variant": 84
  } ],
  83: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _utils = _interopRequireDefault(require("./utils"));
    var _pool = _interopRequireDefault(require("../../utils/pool"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      subClass.__proto__ = superClass;
    }
    var MaterialPool = (function(_Pool) {
      _inheritsLoose(MaterialPool, _Pool);
      function MaterialPool() {
        var _this;
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) args[_key] = arguments[_key];
        _this = _Pool.call.apply(_Pool, [ this ].concat(args)) || this;
        _this.enabled = false;
        _this._pool = {};
        return _this;
      }
      var _proto = MaterialPool.prototype;
      _proto.get = function get(exampleMat, renderComponent) {
        var pool = this._pool;
        if (exampleMat instanceof cc.MaterialVariant) {
          if (!exampleMat._owner) {
            exampleMat._owner = renderComponent;
            return exampleMat;
          }
          if (exampleMat._owner === renderComponent) return exampleMat;
          exampleMat = exampleMat.material;
        }
        var instance;
        if (this.enabled) {
          var uuid = exampleMat.effectAsset._uuid;
          if (pool[uuid]) {
            var key = _utils["default"].serializeDefines(exampleMat._effect._defines) + _utils["default"].serializeTechniques(exampleMat._effect._techniques);
            instance = pool[uuid][key] && pool[uuid][key].pop();
          }
        }
        if (instance) this.count--; else {
          instance = new cc.MaterialVariant(exampleMat);
          instance._name = exampleMat._name + " (Instance)";
          instance._uuid = exampleMat._uuid;
        }
        instance._owner = renderComponent;
        return instance;
      };
      _proto.put = function put(mat) {
        if (!this.enabled || !mat._owner) return;
        var pool = this._pool;
        var uuid = mat.effectAsset._uuid;
        pool[uuid] || (pool[uuid] = {});
        var key = _utils["default"].serializeDefines(mat._effect._defines) + _utils["default"].serializeTechniques(mat._effect._techniques);
        pool[uuid][key] || (pool[uuid][key] = []);
        if (this.count > this.maxSize) return;
        this._clean(mat);
        pool[uuid][key].push(mat);
        this.count++;
      };
      _proto.clear = function clear() {
        this._pool = {};
        this.count = 0;
      };
      _proto._clean = function _clean(mat) {
        mat._owner = null;
      };
      return MaterialPool;
    })(_pool["default"]);
    var materialPool = new MaterialPool();
    _pool["default"].register("material", materialPool);
    var _default = materialPool;
    exports["default"] = _default;
    module.exports = exports["default"];
  }), {
    "../../utils/pool": 211,
    "./utils": 85
  } ],
  84: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _CCMaterial = _interopRequireDefault(require("./CCMaterial"));
    var _effectVariant = _interopRequireDefault(require("./effect-variant"));
    var _materialPool = _interopRequireDefault(require("./material-pool"));
    var _dec, _class, _temp;
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        "value" in descriptor && (descriptor.writable = true);
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      protoProps && _defineProperties(Constructor.prototype, protoProps);
      staticProps && _defineProperties(Constructor, staticProps);
      return Constructor;
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      subClass.__proto__ = superClass;
    }
    var ccclass = cc._decorator.ccclass;
    var MaterialVariant = (_dec = ccclass("cc.MaterialVariant"), _dec(_class = (_temp = (function(_Material) {
      _inheritsLoose(MaterialVariant, _Material);
      MaterialVariant.createWithBuiltin = function createWithBuiltin(materialName, owner) {
        return MaterialVariant.create(_CCMaterial["default"].getBuiltinMaterial(materialName), owner);
      };
      MaterialVariant.create = function create(material, owner) {
        if (!material) return null;
        return _materialPool["default"].get(material, owner);
      };
      _createClass(MaterialVariant, [ {
        key: "uuid",
        get: function get() {
          return this._material.uuid;
        }
      }, {
        key: "owner",
        get: function get() {
          return this._owner;
        }
      }, {
        key: "material",
        get: function get() {
          return this._material;
        }
      } ]);
      function MaterialVariant(material) {
        var _this;
        _this = _Material.call(this) || this;
        _this._owner = null;
        _this._material = null;
        _this.init(material);
        return _this;
      }
      var _proto = MaterialVariant.prototype;
      _proto.init = function init(material) {
        this._effect = new _effectVariant["default"](material.effect);
        this._effectAsset = material._effectAsset;
        this._material = material;
      };
      return MaterialVariant;
    })(_CCMaterial["default"]), _temp)) || _class);
    exports["default"] = MaterialVariant;
    cc.MaterialVariant = MaterialVariant;
    module.exports = exports["default"];
  }), {
    "./CCMaterial": 77,
    "./effect-variant": 80,
    "./material-pool": 83
  } ],
  85: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _enums = _interopRequireDefault(require("../../../renderer/enums"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function serializeDefines(defines) {
      var str = "";
      for (var name in defines) str += name + defines[name];
      return str;
    }
    function serializePass(pass, excludeProperties) {
      var str = pass._programName + pass._cullMode;
      pass._blend && (str += pass._blendEq + pass._blendAlphaEq + pass._blendSrc + pass._blendDst + pass._blendSrcAlpha + pass._blendDstAlpha + pass._blendColor);
      pass._depthTest && (str += pass._depthWrite + pass._depthFunc);
      pass._stencilTest && (str += pass._stencilFuncFront + pass._stencilRefFront + pass._stencilMaskFront + pass._stencilFailOpFront + pass._stencilZFailOpFront + pass._stencilZPassOpFront + pass._stencilWriteMaskFront + pass._stencilFuncBack + pass._stencilRefBack + pass._stencilMaskBack + pass._stencilFailOpBack + pass._stencilZFailOpBack + pass._stencilZPassOpBack + pass._stencilWriteMaskBack);
      excludeProperties || (str += serializeUniforms(pass._properties));
      str += serializeDefines(pass._defines);
      return str;
    }
    function serializePasses(passes) {
      var hashData = "";
      for (var i = 0; i < passes.length; i++) hashData += serializePass(passes[i]);
      return hashData;
    }
    function serializeUniforms(uniforms) {
      var hashData = "";
      for (var name in uniforms) {
        var param = uniforms[name];
        var prop = param.value;
        if (!prop) continue;
        param.type === _enums["default"].PARAM_TEXTURE_2D || param.type === _enums["default"].PARAM_TEXTURE_CUBE ? hashData += prop._id + ";" : hashData += prop.toString() + ";";
      }
      return hashData;
    }
    var _default = {
      serializeDefines: serializeDefines,
      serializePasses: serializePasses,
      serializeUniforms: serializeUniforms
    };
    exports["default"] = _default;
    module.exports = exports["default"];
  }), {
    "../../../renderer/enums": 246
  } ],
  86: [ (function(require, module, exports) {
    "use strict";
    var Event;
    true;
    Event = require("../CCNode").EventType;
    var TOP = 1;
    var MID = 2;
    var BOT = 4;
    var LEFT = 8;
    var CENTER = 16;
    var RIGHT = 32;
    var HORIZONTAL = LEFT | CENTER | RIGHT;
    var VERTICAL = TOP | MID | BOT;
    var AlignMode = cc.Enum({
      ONCE: 0,
      ON_WINDOW_RESIZE: 1,
      ALWAYS: 2
    });
    function getReadonlyNodeSize(parent) {
      return parent instanceof cc.Scene ? cc.visibleRect : parent._contentSize;
    }
    function computeInverseTransForTarget(widgetNode, target, out_inverseTranslate, out_inverseScale) {
      var scaleX = widgetNode._parent.scaleX;
      var scaleY = widgetNode._parent.scaleY;
      var translateX = 0;
      var translateY = 0;
      for (var node = widgetNode._parent; ;) {
        translateX += node.x;
        translateY += node.y;
        node = node._parent;
        if (!node) {
          out_inverseTranslate.x = out_inverseTranslate.y = 0;
          out_inverseScale.x = out_inverseScale.y = 1;
          return;
        }
        if (node === target) break;
        var sx = node.scaleX;
        var sy = node.scaleY;
        translateX *= sx;
        translateY *= sy;
        scaleX *= sx;
        scaleY *= sy;
      }
      out_inverseScale.x = 0 !== scaleX ? 1 / scaleX : 1;
      out_inverseScale.y = 0 !== scaleY ? 1 / scaleY : 1;
      out_inverseTranslate.x = -translateX;
      out_inverseTranslate.y = -translateY;
    }
    var tInverseTranslate = cc.Vec2.ZERO;
    var tInverseScale = cc.Vec2.ONE;
    function align(node, widget) {
      var hasTarget = widget._target;
      var target;
      var inverseTranslate, inverseScale;
      if (hasTarget) {
        target = hasTarget;
        inverseTranslate = tInverseTranslate;
        inverseScale = tInverseScale;
        computeInverseTransForTarget(node, target, inverseTranslate, inverseScale);
      } else target = node._parent;
      var targetSize = getReadonlyNodeSize(target);
      var targetAnchor = target._anchorPoint;
      var isRoot = (true, target instanceof cc.Scene);
      var x = node.x, y = node.y;
      var anchor = node._anchorPoint;
      if (widget._alignFlags & HORIZONTAL) {
        var localLeft, localRight, targetWidth = targetSize.width;
        if (isRoot) {
          localLeft = cc.visibleRect.left.x;
          localRight = cc.visibleRect.right.x;
        } else {
          localLeft = -targetAnchor.x * targetWidth;
          localRight = localLeft + targetWidth;
        }
        localLeft += widget._isAbsLeft ? widget._left : widget._left * targetWidth;
        localRight -= widget._isAbsRight ? widget._right : widget._right * targetWidth;
        if (hasTarget) {
          localLeft += inverseTranslate.x;
          localLeft *= inverseScale.x;
          localRight += inverseTranslate.x;
          localRight *= inverseScale.x;
        }
        var width, anchorX = anchor.x, scaleX = node.scaleX;
        if (scaleX < 0) {
          anchorX = 1 - anchorX;
          scaleX = -scaleX;
        }
        if (widget.isStretchWidth) {
          width = localRight - localLeft;
          0 !== scaleX && (node.width = width / scaleX);
          x = localLeft + anchorX * width;
        } else {
          width = node.width * scaleX;
          if (widget.isAlignHorizontalCenter) {
            var localHorizontalCenter = widget._isAbsHorizontalCenter ? widget._horizontalCenter : widget._horizontalCenter * targetWidth;
            var targetCenter = (.5 - targetAnchor.x) * targetSize.width;
            if (hasTarget) {
              localHorizontalCenter *= inverseScale.x;
              targetCenter += inverseTranslate.x;
              targetCenter *= inverseScale.x;
            }
            x = targetCenter + (anchorX - .5) * width + localHorizontalCenter;
          } else x = widget.isAlignLeft ? localLeft + anchorX * width : localRight + (anchorX - 1) * width;
        }
      }
      if (widget._alignFlags & VERTICAL) {
        var localTop, localBottom, targetHeight = targetSize.height;
        if (isRoot) {
          localBottom = cc.visibleRect.bottom.y;
          localTop = cc.visibleRect.top.y;
        } else {
          localBottom = -targetAnchor.y * targetHeight;
          localTop = localBottom + targetHeight;
        }
        localBottom += widget._isAbsBottom ? widget._bottom : widget._bottom * targetHeight;
        localTop -= widget._isAbsTop ? widget._top : widget._top * targetHeight;
        if (hasTarget) {
          localBottom += inverseTranslate.y;
          localBottom *= inverseScale.y;
          localTop += inverseTranslate.y;
          localTop *= inverseScale.y;
        }
        var height, anchorY = anchor.y, scaleY = node.scaleY;
        if (scaleY < 0) {
          anchorY = 1 - anchorY;
          scaleY = -scaleY;
        }
        if (widget.isStretchHeight) {
          height = localTop - localBottom;
          0 !== scaleY && (node.height = height / scaleY);
          y = localBottom + anchorY * height;
        } else {
          height = node.height * scaleY;
          if (widget.isAlignVerticalCenter) {
            var localVerticalCenter = widget._isAbsVerticalCenter ? widget._verticalCenter : widget._verticalCenter * targetHeight;
            var targetMiddle = (.5 - targetAnchor.y) * targetSize.height;
            if (hasTarget) {
              localVerticalCenter *= inverseScale.y;
              targetMiddle += inverseTranslate.y;
              targetMiddle *= inverseScale.y;
            }
            y = targetMiddle + (anchorY - .5) * height + localVerticalCenter;
          } else y = widget.isAlignBottom ? localBottom + anchorY * height : localTop + (anchorY - 1) * height;
        }
      }
      node.setPosition(x, y);
    }
    function visitNode(node) {
      var widget = node._widget;
      if (widget) {
        false;
        align(node, widget);
        true, widget.alignMode !== AlignMode.ALWAYS ? widget.enabled = false : activeWidgets.push(widget);
      }
      var children = node._children;
      for (var i = 0; i < children.length; i++) {
        var child = children[i];
        child._active && visitNode(child);
      }
    }
    var animationState;
    false;
    function refreshScene() {
      var AnimUtils;
      var EditMode;
      var nowPreviewing;
      var component;
      var animation;
      var _component;
      var _animation;
      false;
      var scene = cc.director.getScene();
      if (scene) {
        widgetManager.isAligning = true;
        if (widgetManager._nodesOrderDirty) {
          activeWidgets.length = 0;
          visitNode(scene);
          widgetManager._nodesOrderDirty = false;
        } else {
          var i, widget, iterator = widgetManager._activeWidgetsIterator;
          var AnimUtils;
          var editingNode;
          var node;
          false;
          for (iterator.i = 0; iterator.i < activeWidgets.length; ++iterator.i) {
            widget = activeWidgets[iterator.i];
            align(widget.node, widget);
          }
        }
        widgetManager.isAligning = false;
      }
      false;
    }
    var adjustWidgetToAllowMovingInEditor = false;
    var adjustWidgetToAllowResizingInEditor = false;
    var activeWidgets = [];
    function updateAlignment(node) {
      var parent = node._parent;
      cc.Node.isNode(parent) && updateAlignment(parent);
      var widget = node._widget || node.getComponent(cc.Widget);
      widget && parent && align(node, widget);
    }
    var widgetManager = cc._widgetManager = module.exports = {
      _AlignFlags: {
        TOP: TOP,
        MID: MID,
        BOT: BOT,
        LEFT: LEFT,
        CENTER: CENTER,
        RIGHT: RIGHT
      },
      isAligning: false,
      _nodesOrderDirty: false,
      _activeWidgetsIterator: new cc.js.array.MutableForwardIterator(activeWidgets),
      init: function init(director) {
        director.on(cc.Director.EVENT_AFTER_UPDATE, refreshScene);
        false;
        var thisOnResized = this.onResized.bind(this);
        window.addEventListener("resize", thisOnResized);
        window.addEventListener("orientationchange", thisOnResized);
      },
      add: function add(widget) {
        widget.node._widget = widget;
        this._nodesOrderDirty = true;
        false;
      },
      remove: function remove(widget) {
        widget.node._widget = null;
        this._activeWidgetsIterator.remove(widget);
        false;
      },
      onResized: function onResized() {
        var scene = cc.director.getScene();
        scene && this.refreshWidgetOnResized(scene);
      },
      refreshWidgetOnResized: function refreshWidgetOnResized(node) {
        var widget = cc.Node.isNode(node) && node.getComponent(cc.Widget);
        widget && widget.alignMode === AlignMode.ON_WINDOW_RESIZE && (widget.enabled = true);
        var children = node._children;
        for (var i = 0; i < children.length; i++) {
          var child = children[i];
          this.refreshWidgetOnResized(child);
        }
      },
      updateAlignment: updateAlignment,
      AlignMode: AlignMode
    };
    false;
  }), {
    "../CCNode": 26
  } ],
  87: [ (function(require, module, exports) {
    "use strict";
    var _valueTypes = require("../value-types");
    var _geomUtils = require("../geom-utils");
    var AffineTrans = require("../utils/affine-transform");
    var renderer = require("../renderer/index");
    var RenderFlow = require("../renderer/render-flow");
    var game = require("../CCGame");
    var RendererCamera = null;
    false;
    RendererCamera = require("../../renderer/scene/camera");
    var _mat4_temp_1 = cc.mat4();
    var _mat4_temp_2 = cc.mat4();
    var _v3_temp_1 = cc.v3();
    var _v3_temp_2 = cc.v3();
    var _v3_temp_3 = cc.v3();
    var _cameras = [];
    function updateMainCamera() {
      for (var i = 0, minDepth = Number.MAX_VALUE; i < _cameras.length; i++) {
        var camera = _cameras[i];
        if (camera._depth < minDepth) {
          Camera.main = camera;
          minDepth = camera._depth;
        }
      }
    }
    var _debugCamera = null;
    function repositionDebugCamera() {
      if (!_debugCamera) return;
      var node = _debugCamera.getNode();
      var canvas = cc.game.canvas;
      node.z = canvas.height / 1.1566;
      node.x = canvas.width / 2;
      node.y = canvas.height / 2;
    }
    var ClearFlags = cc.Enum({
      COLOR: 1,
      DEPTH: 2,
      STENCIL: 4
    });
    var StageFlags = cc.Enum({
      OPAQUE: 1,
      TRANSPARENT: 2
    });
    var Camera = cc.Class({
      name: "cc.Camera",
      extends: cc.Component,
      ctor: function ctor() {
        if (game.renderType !== game.RENDER_TYPE_CANVAS) {
          var camera = new RendererCamera();
          camera.setStages([ "opaque" ]);
          camera.dirty = true;
          this._inited = false;
          this._camera = camera;
        } else this._inited = true;
      },
      editor: false,
      properties: {
        _cullingMask: 4294967295,
        _clearFlags: ClearFlags.DEPTH | ClearFlags.STENCIL,
        _backgroundColor: cc.color(0, 0, 0, 255),
        _depth: 0,
        _zoomRatio: 1,
        _targetTexture: null,
        _fov: 60,
        _orthoSize: 10,
        _nearClip: 1,
        _farClip: 4096,
        _ortho: true,
        _rect: cc.rect(0, 0, 1, 1),
        _renderStages: 1,
        _alignWithScreen: true,
        zoomRatio: {
          get: function get() {
            return this._zoomRatio;
          },
          set: function set(value) {
            this._zoomRatio = value;
          },
          tooltip: false
        },
        fov: {
          get: function get() {
            return this._fov;
          },
          set: function set(v) {
            this._fov = v;
          },
          tooltip: false
        },
        orthoSize: {
          get: function get() {
            return this._orthoSize;
          },
          set: function set(v) {
            this._orthoSize = v;
          },
          tooltip: false
        },
        nearClip: {
          get: function get() {
            return this._nearClip;
          },
          set: function set(v) {
            this._nearClip = v;
            this._updateClippingpPlanes();
          },
          tooltip: false
        },
        farClip: {
          get: function get() {
            return this._farClip;
          },
          set: function set(v) {
            this._farClip = v;
            this._updateClippingpPlanes();
          },
          tooltip: false
        },
        ortho: {
          get: function get() {
            return this._ortho;
          },
          set: function set(v) {
            this._ortho = v;
            this._updateProjection();
          },
          tooltip: false
        },
        rect: {
          get: function get() {
            return this._rect;
          },
          set: function set(v) {
            this._rect = v;
            this._updateRect();
          },
          tooltip: false
        },
        cullingMask: {
          get: function get() {
            return this._cullingMask;
          },
          set: function set(value) {
            this._cullingMask = value;
            this._updateCameraMask();
          },
          tooltip: false
        },
        clearFlags: {
          get: function get() {
            return this._clearFlags;
          },
          set: function set(value) {
            this._clearFlags = value;
            this._camera && this._camera.setClearFlags(value);
          },
          tooltip: false
        },
        backgroundColor: {
          get: function get() {
            return this._backgroundColor;
          },
          set: function set(value) {
            if (!this._backgroundColor.equals(value)) {
              this._backgroundColor.set(value);
              this._updateBackgroundColor();
            }
          },
          tooltip: false
        },
        depth: {
          get: function get() {
            return this._depth;
          },
          set: function set(value) {
            Camera.main === this ? this._depth < value && updateMainCamera() : Camera.main && value < Camera.main._depth && _cameras.includes(this) && (Camera.main = this);
            this._depth = value;
            this._camera && this._camera.setPriority(value);
          },
          tooltip: false
        },
        targetTexture: {
          get: function get() {
            return this._targetTexture;
          },
          set: function set(value) {
            this._targetTexture = value;
            this._updateTargetTexture();
          },
          tooltip: false
        },
        renderStages: {
          get: function get() {
            return this._renderStages;
          },
          set: function set(val) {
            this._renderStages = val;
            this._updateStages();
          },
          tooltip: false
        },
        alignWithScreen: {
          get: function get() {
            return this._alignWithScreen;
          },
          set: function set(v) {
            this._alignWithScreen = v;
          }
        },
        _is3D: {
          get: function get() {
            return this.node && this.node._is3DNode;
          }
        }
      },
      statics: {
        main: null,
        cameras: _cameras,
        ClearFlags: ClearFlags,
        findCamera: function findCamera(node) {
          for (var i = 0, l = _cameras.length; i < l; i++) {
            var camera = _cameras[i];
            if (camera.containsNode(node)) return camera;
          }
          return null;
        },
        _findRendererCamera: function _findRendererCamera(node) {
          var cameras = renderer.scene._cameras;
          for (var i = 0; i < cameras._count; i++) if (cameras._data[i]._cullingMask & node._cullingMask) return cameras._data[i];
          return null;
        },
        _setupDebugCamera: function _setupDebugCamera() {
          if (_debugCamera) return;
          if (game.renderType === game.RENDER_TYPE_CANVAS) return;
          var camera = new RendererCamera();
          _debugCamera = camera;
          camera.setStages([ "opaque" ]);
          camera.setFov(60 * Math.PI / 180);
          camera.setNear(.1);
          camera.setFar(4096);
          camera.dirty = true;
          camera.cullingMask = 1 << cc.Node.BuiltinGroupIndex.DEBUG;
          camera.setPriority(cc.macro.MAX_ZINDEX);
          camera.setClearFlags(0);
          camera.setColor(0, 0, 0, 0);
          var node = new cc.Node();
          camera.setNode(node);
          repositionDebugCamera();
          cc.view.on("design-resolution-changed", repositionDebugCamera);
          renderer.scene.addCamera(camera);
        }
      },
      _updateCameraMask: function _updateCameraMask() {
        if (this._camera) {
          var mask = this._cullingMask & ~(1 << cc.Node.BuiltinGroupIndex.DEBUG);
          this._camera.cullingMask = mask;
        }
      },
      _updateBackgroundColor: function _updateBackgroundColor() {
        if (!this._camera) return;
        var color = this._backgroundColor;
        this._camera.setColor(color.r / 255, color.g / 255, color.b / 255, color.a / 255);
      },
      _updateTargetTexture: function _updateTargetTexture() {
        if (!this._camera) return;
        var texture = this._targetTexture;
        this._camera.setFrameBuffer(texture ? texture._framebuffer : null);
      },
      _updateClippingpPlanes: function _updateClippingpPlanes() {
        if (!this._camera) return;
        this._camera.setNear(this._nearClip);
        this._camera.setFar(this._farClip);
      },
      _updateProjection: function _updateProjection() {
        if (!this._camera) return;
        var type = this._ortho ? 1 : 0;
        this._camera.setType(type);
      },
      _updateRect: function _updateRect() {
        if (!this._camera) return;
        var rect = this._rect;
        this._camera.setRect(rect.x, rect.y, rect.width, rect.height);
      },
      _updateStages: function _updateStages() {
        var flags = this._renderStages;
        var stages = [];
        flags & StageFlags.OPAQUE && stages.push("opaque");
        flags & StageFlags.TRANSPARENT && stages.push("transparent");
        this._camera.setStages(stages);
      },
      _init: function _init() {
        if (this._inited) return;
        this._inited = true;
        var camera = this._camera;
        if (!camera) return;
        camera.setNode(this.node);
        camera.setClearFlags(this._clearFlags);
        camera.setPriority(this._depth);
        this._updateBackgroundColor();
        this._updateCameraMask();
        this._updateTargetTexture();
        this._updateClippingpPlanes();
        this._updateProjection();
        this._updateStages();
        this._updateRect();
        this.beforeDraw();
      },
      onLoad: function onLoad() {
        this._init();
      },
      onEnable: function onEnable() {
        if (true, game.renderType !== game.RENDER_TYPE_CANVAS) {
          cc.director.on(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
          renderer.scene.addCamera(this._camera);
        }
        _cameras.push(this);
        (!Camera.main || this._depth < Camera.main._depth) && (Camera.main = this);
      },
      onDisable: function onDisable() {
        if (true, game.renderType !== game.RENDER_TYPE_CANVAS) {
          cc.director.off(cc.Director.EVENT_BEFORE_DRAW, this.beforeDraw, this);
          renderer.scene.removeCamera(this._camera);
        }
        cc.js.array.fastRemove(_cameras, this);
        if (Camera.main === this) {
          Camera.main = null;
          updateMainCamera();
        }
      },
      getScreenToWorldMatrix2D: function getScreenToWorldMatrix2D(out) {
        this.getWorldToScreenMatrix2D(out);
        _valueTypes.Mat4.invert(out, out);
        return out;
      },
      getWorldToScreenMatrix2D: function getWorldToScreenMatrix2D(out) {
        this.node.getWorldRT(_mat4_temp_1);
        var zoomRatio = this.zoomRatio;
        var _mat4_temp_1m = _mat4_temp_1.m;
        _mat4_temp_1m[0] *= zoomRatio;
        _mat4_temp_1m[1] *= zoomRatio;
        _mat4_temp_1m[4] *= zoomRatio;
        _mat4_temp_1m[5] *= zoomRatio;
        var m12 = _mat4_temp_1m[12];
        var m13 = _mat4_temp_1m[13];
        var center = cc.visibleRect.center;
        _mat4_temp_1m[12] = center.x - (_mat4_temp_1m[0] * m12 + _mat4_temp_1m[4] * m13);
        _mat4_temp_1m[13] = center.y - (_mat4_temp_1m[1] * m12 + _mat4_temp_1m[5] * m13);
        out !== _mat4_temp_1 && _valueTypes.Mat4.copy(out, _mat4_temp_1);
        return out;
      },
      getScreenToWorldPoint: function getScreenToWorldPoint(screenPosition, out) {
        if (this.node.is3DNode) {
          out = out || new cc.Vec3();
          this._camera.screenToWorld(out, screenPosition, cc.visibleRect.width, cc.visibleRect.height);
        } else {
          out = out || new cc.Vec2();
          this.getScreenToWorldMatrix2D(_mat4_temp_1);
          _valueTypes.Vec2.transformMat4(out, screenPosition, _mat4_temp_1);
        }
        return out;
      },
      getWorldToScreenPoint: function getWorldToScreenPoint(worldPosition, out) {
        if (this.node.is3DNode) {
          out = out || new cc.Vec3();
          this._camera.worldToScreen(out, worldPosition, cc.visibleRect.width, cc.visibleRect.height);
        } else {
          out = out || new cc.Vec2();
          this.getWorldToScreenMatrix2D(_mat4_temp_1);
          _valueTypes.Vec2.transformMat4(out, worldPosition, _mat4_temp_1);
        }
        return out;
      },
      getRay: function getRay(screenPos) {
        if (!cc.geomUtils) return screenPos;
        _valueTypes.Vec3.set(_v3_temp_3, screenPos.x, screenPos.y, 1);
        this._camera.screenToWorld(_v3_temp_2, _v3_temp_3, cc.visibleRect.width, cc.visibleRect.height);
        if (this.ortho) {
          _valueTypes.Vec3.set(_v3_temp_3, screenPos.x, screenPos.y, -1);
          this._camera.screenToWorld(_v3_temp_1, _v3_temp_3, cc.visibleRect.width, cc.visibleRect.height);
        } else this.node.getWorldPosition(_v3_temp_1);
        return _geomUtils.Ray.fromPoints(new _geomUtils.Ray(), _v3_temp_1, _v3_temp_2);
      },
      containsNode: function containsNode(node) {
        return (node._cullingMask & this.cullingMask) > 0;
      },
      render: function render(rootNode) {
        rootNode = rootNode || cc.director.getScene();
        if (!rootNode) return null;
        this.node.getWorldMatrix(_mat4_temp_1);
        this.beforeDraw();
        RenderFlow.renderCamera(this._camera, rootNode);
      },
      _onAlignWithScreen: function _onAlignWithScreen() {
        var height = cc.game.canvas.height / cc.view._scaleY;
        var targetTexture = this._targetTexture;
        if (targetTexture) {
          false;
          height = cc.visibleRect.height;
        }
        var fov = this._fov * cc.macro.RAD;
        this.node.z = height / (2 * Math.tan(fov / 2));
        fov = 2 * Math.atan(Math.tan(fov / 2) / this.zoomRatio);
        this._camera.setFov(fov);
        this._camera.setOrthoHeight(height / 2 / this.zoomRatio);
        this.node.setRotation(0, 0, 0, 1);
      },
      beforeDraw: function beforeDraw() {
        if (!this._camera) return;
        if (this._alignWithScreen) this._onAlignWithScreen(); else {
          var fov = this._fov * cc.macro.RAD;
          fov = 2 * Math.atan(Math.tan(fov / 2) / this.zoomRatio);
          this._camera.setFov(fov);
          this._camera.setOrthoHeight(this._orthoSize / this.zoomRatio);
        }
        this._camera.dirty = true;
      }
    });
    cc.js.mixin(Camera.prototype, {
      getNodeToCameraTransform: function getNodeToCameraTransform(node) {
        var out = AffineTrans.identity();
        node.getWorldMatrix(_mat4_temp_2);
        if (this.containsNode(node)) {
          this.getWorldToCameraMatrix(_mat4_temp_1);
          _valueTypes.Mat4.mul(_mat4_temp_2, _mat4_temp_2, _mat4_temp_1);
        }
        AffineTrans.fromMat4(out, _mat4_temp_2);
        return out;
      },
      getCameraToWorldPoint: function getCameraToWorldPoint(point, out) {
        return this.getScreenToWorldPoint(point, out);
      },
      getWorldToCameraPoint: function getWorldToCameraPoint(point, out) {
        return this.getWorldToScreenPoint(point, out);
      },
      getCameraToWorldMatrix: function getCameraToWorldMatrix(out) {
        return this.getScreenToWorldMatrix2D(out);
      },
      getWorldToCameraMatrix: function getWorldToCameraMatrix(out) {
        return this.getWorldToScreenMatrix2D(out);
      }
    });
    module.exports = cc.Camera = Camera;
  }), {
    "../../renderer/scene/camera": 271,
    "../CCGame": 25,
    "../geom-utils": void 0,
    "../renderer/index": 168,
    "../renderer/render-flow": 169,
    "../utils/affine-transform": 200,
    "../value-types": 224
  } ],
  88: [ (function(require, module, exports) {
    "use strict";
    require("./platform/CCClass");
    var Flags = require("./platform/CCObject").Flags;
    var jsArray = require("./platform/js").array;
    var IsStartCalled = Flags.IsStartCalled;
    var IsOnEnableCalled = Flags.IsOnEnableCalled;
    var IsEditorOnEnableCalled = Flags.IsEditorOnEnableCalled;
    var callerFunctor = false;
    var callOnEnableInTryCatch = false;
    var callOnDisableInTryCatch = false;
    function sortedIndex(array, comp) {
      var order = comp.constructor._executionOrder;
      var id = comp._id;
      for (var l = 0, h = array.length - 1, m = h >>> 1; l <= h; m = l + h >>> 1) {
        var test = array[m];
        var testOrder = test.constructor._executionOrder;
        if (testOrder > order) h = m - 1; else if (testOrder < order) l = m + 1; else {
          var testId = test._id;
          if (testId > id) h = m - 1; else {
            if (!(testId < id)) return m;
            l = m + 1;
          }
        }
      }
      return ~l;
    }
    function stableRemoveInactive(iterator, flagToClear) {
      var array = iterator.array;
      var next = iterator.i + 1;
      while (next < array.length) {
        var comp = array[next];
        if (comp._enabled && comp.node._activeInHierarchy) ++next; else {
          iterator.removeAt(next);
          flagToClear && (comp._objFlags &= ~flagToClear);
        }
      }
    }
    var LifeCycleInvoker = cc.Class({
      __ctor__: function __ctor__(invokeFunc) {
        var Iterator = jsArray.MutableForwardIterator;
        this._zero = new Iterator([]);
        this._neg = new Iterator([]);
        this._pos = new Iterator([]);
        false;
        this._invoke = invokeFunc;
      },
      statics: {
        stableRemoveInactive: stableRemoveInactive
      },
      add: null,
      remove: null,
      invoke: null
    });
    function compareOrder(a, b) {
      return a.constructor._executionOrder - b.constructor._executionOrder;
    }
    var OneOffInvoker = cc.Class({
      extends: LifeCycleInvoker,
      add: function add(comp) {
        var order = comp.constructor._executionOrder;
        (0 === order ? this._zero : order < 0 ? this._neg : this._pos).array.push(comp);
      },
      remove: function remove(comp) {
        var order = comp.constructor._executionOrder;
        (0 === order ? this._zero : order < 0 ? this._neg : this._pos).fastRemove(comp);
      },
      cancelInactive: function cancelInactive(flagToClear) {
        stableRemoveInactive(this._zero, flagToClear);
        stableRemoveInactive(this._neg, flagToClear);
        stableRemoveInactive(this._pos, flagToClear);
      },
      invoke: function invoke() {
        var compsNeg = this._neg;
        if (compsNeg.array.length > 0) {
          compsNeg.array.sort(compareOrder);
          this._invoke(compsNeg);
          compsNeg.array.length = 0;
        }
        this._invoke(this._zero);
        this._zero.array.length = 0;
        var compsPos = this._pos;
        if (compsPos.array.length > 0) {
          compsPos.array.sort(compareOrder);
          this._invoke(compsPos);
          compsPos.array.length = 0;
        }
      }
    });
    var ReusableInvoker = cc.Class({
      extends: LifeCycleInvoker,
      add: function add(comp) {
        var order = comp.constructor._executionOrder;
        if (0 === order) this._zero.array.push(comp); else {
          var array = order < 0 ? this._neg.array : this._pos.array;
          var i = sortedIndex(array, comp);
          i < 0 && array.splice(~i, 0, comp);
        }
      },
      remove: function remove(comp) {
        var order = comp.constructor._executionOrder;
        if (0 === order) this._zero.fastRemove(comp); else {
          var iterator = order < 0 ? this._neg : this._pos;
          var i = sortedIndex(iterator.array, comp);
          i >= 0 && iterator.removeAt(i);
        }
      },
      invoke: function invoke(dt) {
        this._neg.array.length > 0 && this._invoke(this._neg, dt);
        this._invoke(this._zero, dt);
        this._pos.array.length > 0 && this._invoke(this._pos, dt);
      }
    });
    function enableInEditor(comp) {
      if (!(comp._objFlags & IsEditorOnEnableCalled)) {
        cc.engine.emit("component-enabled", comp.uuid);
        comp._objFlags |= IsEditorOnEnableCalled;
      }
    }
    function createInvokeImpl(indiePath, useDt, ensureFlag, fastPath) {
      var body;
      false;
      return function(iterator, dt) {
        try {
          fastPath(iterator, dt);
        } catch (e) {
          cc._throw(e);
          var array = iterator.array;
          ensureFlag && (array[iterator.i]._objFlags |= ensureFlag);
          ++iterator.i;
          for (;iterator.i < array.length; ++iterator.i) try {
            indiePath(array[iterator.i], dt);
          } catch (e) {
            cc._throw(e);
            ensureFlag && (array[iterator.i]._objFlags |= ensureFlag);
          }
        }
      };
    }
    var invokeStart = createInvokeImpl((function(c) {
      c.start();
      c._objFlags |= IsStartCalled;
    }), false, IsStartCalled, (function(iterator) {
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var comp = array[iterator.i];
        comp.start();
        comp._objFlags |= IsStartCalled;
      }
    }));
    var invokeUpdate = createInvokeImpl((function(c, dt) {
      c.update(dt);
    }), true, void 0, (function(iterator, dt) {
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) array[iterator.i].update(dt);
    }));
    var invokeLateUpdate = createInvokeImpl((function(c, dt) {
      c.lateUpdate(dt);
    }), true, void 0, (function(iterator, dt) {
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) array[iterator.i].lateUpdate(dt);
    }));
    function ctor() {
      this.startInvoker = new OneOffInvoker(invokeStart);
      this.updateInvoker = new ReusableInvoker(invokeUpdate);
      this.lateUpdateInvoker = new ReusableInvoker(invokeLateUpdate);
      this._deferredComps = [];
      this._updating = false;
    }
    var ComponentScheduler = cc.Class({
      ctor: ctor,
      unscheduleAll: ctor,
      statics: {
        LifeCycleInvoker: LifeCycleInvoker,
        OneOffInvoker: OneOffInvoker,
        createInvokeImpl: createInvokeImpl,
        invokeOnEnable: function(iterator) {
          var compScheduler = cc.director._compScheduler;
          var array = iterator.array;
          for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
            var comp = array[iterator.i];
            if (comp._enabled) {
              comp.onEnable();
              var deactivatedDuringOnEnable = !comp.node._activeInHierarchy;
              deactivatedDuringOnEnable || compScheduler._onEnabled(comp);
            }
          }
        }
      },
      _onEnabled: function _onEnabled(comp) {
        cc.director.getScheduler().resumeTarget(comp);
        comp._objFlags |= IsOnEnableCalled;
        this._updating ? this._deferredComps.push(comp) : this._scheduleImmediate(comp);
      },
      _onDisabled: function _onDisabled(comp) {
        cc.director.getScheduler().pauseTarget(comp);
        comp._objFlags &= ~IsOnEnableCalled;
        var index = this._deferredComps.indexOf(comp);
        if (index >= 0) {
          jsArray.fastRemoveAt(this._deferredComps, index);
          return;
        }
        !comp.start || comp._objFlags & IsStartCalled || this.startInvoker.remove(comp);
        comp.update && this.updateInvoker.remove(comp);
        comp.lateUpdate && this.lateUpdateInvoker.remove(comp);
      },
      enableComp: function(comp, invoker) {
        if (!(comp._objFlags & IsOnEnableCalled)) {
          if (comp.onEnable) {
            if (invoker) {
              invoker.add(comp);
              return;
            }
            comp.onEnable();
            var deactivatedDuringOnEnable = !comp.node._activeInHierarchy;
            if (deactivatedDuringOnEnable) return;
          }
          this._onEnabled(comp);
        }
      },
      disableComp: function(comp) {
        if (comp._objFlags & IsOnEnableCalled) {
          comp.onDisable && comp.onDisable();
          this._onDisabled(comp);
        }
      },
      _scheduleImmediate: function _scheduleImmediate(comp) {
        "function" !== typeof comp.start || comp._objFlags & IsStartCalled || this.startInvoker.add(comp);
        "function" === typeof comp.update && this.updateInvoker.add(comp);
        "function" === typeof comp.lateUpdate && this.lateUpdateInvoker.add(comp);
      },
      _deferredSchedule: function _deferredSchedule() {
        var comps = this._deferredComps;
        for (var i = 0, len = comps.length; i < len; i++) this._scheduleImmediate(comps[i]);
        comps.length = 0;
      },
      _startForNewComps: function _startForNewComps() {
        if (this._deferredComps.length > 0) {
          this._deferredSchedule();
          this.startInvoker.invoke();
        }
      },
      startPhase: function startPhase() {
        this._updating = true;
        this.startInvoker.invoke();
        this._startForNewComps();
      },
      updatePhase: function updatePhase(dt) {
        this.updateInvoker.invoke(dt);
      },
      lateUpdatePhase: function lateUpdatePhase(dt) {
        this.lateUpdateInvoker.invoke(dt);
        this._updating = false;
        this._startForNewComps();
      }
    });
    module.exports = ComponentScheduler;
  }), {
    "./platform/CCClass": 138,
    "./platform/CCObject": 144,
    "./platform/js": 158,
    "./utils/misc": 209
  } ],
  89: [ (function(require, module, exports) {
    "use strict";
    var AnimationAnimator = require("../../animation/animation-animator");
    var AnimationClip = require("../../animation/animation-clip");
    var EventTarget = require("../event/event-target");
    var js = require("../platform/js");
    var equalClips = function(clip1, clip2) {
      return clip1 === clip2;
    };
    var EventType = cc.Enum({
      PLAY: "play",
      STOP: "stop",
      PAUSE: "pause",
      RESUME: "resume",
      LASTFRAME: "lastframe",
      FINISHED: "finished"
    });
    var Animation = cc.Class({
      name: "cc.Animation",
      extends: require("./CCComponent"),
      mixins: [ EventTarget ],
      editor: false,
      statics: {
        EventType: EventType
      },
      ctor: function ctor() {
        cc.EventTarget.call(this);
        this._animator = null;
        this._nameToState = js.createMap(true);
        this._didInit = false;
        this._currentClip = null;
      },
      properties: {
        _defaultClip: {
          default: null,
          type: AnimationClip
        },
        defaultClip: {
          type: AnimationClip,
          get: function get() {
            return this._defaultClip;
          },
          set: function set(value) {
            true;
            return;
          },
          tooltip: false
        },
        currentClip: {
          get: function get() {
            return this._currentClip;
          },
          set: function set(value) {
            this._currentClip = value;
          },
          type: AnimationClip,
          visible: false
        },
        _writableClips: {
          get: function get() {
            return this._clips;
          },
          set: function set(val) {
            this._didInit = false;
            this._clips = val;
            this._init();
          },
          type: [ AnimationClip ]
        },
        _clips: {
          default: [],
          type: [ AnimationClip ],
          tooltip: false,
          visible: true
        },
        playOnLoad: {
          default: false,
          tooltip: false
        }
      },
      start: function start() {
        if ((true, this.playOnLoad) && this._defaultClip) {
          var isPlaying = this._animator && this._animator.isPlaying;
          if (!isPlaying) {
            var state = this.getAnimationState(this._defaultClip.name);
            this._animator.playState(state);
          }
        }
      },
      onEnable: function onEnable() {
        this._animator && this._animator.resume();
      },
      onDisable: function onDisable() {
        this._animator && this._animator.pause();
      },
      onDestroy: function onDestroy() {
        this.stop();
      },
      getClips: function getClips() {
        return this._clips;
      },
      play: function play(name, startTime) {
        var state = this.playAdditive(name, startTime);
        this._animator.stopStatesExcept(state);
        return state;
      },
      playAdditive: function playAdditive(name, startTime) {
        this._init();
        var state = this.getAnimationState(name || this._defaultClip && this._defaultClip.name);
        if (state) {
          this.enabled = true;
          var animator = this._animator;
          if (animator.isPlaying && state.isPlaying) if (state.isPaused) animator.resumeState(state); else {
            animator.stopState(state);
            animator.playState(state, startTime);
          } else animator.playState(state, startTime);
          this.enabledInHierarchy || animator.pause();
          this.currentClip = state.clip;
        }
        return state;
      },
      stop: function stop(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.stopState(state);
        } else this._animator.stop();
      },
      pause: function pause(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.pauseState(state);
        } else this.enabled = false;
      },
      resume: function resume(name) {
        if (!this._didInit) return;
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.resumeState(state);
        } else this.enabled = true;
      },
      setCurrentTime: function setCurrentTime(time, name) {
        this._init();
        if (name) {
          var state = this._nameToState[name];
          state && this._animator.setStateTime(state, time);
        } else this._animator.setStateTime(time);
      },
      getAnimationState: function getAnimationState(name) {
        this._init();
        var state = this._nameToState[name];
        false;
        state && !state.curveLoaded && this._animator._reloadClip(state);
        return state || null;
      },
      addClip: function addClip(clip, newName) {
        if (!clip) {
          cc.warnID(3900);
          return;
        }
        this._init();
        cc.js.array.contains(this._clips, clip) || this._clips.push(clip);
        newName = newName || clip.name;
        var oldState = this._nameToState[newName];
        if (oldState) {
          if (oldState.clip === clip) return oldState;
          var index = this._clips.indexOf(oldState.clip);
          -1 !== index && this._clips.splice(index, 1);
        }
        var newState = new cc.AnimationState(clip, newName);
        this._nameToState[newName] = newState;
        return newState;
      },
      removeClip: function removeClip(clip, force) {
        if (!clip) {
          cc.warnID(3901);
          return;
        }
        this._init();
        var state;
        for (var name in this._nameToState) {
          state = this._nameToState[name];
          if (equalClips(state.clip, clip)) break;
        }
        if (clip === this._defaultClip) {
          if (!force) {
            true;
            cc.warnID(3902);
            return;
          }
          this._defaultClip = null;
        }
        if (state && state.isPlaying) {
          if (!force) {
            true;
            cc.warnID(3903);
            return;
          }
          this.stop(state.name);
        }
        this._clips = this._clips.filter((function(item) {
          return !equalClips(item, clip);
        }));
        state && delete this._nameToState[state.name];
      },
      sample: function sample(name) {
        this._init();
        if (name) {
          var state = this._nameToState[name];
          state && state.sample();
        } else this._animator.sample();
      },
      on: function on(type, callback, target, useCapture) {
        this._init();
        var ret = this._EventTargetOn(type, callback, target, useCapture);
        if ("lastframe" === type) {
          var states = this._nameToState;
          for (var name in states) states[name]._lastframeEventOn = true;
        }
        return ret;
      },
      off: function off(type, callback, target, useCapture) {
        this._init();
        if ("lastframe" === type) {
          var states = this._nameToState;
          for (var name in states) states[name]._lastframeEventOn = false;
        }
        this._EventTargetOff(type, callback, target, useCapture);
      },
      _init: function _init() {
        if (this._didInit) return;
        this._didInit = true;
        this._animator = new AnimationAnimator(this.node, this);
        this._createStates();
      },
      _createStates: function _createStates() {
        this._nameToState = js.createMap(true);
        var state = null;
        var defaultClipState = false;
        for (var i = 0; i < this._clips.length; ++i) {
          var clip = this._clips[i];
          if (clip) {
            state = new cc.AnimationState(clip);
            false;
            this._nameToState[state.name] = state;
            equalClips(this._defaultClip, clip) && (defaultClipState = state);
          }
        }
        if (this._defaultClip && !defaultClipState) {
          state = new cc.AnimationState(this._defaultClip);
          false;
          this._nameToState[state.name] = state;
        }
      }
    });
    Animation.prototype._EventTargetOn = EventTarget.prototype.on;
    Animation.prototype._EventTargetOff = EventTarget.prototype.off;
    cc.Animation = module.exports = Animation;
  }), {
    "../../animation/animation-animator": 10,
    "../../animation/animation-clip": 11,
    "../event/event-target": 121,
    "../platform/js": 158,
    "./CCComponent": 94
  } ],
  90: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var AudioClip = require("../assets/CCAudioClip");
    var AudioSource = cc.Class({
      name: "cc.AudioSource",
      extends: Component,
      editor: false,
      ctor: function ctor() {
        this.audio = new cc._Audio();
      },
      properties: {
        _clip: {
          default: null,
          type: AudioClip
        },
        _volume: 1,
        _mute: false,
        _loop: false,
        _pausedFlag: {
          default: false,
          serializable: false
        },
        isPlaying: {
          get: function get() {
            var state = this.audio.getState();
            return state === cc._Audio.State.PLAYING;
          },
          visible: false
        },
        clip: {
          get: function get() {
            return this._clip;
          },
          set: function set(value) {
            if (value === this._clip) return;
            if (!(value instanceof AudioClip)) return cc.error("Wrong type of AudioClip.");
            this._clip = value;
            this.audio.stop();
            this.preload && (this.audio.src = this._clip);
          },
          type: AudioClip,
          tooltip: false,
          animatable: false
        },
        volume: {
          get: function get() {
            return this._volume;
          },
          set: function set(value) {
            value = misc.clamp01(value);
            this._volume = value;
            this._mute || this.audio.setVolume(value);
            return value;
          },
          tooltip: false
        },
        mute: {
          get: function get() {
            return this._mute;
          },
          set: function set(value) {
            this._mute = value;
            this.audio.setVolume(value ? 0 : this._volume);
            return value;
          },
          animatable: false,
          tooltip: false
        },
        loop: {
          get: function get() {
            return this._loop;
          },
          set: function set(value) {
            this._loop = value;
            this.audio.setLoop(value);
            return value;
          },
          animatable: false,
          tooltip: false
        },
        playOnLoad: {
          default: false,
          tooltip: false,
          animatable: false
        },
        preload: {
          default: false,
          animatable: false
        }
      },
      _ensureDataLoaded: function _ensureDataLoaded() {
        this.audio.src !== this._clip && (this.audio.src = this._clip);
      },
      _pausedCallback: function _pausedCallback() {
        var state = this.audio.getState();
        if (state === cc._Audio.State.PLAYING) {
          this.audio.pause();
          this._pausedFlag = true;
        }
      },
      _restoreCallback: function _restoreCallback() {
        this._pausedFlag && this.audio.resume();
        this._pausedFlag = false;
      },
      onLoad: function onLoad() {
        this.audio.setVolume(this._mute ? 0 : this._volume);
        this.audio.setLoop(this._loop);
      },
      onEnable: function onEnable() {
        this.preload && (this.audio.src = this._clip);
        this.playOnLoad && this.play();
        cc.game.on(cc.game.EVENT_HIDE, this._pausedCallback, this);
        cc.game.on(cc.game.EVENT_SHOW, this._restoreCallback, this);
      },
      onDisable: function onDisable() {
        this.stop();
        cc.game.off(cc.game.EVENT_HIDE, this._pausedCallback, this);
        cc.game.off(cc.game.EVENT_SHOW, this._restoreCallback, this);
      },
      onDestroy: function onDestroy() {
        this.stop();
        this.audio.destroy();
        cc.audioEngine.uncache(this._clip);
      },
      play: function play() {
        if (!this._clip) return;
        var audio = this.audio;
        this._clip.loaded && audio.stop();
        this._ensureDataLoaded();
        audio.setCurrentTime(0);
        audio.play();
      },
      stop: function stop() {
        this.audio.stop();
      },
      pause: function pause() {
        this.audio.pause();
      },
      resume: function resume() {
        this._ensureDataLoaded();
        this.audio.resume();
      },
      rewind: function rewind() {
        this.audio.setCurrentTime(0);
      },
      getCurrentTime: function getCurrentTime() {
        return this.audio.getCurrentTime();
      },
      setCurrentTime: function setCurrentTime(time) {
        this.audio.setCurrentTime(time);
        return time;
      },
      getDuration: function getDuration() {
        return this.audio.getDuration();
      }
    });
    cc.AudioSource = module.exports = AudioSource;
  }), {
    "../assets/CCAudioClip": 60,
    "../utils/misc": 209,
    "./CCComponent": 94
  } ],
  91: [ (function(require, module, exports) {
    "use strict";
    var BlockEvents = [ "touchstart", "touchmove", "touchend", "mousedown", "mousemove", "mouseup", "mouseenter", "mouseleave", "mousewheel" ];
    function stopPropagation(event) {
      event.stopPropagation();
    }
    var BlockInputEvents = cc.Class({
      name: "cc.BlockInputEvents",
      extends: require("./CCComponent"),
      editor: {
        menu: "i18n:MAIN_MENU.component.ui/Block Input Events",
        inspector: "packages://inspector/inspectors/comps/block-input-events.js",
        help: "i18n:COMPONENT.help_url.block_input_events"
      },
      onEnable: function onEnable() {
        for (var i = 0; i < BlockEvents.length; i++) this.node.on(BlockEvents[i], stopPropagation, this);
      },
      onDisable: function onDisable() {
        for (var i = 0; i < BlockEvents.length; i++) this.node.off(BlockEvents[i], stopPropagation, this);
      }
    });
    cc.BlockInputEvents = module.exports = BlockInputEvents;
  }), {
    "./CCComponent": 94
  } ],
  92: [ (function(require, module, exports) {
    "use strict";
    var Component = require("./CCComponent");
    var GraySpriteState = require("../utils/gray-sprite-state");
    var Transition = cc.Enum({
      NONE: 0,
      COLOR: 1,
      SPRITE: 2,
      SCALE: 3
    });
    var State = cc.Enum({
      NORMAL: 0,
      HOVER: 1,
      PRESSED: 2,
      DISABLED: 3
    });
    var Button = cc.Class({
      name: "cc.Button",
      extends: Component,
      mixins: [ GraySpriteState ],
      ctor: function ctor() {
        this._pressed = false;
        this._hovered = false;
        this._fromColor = null;
        this._toColor = null;
        this._time = 0;
        this._transitionFinished = true;
        this._fromScale = cc.Vec2.ZERO;
        this._toScale = cc.Vec2.ZERO;
        this._originalScale = null;
        this._graySpriteMaterial = null;
        this._spriteMaterial = null;
        this._sprite = null;
      },
      editor: false,
      properties: {
        interactable: {
          default: true,
          tooltip: false,
          notify: function notify() {
            this._updateState();
            this.interactable || this._resetState();
          },
          animatable: false
        },
        _resizeToTarget: {
          animatable: false,
          set: function set(value) {
            value && this._resizeNodeToTargetNode();
          }
        },
        enableAutoGrayEffect: {
          default: false,
          tooltip: false,
          notify: function notify() {
            this._updateDisabledState(true);
          }
        },
        transition: {
          default: Transition.NONE,
          tooltip: false,
          type: Transition,
          animatable: false,
          notify: function notify(oldValue) {
            this._updateTransition(oldValue);
          },
          formerlySerializedAs: "transition"
        },
        normalColor: {
          default: cc.Color.WHITE,
          displayName: "Normal",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.NORMAL && (this._getTarget().opacity = this.normalColor.a);
            this._updateState();
          }
        },
        pressedColor: {
          default: cc.color(211, 211, 211),
          displayName: "Pressed",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.PRESSED && (this._getTarget().opacity = this.pressedColor.a);
            this._updateState();
          },
          formerlySerializedAs: "pressedColor"
        },
        hoverColor: {
          default: cc.Color.WHITE,
          displayName: "Hover",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.HOVER && (this._getTarget().opacity = this.hoverColor.a);
            this._updateState();
          },
          formerlySerializedAs: "hoverColor"
        },
        disabledColor: {
          default: cc.color(124, 124, 124),
          displayName: "Disabled",
          tooltip: false,
          notify: function notify() {
            this.transition === Transition.Color && this._getButtonState() === State.DISABLED && (this._getTarget().opacity = this.disabledColor.a);
            this._updateState();
          }
        },
        duration: {
          default: .1,
          range: [ 0, 10 ],
          tooltip: false
        },
        zoomScale: {
          default: 1.2,
          tooltip: false
        },
        normalSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Normal",
          tooltip: false,
          notify: function notify() {
            this._updateState();
          }
        },
        pressedSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Pressed",
          tooltip: false,
          formerlySerializedAs: "pressedSprite",
          notify: function notify() {
            this._updateState();
          }
        },
        hoverSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Hover",
          tooltip: false,
          formerlySerializedAs: "hoverSprite",
          notify: function notify() {
            this._updateState();
          }
        },
        disabledSprite: {
          default: null,
          type: cc.SpriteFrame,
          displayName: "Disabled",
          tooltip: false,
          notify: function notify() {
            this._updateState();
          }
        },
        target: {
          default: null,
          type: cc.Node,
          tooltip: false,
          notify: function notify(oldValue) {
            this._applyTarget();
            oldValue && this.target !== oldValue && this._unregisterTargetEvent(oldValue);
          }
        },
        clickEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        Transition: Transition
      },
      __preload: function __preload() {
        this._applyTarget();
        this._resetState();
      },
      _resetState: function _resetState() {
        this._pressed = false;
        this._hovered = false;
        var target = this._getTarget();
        var transition = this.transition;
        var originalScale = this._originalScale;
        transition === Transition.COLOR && this.interactable ? this._setTargetColor(this.normalColor) : transition === Transition.SCALE && originalScale && target.setScale(originalScale.x, originalScale.y);
        this._transitionFinished = true;
      },
      onEnable: function onEnable() {
        this.normalSprite && this.normalSprite.ensureLoadTexture();
        this.hoverSprite && this.hoverSprite.ensureLoadTexture();
        this.pressedSprite && this.pressedSprite.ensureLoadTexture();
        this.disabledSprite && this.disabledSprite.ensureLoadTexture();
        true;
        this._registerNodeEvent();
        this._updateState();
      },
      onDisable: function onDisable() {
        this._resetState();
        true;
        this._unregisterNodeEvent();
      },
      _getTarget: function _getTarget() {
        return this.target ? this.target : this.node;
      },
      _onTargetSpriteFrameChanged: function _onTargetSpriteFrameChanged(comp) {
        this.transition === Transition.SPRITE && this._setCurrentStateSprite(comp.spriteFrame);
      },
      _onTargetColorChanged: function _onTargetColorChanged(color) {
        this.transition === Transition.COLOR && this._setCurrentStateColor(color);
      },
      _onTargetScaleChanged: function _onTargetScaleChanged() {
        var target = this._getTarget();
        if (this._originalScale && (this.transition !== Transition.SCALE || this._transitionFinished)) {
          this._originalScale.x = target.scaleX;
          this._originalScale.y = target.scaleY;
        }
      },
      _setTargetColor: function _setTargetColor(color) {
        var target = this._getTarget();
        var cloneColor = color.clone();
        target.opacity = cloneColor.a;
        cloneColor.a = 255;
        target.color = cloneColor;
      },
      _getStateColor: function _getStateColor(state) {
        switch (state) {
         case State.NORMAL:
          return this.normalColor;

         case State.HOVER:
          return this.hoverColor;

         case State.PRESSED:
          return this.pressedColor;

         case State.DISABLED:
          return this.disabledColor;
        }
      },
      _getStateSprite: function _getStateSprite(state) {
        switch (state) {
         case State.NORMAL:
          return this.normalSprite;

         case State.HOVER:
          return this.hoverSprite;

         case State.PRESSED:
          return this.pressedSprite;

         case State.DISABLED:
          return this.disabledSprite;
        }
      },
      _setCurrentStateColor: function _setCurrentStateColor(color) {
        switch (this._getButtonState()) {
         case State.NORMAL:
          this.normalColor = color;
          break;

         case State.HOVER:
          this.hoverColor = color;
          break;

         case State.PRESSED:
          this.pressedColor = color;
          break;

         case State.DISABLED:
          this.disabledColor = color;
        }
      },
      _setCurrentStateSprite: function _setCurrentStateSprite(spriteFrame) {
        switch (this._getButtonState()) {
         case State.NORMAL:
          this.normalSprite = spriteFrame;
          break;

         case State.HOVER:
          this.hoverSprite = spriteFrame;
          break;

         case State.PRESSED:
          this.pressedSprite = spriteFrame;
          break;

         case State.DISABLED:
          this.disabledSprite = spriteFrame;
        }
      },
      update: function update(dt) {
        var target = this._getTarget();
        if (this._transitionFinished) return;
        if (this.transition !== Transition.COLOR && this.transition !== Transition.SCALE) return;
        this.time += dt;
        var ratio = 1;
        this.duration > 0 && (ratio = this.time / this.duration);
        ratio >= 1 && (ratio = 1);
        if (this.transition === Transition.COLOR) {
          var color = this._fromColor.lerp(this._toColor, ratio);
          this._setTargetColor(color);
        } else this.transition === Transition.SCALE && this._originalScale && (target.scale = this._fromScale.lerp(this._toScale, ratio));
        1 === ratio && (this._transitionFinished = true);
      },
      _registerNodeEvent: function _registerNodeEvent() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.node.on(cc.Node.EventType.MOUSE_ENTER, this._onMouseMoveIn, this);
        this.node.on(cc.Node.EventType.MOUSE_LEAVE, this._onMouseMoveOut, this);
      },
      _unregisterNodeEvent: function _unregisterNodeEvent() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        this.node.off(cc.Node.EventType.MOUSE_ENTER, this._onMouseMoveIn, this);
        this.node.off(cc.Node.EventType.MOUSE_LEAVE, this._onMouseMoveOut, this);
      },
      _registerTargetEvent: function _registerTargetEvent(target) {
        false;
        target.on(cc.Node.EventType.SCALE_CHANGED, this._onTargetScaleChanged, this);
      },
      _unregisterTargetEvent: function _unregisterTargetEvent(target) {
        false;
        target.off(cc.Node.EventType.SCALE_CHANGED, this._onTargetScaleChanged, this);
      },
      _getTargetSprite: function _getTargetSprite(target) {
        var sprite = null;
        target && (sprite = target.getComponent(cc.Sprite));
        return sprite;
      },
      _applyTarget: function _applyTarget() {
        var target = this._getTarget();
        this._sprite = this._getTargetSprite(target);
        this._originalScale || (this._originalScale = cc.Vec2.ZERO);
        this._originalScale.x = target.scaleX;
        this._originalScale.y = target.scaleY;
        this._registerTargetEvent(target);
      },
      _onTouchBegan: function _onTouchBegan(event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
        this._pressed = true;
        this._updateState();
        event.stopPropagation();
      },
      _onTouchMove: function _onTouchMove(event) {
        if (!this.interactable || !this.enabledInHierarchy || !this._pressed) return;
        var touch = event.touch;
        var hit = this.node._hitTest(touch.getLocation());
        var target = this._getTarget();
        var originalScale = this._originalScale;
        if (this.transition === Transition.SCALE && originalScale) if (hit) {
          this._fromScale.x = originalScale.x;
          this._fromScale.y = originalScale.y;
          this._toScale.x = originalScale.x * this.zoomScale;
          this._toScale.y = originalScale.y * this.zoomScale;
          this._transitionFinished = false;
        } else {
          this.time = 0;
          this._transitionFinished = true;
          target.setScale(originalScale.x, originalScale.y);
        } else {
          var state;
          state = hit ? State.PRESSED : State.NORMAL;
          this._applyTransition(state);
        }
        event.stopPropagation();
      },
      _onTouchEnded: function _onTouchEnded(event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
        if (this._pressed) {
          cc.Component.EventHandler.emitEvents(this.clickEvents, event);
          this.node.emit("click", this);
        }
        this._pressed = false;
        this._updateState();
        event.stopPropagation();
      },
      _onTouchCancel: function _onTouchCancel() {
        if (!this.interactable || !this.enabledInHierarchy) return;
        this._pressed = false;
        this._updateState();
      },
      _onMouseMoveIn: function _onMouseMoveIn() {
        if (this._pressed || !this.interactable || !this.enabledInHierarchy) return;
        if (this.transition === Transition.SPRITE && !this.hoverSprite) return;
        if (!this._hovered) {
          this._hovered = true;
          this._updateState();
        }
      },
      _onMouseMoveOut: function _onMouseMoveOut() {
        if (this._hovered) {
          this._hovered = false;
          this._updateState();
        }
      },
      _updateState: function _updateState() {
        var state = this._getButtonState();
        this._applyTransition(state);
        this._updateDisabledState();
      },
      _getButtonState: function _getButtonState() {
        var state;
        state = this.interactable ? this._pressed ? State.PRESSED : this._hovered ? State.HOVER : State.NORMAL : State.DISABLED;
        return state;
      },
      _updateColorTransitionImmediately: function _updateColorTransitionImmediately(state) {
        var color = this._getStateColor(state);
        this._setTargetColor(color);
        this._fromColor = color.clone();
        this._toColor = color;
      },
      _updateColorTransition: function _updateColorTransition(state) {
        if (false, state === State.DISABLED) this._updateColorTransitionImmediately(state); else {
          var target = this._getTarget();
          var color = this._getStateColor(state);
          this._fromColor = target.color.clone();
          this._toColor = color;
          this.time = 0;
          this._transitionFinished = false;
        }
      },
      _updateSpriteTransition: function _updateSpriteTransition(state) {
        var sprite = this._getStateSprite(state);
        this._sprite && sprite && (this._sprite.spriteFrame = sprite);
      },
      _updateScaleTransition: function _updateScaleTransition(state) {
        state === State.PRESSED ? this._zoomUp() : this._zoomBack();
      },
      _zoomUp: function _zoomUp() {
        if (!this._originalScale) return;
        this._fromScale.x = this._originalScale.x;
        this._fromScale.y = this._originalScale.y;
        this._toScale.x = this._originalScale.x * this.zoomScale;
        this._toScale.y = this._originalScale.y * this.zoomScale;
        this.time = 0;
        this._transitionFinished = false;
      },
      _zoomBack: function _zoomBack() {
        if (!this._originalScale) return;
        var target = this._getTarget();
        this._fromScale.x = target.scaleX;
        this._fromScale.y = target.scaleY;
        this._toScale.x = this._originalScale.x;
        this._toScale.y = this._originalScale.y;
        this.time = 0;
        this._transitionFinished = false;
      },
      _updateTransition: function _updateTransition(oldTransition) {
        oldTransition === Transition.COLOR ? this._updateColorTransitionImmediately(State.NORMAL) : oldTransition === Transition.SPRITE && this._updateSpriteTransition(State.NORMAL);
        this._updateState();
      },
      _applyTransition: function _applyTransition(state) {
        var transition = this.transition;
        transition === Transition.COLOR ? this._updateColorTransition(state) : transition === Transition.SPRITE ? this._updateSpriteTransition(state) : transition === Transition.SCALE && this._updateScaleTransition(state);
      },
      _resizeNodeToTargetNode: false,
      _updateDisabledState: function _updateDisabledState(force) {
        if (!this._sprite) return;
        if (this.enableAutoGrayEffect || force) {
          var useGrayMaterial = false;
          this.transition === Transition.SPRITE && this.disabledSprite || (useGrayMaterial = this.enableAutoGrayEffect && !this.interactable);
          this._switchGrayMaterial(useGrayMaterial, this._sprite);
        }
      }
    });
    cc.Button = module.exports = Button;
  }), {
    "../utils/gray-sprite-state": 206,
    "./CCComponent": 94
  } ],
  93: [ (function(require, module, exports) {
    "use strict";
    var Camera = require("../camera/CCCamera");
    var Component = require("./CCComponent");
    function resetWidgetComponent(canvas) {
      var widget = canvas.node.getComponent(cc.Widget);
      widget || (widget = canvas.node.addComponent(cc.Widget));
      widget.isAlignTop = true;
      widget.isAlignBottom = true;
      widget.isAlignLeft = true;
      widget.isAlignRight = true;
      widget.top = 0;
      widget.bottom = 0;
      widget.left = 0;
      widget.right = 0;
    }
    var Canvas = cc.Class({
      name: "cc.Canvas",
      extends: Component,
      editor: false,
      resetInEditor: false,
      statics: {
        instance: null
      },
      properties: {
        _designResolution: cc.size(960, 640),
        designResolution: {
          get: function get() {
            return cc.size(this._designResolution);
          },
          set: function set(value) {
            this._designResolution.width = value.width;
            this._designResolution.height = value.height;
            this.applySettings();
          },
          tooltip: false
        },
        _fitWidth: false,
        _fitHeight: true,
        fitHeight: {
          get: function get() {
            return this._fitHeight;
          },
          set: function set(value) {
            if (this._fitHeight !== value) {
              this._fitHeight = value;
              this.applySettings();
            }
          },
          tooltip: false
        },
        fitWidth: {
          get: function get() {
            return this._fitWidth;
          },
          set: function set(value) {
            if (this._fitWidth !== value) {
              this._fitWidth = value;
              this.applySettings();
            }
          },
          tooltip: false
        }
      },
      _fitDesignResolution: false,
      __preload: function __preload() {
        var Flags;
        false;
        if (Canvas.instance) return cc.warnID(6700, this.node.name, Canvas.instance.node.name);
        Canvas.instance = this;
        this.applySettings();
        var widget = this.getComponent(cc.Widget);
        !!widget && widget.updateAlignment();
        false;
      },
      start: function start() {
        if (!Camera.main && cc.game.renderType !== cc.game.RENDER_TYPE_CANVAS) {
          var cameraNode = new cc.Node("Main Camera");
          cameraNode.parent = this.node;
          cameraNode.setSiblingIndex(0);
          var camera = cameraNode.addComponent(Camera);
          var ClearFlags = Camera.ClearFlags;
          camera.clearFlags = ClearFlags.COLOR | ClearFlags.DEPTH | ClearFlags.STENCIL;
          camera.depth = -1;
        }
      },
      onDestroy: function onDestroy() {
        false;
        Canvas.instance === this && (Canvas.instance = null);
      },
      applySettings: function applySettings() {
        var ResolutionPolicy = cc.ResolutionPolicy;
        var policy;
        policy = this.fitHeight && this.fitWidth ? ResolutionPolicy.SHOW_ALL : this.fitHeight || this.fitWidth ? this.fitWidth ? ResolutionPolicy.FIXED_WIDTH : ResolutionPolicy.FIXED_HEIGHT : ResolutionPolicy.NO_BORDER;
        var designRes = this._designResolution;
        false;
        cc.view.setDesignResolutionSize(designRes.width, designRes.height, policy);
      }
    });
    cc.Canvas = module.exports = Canvas;
  }), {
    "../camera/CCCamera": 87,
    "./CCComponent": 94
  } ],
  94: [ (function(require, module, exports) {
    "use strict";
    var CCObject = require("../platform/CCObject");
    var js = require("../platform/js");
    var idGenerater = new (require("../platform/id-generater"))("Comp");
    var IsOnEnableCalled = CCObject.Flags.IsOnEnableCalled;
    var IsOnLoadCalled = CCObject.Flags.IsOnLoadCalled;
    var ActionManagerExist = !!cc.ActionManager;
    var Component = cc.Class({
      name: "cc.Component",
      extends: CCObject,
      ctor: function() {
        this._id = idGenerater.getNewId();
        this.__eventTargets = [];
      },
      properties: {
        node: {
          default: null,
          visible: false
        },
        name: {
          get: function get() {
            if (this._name) return this._name;
            var className = cc.js.getClassName(this);
            var trimLeft = className.lastIndexOf(".");
            trimLeft >= 0 && (className = className.slice(trimLeft + 1));
            return this.node.name + "<" + className + ">";
          },
          set: function set(value) {
            this._name = value;
          },
          visible: false
        },
        uuid: {
          get: function get() {
            return this._id;
          },
          visible: false
        },
        __scriptAsset: false,
        _enabled: true,
        enabled: {
          get: function get() {
            return this._enabled;
          },
          set: function set(value) {
            if (this._enabled !== value) {
              this._enabled = value;
              if (this.node._activeInHierarchy) {
                var compScheduler = cc.director._compScheduler;
                value ? compScheduler.enableComp(this) : compScheduler.disableComp(this);
              }
            }
          },
          visible: false,
          animatable: true
        },
        enabledInHierarchy: {
          get: function get() {
            return this._enabled && this.node._activeInHierarchy;
          },
          visible: false
        },
        _isOnLoadCalled: {
          get: function get() {
            return this._objFlags & IsOnLoadCalled;
          }
        }
      },
      update: null,
      lateUpdate: null,
      __preload: null,
      onLoad: null,
      start: null,
      onEnable: null,
      onDisable: null,
      onDestroy: null,
      onFocusInEditor: null,
      onLostFocusInEditor: null,
      resetInEditor: null,
      addComponent: function addComponent(typeOrClassName) {
        return this.node.addComponent(typeOrClassName);
      },
      getComponent: function getComponent(typeOrClassName) {
        return this.node.getComponent(typeOrClassName);
      },
      getComponents: function getComponents(typeOrClassName) {
        return this.node.getComponents(typeOrClassName);
      },
      getComponentInChildren: function getComponentInChildren(typeOrClassName) {
        return this.node.getComponentInChildren(typeOrClassName);
      },
      getComponentsInChildren: function getComponentsInChildren(typeOrClassName) {
        return this.node.getComponentsInChildren(typeOrClassName);
      },
      _getLocalBounds: null,
      onRestore: null,
      destroy: function destroy() {
        var depend;
        false;
        this._super() && this._enabled && this.node._activeInHierarchy && cc.director._compScheduler.disableComp(this);
      },
      _onPreDestroy: function _onPreDestroy() {
        ActionManagerExist && cc.director.getActionManager().removeAllActionsFromTarget(this);
        this.unscheduleAllCallbacks();
        var eventTargets = this.__eventTargets;
        for (var i = eventTargets.length - 1; i >= 0; --i) {
          var target = eventTargets[i];
          target && target.targetOff(this);
        }
        eventTargets.length = 0;
        false;
        cc.director._nodeActivator.destroyComp(this);
        this.node._removeComponent(this);
      },
      _instantiate: function _instantiate(cloned) {
        cloned || (cloned = cc.instantiate._clone(this, this));
        cloned.node = null;
        return cloned;
      },
      schedule: function schedule(callback, interval, repeat, delay) {
        cc.assertID(callback, 1619);
        interval = interval || 0;
        cc.assertID(interval >= 0, 1620);
        repeat = isNaN(repeat) ? cc.macro.REPEAT_FOREVER : repeat;
        delay = delay || 0;
        var scheduler = cc.director.getScheduler();
        var paused = scheduler.isTargetPaused(this);
        scheduler.schedule(callback, this, interval, repeat, delay, paused);
      },
      scheduleOnce: function scheduleOnce(callback, delay) {
        this.schedule(callback, 0, 0, delay);
      },
      unschedule: function unschedule(callback_fn) {
        if (!callback_fn) return;
        cc.director.getScheduler().unschedule(callback_fn, this);
      },
      unscheduleAllCallbacks: function unscheduleAllCallbacks() {
        cc.director.getScheduler().unscheduleAllForTarget(this);
      }
    });
    Component._requireComponent = null;
    Component._executionOrder = 0;
    false;
    false, false;
    js.value(Component, "_registerEditorProps", (function(cls, props) {
      var reqComp = props.requireComponent;
      reqComp && (cls._requireComponent = reqComp);
      var order = props.executionOrder;
      order && "number" === typeof order && (cls._executionOrder = order);
      (false, false) && "disallowMultiple" in props && (cls._disallowMultiple = cls);
      var name;
      var key;
      var val;
      var willExecuteInEditMode;
      false, false;
    }));
    Component.prototype.__scriptUuid = "";
    cc.Component = module.exports = Component;
  }), {
    "../platform/CCObject": 144,
    "../platform/id-generater": 154,
    "../platform/js": 158
  } ],
  95: [ (function(require, module, exports) {
    "use strict";
    cc.Component.EventHandler = cc.Class({
      name: "cc.ClickEvent",
      properties: {
        target: {
          default: null,
          type: cc.Node
        },
        component: "",
        _componentId: "",
        _componentName: {
          get: function get() {
            this._genCompIdIfNeeded();
            return this._compId2Name(this._componentId);
          },
          set: function set(value) {
            this._componentId = this._compName2Id(value);
          }
        },
        handler: {
          default: ""
        },
        customEventData: {
          default: ""
        }
      },
      statics: {
        emitEvents: function emitEvents(events) {
          var args;
          if (arguments.length > 0) {
            args = new Array(arguments.length - 1);
            for (var i = 0, l = args.length; i < l; i++) args[i] = arguments[i + 1];
          }
          for (var _i = 0, _l = events.length; _i < _l; _i++) {
            var event = events[_i];
            if (!(event instanceof cc.Component.EventHandler)) continue;
            event.emit(args);
          }
        }
      },
      emit: function emit(params) {
        var target = this.target;
        if (!cc.isValid(target)) return;
        this._genCompIdIfNeeded();
        var compType = cc.js._getClassById(this._componentId);
        var comp = target.getComponent(compType);
        if (!cc.isValid(comp)) return;
        var handler = comp[this.handler];
        if ("function" !== typeof handler) return;
        if (null != this.customEventData && "" !== this.customEventData) {
          params = params.slice();
          params.push(this.customEventData);
        }
        handler.apply(comp, params);
      },
      _compName2Id: function _compName2Id(compName) {
        var comp = cc.js.getClassByName(compName);
        return cc.js._getClassId(comp);
      },
      _compId2Name: function _compId2Name(compId) {
        var comp = cc.js._getClassById(compId);
        return cc.js.getClassName(comp);
      },
      _genCompIdIfNeeded: function _genCompIdIfNeeded() {
        if (!this._componentId) {
          this._componentName = this.component;
          this.component = "";
        }
      }
    });
  }), {} ],
  96: [ (function(require, module, exports) {
    "use strict";
    var macro = require("../platform/CCMacro");
    var RenderComponent = require("./CCRenderComponent");
    var Material = require("../assets/material/CCMaterial");
    var LabelFrame = require("../renderer/utils/label/label-frame");
    var BlendFunc = require("../utils/blend-func");
    var HorizontalAlign = macro.TextAlignment;
    var VerticalAlign = macro.VerticalTextAlignment;
    var Overflow = cc.Enum({
      NONE: 0,
      CLAMP: 1,
      SHRINK: 2,
      RESIZE_HEIGHT: 3
    });
    var CacheMode = cc.Enum({
      NONE: 0,
      BITMAP: 1,
      CHAR: 2
    });
    var BOLD_FLAG = 1;
    var ITALIC_FLAG = 2;
    var UNDERLINE_FLAG = 4;
    var Label = cc.Class({
      name: "cc.Label",
      extends: RenderComponent,
      mixins: [ BlendFunc ],
      ctor: function ctor() {
        false;
        this._actualFontSize = 0;
        this._assemblerData = null;
        this._frame = null;
        this._ttfTexture = null;
        this._letterTexture = null;
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS ? this._updateMaterial = this._updateMaterialCanvas : this._updateMaterial = this._updateMaterialWebgl;
      },
      editor: false,
      properties: {
        _useOriginalSize: true,
        _string: {
          default: "",
          formerlySerializedAs: "_N$string"
        },
        string: {
          get: function get() {
            return this._string;
          },
          set: function set(value) {
            var oldValue = this._string;
            this._string = "" + value;
            this.string !== oldValue && this.setVertsDirty();
            this._checkStringEmpty();
          },
          multiline: true,
          tooltip: false
        },
        horizontalAlign: {
          default: HorizontalAlign.LEFT,
          type: HorizontalAlign,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.horizontalAlign === oldValue) return;
            this.setVertsDirty();
          },
          animatable: false
        },
        verticalAlign: {
          default: VerticalAlign.TOP,
          type: VerticalAlign,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.verticalAlign === oldValue) return;
            this.setVertsDirty();
          },
          animatable: false
        },
        actualFontSize: {
          displayName: "Actual Font Size",
          animatable: false,
          readonly: true,
          get: function get() {
            return this._actualFontSize;
          },
          tooltip: false
        },
        _fontSize: 40,
        fontSize: {
          get: function get() {
            return this._fontSize;
          },
          set: function set(value) {
            if (this._fontSize === value) return;
            this._fontSize = value;
            this.setVertsDirty();
          },
          range: [ 0, 512 ],
          tooltip: false
        },
        fontFamily: {
          default: "Arial",
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.fontFamily === oldValue) return;
            this.setVertsDirty();
          },
          animatable: false
        },
        _lineHeight: 40,
        lineHeight: {
          get: function get() {
            return this._lineHeight;
          },
          set: function set(value) {
            if (this._lineHeight === value) return;
            this._lineHeight = value;
            this.setVertsDirty();
          },
          tooltip: false
        },
        overflow: {
          default: Overflow.NONE,
          type: Overflow,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.overflow === oldValue) return;
            this.setVertsDirty();
          },
          animatable: false
        },
        _enableWrapText: true,
        enableWrapText: {
          get: function get() {
            return this._enableWrapText;
          },
          set: function set(value) {
            if (this._enableWrapText === value) return;
            this._enableWrapText = value;
            this.setVertsDirty();
          },
          animatable: false,
          tooltip: false
        },
        _N$file: null,
        font: {
          get: function get() {
            return this._N$file;
          },
          set: function set(value) {
            if (this.font === value) return;
            value || (this._isSystemFontUsed = true);
            false;
            this._N$file = value;
            value && this._isSystemFontUsed && (this._isSystemFontUsed = false);
            if (!this.enabledInHierarchy) return;
            this._forceUpdateRenderData();
          },
          type: cc.Font,
          tooltip: false,
          animatable: false
        },
        _isSystemFontUsed: true,
        useSystemFont: {
          get: function get() {
            return this._isSystemFontUsed;
          },
          set: function set(value) {
            if (this._isSystemFontUsed === value) return;
            this._isSystemFontUsed = !!value;
            false;
            if (value) {
              this.font = null;
              if (!this.enabledInHierarchy) return;
              this._forceUpdateRenderData();
            }
            this.markForValidate();
          },
          animatable: false,
          tooltip: false
        },
        _bmFontOriginalSize: {
          displayName: "BMFont Original Size",
          get: function get() {
            return this._N$file instanceof cc.BitmapFont ? this._N$file.fontSize : -1;
          },
          visible: true,
          animatable: false
        },
        _spacingX: 0,
        spacingX: {
          get: function get() {
            return this._spacingX;
          },
          set: function set(value) {
            this._spacingX = value;
            this.setVertsDirty();
          },
          tooltip: false
        },
        _batchAsBitmap: false,
        cacheMode: {
          default: CacheMode.NONE,
          type: CacheMode,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.cacheMode === oldValue) return;
            oldValue !== CacheMode.BITMAP || this.font instanceof cc.BitmapFont || this._frame && this._frame._resetDynamicAtlasFrame();
            oldValue === CacheMode.CHAR && (this._ttfTexture = null);
            if (!this.enabledInHierarchy) return;
            this._forceUpdateRenderData();
          },
          animatable: false
        },
        _styleFlags: 0,
        enableBold: {
          get: function get() {
            return !!(this._styleFlags & BOLD_FLAG);
          },
          set: function set(value) {
            value ? this._styleFlags |= BOLD_FLAG : this._styleFlags &= ~BOLD_FLAG;
            this.setVertsDirty();
          },
          animatable: false,
          tooltip: false
        },
        enableItalic: {
          get: function get() {
            return !!(this._styleFlags & ITALIC_FLAG);
          },
          set: function set(value) {
            value ? this._styleFlags |= ITALIC_FLAG : this._styleFlags &= ~ITALIC_FLAG;
            this.setVertsDirty();
          },
          animatable: false,
          tooltip: false
        },
        enableUnderline: {
          get: function get() {
            return !!(this._styleFlags & UNDERLINE_FLAG);
          },
          set: function set(value) {
            value ? this._styleFlags |= UNDERLINE_FLAG : this._styleFlags &= ~UNDERLINE_FLAG;
            this.setVertsDirty();
          },
          animatable: false,
          tooltip: false
        },
        _underlineHeight: 0,
        underlineHeight: {
          get: function get() {
            return this._underlineHeight;
          },
          set: function set(value) {
            if (this._underlineHeight === value) return;
            this._underlineHeight = value;
            this.setVertsDirty();
          },
          tooltip: false
        }
      },
      statics: {
        HorizontalAlign: HorizontalAlign,
        VerticalAlign: VerticalAlign,
        Overflow: Overflow,
        CacheMode: CacheMode,
        _shareAtlas: null,
        clearCharCache: function clearCharCache() {
          Label._shareAtlas && Label._shareAtlas.clearAllCache();
        }
      },
      onLoad: function onLoad() {
        if (this._batchAsBitmap && this.cacheMode === CacheMode.NONE) {
          this.cacheMode = CacheMode.BITMAP;
          this._batchAsBitmap = false;
        }
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS && (this.cacheMode = CacheMode.NONE);
      },
      onEnable: function onEnable() {
        this._super();
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._nodeSizeChanged, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this.setVertsDirty, this);
        this._forceUpdateRenderData();
      },
      onDisable: function onDisable() {
        this._super();
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._nodeSizeChanged, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this.setVertsDirty, this);
      },
      onDestroy: function onDestroy() {
        this._assembler && this._assembler._resetAssemblerData && this._assembler._resetAssemblerData(this._assemblerData);
        this._assemblerData = null;
        this._letterTexture = null;
        if (this._ttfTexture) {
          this._ttfTexture.destroy();
          this._ttfTexture = null;
        }
        this._super();
      },
      _nodeSizeChanged: function _nodeSizeChanged() {
        (false, this.overflow !== Overflow.NONE) && this.setVertsDirty();
      },
      setVertsDirty: function setVertsDirty() {
        false;
        this._super();
      },
      _updateColor: function _updateColor() {
        this.font instanceof cc.BitmapFont || this._srcBlendFactor === cc.macro.BlendFactor.SRC_ALPHA && this.node._renderFlag & cc.RenderFlow.FLAG_OPACITY || this.setVertsDirty();
        RenderComponent.prototype._updateColor.call(this);
      },
      _validateRender: function _validateRender() {
        if (!this.string) {
          this.disableRender();
          return;
        }
        if (this._materials[0]) {
          var font = this.font;
          if (!(font instanceof cc.BitmapFont)) return;
          var spriteFrame = font.spriteFrame;
          if (spriteFrame && spriteFrame.textureLoaded() && font._fntConfig) return;
        }
        this.disableRender();
      },
      _resetAssembler: function _resetAssembler() {
        this._frame = null;
        RenderComponent.prototype._resetAssembler.call(this);
      },
      _checkStringEmpty: function _checkStringEmpty() {
        this.markForRender(!!this.string);
      },
      _on3DNodeChanged: function _on3DNodeChanged() {
        this._resetAssembler();
        this._applyFontTexture();
      },
      _onBMFontTextureLoaded: function _onBMFontTextureLoaded() {
        this._frame._texture = this.font.spriteFrame._texture;
        this.markForRender(true);
        this._updateMaterial();
        this._assembler && this._assembler.updateRenderData(this);
      },
      _onBlendChanged: function _onBlendChanged() {
        if (!this.useSystemFont || !this.enabledInHierarchy) return;
        this._forceUpdateRenderData();
      },
      _applyFontTexture: function _applyFontTexture() {
        var font = this.font;
        if (font instanceof cc.BitmapFont) {
          var spriteFrame = font.spriteFrame;
          this._frame = spriteFrame;
          spriteFrame && spriteFrame.onTextureLoaded(this._onBMFontTextureLoaded, this);
        } else {
          if (!this._nativeTTF()) {
            this._frame || (this._frame = new LabelFrame());
            if (this.cacheMode === CacheMode.CHAR) {
              this._letterTexture = this._assembler._getAssemblerData();
              this._frame._refreshTexture(this._letterTexture);
            } else if (!this._ttfTexture) {
              this._ttfTexture = new cc.Texture2D();
              this._assemblerData = this._assembler._getAssemblerData();
              this._ttfTexture.initWithElement(this._assemblerData.canvas);
            }
            if (this.cacheMode !== CacheMode.CHAR) {
              this._frame._resetDynamicAtlasFrame();
              this._frame._refreshTexture(this._ttfTexture);
              this._srcBlendFactor === cc.macro.BlendFactor.ONE && true && this._ttfTexture.setPremultiplyAlpha(true);
            }
            this._updateMaterial();
          }
          this._assembler && this._assembler.updateRenderData(this);
        }
        this.markForValidate();
      },
      _updateMaterialCanvas: function _updateMaterialCanvas() {
        if (!this._frame) return;
        this._frame._texture._nativeUrl = this.uuid + "_texture";
      },
      _updateMaterialWebgl: function _updateMaterialWebgl() {
        var material = this.getMaterial(0);
        if (this._nativeTTF()) {
          material && this._assembler._updateTTFMaterial(this);
          return;
        }
        if (!this._frame) return;
        material && material.setProperty("texture", this._frame._texture);
        BlendFunc.prototype._updateMaterial.call(this);
      },
      _nativeTTF: function _nativeTTF() {
        return !!this._assembler && !!this._assembler._updateTTFMaterial;
      },
      _forceUpdateRenderData: function _forceUpdateRenderData() {
        this.setVertsDirty();
        this._resetAssembler();
        this._applyFontTexture();
      },
      _enableBold: function _enableBold(enabled) {
        true;
        cc.warn("`label._enableBold` is deprecated, use `label.enableBold = true` instead please");
        this.enableBold = !!enabled;
      },
      _enableItalics: function _enableItalics(enabled) {
        true;
        cc.warn("`label._enableItalics` is deprecated, use `label.enableItalics = true` instead please");
        this.enableItalic = !!enabled;
      },
      _enableUnderline: function _enableUnderline(enabled) {
        true;
        cc.warn("`label._enableUnderline` is deprecated, use `label.enableUnderline = true` instead please");
        this.enableUnderline = !!enabled;
      }
    });
    cc.Label = module.exports = Label;
  }), {
    "../assets/material/CCMaterial": 77,
    "../platform/CCMacro": 143,
    "../renderer/utils/label/label-frame": 171,
    "../utils/blend-func": 203,
    "./CCRenderComponent": 100
  } ],
  97: [ (function(require, module, exports) {
    "use strict";
    var NodeEvent = require("../CCNode").EventType;
    var Type = cc.Enum({
      NONE: 0,
      HORIZONTAL: 1,
      VERTICAL: 2,
      GRID: 3
    });
    var ResizeMode = cc.Enum({
      NONE: 0,
      CONTAINER: 1,
      CHILDREN: 2
    });
    var AxisDirection = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1
    });
    var VerticalDirection = cc.Enum({
      BOTTOM_TO_TOP: 0,
      TOP_TO_BOTTOM: 1
    });
    var HorizontalDirection = cc.Enum({
      LEFT_TO_RIGHT: 0,
      RIGHT_TO_LEFT: 1
    });
    var Layout = cc.Class({
      name: "cc.Layout",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _layoutSize: cc.size(300, 200),
        _layoutDirty: {
          default: true,
          serializable: false
        },
        _resize: ResizeMode.NONE,
        _N$layoutType: Type.NONE,
        type: {
          type: Type,
          get: function get() {
            return this._N$layoutType;
          },
          set: function set(value) {
            this._N$layoutType = value;
            var reLayouted;
            false;
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        resizeMode: {
          type: ResizeMode,
          tooltip: false,
          animatable: false,
          get: function get() {
            return this._resize;
          },
          set: function set(value) {
            if (this.type === Type.NONE && value === ResizeMode.CHILDREN) return;
            this._resize = value;
            var reLayouted;
            false;
            this._doLayoutDirty();
          }
        },
        cellSize: {
          default: cc.size(40, 40),
          tooltip: false,
          type: cc.Size,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        startAxis: {
          default: AxisDirection.HORIZONTAL,
          tooltip: false,
          type: AxisDirection,
          notify: function notify() {
            var reLayouted;
            false;
            this._doLayoutDirty();
          },
          animatable: false
        },
        paddingLeft: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        paddingRight: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        paddingTop: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        paddingBottom: {
          default: 0,
          tooltip: false,
          notify: function notify() {
            this._doLayoutDirty();
          }
        },
        spacingX: {
          default: 0,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false
        },
        spacingY: {
          default: 0,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false
        },
        verticalDirection: {
          default: VerticalDirection.TOP_TO_BOTTOM,
          type: VerticalDirection,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        horizontalDirection: {
          default: HorizontalDirection.LEFT_TO_RIGHT,
          type: HorizontalDirection,
          notify: function notify() {
            this._doLayoutDirty();
          },
          tooltip: false,
          animatable: false
        },
        affectedByScale: {
          default: false,
          notify: function notify() {
            this._doLayoutDirty();
          },
          animatable: false,
          tooltip: false
        }
      },
      statics: {
        Type: Type,
        VerticalDirection: VerticalDirection,
        HorizontalDirection: HorizontalDirection,
        ResizeMode: ResizeMode,
        AxisDirection: AxisDirection
      },
      onEnable: function onEnable() {
        this._addEventListeners();
        this.node.getContentSize().equals(cc.size(0, 0)) && this.node.setContentSize(this._layoutSize);
        this._doLayoutDirty();
      },
      onDisable: function onDisable() {
        this._removeEventListeners();
      },
      _doLayoutDirty: function _doLayoutDirty() {
        this._layoutDirty = true;
      },
      _doScaleDirty: function _doScaleDirty() {
        this._layoutDirty = this._layoutDirty || this.affectedByScale;
      },
      _addEventListeners: function _addEventListeners() {
        cc.director.on(cc.Director.EVENT_AFTER_UPDATE, this.updateLayout, this);
        this.node.on(NodeEvent.SIZE_CHANGED, this._resized, this);
        this.node.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        this.node.on(NodeEvent.CHILD_ADDED, this._childAdded, this);
        this.node.on(NodeEvent.CHILD_REMOVED, this._childRemoved, this);
        this.node.on(NodeEvent.CHILD_REORDER, this._doLayoutDirty, this);
        this._addChildrenEventListeners();
      },
      _removeEventListeners: function _removeEventListeners() {
        cc.director.off(cc.Director.EVENT_AFTER_UPDATE, this.updateLayout, this);
        this.node.off(NodeEvent.SIZE_CHANGED, this._resized, this);
        this.node.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        this.node.off(NodeEvent.CHILD_ADDED, this._childAdded, this);
        this.node.off(NodeEvent.CHILD_REMOVED, this._childRemoved, this);
        this.node.off(NodeEvent.CHILD_REORDER, this._doLayoutDirty, this);
        this._removeChildrenEventListeners();
      },
      _addChildrenEventListeners: function _addChildrenEventListeners() {
        var children = this.node.children;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.on(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
          child.on(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
          child.on(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
          child.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
          child.on("active-in-hierarchy-changed", this._doLayoutDirty, this);
        }
      },
      _removeChildrenEventListeners: function _removeChildrenEventListeners() {
        var children = this.node.children;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.off(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
          child.off(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
          child.off(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
          child.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
          child.off("active-in-hierarchy-changed", this._doLayoutDirty, this);
        }
      },
      _childAdded: function _childAdded(child) {
        child.on(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
        child.on(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
        child.on(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
        child.on(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        child.on("active-in-hierarchy-changed", this._doLayoutDirty, this);
        this._doLayoutDirty();
      },
      _childRemoved: function _childRemoved(child) {
        child.off(NodeEvent.SCALE_CHANGED, this._doScaleDirty, this);
        child.off(NodeEvent.SIZE_CHANGED, this._doLayoutDirty, this);
        child.off(NodeEvent.POSITION_CHANGED, this._doLayoutDirty, this);
        child.off(NodeEvent.ANCHOR_CHANGED, this._doLayoutDirty, this);
        child.off("active-in-hierarchy-changed", this._doLayoutDirty, this);
        this._doLayoutDirty();
      },
      _resized: function _resized() {
        this._layoutSize = this.node.getContentSize();
        this._doLayoutDirty();
      },
      _doLayoutHorizontally: function _doLayoutHorizontally(baseWidth, rowBreak, fnPositionY, applyChildren) {
        var layoutAnchor = this.node.getAnchorPoint();
        var children = this.node.children;
        var sign = 1;
        var paddingX = this.paddingLeft;
        var leftBoundaryOfLayout = -layoutAnchor.x * baseWidth;
        if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
          sign = -1;
          leftBoundaryOfLayout = (1 - layoutAnchor.x) * baseWidth;
          paddingX = this.paddingRight;
        }
        var nextX = leftBoundaryOfLayout + sign * paddingX - sign * this.spacingX;
        var rowMaxHeight = 0;
        var tempMaxHeight = 0;
        var secondMaxHeight = 0;
        var row = 0;
        var containerResizeBoundary = 0;
        var maxHeightChildAnchorY = 0;
        var activeChildCount = 0;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && activeChildCount++;
        }
        var newChildWidth = this.cellSize.width;
        this.type !== Type.GRID && this.resizeMode === ResizeMode.CHILDREN && (newChildWidth = (baseWidth - (this.paddingLeft + this.paddingRight) - (activeChildCount - 1) * this.spacingX) / activeChildCount);
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          var childScaleX = this._getUsedScaleValue(child.scaleX);
          var childScaleY = this._getUsedScaleValue(child.scaleY);
          if (!child.activeInHierarchy) continue;
          if (this._resize === ResizeMode.CHILDREN) {
            child.width = newChildWidth / childScaleX;
            this.type === Type.GRID && (child.height = this.cellSize.height / childScaleY);
          }
          var anchorX = child.anchorX;
          var childBoundingBoxWidth = child.width * childScaleX;
          var childBoundingBoxHeight = child.height * childScaleY;
          secondMaxHeight > tempMaxHeight && (tempMaxHeight = secondMaxHeight);
          if (childBoundingBoxHeight >= tempMaxHeight) {
            secondMaxHeight = tempMaxHeight;
            tempMaxHeight = childBoundingBoxHeight;
            maxHeightChildAnchorY = child.getAnchorPoint().y;
          }
          this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT && (anchorX = 1 - child.anchorX);
          nextX = nextX + sign * anchorX * childBoundingBoxWidth + sign * this.spacingX;
          var rightBoundaryOfChild = sign * (1 - anchorX) * childBoundingBoxWidth;
          if (rowBreak) {
            var rowBreakBoundary = nextX + rightBoundaryOfChild + sign * (sign > 0 ? this.paddingRight : this.paddingLeft);
            var leftToRightRowBreak = this.horizontalDirection === HorizontalDirection.LEFT_TO_RIGHT && rowBreakBoundary > (1 - layoutAnchor.x) * baseWidth;
            var rightToLeftRowBreak = this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT && rowBreakBoundary < -layoutAnchor.x * baseWidth;
            if (leftToRightRowBreak || rightToLeftRowBreak) {
              if (childBoundingBoxHeight >= tempMaxHeight) {
                0 === secondMaxHeight && (secondMaxHeight = tempMaxHeight);
                rowMaxHeight += secondMaxHeight;
                secondMaxHeight = tempMaxHeight;
              } else {
                rowMaxHeight += tempMaxHeight;
                secondMaxHeight = childBoundingBoxHeight;
                tempMaxHeight = 0;
              }
              nextX = leftBoundaryOfLayout + sign * (paddingX + anchorX * childBoundingBoxWidth);
              row++;
            }
          }
          var finalPositionY = fnPositionY(child, rowMaxHeight, row);
          baseWidth >= childBoundingBoxWidth + this.paddingLeft + this.paddingRight && applyChildren && child.setPosition(cc.v2(nextX, finalPositionY));
          var signX = 1;
          var tempFinalPositionY;
          var topMarign = 0 === tempMaxHeight ? childBoundingBoxHeight : tempMaxHeight;
          if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
            containerResizeBoundary = containerResizeBoundary || this.node._contentSize.height;
            signX = -1;
            tempFinalPositionY = finalPositionY + signX * (topMarign * maxHeightChildAnchorY + this.paddingBottom);
            tempFinalPositionY < containerResizeBoundary && (containerResizeBoundary = tempFinalPositionY);
          } else {
            containerResizeBoundary = containerResizeBoundary || -this.node._contentSize.height;
            tempFinalPositionY = finalPositionY + signX * (topMarign * maxHeightChildAnchorY + this.paddingTop);
            tempFinalPositionY > containerResizeBoundary && (containerResizeBoundary = tempFinalPositionY);
          }
          nextX += rightBoundaryOfChild;
        }
        return containerResizeBoundary;
      },
      _getVerticalBaseHeight: function _getVerticalBaseHeight(children) {
        var newHeight = 0;
        var activeChildCount = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            if (child.activeInHierarchy) {
              activeChildCount++;
              newHeight += child.height * this._getUsedScaleValue(child.scaleY);
            }
          }
          newHeight += (activeChildCount - 1) * this.spacingY + this.paddingBottom + this.paddingTop;
        } else newHeight = this.node.getContentSize().height;
        return newHeight;
      },
      _doLayoutVertically: function _doLayoutVertically(baseHeight, columnBreak, fnPositionX, applyChildren) {
        var layoutAnchor = this.node.getAnchorPoint();
        var children = this.node.children;
        var sign = 1;
        var paddingY = this.paddingBottom;
        var bottomBoundaryOfLayout = -layoutAnchor.y * baseHeight;
        if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
          sign = -1;
          bottomBoundaryOfLayout = (1 - layoutAnchor.y) * baseHeight;
          paddingY = this.paddingTop;
        }
        var nextY = bottomBoundaryOfLayout + sign * paddingY - sign * this.spacingY;
        var columnMaxWidth = 0;
        var tempMaxWidth = 0;
        var secondMaxWidth = 0;
        var column = 0;
        var containerResizeBoundary = 0;
        var maxWidthChildAnchorX = 0;
        var activeChildCount = 0;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && activeChildCount++;
        }
        var newChildHeight = this.cellSize.height;
        this.type !== Type.GRID && this.resizeMode === ResizeMode.CHILDREN && (newChildHeight = (baseHeight - (this.paddingTop + this.paddingBottom) - (activeChildCount - 1) * this.spacingY) / activeChildCount);
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          var childScaleX = this._getUsedScaleValue(child.scaleX);
          var childScaleY = this._getUsedScaleValue(child.scaleY);
          if (!child.activeInHierarchy) continue;
          if (this.resizeMode === ResizeMode.CHILDREN) {
            child.height = newChildHeight / childScaleY;
            this.type === Type.GRID && (child.width = this.cellSize.width / childScaleX);
          }
          var anchorY = child.anchorY;
          var childBoundingBoxWidth = child.width * childScaleX;
          var childBoundingBoxHeight = child.height * childScaleY;
          secondMaxWidth > tempMaxWidth && (tempMaxWidth = secondMaxWidth);
          if (childBoundingBoxWidth >= tempMaxWidth) {
            secondMaxWidth = tempMaxWidth;
            tempMaxWidth = childBoundingBoxWidth;
            maxWidthChildAnchorX = child.getAnchorPoint().x;
          }
          this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM && (anchorY = 1 - child.anchorY);
          nextY = nextY + sign * anchorY * childBoundingBoxHeight + sign * this.spacingY;
          var topBoundaryOfChild = sign * (1 - anchorY) * childBoundingBoxHeight;
          if (columnBreak) {
            var columnBreakBoundary = nextY + topBoundaryOfChild + sign * (sign > 0 ? this.paddingTop : this.paddingBottom);
            var bottomToTopColumnBreak = this.verticalDirection === VerticalDirection.BOTTOM_TO_TOP && columnBreakBoundary > (1 - layoutAnchor.y) * baseHeight;
            var topToBottomColumnBreak = this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM && columnBreakBoundary < -layoutAnchor.y * baseHeight;
            if (bottomToTopColumnBreak || topToBottomColumnBreak) {
              if (childBoundingBoxWidth >= tempMaxWidth) {
                0 === secondMaxWidth && (secondMaxWidth = tempMaxWidth);
                columnMaxWidth += secondMaxWidth;
                secondMaxWidth = tempMaxWidth;
              } else {
                columnMaxWidth += tempMaxWidth;
                secondMaxWidth = childBoundingBoxWidth;
                tempMaxWidth = 0;
              }
              nextY = bottomBoundaryOfLayout + sign * (paddingY + anchorY * childBoundingBoxHeight);
              column++;
            }
          }
          var finalPositionX = fnPositionX(child, columnMaxWidth, column);
          baseHeight >= childBoundingBoxHeight + (this.paddingTop + this.paddingBottom) && applyChildren && child.setPosition(cc.v2(finalPositionX, nextY));
          var signX = 1;
          var tempFinalPositionX;
          var rightMarign = 0 === tempMaxWidth ? childBoundingBoxWidth : tempMaxWidth;
          if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
            signX = -1;
            containerResizeBoundary = containerResizeBoundary || this.node._contentSize.width;
            tempFinalPositionX = finalPositionX + signX * (rightMarign * maxWidthChildAnchorX + this.paddingLeft);
            tempFinalPositionX < containerResizeBoundary && (containerResizeBoundary = tempFinalPositionX);
          } else {
            containerResizeBoundary = containerResizeBoundary || -this.node._contentSize.width;
            tempFinalPositionX = finalPositionX + signX * (rightMarign * maxWidthChildAnchorX + this.paddingRight);
            tempFinalPositionX > containerResizeBoundary && (containerResizeBoundary = tempFinalPositionX);
          }
          nextY += topBoundaryOfChild;
        }
        return containerResizeBoundary;
      },
      _doLayoutBasic: function _doLayoutBasic() {
        var children = this.node.children;
        var allChildrenBoundingBox = null;
        for (var i = 0; i < children.length; ++i) {
          var child = children[i];
          child.activeInHierarchy && (allChildrenBoundingBox ? allChildrenBoundingBox.union(allChildrenBoundingBox, child.getBoundingBoxToWorld()) : allChildrenBoundingBox = child.getBoundingBoxToWorld());
        }
        if (allChildrenBoundingBox) {
          var leftBottomSpace = this.node.convertToNodeSpaceAR(cc.v2(allChildrenBoundingBox.x, allChildrenBoundingBox.y));
          leftBottomSpace = cc.v2(leftBottomSpace.x - this.paddingLeft, leftBottomSpace.y - this.paddingBottom);
          var rightTopSpace = this.node.convertToNodeSpaceAR(cc.v2(allChildrenBoundingBox.xMax, allChildrenBoundingBox.yMax));
          rightTopSpace = cc.v2(rightTopSpace.x + this.paddingRight, rightTopSpace.y + this.paddingTop);
          var newSize = rightTopSpace.sub(leftBottomSpace);
          newSize = cc.size(parseFloat(newSize.x.toFixed(2)), parseFloat(newSize.y.toFixed(2)));
          if (0 !== newSize.width) {
            var newAnchorX = -leftBottomSpace.x / newSize.width;
            this.node.anchorX = parseFloat(newAnchorX.toFixed(2));
          }
          if (0 !== newSize.height) {
            var newAnchorY = -leftBottomSpace.y / newSize.height;
            this.node.anchorY = parseFloat(newAnchorY.toFixed(2));
          }
          this.node.setContentSize(newSize);
        }
      },
      _doLayoutGridAxisHorizontal: function _doLayoutGridAxisHorizontal(layoutAnchor, layoutSize) {
        var baseWidth = layoutSize.width;
        var sign = 1;
        var bottomBoundaryOfLayout = -layoutAnchor.y * layoutSize.height;
        var paddingY = this.paddingBottom;
        if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
          sign = -1;
          bottomBoundaryOfLayout = (1 - layoutAnchor.y) * layoutSize.height;
          paddingY = this.paddingTop;
        }
        var fnPositionY = function(child, topOffset, row) {
          return bottomBoundaryOfLayout + sign * (topOffset + child.anchorY * child.height * this._getUsedScaleValue(child.scaleY) + paddingY + row * this.spacingY);
        }.bind(this);
        var newHeight = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          var boundary = this._doLayoutHorizontally(baseWidth, true, fnPositionY, false);
          newHeight = bottomBoundaryOfLayout - boundary;
          newHeight < 0 && (newHeight *= -1);
          bottomBoundaryOfLayout = -layoutAnchor.y * newHeight;
          if (this.verticalDirection === VerticalDirection.TOP_TO_BOTTOM) {
            sign = -1;
            bottomBoundaryOfLayout = (1 - layoutAnchor.y) * newHeight;
          }
        }
        this._doLayoutHorizontally(baseWidth, true, fnPositionY, true);
        this.resizeMode === ResizeMode.CONTAINER && this.node.setContentSize(baseWidth, newHeight);
      },
      _doLayoutGridAxisVertical: function _doLayoutGridAxisVertical(layoutAnchor, layoutSize) {
        var baseHeight = layoutSize.height;
        var sign = 1;
        var leftBoundaryOfLayout = -layoutAnchor.x * layoutSize.width;
        var paddingX = this.paddingLeft;
        if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
          sign = -1;
          leftBoundaryOfLayout = (1 - layoutAnchor.x) * layoutSize.width;
          paddingX = this.paddingRight;
        }
        var fnPositionX = function(child, leftOffset, column) {
          return leftBoundaryOfLayout + sign * (leftOffset + child.anchorX * child.width * this._getUsedScaleValue(child.scaleX) + paddingX + column * this.spacingX);
        }.bind(this);
        var newWidth = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          var boundary = this._doLayoutVertically(baseHeight, true, fnPositionX, false);
          newWidth = leftBoundaryOfLayout - boundary;
          newWidth < 0 && (newWidth *= -1);
          leftBoundaryOfLayout = -layoutAnchor.x * newWidth;
          if (this.horizontalDirection === HorizontalDirection.RIGHT_TO_LEFT) {
            sign = -1;
            leftBoundaryOfLayout = (1 - layoutAnchor.x) * newWidth;
          }
        }
        this._doLayoutVertically(baseHeight, true, fnPositionX, true);
        this.resizeMode === ResizeMode.CONTAINER && this.node.setContentSize(newWidth, baseHeight);
      },
      _doLayoutGrid: function _doLayoutGrid() {
        var layoutAnchor = this.node.getAnchorPoint();
        var layoutSize = this.node.getContentSize();
        this.startAxis === AxisDirection.HORIZONTAL ? this._doLayoutGridAxisHorizontal(layoutAnchor, layoutSize) : this.startAxis === AxisDirection.VERTICAL && this._doLayoutGridAxisVertical(layoutAnchor, layoutSize);
      },
      _getHorizontalBaseWidth: function _getHorizontalBaseWidth(children) {
        var newWidth = 0;
        var activeChildCount = 0;
        if (this.resizeMode === ResizeMode.CONTAINER) {
          for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            if (child.activeInHierarchy) {
              activeChildCount++;
              newWidth += child.width * this._getUsedScaleValue(child.scaleX);
            }
          }
          newWidth += (activeChildCount - 1) * this.spacingX + this.paddingLeft + this.paddingRight;
        } else newWidth = this.node.getContentSize().width;
        return newWidth;
      },
      _doLayout: function _doLayout() {
        if (this.type === Type.HORIZONTAL) {
          var newWidth = this._getHorizontalBaseWidth(this.node.children);
          var fnPositionY = function fnPositionY(child) {
            return child.y;
          };
          this._doLayoutHorizontally(newWidth, false, fnPositionY, true);
          this.node.width = newWidth;
        } else if (this.type === Type.VERTICAL) {
          var newHeight = this._getVerticalBaseHeight(this.node.children);
          var fnPositionX = function fnPositionX(child) {
            return child.x;
          };
          this._doLayoutVertically(newHeight, false, fnPositionX, true);
          this.node.height = newHeight;
        } else this.type === Type.NONE ? this.resizeMode === ResizeMode.CONTAINER && this._doLayoutBasic() : this.type === Type.GRID && this._doLayoutGrid();
      },
      _getUsedScaleValue: function _getUsedScaleValue(value) {
        return this.affectedByScale ? Math.abs(value) : 1;
      },
      updateLayout: function updateLayout() {
        if (this._layoutDirty && this.node.children.length > 0) {
          this._doLayout();
          this._layoutDirty = false;
        }
      }
    });
    cc.Layout = module.exports = Layout;
  }), {
    "../CCNode": 26,
    "./CCComponent": 94
  } ],
  98: [ (function(require, module, exports) {
    "use strict";
    var _gfx = _interopRequireDefault(require("../../renderer/gfx"));
    var _mat = _interopRequireDefault(require("../value-types/mat4"));
    var _vec = _interopRequireDefault(require("../value-types/vec2"));
    var _materialVariant = _interopRequireDefault(require("../assets/material/material-variant"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var misc = require("../utils/misc");
    var RenderComponent = require("./CCRenderComponent");
    var RenderFlow = require("../renderer/render-flow");
    var Graphics = require("../graphics/graphics");
    var _vec2_temp = new _vec["default"]();
    var _mat4_temp = new _mat["default"]();
    var _circlepoints = [];
    function _calculateCircle(center, radius, segements) {
      _circlepoints.length = 0;
      var anglePerStep = 2 * Math.PI / segements;
      for (var step = 0; step < segements; ++step) _circlepoints.push(cc.v2(radius.x * Math.cos(anglePerStep * step) + center.x, radius.y * Math.sin(anglePerStep * step) + center.y));
      return _circlepoints;
    }
    var MaskType = cc.Enum({
      RECT: 0,
      ELLIPSE: 1,
      IMAGE_STENCIL: 2
    });
    var SEGEMENTS_MIN = 3;
    var SEGEMENTS_MAX = 1e4;
    var Mask = cc.Class({
      name: "cc.Mask",
      extends: RenderComponent,
      editor: false,
      ctor: function ctor() {
        this._graphics = null;
        this._enableMaterial = null;
        this._exitMaterial = null;
        this._clearMaterial = null;
      },
      properties: {
        _spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        _type: MaskType.RECT,
        type: {
          get: function get() {
            return this._type;
          },
          set: function set(value) {
            this._type !== value && this._resetAssembler();
            this._type = value;
            if (this._type !== MaskType.IMAGE_STENCIL) {
              this.spriteFrame = null;
              this.alphaThreshold = 0;
              this._updateGraphics();
            }
            this._activateMaterial();
          },
          type: MaskType,
          tooltip: false
        },
        spriteFrame: {
          type: cc.SpriteFrame,
          tooltip: false,
          get: function get() {
            return this._spriteFrame;
          },
          set: function set(value) {
            var lastSprite = this._spriteFrame;
            false;
            if (lastSprite === value) return;
            this._spriteFrame = value;
            this.setVertsDirty();
            this._updateMaterial();
          }
        },
        alphaThreshold: {
          default: .1,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function notify() {
            if (cc.game.renderType === cc.game.RENDER_TYPE_CANVAS) {
              cc.warnID(4201);
              return;
            }
            this._updateMaterial();
          }
        },
        inverted: {
          default: false,
          type: cc.Boolean,
          tooltip: false,
          notify: function notify() {
            cc.game.renderType === cc.game.RENDER_TYPE_CANVAS && cc.warnID(4202);
          }
        },
        _segments: 64,
        segements: {
          get: function get() {
            return this._segments;
          },
          set: function set(value) {
            this._segments = misc.clampf(value, SEGEMENTS_MIN, SEGEMENTS_MAX);
            this._updateGraphics();
          },
          type: cc.Integer,
          tooltip: false
        },
        _resizeToTarget: {
          animatable: false,
          set: function set(value) {
            value && this._resizeNodeToTargetNode();
          }
        }
      },
      statics: {
        Type: MaskType
      },
      onRestore: function onRestore() {
        this._activateMaterial();
      },
      onEnable: function onEnable() {
        this._super();
        this._type !== MaskType.IMAGE_STENCIL && this._updateGraphics();
        this.node.on(cc.Node.EventType.POSITION_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.ROTATION_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.SCALE_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this._updateGraphics, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this._updateGraphics, this);
      },
      onDisable: function onDisable() {
        this._super();
        this.node.off(cc.Node.EventType.POSITION_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.ROTATION_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.SCALE_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this._updateGraphics, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this._updateGraphics, this);
        this.node._renderFlag &= ~RenderFlow.FLAG_POST_RENDER;
      },
      onDestroy: function onDestroy() {
        this._super();
        this._removeGraphics();
      },
      _resizeNodeToTargetNode: false,
      _validateRender: function _validateRender() {
        if (this._type !== MaskType.IMAGE_STENCIL) return;
        var spriteFrame = this._spriteFrame;
        if (spriteFrame && spriteFrame.textureLoaded()) return;
        this.disableRender();
      },
      _activateMaterial: function _activateMaterial() {
        this._createGraphics();
        var material = this._materials[0];
        material = material ? _materialVariant["default"].create(material, this) : _materialVariant["default"].createWithBuiltin("2d-sprite", this);
        material.define("USE_ALPHA_TEST", true);
        if (this._type === MaskType.IMAGE_STENCIL) {
          material.define("CC_USE_MODEL", false);
          material.define("USE_TEXTURE", true);
        } else {
          material.define("CC_USE_MODEL", true);
          material.define("USE_TEXTURE", false);
        }
        this._enableMaterial || (this._enableMaterial = _materialVariant["default"].createWithBuiltin("2d-sprite", this));
        if (!this._exitMaterial) {
          this._exitMaterial = _materialVariant["default"].createWithBuiltin("2d-sprite", this);
          this._exitMaterial.setStencilEnabled(_gfx["default"].STENCIL_DISABLE);
        }
        this._clearMaterial || (this._clearMaterial = _materialVariant["default"].createWithBuiltin("clear-stencil", this));
        this.setMaterial(0, material);
        this._graphics._materials[0] = material;
        this._updateMaterial();
      },
      _updateMaterial: function _updateMaterial() {
        var material = this._materials[0];
        if (!material) return;
        if (this._type === MaskType.IMAGE_STENCIL && this.spriteFrame) {
          var texture = this.spriteFrame.getTexture();
          material.setProperty("texture", texture);
        }
        material.setProperty("alphaThreshold", this.alphaThreshold);
      },
      _createGraphics: function _createGraphics() {
        if (!this._graphics) {
          this._graphics = new Graphics();
          cc.Assembler.init(this._graphics);
          this._graphics.node = this.node;
          this._graphics.lineWidth = 0;
          this._graphics.strokeColor = cc.color(0, 0, 0, 0);
        }
      },
      _updateGraphics: function _updateGraphics() {
        var node = this.node;
        var graphics = this._graphics;
        graphics.clear(false);
        var width = node._contentSize.width;
        var height = node._contentSize.height;
        var x = -width * node._anchorPoint.x;
        var y = -height * node._anchorPoint.y;
        if (this._type === MaskType.RECT) graphics.rect(x, y, width, height); else if (this._type === MaskType.ELLIPSE) {
          var center = cc.v2(x + width / 2, y + height / 2);
          var radius = {
            x: width / 2,
            y: height / 2
          };
          var points = _calculateCircle(center, radius, this._segments);
          for (var i = 0; i < points.length; ++i) {
            var point = points[i];
            0 === i ? graphics.moveTo(point.x, point.y) : graphics.lineTo(point.x, point.y);
          }
          graphics.close();
        }
        cc.game.renderType === cc.game.RENDER_TYPE_CANVAS ? graphics.stroke() : graphics.fill();
      },
      _removeGraphics: function _removeGraphics() {
        if (this._graphics) {
          this._graphics.destroy();
          this._graphics._destroyImmediate();
          this._graphics = null;
        }
      },
      _hitTest: function _hitTest(cameraPt) {
        var node = this.node;
        var size = node.getContentSize(), w = size.width, h = size.height, testPt = _vec2_temp;
        node._updateWorldMatrix();
        if (!_mat["default"].invert(_mat4_temp, node._worldMatrix)) return false;
        _vec["default"].transformMat4(testPt, cameraPt, _mat4_temp);
        testPt.x += node._anchorPoint.x * w;
        testPt.y += node._anchorPoint.y * h;
        var result = false;
        if (this.type === MaskType.RECT || this.type === MaskType.IMAGE_STENCIL) result = testPt.x >= 0 && testPt.y >= 0 && testPt.x <= w && testPt.y <= h; else if (this.type === MaskType.ELLIPSE) {
          var rx = w / 2, ry = h / 2;
          var px = testPt.x - .5 * w, py = testPt.y - .5 * h;
          result = px * px / (rx * rx) + py * py / (ry * ry) < 1;
        }
        this.inverted && (result = !result);
        return result;
      },
      markForRender: function markForRender(enable) {
        var flag = RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_RENDER;
        if (enable) {
          this.node._renderFlag |= flag;
          this.markForValidate();
        } else enable || (this.node._renderFlag &= ~flag);
      },
      disableRender: function disableRender() {
        this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA | RenderFlow.FLAG_POST_RENDER);
      }
    });
    cc.Mask = module.exports = Mask;
  }), {
    "../../renderer/gfx": 251,
    "../assets/material/material-variant": 84,
    "../graphics/graphics": 127,
    "../renderer/render-flow": 169,
    "../utils/misc": 209,
    "../value-types/mat4": 226,
    "../value-types/vec2": 233,
    "./CCRenderComponent": 100
  } ],
  99: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var Mode = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1,
      FILLED: 2
    });
    var ProgressBar = cc.Class({
      name: "cc.ProgressBar",
      extends: Component,
      editor: false,
      _initBarSprite: function _initBarSprite() {
        if (this.barSprite) {
          var entity = this.barSprite.node;
          if (!entity) return;
          var nodeSize = this.node.getContentSize();
          var nodeAnchor = this.node.getAnchorPoint();
          var entitySize = entity.getContentSize();
          entity.parent === this.node && this.node.setContentSize(entitySize);
          this.barSprite.fillType === cc.Sprite.FillType.RADIAL && (this.mode = Mode.FILLED);
          var barSpriteSize = entity.getContentSize();
          this.mode === Mode.HORIZONTAL ? this.totalLength = barSpriteSize.width : this.mode === Mode.VERTICAL ? this.totalLength = barSpriteSize.height : this.totalLength = this.barSprite.fillRange;
          if (entity.parent === this.node) {
            var x = -nodeSize.width * nodeAnchor.x;
            var y = 0;
            entity.setPosition(cc.v2(x, y));
          }
        }
      },
      _updateBarStatus: function _updateBarStatus() {
        if (this.barSprite) {
          var entity = this.barSprite.node;
          if (!entity) return;
          var entityAnchorPoint = entity.getAnchorPoint();
          var entitySize = entity.getContentSize();
          var entityPosition = entity.getPosition();
          var anchorPoint = cc.v2(0, .5);
          var progress = misc.clamp01(this.progress);
          var actualLenth = this.totalLength * progress;
          var finalContentSize;
          var totalWidth;
          var totalHeight;
          switch (this.mode) {
           case Mode.HORIZONTAL:
            this.reverse && (anchorPoint = cc.v2(1, .5));
            finalContentSize = cc.size(actualLenth, entitySize.height);
            totalWidth = this.totalLength;
            totalHeight = entitySize.height;
            break;

           case Mode.VERTICAL:
            anchorPoint = this.reverse ? cc.v2(.5, 1) : cc.v2(.5, 0);
            finalContentSize = cc.size(entitySize.width, actualLenth);
            totalWidth = entitySize.width;
            totalHeight = this.totalLength;
          }
          if (this.mode === Mode.FILLED) if (this.barSprite.type !== cc.Sprite.Type.FILLED) cc.warn("ProgressBar FILLED mode only works when barSprite's Type is FILLED!"); else {
            this.reverse && (actualLenth *= -1);
            this.barSprite.fillRange = actualLenth;
          } else if (this.barSprite.type !== cc.Sprite.Type.FILLED) {
            var anchorOffsetX = anchorPoint.x - entityAnchorPoint.x;
            var anchorOffsetY = anchorPoint.y - entityAnchorPoint.y;
            var finalPosition = cc.v2(totalWidth * anchorOffsetX, totalHeight * anchorOffsetY);
            entity.setPosition(entityPosition.x + finalPosition.x, entityPosition.y + finalPosition.y);
            entity.setAnchorPoint(anchorPoint);
            entity.setContentSize(finalContentSize);
          } else cc.warn("ProgressBar non-FILLED mode only works when barSprite's Type is non-FILLED!");
        }
      },
      properties: {
        barSprite: {
          default: null,
          type: cc.Sprite,
          tooltip: false,
          notify: function notify() {
            this._initBarSprite();
          },
          animatable: false
        },
        mode: {
          default: Mode.HORIZONTAL,
          type: Mode,
          tooltip: false,
          notify: function notify() {
            if (this.barSprite) {
              var entity = this.barSprite.node;
              if (!entity) return;
              var entitySize = entity.getContentSize();
              this.mode === Mode.HORIZONTAL ? this.totalLength = entitySize.width : this.mode === Mode.VERTICAL ? this.totalLength = entitySize.height : this.mode === Mode.FILLED && (this.totalLength = this.barSprite.fillRange);
            }
          },
          animatable: false
        },
        _N$totalLength: 1,
        totalLength: {
          range: [ 0, Number.MAX_VALUE ],
          tooltip: false,
          get: function get() {
            return this._N$totalLength;
          },
          set: function set(value) {
            this.mode === Mode.FILLED && (value = misc.clamp01(value));
            this._N$totalLength = value;
            this._updateBarStatus();
          }
        },
        progress: {
          default: 1,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function notify() {
            this._updateBarStatus();
          }
        },
        reverse: {
          default: false,
          tooltip: false,
          notify: function notify() {
            this.barSprite && (this.barSprite.fillStart = 1 - this.barSprite.fillStart);
            this._updateBarStatus();
          },
          animatable: false
        }
      },
      statics: {
        Mode: Mode
      }
    });
    cc.ProgressBar = module.exports = ProgressBar;
  }), {
    "../utils/misc": 209,
    "./CCComponent": 94
  } ],
  100: [ (function(require, module, exports) {
    "use strict";
    var _assembler = _interopRequireDefault(require("../renderer/assembler"));
    var _materialVariant = _interopRequireDefault(require("../assets/material/material-variant"));
    var _valueTypes = require("../value-types");
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var Component = require("./CCComponent");
    var RenderFlow = require("../renderer/render-flow");
    var Material = require("../assets/material/CCMaterial");
    var _temp_color = new _valueTypes.Color();
    var RenderComponent = cc.Class({
      name: "RenderComponent",
      extends: Component,
      editor: false,
      properties: {
        _materials: {
          default: [],
          type: Material
        },
        materials: {
          get: function get() {
            return this._materials;
          },
          set: function set(val) {
            this._materials = val;
            this._activateMaterial();
          },
          type: [ Material ],
          displayName: "Materials",
          animatable: false
        }
      },
      ctor: function ctor() {
        this._vertsDirty = true;
        this._assembler = null;
      },
      _resetAssembler: function _resetAssembler() {
        _assembler["default"].init(this);
        this._updateColor();
        this.setVertsDirty();
      },
      __preload: function __preload() {
        this._resetAssembler();
        this._activateMaterial();
      },
      onEnable: function onEnable() {
        this.node._renderComponent && (this.node._renderComponent.enabled = false);
        this.node._renderComponent = this;
        this.node._renderFlag |= RenderFlow.FLAG_OPACITY_COLOR;
        this.setVertsDirty();
      },
      onDisable: function onDisable() {
        this.node._renderComponent = null;
        this.disableRender();
      },
      onDestroy: function onDestroy() {
        var materials = this._materials;
        for (var i = 0; i < materials.length; i++) cc.pool.material.put(materials[i]);
        materials.length = 0;
        cc.pool.assembler.put(this._assembler);
      },
      setVertsDirty: function setVertsDirty() {
        this._vertsDirty = true;
        this.markForRender(true);
      },
      _on3DNodeChanged: function _on3DNodeChanged() {
        this._resetAssembler();
      },
      _validateRender: function _validateRender() {},
      markForValidate: function markForValidate() {
        cc.RenderFlow.registerValidate(this);
      },
      markForRender: function markForRender(enable) {
        var flag = RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA;
        if (enable) {
          this.node._renderFlag |= flag;
          this.markForValidate();
        } else this.node._renderFlag &= ~flag;
      },
      disableRender: function disableRender() {
        this.node._renderFlag &= ~(RenderFlow.FLAG_RENDER | RenderFlow.FLAG_UPDATE_RENDER_DATA);
      },
      getMaterial: function getMaterial(index) {
        if (index < 0 || index >= this._materials.length) return null;
        var material = this._materials[index];
        if (!material) return null;
        var instantiated = _materialVariant["default"].create(material, this);
        instantiated !== material && this.setMaterial(index, instantiated);
        return instantiated;
      },
      getMaterials: function getMaterials() {
        var materials = this._materials;
        for (var i = 0; i < materials.length; i++) materials[i] = _materialVariant["default"].create(materials[i], this);
        return materials;
      },
      setMaterial: function setMaterial(index, material) {
        if (material !== this._materials[index]) {
          material = _materialVariant["default"].create(material, this);
          this._materials[index] = material;
        }
        this._updateMaterial();
        this.markForRender(true);
        return material;
      },
      _getDefaultMaterial: function _getDefaultMaterial() {
        return Material.getBuiltinMaterial("2d-sprite");
      },
      _activateMaterial: function _activateMaterial() {
        var materials = this._materials;
        if (!materials[0]) {
          var material = this._getDefaultMaterial();
          materials[0] = material;
        }
        for (var i = 0; i < materials.length; i++) materials[i] = _materialVariant["default"].create(materials[i], this);
        this._updateMaterial();
      },
      _updateMaterial: function _updateMaterial() {},
      _updateColor: function _updateColor() {
        if (this._assembler.updateColor) {
          var premultiply = this.srcBlendFactor === cc.macro.BlendFactor.ONE;
          premultiply && _valueTypes.Color.premultiplyAlpha(_temp_color, this.node._color);
          var color = premultiply ? _temp_color._val : null;
          this._assembler.updateColor(this, color);
        }
      },
      _checkBacth: function _checkBacth(renderer, cullingMask) {
        var material = this._materials[0];
        if (material && material.getHash() !== renderer.material.getHash() || renderer.cullingMask !== cullingMask) {
          renderer._flush();
          renderer.node = material.getDefine("CC_USE_MODEL") ? this.node : renderer._dummyNode;
          renderer.material = material;
          renderer.cullingMask = cullingMask;
        }
      }
    });
    cc.RenderComponent = module.exports = RenderComponent;
  }), {
    "../assets/material/CCMaterial": 77,
    "../assets/material/material-variant": 84,
    "../renderer/assembler": 165,
    "../renderer/render-flow": 169,
    "../value-types": 224,
    "./CCComponent": 94
  } ],
  101: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var macro = require("../platform/CCMacro");
    var textUtils = require("../utils/text-utils");
    var HtmlTextParser = require("../utils/html-text-parser");
    var _htmlTextParser = new HtmlTextParser();
    var HorizontalAlign = macro.TextAlignment;
    var VerticalAlign = macro.VerticalTextAlignment;
    var RichTextChildName = "RICHTEXT_CHILD";
    var RichTextChildImageName = "RICHTEXT_Image_CHILD";
    var CacheMode = cc.Label.CacheMode;
    function debounce(func, wait, immediate) {
      var timeout;
      return function() {
        var context = this;
        var later = function later() {
          timeout = null;
          immediate || func.apply(context, arguments);
        };
        var callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        callNow && func.apply(context, arguments);
      };
    }
    var pool = new js.Pool(function(node) {
      false;
      false;
      if (!cc.isValid(node)) return false;
      var outline = node.getComponent(cc.LabelOutline);
      outline && (outline.width = 0);
      return true;
    }, 20);
    pool.get = function(string, richtext) {
      var labelNode = this._get();
      labelNode || (labelNode = new cc.PrivateNode(RichTextChildName));
      labelNode.setPosition(0, 0);
      labelNode.setAnchorPoint(.5, .5);
      labelNode.skewX = 0;
      var labelComponent = labelNode.getComponent(cc.Label);
      labelComponent || (labelComponent = labelNode.addComponent(cc.Label));
      labelComponent.string = "";
      labelComponent.horizontalAlign = HorizontalAlign.LEFT;
      labelComponent.verticalAlign = VerticalAlign.CENTER;
      return labelNode;
    };
    var RichText = cc.Class({
      name: "cc.RichText",
      extends: cc.Component,
      ctor: function ctor() {
        this._textArray = null;
        this._labelSegments = [];
        this._labelSegmentsCache = [];
        this._linesWidth = [];
        false;
        this._updateRichTextStatus = this._updateRichText;
      },
      editor: false,
      properties: {
        string: {
          default: "<color=#00ff00>Rich</c><color=#0fffff>Text</color>",
          multiline: true,
          tooltip: false,
          notify: function notify() {
            this._updateRichTextStatus();
          }
        },
        horizontalAlign: {
          default: HorizontalAlign.LEFT,
          type: HorizontalAlign,
          tooltip: false,
          animatable: false,
          notify: function notify(oldValue) {
            if (this.horizontalAlign === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        fontSize: {
          default: 40,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.fontSize === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        _fontFamily: "Arial",
        fontFamily: {
          tooltip: false,
          get: function get() {
            return this._fontFamily;
          },
          set: function set(value) {
            if (this._fontFamily === value) return;
            this._fontFamily = value;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          },
          animatable: false
        },
        font: {
          default: null,
          type: cc.TTFFont,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.font === oldValue) return;
            this._layoutDirty = true;
            if (this.font) {
              false;
              this.useSystemFont = false;
              this._onTTFLoaded();
            } else this.useSystemFont = true;
            this._updateRichTextStatus();
          }
        },
        _isSystemFontUsed: true,
        useSystemFont: {
          get: function get() {
            return this._isSystemFontUsed;
          },
          set: function set(value) {
            if (this._isSystemFontUsed === value) return;
            this._isSystemFontUsed = value;
            false;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          },
          animatable: false,
          tooltip: false
        },
        cacheMode: {
          default: CacheMode.NONE,
          type: CacheMode,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.cacheMode === oldValue) return;
            this._updateRichTextStatus();
          },
          animatable: false
        },
        maxWidth: {
          default: 0,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.maxWidth === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        lineHeight: {
          default: 40,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.lineHeight === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        imageAtlas: {
          default: null,
          type: cc.SpriteAtlas,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.imageAtlas === oldValue) return;
            this._layoutDirty = true;
            this._updateRichTextStatus();
          }
        },
        handleTouchEvent: {
          default: true,
          tooltip: false,
          notify: function notify(oldValue) {
            if (this.handleTouchEvent === oldValue) return;
            this.enabledInHierarchy && (this.handleTouchEvent ? this._addEventListeners() : this._removeEventListeners());
          }
        }
      },
      statics: {
        HorizontalAlign: HorizontalAlign,
        VerticalAlign: VerticalAlign
      },
      onEnable: function onEnable() {
        this.handleTouchEvent && this._addEventListeners();
        this._updateRichText();
        this._activateChildren(true);
      },
      onDisable: function onDisable() {
        this.handleTouchEvent && this._removeEventListeners();
        this._activateChildren(false);
      },
      start: function start() {
        this._onTTFLoaded();
      },
      _onColorChanged: function _onColorChanged(parentColor) {
        var children = this.node.children;
        children.forEach((function(childNode) {
          childNode.color = parentColor;
        }));
      },
      _addEventListeners: function _addEventListeners() {
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.COLOR_CHANGED, this._onColorChanged, this);
      },
      _removeEventListeners: function _removeEventListeners() {
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.COLOR_CHANGED, this._onColorChanged, this);
      },
      _updateLabelSegmentTextAttributes: function _updateLabelSegmentTextAttributes() {
        this._labelSegments.forEach(function(item) {
          this._applyTextAttribute(item, null, true);
        }.bind(this));
      },
      _createFontLabel: function _createFontLabel(string) {
        return pool.get(string, this);
      },
      _onTTFLoaded: function _onTTFLoaded() {
        if (this.font instanceof cc.TTFFont) if (this.font._nativeAsset) {
          this._layoutDirty = true;
          this._updateRichText();
        } else {
          var self = this;
          cc.assetManager.postLoadNative(this.font, (function(err) {
            self._layoutDirty = true;
            self._updateRichText();
          }));
        } else {
          this._layoutDirty = true;
          this._updateRichText();
        }
      },
      _measureText: function _measureText(styleIndex, string) {
        var self = this;
        var func = function func(string) {
          var label;
          if (0 === self._labelSegmentsCache.length) {
            label = self._createFontLabel(string);
            self._labelSegmentsCache.push(label);
          } else label = self._labelSegmentsCache[0];
          label._styleIndex = styleIndex;
          self._applyTextAttribute(label, string, true);
          var labelSize = label.getContentSize();
          return labelSize.width;
        };
        return string ? func(string) : func;
      },
      _onTouchEnded: function _onTouchEnded(event) {
        var _this = this;
        var components = this.node.getComponents(cc.Component);
        var _loop = function _loop(i) {
          var labelSegment = _this._labelSegments[i];
          var clickHandler = labelSegment._clickHandler;
          var clickParam = labelSegment._clickParam;
          if (clickHandler && _this._containsTouchLocation(labelSegment, event.touch.getLocation())) {
            components.forEach((function(component) {
              component.enabledInHierarchy && component[clickHandler] && component[clickHandler](event, clickParam);
            }));
            event.stopPropagation();
          }
        };
        for (var i = 0; i < this._labelSegments.length; ++i) _loop(i);
      },
      _containsTouchLocation: function _containsTouchLocation(label, point) {
        var myRect = label.getBoundingBoxToWorld();
        return myRect.contains(point);
      },
      _resetState: function _resetState() {
        var children = this.node.children;
        for (var i = children.length - 1; i >= 0; i--) {
          var child = children[i];
          if (child.name === RichTextChildName || child.name === RichTextChildImageName) {
            child.parent === this.node ? child.parent = null : children.splice(i, 1);
            child.name === RichTextChildName && pool.put(child);
          }
        }
        this._labelSegments.length = 0;
        this._labelSegmentsCache.length = 0;
        this._linesWidth.length = 0;
        this._lineOffsetX = 0;
        this._lineCount = 1;
        this._labelWidth = 0;
        this._labelHeight = 0;
        this._layoutDirty = true;
      },
      onRestore: false,
      _activateChildren: function _activateChildren(active) {
        for (var i = this.node.children.length - 1; i >= 0; i--) {
          var child = this.node.children[i];
          child.name !== RichTextChildName && child.name !== RichTextChildImageName || (child.active = active);
        }
      },
      _addLabelSegment: function _addLabelSegment(stringToken, styleIndex) {
        var labelSegment;
        labelSegment = 0 === this._labelSegmentsCache.length ? this._createFontLabel(stringToken) : this._labelSegmentsCache.pop();
        labelSegment._styleIndex = styleIndex;
        labelSegment._lineCount = this._lineCount;
        labelSegment.active = this.node.active;
        labelSegment.setAnchorPoint(0, 0);
        this._applyTextAttribute(labelSegment, stringToken);
        this.node.addChild(labelSegment);
        this._labelSegments.push(labelSegment);
        return labelSegment;
      },
      _updateRichTextWithMaxWidth: function _updateRichTextWithMaxWidth(labelString, labelWidth, styleIndex) {
        var fragmentWidth = labelWidth;
        var labelSegment;
        if (this._lineOffsetX > 0 && fragmentWidth + this._lineOffsetX > this.maxWidth) {
          var checkStartIndex = 0;
          while (this._lineOffsetX <= this.maxWidth) {
            var checkEndIndex = this._getFirstWordLen(labelString, checkStartIndex, labelString.length);
            var checkString = labelString.substr(checkStartIndex, checkEndIndex);
            var checkStringWidth = this._measureText(styleIndex, checkString);
            if (!(this._lineOffsetX + checkStringWidth <= this.maxWidth)) {
              if (checkStartIndex > 0) {
                var remainingString = labelString.substr(0, checkStartIndex);
                this._addLabelSegment(remainingString, styleIndex);
                labelString = labelString.substr(checkStartIndex, labelString.length);
                fragmentWidth = this._measureText(styleIndex, labelString);
              }
              this._updateLineInfo();
              break;
            }
            this._lineOffsetX += checkStringWidth;
            checkStartIndex += checkEndIndex;
          }
        }
        if (fragmentWidth > this.maxWidth) {
          var fragments = textUtils.fragmentText(labelString, fragmentWidth, this.maxWidth, this._measureText(styleIndex));
          for (var k = 0; k < fragments.length; ++k) {
            var splitString = fragments[k];
            labelSegment = this._addLabelSegment(splitString, styleIndex);
            var labelSize = labelSegment.getContentSize();
            this._lineOffsetX += labelSize.width;
            fragments.length > 1 && k < fragments.length - 1 && this._updateLineInfo();
          }
        } else {
          this._lineOffsetX += fragmentWidth;
          this._addLabelSegment(labelString, styleIndex);
        }
      },
      _isLastComponentCR: function _isLastComponentCR(stringToken) {
        return stringToken.length - 1 === stringToken.lastIndexOf("\n");
      },
      _updateLineInfo: function _updateLineInfo() {
        this._linesWidth.push(this._lineOffsetX);
        this._lineOffsetX = 0;
        this._lineCount++;
      },
      _needsUpdateTextLayout: function _needsUpdateTextLayout(newTextArray) {
        if (this._layoutDirty || !this._textArray || !newTextArray) return true;
        if (this._textArray.length !== newTextArray.length) return true;
        for (var i = 0; i < this._textArray.length; ++i) {
          var oldItem = this._textArray[i];
          var newItem = newTextArray[i];
          if (oldItem.text !== newItem.text) return true;
          var oldStyle = oldItem.style, newStyle = newItem.style;
          if (oldStyle) {
            if (newStyle) {
              if (!oldStyle.outline !== !newStyle.outline) return true;
              if (oldStyle.size !== newStyle.size || !oldStyle.italic !== !newStyle.italic || oldStyle.isImage !== newStyle.isImage) return true;
              if (oldStyle.src !== newStyle.src || oldStyle.imageAlign !== newStyle.imageAlign || oldStyle.imageHeight !== newStyle.imageHeight || oldStyle.imageWidth !== newStyle.imageWidth || oldStyle.imageOffset !== newStyle.imageOffset) return true;
            } else if (oldStyle.size || oldStyle.italic || oldStyle.isImage || oldStyle.outline) return true;
          } else if (newStyle && (newStyle.size || newStyle.italic || newStyle.isImage || newStyle.outline)) return true;
        }
        return false;
      },
      _addRichTextImageElement: function _addRichTextImageElement(richTextElement) {
        var spriteFrameName = richTextElement.style.src;
        var spriteFrame = this.imageAtlas.getSpriteFrame(spriteFrameName);
        if (spriteFrame) {
          var spriteNode = new cc.PrivateNode(RichTextChildImageName);
          var spriteComponent = spriteNode.addComponent(cc.Sprite);
          switch (richTextElement.style.imageAlign) {
           case "top":
            spriteNode.setAnchorPoint(0, 1);
            break;

           case "center":
            spriteNode.setAnchorPoint(0, .5);
            break;

           default:
            spriteNode.setAnchorPoint(0, 0);
          }
          richTextElement.style.imageOffset && (spriteNode._imageOffset = richTextElement.style.imageOffset);
          spriteComponent.type = cc.Sprite.Type.SLICED;
          spriteComponent.sizeMode = cc.Sprite.SizeMode.CUSTOM;
          this.node.addChild(spriteNode);
          this._labelSegments.push(spriteNode);
          var spriteRect = spriteFrame.getRect();
          var scaleFactor = 1;
          var spriteWidth = spriteRect.width;
          var spriteHeight = spriteRect.height;
          var expectWidth = richTextElement.style.imageWidth;
          var expectHeight = richTextElement.style.imageHeight;
          if (expectHeight > 0) {
            scaleFactor = expectHeight / spriteHeight;
            spriteWidth *= scaleFactor;
            spriteHeight *= scaleFactor;
          } else {
            scaleFactor = this.lineHeight / spriteHeight;
            spriteWidth *= scaleFactor;
            spriteHeight *= scaleFactor;
          }
          expectWidth > 0 && (spriteWidth = expectWidth);
          if (this.maxWidth > 0) {
            this._lineOffsetX + spriteWidth > this.maxWidth && this._updateLineInfo();
            this._lineOffsetX += spriteWidth;
          } else {
            this._lineOffsetX += spriteWidth;
            this._lineOffsetX > this._labelWidth && (this._labelWidth = this._lineOffsetX);
          }
          spriteComponent.spriteFrame = spriteFrame;
          spriteNode.setContentSize(spriteWidth, spriteHeight);
          spriteNode._lineCount = this._lineCount;
          if (richTextElement.style.event) {
            richTextElement.style.event.click && (spriteNode._clickHandler = richTextElement.style.event.click);
            richTextElement.style.event.param ? spriteNode._clickParam = richTextElement.style.event.param : spriteNode._clickParam = "";
          } else spriteNode._clickHandler = null;
        } else cc.warnID(4400);
      },
      _updateRichText: function _updateRichText() {
        if (!this.enabledInHierarchy) return;
        var newTextArray = _htmlTextParser.parse(this.string);
        if (!this._needsUpdateTextLayout(newTextArray)) {
          this._textArray = newTextArray;
          this._updateLabelSegmentTextAttributes();
          return;
        }
        this._textArray = newTextArray;
        this._resetState();
        var lastEmptyLine = false;
        var label;
        var labelSize;
        for (var i = 0; i < this._textArray.length; ++i) {
          var richTextElement = this._textArray[i];
          var text = richTextElement.text;
          if ("" === text) {
            if (richTextElement.style && richTextElement.style.newline) {
              this._updateLineInfo();
              continue;
            }
            if (richTextElement.style && richTextElement.style.isImage && this.imageAtlas) {
              this._addRichTextImageElement(richTextElement);
              continue;
            }
          }
          var multilineTexts = text.split("\n");
          for (var j = 0; j < multilineTexts.length; ++j) {
            var labelString = multilineTexts[j];
            if ("" === labelString) {
              if (this._isLastComponentCR(text) && j === multilineTexts.length - 1) continue;
              this._updateLineInfo();
              lastEmptyLine = true;
              continue;
            }
            lastEmptyLine = false;
            if (this.maxWidth > 0) {
              var labelWidth = this._measureText(i, labelString);
              this._updateRichTextWithMaxWidth(labelString, labelWidth, i);
              multilineTexts.length > 1 && j < multilineTexts.length - 1 && this._updateLineInfo();
            } else {
              label = this._addLabelSegment(labelString, i);
              labelSize = label.getContentSize();
              this._lineOffsetX += labelSize.width;
              this._lineOffsetX > this._labelWidth && (this._labelWidth = this._lineOffsetX);
              multilineTexts.length > 1 && j < multilineTexts.length - 1 && this._updateLineInfo();
            }
          }
        }
        lastEmptyLine || this._linesWidth.push(this._lineOffsetX);
        this.maxWidth > 0 && (this._labelWidth = this.maxWidth);
        this._labelHeight = (this._lineCount + textUtils.BASELINE_RATIO) * this.lineHeight;
        this.node.setContentSize(this._labelWidth, this._labelHeight);
        this._updateRichTextPosition();
        this._layoutDirty = false;
      },
      _getFirstWordLen: function _getFirstWordLen(text, startIndex, textLen) {
        var character = text.charAt(startIndex);
        if (textUtils.isUnicodeCJK(character) || textUtils.isUnicodeSpace(character)) return 1;
        var len = 1;
        for (var index = startIndex + 1; index < textLen; ++index) {
          character = text.charAt(index);
          if (textUtils.isUnicodeSpace(character) || textUtils.isUnicodeCJK(character)) break;
          len++;
        }
        return len;
      },
      _updateRichTextPosition: function _updateRichTextPosition() {
        var nextTokenX = 0;
        var nextLineIndex = 1;
        var totalLineCount = this._lineCount;
        for (var i = 0; i < this._labelSegments.length; ++i) {
          var label = this._labelSegments[i];
          var lineCount = label._lineCount;
          if (lineCount > nextLineIndex) {
            nextTokenX = 0;
            nextLineIndex = lineCount;
          }
          var lineOffsetX = 0;
          switch (this.horizontalAlign) {
           case HorizontalAlign.LEFT:
            lineOffsetX = -this._labelWidth / 2;
            break;

           case HorizontalAlign.CENTER:
            lineOffsetX = -this._linesWidth[lineCount - 1] / 2;
            break;

           case HorizontalAlign.RIGHT:
            lineOffsetX = this._labelWidth / 2 - this._linesWidth[lineCount - 1];
          }
          label.x = nextTokenX + lineOffsetX;
          var labelSize = label.getContentSize();
          label.y = this.lineHeight * (totalLineCount - lineCount) - this._labelHeight / 2;
          lineCount === nextLineIndex && (nextTokenX += labelSize.width);
          var sprite = label.getComponent(cc.Sprite);
          if (sprite) {
            var lineHeightSet = this.lineHeight;
            var lineHeightReal = this.lineHeight * (1 + textUtils.BASELINE_RATIO);
            switch (label.anchorY) {
             case 1:
              label.y += lineHeightSet + (lineHeightReal - lineHeightSet) / 2;
              break;

             case .5:
              label.y += lineHeightReal / 2;
              break;

             default:
              label.y += (lineHeightReal - lineHeightSet) / 2;
            }
            if (label._imageOffset) {
              var offsets = label._imageOffset.split(",");
              if (1 === offsets.length && offsets[0]) {
                var offsetY = parseFloat(offsets[0]);
                Number.isInteger(offsetY) && (label.y += offsetY);
              } else if (2 === offsets.length) {
                var offsetX = parseFloat(offsets[0]);
                var _offsetY = parseFloat(offsets[1]);
                Number.isInteger(offsetX) && (label.x += offsetX);
                Number.isInteger(_offsetY) && (label.y += _offsetY);
              }
            }
          }
          var outline = label.getComponent(cc.LabelOutline);
          outline && outline.width && (label.y = label.y - outline.width);
        }
      },
      _convertLiteralColorValue: function _convertLiteralColorValue(color) {
        var colorValue = color.toUpperCase();
        if (cc.Color[colorValue]) return cc.Color[colorValue];
        var out = cc.color();
        return out.fromHEX(color);
      },
      _applyTextAttribute: function _applyTextAttribute(labelNode, string, force) {
        var labelComponent = labelNode.getComponent(cc.Label);
        if (!labelComponent) return;
        var index = labelNode._styleIndex;
        var textStyle = null;
        this._textArray[index] && (textStyle = this._textArray[index].style);
        textStyle && textStyle.color ? labelNode.color = this._convertLiteralColorValue(textStyle.color) : labelNode.color = this.node.color;
        labelComponent.cacheMode = this.cacheMode;
        var isAsset = this.font instanceof cc.Font;
        isAsset && !this._isSystemFontUsed ? labelComponent.font = this.font : labelComponent.fontFamily = this.fontFamily;
        labelComponent.useSystemFont = this._isSystemFontUsed;
        labelComponent.lineHeight = this.lineHeight;
        labelComponent.enableBold = textStyle && textStyle.bold;
        labelComponent.enableItalics = textStyle && textStyle.italic;
        textStyle && textStyle.italic && (labelNode.skewX = 12);
        labelComponent.enableUnderline = textStyle && textStyle.underline;
        if (textStyle && textStyle.outline) {
          var labelOutlineComponent = labelNode.getComponent(cc.LabelOutline);
          labelOutlineComponent || (labelOutlineComponent = labelNode.addComponent(cc.LabelOutline));
          labelOutlineComponent.color = this._convertLiteralColorValue(textStyle.outline.color);
          labelOutlineComponent.width = textStyle.outline.width;
        }
        textStyle && textStyle.size ? labelComponent.fontSize = textStyle.size : labelComponent.fontSize = this.fontSize;
        if (null !== string) {
          "string" !== typeof string && (string = "" + string);
          labelComponent.string = string;
        }
        force && labelComponent._forceUpdateRenderData();
        if (textStyle && textStyle.event) {
          textStyle.event.click && (labelNode._clickHandler = textStyle.event.click);
          textStyle.event.param ? labelNode._clickParam = textStyle.event.param : labelNode._clickParam = "";
        } else labelNode._clickHandler = null;
      },
      onDestroy: function onDestroy() {
        for (var i = 0; i < this._labelSegments.length; ++i) {
          this._labelSegments[i].removeFromParent();
          pool.put(this._labelSegments[i]);
        }
      }
    });
    cc.RichText = module.exports = RichText;
  }), {
    "../platform/CCMacro": 143,
    "../platform/js": 158,
    "../utils/html-text-parser": 207,
    "../utils/text-utils": 216
  } ],
  102: [ (function(require, module, exports) {
    "use strict";
    var Widget = require("./CCWidget");
    var SafeArea = cc.Class({
      name: "cc.SafeArea",
      extends: require("./CCComponent"),
      editor: false,
      onEnable: function onEnable() {
        this.updateArea();
        cc.view.on("canvas-resize", this.updateArea, this);
      },
      onDisable: function onDisable() {
        cc.view.off("canvas-resize", this.updateArea, this);
      },
      updateArea: function updateArea() {
        var widget = this.node.getComponent(Widget);
        if (!widget) return;
        false;
        widget.updateAlignment();
        var lastPos = this.node.position;
        var lastAnchorPoint = this.node.getAnchorPoint();
        widget.isAlignTop = widget.isAlignBottom = widget.isAlignLeft = widget.isAlignRight = true;
        var screenWidth = cc.winSize.width, screenHeight = cc.winSize.height;
        var safeArea = cc.sys.getSafeAreaRect();
        widget.top = screenHeight - safeArea.y - safeArea.height;
        widget.bottom = safeArea.y;
        widget.left = safeArea.x;
        widget.right = screenWidth - safeArea.x - safeArea.width;
        widget.updateAlignment();
        var curPos = this.node.position;
        var anchorX = lastAnchorPoint.x - (curPos.x - lastPos.x) / this.node.width;
        var anchorY = lastAnchorPoint.y - (curPos.y - lastPos.y) / this.node.height;
        this.node.setAnchorPoint(anchorX, anchorY);
        widget.enabled = true;
      }
    });
    cc.SafeArea = module.exports = SafeArea;
  }), {
    "./CCComponent": 94,
    "./CCWidget": 111
  } ],
  103: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var GETTINGSHORTERFACTOR = 20;
    var Direction = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1
    });
    var Scrollbar = cc.Class({
      name: "cc.Scrollbar",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        _scrollView: null,
        _touching: false,
        _autoHideRemainingTime: {
          default: 0,
          serializable: false
        },
        _opacity: 255,
        handle: {
          default: null,
          type: cc.Sprite,
          tooltip: false,
          notify: function notify() {
            this._onScroll(cc.v2(0, 0));
          },
          animatable: false
        },
        direction: {
          default: Direction.HORIZONTAL,
          type: Direction,
          tooltip: false,
          notify: function notify() {
            this._onScroll(cc.v2(0, 0));
          },
          animatable: false
        },
        enableAutoHide: {
          default: true,
          animatable: false,
          tooltip: false
        },
        autoHideTime: {
          default: 1,
          animatable: false,
          tooltip: false
        }
      },
      statics: {
        Direction: Direction
      },
      setTargetScrollView: function setTargetScrollView(scrollView) {
        this._scrollView = scrollView;
      },
      _convertToScrollViewSpace: function _convertToScrollViewSpace(content) {
        var scrollViewNode = this._scrollView.node;
        var worldSpacePos = content.convertToWorldSpaceAR(cc.v2(-content.anchorX * content.width, -content.anchorY * content.height));
        var scrollViewSpacePos = scrollViewNode.convertToNodeSpaceAR(worldSpacePos);
        scrollViewSpacePos.x += scrollViewNode.anchorX * scrollViewNode.width;
        scrollViewSpacePos.y += scrollViewNode.anchorY * scrollViewNode.height;
        return scrollViewSpacePos;
      },
      _setOpacity: function _setOpacity(opacity) {
        if (this.handle) {
          this.node.opacity = opacity;
          this.handle.node.opacity = opacity;
        }
      },
      _onScroll: function _onScroll(outOfBoundary) {
        if (this._scrollView) {
          var content = this._scrollView.content;
          if (content) {
            var contentSize = content.getContentSize();
            var scrollViewSize = this._scrollView.node.getContentSize();
            var handleNodeSize = this.node.getContentSize();
            if (this._conditionalDisableScrollBar(contentSize, scrollViewSize)) return;
            if (this.enableAutoHide) {
              this._autoHideRemainingTime = this.autoHideTime;
              this._setOpacity(this._opacity);
            }
            var contentMeasure = 0;
            var scrollViewMeasure = 0;
            var outOfBoundaryValue = 0;
            var contentPosition = 0;
            var handleNodeMeasure = 0;
            if (this.direction === Direction.HORIZONTAL) {
              contentMeasure = contentSize.width;
              scrollViewMeasure = scrollViewSize.width;
              handleNodeMeasure = handleNodeSize.width;
              outOfBoundaryValue = outOfBoundary.x;
              contentPosition = -this._convertToScrollViewSpace(content).x;
            } else if (this.direction === Direction.VERTICAL) {
              contentMeasure = contentSize.height;
              scrollViewMeasure = scrollViewSize.height;
              handleNodeMeasure = handleNodeSize.height;
              outOfBoundaryValue = outOfBoundary.y;
              contentPosition = -this._convertToScrollViewSpace(content).y;
            }
            var length = this._calculateLength(contentMeasure, scrollViewMeasure, handleNodeMeasure, outOfBoundaryValue);
            var position = this._calculatePosition(contentMeasure, scrollViewMeasure, handleNodeMeasure, contentPosition, outOfBoundaryValue, length);
            this._updateLength(length);
            this._updateHanlderPosition(position);
          }
        }
      },
      _updateHanlderPosition: function _updateHanlderPosition(position) {
        if (this.handle) {
          var oldPosition = this._fixupHandlerPosition();
          this.handle.node.setPosition(position.x + oldPosition.x, position.y + oldPosition.y);
        }
      },
      _fixupHandlerPosition: function _fixupHandlerPosition() {
        var barSize = this.node.getContentSize();
        var barAnchor = this.node.getAnchorPoint();
        var handleSize = this.handle.node.getContentSize();
        var handleParent = this.handle.node.parent;
        var leftBottomWorldPosition = this.node.convertToWorldSpaceAR(cc.v2(-barSize.width * barAnchor.x, -barSize.height * barAnchor.y));
        var fixupPosition = handleParent.convertToNodeSpaceAR(leftBottomWorldPosition);
        this.direction === Direction.HORIZONTAL ? fixupPosition = cc.v2(fixupPosition.x, fixupPosition.y + (barSize.height - handleSize.height) / 2) : this.direction === Direction.VERTICAL && (fixupPosition = cc.v2(fixupPosition.x + (barSize.width - handleSize.width) / 2, fixupPosition.y));
        this.handle.node.setPosition(fixupPosition);
        return fixupPosition;
      },
      _onTouchBegan: function _onTouchBegan() {
        if (!this.enableAutoHide) return;
        this._touching = true;
      },
      _conditionalDisableScrollBar: function _conditionalDisableScrollBar(contentSize, scrollViewSize) {
        if (contentSize.width <= scrollViewSize.width && this.direction === Direction.HORIZONTAL) return true;
        if (contentSize.height <= scrollViewSize.height && this.direction === Direction.VERTICAL) return true;
        return false;
      },
      _onTouchEnded: function _onTouchEnded() {
        if (!this.enableAutoHide) return;
        this._touching = false;
        if (this.autoHideTime <= 0) return;
        if (this._scrollView) {
          var content = this._scrollView.content;
          if (content) {
            var contentSize = content.getContentSize();
            var scrollViewSize = this._scrollView.node.getContentSize();
            if (this._conditionalDisableScrollBar(contentSize, scrollViewSize)) return;
          }
        }
        this._autoHideRemainingTime = this.autoHideTime;
      },
      _calculateLength: function _calculateLength(contentMeasure, scrollViewMeasure, handleNodeMeasure, outOfBoundary) {
        var denominatorValue = contentMeasure;
        outOfBoundary && (denominatorValue += (outOfBoundary > 0 ? outOfBoundary : -outOfBoundary) * GETTINGSHORTERFACTOR);
        var lengthRation = scrollViewMeasure / denominatorValue;
        return handleNodeMeasure * lengthRation;
      },
      _calculatePosition: function _calculatePosition(contentMeasure, scrollViewMeasure, handleNodeMeasure, contentPosition, outOfBoundary, actualLenth) {
        var denominatorValue = contentMeasure - scrollViewMeasure;
        outOfBoundary && (denominatorValue += Math.abs(outOfBoundary));
        var positionRatio = 0;
        if (denominatorValue) {
          positionRatio = contentPosition / denominatorValue;
          positionRatio = misc.clamp01(positionRatio);
        }
        var position = (handleNodeMeasure - actualLenth) * positionRatio;
        return this.direction === Direction.VERTICAL ? cc.v2(0, position) : cc.v2(position, 0);
      },
      _updateLength: function _updateLength(length) {
        if (this.handle) {
          var handleNode = this.handle.node;
          var handleNodeSize = handleNode.getContentSize();
          handleNode.setAnchorPoint(cc.v2(0, 0));
          this.direction === Direction.HORIZONTAL ? handleNode.setContentSize(length, handleNodeSize.height) : handleNode.setContentSize(handleNodeSize.width, length);
        }
      },
      _processAutoHide: function _processAutoHide(deltaTime) {
        if (!this.enableAutoHide || this._autoHideRemainingTime <= 0) return;
        if (this._touching) return;
        this._autoHideRemainingTime -= deltaTime;
        if (this._autoHideRemainingTime <= this.autoHideTime) {
          this._autoHideRemainingTime = Math.max(0, this._autoHideRemainingTime);
          var opacity = this._opacity * (this._autoHideRemainingTime / this.autoHideTime);
          this._setOpacity(opacity);
        }
      },
      start: function start() {
        this.enableAutoHide && this._setOpacity(0);
      },
      hide: function hide() {
        this._autoHideRemainingTime = 0;
        this._setOpacity(0);
      },
      show: function show() {
        this._autoHideRemainingTime = this.autoHideTime;
        this._setOpacity(this._opacity);
      },
      update: function update(dt) {
        this._processAutoHide(dt);
      }
    });
    cc.Scrollbar = module.exports = Scrollbar;
  }), {
    "../utils/misc": 209,
    "./CCComponent": 94
  } ],
  104: [ (function(require, module, exports) {
    "use strict";
    var NodeEvent = require("../CCNode").EventType;
    var NUMBER_OF_GATHERED_TOUCHES_FOR_MOVE_SPEED = 5;
    var OUT_OF_BOUNDARY_BREAKING_FACTOR = .05;
    var EPSILON = 1e-4;
    var MOVEMENT_FACTOR = .7;
    var _tempPoint = cc.v2();
    var _tempPrevPoint = cc.v2();
    var quintEaseOut = function quintEaseOut(time) {
      time -= 1;
      return time * time * time * time * time + 1;
    };
    var getTimeInMilliseconds = function getTimeInMilliseconds() {
      var currentTime = new Date();
      return currentTime.getMilliseconds();
    };
    var EventType = cc.Enum({
      SCROLL_TO_TOP: 0,
      SCROLL_TO_BOTTOM: 1,
      SCROLL_TO_LEFT: 2,
      SCROLL_TO_RIGHT: 3,
      SCROLLING: 4,
      BOUNCE_TOP: 5,
      BOUNCE_BOTTOM: 6,
      BOUNCE_LEFT: 7,
      BOUNCE_RIGHT: 8,
      SCROLL_ENDED: 9,
      TOUCH_UP: 10,
      AUTOSCROLL_ENDED_WITH_THRESHOLD: 11,
      SCROLL_BEGAN: 12
    });
    var eventMap = {
      "scroll-to-top": EventType.SCROLL_TO_TOP,
      "scroll-to-bottom": EventType.SCROLL_TO_BOTTOM,
      "scroll-to-left": EventType.SCROLL_TO_LEFT,
      "scroll-to-right": EventType.SCROLL_TO_RIGHT,
      scrolling: EventType.SCROLLING,
      "bounce-bottom": EventType.BOUNCE_BOTTOM,
      "bounce-left": EventType.BOUNCE_LEFT,
      "bounce-right": EventType.BOUNCE_RIGHT,
      "bounce-top": EventType.BOUNCE_TOP,
      "scroll-ended": EventType.SCROLL_ENDED,
      "touch-up": EventType.TOUCH_UP,
      "scroll-ended-with-threshold": EventType.AUTOSCROLL_ENDED_WITH_THRESHOLD,
      "scroll-began": EventType.SCROLL_BEGAN
    };
    var ScrollView = cc.Class({
      name: "cc.ScrollView",
      extends: require("./CCViewGroup"),
      editor: false,
      ctor: function ctor() {
        this._topBoundary = 0;
        this._bottomBoundary = 0;
        this._leftBoundary = 0;
        this._rightBoundary = 0;
        this._touchMoveDisplacements = [];
        this._touchMoveTimeDeltas = [];
        this._touchMovePreviousTimestamp = 0;
        this._touchMoved = false;
        this._autoScrolling = false;
        this._autoScrollAttenuate = false;
        this._autoScrollStartPosition = cc.v2(0, 0);
        this._autoScrollTargetDelta = cc.v2(0, 0);
        this._autoScrollTotalTime = 0;
        this._autoScrollAccumulatedTime = 0;
        this._autoScrollCurrentlyOutOfBoundary = false;
        this._autoScrollBraking = false;
        this._autoScrollBrakingStartPosition = cc.v2(0, 0);
        this._outOfBoundaryAmount = cc.v2(0, 0);
        this._outOfBoundaryAmountDirty = true;
        this._stopMouseWheel = false;
        this._mouseWheelEventElapsedTime = 0;
        this._isScrollEndedWithThresholdEventFired = false;
        this._scrollEventEmitMask = 0;
        this._isBouncing = false;
        this._scrolling = false;
      },
      properties: {
        content: {
          default: void 0,
          type: cc.Node,
          tooltip: false,
          formerlySerializedAs: "content",
          notify: function notify(oldValue) {
            this._calculateBoundary();
          }
        },
        horizontal: {
          default: true,
          animatable: false,
          tooltip: false
        },
        vertical: {
          default: true,
          animatable: false,
          tooltip: false
        },
        inertia: {
          default: true,
          tooltip: false
        },
        brake: {
          default: .5,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          tooltip: false
        },
        elastic: {
          default: true,
          animatable: false,
          tooltip: false
        },
        bounceDuration: {
          default: 1,
          range: [ 0, 10 ],
          tooltip: false
        },
        horizontalScrollBar: {
          default: void 0,
          type: cc.Scrollbar,
          tooltip: false,
          notify: function notify() {
            if (this.horizontalScrollBar) {
              this.horizontalScrollBar.setTargetScrollView(this);
              this._updateScrollBar(0);
            }
          },
          animatable: false
        },
        verticalScrollBar: {
          default: void 0,
          type: cc.Scrollbar,
          tooltip: false,
          notify: function notify() {
            if (this.verticalScrollBar) {
              this.verticalScrollBar.setTargetScrollView(this);
              this._updateScrollBar(0);
            }
          },
          animatable: false
        },
        scrollEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        },
        cancelInnerEvents: {
          default: true,
          animatable: false,
          tooltip: false
        },
        _view: {
          get: function get() {
            if (this.content) return this.content.parent;
          }
        }
      },
      statics: {
        EventType: EventType
      },
      scrollToBottom: function scrollToBottom(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 0),
          applyToHorizontal: false,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta, true);
      },
      scrollToTop: function scrollToTop(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 1),
          applyToHorizontal: false,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToLeft: function scrollToLeft(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 0),
          applyToHorizontal: true,
          applyToVertical: false
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToRight: function scrollToRight(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(1, 0),
          applyToHorizontal: true,
          applyToVertical: false
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToTopLeft: function scrollToTopLeft(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 1),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToTopRight: function scrollToTopRight(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(1, 1),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToBottomLeft: function scrollToBottomLeft(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, 0),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToBottomRight: function scrollToBottomRight(timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(1, 0),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToOffset: function scrollToOffset(offset, timeInSecond, attenuated) {
        var maxScrollOffset = this.getMaxScrollOffset();
        var anchor = cc.v2(0, 0);
        0 === maxScrollOffset.x ? anchor.x = 0 : anchor.x = offset.x / maxScrollOffset.x;
        0 === maxScrollOffset.y ? anchor.y = 1 : anchor.y = (maxScrollOffset.y - offset.y) / maxScrollOffset.y;
        this.scrollTo(anchor, timeInSecond, attenuated);
      },
      getScrollOffset: function getScrollOffset() {
        var topDelta = this._getContentTopBoundary() - this._topBoundary;
        var leftDeta = this._getContentLeftBoundary() - this._leftBoundary;
        return cc.v2(leftDeta, topDelta);
      },
      getMaxScrollOffset: function getMaxScrollOffset() {
        var viewSize = this._view.getContentSize();
        var contentSize = this.content.getContentSize();
        var horizontalMaximizeOffset = contentSize.width - viewSize.width;
        var verticalMaximizeOffset = contentSize.height - viewSize.height;
        horizontalMaximizeOffset = horizontalMaximizeOffset >= 0 ? horizontalMaximizeOffset : 0;
        verticalMaximizeOffset = verticalMaximizeOffset >= 0 ? verticalMaximizeOffset : 0;
        return cc.v2(horizontalMaximizeOffset, verticalMaximizeOffset);
      },
      scrollToPercentHorizontal: function scrollToPercentHorizontal(percent, timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(percent, 0),
          applyToHorizontal: true,
          applyToVertical: false
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollTo: function scrollTo(anchor, timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(anchor),
          applyToHorizontal: true,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      scrollToPercentVertical: function scrollToPercentVertical(percent, timeInSecond, attenuated) {
        var moveDelta = this._calculateMovePercentDelta({
          anchor: cc.v2(0, percent),
          applyToHorizontal: false,
          applyToVertical: true
        });
        timeInSecond ? this._startAutoScroll(moveDelta, timeInSecond, false !== attenuated) : this._moveContent(moveDelta);
      },
      stopAutoScroll: function stopAutoScroll() {
        this._autoScrolling = false;
        this._autoScrollAccumulatedTime = this._autoScrollTotalTime;
      },
      setContentPosition: function setContentPosition(position) {
        if (position.fuzzyEquals(this.getContentPosition(), EPSILON)) return;
        this.content.setPosition(position);
        this._outOfBoundaryAmountDirty = true;
      },
      getContentPosition: function getContentPosition() {
        return this.content.getPosition();
      },
      isScrolling: function isScrolling() {
        return this._scrolling;
      },
      isAutoScrolling: function isAutoScrolling() {
        return this._autoScrolling;
      },
      _registerEvent: function _registerEvent() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this, true);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this, true);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this, true);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this, true);
        this.node.on(cc.Node.EventType.MOUSE_WHEEL, this._onMouseWheel, this, true);
      },
      _unregisterEvent: function _unregisterEvent() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this, true);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this, true);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this, true);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this, true);
        this.node.off(cc.Node.EventType.MOUSE_WHEEL, this._onMouseWheel, this, true);
      },
      _onMouseWheel: function _onMouseWheel(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        var deltaMove = cc.v2(0, 0);
        var wheelPrecision = -.1;
        false, false;
        this.vertical ? deltaMove = cc.v2(0, event.getScrollY() * wheelPrecision) : this.horizontal && (deltaMove = cc.v2(event.getScrollY() * wheelPrecision, 0));
        this._mouseWheelEventElapsedTime = 0;
        this._processDeltaMove(deltaMove);
        if (!this._stopMouseWheel) {
          this._handlePressLogic();
          this.schedule(this._checkMouseWheel, 1 / 60);
          this._stopMouseWheel = true;
        }
        this._stopPropagationIfTargetIsMe(event);
      },
      _checkMouseWheel: function _checkMouseWheel(dt) {
        var currentOutOfBoundary = this._getHowMuchOutOfBoundary();
        var maxElapsedTime = .1;
        if (!currentOutOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON)) {
          this._processInertiaScroll();
          this.unschedule(this._checkMouseWheel);
          this._dispatchEvent("scroll-ended");
          this._stopMouseWheel = false;
          return;
        }
        this._mouseWheelEventElapsedTime += dt;
        if (this._mouseWheelEventElapsedTime > maxElapsedTime) {
          this._onScrollBarTouchEnded();
          this.unschedule(this._checkMouseWheel);
          this._dispatchEvent("scroll-ended");
          this._stopMouseWheel = false;
        }
      },
      _calculateMovePercentDelta: function _calculateMovePercentDelta(options) {
        var anchor = options.anchor;
        var applyToHorizontal = options.applyToHorizontal;
        var applyToVertical = options.applyToVertical;
        this._calculateBoundary();
        anchor = anchor.clampf(cc.v2(0, 0), cc.v2(1, 1));
        var scrollSize = this._view.getContentSize();
        var contentSize = this.content.getContentSize();
        var bottomDeta = this._getContentBottomBoundary() - this._bottomBoundary;
        bottomDeta = -bottomDeta;
        var leftDeta = this._getContentLeftBoundary() - this._leftBoundary;
        leftDeta = -leftDeta;
        var moveDelta = cc.v2(0, 0);
        var totalScrollDelta = 0;
        if (applyToHorizontal) {
          totalScrollDelta = contentSize.width - scrollSize.width;
          moveDelta.x = leftDeta - totalScrollDelta * anchor.x;
        }
        if (applyToVertical) {
          totalScrollDelta = contentSize.height - scrollSize.height;
          moveDelta.y = bottomDeta - totalScrollDelta * anchor.y;
        }
        return moveDelta;
      },
      _moveContentToTopLeft: function _moveContentToTopLeft(scrollViewSize) {
        var contentSize = this.content.getContentSize();
        var bottomDeta = this._getContentBottomBoundary() - this._bottomBoundary;
        bottomDeta = -bottomDeta;
        var moveDelta = cc.v2(0, 0);
        var totalScrollDelta = 0;
        var leftDeta = this._getContentLeftBoundary() - this._leftBoundary;
        leftDeta = -leftDeta;
        if (contentSize.height < scrollViewSize.height) {
          totalScrollDelta = contentSize.height - scrollViewSize.height;
          moveDelta.y = bottomDeta - totalScrollDelta;
        }
        if (contentSize.width < scrollViewSize.width) {
          totalScrollDelta = contentSize.width - scrollViewSize.width;
          moveDelta.x = leftDeta;
        }
        this._updateScrollBarState();
        this._moveContent(moveDelta);
        this._adjustContentOutOfBoundary();
      },
      _calculateBoundary: function _calculateBoundary() {
        if (this.content) {
          var layout = this.content.getComponent(cc.Layout);
          layout && layout.enabledInHierarchy && layout.updateLayout();
          var viewSize = this._view.getContentSize();
          var anchorX = viewSize.width * this._view.anchorX;
          var anchorY = viewSize.height * this._view.anchorY;
          this._leftBoundary = -anchorX;
          this._bottomBoundary = -anchorY;
          this._rightBoundary = this._leftBoundary + viewSize.width;
          this._topBoundary = this._bottomBoundary + viewSize.height;
          this._moveContentToTopLeft(viewSize);
        }
      },
      _hasNestedViewGroup: function _hasNestedViewGroup(event, captureListeners) {
        if (event.eventPhase !== cc.Event.CAPTURING_PHASE) return;
        if (captureListeners) for (var i = 0; i < captureListeners.length; ++i) {
          var item = captureListeners[i];
          if (this.node === item) {
            if (event.target.getComponent(cc.ViewGroup)) return true;
            return false;
          }
          if (item.getComponent(cc.ViewGroup)) return true;
        }
        return false;
      },
      _stopPropagationIfTargetIsMe: function _stopPropagationIfTargetIsMe(event) {
        event.eventPhase === cc.Event.AT_TARGET && event.target === this.node && event.stopPropagation();
      },
      _onTouchBegan: function _onTouchBegan(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        var touch = event.touch;
        this.content && this._handlePressLogic(touch);
        this._touchMoved = false;
        this._stopPropagationIfTargetIsMe(event);
      },
      _onTouchMoved: function _onTouchMoved(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        var touch = event.touch;
        this.content && this._handleMoveLogic(touch);
        if (!this.cancelInnerEvents) return;
        var deltaMove = touch.getLocation().sub(touch.getStartLocation());
        if (deltaMove.mag() > 7 && !this._touchMoved && event.target !== this.node) {
          var cancelEvent = new cc.Event.EventTouch(event.getTouches(), event.bubbles);
          cancelEvent.type = cc.Node.EventType.TOUCH_CANCEL;
          cancelEvent.touch = event.touch;
          cancelEvent.simulate = true;
          event.target.dispatchEvent(cancelEvent);
          this._touchMoved = true;
        }
        this._stopPropagationIfTargetIsMe(event);
      },
      _onTouchEnded: function _onTouchEnded(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        this._dispatchEvent("touch-up");
        var touch = event.touch;
        this.content && this._handleReleaseLogic(touch);
        this._touchMoved ? event.stopPropagation() : this._stopPropagationIfTargetIsMe(event);
      },
      _onTouchCancelled: function _onTouchCancelled(event, captureListeners) {
        if (!this.enabledInHierarchy) return;
        if (this._hasNestedViewGroup(event, captureListeners)) return;
        if (!event.simulate) {
          var touch = event.touch;
          this.content && this._handleReleaseLogic(touch);
        }
        this._stopPropagationIfTargetIsMe(event);
      },
      _processDeltaMove: function _processDeltaMove(deltaMove) {
        this._scrollChildren(deltaMove);
        this._gatherTouchMove(deltaMove);
      },
      _getLocalAxisAlignDelta: function _getLocalAxisAlignDelta(touch) {
        this.node.convertToNodeSpaceAR(touch.getLocation(), _tempPoint);
        this.node.convertToNodeSpaceAR(touch.getPreviousLocation(), _tempPrevPoint);
        return _tempPoint.sub(_tempPrevPoint);
      },
      _handleMoveLogic: function _handleMoveLogic(touch) {
        var deltaMove = this._getLocalAxisAlignDelta(touch);
        this._processDeltaMove(deltaMove);
      },
      _scrollChildren: function _scrollChildren(deltaMove) {
        deltaMove = this._clampDelta(deltaMove);
        var realMove = deltaMove;
        var outOfBoundary;
        if (this.elastic) {
          outOfBoundary = this._getHowMuchOutOfBoundary();
          realMove.x *= 0 === outOfBoundary.x ? 1 : .5;
          realMove.y *= 0 === outOfBoundary.y ? 1 : .5;
        }
        if (!this.elastic) {
          outOfBoundary = this._getHowMuchOutOfBoundary(realMove);
          realMove = realMove.add(outOfBoundary);
        }
        var scrollEventType = -1;
        if (realMove.y > 0) {
          var icBottomPos = this.content.y - this.content.anchorY * this.content.height;
          icBottomPos + realMove.y >= this._bottomBoundary && (scrollEventType = "scroll-to-bottom");
        } else if (realMove.y < 0) {
          var icTopPos = this.content.y - this.content.anchorY * this.content.height + this.content.height;
          icTopPos + realMove.y <= this._topBoundary && (scrollEventType = "scroll-to-top");
        }
        if (realMove.x < 0) {
          var icRightPos = this.content.x - this.content.anchorX * this.content.width + this.content.width;
          icRightPos + realMove.x <= this._rightBoundary && (scrollEventType = "scroll-to-right");
        } else if (realMove.x > 0) {
          var icLeftPos = this.content.x - this.content.anchorX * this.content.width;
          icLeftPos + realMove.x >= this._leftBoundary && (scrollEventType = "scroll-to-left");
        }
        this._moveContent(realMove, false);
        if (0 !== realMove.x || 0 !== realMove.y) {
          if (!this._scrolling) {
            this._scrolling = true;
            this._dispatchEvent("scroll-began");
          }
          this._dispatchEvent("scrolling");
        }
        -1 !== scrollEventType && this._dispatchEvent(scrollEventType);
      },
      _handlePressLogic: function _handlePressLogic() {
        this._autoScrolling && this._dispatchEvent("scroll-ended");
        this._autoScrolling = false;
        this._isBouncing = false;
        this._touchMovePreviousTimestamp = getTimeInMilliseconds();
        this._touchMoveDisplacements.length = 0;
        this._touchMoveTimeDeltas.length = 0;
        this._onScrollBarTouchBegan();
      },
      _clampDelta: function _clampDelta(delta) {
        var contentSize = this.content.getContentSize();
        var scrollViewSize = this._view.getContentSize();
        contentSize.width < scrollViewSize.width && (delta.x = 0);
        contentSize.height < scrollViewSize.height && (delta.y = 0);
        return delta;
      },
      _gatherTouchMove: function _gatherTouchMove(delta) {
        delta = this._clampDelta(delta);
        while (this._touchMoveDisplacements.length >= NUMBER_OF_GATHERED_TOUCHES_FOR_MOVE_SPEED) {
          this._touchMoveDisplacements.shift();
          this._touchMoveTimeDeltas.shift();
        }
        this._touchMoveDisplacements.push(delta);
        var timeStamp = getTimeInMilliseconds();
        this._touchMoveTimeDeltas.push((timeStamp - this._touchMovePreviousTimestamp) / 1e3);
        this._touchMovePreviousTimestamp = timeStamp;
      },
      _startBounceBackIfNeeded: function _startBounceBackIfNeeded() {
        if (!this.elastic) return false;
        var bounceBackAmount = this._getHowMuchOutOfBoundary();
        bounceBackAmount = this._clampDelta(bounceBackAmount);
        if (bounceBackAmount.fuzzyEquals(cc.v2(0, 0), EPSILON)) return false;
        var bounceBackTime = Math.max(this.bounceDuration, 0);
        this._startAutoScroll(bounceBackAmount, bounceBackTime, true);
        if (!this._isBouncing) {
          bounceBackAmount.y > 0 && this._dispatchEvent("bounce-top");
          bounceBackAmount.y < 0 && this._dispatchEvent("bounce-bottom");
          bounceBackAmount.x > 0 && this._dispatchEvent("bounce-right");
          bounceBackAmount.x < 0 && this._dispatchEvent("bounce-left");
          this._isBouncing = true;
        }
        return true;
      },
      _processInertiaScroll: function _processInertiaScroll() {
        var bounceBackStarted = this._startBounceBackIfNeeded();
        if (!bounceBackStarted && this.inertia) {
          var touchMoveVelocity = this._calculateTouchMoveVelocity();
          !touchMoveVelocity.fuzzyEquals(cc.v2(0, 0), EPSILON) && this.brake < 1 && this._startInertiaScroll(touchMoveVelocity);
        }
        this._onScrollBarTouchEnded();
      },
      _handleReleaseLogic: function _handleReleaseLogic(touch) {
        var delta = this._getLocalAxisAlignDelta(touch);
        this._gatherTouchMove(delta);
        this._processInertiaScroll();
        if (this._scrolling) {
          this._scrolling = false;
          this._autoScrolling || this._dispatchEvent("scroll-ended");
        }
      },
      _isOutOfBoundary: function _isOutOfBoundary() {
        var outOfBoundary = this._getHowMuchOutOfBoundary();
        return !outOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON);
      },
      _isNecessaryAutoScrollBrake: function _isNecessaryAutoScrollBrake() {
        if (this._autoScrollBraking) return true;
        if (this._isOutOfBoundary()) {
          if (!this._autoScrollCurrentlyOutOfBoundary) {
            this._autoScrollCurrentlyOutOfBoundary = true;
            this._autoScrollBraking = true;
            this._autoScrollBrakingStartPosition = this.getContentPosition();
            return true;
          }
        } else this._autoScrollCurrentlyOutOfBoundary = false;
        return false;
      },
      getScrollEndedEventTiming: function getScrollEndedEventTiming() {
        return EPSILON;
      },
      _processAutoScrolling: function _processAutoScrolling(dt) {
        var isAutoScrollBrake = this._isNecessaryAutoScrollBrake();
        var brakingFactor = isAutoScrollBrake ? OUT_OF_BOUNDARY_BREAKING_FACTOR : 1;
        this._autoScrollAccumulatedTime += dt * (1 / brakingFactor);
        var percentage = Math.min(1, this._autoScrollAccumulatedTime / this._autoScrollTotalTime);
        this._autoScrollAttenuate && (percentage = quintEaseOut(percentage));
        var newPosition = this._autoScrollStartPosition.add(this._autoScrollTargetDelta.mul(percentage));
        var reachedEnd = Math.abs(percentage - 1) <= EPSILON;
        var fireEvent = Math.abs(percentage - 1) <= this.getScrollEndedEventTiming();
        if (fireEvent && !this._isScrollEndedWithThresholdEventFired) {
          this._dispatchEvent("scroll-ended-with-threshold");
          this._isScrollEndedWithThresholdEventFired = true;
        }
        if (this.elastic) {
          var brakeOffsetPosition = newPosition.sub(this._autoScrollBrakingStartPosition);
          isAutoScrollBrake && (brakeOffsetPosition = brakeOffsetPosition.mul(brakingFactor));
          newPosition = this._autoScrollBrakingStartPosition.add(brakeOffsetPosition);
        } else {
          var moveDelta = newPosition.sub(this.getContentPosition());
          var outOfBoundary = this._getHowMuchOutOfBoundary(moveDelta);
          if (!outOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON)) {
            newPosition = newPosition.add(outOfBoundary);
            reachedEnd = true;
          }
        }
        reachedEnd && (this._autoScrolling = false);
        var deltaMove = newPosition.sub(this.getContentPosition());
        this._moveContent(this._clampDelta(deltaMove), reachedEnd);
        this._dispatchEvent("scrolling");
        if (!this._autoScrolling) {
          this._isBouncing = false;
          this._scrolling = false;
          this._dispatchEvent("scroll-ended");
        }
      },
      _startInertiaScroll: function _startInertiaScroll(touchMoveVelocity) {
        var inertiaTotalMovement = touchMoveVelocity.mul(MOVEMENT_FACTOR);
        this._startAttenuatingAutoScroll(inertiaTotalMovement, touchMoveVelocity);
      },
      _calculateAttenuatedFactor: function _calculateAttenuatedFactor(distance) {
        if (this.brake <= 0) return 1 - this.brake;
        return (1 - this.brake) * (1 / (1 + 14e-6 * distance + distance * distance * 8e-9));
      },
      _startAttenuatingAutoScroll: function _startAttenuatingAutoScroll(deltaMove, initialVelocity) {
        var time = this._calculateAutoScrollTimeByInitalSpeed(initialVelocity.mag());
        var targetDelta = deltaMove.normalize();
        var contentSize = this.content.getContentSize();
        var scrollviewSize = this._view.getContentSize();
        var totalMoveWidth = contentSize.width - scrollviewSize.width;
        var totalMoveHeight = contentSize.height - scrollviewSize.height;
        var attenuatedFactorX = this._calculateAttenuatedFactor(totalMoveWidth);
        var attenuatedFactorY = this._calculateAttenuatedFactor(totalMoveHeight);
        targetDelta = cc.v2(targetDelta.x * totalMoveWidth * (1 - this.brake) * attenuatedFactorX, targetDelta.y * totalMoveHeight * attenuatedFactorY * (1 - this.brake));
        var originalMoveLength = deltaMove.mag();
        var factor = targetDelta.mag() / originalMoveLength;
        targetDelta = targetDelta.add(deltaMove);
        if (this.brake > 0 && factor > 7) {
          factor = Math.sqrt(factor);
          targetDelta = deltaMove.mul(factor).add(deltaMove);
        }
        if (this.brake > 0 && factor > 3) {
          factor = 3;
          time *= factor;
        }
        0 === this.brake && factor > 1 && (time *= factor);
        this._startAutoScroll(targetDelta, time, true);
      },
      _calculateAutoScrollTimeByInitalSpeed: function _calculateAutoScrollTimeByInitalSpeed(initalSpeed) {
        return Math.sqrt(Math.sqrt(initalSpeed / 5));
      },
      _startAutoScroll: function _startAutoScroll(deltaMove, timeInSecond, attenuated) {
        var adjustedDeltaMove = this._flattenVectorByDirection(deltaMove);
        this._autoScrolling = true;
        this._autoScrollTargetDelta = adjustedDeltaMove;
        this._autoScrollAttenuate = attenuated;
        this._autoScrollStartPosition = this.getContentPosition();
        this._autoScrollTotalTime = timeInSecond;
        this._autoScrollAccumulatedTime = 0;
        this._autoScrollBraking = false;
        this._isScrollEndedWithThresholdEventFired = false;
        this._autoScrollBrakingStartPosition = cc.v2(0, 0);
        var currentOutOfBoundary = this._getHowMuchOutOfBoundary();
        currentOutOfBoundary.fuzzyEquals(cc.v2(0, 0), EPSILON) || (this._autoScrollCurrentlyOutOfBoundary = true);
      },
      _calculateTouchMoveVelocity: function _calculateTouchMoveVelocity() {
        var totalTime = 0;
        totalTime = this._touchMoveTimeDeltas.reduce((function(a, b) {
          return a + b;
        }), totalTime);
        if (totalTime <= 0 || totalTime >= .5) return cc.v2(0, 0);
        var totalMovement = cc.v2(0, 0);
        totalMovement = this._touchMoveDisplacements.reduce((function(a, b) {
          return a.add(b);
        }), totalMovement);
        return cc.v2(totalMovement.x * (1 - this.brake) / totalTime, totalMovement.y * (1 - this.brake) / totalTime);
      },
      _flattenVectorByDirection: function _flattenVectorByDirection(vector) {
        var result = vector;
        result.x = this.horizontal ? result.x : 0;
        result.y = this.vertical ? result.y : 0;
        return result;
      },
      _moveContent: function _moveContent(deltaMove, canStartBounceBack) {
        var adjustedMove = this._flattenVectorByDirection(deltaMove);
        var newPosition = this.getContentPosition().add(adjustedMove);
        this.setContentPosition(newPosition);
        var outOfBoundary = this._getHowMuchOutOfBoundary();
        this._updateScrollBar(outOfBoundary);
        this.elastic && canStartBounceBack && this._startBounceBackIfNeeded();
      },
      _getContentLeftBoundary: function _getContentLeftBoundary() {
        var contentPos = this.getContentPosition();
        return contentPos.x - this.content.getAnchorPoint().x * this.content.getContentSize().width;
      },
      _getContentRightBoundary: function _getContentRightBoundary() {
        var contentSize = this.content.getContentSize();
        return this._getContentLeftBoundary() + contentSize.width;
      },
      _getContentTopBoundary: function _getContentTopBoundary() {
        var contentSize = this.content.getContentSize();
        return this._getContentBottomBoundary() + contentSize.height;
      },
      _getContentBottomBoundary: function _getContentBottomBoundary() {
        var contentPos = this.getContentPosition();
        return contentPos.y - this.content.getAnchorPoint().y * this.content.getContentSize().height;
      },
      _getHowMuchOutOfBoundary: function _getHowMuchOutOfBoundary(addition) {
        addition = addition || cc.v2(0, 0);
        if (addition.fuzzyEquals(cc.v2(0, 0), EPSILON) && !this._outOfBoundaryAmountDirty) return this._outOfBoundaryAmount;
        var outOfBoundaryAmount = cc.v2(0, 0);
        this._getContentLeftBoundary() + addition.x > this._leftBoundary ? outOfBoundaryAmount.x = this._leftBoundary - (this._getContentLeftBoundary() + addition.x) : this._getContentRightBoundary() + addition.x < this._rightBoundary && (outOfBoundaryAmount.x = this._rightBoundary - (this._getContentRightBoundary() + addition.x));
        this._getContentTopBoundary() + addition.y < this._topBoundary ? outOfBoundaryAmount.y = this._topBoundary - (this._getContentTopBoundary() + addition.y) : this._getContentBottomBoundary() + addition.y > this._bottomBoundary && (outOfBoundaryAmount.y = this._bottomBoundary - (this._getContentBottomBoundary() + addition.y));
        if (addition.fuzzyEquals(cc.v2(0, 0), EPSILON)) {
          this._outOfBoundaryAmount = outOfBoundaryAmount;
          this._outOfBoundaryAmountDirty = false;
        }
        outOfBoundaryAmount = this._clampDelta(outOfBoundaryAmount);
        return outOfBoundaryAmount;
      },
      _updateScrollBarState: function _updateScrollBarState() {
        if (!this.content) return;
        var contentSize = this.content.getContentSize();
        var scrollViewSize = this._view.getContentSize();
        this.verticalScrollBar && (contentSize.height < scrollViewSize.height ? this.verticalScrollBar.hide() : this.verticalScrollBar.show());
        this.horizontalScrollBar && (contentSize.width < scrollViewSize.width ? this.horizontalScrollBar.hide() : this.horizontalScrollBar.show());
      },
      _updateScrollBar: function _updateScrollBar(outOfBoundary) {
        this.horizontalScrollBar && this.horizontalScrollBar._onScroll(outOfBoundary);
        this.verticalScrollBar && this.verticalScrollBar._onScroll(outOfBoundary);
      },
      _onScrollBarTouchBegan: function _onScrollBarTouchBegan() {
        this.horizontalScrollBar && this.horizontalScrollBar._onTouchBegan();
        this.verticalScrollBar && this.verticalScrollBar._onTouchBegan();
      },
      _onScrollBarTouchEnded: function _onScrollBarTouchEnded() {
        this.horizontalScrollBar && this.horizontalScrollBar._onTouchEnded();
        this.verticalScrollBar && this.verticalScrollBar._onTouchEnded();
      },
      _dispatchEvent: function _dispatchEvent(event) {
        if ("scroll-ended" === event) this._scrollEventEmitMask = 0; else if ("scroll-to-top" === event || "scroll-to-bottom" === event || "scroll-to-left" === event || "scroll-to-right" === event) {
          var flag = 1 << eventMap[event];
          if (this._scrollEventEmitMask & flag) return;
          this._scrollEventEmitMask |= flag;
        }
        cc.Component.EventHandler.emitEvents(this.scrollEvents, this, eventMap[event]);
        this.node.emit(event, this);
      },
      _adjustContentOutOfBoundary: function _adjustContentOutOfBoundary() {
        this._outOfBoundaryAmountDirty = true;
        if (this._isOutOfBoundary()) {
          var outOfBoundary = this._getHowMuchOutOfBoundary(cc.v2(0, 0));
          var newPosition = this.getContentPosition().add(outOfBoundary);
          if (this.content) {
            this.content.setPosition(newPosition);
            this._updateScrollBar(0);
          }
        }
      },
      start: function start() {
        this._calculateBoundary();
        this.content && cc.director.once(cc.Director.EVENT_BEFORE_DRAW, this._adjustContentOutOfBoundary, this);
      },
      _hideScrollbar: function _hideScrollbar() {
        this.horizontalScrollBar && this.horizontalScrollBar.hide();
        this.verticalScrollBar && this.verticalScrollBar.hide();
      },
      onDisable: function onDisable() {
        true;
        this._unregisterEvent();
        if (this.content) {
          this.content.off(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          this.content.off(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
          if (this._view) {
            this._view.off(NodeEvent.POSITION_CHANGED, this._calculateBoundary, this);
            this._view.off(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
            this._view.off(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          }
        }
        this._hideScrollbar();
        this.stopAutoScroll();
      },
      onEnable: function onEnable() {
        true;
        this._registerEvent();
        if (this.content) {
          this.content.on(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          this.content.on(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
          if (this._view) {
            this._view.on(NodeEvent.POSITION_CHANGED, this._calculateBoundary, this);
            this._view.on(NodeEvent.SCALE_CHANGED, this._calculateBoundary, this);
            this._view.on(NodeEvent.SIZE_CHANGED, this._calculateBoundary, this);
          }
        }
        this._updateScrollBarState();
      },
      update: function update(dt) {
        this._autoScrolling && this._processAutoScrolling(dt);
      }
    });
    cc.ScrollView = module.exports = ScrollView;
  }), {
    "../CCNode": 26,
    "./CCViewGroup": 110
  } ],
  105: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var Component = require("./CCComponent");
    var Direction = cc.Enum({
      Horizontal: 0,
      Vertical: 1
    });
    var Slider = cc.Class({
      name: "cc.Slider",
      extends: Component,
      editor: false,
      ctor: function ctor() {
        this._offset = cc.v2();
        this._touchHandle = false;
        this._dragging = false;
      },
      properties: {
        handle: {
          default: null,
          type: cc.Button,
          tooltip: false,
          notify: function notify() {
            false;
          }
        },
        direction: {
          default: Direction.Horizontal,
          type: Direction,
          tooltip: false
        },
        progress: {
          default: .5,
          type: cc.Float,
          range: [ 0, 1, .1 ],
          slide: true,
          tooltip: false,
          notify: function notify() {
            this._updateHandlePosition();
          }
        },
        slideEvents: {
          default: [],
          type: cc.Component.EventHandler,
          tooltip: false
        }
      },
      statics: {
        Direction: Direction
      },
      __preload: function __preload() {
        this._updateHandlePosition();
      },
      onEnable: function onEnable() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this);
        if (this.handle && this.handle.isValid) {
          this.handle.node.on(cc.Node.EventType.TOUCH_START, this._onHandleDragStart, this);
          this.handle.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
          this.handle.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        }
      },
      onDisable: function onDisable() {
        this.node.off(cc.Node.EventType.TOUCH_START, this._onTouchBegan, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelled, this);
        if (this.handle && this.handle.isValid) {
          this.handle.node.off(cc.Node.EventType.TOUCH_START, this._onHandleDragStart, this);
          this.handle.node.off(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoved, this);
          this.handle.node.off(cc.Node.EventType.TOUCH_END, this._onTouchEnded, this);
        }
      },
      _onHandleDragStart: function _onHandleDragStart(event) {
        this._dragging = true;
        this._touchHandle = true;
        this._offset = this.handle.node.convertToNodeSpaceAR(event.touch.getLocation());
        event.stopPropagation();
      },
      _onTouchBegan: function _onTouchBegan(event) {
        if (!this.handle) return;
        this._dragging = true;
        this._touchHandle || this._handleSliderLogic(event.touch);
        event.stopPropagation();
      },
      _onTouchMoved: function _onTouchMoved(event) {
        if (!this._dragging) return;
        this._handleSliderLogic(event.touch);
        event.stopPropagation();
      },
      _onTouchEnded: function _onTouchEnded(event) {
        this._dragging = false;
        this._touchHandle = false;
        this._offset = cc.v2();
        event.stopPropagation();
      },
      _onTouchCancelled: function _onTouchCancelled(event) {
        this._dragging = false;
        event.stopPropagation();
      },
      _handleSliderLogic: function _handleSliderLogic(touch) {
        this._updateProgress(touch);
        this._emitSlideEvent();
      },
      _emitSlideEvent: function _emitSlideEvent() {
        cc.Component.EventHandler.emitEvents(this.slideEvents, this);
        this.node.emit("slide", this);
      },
      _updateProgress: function _updateProgress(touch) {
        if (!this.handle) return;
        var node = this.node;
        var localTouchPos = node.convertToNodeSpaceAR(touch.getLocation());
        this.direction === Direction.Horizontal ? this.progress = misc.clamp01((localTouchPos.x - this._offset.x + node.anchorX * node.width) / node.width) : this.progress = misc.clamp01((localTouchPos.y - this._offset.y + node.anchorY * node.height) / node.height);
      },
      _updateHandlePosition: function _updateHandlePosition() {
        if (!this.handle) return;
        var handlelocalPos;
        handlelocalPos = this.direction === Direction.Horizontal ? cc.v2(-this.node.width * this.node.anchorX + this.progress * this.node.width, 0) : cc.v2(0, -this.node.height * this.node.anchorY + this.progress * this.node.height);
        var worldSpacePos = this.node.convertToWorldSpaceAR(handlelocalPos);
        this.handle.node.position = this.handle.node.parent.convertToNodeSpaceAR(worldSpacePos);
      }
    });
    cc.Slider = module.exports = Slider;
  }), {
    "../utils/misc": 209,
    "./CCComponent": 94
  } ],
  106: [ (function(require, module, exports) {
    "use strict";
    var misc = require("../utils/misc");
    var NodeEvent = require("../CCNode").EventType;
    var RenderComponent = require("./CCRenderComponent");
    var BlendFunc = require("../utils/blend-func");
    var SpriteType = cc.Enum({
      SIMPLE: 0,
      SLICED: 1,
      TILED: 2,
      FILLED: 3,
      MESH: 4
    });
    var FillType = cc.Enum({
      HORIZONTAL: 0,
      VERTICAL: 1,
      RADIAL: 2
    });
    var SizeMode = cc.Enum({
      CUSTOM: 0,
      TRIMMED: 1,
      RAW: 2
    });
    var State = cc.Enum({
      NORMAL: 0,
      GRAY: 1
    });
    var Sprite = cc.Class({
      name: "cc.Sprite",
      extends: RenderComponent,
      mixins: [ BlendFunc ],
      editor: false,
      properties: {
        _spriteFrame: {
          default: null,
          type: cc.SpriteFrame
        },
        _type: SpriteType.SIMPLE,
        _sizeMode: SizeMode.TRIMMED,
        _fillType: 0,
        _fillCenter: cc.v2(0, 0),
        _fillStart: 0,
        _fillRange: 0,
        _isTrimmedMode: true,
        _atlas: {
          default: null,
          type: cc.SpriteAtlas,
          tooltip: false,
          editorOnly: true,
          visible: true,
          animatable: false
        },
        spriteFrame: {
          get: function get() {
            return this._spriteFrame;
          },
          set: function set(value, force) {
            var lastSprite = this._spriteFrame;
            false;
            if (lastSprite === value) return;
            this._spriteFrame = value;
            this._applySpriteFrame(lastSprite);
            false;
          },
          type: cc.SpriteFrame
        },
        type: {
          get: function get() {
            return this._type;
          },
          set: function set(value) {
            if (this._type !== value) {
              this._type = value;
              this.setVertsDirty();
              this._resetAssembler();
            }
          },
          type: SpriteType,
          animatable: false,
          tooltip: false
        },
        fillType: {
          get: function get() {
            return this._fillType;
          },
          set: function set(value) {
            if (value !== this._fillType) {
              this._fillType = value;
              this.setVertsDirty();
              this._resetAssembler();
            }
          },
          type: FillType,
          tooltip: false
        },
        fillCenter: {
          get: function get() {
            return this._fillCenter;
          },
          set: function set(value) {
            this._fillCenter.x = value.x;
            this._fillCenter.y = value.y;
            this._type === SpriteType.FILLED && this.setVertsDirty();
          },
          tooltip: false
        },
        fillStart: {
          get: function get() {
            return this._fillStart;
          },
          set: function set(value) {
            this._fillStart = misc.clampf(value, -1, 1);
            this._type === SpriteType.FILLED && this.setVertsDirty();
          },
          tooltip: false
        },
        fillRange: {
          get: function get() {
            return this._fillRange;
          },
          set: function set(value) {
            this._fillRange = misc.clampf(value, -1, 1);
            this._type === SpriteType.FILLED && this.setVertsDirty();
          },
          tooltip: false
        },
        trim: {
          get: function get() {
            return this._isTrimmedMode;
          },
          set: function set(value) {
            if (this._isTrimmedMode !== value) {
              this._isTrimmedMode = value;
              this._type !== SpriteType.SIMPLE && this._type !== SpriteType.MESH || this.setVertsDirty();
            }
          },
          animatable: false,
          tooltip: false
        },
        sizeMode: {
          get: function get() {
            return this._sizeMode;
          },
          set: function set(value) {
            this._sizeMode = value;
            value !== SizeMode.CUSTOM && this._applySpriteSize();
          },
          animatable: false,
          type: SizeMode,
          tooltip: false
        }
      },
      statics: {
        FillType: FillType,
        Type: SpriteType,
        SizeMode: SizeMode,
        State: State
      },
      setVisible: function setVisible(visible) {
        this.enabled = visible;
      },
      setState: function setState() {},
      getState: function getState() {},
      __preload: function __preload() {
        this._super();
        false;
        this._applySpriteFrame();
      },
      onEnable: function onEnable() {
        this._super();
        this._spriteFrame && this._spriteFrame.ensureLoadTexture();
        this.node.on(cc.Node.EventType.SIZE_CHANGED, this.setVertsDirty, this);
        this.node.on(cc.Node.EventType.ANCHOR_CHANGED, this.setVertsDirty, this);
      },
      onDisable: function onDisable() {
        this._super();
        this.node.off(cc.Node.EventType.SIZE_CHANGED, this.setVertsDirty, this);
        this.node.off(cc.Node.EventType.ANCHOR_CHANGED, this.setVertsDirty, this);
      },
      _updateMaterial: function _updateMaterial() {
        var texture = this._spriteFrame && this._spriteFrame.getTexture();
        var material = this.getMaterial(0);
        if (material) {
          void 0 !== material.getDefine("USE_TEXTURE") && material.define("USE_TEXTURE", true);
          material.setProperty("texture", texture);
        }
        BlendFunc.prototype._updateMaterial.call(this);
      },
      _applyAtlas: false,
      _validateRender: function _validateRender() {
        var spriteFrame = this._spriteFrame;
        if (this._materials[0] && spriteFrame && spriteFrame.textureLoaded()) return;
        this.disableRender();
      },
      _applySpriteSize: function _applySpriteSize() {
        if (!this._spriteFrame || !this.isValid) return;
        if (SizeMode.RAW === this._sizeMode) {
          var size = this._spriteFrame._originalSize;
          this.node.setContentSize(size);
        } else if (SizeMode.TRIMMED === this._sizeMode) {
          var rect = this._spriteFrame._rect;
          this.node.setContentSize(rect.width, rect.height);
        }
        this.setVertsDirty();
      },
      _applySpriteFrame: function _applySpriteFrame(oldFrame) {
        var oldTexture = oldFrame && oldFrame.getTexture();
        oldTexture && !oldTexture.loaded && oldFrame.off("load", this._applySpriteSize, this);
        var spriteFrame = this._spriteFrame;
        if (spriteFrame) {
          this._updateMaterial();
          var newTexture = spriteFrame.getTexture();
          if (newTexture && newTexture.loaded) this._applySpriteSize(); else {
            this.disableRender();
            spriteFrame.once("load", this._applySpriteSize, this);
          }
        } else this.disableRender();
        false;
      }
    });
    false;
    cc.Sprite = module.exports = Sprite;
  }), {
    "../CCNode": 26,
    "../utils/blend-func": 203,
    "../utils/misc": 209,
    "./CCRenderComponent": 100
  } ],
  107: [ (function(require, module, exports) {
    "use strict";
    var GraySpriteState = require("../utils/gray-sprite-state");
    var Toggle = cc.Class({
      name: "cc.Toggle",
      extends: require("./CCButton"),
      mixins: [ GraySpriteState ],
      editor: false,
      properties: {
        _N$isChecked: true,
        isChecked: {
          get: function get() {
            return this._N$isChecked;
          },
          set: function set(value) {
            if (value === this._N$isChecked) return;
            var group = this.toggleGroup || this._toggleContainer;
            if (group && group.enabled && this._N$isChecked && !group.allowSwitchOff) return;
            this._N$isChecked = value;
            this._updateCheckMark();
            group && group.enabled && group.updateToggles(this);
            cc.Toggle._triggerEventInScript_isChecked && this._emitToggleEvents();
          },
          tooltip: false
        },
        toggleGroup: {
          default: null,
          tooltip: false,
          type: require("./CCToggleGroup")
        },
        checkMark: {
          default: null,
          type: cc.Sprite,
          tooltip: false
        },
        checkEvents: {
          default: [],
          type: cc.Component.EventHandler
        },
        _resizeToTarget: {
          animatable: false,
          set: function set(value) {
            value && this._resizeNodeToTargetNode();
          }
        }
      },
      statics: {
        _triggerEventInScript_check: false,
        _triggerEventInScript_isChecked: false
      },
      onEnable: function onEnable() {
        this._super();
        true;
        this._registerToggleEvent();
        this.toggleGroup && this.toggleGroup.enabledInHierarchy && this.toggleGroup.addToggle(this);
      },
      onDisable: function onDisable() {
        this._super();
        true;
        this._unregisterToggleEvent();
        this.toggleGroup && this.toggleGroup.enabledInHierarchy && this.toggleGroup.removeToggle(this);
      },
      _hideCheckMark: function _hideCheckMark() {
        this._N$isChecked = false;
        this._updateCheckMark();
      },
      toggle: function toggle(event) {
        this.isChecked = !this.isChecked;
        cc.Toggle._triggerEventInScript_isChecked || !cc.Toggle._triggerEventInScript_check && !event || this._emitToggleEvents();
      },
      check: function check() {
        this.isChecked = true;
        !cc.Toggle._triggerEventInScript_isChecked && cc.Toggle._triggerEventInScript_check && this._emitToggleEvents();
      },
      uncheck: function uncheck() {
        this.isChecked = false;
        !cc.Toggle._triggerEventInScript_isChecked && cc.Toggle._triggerEventInScript_check && this._emitToggleEvents();
      },
      _updateCheckMark: function _updateCheckMark() {
        this.checkMark && (this.checkMark.node.active = !!this.isChecked);
      },
      _updateDisabledState: function _updateDisabledState() {
        this._super();
        if (this.enableAutoGrayEffect && this.checkMark) {
          var useGrayMaterial = !this.interactable;
          this._switchGrayMaterial(useGrayMaterial, this.checkMark);
        }
      },
      _registerToggleEvent: function _registerToggleEvent() {
        this.node.on("click", this.toggle, this);
      },
      _unregisterToggleEvent: function _unregisterToggleEvent() {
        this.node.off("click", this.toggle, this);
      },
      _emitToggleEvents: function _emitToggleEvents() {
        this.node.emit("toggle", this);
        this.checkEvents && cc.Component.EventHandler.emitEvents(this.checkEvents, this);
      }
    });
    cc.Toggle = module.exports = Toggle;
    var js = require("../platform/js");
    js.get(Toggle.prototype, "_toggleContainer", (function() {
      var parent = this.node.parent;
      if (cc.Node.isNode(parent)) return parent.getComponent(cc.ToggleContainer);
      return null;
    }));
  }), {
    "../platform/js": 158,
    "../utils/gray-sprite-state": 206,
    "./CCButton": 92,
    "./CCToggleGroup": 109
  } ],
  108: [ (function(require, module, exports) {
    "use strict";
    var ToggleContainer = cc.Class({
      name: "cc.ToggleContainer",
      extends: cc.Component,
      editor: false,
      properties: {
        allowSwitchOff: {
          tooltip: false,
          default: false
        },
        checkEvents: {
          default: [],
          type: cc.Component.EventHandler
        }
      },
      updateToggles: function updateToggles(toggle) {
        if (!this.enabledInHierarchy) return;
        if (toggle.isChecked) {
          this.toggleItems.forEach((function(item) {
            item !== toggle && item.isChecked && item.enabled && item._hideCheckMark();
          }));
          this.checkEvents && cc.Component.EventHandler.emitEvents(this.checkEvents, toggle);
        }
      },
      _allowOnlyOneToggleChecked: function _allowOnlyOneToggleChecked() {
        var isChecked = false;
        this.toggleItems.forEach((function(item) {
          isChecked ? item._hideCheckMark() : item.isChecked && (isChecked = true);
        }));
        return isChecked;
      },
      _makeAtLeastOneToggleChecked: function _makeAtLeastOneToggleChecked() {
        var isChecked = this._allowOnlyOneToggleChecked();
        if (!isChecked && !this.allowSwitchOff) {
          var toggleItems = this.toggleItems;
          toggleItems.length > 0 && toggleItems[0].check();
        }
      },
      onEnable: function onEnable() {
        this.node.on("child-added", this._allowOnlyOneToggleChecked, this);
        this.node.on("child-removed", this._makeAtLeastOneToggleChecked, this);
      },
      onDisable: function onDisable() {
        this.node.off("child-added", this._allowOnlyOneToggleChecked, this);
        this.node.off("child-removed", this._makeAtLeastOneToggleChecked, this);
      },
      start: function start() {
        this._makeAtLeastOneToggleChecked();
      }
    });
    var js = require("../platform/js");
    js.get(ToggleContainer.prototype, "toggleItems", (function() {
      return this.node._children.map((function(item) {
        return item.getComponent(cc.Toggle);
      })).filter(Boolean);
    }));
    cc.ToggleContainer = module.exports = ToggleContainer;
  }), {
    "../platform/js": 158
  } ],
  109: [ (function(require, module, exports) {
    "use strict";
    var ToggleGroup = cc.Class({
      name: "cc.ToggleGroup",
      extends: cc.Component,
      ctor: function ctor() {
        this._toggleItems = [];
      },
      editor: false,
      properties: {
        allowSwitchOff: {
          tooltip: false,
          default: false
        },
        toggleItems: {
          get: function get() {
            return this._toggleItems;
          }
        }
      },
      updateToggles: function updateToggles(toggle) {
        if (!this.enabledInHierarchy) return;
        this._toggleItems.forEach((function(item) {
          toggle.isChecked && item !== toggle && item.isChecked && item.enabled && item._hideCheckMark();
        }));
      },
      addToggle: function addToggle(toggle) {
        var index = this._toggleItems.indexOf(toggle);
        -1 === index && this._toggleItems.push(toggle);
        this._allowOnlyOneToggleChecked();
      },
      removeToggle: function removeToggle(toggle) {
        var index = this._toggleItems.indexOf(toggle);
        index > -1 && this._toggleItems.splice(index, 1);
        this._makeAtLeastOneToggleChecked();
      },
      _allowOnlyOneToggleChecked: function _allowOnlyOneToggleChecked() {
        var isChecked = false;
        this._toggleItems.forEach((function(item) {
          isChecked && item.enabled && item._hideCheckMark();
          item.isChecked && item.enabled && (isChecked = true);
        }));
        return isChecked;
      },
      _makeAtLeastOneToggleChecked: function _makeAtLeastOneToggleChecked() {
        var isChecked = this._allowOnlyOneToggleChecked();
        isChecked || this.allowSwitchOff || this._toggleItems.length > 0 && (this._toggleItems[0].isChecked = true);
      },
      start: function start() {
        this._makeAtLeastOneToggleChecked();
      }
    });
    var js = require("../platform/js");
    var showed = false;
    js.get(cc, "ToggleGroup", (function() {
      if (!showed) {
        cc.errorID(1405, "cc.ToggleGroup", "cc.ToggleContainer");
        showed = true;
      }
      return ToggleGroup;
    }));
    module.exports = ToggleGroup;
  }), {
    "../platform/js": 158
  } ],
  110: [ (function(require, module, exports) {
    "use strict";
    var ViewGroup = cc.Class({
      name: "cc.ViewGroup",
      extends: require("./CCComponent")
    });
    cc.ViewGroup = module.exports = ViewGroup;
  }), {
    "./CCComponent": 94
  } ],
  111: [ (function(require, module, exports) {
    "use strict";
    var WidgetManager = require("../base-ui/CCWidgetManager");
    var AlignMode = WidgetManager.AlignMode;
    var AlignFlags = WidgetManager._AlignFlags;
    var TOP = AlignFlags.TOP;
    var MID = AlignFlags.MID;
    var BOT = AlignFlags.BOT;
    var LEFT = AlignFlags.LEFT;
    var CENTER = AlignFlags.CENTER;
    var RIGHT = AlignFlags.RIGHT;
    var TOP_BOT = TOP | BOT;
    var LEFT_RIGHT = LEFT | RIGHT;
    var Widget = cc.Class({
      name: "cc.Widget",
      extends: require("./CCComponent"),
      editor: false,
      properties: {
        target: {
          get: function get() {
            return this._target;
          },
          set: function set(value) {
            this._target = value;
            false;
          },
          type: cc.Node,
          tooltip: false
        },
        isAlignTop: {
          get: function get() {
            return (this._alignFlags & TOP) > 0;
          },
          set: function set(value) {
            this._setAlign(TOP, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignVerticalCenter: {
          get: function get() {
            return (this._alignFlags & MID) > 0;
          },
          set: function set(value) {
            if (value) {
              this.isAlignTop = false;
              this.isAlignBottom = false;
              this._alignFlags |= MID;
            } else this._alignFlags &= ~MID;
          },
          animatable: false,
          tooltip: false
        },
        isAlignBottom: {
          get: function get() {
            return (this._alignFlags & BOT) > 0;
          },
          set: function set(value) {
            this._setAlign(BOT, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignLeft: {
          get: function get() {
            return (this._alignFlags & LEFT) > 0;
          },
          set: function set(value) {
            this._setAlign(LEFT, value);
          },
          animatable: false,
          tooltip: false
        },
        isAlignHorizontalCenter: {
          get: function get() {
            return (this._alignFlags & CENTER) > 0;
          },
          set: function set(value) {
            if (value) {
              this.isAlignLeft = false;
              this.isAlignRight = false;
              this._alignFlags |= CENTER;
            } else this._alignFlags &= ~CENTER;
          },
          animatable: false,
          tooltip: false
        },
        isAlignRight: {
          get: function get() {
            return (this._alignFlags & RIGHT) > 0;
          },
          set: function set(value) {
            this._setAlign(RIGHT, value);
          },
          animatable: false,
          tooltip: false
        },
        isStretchWidth: {
          get: function get() {
            return (this._alignFlags & LEFT_RIGHT) === LEFT_RIGHT;
          },
          visible: false
        },
        isStretchHeight: {
          get: function get() {
            return (this._alignFlags & TOP_BOT) === TOP_BOT;
          },
          visible: false
        },
        top: {
          get: function get() {
            return this._top;
          },
          set: function set(value) {
            this._top = value;
          },
          tooltip: false
        },
        bottom: {
          get: function get() {
            return this._bottom;
          },
          set: function set(value) {
            this._bottom = value;
          },
          tooltip: false
        },
        left: {
          get: function get() {
            return this._left;
          },
          set: function set(value) {
            this._left = value;
          },
          tooltip: false
        },
        right: {
          get: function get() {
            return this._right;
          },
          set: function set(value) {
            this._right = value;
          },
          tooltip: false
        },
        horizontalCenter: {
          get: function get() {
            return this._horizontalCenter;
          },
          set: function set(value) {
            this._horizontalCenter = value;
          },
          tooltip: false
        },
        verticalCenter: {
          get: function get() {
            return this._verticalCenter;
          },
          set: function set(value) {
            this._verticalCenter = value;
          },
          tooltip: false
        },
        isAbsoluteHorizontalCenter: {
          get: function get() {
            return this._isAbsHorizontalCenter;
          },
          set: function set(value) {
            this._isAbsHorizontalCenter = value;
          },
          animatable: false
        },
        isAbsoluteVerticalCenter: {
          get: function get() {
            return this._isAbsVerticalCenter;
          },
          set: function set(value) {
            this._isAbsVerticalCenter = value;
          },
          animatable: false
        },
        isAbsoluteTop: {
          get: function get() {
            return this._isAbsTop;
          },
          set: function set(value) {
            this._isAbsTop = value;
          },
          animatable: false
        },
        isAbsoluteBottom: {
          get: function get() {
            return this._isAbsBottom;
          },
          set: function set(value) {
            this._isAbsBottom = value;
          },
          animatable: false
        },
        isAbsoluteLeft: {
          get: function get() {
            return this._isAbsLeft;
          },
          set: function set(value) {
            this._isAbsLeft = value;
          },
          animatable: false
        },
        isAbsoluteRight: {
          get: function get() {
            return this._isAbsRight;
          },
          set: function set(value) {
            this._isAbsRight = value;
          },
          animatable: false
        },
        alignMode: {
          default: AlignMode.ON_WINDOW_RESIZE,
          type: AlignMode,
          tooltip: false
        },
        _wasAlignOnce: {
          default: void 0,
          formerlySerializedAs: "isAlignOnce"
        },
        _target: null,
        _alignFlags: 0,
        _left: 0,
        _right: 0,
        _top: 0,
        _bottom: 0,
        _verticalCenter: 0,
        _horizontalCenter: 0,
        _isAbsLeft: true,
        _isAbsRight: true,
        _isAbsTop: true,
        _isAbsBottom: true,
        _isAbsHorizontalCenter: true,
        _isAbsVerticalCenter: true,
        _originalWidth: 0,
        _originalHeight: 0
      },
      statics: {
        AlignMode: AlignMode
      },
      onLoad: function onLoad() {
        if (void 0 !== this._wasAlignOnce) {
          this.alignMode = this._wasAlignOnce ? AlignMode.ONCE : AlignMode.ALWAYS;
          this._wasAlignOnce = void 0;
        }
      },
      onEnable: function onEnable() {
        WidgetManager.add(this);
      },
      onDisable: function onDisable() {
        WidgetManager.remove(this);
      },
      _validateTargetInDEV: false,
      _setAlign: function _setAlign(flag, isAlign) {
        var current = (this._alignFlags & flag) > 0;
        if (isAlign === current) return;
        var isHorizontal = (flag & LEFT_RIGHT) > 0;
        if (isAlign) {
          this._alignFlags |= flag;
          if (isHorizontal) {
            this.isAlignHorizontalCenter = false;
            if (this.isStretchWidth) {
              this._originalWidth = this.node.width;
              false;
            }
          } else {
            this.isAlignVerticalCenter = false;
            if (this.isStretchHeight) {
              this._originalHeight = this.node.height;
              false;
            }
          }
          false;
        } else {
          isHorizontal ? this.isStretchWidth && (this.node.width = this._originalWidth) : this.isStretchHeight && (this.node.height = this._originalHeight);
          this._alignFlags &= ~flag;
        }
      },
      updateAlignment: function updateAlignment() {
        WidgetManager.updateAlignment(this.node);
      }
    });
    Object.defineProperty(Widget.prototype, "isAlignOnce", {
      get: function get() {
        true;
        cc.warn("`widget.isAlignOnce` is deprecated, use `widget.alignMode === cc.Widget.AlignMode.ONCE` instead please.");
        return this.alignMode === AlignMode.ONCE;
      },
      set: function set(value) {
        true;
        cc.warn("`widget.isAlignOnce` is deprecated, use `widget.alignMode = cc.Widget.AlignMode.*` instead please.");
        this.alignMode = value ? AlignMode.ONCE : AlignMode.ALWAYS;
      }
    });
    cc.Widget = module.exports = Widget;
  }), {
    "../base-ui/CCWidgetManager": 86,
    "./CCComponent": 94
  } ],
  112: [ (function(require, module, exports) {
    "use strict";
    var Component = require("./CCComponent");
    var WXSubContextView = cc.Class({
      name: "cc.WXSubContextView",
      extends: Component,
      editor: false,
      properties: {
        _fps: 60,
        fps: {
          get: function get() {
            return this._fps;
          },
          set: function set(value) {
            if (this._fps === value) return;
            this._fps = value;
            this._updateInterval = 1 / value;
            this._updateSubContextFrameRate();
          },
          tooltip: false
        }
      },
      ctor: function ctor() {
        this._sprite = null;
        this._tex = new cc.Texture2D();
        this._context = null;
        this._updatedTime = performance.now();
        this._updateInterval = 0;
      },
      onLoad: function onLoad() {
        if (wx.getOpenDataContext) {
          this._updateInterval = 1e3 / this._fps;
          this._context = wx.getOpenDataContext();
          this.reset();
          this._tex.setPremultiplyAlpha(true);
          this._tex.initWithElement(sharedCanvas);
          this._sprite = this.node.getComponent(cc.Sprite);
          if (!this._sprite) {
            this._sprite = this.node.addComponent(cc.Sprite);
            this._sprite.srcBlendFactor = cc.macro.BlendFactor.ONE;
          }
          this._sprite.spriteFrame = new cc.SpriteFrame(this._tex);
        } else this.enabled = false;
      },
      reset: function reset() {
        if (this._context) {
          this.updateSubContextViewport();
          var _sharedCanvas = this._context.canvas;
          if (_sharedCanvas) {
            _sharedCanvas.width = this.node.width;
            _sharedCanvas.height = this.node.height;
          }
        }
      },
      onEnable: function onEnable() {
        this._runSubContextMainLoop();
        this._registerNodeEvent();
        this._updateSubContextFrameRate();
        this.updateSubContextViewport();
      },
      onDisable: function onDisable() {
        this._unregisterNodeEvent();
        this._stopSubContextMainLoop();
      },
      update: function update(dt) {
        var calledUpdateMannually = void 0 === dt;
        if (calledUpdateMannually) {
          this._context && this._context.postMessage({
            fromEngine: true,
            event: "step"
          });
          this._updateSubContextTexture();
          return;
        }
        var now = performance.now();
        var deltaTime = now - this._updatedTime;
        if (deltaTime >= this._updateInterval) {
          this._updatedTime += this._updateInterval;
          this._updateSubContextTexture();
        }
      },
      _updateSubContextTexture: function _updateSubContextTexture() {
        if (!this._tex || !this._context) return;
        this._tex.initWithElement(this._context.canvas);
        this._sprite._activateMaterial();
      },
      updateSubContextViewport: function updateSubContextViewport() {
        if (this._context) {
          var box = this.node.getBoundingBoxToWorld();
          var sx = cc.view._scaleX;
          var sy = cc.view._scaleY;
          this._context.postMessage({
            fromEngine: true,
            event: "viewport",
            x: box.x * sx + cc.view._viewportRect.x,
            y: box.y * sy + cc.view._viewportRect.y,
            width: box.width * sx,
            height: box.height * sy
          });
        }
      },
      _registerNodeEvent: function _registerNodeEvent() {
        this.node.on("position-changed", this.updateSubContextViewport, this);
        this.node.on("scale-changed", this.updateSubContextViewport, this);
        this.node.on("size-changed", this.updateSubContextViewport, this);
      },
      _unregisterNodeEvent: function _unregisterNodeEvent() {
        this.node.off("position-changed", this.updateSubContextViewport, this);
        this.node.off("scale-changed", this.updateSubContextViewport, this);
        this.node.off("size-changed", this.updateSubContextViewport, this);
      },
      _runSubContextMainLoop: function _runSubContextMainLoop() {
        this._context && this._context.postMessage({
          fromEngine: true,
          event: "mainLoop",
          value: true
        });
      },
      _stopSubContextMainLoop: function _stopSubContextMainLoop() {
        this._context && this._context.postMessage({
          fromEngine: true,
          event: "mainLoop",
          value: false
        });
      },
      _updateSubContextFrameRate: function _updateSubContextFrameRate() {
        this._context && this._context.postMessage({
          fromEngine: true,
          event: "frameRate",
          value: this._fps
        });
      }
    });
    cc.WXSubContextView = module.exports = WXSubContextView;
  }), {
    "./CCComponent": 94
  } ],
  113: [ (function(require, module, exports) {
    "use strict";
    require("./CCComponent");
    require("./CCComponentEventHandler");
    require("./missing-script");
    var WXSubContextView = require("./WXSubContextView");
    var SwanSubContextView = require("./SwanSubContextView");
    WXSubContextView || (WXSubContextView = cc.Class({
      name: "cc.WXSubContextView",
      extends: cc.Component
    }));
    SwanSubContextView || (SwanSubContextView = cc.Class({
      name: "cc.SwanSubContextView",
      extends: cc.Component
    }));
    var components = [ require("./CCSprite"), require("./CCWidget"), require("./CCCanvas"), require("./CCAudioSource"), require("./CCAnimation"), require("./CCButton"), require("./CCLabel"), require("./CCProgressBar"), require("./CCMask"), require("./CCScrollBar"), require("./CCScrollView"), require("./CCPageViewIndicator"), require("./CCPageView"), require("./CCSlider"), require("./CCLayout"), require("./editbox/CCEditBox"), require("./CCLabelOutline"), require("./CCLabelShadow"), require("./CCRichText"), require("./CCToggleContainer"), require("./CCToggleGroup"), require("./CCToggle"), require("./CCBlockInputEvents"), require("./CCMotionStreak"), require("./CCSafeArea"), WXSubContextView, SwanSubContextView ];
    module.exports = components;
  }), {
    "./CCAnimation": 89,
    "./CCAudioSource": 90,
    "./CCBlockInputEvents": 91,
    "./CCButton": 92,
    "./CCCanvas": 93,
    "./CCComponent": 94,
    "./CCComponentEventHandler": 95,
    "./CCLabel": 96,
    "./CCLabelOutline": void 0,
    "./CCLabelShadow": void 0,
    "./CCLayout": 97,
    "./CCMask": 98,
    "./CCMotionStreak": void 0,
    "./CCPageView": void 0,
    "./CCPageViewIndicator": void 0,
    "./CCProgressBar": 99,
    "./CCRichText": 101,
    "./CCSafeArea": 102,
    "./CCScrollBar": 103,
    "./CCScrollView": 104,
    "./CCSlider": 105,
    "./CCSprite": 106,
    "./CCToggle": 107,
    "./CCToggleContainer": 108,
    "./CCToggleGroup": 109,
    "./CCWidget": 111,
    "./SwanSubContextView": void 0,
    "./WXSubContextView": 112,
    "./editbox/CCEditBox": void 0,
    "./missing-script": 114
  } ],
  114: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var BUILTIN_CLASSID_RE = require("../utils/misc").BUILTIN_CLASSID_RE;
    var MissingClass = cc.Class({
      name: "cc.MissingClass",
      properties: {
        _$erialized: {
          default: null,
          visible: false,
          editorOnly: true
        }
      }
    });
    var MissingScript = cc.Class({
      name: "cc.MissingScript",
      extends: cc.Component,
      editor: {
        inspector: "packages://inspector/inspectors/comps/missing-script.js"
      },
      properties: {
        compiled: {
          default: false,
          serializable: false
        },
        _$erialized: {
          default: null,
          visible: false,
          editorOnly: true
        }
      },
      ctor: false,
      statics: {
        safeFindClass: function safeFindClass(id, data) {
          var cls = js._getClassById(id);
          if (cls) return cls;
          if (id) {
            cc.deserialize.reportMissingClass(id);
            return MissingScript.getMissingWrapper(id, data);
          }
          return null;
        },
        getMissingWrapper: function getMissingWrapper(id, data) {
          return data.node && (/^[0-9a-zA-Z+/]{23}$/.test(id) || BUILTIN_CLASSID_RE.test(id)) ? MissingScript : MissingClass;
        }
      },
      onLoad: function onLoad() {
        cc.warnID(4600, this.node.name);
      }
    });
    cc._MissingScript = module.exports = MissingScript;
  }), {
    "../utils/misc": 209
  } ],
  115: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    require("../event/event");
    var EventMouse = function EventMouse(eventType, bubbles) {
      cc.Event.call(this, cc.Event.MOUSE, bubbles);
      this._eventType = eventType;
      this._button = 0;
      this._x = 0;
      this._y = 0;
      this._prevX = 0;
      this._prevY = 0;
      this._scrollX = 0;
      this._scrollY = 0;
    };
    js.extend(EventMouse, cc.Event);
    var proto = EventMouse.prototype;
    proto.setScrollData = function(scrollX, scrollY) {
      this._scrollX = scrollX;
      this._scrollY = scrollY;
    };
    proto.getScrollX = function() {
      return this._scrollX;
    };
    proto.getScrollY = function() {
      return this._scrollY;
    };
    proto.setLocation = function(x, y) {
      this._x = x;
      this._y = y;
    };
    proto.getLocation = function() {
      return cc.v2(this._x, this._y);
    };
    proto.getLocationInView = function() {
      return cc.v2(this._x, cc.view._designResolutionSize.height - this._y);
    };
    proto._setPrevCursor = function(x, y) {
      this._prevX = x;
      this._prevY = y;
    };
    proto.getPreviousLocation = function() {
      return cc.v2(this._prevX, this._prevY);
    };
    proto.getDelta = function() {
      return cc.v2(this._x - this._prevX, this._y - this._prevY);
    };
    proto.getDeltaX = function() {
      return this._x - this._prevX;
    };
    proto.getDeltaY = function() {
      return this._y - this._prevY;
    };
    proto.setButton = function(button) {
      this._button = button;
    };
    proto.getButton = function() {
      return this._button;
    };
    proto.getLocationX = function() {
      return this._x;
    };
    proto.getLocationY = function() {
      return this._y;
    };
    EventMouse.NONE = 0;
    EventMouse.DOWN = 1;
    EventMouse.UP = 2;
    EventMouse.MOVE = 3;
    EventMouse.SCROLL = 4;
    EventMouse.BUTTON_LEFT = 0;
    EventMouse.BUTTON_RIGHT = 2;
    EventMouse.BUTTON_MIDDLE = 1;
    EventMouse.BUTTON_4 = 3;
    EventMouse.BUTTON_5 = 4;
    EventMouse.BUTTON_6 = 5;
    EventMouse.BUTTON_7 = 6;
    EventMouse.BUTTON_8 = 7;
    var EventTouch = function EventTouch(touchArr, bubbles) {
      cc.Event.call(this, cc.Event.TOUCH, bubbles);
      this._eventCode = 0;
      this._touches = touchArr || [];
      this.touch = null;
      this.currentTouch = null;
    };
    js.extend(EventTouch, cc.Event);
    proto = EventTouch.prototype;
    proto.getEventCode = function() {
      return this._eventCode;
    };
    proto.getTouches = function() {
      return this._touches;
    };
    proto._setEventCode = function(eventCode) {
      this._eventCode = eventCode;
    };
    proto._setTouches = function(touches) {
      this._touches = touches;
    };
    proto.setLocation = function(x, y) {
      this.touch && this.touch.setTouchInfo(this.touch.getID(), x, y);
    };
    proto.getLocation = function() {
      return this.touch ? this.touch.getLocation() : cc.v2();
    };
    proto.getLocationInView = function() {
      return this.touch ? this.touch.getLocationInView() : cc.v2();
    };
    proto.getPreviousLocation = function() {
      return this.touch ? this.touch.getPreviousLocation() : cc.v2();
    };
    proto.getStartLocation = function() {
      return this.touch ? this.touch.getStartLocation() : cc.v2();
    };
    proto.getID = function() {
      return this.touch ? this.touch.getID() : null;
    };
    proto.getDelta = function() {
      return this.touch ? this.touch.getDelta() : cc.v2();
    };
    proto.getDeltaX = function() {
      return this.touch ? this.touch.getDelta().x : 0;
    };
    proto.getDeltaY = function() {
      return this.touch ? this.touch.getDelta().y : 0;
    };
    proto.getLocationX = function() {
      return this.touch ? this.touch.getLocationX() : 0;
    };
    proto.getLocationY = function() {
      return this.touch ? this.touch.getLocationY() : 0;
    };
    EventTouch.MAX_TOUCHES = 5;
    EventTouch.BEGAN = 0;
    EventTouch.MOVED = 1;
    EventTouch.ENDED = 2;
    EventTouch.CANCELED = 3;
    var EventAcceleration = function EventAcceleration(acc, bubbles) {
      cc.Event.call(this, cc.Event.ACCELERATION, bubbles);
      this.acc = acc;
    };
    js.extend(EventAcceleration, cc.Event);
    var EventKeyboard = function EventKeyboard(keyCode, isPressed, bubbles) {
      cc.Event.call(this, cc.Event.KEYBOARD, bubbles);
      this.keyCode = keyCode;
      this.isPressed = isPressed;
    };
    js.extend(EventKeyboard, cc.Event);
    cc.Event.EventMouse = EventMouse;
    cc.Event.EventTouch = EventTouch;
    cc.Event.EventAcceleration = EventAcceleration;
    cc.Event.EventKeyboard = EventKeyboard;
    module.exports = cc.Event;
  }), {
    "../event/event": 122
  } ],
  116: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    cc.EventListener = function(type, listenerID, callback) {
      this._onEvent = callback;
      this._type = type || 0;
      this._listenerID = listenerID || "";
      this._registered = false;
      this._fixedPriority = 0;
      this._node = null;
      this._target = null;
      this._paused = true;
      this._isEnabled = true;
    };
    cc.EventListener.prototype = {
      constructor: cc.EventListener,
      _setPaused: function _setPaused(paused) {
        this._paused = paused;
      },
      _isPaused: function _isPaused() {
        return this._paused;
      },
      _setRegistered: function _setRegistered(registered) {
        this._registered = registered;
      },
      _isRegistered: function _isRegistered() {
        return this._registered;
      },
      _getType: function _getType() {
        return this._type;
      },
      _getListenerID: function _getListenerID() {
        return this._listenerID;
      },
      _setFixedPriority: function _setFixedPriority(fixedPriority) {
        this._fixedPriority = fixedPriority;
      },
      _getFixedPriority: function _getFixedPriority() {
        return this._fixedPriority;
      },
      _setSceneGraphPriority: function _setSceneGraphPriority(node) {
        this._target = node;
        this._node = node;
      },
      _getSceneGraphPriority: function _getSceneGraphPriority() {
        return this._node;
      },
      checkAvailable: function checkAvailable() {
        return null !== this._onEvent;
      },
      clone: function clone() {
        return null;
      },
      setEnabled: function setEnabled(enabled) {
        this._isEnabled = enabled;
      },
      isEnabled: function isEnabled() {
        return this._isEnabled;
      },
      retain: function retain() {},
      release: function release() {}
    };
    cc.EventListener.UNKNOWN = 0;
    cc.EventListener.TOUCH_ONE_BY_ONE = 1;
    cc.EventListener.TOUCH_ALL_AT_ONCE = 2;
    cc.EventListener.KEYBOARD = 3;
    cc.EventListener.MOUSE = 4;
    cc.EventListener.ACCELERATION = 6;
    cc.EventListener.CUSTOM = 8;
    var ListenerID = cc.EventListener.ListenerID = {
      MOUSE: "__cc_mouse",
      TOUCH_ONE_BY_ONE: "__cc_touch_one_by_one",
      TOUCH_ALL_AT_ONCE: "__cc_touch_all_at_once",
      KEYBOARD: "__cc_keyboard",
      ACCELERATION: "__cc_acceleration"
    };
    var Custom = function Custom(listenerId, callback) {
      this._onCustomEvent = callback;
      cc.EventListener.call(this, cc.EventListener.CUSTOM, listenerId, this._callback);
    };
    js.extend(Custom, cc.EventListener);
    js.mixin(Custom.prototype, {
      _onCustomEvent: null,
      _callback: function _callback(event) {
        null !== this._onCustomEvent && this._onCustomEvent(event);
      },
      checkAvailable: function checkAvailable() {
        return cc.EventListener.prototype.checkAvailable.call(this) && null !== this._onCustomEvent;
      },
      clone: function clone() {
        return new Custom(this._listenerID, this._onCustomEvent);
      }
    });
    var Mouse = function Mouse() {
      cc.EventListener.call(this, cc.EventListener.MOUSE, ListenerID.MOUSE, this._callback);
    };
    js.extend(Mouse, cc.EventListener);
    js.mixin(Mouse.prototype, {
      onMouseDown: null,
      onMouseUp: null,
      onMouseMove: null,
      onMouseScroll: null,
      _callback: function _callback(event) {
        var eventType = cc.Event.EventMouse;
        switch (event._eventType) {
         case eventType.DOWN:
          this.onMouseDown && this.onMouseDown(event);
          break;

         case eventType.UP:
          this.onMouseUp && this.onMouseUp(event);
          break;

         case eventType.MOVE:
          this.onMouseMove && this.onMouseMove(event);
          break;

         case eventType.SCROLL:
          this.onMouseScroll && this.onMouseScroll(event);
        }
      },
      clone: function clone() {
        var eventListener = new Mouse();
        eventListener.onMouseDown = this.onMouseDown;
        eventListener.onMouseUp = this.onMouseUp;
        eventListener.onMouseMove = this.onMouseMove;
        eventListener.onMouseScroll = this.onMouseScroll;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        return true;
      }
    });
    var TouchOneByOne = function TouchOneByOne() {
      cc.EventListener.call(this, cc.EventListener.TOUCH_ONE_BY_ONE, ListenerID.TOUCH_ONE_BY_ONE, null);
      this._claimedTouches = [];
    };
    js.extend(TouchOneByOne, cc.EventListener);
    js.mixin(TouchOneByOne.prototype, {
      constructor: TouchOneByOne,
      _claimedTouches: null,
      swallowTouches: false,
      onTouchBegan: null,
      onTouchMoved: null,
      onTouchEnded: null,
      onTouchCancelled: null,
      setSwallowTouches: function setSwallowTouches(needSwallow) {
        this.swallowTouches = needSwallow;
      },
      isSwallowTouches: function isSwallowTouches() {
        return this.swallowTouches;
      },
      clone: function clone() {
        var eventListener = new TouchOneByOne();
        eventListener.onTouchBegan = this.onTouchBegan;
        eventListener.onTouchMoved = this.onTouchMoved;
        eventListener.onTouchEnded = this.onTouchEnded;
        eventListener.onTouchCancelled = this.onTouchCancelled;
        eventListener.swallowTouches = this.swallowTouches;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        if (!this.onTouchBegan) {
          cc.logID(1801);
          return false;
        }
        return true;
      }
    });
    var TouchAllAtOnce = function TouchAllAtOnce() {
      cc.EventListener.call(this, cc.EventListener.TOUCH_ALL_AT_ONCE, ListenerID.TOUCH_ALL_AT_ONCE, null);
    };
    js.extend(TouchAllAtOnce, cc.EventListener);
    js.mixin(TouchAllAtOnce.prototype, {
      constructor: TouchAllAtOnce,
      onTouchesBegan: null,
      onTouchesMoved: null,
      onTouchesEnded: null,
      onTouchesCancelled: null,
      clone: function clone() {
        var eventListener = new TouchAllAtOnce();
        eventListener.onTouchesBegan = this.onTouchesBegan;
        eventListener.onTouchesMoved = this.onTouchesMoved;
        eventListener.onTouchesEnded = this.onTouchesEnded;
        eventListener.onTouchesCancelled = this.onTouchesCancelled;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        if (null === this.onTouchesBegan && null === this.onTouchesMoved && null === this.onTouchesEnded && null === this.onTouchesCancelled) {
          cc.logID(1802);
          return false;
        }
        return true;
      }
    });
    var Acceleration = function Acceleration(callback) {
      this._onAccelerationEvent = callback;
      cc.EventListener.call(this, cc.EventListener.ACCELERATION, ListenerID.ACCELERATION, this._callback);
    };
    js.extend(Acceleration, cc.EventListener);
    js.mixin(Acceleration.prototype, {
      constructor: Acceleration,
      _onAccelerationEvent: null,
      _callback: function _callback(event) {
        this._onAccelerationEvent(event.acc, event);
      },
      checkAvailable: function checkAvailable() {
        cc.assertID(this._onAccelerationEvent, 1803);
        return true;
      },
      clone: function clone() {
        return new Acceleration(this._onAccelerationEvent);
      }
    });
    var Keyboard = function Keyboard() {
      cc.EventListener.call(this, cc.EventListener.KEYBOARD, ListenerID.KEYBOARD, this._callback);
    };
    js.extend(Keyboard, cc.EventListener);
    js.mixin(Keyboard.prototype, {
      constructor: Keyboard,
      onKeyPressed: null,
      onKeyReleased: null,
      _callback: function _callback(event) {
        event.isPressed ? this.onKeyPressed && this.onKeyPressed(event.keyCode, event) : this.onKeyReleased && this.onKeyReleased(event.keyCode, event);
      },
      clone: function clone() {
        var eventListener = new Keyboard();
        eventListener.onKeyPressed = this.onKeyPressed;
        eventListener.onKeyReleased = this.onKeyReleased;
        return eventListener;
      },
      checkAvailable: function checkAvailable() {
        if (null === this.onKeyPressed && null === this.onKeyReleased) {
          cc.logID(1800);
          return false;
        }
        return true;
      }
    });
    cc.EventListener.create = function(argObj) {
      cc.assertID(argObj && argObj.event, 1900);
      var listenerType = argObj.event;
      delete argObj.event;
      var listener = null;
      if (listenerType === cc.EventListener.TOUCH_ONE_BY_ONE) listener = new TouchOneByOne(); else if (listenerType === cc.EventListener.TOUCH_ALL_AT_ONCE) listener = new TouchAllAtOnce(); else if (listenerType === cc.EventListener.MOUSE) listener = new Mouse(); else if (listenerType === cc.EventListener.CUSTOM) {
        listener = new Custom(argObj.eventName, argObj.callback);
        delete argObj.eventName;
        delete argObj.callback;
      } else if (listenerType === cc.EventListener.KEYBOARD) listener = new Keyboard(); else if (listenerType === cc.EventListener.ACCELERATION) {
        listener = new Acceleration(argObj.callback);
        delete argObj.callback;
      }
      for (var key in argObj) listener[key] = argObj[key];
      return listener;
    };
    module.exports = cc.EventListener;
  }), {
    "../platform/js": 158
  } ],
  117: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    require("./CCEventListener");
    var ListenerID = cc.EventListener.ListenerID;
    var _EventListenerVector = function _EventListenerVector() {
      this._fixedListeners = [];
      this._sceneGraphListeners = [];
      this.gt0Index = 0;
    };
    _EventListenerVector.prototype = {
      constructor: _EventListenerVector,
      size: function size() {
        return this._fixedListeners.length + this._sceneGraphListeners.length;
      },
      empty: function empty() {
        return 0 === this._fixedListeners.length && 0 === this._sceneGraphListeners.length;
      },
      push: function push(listener) {
        0 === listener._getFixedPriority() ? this._sceneGraphListeners.push(listener) : this._fixedListeners.push(listener);
      },
      clearSceneGraphListeners: function clearSceneGraphListeners() {
        this._sceneGraphListeners.length = 0;
      },
      clearFixedListeners: function clearFixedListeners() {
        this._fixedListeners.length = 0;
      },
      clear: function clear() {
        this._sceneGraphListeners.length = 0;
        this._fixedListeners.length = 0;
      },
      getFixedPriorityListeners: function getFixedPriorityListeners() {
        return this._fixedListeners;
      },
      getSceneGraphPriorityListeners: function getSceneGraphPriorityListeners() {
        return this._sceneGraphListeners;
      }
    };
    var __getListenerID = function __getListenerID(event) {
      var eventType = cc.Event, type = event.type;
      if (type === eventType.ACCELERATION) return ListenerID.ACCELERATION;
      if (type === eventType.KEYBOARD) return ListenerID.KEYBOARD;
      if (type.startsWith(eventType.MOUSE)) return ListenerID.MOUSE;
      type.startsWith(eventType.TOUCH) && cc.logID(2e3);
      return "";
    };
    var eventManager = {
      DIRTY_NONE: 0,
      DIRTY_FIXED_PRIORITY: 1,
      DIRTY_SCENE_GRAPH_PRIORITY: 2,
      DIRTY_ALL: 3,
      _listenersMap: {},
      _priorityDirtyFlagMap: {},
      _nodeListenersMap: {},
      _toAddedListeners: [],
      _toRemovedListeners: [],
      _dirtyListeners: {},
      _inDispatch: 0,
      _isEnabled: false,
      _currentTouch: null,
      _currentTouchListener: null,
      _internalCustomListenerIDs: [],
      _setDirtyForNode: function _setDirtyForNode(node) {
        var selListeners = this._nodeListenersMap[node._id];
        if (void 0 !== selListeners) for (var j = 0, len = selListeners.length; j < len; j++) {
          var selListener = selListeners[j];
          var listenerID = selListener._getListenerID();
          null == this._dirtyListeners[listenerID] && (this._dirtyListeners[listenerID] = true);
        }
        if (node.childrenCount > 0) {
          var children = node._children;
          for (var i = 0, _len = children.length; i < _len; i++) this._setDirtyForNode(children[i]);
        }
      },
      pauseTarget: function pauseTarget(node, recursive) {
        if (!(node instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        var listeners = this._nodeListenersMap[node._id], i, len;
        if (listeners) for (i = 0, len = listeners.length; i < len; i++) listeners[i]._setPaused(true);
        if (true === recursive) {
          var locChildren = node._children;
          for (i = 0, len = locChildren ? locChildren.length : 0; i < len; i++) this.pauseTarget(locChildren[i], true);
        }
      },
      resumeTarget: function resumeTarget(node, recursive) {
        if (!(node instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        var listeners = this._nodeListenersMap[node._id], i, len;
        if (listeners) for (i = 0, len = listeners.length; i < len; i++) listeners[i]._setPaused(false);
        this._setDirtyForNode(node);
        if (true === recursive) {
          var locChildren = node._children;
          for (i = 0, len = locChildren ? locChildren.length : 0; i < len; i++) this.resumeTarget(locChildren[i], true);
        }
      },
      _addListener: function _addListener(listener) {
        0 === this._inDispatch ? this._forceAddEventListener(listener) : this._toAddedListeners.push(listener);
      },
      _forceAddEventListener: function _forceAddEventListener(listener) {
        var listenerID = listener._getListenerID();
        var listeners = this._listenersMap[listenerID];
        if (!listeners) {
          listeners = new _EventListenerVector();
          this._listenersMap[listenerID] = listeners;
        }
        listeners.push(listener);
        if (0 === listener._getFixedPriority()) {
          this._setDirty(listenerID, this.DIRTY_SCENE_GRAPH_PRIORITY);
          var node = listener._getSceneGraphPriority();
          null === node && cc.logID(3507);
          this._associateNodeAndEventListener(node, listener);
          node.activeInHierarchy && this.resumeTarget(node);
        } else this._setDirty(listenerID, this.DIRTY_FIXED_PRIORITY);
      },
      _getListeners: function _getListeners(listenerID) {
        return this._listenersMap[listenerID];
      },
      _updateDirtyFlagForSceneGraph: function _updateDirtyFlagForSceneGraph() {
        var locDirtyListeners = this._dirtyListeners;
        for (var selKey in locDirtyListeners) this._setDirty(selKey, this.DIRTY_SCENE_GRAPH_PRIORITY);
        this._dirtyListeners = {};
      },
      _removeAllListenersInVector: function _removeAllListenersInVector(listenerVector) {
        if (!listenerVector) return;
        var selListener;
        for (var i = listenerVector.length - 1; i >= 0; i--) {
          selListener = listenerVector[i];
          selListener._setRegistered(false);
          if (null != selListener._getSceneGraphPriority()) {
            this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
            selListener._setSceneGraphPriority(null);
          }
          0 === this._inDispatch && cc.js.array.removeAt(listenerVector, i);
        }
      },
      _removeListenersForListenerID: function _removeListenersForListenerID(listenerID) {
        var listeners = this._listenersMap[listenerID], i;
        if (listeners) {
          var fixedPriorityListeners = listeners.getFixedPriorityListeners();
          var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          this._removeAllListenersInVector(sceneGraphPriorityListeners);
          this._removeAllListenersInVector(fixedPriorityListeners);
          delete this._priorityDirtyFlagMap[listenerID];
          if (!this._inDispatch) {
            listeners.clear();
            delete this._listenersMap[listenerID];
          }
        }
        var locToAddedListeners = this._toAddedListeners, listener;
        for (i = locToAddedListeners.length - 1; i >= 0; i--) {
          listener = locToAddedListeners[i];
          listener && listener._getListenerID() === listenerID && cc.js.array.removeAt(locToAddedListeners, i);
        }
      },
      _sortEventListeners: function _sortEventListeners(listenerID) {
        var dirtyFlag = this.DIRTY_NONE, locFlagMap = this._priorityDirtyFlagMap;
        locFlagMap[listenerID] && (dirtyFlag = locFlagMap[listenerID]);
        if (dirtyFlag !== this.DIRTY_NONE) {
          locFlagMap[listenerID] = this.DIRTY_NONE;
          dirtyFlag & this.DIRTY_FIXED_PRIORITY && this._sortListenersOfFixedPriority(listenerID);
          if (dirtyFlag & this.DIRTY_SCENE_GRAPH_PRIORITY) {
            var rootEntity = cc.director.getScene();
            rootEntity && this._sortListenersOfSceneGraphPriority(listenerID);
          }
        }
      },
      _sortListenersOfSceneGraphPriority: function _sortListenersOfSceneGraphPriority(listenerID) {
        var listeners = this._getListeners(listenerID);
        if (!listeners) return;
        var sceneGraphListener = listeners.getSceneGraphPriorityListeners();
        if (!sceneGraphListener || 0 === sceneGraphListener.length) return;
        listeners.getSceneGraphPriorityListeners().sort(this._sortEventListenersOfSceneGraphPriorityDes);
      },
      _sortEventListenersOfSceneGraphPriorityDes: function _sortEventListenersOfSceneGraphPriorityDes(l1, l2) {
        var node1 = l1._getSceneGraphPriority(), node2 = l2._getSceneGraphPriority();
        if (!(l2 && node2 && node2._activeInHierarchy && null !== node2._parent)) return -1;
        if (!l1 || !node1 || !node1._activeInHierarchy || null === node1._parent) return 1;
        var p1 = node1, p2 = node2, ex = false;
        while (p1._parent._id !== p2._parent._id) {
          p1 = null === p1._parent._parent ? (ex = true) && node2 : p1._parent;
          p2 = null === p2._parent._parent ? (ex = true) && node1 : p2._parent;
        }
        if (p1._id === p2._id) {
          if (p1._id === node2._id) return -1;
          if (p1._id === node1._id) return 1;
        }
        return ex ? p1._localZOrder - p2._localZOrder : p2._localZOrder - p1._localZOrder;
      },
      _sortListenersOfFixedPriority: function _sortListenersOfFixedPriority(listenerID) {
        var listeners = this._listenersMap[listenerID];
        if (!listeners) return;
        var fixedListeners = listeners.getFixedPriorityListeners();
        if (!fixedListeners || 0 === fixedListeners.length) return;
        fixedListeners.sort(this._sortListenersOfFixedPriorityAsc);
        var index = 0;
        for (var len = fixedListeners.length; index < len; ) {
          if (fixedListeners[index]._getFixedPriority() >= 0) break;
          ++index;
        }
        listeners.gt0Index = index;
      },
      _sortListenersOfFixedPriorityAsc: function _sortListenersOfFixedPriorityAsc(l1, l2) {
        return l1._getFixedPriority() - l2._getFixedPriority();
      },
      _onUpdateListeners: function _onUpdateListeners(listeners) {
        var fixedPriorityListeners = listeners.getFixedPriorityListeners();
        var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
        var i, selListener, idx, toRemovedListeners = this._toRemovedListeners;
        if (sceneGraphPriorityListeners) for (i = sceneGraphPriorityListeners.length - 1; i >= 0; i--) {
          selListener = sceneGraphPriorityListeners[i];
          if (!selListener._isRegistered()) {
            cc.js.array.removeAt(sceneGraphPriorityListeners, i);
            idx = toRemovedListeners.indexOf(selListener);
            -1 !== idx && toRemovedListeners.splice(idx, 1);
          }
        }
        if (fixedPriorityListeners) for (i = fixedPriorityListeners.length - 1; i >= 0; i--) {
          selListener = fixedPriorityListeners[i];
          if (!selListener._isRegistered()) {
            cc.js.array.removeAt(fixedPriorityListeners, i);
            idx = toRemovedListeners.indexOf(selListener);
            -1 !== idx && toRemovedListeners.splice(idx, 1);
          }
        }
        sceneGraphPriorityListeners && 0 === sceneGraphPriorityListeners.length && listeners.clearSceneGraphListeners();
        fixedPriorityListeners && 0 === fixedPriorityListeners.length && listeners.clearFixedListeners();
      },
      frameUpdateListeners: function frameUpdateListeners() {
        var locListenersMap = this._listenersMap, locPriorityDirtyFlagMap = this._priorityDirtyFlagMap;
        for (var selKey in locListenersMap) if (locListenersMap[selKey].empty()) {
          delete locPriorityDirtyFlagMap[selKey];
          delete locListenersMap[selKey];
        }
        var locToAddedListeners = this._toAddedListeners;
        if (0 !== locToAddedListeners.length) {
          for (var i = 0, len = locToAddedListeners.length; i < len; i++) this._forceAddEventListener(locToAddedListeners[i]);
          locToAddedListeners.length = 0;
        }
        0 !== this._toRemovedListeners.length && this._cleanToRemovedListeners();
      },
      _updateTouchListeners: function _updateTouchListeners(event) {
        var locInDispatch = this._inDispatch;
        cc.assertID(locInDispatch > 0, 3508);
        if (locInDispatch > 1) return;
        var listeners;
        listeners = this._listenersMap[ListenerID.TOUCH_ONE_BY_ONE];
        listeners && this._onUpdateListeners(listeners);
        listeners = this._listenersMap[ListenerID.TOUCH_ALL_AT_ONCE];
        listeners && this._onUpdateListeners(listeners);
        cc.assertID(1 === locInDispatch, 3509);
        var locToAddedListeners = this._toAddedListeners;
        if (0 !== locToAddedListeners.length) {
          for (var i = 0, len = locToAddedListeners.length; i < len; i++) this._forceAddEventListener(locToAddedListeners[i]);
          this._toAddedListeners.length = 0;
        }
        0 !== this._toRemovedListeners.length && this._cleanToRemovedListeners();
      },
      _cleanToRemovedListeners: function _cleanToRemovedListeners() {
        var toRemovedListeners = this._toRemovedListeners;
        for (var i = 0; i < toRemovedListeners.length; i++) {
          var selListener = toRemovedListeners[i];
          var listeners = this._listenersMap[selListener._getListenerID()];
          if (!listeners) continue;
          var idx, fixedPriorityListeners = listeners.getFixedPriorityListeners(), sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          if (sceneGraphPriorityListeners) {
            idx = sceneGraphPriorityListeners.indexOf(selListener);
            -1 !== idx && sceneGraphPriorityListeners.splice(idx, 1);
          }
          if (fixedPriorityListeners) {
            idx = fixedPriorityListeners.indexOf(selListener);
            -1 !== idx && fixedPriorityListeners.splice(idx, 1);
          }
        }
        toRemovedListeners.length = 0;
      },
      _onTouchEventCallback: function _onTouchEventCallback(listener, argsObj) {
        if (!listener._isRegistered()) return false;
        var event = argsObj.event, selTouch = event.currentTouch;
        event.currentTarget = listener._node;
        var isClaimed = false, removedIdx;
        var getCode = event.getEventCode(), EventTouch = cc.Event.EventTouch;
        if (getCode === EventTouch.BEGAN) {
          if (!cc.macro.ENABLE_MULTI_TOUCH && eventManager._currentTouch) {
            var node = eventManager._currentTouchListener._node;
            if (node && node.activeInHierarchy) return false;
          }
          if (listener.onTouchBegan) {
            isClaimed = listener.onTouchBegan(selTouch, event);
            if (isClaimed && listener._registered) {
              listener._claimedTouches.push(selTouch);
              eventManager._currentTouchListener = listener;
              eventManager._currentTouch = selTouch;
            }
          }
        } else if (listener._claimedTouches.length > 0 && -1 !== (removedIdx = listener._claimedTouches.indexOf(selTouch))) {
          isClaimed = true;
          if (!cc.macro.ENABLE_MULTI_TOUCH && eventManager._currentTouch && eventManager._currentTouch !== selTouch) return false;
          if (getCode === EventTouch.MOVED && listener.onTouchMoved) listener.onTouchMoved(selTouch, event); else if (getCode === EventTouch.ENDED) {
            listener.onTouchEnded && listener.onTouchEnded(selTouch, event);
            listener._registered && listener._claimedTouches.splice(removedIdx, 1);
            eventManager._clearCurTouch();
          } else if (getCode === EventTouch.CANCELED) {
            listener.onTouchCancelled && listener.onTouchCancelled(selTouch, event);
            listener._registered && listener._claimedTouches.splice(removedIdx, 1);
            eventManager._clearCurTouch();
          }
        }
        if (event.isStopped()) {
          eventManager._updateTouchListeners(event);
          return true;
        }
        if (isClaimed && listener.swallowTouches) {
          argsObj.needsMutableSet && argsObj.touches.splice(selTouch, 1);
          return true;
        }
        return false;
      },
      _dispatchTouchEvent: function _dispatchTouchEvent(event) {
        this._sortEventListeners(ListenerID.TOUCH_ONE_BY_ONE);
        this._sortEventListeners(ListenerID.TOUCH_ALL_AT_ONCE);
        var oneByOneListeners = this._getListeners(ListenerID.TOUCH_ONE_BY_ONE);
        var allAtOnceListeners = this._getListeners(ListenerID.TOUCH_ALL_AT_ONCE);
        if (null === oneByOneListeners && null === allAtOnceListeners) return;
        var originalTouches = event.getTouches(), mutableTouches = cc.js.array.copy(originalTouches);
        var oneByOneArgsObj = {
          event: event,
          needsMutableSet: oneByOneListeners && allAtOnceListeners,
          touches: mutableTouches,
          selTouch: null
        };
        if (oneByOneListeners) for (var i = 0; i < originalTouches.length; i++) {
          event.currentTouch = originalTouches[i];
          event._propagationStopped = event._propagationImmediateStopped = false;
          this._dispatchEventToListeners(oneByOneListeners, this._onTouchEventCallback, oneByOneArgsObj);
        }
        if (allAtOnceListeners && mutableTouches.length > 0) {
          this._dispatchEventToListeners(allAtOnceListeners, this._onTouchesEventCallback, {
            event: event,
            touches: mutableTouches
          });
          if (event.isStopped()) return;
        }
        this._updateTouchListeners(event);
      },
      _onTouchesEventCallback: function _onTouchesEventCallback(listener, callbackParams) {
        if (!listener._registered) return false;
        var EventTouch = cc.Event.EventTouch, event = callbackParams.event, touches = callbackParams.touches, getCode = event.getEventCode();
        event.currentTarget = listener._node;
        getCode === EventTouch.BEGAN && listener.onTouchesBegan ? listener.onTouchesBegan(touches, event) : getCode === EventTouch.MOVED && listener.onTouchesMoved ? listener.onTouchesMoved(touches, event) : getCode === EventTouch.ENDED && listener.onTouchesEnded ? listener.onTouchesEnded(touches, event) : getCode === EventTouch.CANCELED && listener.onTouchesCancelled && listener.onTouchesCancelled(touches, event);
        if (event.isStopped()) {
          eventManager._updateTouchListeners(event);
          return true;
        }
        return false;
      },
      _associateNodeAndEventListener: function _associateNodeAndEventListener(node, listener) {
        var listeners = this._nodeListenersMap[node._id];
        if (!listeners) {
          listeners = [];
          this._nodeListenersMap[node._id] = listeners;
        }
        listeners.push(listener);
      },
      _dissociateNodeAndEventListener: function _dissociateNodeAndEventListener(node, listener) {
        var listeners = this._nodeListenersMap[node._id];
        if (listeners) {
          cc.js.array.remove(listeners, listener);
          0 === listeners.length && delete this._nodeListenersMap[node._id];
        }
      },
      _dispatchEventToListeners: function _dispatchEventToListeners(listeners, onEvent, eventOrArgs) {
        var shouldStopPropagation = false;
        var fixedPriorityListeners = listeners.getFixedPriorityListeners();
        var sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
        var i = 0, j, selListener;
        if (fixedPriorityListeners && 0 !== fixedPriorityListeners.length) for (;i < listeners.gt0Index; ++i) {
          selListener = fixedPriorityListeners[i];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
        if (sceneGraphPriorityListeners && !shouldStopPropagation) for (j = 0; j < sceneGraphPriorityListeners.length; j++) {
          selListener = sceneGraphPriorityListeners[j];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
        if (fixedPriorityListeners && !shouldStopPropagation) for (;i < fixedPriorityListeners.length; ++i) {
          selListener = fixedPriorityListeners[i];
          if (selListener.isEnabled() && !selListener._isPaused() && selListener._isRegistered() && onEvent(selListener, eventOrArgs)) {
            shouldStopPropagation = true;
            break;
          }
        }
      },
      _setDirty: function _setDirty(listenerID, flag) {
        var locDirtyFlagMap = this._priorityDirtyFlagMap;
        null == locDirtyFlagMap[listenerID] ? locDirtyFlagMap[listenerID] = flag : locDirtyFlagMap[listenerID] = flag | locDirtyFlagMap[listenerID];
      },
      _sortNumberAsc: function _sortNumberAsc(a, b) {
        return a - b;
      },
      hasEventListener: function hasEventListener(listenerID) {
        return !!this._getListeners(listenerID);
      },
      addListener: function addListener(listener, nodeOrPriority) {
        cc.assertID(listener && nodeOrPriority, 3503);
        if (!(cc.js.isNumber(nodeOrPriority) || nodeOrPriority instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        if (listener instanceof cc.EventListener) {
          if (listener._isRegistered()) {
            cc.logID(3505);
            return;
          }
        } else {
          cc.assertID(!cc.js.isNumber(nodeOrPriority), 3504);
          listener = cc.EventListener.create(listener);
        }
        if (!listener.checkAvailable()) return;
        if (cc.js.isNumber(nodeOrPriority)) {
          if (0 === nodeOrPriority) {
            cc.logID(3500);
            return;
          }
          listener._setSceneGraphPriority(null);
          listener._setFixedPriority(nodeOrPriority);
          listener._setRegistered(true);
          listener._setPaused(false);
          this._addListener(listener);
        } else {
          listener._setSceneGraphPriority(nodeOrPriority);
          listener._setFixedPriority(0);
          listener._setRegistered(true);
          this._addListener(listener);
        }
        return listener;
      },
      addCustomListener: function addCustomListener(eventName, callback) {
        var listener = new cc.EventListener.create({
          event: cc.EventListener.CUSTOM,
          eventName: eventName,
          callback: callback
        });
        this.addListener(listener, 1);
        return listener;
      },
      removeListener: function removeListener(listener) {
        if (null == listener) return;
        var isFound, locListener = this._listenersMap;
        for (var selKey in locListener) {
          var listeners = locListener[selKey];
          var fixedPriorityListeners = listeners.getFixedPriorityListeners(), sceneGraphPriorityListeners = listeners.getSceneGraphPriorityListeners();
          isFound = this._removeListenerInVector(sceneGraphPriorityListeners, listener);
          if (isFound) this._setDirty(listener._getListenerID(), this.DIRTY_SCENE_GRAPH_PRIORITY); else {
            isFound = this._removeListenerInVector(fixedPriorityListeners, listener);
            isFound && this._setDirty(listener._getListenerID(), this.DIRTY_FIXED_PRIORITY);
          }
          if (listeners.empty()) {
            delete this._priorityDirtyFlagMap[listener._getListenerID()];
            delete locListener[selKey];
          }
          if (isFound) break;
        }
        if (!isFound) {
          var locToAddedListeners = this._toAddedListeners;
          for (var i = locToAddedListeners.length - 1; i >= 0; i--) {
            var selListener = locToAddedListeners[i];
            if (selListener === listener) {
              cc.js.array.removeAt(locToAddedListeners, i);
              selListener._setRegistered(false);
              break;
            }
          }
        }
        this._currentTouchListener === listener && this._clearCurTouch();
      },
      _clearCurTouch: function _clearCurTouch() {
        this._currentTouchListener = null;
        this._currentTouch = null;
      },
      _removeListenerInCallback: function _removeListenerInCallback(listeners, callback) {
        if (null == listeners) return false;
        for (var i = listeners.length - 1; i >= 0; i--) {
          var selListener = listeners[i];
          if (selListener._onCustomEvent === callback || selListener._onEvent === callback) {
            selListener._setRegistered(false);
            if (null != selListener._getSceneGraphPriority()) {
              this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
              selListener._setSceneGraphPriority(null);
            }
            0 === this._inDispatch ? cc.js.array.removeAt(listeners, i) : this._toRemovedListeners.push(selListener);
            return true;
          }
        }
        return false;
      },
      _removeListenerInVector: function _removeListenerInVector(listeners, listener) {
        if (null == listeners) return false;
        for (var i = listeners.length - 1; i >= 0; i--) {
          var selListener = listeners[i];
          if (selListener === listener) {
            selListener._setRegistered(false);
            if (null != selListener._getSceneGraphPriority()) {
              this._dissociateNodeAndEventListener(selListener._getSceneGraphPriority(), selListener);
              selListener._setSceneGraphPriority(null);
            }
            0 === this._inDispatch ? cc.js.array.removeAt(listeners, i) : this._toRemovedListeners.push(selListener);
            return true;
          }
        }
        return false;
      },
      removeListeners: function removeListeners(listenerType, recursive) {
        var i, _t = this;
        if (!(cc.js.isNumber(listenerType) || listenerType instanceof cc._BaseNode)) {
          cc.warnID(3506);
          return;
        }
        if (void 0 !== listenerType._id) {
          var listeners = _t._nodeListenersMap[listenerType._id], i;
          if (listeners) {
            var listenersCopy = cc.js.array.copy(listeners);
            for (i = 0; i < listenersCopy.length; i++) _t.removeListener(listenersCopy[i]);
            delete _t._nodeListenersMap[listenerType._id];
          }
          var locToAddedListeners = _t._toAddedListeners;
          for (i = 0; i < locToAddedListeners.length; ) {
            var listener = locToAddedListeners[i];
            if (listener._getSceneGraphPriority() === listenerType) {
              listener._setSceneGraphPriority(null);
              listener._setRegistered(false);
              locToAddedListeners.splice(i, 1);
            } else ++i;
          }
          if (true === recursive) {
            var locChildren = listenerType.children, len;
            for (i = 0, len = locChildren.length; i < len; i++) _t.removeListeners(locChildren[i], true);
          }
        } else listenerType === cc.EventListener.TOUCH_ONE_BY_ONE ? _t._removeListenersForListenerID(ListenerID.TOUCH_ONE_BY_ONE) : listenerType === cc.EventListener.TOUCH_ALL_AT_ONCE ? _t._removeListenersForListenerID(ListenerID.TOUCH_ALL_AT_ONCE) : listenerType === cc.EventListener.MOUSE ? _t._removeListenersForListenerID(ListenerID.MOUSE) : listenerType === cc.EventListener.ACCELERATION ? _t._removeListenersForListenerID(ListenerID.ACCELERATION) : listenerType === cc.EventListener.KEYBOARD ? _t._removeListenersForListenerID(ListenerID.KEYBOARD) : cc.logID(3501);
      },
      removeCustomListeners: function removeCustomListeners(customEventName) {
        this._removeListenersForListenerID(customEventName);
      },
      removeAllListeners: function removeAllListeners() {
        var locListeners = this._listenersMap, locInternalCustomEventIDs = this._internalCustomListenerIDs;
        for (var selKey in locListeners) -1 === locInternalCustomEventIDs.indexOf(selKey) && this._removeListenersForListenerID(selKey);
      },
      setPriority: function setPriority(listener, fixedPriority) {
        if (null == listener) return;
        var locListeners = this._listenersMap;
        for (var selKey in locListeners) {
          var selListeners = locListeners[selKey];
          var fixedPriorityListeners = selListeners.getFixedPriorityListeners();
          if (fixedPriorityListeners) {
            var found = fixedPriorityListeners.indexOf(listener);
            if (-1 !== found) {
              null != listener._getSceneGraphPriority() && cc.logID(3502);
              if (listener._getFixedPriority() !== fixedPriority) {
                listener._setFixedPriority(fixedPriority);
                this._setDirty(listener._getListenerID(), this.DIRTY_FIXED_PRIORITY);
              }
              return;
            }
          }
        }
      },
      setEnabled: function setEnabled(enabled) {
        this._isEnabled = enabled;
      },
      isEnabled: function isEnabled() {
        return this._isEnabled;
      },
      dispatchEvent: function dispatchEvent(event) {
        if (!this._isEnabled) return;
        this._updateDirtyFlagForSceneGraph();
        this._inDispatch++;
        if (!event || !event.getType) {
          cc.errorID(3511);
          return;
        }
        if (event.getType().startsWith(cc.Event.TOUCH)) {
          this._dispatchTouchEvent(event);
          this._inDispatch--;
          return;
        }
        var listenerID = __getListenerID(event);
        this._sortEventListeners(listenerID);
        var selListeners = this._listenersMap[listenerID];
        if (null != selListeners) {
          this._dispatchEventToListeners(selListeners, this._onListenerCallback, event);
          this._onUpdateListeners(selListeners);
        }
        this._inDispatch--;
      },
      _onListenerCallback: function _onListenerCallback(listener, event) {
        event.currentTarget = listener._target;
        listener._onEvent(event);
        return event.isStopped();
      },
      dispatchCustomEvent: function dispatchCustomEvent(eventName, optionalUserData) {
        var ev = new cc.Event.EventCustom(eventName);
        ev.setUserData(optionalUserData);
        this.dispatchEvent(ev);
      }
    };
    js.get(cc, "eventManager", (function() {
      cc.errorID(1405, "cc.eventManager", "cc.EventTarget or cc.systemEvent");
      return eventManager;
    }));
    module.exports = cc.internal.eventManager = eventManager;
  }), {
    "../platform/js": 158,
    "./CCEventListener": 116
  } ],
  118: [ (function(require, module, exports) {
    "use strict";
    cc.Touch = function(x, y, id) {
      this._lastModified = 0;
      this.setTouchInfo(id, x, y);
    };
    cc.Touch.prototype = {
      constructor: cc.Touch,
      getLocation: function getLocation() {
        return cc.v2(this._point.x, this._point.y);
      },
      getLocationX: function getLocationX() {
        return this._point.x;
      },
      getLocationY: function getLocationY() {
        return this._point.y;
      },
      getPreviousLocation: function getPreviousLocation() {
        return cc.v2(this._prevPoint.x, this._prevPoint.y);
      },
      getStartLocation: function getStartLocation() {
        return cc.v2(this._startPoint.x, this._startPoint.y);
      },
      getDelta: function getDelta() {
        return this._point.sub(this._prevPoint);
      },
      getLocationInView: function getLocationInView() {
        return cc.v2(this._point.x, cc.view._designResolutionSize.height - this._point.y);
      },
      getPreviousLocationInView: function getPreviousLocationInView() {
        return cc.v2(this._prevPoint.x, cc.view._designResolutionSize.height - this._prevPoint.y);
      },
      getStartLocationInView: function getStartLocationInView() {
        return cc.v2(this._startPoint.x, cc.view._designResolutionSize.height - this._startPoint.y);
      },
      getID: function getID() {
        return this._id;
      },
      setTouchInfo: function setTouchInfo(id, x, y) {
        this._prevPoint = this._point;
        this._point = cc.v2(x || 0, y || 0);
        this._id = id;
        if (!this._startPointCaptured) {
          this._startPoint = cc.v2(this._point);
          cc.view._convertPointWithScale(this._startPoint);
          this._startPointCaptured = true;
        }
      },
      _setPoint: function _setPoint(x, y) {
        if (void 0 === y) {
          this._point.x = x.x;
          this._point.y = x.y;
        } else {
          this._point.x = x;
          this._point.y = y;
        }
      },
      _setPrevPoint: function _setPrevPoint(x, y) {
        this._prevPoint = void 0 === y ? cc.v2(x.x, x.y) : cc.v2(x || 0, y || 0);
      }
    };
  }), {} ],
  119: [ (function(require, module, exports) {
    "use strict";
    require("./CCEvent");
    require("./CCTouch");
    require("./CCEventListener");
    var eventManager = require("./CCEventManager");
    module.exports = eventManager;
    false;
  }), {
    "./CCEvent": 115,
    "./CCEventListener": 116,
    "./CCEventManager": 117,
    "./CCTouch": 118
  } ],
  120: [ (function(require, module, exports) {
    "use strict";
    var js = cc.js;
    var CallbacksInvoker = require("../platform/callbacks-invoker");
    function EventListeners() {
      CallbacksInvoker.call(this);
    }
    js.extend(EventListeners, CallbacksInvoker);
    EventListeners.prototype.emit = function(event, captureListeners) {
      var key = event.type;
      var list = this._callbackTable[key];
      if (list) {
        var rootInvoker = !list.isInvoking;
        list.isInvoking = true;
        var infos = list.callbackInfos;
        for (var i = 0, len = infos.length; i < len; ++i) {
          var info = infos[i];
          if (info && info.callback) {
            info.callback.call(info.target, event, captureListeners);
            if (event._propagationImmediateStopped) break;
          }
        }
        if (rootInvoker) {
          list.isInvoking = false;
          list.containCanceled && list.purgeCanceled();
        }
      }
    };
    module.exports = EventListeners;
    false;
  }), {
    "../platform/callbacks-invoker": 151
  } ],
  121: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    var CallbacksInvoker = require("../platform/callbacks-invoker");
    var fastRemove = js.array.fastRemove;
    function EventTarget() {
      CallbacksInvoker.call(this);
    }
    js.extend(EventTarget, CallbacksInvoker);
    var proto = EventTarget.prototype;
    proto.__on = proto.on;
    proto.on = function(type, callback, target, once) {
      if (!callback) {
        cc.errorID(6800);
        return;
      }
      if (!this.hasEventListener(type, callback, target)) {
        this.__on(type, callback, target, once);
        target && target.__eventTargets && target.__eventTargets.push(this);
      }
      return callback;
    };
    proto.__off = proto.off;
    proto.off = function(type, callback, target) {
      if (callback) {
        this.__off(type, callback, target);
        target && target.__eventTargets && fastRemove(target.__eventTargets, this);
      } else {
        var list = this._callbackTable[type];
        if (!list) return;
        var infos = list.callbackInfos;
        for (var i = 0; i < infos.length; ++i) {
          var _target = infos[i] && infos[i].target;
          _target && _target.__eventTargets && fastRemove(_target.__eventTargets, this);
        }
        this.removeAll(type);
      }
    };
    proto.targetOff = function(target) {
      this.removeAll(target);
      target && target.__eventTargets && fastRemove(target.__eventTargets, this);
    };
    proto.once = function(type, callback, target) {
      this.on(type, callback, target, true);
    };
    proto.dispatchEvent = function(event) {
      this.emit(event.type, event);
    };
    cc.EventTarget = module.exports = EventTarget;
  }), {
    "../platform/callbacks-invoker": 151,
    "../platform/js": 158
  } ],
  122: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    cc.Event = function(type, bubbles) {
      this.type = type;
      this.bubbles = !!bubbles;
      this.target = null;
      this.currentTarget = null;
      this.eventPhase = 0;
      this._propagationStopped = false;
      this._propagationImmediateStopped = false;
    };
    cc.Event.prototype = {
      constructor: cc.Event,
      unuse: function unuse() {
        this.type = cc.Event.NO_TYPE;
        this.target = null;
        this.currentTarget = null;
        this.eventPhase = cc.Event.NONE;
        this._propagationStopped = false;
        this._propagationImmediateStopped = false;
      },
      reuse: function reuse(type, bubbles) {
        this.type = type;
        this.bubbles = bubbles || false;
      },
      stopPropagation: function stopPropagation() {
        this._propagationStopped = true;
      },
      stopPropagationImmediate: function stopPropagationImmediate() {
        this._propagationImmediateStopped = true;
      },
      isStopped: function isStopped() {
        return this._propagationStopped || this._propagationImmediateStopped;
      },
      getCurrentTarget: function getCurrentTarget() {
        return this.currentTarget;
      },
      getType: function getType() {
        return this.type;
      }
    };
    cc.Event.NO_TYPE = "no_type";
    cc.Event.TOUCH = "touch";
    cc.Event.MOUSE = "mouse";
    cc.Event.KEYBOARD = "keyboard";
    cc.Event.ACCELERATION = "acceleration";
    cc.Event.NONE = 0;
    cc.Event.CAPTURING_PHASE = 1;
    cc.Event.AT_TARGET = 2;
    cc.Event.BUBBLING_PHASE = 3;
    var EventCustom = function EventCustom(type, bubbles) {
      cc.Event.call(this, type, bubbles);
      this.detail = null;
    };
    js.extend(EventCustom, cc.Event);
    EventCustom.prototype.reset = EventCustom;
    EventCustom.prototype.setUserData = function(data) {
      this.detail = data;
    };
    EventCustom.prototype.getUserData = function() {
      return this.detail;
    };
    EventCustom.prototype.getEventName = cc.Event.prototype.getType;
    var MAX_POOL_SIZE = 10;
    var _eventPool = new js.Pool(MAX_POOL_SIZE);
    EventCustom.put = function(event) {
      _eventPool.put(event);
    };
    EventCustom.get = function(type, bubbles) {
      var event = _eventPool._get();
      event ? event.reset(type, bubbles) : event = new EventCustom(type, bubbles);
      return event;
    };
    cc.Event.EventCustom = EventCustom;
    module.exports = cc.Event;
  }), {
    "../platform/js": 158
  } ],
  123: [ (function(require, module, exports) {
    "use strict";
    require("./event");
    require("./event-listeners");
    require("./event-target");
    require("./system-event");
  }), {
    "./event": 122,
    "./event-listeners": 120,
    "./event-target": 121,
    "./system-event": 124
  } ],
  124: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../event/event-target");
    var eventManager = require("../event-manager");
    var inputManger = require("../platform/CCInputManager");
    var EventType = cc.Enum({
      KEY_DOWN: "keydown",
      KEY_UP: "keyup",
      DEVICEMOTION: "devicemotion"
    });
    var keyboardListener = null;
    var accelerationListener = null;
    var SystemEvent = cc.Class({
      name: "SystemEvent",
      extends: EventTarget,
      statics: {
        EventType: EventType
      },
      setAccelerometerEnabled: function setAccelerometerEnabled(isEnable) {
        false;
        isEnable && window.DeviceMotionEvent && "function" === typeof DeviceMotionEvent.requestPermission ? DeviceMotionEvent.requestPermission().then((function(response) {
          console.log("Device Motion Event request permission: " + response);
          inputManger.setAccelerometerEnabled("granted" === response);
        })) : inputManger.setAccelerometerEnabled(isEnable);
      },
      setAccelerometerInterval: function setAccelerometerInterval(interval) {
        false;
        inputManger.setAccelerometerInterval(interval);
      },
      on: function on(type, callback, target, once) {
        false;
        this._super(type, callback, target, once);
        if (type === EventType.KEY_DOWN || type === EventType.KEY_UP) {
          keyboardListener || (keyboardListener = cc.EventListener.create({
            event: cc.EventListener.KEYBOARD,
            onKeyPressed: function onKeyPressed(keyCode, event) {
              event.type = EventType.KEY_DOWN;
              cc.systemEvent.dispatchEvent(event);
            },
            onKeyReleased: function onKeyReleased(keyCode, event) {
              event.type = EventType.KEY_UP;
              cc.systemEvent.dispatchEvent(event);
            }
          }));
          eventManager.hasEventListener(cc.EventListener.ListenerID.KEYBOARD) || eventManager.addListener(keyboardListener, 1);
        }
        if (type === EventType.DEVICEMOTION) {
          accelerationListener || (accelerationListener = cc.EventListener.create({
            event: cc.EventListener.ACCELERATION,
            callback: function callback(acc, event) {
              event.type = EventType.DEVICEMOTION;
              cc.systemEvent.dispatchEvent(event);
            }
          }));
          eventManager.hasEventListener(cc.EventListener.ListenerID.ACCELERATION) || eventManager.addListener(accelerationListener, 1);
        }
      },
      off: function off(type, callback, target) {
        false;
        this._super(type, callback, target);
        if (keyboardListener && (type === EventType.KEY_DOWN || type === EventType.KEY_UP)) {
          var hasKeyDownEventListener = this.hasEventListener(EventType.KEY_DOWN);
          var hasKeyUpEventListener = this.hasEventListener(EventType.KEY_UP);
          hasKeyDownEventListener || hasKeyUpEventListener || eventManager.removeListener(keyboardListener);
        }
        accelerationListener && type === EventType.DEVICEMOTION && eventManager.removeListener(accelerationListener);
      }
    });
    cc.SystemEvent = module.exports = SystemEvent;
    cc.systemEvent = new cc.SystemEvent();
  }), {
    "../event-manager": 119,
    "../event/event-target": 121,
    "../platform/CCInputManager": 142
  } ],
  125: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _vec = _interopRequireDefault(require("../value-types/vec3"));
    var _mat = _interopRequireDefault(require("../value-types/mat3"));
    var _enums = _interopRequireDefault(require("./enums"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var _v3_tmp = new _vec["default"]();
    var _v3_tmp2 = new _vec["default"]();
    var _m3_tmp = new _mat["default"]();
    var transform_extent_m4 = function transform_extent_m4(out, extent, m4) {
      var _m3_tmpm = _m3_tmp.m, m4m = m4.m;
      _m3_tmpm[0] = Math.abs(m4m[0]);
      _m3_tmpm[1] = Math.abs(m4m[1]);
      _m3_tmpm[2] = Math.abs(m4m[2]);
      _m3_tmpm[3] = Math.abs(m4m[4]);
      _m3_tmpm[4] = Math.abs(m4m[5]);
      _m3_tmpm[5] = Math.abs(m4m[6]);
      _m3_tmpm[6] = Math.abs(m4m[8]);
      _m3_tmpm[7] = Math.abs(m4m[9]);
      _m3_tmpm[8] = Math.abs(m4m[10]);
      _vec["default"].transformMat3(out, extent, _m3_tmp);
    };
    var aabb = (function() {
      aabb.create = function create(px, py, pz, w, h, l) {
        return new aabb(px, py, pz, w, h, l);
      };
      aabb.clone = function clone(a) {
        return new aabb(a.center.x, a.center.y, a.center.z, a.halfExtents.x, a.halfExtents.y, a.halfExtents.z);
      };
      aabb.copy = function copy(out, a) {
        _vec["default"].copy(out.center, a.center);
        _vec["default"].copy(out.halfExtents, a.halfExtents);
        return out;
      };
      aabb.fromPoints = function fromPoints(out, minPos, maxPos) {
        _vec["default"].scale(out.center, _vec["default"].add(_v3_tmp, minPos, maxPos), .5);
        _vec["default"].scale(out.halfExtents, _vec["default"].sub(_v3_tmp2, maxPos, minPos), .5);
        return out;
      };
      aabb.set = function set(out, px, py, pz, w, h, l) {
        _vec["default"].set(out.center, px, py, pz);
        _vec["default"].set(out.halfExtents, w, h, l);
        return out;
      };
      function aabb(px, py, pz, w, h, l) {
        this.center = void 0;
        this.halfExtents = void 0;
        this._type = void 0;
        this._type = _enums["default"].SHAPE_AABB;
        this.center = new _vec["default"](px, py, pz);
        this.halfExtents = new _vec["default"](w, h, l);
      }
      var _proto = aabb.prototype;
      _proto.getBoundary = function getBoundary(minPos, maxPos) {
        _vec["default"].sub(minPos, this.center, this.halfExtents);
        _vec["default"].add(maxPos, this.center, this.halfExtents);
      };
      _proto.transform = function transform(m, pos, rot, scale, out) {
        out || (out = this);
        _vec["default"].transformMat4(out.center, this.center, m);
        transform_extent_m4(out.halfExtents, this.halfExtents, m);
      };
      return aabb;
    })();
    exports["default"] = aabb;
    module.exports = exports["default"];
  }), {
    "../value-types/mat3": 225,
    "../value-types/vec3": 234,
    "./enums": 126
  } ],
  126: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _default = {
      SHAPE_RAY: 1,
      SHAPE_LINE: 2,
      SHAPE_SPHERE: 4,
      SHAPE_AABB: 8,
      SHAPE_OBB: 16,
      SHAPE_PLANE: 32,
      SHAPE_TRIANGLE: 64,
      SHAPE_FRUSTUM: 128,
      SHAPE_FRUSTUM_ACCURATE: 256
    };
    exports["default"] = _default;
    module.exports = exports["default"];
  }), {} ],
  127: [ (function(require, module, exports) {
    "use strict";
    var RenderComponent = require("../components/CCRenderComponent");
    var Material = require("../assets/material/CCMaterial");
    var Types = require("./types");
    var LineCap = Types.LineCap;
    var LineJoin = Types.LineJoin;
    var Graphics = cc.Class({
      name: "cc.Graphics",
      extends: RenderComponent,
      editor: false,
      ctor: function ctor() {
        this._impl = new Graphics._Impl(this);
      },
      properties: {
        _lineWidth: 2,
        _strokeColor: cc.Color.BLACK,
        _lineJoin: LineJoin.MITER,
        _lineCap: LineCap.BUTT,
        _fillColor: cc.Color.WHITE,
        _miterLimit: 10,
        lineWidth: {
          get: function get() {
            return this._lineWidth;
          },
          set: function set(value) {
            this._lineWidth = value;
            this._impl.lineWidth = value;
          }
        },
        lineJoin: {
          get: function get() {
            return this._lineJoin;
          },
          set: function set(value) {
            this._lineJoin = value;
            this._impl.lineJoin = value;
          },
          type: LineJoin
        },
        lineCap: {
          get: function get() {
            return this._lineCap;
          },
          set: function set(value) {
            this._lineCap = value;
            this._impl.lineCap = value;
          },
          type: LineCap
        },
        strokeColor: {
          get: function get() {
            return this._strokeColor;
          },
          set: function set(value) {
            this._impl.strokeColor = this._strokeColor = cc.color(value);
          }
        },
        fillColor: {
          get: function get() {
            return this._fillColor;
          },
          set: function set(value) {
            this._impl.fillColor = this._fillColor = cc.color(value);
          }
        },
        miterLimit: {
          get: function get() {
            return this._miterLimit;
          },
          set: function set(value) {
            this._miterLimit = value;
            this._impl.miterLimit = value;
          }
        }
      },
      statics: {
        LineJoin: LineJoin,
        LineCap: LineCap
      },
      onRestore: function onRestore() {
        this._impl || (this._impl = new Graphics._Impl(this));
      },
      onDestroy: function onDestroy() {
        this.clear(true);
        this._super();
        this._impl = null;
      },
      _getDefaultMaterial: function _getDefaultMaterial() {
        return Material.getBuiltinMaterial("2d-graphics");
      },
      _updateMaterial: function _updateMaterial() {
        var material = this._materials[0];
        if (!material) return;
        void 0 !== material.getDefine("CC_USE_MODEL") && material.define("CC_USE_MODEL", true);
        void 0 !== material.getDefine("CC_SUPPORT_standard_derivatives") && cc.sys.glExtension("OES_standard_derivatives") && material.define("CC_SUPPORT_standard_derivatives", true);
      },
      moveTo: function moveTo(x, y) {
        if (true, x instanceof cc.Vec2) {
          cc.warn("[moveTo] : Can not pass Vec2 as [x, y] value, please check it.");
          return;
        }
        this._impl.moveTo(x, y);
      },
      lineTo: function lineTo(x, y) {
        if (true, x instanceof cc.Vec2) {
          cc.warn("[moveTo] : Can not pass Vec2 as [x, y] value, please check it.");
          return;
        }
        this._impl.lineTo(x, y);
      },
      bezierCurveTo: function bezierCurveTo(c1x, c1y, c2x, c2y, x, y) {
        this._impl.bezierCurveTo(c1x, c1y, c2x, c2y, x, y);
      },
      quadraticCurveTo: function quadraticCurveTo(cx, cy, x, y) {
        this._impl.quadraticCurveTo(cx, cy, x, y);
      },
      arc: function arc(cx, cy, r, startAngle, endAngle, counterclockwise) {
        this._impl.arc(cx, cy, r, startAngle, endAngle, counterclockwise);
      },
      ellipse: function ellipse(cx, cy, rx, ry) {
        this._impl.ellipse(cx, cy, rx, ry);
      },
      circle: function circle(cx, cy, r) {
        this._impl.circle(cx, cy, r);
      },
      rect: function rect(x, y, w, h) {
        this._impl.rect(x, y, w, h);
      },
      roundRect: function roundRect(x, y, w, h, r) {
        this._impl.roundRect(x, y, w, h, r);
      },
      fillRect: function fillRect(x, y, w, h) {
        this.rect(x, y, w, h);
        this.fill();
      },
      clear: function clear(clean) {
        this._impl.clear(clean);
        this._assembler && this._assembler.clear(clean);
      },
      close: function close() {
        this._impl.close();
      },
      stroke: function stroke() {
        this._assembler || this._resetAssembler();
        this._assembler.stroke(this);
      },
      fill: function fill() {
        this._assembler || this._resetAssembler();
        this._assembler.fill(this);
      }
    });
    cc.Graphics = module.exports = Graphics;
    cc.Graphics.Types = Types;
    cc.Graphics.Helper = require("./helper");
  }), {
    "../assets/material/CCMaterial": 77,
    "../components/CCRenderComponent": 100,
    "./helper": 128,
    "./types": 130
  } ],
  128: [ (function(require, module, exports) {
    "use strict";
    var PointFlags = require("./types").PointFlags;
    var PI = Math.PI;
    var min = Math.min;
    var max = Math.max;
    var cos = Math.cos;
    var sin = Math.sin;
    var abs = Math.abs;
    var sign = Math.sign;
    var KAPPA90 = .5522847493;
    function arc(ctx, cx, cy, r, startAngle, endAngle, counterclockwise) {
      counterclockwise = counterclockwise || false;
      var a = 0, da = 0, hda = 0, kappa = 0;
      var dx = 0, dy = 0, x = 0, y = 0, tanx = 0, tany = 0;
      var px = 0, py = 0, ptanx = 0, ptany = 0;
      var i, ndivs;
      da = endAngle - startAngle;
      if (counterclockwise) if (abs(da) >= 2 * PI) da = 2 * PI; else while (da < 0) da += 2 * PI; else if (abs(da) >= 2 * PI) da = 2 * -PI; else while (da > 0) da -= 2 * PI;
      ndivs = 0 | max(1, min(abs(da) / (.5 * PI) + .5, 5));
      hda = da / ndivs / 2;
      kappa = abs(4 / 3 * (1 - cos(hda)) / sin(hda));
      counterclockwise || (kappa = -kappa);
      for (i = 0; i <= ndivs; i++) {
        a = startAngle + da * (i / ndivs);
        dx = cos(a);
        dy = sin(a);
        x = cx + dx * r;
        y = cy + dy * r;
        tanx = -dy * r * kappa;
        tany = dx * r * kappa;
        0 === i ? ctx.moveTo(x, y) : ctx.bezierCurveTo(px + ptanx, py + ptany, x - tanx, y - tany, x, y);
        px = x;
        py = y;
        ptanx = tanx;
        ptany = tany;
      }
    }
    function ellipse(ctx, cx, cy, rx, ry) {
      ctx.moveTo(cx - rx, cy);
      ctx.bezierCurveTo(cx - rx, cy + ry * KAPPA90, cx - rx * KAPPA90, cy + ry, cx, cy + ry);
      ctx.bezierCurveTo(cx + rx * KAPPA90, cy + ry, cx + rx, cy + ry * KAPPA90, cx + rx, cy);
      ctx.bezierCurveTo(cx + rx, cy - ry * KAPPA90, cx + rx * KAPPA90, cy - ry, cx, cy - ry);
      ctx.bezierCurveTo(cx - rx * KAPPA90, cy - ry, cx - rx, cy - ry * KAPPA90, cx - rx, cy);
      ctx.close();
    }
    function roundRect(ctx, x, y, w, h, r) {
      if (r < .1) {
        ctx.rect(x, y, w, h);
        return;
      }
      var rx = min(r, .5 * abs(w)) * sign(w), ry = min(r, .5 * abs(h)) * sign(h);
      ctx.moveTo(x, y + ry);
      ctx.lineTo(x, y + h - ry);
      ctx.bezierCurveTo(x, y + h - ry * (1 - KAPPA90), x + rx * (1 - KAPPA90), y + h, x + rx, y + h);
      ctx.lineTo(x + w - rx, y + h);
      ctx.bezierCurveTo(x + w - rx * (1 - KAPPA90), y + h, x + w, y + h - ry * (1 - KAPPA90), x + w, y + h - ry);
      ctx.lineTo(x + w, y + ry);
      ctx.bezierCurveTo(x + w, y + ry * (1 - KAPPA90), x + w - rx * (1 - KAPPA90), y, x + w - rx, y);
      ctx.lineTo(x + rx, y);
      ctx.bezierCurveTo(x + rx * (1 - KAPPA90), y, x, y + ry * (1 - KAPPA90), x, y + ry);
      ctx.close();
    }
    function tesselateBezier(ctx, x1, y1, x2, y2, x3, y3, x4, y4, level, type) {
      var x12, y12, x23, y23, x34, y34, x123, y123, x234, y234, x1234, y1234;
      var dx, dy, d2, d3;
      if (level > 10) return;
      x12 = .5 * (x1 + x2);
      y12 = .5 * (y1 + y2);
      x23 = .5 * (x2 + x3);
      y23 = .5 * (y2 + y3);
      x34 = .5 * (x3 + x4);
      y34 = .5 * (y3 + y4);
      x123 = .5 * (x12 + x23);
      y123 = .5 * (y12 + y23);
      dx = x4 - x1;
      dy = y4 - y1;
      d2 = abs((x2 - x4) * dy - (y2 - y4) * dx);
      d3 = abs((x3 - x4) * dy - (y3 - y4) * dx);
      if ((d2 + d3) * (d2 + d3) < ctx._tessTol * (dx * dx + dy * dy)) {
        ctx._addPoint(x4, y4, 0 === type ? type | PointFlags.PT_BEVEL : type);
        return;
      }
      x234 = .5 * (x23 + x34);
      y234 = .5 * (y23 + y34);
      x1234 = .5 * (x123 + x234);
      y1234 = .5 * (y123 + y234);
      tesselateBezier(ctx, x1, y1, x12, y12, x123, y123, x1234, y1234, level + 1, 0);
      tesselateBezier(ctx, x1234, y1234, x234, y234, x34, y34, x4, y4, level + 1, type);
    }
    module.exports = {
      arc: arc,
      ellipse: ellipse,
      roundRect: roundRect,
      tesselateBezier: tesselateBezier
    };
  }), {
    "./types": 130
  } ],
  129: [ (function(require, module, exports) {
    "use strict";
    require("./graphics");
  }), {
    "./graphics": 127
  } ],
  130: [ (function(require, module, exports) {
    "use strict";
    var LineCap = cc.Enum({
      BUTT: 0,
      ROUND: 1,
      SQUARE: 2
    });
    var LineJoin = cc.Enum({
      BEVEL: 0,
      ROUND: 1,
      MITER: 2
    });
    var PointFlags = cc.Enum({
      PT_CORNER: 1,
      PT_LEFT: 2,
      PT_BEVEL: 4,
      PT_INNERBEVEL: 8
    });
    module.exports = {
      LineCap: LineCap,
      LineJoin: LineJoin,
      PointFlags: PointFlags
    };
  }), {} ],
  131: [ (function(require, module, exports) {
    "use strict";
    require("./platform");
    require("./assets");
    true;
    require("./CCNode");
    require("./CCPrivateNode");
    require("./CCScene");
    require("./components");
    require("./graphics");
    require("./collider");
    require("./collider/CCIntersection");
    require("./physics");
    require("./camera/CCCamera");
    require("./geom-utils");
    require("./mesh");
    require("./3d");
    require("./base-ui/CCWidgetManager");
  }), {
    "./3d": void 0,
    "./CCNode": 26,
    "./CCPrivateNode": 27,
    "./CCScene": 28,
    "./assets": 75,
    "./base-ui/CCWidgetManager": 86,
    "./camera/CCCamera": 87,
    "./collider": void 0,
    "./collider/CCIntersection": void 0,
    "./components": 113,
    "./geom-utils": void 0,
    "./graphics": 129,
    "./mesh": 134,
    "./physics": void 0,
    "./platform": 155
  } ],
  132: [ (function(require, module, exports) {
    "use strict";
    var _inputAssembler = _interopRequireDefault(require("../../renderer/core/input-assembler"));
    var _gfx = _interopRequireDefault(require("../../renderer/gfx"));
    var _meshData = require("./mesh-data");
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var renderer = require("../renderer");
    var EventTarget = require("../event/event-target");
    function applyColor(data, offset, value) {
      data[offset] = value._val;
    }
    function applyVec2(data, offset, value) {
      data[offset] = value.x;
      data[offset + 1] = value.y;
    }
    function applyVec3(data, offset, value) {
      data[offset] = value.x;
      data[offset + 1] = value.y;
      data[offset + 2] = value.z;
    }
    var _compType2fn = {
      5120: "getInt8",
      5121: "getUint8",
      5122: "getInt16",
      5123: "getUint16",
      5124: "getInt32",
      5125: "getUint32",
      5126: "getFloat32"
    };
    var _compType2write = {
      5120: "setInt8",
      5121: "setUint8",
      5122: "setInt16",
      5123: "setUint16",
      5124: "setInt32",
      5125: "setUint32",
      5126: "setFloat32"
    };
    var littleEndian = (function() {
      var buffer = new ArrayBuffer(2);
      new DataView(buffer).setInt16(0, 256, true);
      return 256 === new Int16Array(buffer)[0];
    })();
    var Mesh = cc.Class({
      name: "cc.Mesh",
      extends: cc.Asset,
      mixins: [ EventTarget ],
      properties: {
        _nativeAsset: {
          override: true,
          get: function get() {
            return this._buffer;
          },
          set: function set(bin) {
            this._buffer = ArrayBuffer.isView(bin) ? bin.buffer : bin;
            this.initWithBuffer();
          }
        },
        _vertexBundles: {
          default: null,
          type: _meshData.VertexBundle
        },
        _primitives: {
          default: null,
          Primitive: _meshData.Primitive
        },
        _minPos: cc.v3(),
        _maxPos: cc.v3(),
        subMeshes: {
          get: function get() {
            return this._subMeshes;
          },
          set: function set(v) {
            this._subMeshes = v;
          }
        },
        subDatas: {
          get: function get() {
            return this._subDatas;
          }
        }
      },
      ctor: function ctor() {
        this._subMeshes = [];
        this._subDatas = [];
        this.loaded = false;
      },
      initWithBuffer: function initWithBuffer() {
        this._subMeshes.length = 0;
        var primitives = this._primitives;
        for (var i = 0; i < primitives.length; i++) {
          var primitive = primitives[i];
          var ibrange = primitive.data;
          var ibData = new Uint8Array(this._buffer, ibrange.offset, ibrange.length);
          var vertexBundle = this._vertexBundles[primitive.vertexBundleIndices[0]];
          var vbRange = vertexBundle.data;
          var gfxVFmt = new _gfx["default"].VertexFormat(vertexBundle.formats);
          var vbData = new Uint8Array(this._buffer, vbRange.offset, vbRange.length);
          var canBatch = this._canVertexFormatBatch(gfxVFmt);
          var meshData = new _meshData.MeshData();
          meshData.vData = vbData;
          meshData.iData = ibData;
          meshData.vfm = gfxVFmt;
          meshData.offset = vbRange.offset;
          meshData.canBatch = canBatch;
          this._subDatas.push(meshData);
          false;
          var vbBuffer = new _gfx["default"].VertexBuffer(renderer.device, gfxVFmt, _gfx["default"].USAGE_STATIC, vbData);
          var ibBuffer = new _gfx["default"].IndexBuffer(renderer.device, primitive.indexUnit, _gfx["default"].USAGE_STATIC, ibData);
          this._subMeshes.push(new _inputAssembler["default"](vbBuffer, ibBuffer));
        }
        this.loaded = true;
        this.emit("load");
      },
      _canVertexFormatBatch: function _canVertexFormatBatch(format) {
        var aPosition = format._attr2el[_gfx["default"].ATTR_POSITION];
        var canBatch = !aPosition || aPosition.type === _gfx["default"].ATTR_TYPE_FLOAT32 && format._bytes % 4 === 0;
        return canBatch;
      },
      init: function init(vertexFormat, vertexCount, dynamic, index) {
        void 0 === dynamic && (dynamic = false);
        void 0 === index && (index = 0);
        var data = new Uint8Array(vertexFormat._bytes * vertexCount);
        var meshData = new _meshData.MeshData();
        meshData.vData = data;
        meshData.vfm = vertexFormat;
        meshData.vDirty = true;
        meshData.canBatch = this._canVertexFormatBatch(vertexFormat);
        true;
        var vb = new _gfx["default"].VertexBuffer(renderer.device, vertexFormat, dynamic ? _gfx["default"].USAGE_DYNAMIC : _gfx["default"].USAGE_STATIC, data);
        meshData.vb = vb;
        this._subMeshes[index] = new _inputAssembler["default"](meshData.vb);
        var oldSubData = this._subDatas[index];
        if (oldSubData) {
          oldSubData.vb && oldSubData.vb.destroy();
          oldSubData.ib && oldSubData.ib.destroy();
        }
        this._subDatas[index] = meshData;
        this.loaded = true;
        this.emit("load");
        this.emit("init-format");
      },
      setVertices: function setVertices(name, values, index) {
        index = index || 0;
        var subData = this._subDatas[index];
        var el = subData.vfm.element(name);
        if (!el) return cc.warn("Cannot find " + name + " attribute in vertex defines.");
        var isFlatMode = "number" === typeof values[0];
        var elNum = el.num;
        var verticesCount = isFlatMode ? values.length / elNum | 0 : values.length;
        subData.vData.byteLength < verticesCount * el.stride && subData.setVData(new Uint8Array(verticesCount * subData.vfm._bytes));
        var data;
        var bytes = 4;
        if (name === _gfx["default"].ATTR_COLOR) if (isFlatMode) {
          data = subData.getVData();
          bytes = 1;
        } else data = subData.getVData(Uint32Array); else data = subData.getVData(Float32Array);
        var stride = el.stride / bytes;
        var offset = el.offset / bytes;
        if (isFlatMode) for (var i = 0, l = values.length / elNum; i < l; i++) {
          var sOffset = i * elNum;
          var dOffset = i * stride + offset;
          for (var j = 0; j < elNum; j++) data[dOffset + j] = values[sOffset + j];
        } else {
          var applyFunc;
          applyFunc = name === _gfx["default"].ATTR_COLOR ? applyColor : 2 === elNum ? applyVec2 : applyVec3;
          for (var _i = 0, _l = values.length; _i < _l; _i++) {
            var v = values[_i];
            var vOffset = _i * stride + offset;
            applyFunc(data, vOffset, v);
          }
        }
        subData.vDirty = true;
      },
      setIndices: function setIndices(indices, index, dynamic) {
        index = index || 0;
        var iData = indices;
        if (indices instanceof Uint16Array) iData = new Uint8Array(indices.buffer, indices.byteOffset, indices.byteLength); else if (Array.isArray(indices)) {
          iData = new Uint16Array(indices);
          iData = new Uint8Array(iData.buffer, iData.byteOffset, iData.byteLength);
        }
        var usage = dynamic ? _gfx["default"].USAGE_DYNAMIC : _gfx["default"].USAGE_STATIC;
        var subData = this._subDatas[index];
        if (subData.ib) {
          subData.iData = iData;
          subData.iDirty = true;
        } else {
          subData.iData = iData;
          true;
          var buffer = new _gfx["default"].IndexBuffer(renderer.device, _gfx["default"].INDEX_FMT_UINT16, usage, iData, iData.byteLength / _gfx["default"].IndexBuffer.BYTES_PER_INDEX[_gfx["default"].INDEX_FMT_UINT16]);
          subData.ib = buffer;
          this._subMeshes[index]._indexBuffer = subData.ib;
        }
      },
      setPrimitiveType: function setPrimitiveType(type, index) {
        index = index || 0;
        var subMesh = this._subMeshes[index];
        if (!subMesh) {
          cc.warn("Do not have sub mesh at index " + index);
          return;
        }
        this._subMeshes[index]._primitiveType = type;
      },
      clear: function clear() {
        this._subMeshes.length = 0;
        var subDatas = this._subDatas;
        for (var i = 0, len = subDatas.length; i < len; i++) {
          var vb = subDatas[i].vb;
          vb && vb.destroy();
          var ib = subDatas[i].ib;
          ib && ib.destroy();
        }
        subDatas.length = 0;
      },
      setBoundingBox: function setBoundingBox(min, max) {
        this._minPos = min;
        this._maxPos = max;
      },
      destroy: function destroy() {
        this.clear();
      },
      _uploadData: function _uploadData() {
        var subDatas = this._subDatas;
        for (var i = 0, len = subDatas.length; i < len; i++) {
          var subData = subDatas[i];
          if (subData.vDirty) {
            var buffer = subData.vb, data = subData.vData;
            buffer.update(0, data);
            subData.vDirty = false;
          }
          if (subData.iDirty) {
            var _buffer = subData.ib, _data = subData.iData;
            _buffer.update(0, _data);
            subData.iDirty = false;
          }
        }
      },
      _getAttrMeshData: function _getAttrMeshData(subDataIndex, name) {
        var subData = this._subDatas[subDataIndex];
        if (!subData) return [];
        var format = subData.vfm;
        var fmt = format.element(name);
        if (!fmt) return [];
        subData.attrDatas || (subData.attrDatas = {});
        var attrDatas = subData.attrDatas;
        var data = attrDatas[name];
        if (data) return data;
        data = attrDatas[name] = [];
        var vbData = subData.vData;
        var dv = new DataView(vbData.buffer, vbData.byteOffset, vbData.byteLength);
        var stride = fmt.stride;
        var eleOffset = fmt.offset;
        var eleNum = fmt.num;
        var eleByte = fmt.bytes / eleNum;
        var fn = _compType2fn[fmt.type];
        var vertexCount = vbData.byteLength / format._bytes;
        for (var i = 0; i < vertexCount; i++) {
          var offset = i * stride + eleOffset;
          for (var j = 0; j < eleNum; j++) {
            var v = dv[fn](offset + j * eleByte, littleEndian);
            data.push(v);
          }
        }
        return data;
      },
      copyAttribute: function copyAttribute(primitiveIndex, attributeName, buffer, stride, offset) {
        var written = false;
        var subData = this._subDatas[primitiveIndex];
        if (!subData) return written;
        var format = subData.vfm;
        var fmt = format.element(attributeName);
        if (!fmt) return written;
        var writter = _compType2write[fmt.type];
        if (!writter) return written;
        var data = this._getAttrMeshData(primitiveIndex, attributeName);
        var vertexCount = subData.vData.byteLength / format._bytes;
        var eleByte = fmt.bytes / fmt.num;
        if (data.length > 0) {
          var outputView = new DataView(buffer, offset);
          var outputStride = stride;
          var num = fmt.num;
          for (var i = 0; i < vertexCount; ++i) {
            var index = i * num;
            for (var j = 0; j < num; ++j) {
              var inputOffset = index + j;
              var outputOffset = outputStride * i + eleByte * j;
              outputView[writter](outputOffset, data[inputOffset], littleEndian);
            }
          }
          written = true;
        }
        return written;
      },
      copyIndices: function copyIndices(primitiveIndex, outputArray) {
        var subData = this._subDatas[primitiveIndex];
        if (!subData) return false;
        var iData = subData.iData;
        var indexCount = iData.length / 2;
        var dv = new DataView(iData.buffer, iData.byteOffset, iData.byteLength);
        var fn = _compType2fn[_gfx["default"].INDEX_FMT_UINT8];
        for (var i = 0; i < indexCount; ++i) outputArray[i] = dv[fn](2 * i);
        return true;
      }
    });
    cc.Mesh = module.exports = Mesh;
  }), {
    "../../renderer/core/input-assembler": 241,
    "../../renderer/gfx": 251,
    "../event/event-target": 121,
    "../renderer": 168,
    "./mesh-data": 135
  } ],
  133: [ (function(require, module, exports) {
    "use strict";
    var _gfx = _interopRequireDefault(require("../../renderer/gfx"));
    var _inputAssembler = _interopRequireDefault(require("../../renderer/core/input-assembler"));
    var _aabb = _interopRequireDefault(require("../geom-utils/aabb"));
    var _vec = _interopRequireDefault(require("../value-types/vec3"));
    var _mat = _interopRequireDefault(require("../value-types/mat4"));
    var _materialVariant = _interopRequireDefault(require("../assets/material/material-variant"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var RenderComponent = require("../components/CCRenderComponent");
    var Mesh = require("./CCMesh");
    var RenderFlow = require("../renderer/render-flow");
    var Renderer = require("../renderer");
    var Material = require("../assets/material/CCMaterial");
    var ShadowCastingMode = cc.Enum({
      OFF: 0,
      ON: 1
    });
    var MeshRenderer = cc.Class({
      name: "cc.MeshRenderer",
      extends: RenderComponent,
      editor: false,
      properties: {
        _mesh: {
          default: null,
          type: Mesh
        },
        _receiveShadows: false,
        _shadowCastingMode: ShadowCastingMode.OFF,
        _enableAutoBatch: false,
        mesh: {
          get: function get() {
            return this._mesh;
          },
          set: function set(v) {
            if (this._mesh === v) return;
            this._setMesh(v);
            if (!v) {
              this.disableRender();
              return;
            }
            this.markForRender(true);
            this.node._renderFlag |= RenderFlow.FLAG_TRANSFORM;
          },
          type: Mesh,
          animatable: false
        },
        textures: {
          default: [],
          type: cc.Texture2D,
          visible: false
        },
        receiveShadows: {
          get: function get() {
            return this._receiveShadows;
          },
          set: function set(val) {
            this._receiveShadows = val;
            this._updateReceiveShadow();
          },
          animatable: false
        },
        shadowCastingMode: {
          get: function get() {
            return this._shadowCastingMode;
          },
          set: function set(val) {
            this._shadowCastingMode = val;
            this._updateCastShadow();
          },
          type: ShadowCastingMode,
          animatable: false
        },
        enableAutoBatch: {
          get: function get() {
            return this._enableAutoBatch;
          },
          set: function set(val) {
            this._enableAutoBatch = val;
          }
        }
      },
      statics: {
        ShadowCastingMode: ShadowCastingMode
      },
      ctor: function ctor() {
        this._boundingBox = cc.geomUtils && new _aabb["default"]();
        true;
        this._debugDatas = {
          wireFrame: [],
          normal: []
        };
      },
      onEnable: function onEnable() {
        var _this = this;
        this._super();
        if (this._mesh && !this._mesh.loaded) {
          this.disableRender();
          this._mesh.once("load", (function() {
            if (!_this.isValid) return;
            _this._setMesh(_this._mesh);
            _this.markForRender(true);
          }));
          cc.assetManager.postLoadNative(this._mesh);
        } else this._setMesh(this._mesh);
        this._updateRenderNode();
        this._updateMaterial();
      },
      onDestroy: function onDestroy() {
        this._setMesh(null);
        cc.pool.assembler.put(this._assembler);
      },
      _updateRenderNode: function _updateRenderNode() {
        this._assembler.setRenderNode(this.node);
      },
      _setMesh: function _setMesh(mesh) {
        cc.geomUtils && mesh && _aabb["default"].fromPoints(this._boundingBox, mesh._minPos, mesh._maxPos);
        this._mesh && this._mesh.off("init-format", this._updateMeshAttribute, this);
        mesh && mesh.on("init-format", this._updateMeshAttribute, this);
        this._mesh = mesh;
        this._assembler && (this._assembler._worldDatas = {});
        this._updateMeshAttribute();
      },
      _getDefaultMaterial: function _getDefaultMaterial() {
        return Material.getBuiltinMaterial("unlit");
      },
      _validateRender: function _validateRender() {
        var mesh = this._mesh;
        if (mesh && mesh._subDatas.length > 0) return;
        this.disableRender();
      },
      _updateMaterial: function _updateMaterial() {
        var textures = this.textures;
        if (textures && textures.length > 0) {
          var defaultMaterial = this._getDefaultMaterial();
          for (var i = 0; i < textures.length; i++) {
            var material = this._materials[i];
            if (material && material._uuid !== defaultMaterial._uuid) continue;
            if (!material) {
              material = _materialVariant["default"].create(defaultMaterial, this);
              this.setMaterial(i, material);
            }
            material.setProperty("diffuseTexture", textures[i]);
          }
        }
        this._updateReceiveShadow();
        this._updateCastShadow();
        this._updateMeshAttribute();
      },
      _updateReceiveShadow: function _updateReceiveShadow() {
        var materials = this.getMaterials();
        for (var i = 0; i < materials.length; i++) materials[i].define("CC_USE_SHADOW_MAP", this._receiveShadows, void 0, true);
      },
      _updateCastShadow: function _updateCastShadow() {
        var materials = this.getMaterials();
        for (var i = 0; i < materials.length; i++) materials[i].define("CC_CASTING_SHADOW", this._shadowCastingMode === ShadowCastingMode.ON, void 0, true);
      },
      _updateMeshAttribute: function _updateMeshAttribute() {
        var subDatas = this._mesh && this._mesh.subDatas;
        if (!subDatas) return;
        var materials = this.getMaterials();
        for (var i = 0; i < materials.length; i++) {
          if (!subDatas[i]) break;
          var vfm = subDatas[i].vfm;
          var material = materials[i];
          material.define("CC_USE_ATTRIBUTE_COLOR", !!vfm.element(_gfx["default"].ATTR_COLOR), void 0, true);
          material.define("CC_USE_ATTRIBUTE_UV0", !!vfm.element(_gfx["default"].ATTR_UV0), void 0, true);
          material.define("CC_USE_ATTRIBUTE_NORMAL", !!vfm.element(_gfx["default"].ATTR_NORMAL), void 0, true);
          material.define("CC_USE_ATTRIBUTE_TANGENT", !!vfm.element(_gfx["default"].ATTR_TANGENT), void 0, true);
        }
        true;
        for (var name in this._debugDatas) this._debugDatas[name].length = 0;
        false;
      },
      _checkBacth: function _checkBacth() {}
    });
    true;
    var BLACK_COLOR = cc.Color.BLACK;
    var RED_COLOR = cc.Color.RED;
    var v3_tmp = [ cc.v3(), cc.v3() ];
    var mat4_tmp = cc.mat4();
    var createDebugDataFns = {
      normal: function normal(comp, ia, subData, subIndex) {
        var oldVfm = subData.vfm;
        var normalEle = oldVfm.element(_gfx["default"].ATTR_NORMAL);
        var posEle = oldVfm.element(_gfx["default"].ATTR_POSITION);
        var jointEle = oldVfm.element(_gfx["default"].ATTR_JOINTS);
        var weightEle = oldVfm.element(_gfx["default"].ATTR_WEIGHTS);
        if (!normalEle || !posEle) return;
        var indices = [];
        var vbData = [];
        var lineLength = 100;
        _vec["default"].set(v3_tmp[0], 5, 0, 0);
        _mat["default"].invert(mat4_tmp, comp.node._worldMatrix);
        _vec["default"].transformMat4Normal(v3_tmp[0], v3_tmp[0], mat4_tmp);
        lineLength = v3_tmp[0].mag();
        var mesh = comp.mesh;
        var posData = mesh._getAttrMeshData(subIndex, _gfx["default"].ATTR_POSITION);
        var normalData = mesh._getAttrMeshData(subIndex, _gfx["default"].ATTR_NORMAL);
        var jointData = mesh._getAttrMeshData(subIndex, _gfx["default"].ATTR_JOINTS);
        var weightData = mesh._getAttrMeshData(subIndex, _gfx["default"].ATTR_WEIGHTS);
        var vertexCount = posData.length / posEle.num;
        for (var i = 0; i < vertexCount; i++) {
          var normalIndex = i * normalEle.num;
          var posIndex = i * posEle.num;
          _vec["default"].set(v3_tmp[0], normalData[normalIndex], normalData[normalIndex + 1], normalData[normalIndex + 2]);
          _vec["default"].set(v3_tmp[1], posData[posIndex], posData[posIndex + 1], posData[posIndex + 2]);
          _vec["default"].scaleAndAdd(v3_tmp[0], v3_tmp[1], v3_tmp[0], lineLength);
          for (var lineIndex = 0; lineIndex < 2; lineIndex++) {
            vbData.push(v3_tmp[lineIndex].x, v3_tmp[lineIndex].y, v3_tmp[lineIndex].z);
            if (jointEle) {
              var jointIndex = i * jointEle.num;
              for (var j = 0; j < jointEle.num; j++) vbData.push(jointData[jointIndex + j]);
            }
            if (weightEle) {
              var weightIndex = i * weightEle.num;
              for (var _j = 0; _j < weightEle.num; _j++) vbData.push(weightData[weightIndex + _j]);
            }
          }
          indices.push(2 * i, 2 * i + 1);
        }
        var formatOpts = [ {
          name: _gfx["default"].ATTR_POSITION,
          type: _gfx["default"].ATTR_TYPE_FLOAT32,
          num: 3
        } ];
        jointEle && formatOpts.push({
          name: _gfx["default"].ATTR_JOINTS,
          type: _gfx["default"].ATTR_TYPE_FLOAT32,
          num: jointEle.num
        });
        weightEle && formatOpts.push({
          name: _gfx["default"].ATTR_WEIGHTS,
          type: _gfx["default"].ATTR_TYPE_FLOAT32,
          num: weightEle.num
        });
        var gfxVFmt = new _gfx["default"].VertexFormat(formatOpts);
        var vb = new _gfx["default"].VertexBuffer(Renderer.device, gfxVFmt, _gfx["default"].USAGE_STATIC, new Float32Array(vbData));
        var ibData = new Uint16Array(indices);
        var ib = new _gfx["default"].IndexBuffer(Renderer.device, _gfx["default"].INDEX_FMT_UINT16, _gfx["default"].USAGE_STATIC, ibData, ibData.length);
        var m = _materialVariant["default"].createWithBuiltin("unlit");
        m.setProperty("diffuseColor", RED_COLOR);
        return {
          material: m,
          ia: new _inputAssembler["default"](vb, ib, _gfx["default"].PT_LINES)
        };
      },
      wireFrame: function wireFrame(comp, ia, subData) {
        var oldIbData = subData.getIData(Uint16Array);
        var m = _materialVariant["default"].createWithBuiltin("unlit");
        m.setProperty("diffuseColor", BLACK_COLOR);
        var indices = [];
        for (var i = 0; i < oldIbData.length; i += 3) {
          var a = oldIbData[i + 0];
          var b = oldIbData[i + 1];
          var c = oldIbData[i + 2];
          indices.push(a, b, b, c, c, a);
        }
        var ibData = new Uint16Array(indices);
        var ib = new _gfx["default"].IndexBuffer(Renderer.device, _gfx["default"].INDEX_FMT_UINT16, _gfx["default"].USAGE_STATIC, ibData, ibData.length);
        return {
          material: m,
          ia: new _inputAssembler["default"](ia._vertexBuffer, ib, _gfx["default"].PT_LINES)
        };
      }
    };
    var _proto = MeshRenderer.prototype;
    _proto._updateDebugDatas = function() {
      var debugDatas = this._debugDatas;
      var subMeshes = this._mesh.subMeshes;
      var subDatas = this._mesh._subDatas;
      for (var name in debugDatas) {
        var debugData = debugDatas[name];
        if (debugData.length === subMeshes.length) continue;
        if (!cc.macro["SHOW_MESH_" + name.toUpperCase()]) continue;
        debugData.length = subMeshes.length;
        for (var i = 0; i < subMeshes.length; i++) debugData[i] = createDebugDataFns[name](this, subMeshes[i], subDatas[i], i);
      }
    };
    cc.MeshRenderer = module.exports = MeshRenderer;
  }), {
    "../../renderer/core/input-assembler": 241,
    "../../renderer/gfx": 251,
    "../assets/material/CCMaterial": 77,
    "../assets/material/material-variant": 84,
    "../components/CCRenderComponent": 100,
    "../geom-utils/aabb": 125,
    "../renderer": 168,
    "../renderer/render-flow": 169,
    "../value-types/mat4": 226,
    "../value-types/vec3": 234,
    "./CCMesh": 132
  } ],
  134: [ (function(require, module, exports) {
    "use strict";
    require("./CCMesh");
    true;
    require("./CCMeshRenderer");
    require("./mesh-renderer");
  }), {
    "./CCMesh": 132,
    "./CCMeshRenderer": 133,
    "./mesh-renderer": 136
  } ],
  135: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports.MeshData = MeshData;
    exports.Primitive = exports.VertexBundle = exports.VertexFormat = exports.BufferRange = void 0;
    var _gfx = _interopRequireDefault(require("../../renderer/gfx"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var BufferRange = cc.Class({
      name: "cc.BufferRange",
      properties: {
        offset: 0,
        length: 0
      }
    });
    exports.BufferRange = BufferRange;
    var VertexFormat = cc.Class({
      name: "cc.mesh.VertexFormat",
      properties: {
        name: "",
        type: -1,
        num: -1,
        normalize: false
      }
    });
    exports.VertexFormat = VertexFormat;
    var VertexBundle = cc.Class({
      name: "cc.mesh.VertexBundle",
      properties: {
        data: {
          default: null,
          type: BufferRange
        },
        formats: {
          default: [],
          type: VertexFormat
        },
        verticesCount: 0
      }
    });
    exports.VertexBundle = VertexBundle;
    var Primitive = cc.Class({
      name: "cc.mesh.Primitive",
      properties: {
        vertexBundleIndices: {
          default: [],
          type: cc.Float
        },
        data: {
          default: null,
          type: BufferRange
        },
        indexUnit: _gfx["default"].INDEX_FMT_UINT16,
        topology: _gfx["default"].PT_TRIANGLES
      }
    });
    exports.Primitive = Primitive;
    function MeshData() {
      this.vData = null;
      this.float32VData = null;
      this.uint32VData = null;
      this.iData = null;
      this.uint16IData = null;
      this.vfm = null;
      this.offset = 0;
      this.vb = null;
      this.ib = null;
      this.vDirty = false;
      this.iDirty = false;
      this.enable = true;
    }
    MeshData.prototype.setVData = function(data) {
      this.vData = data;
      this.float32VData = null;
      this.uint32VData = null;
    };
    MeshData.prototype.getVData = function(format) {
      if (format === Float32Array) {
        this.float32VData || (this.float32VData = new Float32Array(this.vData.buffer, this.vData.byteOffset, this.vData.byteLength / 4));
        return this.float32VData;
      }
      if (format === Uint32Array) {
        this.uint32VData || (this.uint32VData = new Uint32Array(this.vData.buffer, this.vData.byteOffset, this.vData.byteLength / 4));
        return this.uint32VData;
      }
      return this.vData;
    };
    MeshData.prototype.getIData = function(format) {
      if (format === Uint16Array) {
        this.uint16IData || (this.uint16IData = new Uint16Array(this.iData.buffer, this.iData.byteOffset, this.iData.byteLength / 2));
        return this.uint16IData;
      }
      return this.iData;
    };
  }), {
    "../../renderer/gfx": 251
  } ],
  136: [ (function(require, module, exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _assembler = _interopRequireDefault(require("../renderer/assembler"));
    var _gfx = _interopRequireDefault(require("../../renderer/gfx"));
    var _vec = _interopRequireDefault(require("../value-types/vec3"));
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      subClass.__proto__ = superClass;
    }
    var MeshRenderer = require("./CCMeshRenderer");
    var _tmp_vec3 = new _vec["default"]();
    var MeshRendererAssembler = (function(_Assembler) {
      _inheritsLoose(MeshRendererAssembler, _Assembler);
      function MeshRendererAssembler() {
        return _Assembler.apply(this, arguments) || this;
      }
      var _proto = MeshRendererAssembler.prototype;
      _proto.init = function init(renderComp) {
        _Assembler.prototype.init.call(this, renderComp);
        this._worldDatas = {};
        this._renderNode = null;
      };
      _proto.setRenderNode = function setRenderNode(node) {
        this._renderNode = node;
      };
      _proto.fillBuffers = function fillBuffers(comp, renderer) {
        if (!comp.mesh) return;
        comp.mesh._uploadData();
        var isCullingMaskSame = renderer.cullingMask === comp.node._cullingMask;
        var enableAutoBatch = comp.enableAutoBatch;
        var materials = comp._materials;
        var submeshes = comp.mesh._subMeshes;
        var subDatas = comp.mesh.subDatas;
        for (var i = 0; i < submeshes.length; i++) {
          var ia = submeshes[i];
          var meshData = subDatas[i];
          var material = materials[i] || materials[0];
          if (!enableAutoBatch || !meshData.canBatch || ia._primitiveType !== _gfx["default"].PT_TRIANGLES) {
            renderer._flush();
            renderer.material = material;
            renderer.cullingMask = comp.node._cullingMask;
            renderer.node = this._renderNode;
            renderer._flushIA(ia);
            continue;
          }
          isCullingMaskSame && material.getHash() === renderer.material.getHash() || renderer._flush();
          renderer.material = material;
          renderer.cullingMask = comp.node._cullingMask;
          renderer.node = renderer._dummyNode;
          this._fillBuffer(comp, meshData, renderer, i);
        }
        if ((true, cc.macro.SHOW_MESH_WIREFRAME || cc.macro.SHOW_MESH_NORMAL) && !(comp.node._cullingMask & 1 << cc.Node.BuiltinGroupIndex.DEBUG)) {
          renderer._flush();
          renderer.node = this._renderNode;
          comp._updateDebugDatas();
          cc.macro.SHOW_MESH_WIREFRAME && this._drawDebugDatas(comp, renderer, "wireFrame");
          cc.macro.SHOW_MESH_NORMAL && this._drawDebugDatas(comp, renderer, "normal");
        }
      };
      _proto._fillBuffer = function _fillBuffer(comp, meshData, renderer, dataIndex) {
        var vData = meshData.getVData(Float32Array);
        var vtxFormat = meshData.vfm;
        var vertexCount = vData.byteLength / vtxFormat._bytes | 0;
        var indices = meshData.getIData(Uint16Array);
        var indicesCount = indices.length;
        var buffer = renderer.getBuffer("mesh", vtxFormat);
        var offsetInfo = buffer.request(vertexCount, indicesCount);
        var indiceOffset = offsetInfo.indiceOffset, vertexOffset = offsetInfo.byteOffset >> 2, vertexId = offsetInfo.vertexOffset, vbuf = buffer._vData, ibuf = buffer._iData;
        !renderer.worldMatDirty && this._worldDatas[dataIndex] || this._updateWorldVertices(dataIndex, vertexCount, vData, vtxFormat, comp.node._worldMatrix);
        vbuf.set(this._worldDatas[dataIndex], vertexOffset);
        for (var i = 0; i < indicesCount; i++) ibuf[indiceOffset + i] = vertexId + indices[i];
      };
      _proto._updateWorldVertices = function _updateWorldVertices(dataIndex, vertexCount, local, vtxFormat, wolrdMatrix) {
        var world = this._worldDatas[dataIndex];
        if (!world) {
          world = this._worldDatas[dataIndex] = new Float32Array(local.length);
          world.set(local);
        }
        var floatCount = vtxFormat._bytes / 4;
        var elements = vtxFormat._elements;
        for (var i = 0, n = elements.length; i < n; i++) {
          var element = elements[i];
          var attrOffset = element.offset / 4;
          if (element.name === _gfx["default"].ATTR_POSITION || element.name === _gfx["default"].ATTR_NORMAL) {
            var transformMat4 = element.name === _gfx["default"].ATTR_NORMAL ? _vec["default"].transformMat4Normal : _vec["default"].transformMat4;
            for (var j = 0; j < vertexCount; j++) {
              var offset = j * floatCount + attrOffset;
              _tmp_vec3.x = local[offset];
              _tmp_vec3.y = local[offset + 1];
              _tmp_vec3.z = local[offset + 2];
              transformMat4(_tmp_vec3, _tmp_vec3, wolrdMatrix);
              world[offset] = _tmp_vec3.x;
              world[offset + 1] = _tmp_vec3.y;
              world[offset + 2] = _tmp_vec3.z;
            }
          }
        }
      };
      _proto._drawDebugDatas = function _drawDebugDatas(comp, renderer, name) {
        var debugDatas = comp._debugDatas[name];
        if (!debugDatas) return;
        for (var i = 0; i < debugDatas.length; i++) {
          var debugData = debugDatas[i];
          if (!debugData) continue;
          var material = debugData.material;
          renderer.material = material;
          renderer._flushIA(debugData.ia);
        }
      };
      return MeshRendererAssembler;
    })(_assembler["default"]);
    exports["default"] = MeshRendererAssembler;
    _assembler["default"].register(MeshRenderer, MeshRendererAssembler);
    module.exports = exports["default"];
  }), {
    "../../renderer/gfx": 251,
    "../renderer/assembler": 165,
    "../value-types/vec3": 234,
    "./CCMeshRenderer": 133
  } ],
  137: [ (function(require, module, exports) {
    "use strict";
    var CompScheduler = require("./component-scheduler");
    var Flags = require("./platform/CCObject").Flags;
    var js = require("./platform/js");
    var callerFunctor = false;
    var MAX_POOL_SIZE = 4;
    var IsPreloadStarted = Flags.IsPreloadStarted;
    var IsOnLoadStarted = Flags.IsOnLoadStarted;
    var IsOnLoadCalled = Flags.IsOnLoadCalled;
    var Deactivating = Flags.Deactivating;
    var callPreloadInTryCatch = false;
    var callOnLoadInTryCatch = false;
    var callOnDestroyInTryCatch = false;
    var callOnFocusInTryCatch = false;
    var callOnLostFocusInTryCatch = false;
    var UnsortedInvoker = cc.Class({
      extends: CompScheduler.LifeCycleInvoker,
      add: function add(comp) {
        this._zero.array.push(comp);
      },
      remove: function remove(comp) {
        this._zero.fastRemove(comp);
      },
      cancelInactive: function cancelInactive(flagToClear) {
        CompScheduler.LifeCycleInvoker.stableRemoveInactive(this._zero, flagToClear);
      },
      invoke: function invoke() {
        this._invoke(this._zero);
        this._zero.array.length = 0;
      }
    });
    var invokePreload = CompScheduler.createInvokeImpl((function(c) {
      c.__preload();
    }), false, void 0, (function(iterator) {
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) array[iterator.i].__preload();
    }));
    var invokeOnLoad = CompScheduler.createInvokeImpl((function(c) {
      c.onLoad();
      c._objFlags |= IsOnLoadCalled;
    }), false, IsOnLoadCalled, (function(iterator) {
      var array = iterator.array;
      for (iterator.i = 0; iterator.i < array.length; ++iterator.i) {
        var comp = array[iterator.i];
        comp.onLoad();
        comp._objFlags |= IsOnLoadCalled;
      }
    }));
    var activateTasksPool = new js.Pool(MAX_POOL_SIZE);
    activateTasksPool.get = function getActivateTask() {
      var task = this._get() || {
        preload: new UnsortedInvoker(invokePreload),
        onLoad: new CompScheduler.OneOffInvoker(invokeOnLoad),
        onEnable: new CompScheduler.OneOffInvoker(CompScheduler.invokeOnEnable)
      };
      task.preload._zero.i = -1;
      var invoker = task.onLoad;
      invoker._zero.i = -1;
      invoker._neg.i = -1;
      invoker._pos.i = -1;
      invoker = task.onEnable;
      invoker._zero.i = -1;
      invoker._neg.i = -1;
      invoker._pos.i = -1;
      return task;
    };
    function _componentCorrupted(node, comp, index) {
      false;
      comp ? node._removeComponent(comp) : js.array.removeAt(node._components, index);
    }
    function _onLoadInEditor(comp) {
      if (comp.onLoad && !cc.engine._isPlaying) {
        var focused = Editor.Selection.curActivate("node") === comp.node.uuid;
        focused ? comp.onFocusInEditor && callOnFocusInTryCatch(comp) : comp.onLostFocusInEditor && callOnLostFocusInTryCatch(comp);
      }
      true;
      _Scene.AssetsWatcher.start(comp);
    }
    function ctor() {
      this._activatingStack = [];
    }
    var NodeActivator = cc.Class({
      ctor: ctor,
      reset: ctor,
      _activateNodeRecursively: function _activateNodeRecursively(node, preloadInvoker, onLoadInvoker, onEnableInvoker) {
        if (node._objFlags & Deactivating) {
          cc.errorID(3816, node.name);
          return;
        }
        node._activeInHierarchy = true;
        var originCount = node._components.length;
        for (var i = 0; i < originCount; ++i) {
          var component = node._components[i];
          if (component instanceof cc.Component) this.activateComp(component, preloadInvoker, onLoadInvoker, onEnableInvoker); else {
            _componentCorrupted(node, component, i);
            --i;
            --originCount;
          }
        }
        node._childArrivalOrder = node._children.length;
        for (var _i = 0, len = node._children.length; _i < len; ++_i) {
          var child = node._children[_i];
          child._localZOrder = 4294901760 & child._localZOrder | _i + 1;
          child._active && this._activateNodeRecursively(child, preloadInvoker, onLoadInvoker, onEnableInvoker);
        }
        node._onPostActivated(true);
      },
      _deactivateNodeRecursively: function _deactivateNodeRecursively(node) {
        false;
        node._objFlags |= Deactivating;
        node._activeInHierarchy = false;
        var originCount = node._components.length;
        for (var c = 0; c < originCount; ++c) {
          var component = node._components[c];
          if (component._enabled) {
            cc.director._compScheduler.disableComp(component);
            if (node._activeInHierarchy) {
              node._objFlags &= ~Deactivating;
              return;
            }
          }
        }
        for (var i = 0, len = node._children.length; i < len; ++i) {
          var child = node._children[i];
          if (child._activeInHierarchy) {
            this._deactivateNodeRecursively(child);
            if (node._activeInHierarchy) {
              node._objFlags &= ~Deactivating;
              return;
            }
          }
        }
        node._onPostActivated(false);
        node._objFlags &= ~Deactivating;
      },
      activateNode: function activateNode(node, active) {
        if (active) {
          var task = activateTasksPool.get();
          this._activatingStack.push(task);
          this._activateNodeRecursively(node, task.preload, task.onLoad, task.onEnable);
          task.preload.invoke();
          task.onLoad.invoke();
          task.onEnable.invoke();
          this._activatingStack.pop();
          activateTasksPool.put(task);
        } else {
          this._deactivateNodeRecursively(node);
          var stack = this._activatingStack;
          for (var i = 0; i < stack.length; i++) {
            var lastTask = stack[i];
            lastTask.preload.cancelInactive(IsPreloadStarted);
            lastTask.onLoad.cancelInactive(IsOnLoadStarted);
            lastTask.onEnable.cancelInactive();
          }
        }
        node.emit("active-in-hierarchy-changed", node);
      },
      activateComp: function(comp, preloadInvoker, onLoadInvoker, onEnableInvoker) {
        if (!cc.isValid(comp, true)) return;
        if (!(comp._objFlags & IsPreloadStarted)) {
          comp._objFlags |= IsPreloadStarted;
          comp.__preload && (preloadInvoker ? preloadInvoker.add(comp) : comp.__preload());
        }
        if (!(comp._objFlags & IsOnLoadStarted)) {
          comp._objFlags |= IsOnLoadStarted;
          if (comp.onLoad) if (onLoadInvoker) onLoadInvoker.add(comp); else {
            comp.onLoad();
            comp._objFlags |= IsOnLoadCalled;
          } else comp._objFlags |= IsOnLoadCalled;
        }
        if (comp._enabled) {
          var deactivatedOnLoading = !comp.node._activeInHierarchy;
          if (deactivatedOnLoading) return;
          cc.director._compScheduler.enableComp(comp, onEnableInvoker);
        }
      },
      destroyComp: function(comp) {
        cc.director._compScheduler.disableComp(comp);
        comp.onDestroy && comp._objFlags & IsOnLoadCalled && comp.onDestroy();
      },
      resetComp: false
    });
    module.exports = NodeActivator;
  }), {
    "./component-scheduler": 88,
    "./platform/CCObject": 144,
    "./platform/js": 158,
    "./utils/misc": 209
  } ],
  138: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    var Enum = require("./CCEnum");
    var utils = require("./utils");
    var _isPlainEmptyObj_DEV = utils.isPlainEmptyObj_DEV;
    var _cloneable_DEV = utils.cloneable_DEV;
    var Attr = require("./attribute");
    var DELIMETER = Attr.DELIMETER;
    var preprocess = require("./preprocess-class");
    require("./requiring-frame");
    var BUILTIN_ENTRIES = [ "name", "extends", "mixins", "ctor", "__ctor__", "properties", "statics", "editor", "__ES6__" ];
    var INVALID_STATICS_DEV = false;
    function pushUnique(array, item) {
      array.indexOf(item) < 0 && array.push(item);
    }
    var deferredInitializer = {
      datas: null,
      push: function push(data) {
        if (this.datas) this.datas.push(data); else {
          this.datas = [ data ];
          var self = this;
          setTimeout((function() {
            self.init();
          }), 0);
        }
      },
      init: function init() {
        var datas = this.datas;
        if (datas) {
          for (var i = 0; i < datas.length; ++i) {
            var data = datas[i];
            var cls = data.cls;
            var properties = data.props;
            "function" === typeof properties && (properties = properties());
            var name = js.getClassName(cls);
            properties ? declareProperties(cls, name, properties, cls.$super, data.mixins) : cc.errorID(3633, name);
          }
          this.datas = null;
        }
      }
    };
    function appendProp(cls, name) {
      false;
      pushUnique(cls.__props__, name);
    }
    function defineProp(cls, className, propName, val, es6) {
      var defaultValue = val["default"];
      false;
      Attr.setClassAttr(cls, propName, "default", defaultValue);
      appendProp(cls, propName);
      parseAttributes(cls, val, className, propName, false);
      var i;
      false, false;
    }
    function defineGetSet(cls, name, propName, val, es6) {
      var getter = val.get;
      var setter = val.set;
      var proto = cls.prototype;
      var d = Object.getOwnPropertyDescriptor(proto, propName);
      var setterUndefined = !d;
      if (getter) {
        false;
        parseAttributes(cls, val, name, propName, true);
        false, false;
        Attr.setClassAttr(cls, propName, "serializable", false);
        false;
        es6 || js.get(proto, propName, getter, setterUndefined, setterUndefined);
        false, false;
      }
      if (setter) {
        if (!es6) {
          false;
          js.set(proto, propName, setter, setterUndefined, setterUndefined);
        }
        false, false;
      }
    }
    function getDefault(defaultVal) {
      if ("function" === typeof defaultVal) {
        false;
        return defaultVal();
      }
      return defaultVal;
    }
    function mixinWithInherited(dest, src, filter) {
      for (var prop in src) dest.hasOwnProperty(prop) || filter && !filter(prop) || Object.defineProperty(dest, prop, js.getPropertyDescriptor(src, prop));
    }
    function doDefine(className, baseClass, mixins, options) {
      var shouldAddProtoCtor;
      var __ctor__ = options.__ctor__;
      var ctor = options.ctor;
      var __es6__ = options.__ES6__;
      var ctorToUse;
      false;
      var ctors;
      var fireClass;
      if (__es6__) {
        ctors = [ ctor ];
        fireClass = ctor;
      } else {
        ctors = __ctor__ ? [ __ctor__ ] : _getAllCtors(baseClass, mixins, options);
        fireClass = _createCtor(ctors, baseClass, className, options);
        js.value(fireClass, "extend", (function(options) {
          options["extends"] = this;
          return CCClass(options);
        }), true);
      }
      js.value(fireClass, "__ctors__", ctors.length > 0 ? ctors : null, true);
      var prototype = fireClass.prototype;
      if (baseClass) {
        if (!__es6__) {
          js.extend(fireClass, baseClass);
          prototype = fireClass.prototype;
        }
        fireClass.$super = baseClass;
        false;
      }
      if (mixins) {
        for (var m = mixins.length - 1; m >= 0; m--) {
          var mixin = mixins[m];
          mixinWithInherited(prototype, mixin.prototype);
          mixinWithInherited(fireClass, mixin, (function(prop) {
            return mixin.hasOwnProperty(prop) && true;
          }));
          CCClass._isCCClass(mixin) && mixinWithInherited(Attr.getClassAttrs(fireClass), Attr.getClassAttrs(mixin));
        }
        prototype.constructor = fireClass;
      }
      __es6__ || (prototype.__initProps__ = compileProps);
      js.setClassName(className, fireClass);
      return fireClass;
    }
    function define(className, baseClass, mixins, options) {
      var Component = cc.Component;
      var frame = cc._RF.peek();
      if (frame && js.isChildClassOf(baseClass, Component)) {
        if (js.isChildClassOf(frame.cls, Component)) {
          cc.errorID(3615);
          return null;
        }
        false;
        className = className || frame.script;
      }
      var cls = doDefine(className, baseClass, mixins, options);
      if (frame) if (js.isChildClassOf(baseClass, Component)) {
        var uuid = frame.uuid;
        if (uuid) {
          js._setClassId(uuid, cls);
          false;
        }
        frame.cls = cls;
      } else js.isChildClassOf(frame.cls, Component) || (frame.cls = cls);
      return cls;
    }
    function normalizeClassName_DEV(className) {
      var DefaultName = "CCClass";
      if (className) {
        className = className.replace(/^[^$A-Za-z_]/, "_").replace(/[^0-9A-Za-z_$]/g, "_");
        try {
          Function("function " + className + "(){}")();
          return className;
        } catch (e) {}
      }
      return DefaultName;
    }
    function getNewValueTypeCodeJit(value) {
      var clsName = js.getClassName(value);
      var type = value.constructor;
      var res = "new " + clsName + "(";
      for (var i = 0; i < type.__props__.length; i++) {
        var prop = type.__props__[i];
        var propVal = value[prop];
        false;
        res += propVal;
        i < type.__props__.length - 1 && (res += ",");
      }
      return res + ")";
    }
    function escapeForJS(s) {
      return JSON.stringify(s).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029");
    }
    function getInitPropsJit(attrs, propList) {
      var F = [];
      var func = "";
      for (var i = 0; i < propList.length; i++) {
        var prop = propList[i];
        var attrKey = prop + DELIMETER + "default";
        if (attrKey in attrs) {
          var statement;
          statement = IDENTIFIER_RE.test(prop) ? "this." + prop + "=" : "this[" + escapeForJS(prop) + "]=";
          var expression;
          var def = attrs[attrKey];
          if ("object" === typeof def && def) expression = def instanceof cc.ValueType ? getNewValueTypeCodeJit(def) : Array.isArray(def) ? "[]" : "{}"; else if ("function" === typeof def) {
            var index = F.length;
            F.push(def);
            expression = "F[" + index + "]()";
            false;
          } else expression = "string" === typeof def ? escapeForJS(def) : def;
          statement = statement + expression + ";\n";
          func += statement;
        }
      }
      var initProps;
      initProps = 0 === F.length ? Function(func) : Function("F", "return (function(){\n" + func + "})")(F);
      return initProps;
    }
    function getInitProps(attrs, propList) {
      var props = null;
      var simpleEnd = 0;
      var valueTypeEnd = 0;
      (function() {
        var simples = null;
        var valueTypes = null;
        var advanceds = null;
        for (var i = 0; i < propList.length; ++i) {
          var prop = propList[i];
          var attrKey = prop + DELIMETER + "default";
          if (attrKey in attrs) {
            var def = attrs[attrKey];
            if ("object" === typeof def && def || "function" === typeof def) if (def instanceof cc.ValueType) {
              valueTypes || (valueTypes = []);
              valueTypes.push(prop, def);
            } else {
              advanceds || (advanceds = []);
              advanceds.push(prop, def);
            } else {
              simples || (simples = []);
              simples.push(prop, def);
            }
          }
        }
        simpleEnd = simples ? simples.length : 0;
        valueTypeEnd = simpleEnd + (valueTypes ? valueTypes.length : 0);
        var totalLength = valueTypeEnd + (advanceds ? advanceds.length : 0);
        props = new Array(totalLength);
        for (var _i = 0; _i < simpleEnd; ++_i) props[_i] = simples[_i];
        for (var _i2 = simpleEnd; _i2 < valueTypeEnd; ++_i2) props[_i2] = valueTypes[_i2 - simpleEnd];
        for (var _i3 = valueTypeEnd; _i3 < totalLength; ++_i3) props[_i3] = advanceds[_i3 - valueTypeEnd];
      })();
      return function() {
        var i = 0;
        for (;i < simpleEnd; i += 2) this[props[i]] = props[i + 1];
        for (;i < valueTypeEnd; i += 2) this[props[i]] = props[i + 1].clone();
        for (;i < props.length; i += 2) {
          var def = props[i + 1];
          if (Array.isArray(def)) this[props[i]] = []; else {
            var value;
            if ("object" === typeof def) value = {}; else {
              false;
              value = def();
            }
            this[props[i]] = value;
          }
        }
      };
    }
    var IDENTIFIER_RE = /^[A-Za-z_$][0-9A-Za-z_$]*$/;
    function compileProps(actualClass) {
      var attrs = Attr.getClassAttrs(actualClass);
      var propList = actualClass.__props__;
      if (null === propList) {
        deferredInitializer.init();
        propList = actualClass.__props__;
      }
      var initProps = getInitProps(attrs, propList);
      actualClass.prototype.__initProps__ = initProps;
      initProps.call(this);
    }
    var _createCtor = function(ctors, baseClass, className, options) {
      var superCallBounded = baseClass && boundSuperCalls(baseClass, options, className);
      var ctorLen = ctors.length;
      var _Class5;
      _Class5 = ctorLen > 0 ? superCallBounded ? 2 === ctorLen ? function Class() {
        this._super = null;
        this.__initProps__(_Class5);
        ctors[0].apply(this, arguments);
        ctors[1].apply(this, arguments);
      } : function _Class() {
        this._super = null;
        this.__initProps__(_Class5);
        for (var i = 0; i < ctors.length; ++i) ctors[i].apply(this, arguments);
      } : 3 === ctorLen ? function _Class2() {
        this.__initProps__(_Class5);
        ctors[0].apply(this, arguments);
        ctors[1].apply(this, arguments);
        ctors[2].apply(this, arguments);
      } : function _Class3() {
        this.__initProps__(_Class5);
        var ctors = _Class5.__ctors__;
        for (var i = 0; i < ctors.length; ++i) ctors[i].apply(this, arguments);
      } : function _Class4() {
        superCallBounded && (this._super = null);
        this.__initProps__(_Class5);
      };
      return _Class5;
    };
    function _validateCtor_DEV(ctor, baseClass, className, options) {
      var originCtor;
      false;
      !(ctor.length > 0) || className && className.startsWith("cc.") || cc.warnID(3617, className);
      return ctor;
    }
    function _getAllCtors(baseClass, mixins, options) {
      function getCtors(cls) {
        return CCClass._isCCClass(cls) ? cls.__ctors__ || [] : [ cls ];
      }
      var ctors = [];
      var baseOrMixins = [ baseClass ].concat(mixins);
      for (var b = 0; b < baseOrMixins.length; b++) {
        var baseOrMixin = baseOrMixins[b];
        if (baseOrMixin) {
          var baseCtors = getCtors(baseOrMixin);
          for (var c = 0; c < baseCtors.length; c++) pushUnique(ctors, baseCtors[c]);
        }
      }
      var ctor = options.ctor;
      ctor && ctors.push(ctor);
      return ctors;
    }
    var SuperCallReg = /xyz/.test((function() {
      xyz;
    })) ? /\b\._super\b/ : /.*/;
    var SuperCallRegStrict = /xyz/.test((function() {
      xyz;
    })) ? /this\._super\s*\(/ : /(NONE){99}/;
    function boundSuperCalls(baseClass, options, className) {
      var hasSuperCall = false;
      for (var funcName in options) {
        if (BUILTIN_ENTRIES.indexOf(funcName) >= 0) continue;
        var func = options[funcName];
        if ("function" !== typeof func) continue;
        var pd = js.getPropertyDescriptor(baseClass.prototype, funcName);
        if (pd) {
          var superFunc = pd.value;
          if ("function" === typeof superFunc) {
            if (SuperCallReg.test(func)) {
              hasSuperCall = true;
              options[funcName] = (function(superFunc, func) {
                return function() {
                  var tmp = this._super;
                  this._super = superFunc;
                  var ret = func.apply(this, arguments);
                  this._super = tmp;
                  return ret;
                };
              })(superFunc, func);
            }
            continue;
          }
        }
        false;
      }
      return hasSuperCall;
    }
    function declareProperties(cls, className, properties, baseClass, mixins, es6) {
      cls.__props__ = [];
      baseClass && baseClass.__props__ && (cls.__props__ = baseClass.__props__.slice());
      if (mixins) for (var m = 0; m < mixins.length; ++m) {
        var mixin = mixins[m];
        mixin.__props__ && (cls.__props__ = cls.__props__.concat(mixin.__props__.filter((function(x) {
          return cls.__props__.indexOf(x) < 0;
        }))));
      }
      if (properties) {
        preprocess.preprocessAttrs(properties, className, cls, es6);
        for (var propName in properties) {
          var val = properties[propName];
          "default" in val ? defineProp(cls, className, propName, val, es6) : defineGetSet(cls, className, propName, val, es6);
        }
      }
      var attrs = Attr.getClassAttrs(cls);
      cls.__values__ = cls.__props__.filter((function(prop) {
        return false !== attrs[prop + DELIMETER + "serializable"];
      }));
    }
    function CCClass(options) {
      options = options || {};
      var name = options.name;
      var base = options["extends"];
      var mixins = options.mixins;
      var cls = define(name, base, mixins, options);
      name || (name = cc.js.getClassName(cls));
      cls._sealed = true;
      base && (base._sealed = false);
      var properties = options.properties;
      if ("function" === typeof properties || base && null === base.__props__ || mixins && mixins.some((function(x) {
        return null === x.__props__;
      }))) {
        false;
        deferredInitializer.push({
          cls: cls,
          props: properties,
          mixins: mixins
        });
        cls.__props__ = cls.__values__ = null;
      } else declareProperties(cls, name, properties, base, options.mixins, options.__ES6__);
      var statics = options.statics;
      if (statics) {
        var staticPropName;
        false;
        for (staticPropName in statics) cls[staticPropName] = statics[staticPropName];
      }
      for (var funcName in options) {
        if (BUILTIN_ENTRIES.indexOf(funcName) >= 0) continue;
        var func = options[funcName];
        if (!preprocess.validateMethodWithProps(func, funcName, name, cls, base)) continue;
        js.value(cls.prototype, funcName, func, true, true);
      }
      var editor = options.editor;
      editor && !!js.isChildClassOf(base, cc.Component) && cc.Component._registerEditorProps(cls, editor);
      return cls;
    }
    CCClass._isCCClass = function(constructor) {
      return constructor && constructor.hasOwnProperty("__ctors__");
    };
    CCClass._fastDefine = function(className, constructor, serializableFields) {
      js.setClassName(className, constructor);
      var props = constructor.__props__ = constructor.__values__ = Object.keys(serializableFields);
      var attrs = Attr.getClassAttrs(constructor);
      for (var i = 0; i < props.length; i++) {
        var key = props[i];
        attrs[key + DELIMETER + "visible"] = false;
        attrs[key + DELIMETER + "default"] = serializableFields[key];
      }
    };
    CCClass.Attr = Attr;
    CCClass.attr = Attr.attr;
    CCClass.getInheritanceChain = function(klass) {
      var chain = [];
      for (;;) {
        klass = js.getSuper(klass);
        if (!klass) break;
        klass !== Object && chain.push(klass);
      }
      return chain;
    };
    var PrimitiveTypes = {
      Integer: "Number",
      Float: "Number",
      Boolean: "Boolean",
      String: "String"
    };
    var onAfterProps_ET = [];
    function parseAttributes(cls, attributes, className, propName, usedInGetter) {
      var ERR_Type = "";
      var attrs = null;
      var propNamePrefix = "";
      function initAttrs() {
        propNamePrefix = propName + DELIMETER;
        return attrs = Attr.getClassAttrs(cls);
      }
      false, false;
      var type = attributes.type;
      if (type) {
        var primitiveType = PrimitiveTypes[type];
        if (primitiveType) {
          (attrs || initAttrs())[propNamePrefix + "type"] = type;
          (false, false) && !attributes._short && onAfterProps_ET.push(Attr.getTypeChecker_ET(primitiveType, "cc." + type));
        } else if ("Object" === type) false; else if (type === Attr.ScriptUuid) {
          (attrs || initAttrs())[propNamePrefix + "type"] = "Script";
          attrs[propNamePrefix + "ctor"] = cc.ScriptAsset;
        } else if ("object" === typeof type) if (Enum.isEnum(type)) {
          (attrs || initAttrs())[propNamePrefix + "type"] = "Enum";
          attrs[propNamePrefix + "enumList"] = Enum.getList(type);
        } else false; else if ("function" === typeof type) {
          (attrs || initAttrs())[propNamePrefix + "type"] = "Object";
          attrs[propNamePrefix + "ctor"] = type;
          (false, false) && !attributes._short && onAfterProps_ET.push(Attr.getObjTypeChecker_ET(type));
        } else false;
      }
      function parseSimpleAttr(attrName, expectType) {
        if (attrName in attributes) {
          var val = attributes[attrName];
          typeof val === expectType && ((attrs || initAttrs())[propNamePrefix + attrName] = val);
        }
      }
      if (attributes.editorOnly) {
        false;
        (attrs || initAttrs())[propNamePrefix + "editorOnly"] = true;
      }
      false;
      if (false === attributes.serializable) {
        false;
        (attrs || initAttrs())[propNamePrefix + "serializable"] = false;
      }
      parseSimpleAttr("formerlySerializedAs", "string");
      false;
      var visible;
      var startsWithUS;
      false;
      var range = attributes.range;
      if (range) if (Array.isArray(range)) if (range.length >= 2) {
        (attrs || initAttrs())[propNamePrefix + "min"] = range[0];
        attrs[propNamePrefix + "max"] = range[1];
        range.length > 2 && (attrs[propNamePrefix + "step"] = range[2]);
      } else false; else false;
      parseSimpleAttr("min", "number");
      parseSimpleAttr("max", "number");
      parseSimpleAttr("step", "number");
    }
    cc.Class = CCClass;
    module.exports = {
      isArray: function isArray(defaultVal) {
        defaultVal = getDefault(defaultVal);
        return Array.isArray(defaultVal);
      },
      fastDefine: CCClass._fastDefine,
      getNewValueTypeCode: false,
      IDENTIFIER_RE: IDENTIFIER_RE,
      escapeForJS: escapeForJS,
      getDefault: getDefault
    };
    false;
  }), {
    "./CCEnum": 140,
    "./attribute": 150,
    "./js": 158,
    "./preprocess-class": 159,
    "./requiring-frame": 160,
    "./utils": 161
  } ],
  139: [ (function(require, module, exports) {
    "use strict";
    require("./CCClass");
    var Preprocess = require("./preprocess-class");
    var js = require("./js");
    var isPlainEmptyObj_DEV = false;
    var CACHE_KEY = "__ccclassCache__";
    function fNOP(ctor) {
      return ctor;
    }
    function getSubDict(obj, key) {
      return obj[key] || (obj[key] = {});
    }
    function checkCtorArgument(decorate) {
      return function(target) {
        if ("function" === typeof target) return decorate(target);
        return function(ctor) {
          return decorate(ctor, target);
        };
      };
    }
    function _checkNormalArgument(validator_DEV, decorate, decoratorName) {
      return function(target) {
        false;
        return function(ctor) {
          return decorate(ctor, target);
        };
      };
    }
    var checkCompArgument = _checkNormalArgument.bind(null, false);
    function _argumentChecker(type) {
      return _checkNormalArgument.bind(null, false);
    }
    var checkStringArgument = _argumentChecker("string");
    var checkNumberArgument = _argumentChecker("number");
    function getClassCache(ctor, decoratorName) {
      false;
      return getSubDict(ctor, CACHE_KEY);
    }
    function getDefaultFromInitializer(initializer) {
      var value;
      try {
        value = initializer();
      } catch (e) {
        return initializer;
      }
      return "object" !== typeof value || null === value ? value : initializer;
    }
    function extractActualDefaultValues(ctor) {
      var dummyObj;
      try {
        dummyObj = new ctor();
      } catch (e) {
        false;
        return {};
      }
      return dummyObj;
    }
    function genProperty(ctor, properties, propName, options, desc, cache) {
      var fullOptions;
      var isGetset = desc && (desc.get || desc.set);
      options && (fullOptions = Preprocess.getFullFormOfProperty(options, isGetset));
      var existsProperty = properties[propName];
      var prop = js.mixin(existsProperty || {}, fullOptions || options || {});
      if (isGetset) {
        var errorProps;
        false;
        desc.get && (prop.get = desc.get);
        desc.set && (prop.set = desc.set);
      } else {
        false;
        var defaultValue = void 0;
        var isDefaultValueSpecified = false;
        if (desc) {
          if (desc.initializer) {
            defaultValue = getDefaultFromInitializer(desc.initializer);
            isDefaultValueSpecified = true;
          }
        } else {
          var actualDefaultValues = cache["default"] || (cache["default"] = extractActualDefaultValues(ctor));
          if (actualDefaultValues.hasOwnProperty(propName)) {
            defaultValue = actualDefaultValues[propName];
            isDefaultValueSpecified = true;
          }
        }
        false, false;
        prop["default"] = defaultValue;
      }
      properties[propName] = prop;
    }
    var ccclass = checkCtorArgument((function(ctor, name) {
      var base = js.getSuper(ctor);
      base === Object && (base = null);
      var proto = {
        name: name,
        extends: base,
        ctor: ctor,
        __ES6__: true
      };
      var cache = ctor[CACHE_KEY];
      if (cache) {
        var decoratedProto = cache.proto;
        decoratedProto && js.mixin(proto, decoratedProto);
        ctor[CACHE_KEY] = void 0;
      }
      var res = cc.Class(proto);
      var propNames;
      var i;
      var prop;
      var desc;
      var func;
      false;
      return res;
    }));
    function property(ctorProtoOrOptions, propName, desc) {
      var options = null;
      function normalized(ctorProto, propName, desc) {
        var cache = getClassCache(ctorProto.constructor);
        if (cache) {
          var ccclassProto = getSubDict(cache, "proto");
          var properties = getSubDict(ccclassProto, "properties");
          genProperty(ctorProto.constructor, properties, propName, options, desc, cache);
        }
      }
      if ("undefined" === typeof propName) {
        options = ctorProtoOrOptions;
        return normalized;
      }
      normalized(ctorProtoOrOptions, propName, desc);
    }
    function createEditorDecorator(argCheckFunc, editorPropName, staticValue) {
      return argCheckFunc((function(ctor, decoratedValue) {
        var cache = getClassCache(ctor, editorPropName);
        if (cache) {
          var value = void 0 !== staticValue ? staticValue : decoratedValue;
          var proto = getSubDict(cache, "proto");
          getSubDict(proto, "editor")[editorPropName] = value;
        }
      }), editorPropName);
    }
    function createDummyDecorator(argCheckFunc) {
      return argCheckFunc(fNOP);
    }
    var executeInEditMode = createDummyDecorator(checkCtorArgument, "executeInEditMode", true);
    var requireComponent = createEditorDecorator(checkCompArgument, "requireComponent");
    var menu = createDummyDecorator(checkStringArgument, "menu");
    var executionOrder = createEditorDecorator(checkNumberArgument, "executionOrder");
    var disallowMultiple = createDummyDecorator(checkCtorArgument, "disallowMultiple");
    var playOnFocus = createDummyDecorator(checkCtorArgument, "playOnFocus", true);
    var inspector = createDummyDecorator(checkStringArgument, "inspector");
    var icon = createDummyDecorator(checkStringArgument, "icon");
    var help = createDummyDecorator(checkStringArgument, "help");
    function mixins() {
      var mixins = [];
      for (var i = 0; i < arguments.length; i++) mixins[i] = arguments[i];
      return function(ctor) {
        var cache = getClassCache(ctor, "mixins");
        cache && (getSubDict(cache, "proto").mixins = mixins);
      };
    }
    cc._decorator = module.exports = {
      ccclass: ccclass,
      property: property,
      executeInEditMode: executeInEditMode,
      requireComponent: requireComponent,
      menu: menu,
      executionOrder: executionOrder,
      disallowMultiple: disallowMultiple,
      playOnFocus: playOnFocus,
      inspector: inspector,
      icon: icon,
      help: help,
      mixins: mixins
    };
  }), {
    "./CCClass": 138,
    "./js": 158,
    "./preprocess-class": 159,
    "./utils": 161
  } ],
  140: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    function Enum(obj) {
      if ("__enums__" in obj) return obj;
      js.value(obj, "__enums__", null, true);
      var lastIndex = -1;
      var keys = Object.keys(obj);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var val = obj[key];
        if (-1 === val) {
          val = ++lastIndex;
          obj[key] = val;
        } else if ("number" === typeof val) lastIndex = val; else if ("string" === typeof val && Number.isInteger(parseFloat(key))) continue;
        var reverseKey = "" + val;
        if (key !== reverseKey) {
          if ((false, false) && reverseKey in obj && obj[reverseKey] !== key) {
            cc.errorID(7100, reverseKey);
            continue;
          }
          js.value(obj, reverseKey, key);
        }
      }
      return obj;
    }
    Enum.isEnum = function(enumType) {
      return enumType && enumType.hasOwnProperty("__enums__");
    };
    Enum.getList = function(enumDef) {
      if (enumDef.__enums__) return enumDef.__enums__;
      var enums = enumDef.__enums__ = [];
      for (var name in enumDef) {
        var value = enumDef[name];
        Number.isInteger(value) && enums.push({
          name: name,
          value: value
        });
      }
      enums.sort((function(a, b) {
        return a.value - b.value;
      }));
      return enums;
    };
    var _TestEnum;
    false;
    module.exports = cc.Enum = Enum;
  }), {
    "./js": 158
  } ],
  141: [ (function(require, module, exports) {
    "use strict";
    var eventManager = require("../event-manager");
    var inputManager = require("./CCInputManager");
    var PORTRAIT = 0;
    var LANDSCAPE_LEFT = -90;
    var PORTRAIT_UPSIDE_DOWN = 180;
    var LANDSCAPE_RIGHT = 90;
    var _didAccelerateFun;
    cc.Acceleration = function(x, y, z, timestamp) {
      this.x = x || 0;
      this.y = y || 0;
      this.z = z || 0;
      this.timestamp = timestamp || 0;
    };
    inputManager.setAccelerometerEnabled = function(isEnable) {
      var _t = this;
      if (_t._accelEnabled === isEnable) return;
      _t._accelEnabled = isEnable;
      var scheduler = cc.director.getScheduler();
      scheduler.enableForTarget(_t);
      if (_t._accelEnabled) {
        _t._registerAccelerometerEvent();
        _t._accelCurTime = 0;
        scheduler.scheduleUpdate(_t);
      } else {
        _t._unregisterAccelerometerEvent();
        _t._accelCurTime = 0;
        scheduler.unscheduleUpdate(_t);
      }
      false, false;
    };
    inputManager.setAccelerometerInterval = function(interval) {
      if (this._accelInterval !== interval) {
        this._accelInterval = interval;
        false, false;
      }
    };
    inputManager._registerKeyboardEvent = function() {
      cc.game.canvas.addEventListener("keydown", (function(e) {
        eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, true));
        e.stopPropagation();
        e.preventDefault();
      }), false);
      cc.game.canvas.addEventListener("keyup", (function(e) {
        eventManager.dispatchEvent(new cc.Event.EventKeyboard(e.keyCode, false));
        e.stopPropagation();
        e.preventDefault();
      }), false);
    };
    inputManager._registerAccelerometerEvent = function() {
      var w = window, _t = this;
      _t._acceleration = new cc.Acceleration();
      _t._accelDeviceEvent = w.DeviceMotionEvent || w.DeviceOrientationEvent;
      cc.sys.browserType === cc.sys.BROWSER_TYPE_MOBILE_QQ && (_t._accelDeviceEvent = window.DeviceOrientationEvent);
      var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";
      var ua = navigator.userAgent;
      (/Android/.test(ua) || /Adr/.test(ua) && cc.sys.browserType === cc.BROWSER_TYPE_UC) && (_t._minus = -1);
      _didAccelerateFun = _t.didAccelerate.bind(_t);
      w.addEventListener(_deviceEventType, _didAccelerateFun, false);
    };
    inputManager._unregisterAccelerometerEvent = function() {
      var w = window, _t = this;
      var _deviceEventType = _t._accelDeviceEvent === w.DeviceMotionEvent ? "devicemotion" : "deviceorientation";
      _didAccelerateFun && w.removeEventListener(_deviceEventType, _didAccelerateFun, false);
    };
    inputManager.didAccelerate = function(eventData) {
      var _t = this, w = window;
      if (!_t._accelEnabled) return;
      var mAcceleration = _t._acceleration;
      var x, y, z;
      if (_t._accelDeviceEvent === window.DeviceMotionEvent) {
        var eventAcceleration = eventData["accelerationIncludingGravity"];
        x = _t._accelMinus * eventAcceleration.x * .1;
        y = _t._accelMinus * eventAcceleration.y * .1;
        z = .1 * eventAcceleration.z;
      } else {
        x = eventData["gamma"] / 90 * .981;
        y = -eventData["beta"] / 90 * .981;
        z = eventData["alpha"] / 90 * .981;
      }
      if (cc.view._isRotated) {
        var tmp = x;
        x = -y;
        y = tmp;
      }
      mAcceleration.x = x;
      mAcceleration.y = y;
      mAcceleration.z = z;
      mAcceleration.timestamp = eventData.timeStamp || Date.now();
      var tmpX = mAcceleration.x;
      if (w.orientation === LANDSCAPE_RIGHT) {
        mAcceleration.x = -mAcceleration.y;
        mAcceleration.y = tmpX;
      } else if (w.orientation === LANDSCAPE_LEFT) {
        mAcceleration.x = mAcceleration.y;
        mAcceleration.y = -tmpX;
      } else if (w.orientation === PORTRAIT_UPSIDE_DOWN) {
        mAcceleration.x = -mAcceleration.x;
        mAcceleration.y = -mAcceleration.y;
      }
      if (cc.sys.os === cc.sys.OS_ANDROID && cc.sys.browserType !== cc.sys.BROWSER_TYPE_MOBILE_QQ) {
        mAcceleration.x = -mAcceleration.x;
        mAcceleration.y = -mAcceleration.y;
      }
    };
  }), {
    "../event-manager": 119,
    "./CCInputManager": 142
  } ],
  142: [ (function(require, module, exports) {
    "use strict";
    var macro = require("./CCMacro");
    var sys = require("./CCSys");
    var eventManager = require("../event-manager");
    var TOUCH_TIMEOUT = macro.TOUCH_TIMEOUT;
    var _vec2 = cc.v2();
    var inputManager = {
      _mousePressed: false,
      _isRegisterEvent: false,
      _preTouchPoint: cc.v2(0, 0),
      _prevMousePoint: cc.v2(0, 0),
      _preTouchPool: [],
      _preTouchPoolPointer: 0,
      _touches: [],
      _touchesIntegerDict: {},
      _indexBitsUsed: 0,
      _maxTouches: 8,
      _accelEnabled: false,
      _accelInterval: .2,
      _accelMinus: 1,
      _accelCurTime: 0,
      _acceleration: null,
      _accelDeviceEvent: null,
      _canvasBoundingRect: {
        left: 0,
        top: 0,
        adjustedLeft: 0,
        adjustedTop: 0,
        width: 0,
        height: 0
      },
      _getUnUsedIndex: function _getUnUsedIndex() {
        var temp = this._indexBitsUsed;
        var now = cc.sys.now();
        for (var i = 0; i < this._maxTouches; i++) {
          if (!(1 & temp)) {
            this._indexBitsUsed |= 1 << i;
            return i;
          }
          var touch = this._touches[i];
          if (now - touch._lastModified > TOUCH_TIMEOUT) {
            this._removeUsedIndexBit(i);
            delete this._touchesIntegerDict[touch.getID()];
            return i;
          }
          temp >>= 1;
        }
        return -1;
      },
      _removeUsedIndexBit: function _removeUsedIndexBit(index) {
        if (index < 0 || index >= this._maxTouches) return;
        var temp = 1 << index;
        temp = ~temp;
        this._indexBitsUsed &= temp;
      },
      _glView: null,
      _updateCanvasBoundingRect: function _updateCanvasBoundingRect() {
        var element = cc.game.canvas;
        var canvasBoundingRect = this._canvasBoundingRect;
        var docElem = document.documentElement;
        var leftOffset = window.pageXOffset - docElem.clientLeft;
        var topOffset = window.pageYOffset - docElem.clientTop;
        if (element.getBoundingClientRect) {
          var box = element.getBoundingClientRect();
          canvasBoundingRect.left = box.left + leftOffset;
          canvasBoundingRect.top = box.top + topOffset;
          canvasBoundingRect.width = box.width;
          canvasBoundingRect.height = box.height;
        } else if (element instanceof HTMLCanvasElement) {
          canvasBoundingRect.left = leftOffset;
          canvasBoundingRect.top = topOffset;
          canvasBoundingRect.width = element.width;
          canvasBoundingRect.height = element.height;
        } else {
          canvasBoundingRect.left = leftOffset;
          canvasBoundingRect.top = topOffset;
          canvasBoundingRect.width = parseInt(element.style.width);
          canvasBoundingRect.height = parseInt(element.style.height);
        }
      },
      handleTouchesBegin: function handleTouchesBegin(touches) {
        var selTouch, index, curTouch, touchID, handleTouches = [], locTouchIntDict = this._touchesIntegerDict, now = sys.now();
        for (var i = 0, len = touches.length; i < len; i++) {
          selTouch = touches[i];
          touchID = selTouch.getID();
          index = locTouchIntDict[touchID];
          if (null == index) {
            var unusedIndex = this._getUnUsedIndex();
            if (-1 === unusedIndex) {
              cc.logID(2300, unusedIndex);
              continue;
            }
            curTouch = this._touches[unusedIndex] = new cc.Touch(selTouch._point.x, selTouch._point.y, selTouch.getID());
            curTouch._lastModified = now;
            curTouch._setPrevPoint(selTouch._prevPoint);
            locTouchIntDict[touchID] = unusedIndex;
            handleTouches.push(curTouch);
          }
        }
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.BEGAN;
          eventManager.dispatchEvent(touchEvent);
        }
      },
      handleTouchesMove: function handleTouchesMove(touches) {
        var selTouch, index, touchID, handleTouches = [], locTouches = this._touches, now = sys.now();
        for (var i = 0, len = touches.length; i < len; i++) {
          selTouch = touches[i];
          touchID = selTouch.getID();
          index = this._touchesIntegerDict[touchID];
          if (null == index) continue;
          if (locTouches[index]) {
            locTouches[index]._setPoint(selTouch._point);
            locTouches[index]._setPrevPoint(selTouch._prevPoint);
            locTouches[index]._lastModified = now;
            handleTouches.push(locTouches[index]);
          }
        }
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.MOVED;
          eventManager.dispatchEvent(touchEvent);
        }
      },
      handleTouchesEnd: function handleTouchesEnd(touches) {
        var handleTouches = this.getSetOfTouchesEndOrCancel(touches);
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.ENDED;
          eventManager.dispatchEvent(touchEvent);
        }
        this._preTouchPool.length = 0;
      },
      handleTouchesCancel: function handleTouchesCancel(touches) {
        var handleTouches = this.getSetOfTouchesEndOrCancel(touches);
        if (handleTouches.length > 0) {
          this._glView._convertTouchesWithScale(handleTouches);
          var touchEvent = new cc.Event.EventTouch(handleTouches);
          touchEvent._eventCode = cc.Event.EventTouch.CANCELED;
          eventManager.dispatchEvent(touchEvent);
        }
        this._preTouchPool.length = 0;
      },
      getSetOfTouchesEndOrCancel: function getSetOfTouchesEndOrCancel(touches) {
        var selTouch, index, touchID, handleTouches = [], locTouches = this._touches, locTouchesIntDict = this._touchesIntegerDict;
        for (var i = 0, len = touches.length; i < len; i++) {
          selTouch = touches[i];
          touchID = selTouch.getID();
          index = locTouchesIntDict[touchID];
          if (null == index) continue;
          if (locTouches[index]) {
            locTouches[index]._setPoint(selTouch._point);
            locTouches[index]._setPrevPoint(selTouch._prevPoint);
            handleTouches.push(locTouches[index]);
            this._removeUsedIndexBit(index);
            delete locTouchesIntDict[touchID];
          }
        }
        return handleTouches;
      },
      getPreTouch: function getPreTouch(touch) {
        var preTouch = null;
        var locPreTouchPool = this._preTouchPool;
        var id = touch.getID();
        for (var i = locPreTouchPool.length - 1; i >= 0; i--) if (locPreTouchPool[i].getID() === id) {
          preTouch = locPreTouchPool[i];
          break;
        }
        preTouch || (preTouch = touch);
        return preTouch;
      },
      setPreTouch: function setPreTouch(touch) {
        var find = false;
        var locPreTouchPool = this._preTouchPool;
        var id = touch.getID();
        for (var i = locPreTouchPool.length - 1; i >= 0; i--) if (locPreTouchPool[i].getID() === id) {
          locPreTouchPool[i] = touch;
          find = true;
          break;
        }
        if (!find) if (locPreTouchPool.length <= 50) locPreTouchPool.push(touch); else {
          locPreTouchPool[this._preTouchPoolPointer] = touch;
          this._preTouchPoolPointer = (this._preTouchPoolPointer + 1) % 50;
        }
      },
      getTouchByXY: function getTouchByXY(tx, ty, pos) {
        var locPreTouch = this._preTouchPoint;
        var location = this._glView.convertToLocationInView(tx, ty, pos);
        var touch = new cc.Touch(location.x, location.y, 0);
        touch._setPrevPoint(locPreTouch.x, locPreTouch.y);
        locPreTouch.x = location.x;
        locPreTouch.y = location.y;
        return touch;
      },
      getMouseEvent: function getMouseEvent(location, pos, eventType) {
        var locPreMouse = this._prevMousePoint;
        var mouseEvent = new cc.Event.EventMouse(eventType);
        mouseEvent._setPrevCursor(locPreMouse.x, locPreMouse.y);
        locPreMouse.x = location.x;
        locPreMouse.y = location.y;
        this._glView._convertMouseToLocationInView(locPreMouse, pos);
        mouseEvent.setLocation(locPreMouse.x, locPreMouse.y);
        return mouseEvent;
      },
      getPointByEvent: function getPointByEvent(event, pos) {
        cc.sys.browserType !== cc.sys.BROWSER_TYPE_QQ && cc.sys.browserType !== cc.sys.BROWSER_TYPE_UC && cc.sys.browserType !== cc.sys.BROWSER_TYPE_SAFARI || this._updateCanvasBoundingRect();
        if (null != event.pageX) return {
          x: event.pageX,
          y: event.pageY
        };
        pos.left -= document.body.scrollLeft;
        pos.top -= document.body.scrollTop;
        return {
          x: event.clientX,
          y: event.clientY
        };
      },
      getTouchesByEvent: function getTouchesByEvent(event, pos) {
        var touchArr = [], locView = this._glView;
        var touch_event, touch, preLocation;
        var locPreTouch = this._preTouchPoint;
        var length = event.changedTouches.length;
        for (var i = 0; i < length; i++) {
          touch_event = event.changedTouches[i];
          if (touch_event) {
            var location = void 0;
            location = sys.BROWSER_TYPE_FIREFOX === sys.browserType ? locView.convertToLocationInView(touch_event.pageX, touch_event.pageY, pos, _vec2) : locView.convertToLocationInView(touch_event.clientX, touch_event.clientY, pos, _vec2);
            if (null != touch_event.identifier) {
              touch = new cc.Touch(location.x, location.y, touch_event.identifier);
              preLocation = this.getPreTouch(touch).getLocation();
              touch._setPrevPoint(preLocation.x, preLocation.y);
              this.setPreTouch(touch);
            } else {
              touch = new cc.Touch(location.x, location.y);
              touch._setPrevPoint(locPreTouch.x, locPreTouch.y);
            }
            locPreTouch.x = location.x;
            locPreTouch.y = location.y;
            touchArr.push(touch);
          }
        }
        return touchArr;
      },
      registerSystemEvent: function registerSystemEvent(element) {
        if (this._isRegisterEvent) return;
        this._glView = cc.view;
        var selfPointer = this;
        var canvasBoundingRect = this._canvasBoundingRect;
        window.addEventListener("resize", this._updateCanvasBoundingRect.bind(this));
        var prohibition = sys.isMobile;
        var supportMouse = "mouse" in sys.capabilities;
        var supportTouches = "touches" in sys.capabilities;
        if (supportMouse) {
          if (!prohibition) {
            window.addEventListener("mousedown", (function() {
              selfPointer._mousePressed = true;
            }), false);
            window.addEventListener("mouseup", (function(event) {
              if (!selfPointer._mousePressed) return;
              selfPointer._mousePressed = false;
              var location = selfPointer.getPointByEvent(event, canvasBoundingRect);
              if (!cc.rect(canvasBoundingRect.left, canvasBoundingRect.top, canvasBoundingRect.width, canvasBoundingRect.height).contains(location)) {
                selfPointer.handleTouchesEnd([ selfPointer.getTouchByXY(location.x, location.y, canvasBoundingRect) ]);
                var mouseEvent = selfPointer.getMouseEvent(location, canvasBoundingRect, cc.Event.EventMouse.UP);
                mouseEvent.setButton(event.button);
                eventManager.dispatchEvent(mouseEvent);
              }
            }), false);
          }
          var EventMouse = cc.Event.EventMouse;
          var _mouseEventsOnElement = [ !prohibition && [ "mousedown", EventMouse.DOWN, function(event, mouseEvent, location, canvasBoundingRect) {
            selfPointer._mousePressed = true;
            selfPointer.handleTouchesBegin([ selfPointer.getTouchByXY(location.x, location.y, canvasBoundingRect) ]);
            element.focus();
          } ], !prohibition && [ "mouseup", EventMouse.UP, function(event, mouseEvent, location, canvasBoundingRect) {
            selfPointer._mousePressed = false;
            selfPointer.handleTouchesEnd([ selfPointer.getTouchByXY(location.x, location.y, canvasBoundingRect) ]);
          } ], !prohibition && [ "mousemove", EventMouse.MOVE, function(event, mouseEvent, location, canvasBoundingRect) {
            selfPointer.handleTouchesMove([ selfPointer.getTouchByXY(location.x, location.y, canvasBoundingRect) ]);
            selfPointer._mousePressed || mouseEvent.setButton(null);
          } ], [ "mousewheel", EventMouse.SCROLL, function(event, mouseEvent) {
            mouseEvent.setScrollData(0, event.wheelDelta);
          } ], [ "DOMMouseScroll", EventMouse.SCROLL, function(event, mouseEvent) {
            mouseEvent.setScrollData(0, -120 * event.detail);
          } ] ];
          for (var i = 0; i < _mouseEventsOnElement.length; ++i) {
            var entry = _mouseEventsOnElement[i];
            entry && (function() {
              var name = entry[0];
              var type = entry[1];
              var handler = entry[2];
              element.addEventListener(name, (function(event) {
                var location = selfPointer.getPointByEvent(event, canvasBoundingRect);
                var mouseEvent = selfPointer.getMouseEvent(location, canvasBoundingRect, type);
                mouseEvent.setButton(event.button);
                handler(event, mouseEvent, location, canvasBoundingRect);
                eventManager.dispatchEvent(mouseEvent);
                event.stopPropagation();
                event.preventDefault();
              }), false);
            })();
          }
        }
        if (window.navigator.msPointerEnabled) {
          var _pointerEventsMap = {
            MSPointerDown: selfPointer.handleTouchesBegin,
            MSPointerMove: selfPointer.handleTouchesMove,
            MSPointerUp: selfPointer.handleTouchesEnd,
            MSPointerCancel: selfPointer.handleTouchesCancel
          };
          var _loop = function _loop(eventName) {
            var touchEvent = _pointerEventsMap[eventName];
            element.addEventListener(eventName, (function(event) {
              var documentElement = document.documentElement;
              canvasBoundingRect.adjustedLeft = canvasBoundingRect.left - documentElement.scrollLeft;
              canvasBoundingRect.adjustedTop = canvasBoundingRect.top - documentElement.scrollTop;
              touchEvent.call(selfPointer, [ selfPointer.getTouchByXY(event.clientX, event.clientY, canvasBoundingRect) ]);
              event.stopPropagation();
            }), false);
          };
          for (var eventName in _pointerEventsMap) _loop(eventName);
        }
        if (supportTouches) {
          var _touchEventsMap = {
            touchstart: function touchstart(touchesToHandle) {
              selfPointer.handleTouchesBegin(touchesToHandle);
              element.focus();
            },
            touchmove: function touchmove(touchesToHandle) {
              selfPointer.handleTouchesMove(touchesToHandle);
            },
            touchend: function touchend(touchesToHandle) {
              selfPointer.handleTouchesEnd(touchesToHandle);
            },
            touchcancel: function touchcancel(touchesToHandle) {
              selfPointer.handleTouchesCancel(touchesToHandle);
            }
          };
          var registerTouchEvent = function registerTouchEvent(eventName) {
            var handler = _touchEventsMap[eventName];
            element.addEventListener(eventName, (function(event) {
              if (!event.changedTouches) return;
              var body = document.body;
              canvasBoundingRect.adjustedLeft = canvasBoundingRect.left - (body.scrollLeft || window.scrollX || 0);
              canvasBoundingRect.adjustedTop = canvasBoundingRect.top - (body.scrollTop || window.scrollY || 0);
              handler(selfPointer.getTouchesByEvent(event, canvasBoundingRect));
              event.stopPropagation();
              event.preventDefault();
            }), false);
          };
          for (var _eventName in _touchEventsMap) registerTouchEvent(_eventName);
        }
        this._registerKeyboardEvent();
        this._isRegisterEvent = true;
      },
      _registerKeyboardEvent: function _registerKeyboardEvent() {},
      _registerAccelerometerEvent: function _registerAccelerometerEvent() {},
      update: function update(dt) {
        if (this._accelCurTime > this._accelInterval) {
          this._accelCurTime -= this._accelInterval;
          eventManager.dispatchEvent(new cc.Event.EventAcceleration(this._acceleration));
        }
        this._accelCurTime += dt;
      }
    };
    module.exports = cc.internal.inputManager = inputManager;
  }), {
    "../event-manager": 119,
    "./CCMacro": 143,
    "./CCSys": 147
  } ],
  143: [ (function(require, module, exports) {
    "use strict";
    cc.macro = {
      RAD: Math.PI / 180,
      DEG: 180 / Math.PI,
      REPEAT_FOREVER: Number.MAX_VALUE - 1,
      FLT_EPSILON: 1.192092896e-7,
      MIN_ZINDEX: -Math.pow(2, 15),
      MAX_ZINDEX: Math.pow(2, 15) - 1,
      ONE: 1,
      ZERO: 0,
      SRC_ALPHA: 770,
      SRC_ALPHA_SATURATE: 776,
      SRC_COLOR: 768,
      DST_ALPHA: 772,
      DST_COLOR: 774,
      ONE_MINUS_SRC_ALPHA: 771,
      ONE_MINUS_SRC_COLOR: 769,
      ONE_MINUS_DST_ALPHA: 773,
      ONE_MINUS_DST_COLOR: 775,
      ONE_MINUS_CONSTANT_ALPHA: 32772,
      ONE_MINUS_CONSTANT_COLOR: 32770,
      ORIENTATION_PORTRAIT: 1,
      ORIENTATION_LANDSCAPE: 2,
      ORIENTATION_AUTO: 3,
      DENSITYDPI_DEVICE: "device-dpi",
      DENSITYDPI_HIGH: "high-dpi",
      DENSITYDPI_MEDIUM: "medium-dpi",
      DENSITYDPI_LOW: "low-dpi",
      FIX_ARTIFACTS_BY_STRECHING_TEXEL_TMX: true,
      DIRECTOR_STATS_POSITION: cc.v2(0, 0),
      ENABLE_STACKABLE_ACTIONS: true,
      TOUCH_TIMEOUT: 5e3,
      BATCH_VERTEX_COUNT: 2e4,
      ENABLE_TILEDMAP_CULLING: true,
      ENABLE_TRANSPARENT_CANVAS: false,
      ENABLE_WEBGL_ANTIALIAS: false,
      ENABLE_CULLING: false,
      CLEANUP_IMAGE_CACHE: false,
      SHOW_MESH_WIREFRAME: false,
      SHOW_MESH_NORMAL: false,
      ENABLE_MULTI_TOUCH: true,
      ALLOW_IMAGE_BITMAP: true
    };
    Object.defineProperty(cc.macro, "ROTATE_ACTION_CCW", {
      set: function set(value) {
        cc.RotateTo && cc.RotateBy && (cc.RotateTo._reverse = cc.RotateBy._reverse = value);
      }
    });
    var SUPPORT_TEXTURE_FORMATS = [ ".pkm", ".pvr", ".webp", ".jpg", ".jpeg", ".bmp", ".png" ];
    cc.macro.SUPPORT_TEXTURE_FORMATS = SUPPORT_TEXTURE_FORMATS;
    cc.macro.KEY = {
      none: 0,
      back: 6,
      menu: 18,
      backspace: 8,
      tab: 9,
      enter: 13,
      shift: 16,
      ctrl: 17,
      alt: 18,
      pause: 19,
      capslock: 20,
      escape: 27,
      space: 32,
      pageup: 33,
      pagedown: 34,
      end: 35,
      home: 36,
      left: 37,
      up: 38,
      right: 39,
      down: 40,
      select: 41,
      insert: 45,
      Delete: 46,
      0: 48,
      1: 49,
      2: 50,
      3: 51,
      4: 52,
      5: 53,
      6: 54,
      7: 55,
      8: 56,
      9: 57,
      a: 65,
      b: 66,
      c: 67,
      d: 68,
      e: 69,
      f: 70,
      g: 71,
      h: 72,
      i: 73,
      j: 74,
      k: 75,
      l: 76,
      m: 77,
      n: 78,
      o: 79,
      p: 80,
      q: 81,
      r: 82,
      s: 83,
      t: 84,
      u: 85,
      v: 86,
      w: 87,
      x: 88,
      y: 89,
      z: 90,
      num0: 96,
      num1: 97,
      num2: 98,
      num3: 99,
      num4: 100,
      num5: 101,
      num6: 102,
      num7: 103,
      num8: 104,
      num9: 105,
      "*": 106,
      "+": 107,
      "-": 109,
      numdel: 110,
      "/": 111,
      f1: 112,
      f2: 113,
      f3: 114,
      f4: 115,
      f5: 116,
      f6: 117,
      f7: 118,
      f8: 119,
      f9: 120,
      f10: 121,
      f11: 122,
      f12: 123,
      numlock: 144,
      scrolllock: 145,
      ";": 186,
      semicolon: 186,
      equal: 187,
      "=": 187,
      ",": 188,
      comma: 188,
      dash: 189,
      ".": 190,
      period: 190,
      forwardslash: 191,
      grave: 192,
      "[": 219,
      openbracket: 219,
      backslash: 220,
      "]": 221,
      closebracket: 221,
      quote: 222,
      dpadLeft: 1e3,
      dpadRight: 1001,
      dpadUp: 1003,
      dpadDown: 1004,
      dpadCenter: 1005
    };
    cc.macro.ImageFormat = cc.Enum({
      JPG: 0,
      PNG: 1,
      TIFF: 2,
      WEBP: 3,
      PVR: 4,
      ETC: 5,
      S3TC: 6,
      ATITC: 7,
      TGA: 8,
      RAWDATA: 9,
      UNKNOWN: 10
    });
    cc.macro.BlendFactor = cc.Enum({
      ONE: 1,
      ZERO: 0,
      SRC_ALPHA: 770,
      SRC_COLOR: 768,
      DST_ALPHA: 772,
      DST_COLOR: 774,
      ONE_MINUS_SRC_ALPHA: 771,
      ONE_MINUS_SRC_COLOR: 769,
      ONE_MINUS_DST_ALPHA: 773,
      ONE_MINUS_DST_COLOR: 775
    });
    cc.macro.TextAlignment = cc.Enum({
      LEFT: 0,
      CENTER: 1,
      RIGHT: 2
    });
    cc.macro.VerticalTextAlignment = cc.Enum({
      TOP: 0,
      CENTER: 1,
      BOTTOM: 2
    });
    module.exports = cc.macro;
  }), {} ],
  144: [ (function(require, module, exports) {
    "use strict";
    var js = require("./js");
    var CCClass = require("./CCClass");
    var Destroyed = 1;
    var RealDestroyed = 2;
    var ToDestroy = 4;
    var DontSave = 8;
    var EditorOnly = 16;
    var Dirty = 32;
    var DontDestroy = 64;
    var Destroying = 128;
    var Deactivating = 256;
    var LockedInEditor = 512;
    var HideInHierarchy = 1024;
    var IsOnEnableCalled = 2048;
    var IsEditorOnEnableCalled = 4096;
    var IsPreloadStarted = 8192;
    var IsOnLoadCalled = 16384;
    var IsOnLoadStarted = 32768;
    var IsStartCalled = 65536;
    var IsRotationLocked = 1 << 17;
    var IsScaleLocked = 1 << 18;
    var IsAnchorLocked = 1 << 19;
    var IsSizeLocked = 1 << 20;
    var IsPositionLocked = 1 << 21;
    var PersistentMask = ~(ToDestroy | Dirty | Destroying | DontDestroy | Deactivating | IsPreloadStarted | IsOnLoadStarted | IsOnLoadCalled | IsStartCalled | IsOnEnableCalled | IsEditorOnEnableCalled | IsRotationLocked | IsScaleLocked | IsAnchorLocked | IsSizeLocked | IsPositionLocked);
    function CCObject() {
      this._name = "";
      this._objFlags = 0;
    }
    CCClass.fastDefine("cc.Object", CCObject, {
      _name: "",
      _objFlags: 0
    });
    js.value(CCObject, "Flags", {
      Destroyed: Destroyed,
      DontSave: DontSave,
      EditorOnly: EditorOnly,
      Dirty: Dirty,
      DontDestroy: DontDestroy,
      PersistentMask: PersistentMask,
      Destroying: Destroying,
      Deactivating: Deactivating,
      LockedInEditor: LockedInEditor,
      HideInHierarchy: HideInHierarchy,
      IsPreloadStarted: IsPreloadStarted,
      IsOnLoadStarted: IsOnLoadStarted,
      IsOnLoadCalled: IsOnLoadCalled,
      IsOnEnableCalled: IsOnEnableCalled,
      IsStartCalled: IsStartCalled,
      IsEditorOnEnableCalled: IsEditorOnEnableCalled,
      IsPositionLocked: IsPositionLocked,
      IsRotationLocked: IsRotationLocked,
      IsScaleLocked: IsScaleLocked,
      IsAnchorLocked: IsAnchorLocked,
      IsSizeLocked: IsSizeLocked
    });
    var objectsToDestroy = [];
    function deferredDestroy() {
      var deleteCount = objectsToDestroy.length;
      for (var i = 0; i < deleteCount; ++i) {
        var obj = objectsToDestroy[i];
        obj._objFlags & Destroyed || obj._destroyImmediate();
      }
      deleteCount === objectsToDestroy.length ? objectsToDestroy.length = 0 : objectsToDestroy.splice(0, deleteCount);
      false;
    }
    js.value(CCObject, "_deferredDestroy", deferredDestroy);
    false;
    var prototype = CCObject.prototype;
    js.getset(prototype, "name", (function() {
      return this._name;
    }), (function(value) {
      this._name = value;
    }), true);
    js.get(prototype, "isValid", (function() {
      return !(this._objFlags & Destroyed);
    }), true);
    false, false;
    var deferredDestroyTimer = null;
    prototype.destroy = function() {
      if (this._objFlags & Destroyed) {
        cc.warnID(5e3);
        return false;
      }
      if (this._objFlags & ToDestroy) return false;
      this._objFlags |= ToDestroy;
      objectsToDestroy.push(this);
      false;
      return true;
    };
    false, false;
    function compileDestruct(obj, ctor) {
      var shouldSkipId = obj instanceof cc._BaseNode || obj instanceof cc.Component;
      var idToSkip = shouldSkipId ? "_id" : null;
      var key, propsToReset = {};
      for (key in obj) if (obj.hasOwnProperty(key)) {
        if (key === idToSkip) continue;
        switch (typeof obj[key]) {
         case "string":
          propsToReset[key] = "";
          break;

         case "object":
         case "function":
          propsToReset[key] = null;
        }
      }
      if (cc.Class._isCCClass(ctor)) {
        var attrs = cc.Class.Attr.getClassAttrs(ctor);
        var propList = ctor.__props__;
        for (var i = 0; i < propList.length; i++) {
          key = propList[i];
          var attrKey = key + cc.Class.Attr.DELIMETER + "default";
          if (attrKey in attrs) {
            if (shouldSkipId && "_id" === key) continue;
            switch (typeof attrs[attrKey]) {
             case "string":
              propsToReset[key] = "";
              break;

             case "object":
             case "function":
              propsToReset[key] = null;
              break;

             case "undefined":
              propsToReset[key] = void 0;
            }
          }
        }
      }
      var func;
      var statement;
      var val;
      false;
      return function(o) {
        for (var key in propsToReset) o[key] = propsToReset[key];
      };
    }
    prototype._destruct = function() {
      var ctor = this.constructor;
      var destruct = ctor.__destruct__;
      if (!destruct) {
        destruct = compileDestruct(this, ctor);
        js.value(ctor, "__destruct__", destruct, true);
      }
      destruct(this);
    };
    prototype._onPreDestroy = null;
    prototype._destroyImmediate = function() {
      if (this._objFlags & Destroyed) {
        cc.errorID(5e3);
        return;
      }
      this._onPreDestroy && this._onPreDestroy();
      true;
      this._destruct();
      this._objFlags |= Destroyed;
    };
    false;
    prototype._deserialize = null;
    cc.isValid = function(value, strictMode) {
      return "object" === typeof value ? !!value && !(value._objFlags & (strictMode ? Destroyed | ToDestroy : Destroyed)) : "undefined" !== typeof value;
    };
    false, false;
    cc.Object = module.exports = CCObject;
  }), {
    "./CCClass": 138,
    "./js": 158
  } ],
  145: [ (function(require, module, exports) {
    "use strict";
    var js = require("../platform/js");
    cc.SAXParser = function() {
      if (true, window.DOMParser) {
        this._isSupportDOMParser = true;
        this._parser = new DOMParser();
      } else {
        this._isSupportDOMParser = false;
        this._parser = null;
      }
    };
    cc.SAXParser.prototype = {
      constructor: cc.SAXParser,
      parse: function parse(xmlTxt) {
        return this._parseXML(xmlTxt);
      },
      _parseXML: function _parseXML(textxml) {
        var xmlDoc;
        if (this._isSupportDOMParser) xmlDoc = this._parser.parseFromString(textxml, "text/xml"); else {
          xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
          xmlDoc.async = "false";
          xmlDoc.loadXML(textxml);
        }
        return xmlDoc;
      }
    };
    cc.PlistParser = function() {
      cc.SAXParser.call(this);
    };
    js.extend(cc.PlistParser, cc.SAXParser);
    js.mixin(cc.PlistParser.prototype, {
      parse: function parse(xmlTxt) {
        var xmlDoc = this._parseXML(xmlTxt);
        var plist = xmlDoc.documentElement;
        if ("plist" !== plist.tagName) {
          cc.warnID(5100);
          return {};
        }
        var node = null;
        for (var i = 0, len = plist.childNodes.length; i < len; i++) {
          node = plist.childNodes[i];
          if (1 === node.nodeType) break;
        }
        xmlDoc = null;
        return this._parseNode(node);
      },
      _parseNode: function _parseNode(node) {
        var data = null, tagName = node.tagName;
        if ("dict" === tagName) data = this._parseDict(node); else if ("array" === tagName) data = this._parseArray(node); else if ("string" === tagName) if (1 === node.childNodes.length) data = node.firstChild.nodeValue; else {
          data = "";
          for (var i = 0; i < node.childNodes.length; i++) data += node.childNodes[i].nodeValue;
        } else "false" === tagName ? data = false : "true" === tagName ? data = true : "real" === tagName ? data = parseFloat(node.firstChild.nodeValue) : "integer" === tagName && (data = parseInt(node.firstChild.nodeValue, 10));
        return data;
      },
      _parseArray: function _parseArray(node) {
        var data = [];
        for (var i = 0, len = node.childNodes.length; i < len; i++) {
          var child = node.childNodes[i];
          if (1 !== child.nodeType) continue;
          data.push(this._parseNode(child));
        }
        return data;
      },
      _parseDict: function _parseDict(node) {
        var data = {};
        var key = null;
        for (var i = 0, len = node.childNodes.length; i < len; i++) {
          var child = node.childNodes[i];
          if (1 !== child.nodeType) continue;
          "key" === child.tagName ? key = child.firstChild.nodeValue : data[key] = this._parseNode(child);
        }
        return data;
      }
    });
    cc.saxParser = new cc.SAXParser();
    cc.plistParser = new cc.PlistParser();
    module.exports = {
      saxParser: cc.saxParser,
      plistParser: cc.plistParser
    };
  }), {
    "../platform/js": 158
  } ],
  146: [ (function(require, module, exports) {
    "use strict";
    cc.screen = {
      _supportsFullScreen: false,
      _onfullscreenchange: null,
      _onfullscreenerror: null,
      _preOnFullScreenChange: null,
      _preOnFullScreenError: null,
      _preOnTouch: null,
      _touchEvent: "",
      _fn: null,
      _fnMap: [ [ "requestFullscreen", "exitFullscreen", "fullscreenchange", "fullscreenEnabled", "fullscreenElement", "fullscreenerror" ], [ "requestFullScreen", "exitFullScreen", "fullScreenchange", "fullScreenEnabled", "fullScreenElement", "fullscreenerror" ], [ "webkitRequestFullScreen", "webkitCancelFullScreen", "webkitfullscreenchange", "webkitIsFullScreen", "webkitCurrentFullScreenElement", "webkitfullscreenerror" ], [ "mozRequestFullScreen", "mozCancelFullScreen", "mozfullscreenchange", "mozFullScreen", "mozFullScreenElement", "mozfullscreenerror" ], [ "msRequestFullscreen", "msExitFullscreen", "MSFullscreenChange", "msFullscreenEnabled", "msFullscreenElement", "msfullscreenerror" ] ],
      init: function init() {
        this._fn = {};
        var i, l, val, map = this._fnMap, valL;
        for (i = 0, l = map.length; i < l; i++) {
          val = map[i];
          if (val && "undefined" !== typeof document[val[1]]) {
            for (i = 0, valL = val.length; i < valL; i++) this._fn[map[0][i]] = val[i];
            break;
          }
        }
        this._supportsFullScreen = void 0 !== this._fn.requestFullscreen;
        this._touchEvent = "ontouchend" in window ? "touchend" : "mousedown";
      },
      fullScreen: function fullScreen() {
        return !!this._supportsFullScreen && !!(document[this._fn.fullscreenElement] || document[this._fn.webkitFullscreenElement] || document[this._fn.mozFullScreenElement]);
      },
      requestFullScreen: function requestFullScreen(element, onFullScreenChange, onFullScreenError) {
        if (element && "video" === element.tagName.toLowerCase()) {
          if (cc.sys.os === cc.sys.OS_IOS && cc.sys.isBrowser && element.readyState > 0) {
            element.webkitEnterFullscreen && element.webkitEnterFullscreen();
            return;
          }
          element.setAttribute("x5-video-player-fullscreen", "true");
        }
        if (!this._supportsFullScreen) return;
        element = element || document.documentElement;
        if (onFullScreenChange) {
          var eventName = this._fn.fullscreenchange;
          this._onfullscreenchange && document.removeEventListener(eventName, this._onfullscreenchange);
          this._onfullscreenchange = onFullScreenChange;
          document.addEventListener(eventName, onFullScreenChange, false);
        }
        if (onFullScreenError) {
          var _eventName = this._fn.fullscreenerror;
          this._onfullscreenerror && document.removeEventListener(_eventName, this._onfullscreenerror);
          this._onfullscreenerror = onFullScreenError;
          document.addEventListener(_eventName, onFullScreenError, {
            once: true
          });
        }
        var requestPromise = element[this._fn.requestFullscreen]();
        "undefined" === typeof document[this._fn.fullscreenerror] && window.Promise && requestPromise instanceof Promise && requestPromise["catch"]((function(err) {}));
      },
      exitFullScreen: function exitFullScreen(element) {
        if (element && "video" === element.tagName.toLowerCase()) {
          if (cc.sys.os === cc.sys.OS_IOS && cc.sys.isBrowser) {
            element.webkitExitFullscreen && element.webkitExitFullscreen();
            return;
          }
          element.setAttribute("x5-video-player-fullscreen", "false");
        }
        return !this._supportsFullScreen || document[this._fn.exitFullscreen]();
      },
      autoFullScreen: function autoFullScreen(element, onFullScreenChange) {
        element = element || document.body;
        this._ensureFullScreen(element, onFullScreenChange);
        this.requestFullScreen(element, onFullScreenChange);
      },
      disableAutoFullScreen: function disableAutoFullScreen(element) {
        var touchTarget = cc.game.canvas || element;
        var touchEventName = this._touchEvent;
        if (this._preOnTouch) {
          touchTarget.removeEventListener(touchEventName, this._preOnTouch);
          this._preOnTouch = null;
        }
      },
      _ensureFullScreen: function _ensureFullScreen(element, onFullScreenChange) {
        var self = this;
        var touchTarget = cc.game.canvas || element;
        var fullScreenErrorEventName = this._fn.fullscreenerror;
        if ("undefined" === typeof document[fullScreenErrorEventName]) return;
        var touchEventName = this._touchEvent;
        function onFullScreenError() {
          self._preOnFullScreenError = null;
          function onTouch() {
            self._preOnTouch = null;
            self.requestFullScreen(element, onFullScreenChange);
          }
          self._preOnTouch && touchTarget.removeEventListener(touchEventName, self._preOnTouch);
          self._preOnTouch = onTouch;
          touchTarget.addEventListener(touchEventName, self._preOnTouch, {
            once: true
          });
        }
        this._preOnFullScreenError && element.removeEventListener(fullScreenErrorEventName, this._preOnFullScreenError);
        this._preOnFullScreenError = onFullScreenError;
        element.addEventListener(fullScreenErrorEventName, onFullScreenError, {
          once: true
        });
      }
    };
    cc.screen.init();
  }), {} ],
  147: [ (function(require, module, exports) {
    "use strict";
    var settingPlatform;
    true;
    settingPlatform = window._CCSettings ? _CCSettings.platform : void 0;
    var isVivoGame = "qgame" === settingPlatform;
    var isOppoGame = "quickgame" === settingPlatform;
    var isHuaweiGame = "huawei" === settingPlatform;
    var isJKWGame = "jkw-game" === settingPlatform;
    var isQttGame = "qtt-game" === settingPlatform;
    var _global = "undefined" === typeof window ? global : window;
    function initSys() {
      cc.sys = {};
      var sys = cc.sys;
      sys.LANGUAGE_ENGLISH = "en";
      sys.LANGUAGE_CHINESE = "zh";
      sys.LANGUAGE_FRENCH = "fr";
      sys.LANGUAGE_ITALIAN = "it";
      sys.LANGUAGE_GERMAN = "de";
      sys.LANGUAGE_SPANISH = "es";
      sys.LANGUAGE_DUTCH = "du";
      sys.LANGUAGE_RUSSIAN = "ru";
      sys.LANGUAGE_KOREAN = "ko";
      sys.LANGUAGE_JAPANESE = "ja";
      sys.LANGUAGE_HUNGARIAN = "hu";
      sys.LANGUAGE_PORTUGUESE = "pt";
      sys.LANGUAGE_ARABIC = "ar";
      sys.LANGUAGE_NORWEGIAN = "no";
      sys.LANGUAGE_POLISH = "pl";
      sys.LANGUAGE_TURKISH = "tr";
      sys.LANGUAGE_UKRAINIAN = "uk";
      sys.LANGUAGE_ROMANIAN = "ro";
      sys.LANGUAGE_BULGARIAN = "bg";
      sys.LANGUAGE_UNKNOWN = "unknown";
      sys.OS_IOS = "iOS";
      sys.OS_ANDROID = "Android";
      sys.OS_WINDOWS = "Windows";
      sys.OS_MARMALADE = "Marmalade";
      sys.OS_LINUX = "Linux";
      sys.OS_BADA = "Bada";
      sys.OS_BLACKBERRY = "Blackberry";
      sys.OS_OSX = "OS X";
      sys.OS_WP8 = "WP8";
      sys.OS_WINRT = "WINRT";
      sys.OS_UNKNOWN = "Unknown";
      sys.UNKNOWN = -1;
      sys.WIN32 = 0;
      sys.LINUX = 1;
      sys.MACOS = 2;
      sys.ANDROID = 3;
      sys.IPHONE = 4;
      sys.IPAD = 5;
      sys.BLACKBERRY = 6;
      sys.NACL = 7;
      sys.EMSCRIPTEN = 8;
      sys.TIZEN = 9;
      sys.WINRT = 10;
      sys.WP8 = 11;
      sys.MOBILE_BROWSER = 100;
      sys.DESKTOP_BROWSER = 101;
      sys.EDITOR_PAGE = 102;
      sys.EDITOR_CORE = 103;
      sys.WECHAT_GAME = 104;
      sys.QQ_PLAY = 105;
      sys.FB_PLAYABLE_ADS = 106;
      sys.BAIDU_GAME = 107;
      sys.VIVO_GAME = 108;
      sys.OPPO_GAME = 109;
      sys.HUAWEI_GAME = 110;
      sys.XIAOMI_GAME = 111;
      sys.JKW_GAME = 112;
      sys.ALIPAY_GAME = 113;
      sys.WECHAT_GAME_SUB = 114;
      sys.BAIDU_GAME_SUB = 115;
      sys.QTT_GAME = 116;
      sys.BROWSER_TYPE_WECHAT = "wechat";
      sys.BROWSER_TYPE_WECHAT_GAME = "wechatgame";
      sys.BROWSER_TYPE_WECHAT_GAME_SUB = "wechatgamesub";
      sys.BROWSER_TYPE_BAIDU_GAME = "baidugame";
      sys.BROWSER_TYPE_BAIDU_GAME_SUB = "baidugamesub";
      sys.BROWSER_TYPE_XIAOMI_GAME = "xiaomigame";
      sys.BROWSER_TYPE_ALIPAY_GAME = "alipaygame";
      sys.BROWSER_TYPE_QQ_PLAY = "qqplay";
      sys.BROWSER_TYPE_ANDROID = "androidbrowser";
      sys.BROWSER_TYPE_IE = "ie";
      sys.BROWSER_TYPE_EDGE = "edge";
      sys.BROWSER_TYPE_QQ = "qqbrowser";
      sys.BROWSER_TYPE_MOBILE_QQ = "mqqbrowser";
      sys.BROWSER_TYPE_UC = "ucbrowser";
      sys.BROWSER_TYPE_UCBS = "ucbs";
      sys.BROWSER_TYPE_360 = "360browser";
      sys.BROWSER_TYPE_BAIDU_APP = "baiduboxapp";
      sys.BROWSER_TYPE_BAIDU = "baidubrowser";
      sys.BROWSER_TYPE_MAXTHON = "maxthon";
      sys.BROWSER_TYPE_OPERA = "opera";
      sys.BROWSER_TYPE_OUPENG = "oupeng";
      sys.BROWSER_TYPE_MIUI = "miuibrowser";
      sys.BROWSER_TYPE_FIREFOX = "firefox";
      sys.BROWSER_TYPE_SAFARI = "safari";
      sys.BROWSER_TYPE_CHROME = "chrome";
      sys.BROWSER_TYPE_LIEBAO = "liebao";
      sys.BROWSER_TYPE_QZONE = "qzone";
      sys.BROWSER_TYPE_SOUGOU = "sogou";
      sys.BROWSER_TYPE_UNKNOWN = "unknown";
      sys.isNative = (false, false);
      sys.isBrowser = "object" === typeof window && "object" === typeof document && true;
      sys.glExtension = function(name) {
        return !!cc.renderer.device.ext(name);
      };
      sys.getMaxJointMatrixSize = function() {
        if (!sys._maxJointMatrixSize) {
          var JOINT_MATRICES_SIZE = 50;
          var LEFT_UNIFORM_SIZE = 10;
          var gl = cc.game._renderContext;
          var maxUniforms = Math.floor(gl.getParameter(gl.MAX_VERTEX_UNIFORM_VECTORS) / 4) - LEFT_UNIFORM_SIZE;
          sys._maxJointMatrixSize = maxUniforms < JOINT_MATRICES_SIZE ? 0 : JOINT_MATRICES_SIZE;
        }
        return sys._maxJointMatrixSize;
      };
      sys.getSafeAreaRect = function() {
        var visibleSize = cc.view.getVisibleSize();
        return cc.rect(0, 0, visibleSize.width, visibleSize.height);
      };
      if (_global.__globalAdapter && _global.__globalAdapter.adaptSys) _global.__globalAdapter.adaptSys(sys); else {
        false;
        var platform;
        var languageCode;
        var w;
        var h;
        var ratio;
        var capabilities;
        false, false;
        var win = window, nav = win.navigator, doc = document, docEle = doc.documentElement;
        var ua = nav.userAgent.toLowerCase();
        false;
        sys.isMobile = /mobile|android|iphone|ipad/.test(ua);
        "undefined" !== typeof FbPlayableAd ? sys.platform = sys.FB_PLAYABLE_ADS : sys.platform = sys.isMobile ? sys.MOBILE_BROWSER : sys.DESKTOP_BROWSER;
        var currLanguage = nav.language;
        currLanguage = currLanguage || nav.browserLanguage;
        sys.languageCode = currLanguage.toLowerCase();
        currLanguage = currLanguage ? currLanguage.split("-")[0] : sys.LANGUAGE_ENGLISH;
        sys.language = currLanguage;
        var isAndroid = false, iOS = false, osVersion = "", osMainVersion = 0;
        var uaResult = /android\s*(\d+(?:\.\d+)*)/i.exec(ua) || /android\s*(\d+(?:\.\d+)*)/i.exec(nav.platform);
        if (uaResult) {
          isAndroid = true;
          osVersion = uaResult[1] || "";
          osMainVersion = parseInt(osVersion) || 0;
        }
        uaResult = /(iPad|iPhone|iPod).*OS ((\d+_?){2,3})/i.exec(ua);
        if (uaResult) {
          iOS = true;
          osVersion = uaResult[2] || "";
          osMainVersion = parseInt(osVersion) || 0;
        } else if (/(iPhone|iPad|iPod)/.exec(nav.platform) || "MacIntel" === nav.platform && nav.maxTouchPoints && nav.maxTouchPoints > 1) {
          iOS = true;
          osVersion = "";
          osMainVersion = 0;
        }
        var osName = sys.OS_UNKNOWN;
        -1 !== nav.appVersion.indexOf("Win") ? osName = sys.OS_WINDOWS : iOS ? osName = sys.OS_IOS : -1 !== nav.appVersion.indexOf("Mac") ? osName = sys.OS_OSX : -1 !== nav.appVersion.indexOf("X11") && -1 === nav.appVersion.indexOf("Linux") ? osName = sys.OS_UNIX : isAndroid ? osName = sys.OS_ANDROID : -1 === nav.appVersion.indexOf("Linux") && -1 === ua.indexOf("ubuntu") || (osName = sys.OS_LINUX);
        sys.os = osName;
        sys.osVersion = osVersion;
        sys.osMainVersion = osMainVersion;
        sys.browserType = sys.BROWSER_TYPE_UNKNOWN;
        (function() {
          var typeReg1 = /mqqbrowser|micromessenger|qqbrowser|sogou|qzone|liebao|maxthon|ucbs|360 aphone|360browser|baiduboxapp|baidubrowser|maxthon|mxbrowser|miuibrowser/i;
          var typeReg2 = /qq|ucbrowser|ubrowser|edge/i;
          var typeReg3 = /chrome|safari|firefox|trident|opera|opr\/|oupeng/i;
          var browserTypes = typeReg1.exec(ua) || typeReg2.exec(ua) || typeReg3.exec(ua);
          var browserType = browserTypes ? browserTypes[0].toLowerCase() : sys.BROWSER_TYPE_UNKNOWN;
          "safari" === browserType && isAndroid ? browserType = sys.BROWSER_TYPE_ANDROID : "qq" === browserType && ua.match(/android.*applewebkit/i) && (browserType = sys.BROWSER_TYPE_ANDROID);
          var typeMap = {
            micromessenger: sys.BROWSER_TYPE_WECHAT,
            trident: sys.BROWSER_TYPE_IE,
            edge: sys.BROWSER_TYPE_EDGE,
            "360 aphone": sys.BROWSER_TYPE_360,
            mxbrowser: sys.BROWSER_TYPE_MAXTHON,
            "opr/": sys.BROWSER_TYPE_OPERA,
            ubrowser: sys.BROWSER_TYPE_UC
          };
          sys.browserType = typeMap[browserType] || browserType;
        })();
        sys.browserVersion = "";
        (function() {
          var versionReg1 = /(mqqbrowser|micromessenger|qqbrowser|sogou|qzone|liebao|maxthon|uc|ucbs|360 aphone|360|baiduboxapp|baidu|maxthon|mxbrowser|miui(?:.hybrid)?)(mobile)?(browser)?\/?([\d.]+)/i;
          var versionReg2 = /(qq|chrome|safari|firefox|trident|opera|opr\/|oupeng)(mobile)?(browser)?\/?([\d.]+)/i;
          var tmp = ua.match(versionReg1);
          tmp || (tmp = ua.match(versionReg2));
          sys.browserVersion = tmp ? tmp[4] : "";
        })();
        var w = window.innerWidth || document.documentElement.clientWidth;
        var h = window.innerHeight || document.documentElement.clientHeight;
        var ratio = window.devicePixelRatio || 1;
        sys.windowPixelResolution = {
          width: ratio * w,
          height: ratio * h
        };
        sys._checkWebGLRenderMode = function() {
          if (cc.game.renderType !== cc.game.RENDER_TYPE_WEBGL) throw new Error("This feature supports WebGL render mode only.");
        };
        var _tmpCanvas1 = document.createElement("canvas");
        var create3DContext = function create3DContext(canvas, opt_attribs, opt_contextType) {
          if (!opt_contextType) return create3DContext(canvas, opt_attribs, "webgl") || create3DContext(canvas, opt_attribs, "experimental-webgl") || create3DContext(canvas, opt_attribs, "webkit-3d") || create3DContext(canvas, opt_attribs, "moz-webgl") || null;
          try {
            return canvas.getContext(opt_contextType, opt_attribs);
          } catch (e) {
            return null;
          }
        };
        try {
          var localStorage = sys.localStorage = win.localStorage;
          localStorage.setItem("storage", "");
          localStorage.removeItem("storage");
          localStorage = null;
        } catch (e) {
          var warn = function warn() {
            cc.warnID(5200);
          };
          sys.localStorage = {
            getItem: warn,
            setItem: warn,
            removeItem: warn,
            clear: warn
          };
        }
        var _supportWebp = _tmpCanvas1.toDataURL("image/webp").startsWith("data:image/webp");
        var _supportCanvas = !!_tmpCanvas1.getContext("2d");
        var _supportWebGL = false;
        false;
        win.WebGLRenderingContext && (_supportWebGL = true);
        var capabilities = sys.capabilities = {
          canvas: _supportCanvas,
          opengl: _supportWebGL,
          webp: _supportWebp,
          imageBitmap: false
        };
        if ("undefined" !== typeof createImageBitmap && "undefined" !== typeof Blob) {
          _tmpCanvas1.width = _tmpCanvas1.height = 2;
          createImageBitmap(_tmpCanvas1, {}).then((function(imageBitmap) {
            capabilities.imageBitmap = true;
            imageBitmap.close && imageBitmap.close();
          }))["catch"]((function(err) {}));
        }
        (void 0 !== docEle["ontouchstart"] || void 0 !== doc["ontouchstart"] || nav.msPointerEnabled) && (capabilities["touches"] = true);
        void 0 !== docEle["onmouseup"] && (capabilities["mouse"] = true);
        void 0 !== docEle["onkeyup"] && (capabilities["keyboard"] = true);
        (win.DeviceMotionEvent || win.DeviceOrientationEvent) && (capabilities["accelerometer"] = true);
        var __audioSupport;
        (function() {
          var DEBUG = false;
          var version = sys.browserVersion;
          var supportWebAudio = !!(window.AudioContext || window.webkitAudioContext || window.mozAudioContext);
          __audioSupport = {
            ONLY_ONE: false,
            WEB_AUDIO: supportWebAudio,
            DELAY_CREATE_CTX: false
          };
          sys.os === sys.OS_IOS && (__audioSupport.USE_LOADER_EVENT = "loadedmetadata");
          if (sys.browserType === sys.BROWSER_TYPE_FIREFOX) {
            __audioSupport.DELAY_CREATE_CTX = true;
            __audioSupport.USE_LOADER_EVENT = "canplay";
          }
          sys.os === sys.OS_ANDROID && sys.browserType === sys.BROWSER_TYPE_UC && (__audioSupport.ONE_SOURCE = true);
          DEBUG && setTimeout((function() {
            cc.log("browse type: " + sys.browserType);
            cc.log("browse version: " + version);
            cc.log("MULTI_CHANNEL: " + __audioSupport.MULTI_CHANNEL);
            cc.log("WEB_AUDIO: " + __audioSupport.WEB_AUDIO);
            cc.log("AUTOPLAY: " + __audioSupport.AUTOPLAY);
          }), 0);
        })();
        try {
          if (__audioSupport.WEB_AUDIO) {
            __audioSupport.context = new (window.AudioContext || window.webkitAudioContext || window.mozAudioContext)();
            __audioSupport.DELAY_CREATE_CTX && setTimeout((function() {
              __audioSupport.context = new (window.AudioContext || window.webkitAudioContext || window.mozAudioContext)();
            }), 0);
          }
        } catch (error) {
          __audioSupport.WEB_AUDIO = false;
          cc.logID(5201);
        }
        var formatSupport = [];
        (function() {
          var audio = document.createElement("audio");
          if (audio.canPlayType) {
            var ogg = audio.canPlayType('audio/ogg; codecs="vorbis"');
            ogg && formatSupport.push(".ogg");
            var mp3 = audio.canPlayType("audio/mpeg");
            mp3 && formatSupport.push(".mp3");
            var wav = audio.canPlayType('audio/wav; codecs="1"');
            wav && formatSupport.push(".wav");
            var mp4 = audio.canPlayType("audio/mp4");
            mp4 && formatSupport.push(".mp4");
            var m4a = audio.canPlayType("audio/x-m4a");
            m4a && formatSupport.push(".m4a");
          }
        })();
        __audioSupport.format = formatSupport;
        sys.__audioSupport = __audioSupport;
      }
      sys.NetworkType = {
        NONE: 0,
        LAN: 1,
        WWAN: 2
      };
      sys.getNetworkType = function() {
        return sys.NetworkType.LAN;
      };
      sys.getBatteryLevel = function() {
        return 1;
      };
      sys.garbageCollect = function() {};
      sys.restartVM = function() {};
      sys.isObjectValid = function(obj) {
        if (obj) return true;
        return false;
      };
      sys.dump = function() {
        var self = this;
        var str = "";
        str += "isMobile : " + self.isMobile + "\r\n";
        str += "language : " + self.language + "\r\n";
        str += "browserType : " + self.browserType + "\r\n";
        str += "browserVersion : " + self.browserVersion + "\r\n";
        str += "capabilities : " + JSON.stringify(self.capabilities) + "\r\n";
        str += "os : " + self.os + "\r\n";
        str += "osVersion : " + self.osVersion + "\r\n";
        str += "platform : " + self.platform + "\r\n";
        str += "Using " + (cc.game.renderType === cc.game.RENDER_TYPE_WEBGL ? "WEBGL" : "CANVAS") + " renderer.\r\n";
        cc.log(str);
      };
      sys.openURL = function(url) {
        false, false;
        window.open(url);
      };
      sys.now = function() {
        return Date.now ? Date.now() : +new Date();
      };
      return sys;
    }
    var sys = cc && cc.sys ? cc.sys : initSys();
    module.exports = sys;
  }), {} ],
  148: [ (function(require, module, exports) {
    "use strict";
    var EventTarget = require("../event/event-target");
    var js = require("../platform/js");
    var renderer = require("../renderer");
    require("../platform/CCClass");
    var __BrowserGetter = {
      init: function init() {
        this.html = document.getElementsByTagName("html")[0];
      },
      availWidth: function availWidth(frame) {
        return frame && frame !== this.html ? frame.clientWidth : window.innerWidth;
      },
      availHeight: function availHeight(frame) {
        return frame && frame !== this.html ? frame.clientHeight : window.innerHeight;
      },
      meta: {
        width: "device-width"
      },
      adaptationType: cc.sys.browserType
    };
    cc.sys.os === cc.sys.OS_IOS && (__BrowserGetter.adaptationType = cc.sys.BROWSER_TYPE_SAFARI);
    switch (__BrowserGetter.adaptationType) {
     case cc.sys.BROWSER_TYPE_SAFARI:
     case cc.sys.BROWSER_TYPE_SOUGOU:
     case cc.sys.BROWSER_TYPE_UC:
      __BrowserGetter.meta["minimal-ui"] = "true";
      __BrowserGetter.availWidth = function(frame) {
        return frame.clientWidth;
      };
      __BrowserGetter.availHeight = function(frame) {
        return frame.clientHeight;
      };
    }
    var _scissorRect = null;
    var View = function View() {
      EventTarget.call(this);
      var _t = this, _strategyer = cc.ContainerStrategy, _strategy = cc.ContentStrategy;
      __BrowserGetter.init(this);
      _t._frameSize = cc.size(0, 0);
      _t._designResolutionSize = cc.size(0, 0);
      _t._originalDesignResolutionSize = cc.size(0, 0);
      _t._scaleX = 1;
      _t._scaleY = 1;
      _t._viewportRect = cc.rect(0, 0, 0, 0);
      _t._visibleRect = cc.rect(0, 0, 0, 0);
      _t._autoFullScreen = false;
      _t._devicePixelRatio = 1;
      false;
      _t._maxPixelRatio = 2;
      _t._retinaEnabled = false;
      _t._resizeCallback = null;
      _t._resizing = false;
      _t._resizeWithBrowserSize = false;
      _t._orientationChanging = true;
      _t._isRotated = false;
      _t._orientation = cc.macro.ORIENTATION_AUTO;
      _t._isAdjustViewport = true;
      _t._antiAliasEnabled = false;
      _t._resolutionPolicy = null;
      _t._rpExactFit = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.EXACT_FIT);
      _t._rpShowAll = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.SHOW_ALL);
      _t._rpNoBorder = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.NO_BORDER);
      _t._rpFixedHeight = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.FIXED_HEIGHT);
      _t._rpFixedWidth = new cc.ResolutionPolicy(_strategyer.EQUAL_TO_FRAME, _strategy.FIXED_WIDTH);
      cc.game.once(cc.game.EVENT_ENGINE_INITED, this.init, this);
    };
    cc.js.extend(View, EventTarget);
    cc.js.mixin(View.prototype, {
      init: function init() {
        this._initFrameSize();
        var w = cc.game.canvas.width, h = cc.game.canvas.height;
        this._designResolutionSize.width = w;
        this._designResolutionSize.height = h;
        this._originalDesignResolutionSize.width = w;
        this._originalDesignResolutionSize.height = h;
        this._viewportRect.width = w;
        this._viewportRect.height = h;
        this._visibleRect.width = w;
        this._visibleRect.height = h;
        cc.winSize.width = this._visibleRect.width;
        cc.winSize.height = this._visibleRect.height;
        cc.visibleRect && cc.visibleRect.init(this._visibleRect);
      },
      _resizeEvent: function _resizeEvent(forceOrEvent) {
        var view;
        view = this.setDesignResolutionSize ? this : cc.view;
        var sys = cc.sys;
        if (sys.browserType === sys.BROWSER_TYPE_UC && sys.os === sys.OS_IOS) {
          setTimeout((function() {
            view._resizeEvent(forceOrEvent);
          }), 0);
          return;
        }
        var prevFrameW = view._frameSize.width, prevFrameH = view._frameSize.height, prevRotated = view._isRotated;
        if (cc.sys.isMobile) {
          var containerStyle = cc.game.container.style, margin = containerStyle.margin;
          containerStyle.margin = "0";
          containerStyle.display = "none";
          view._initFrameSize();
          containerStyle.margin = margin;
          containerStyle.display = "block";
        } else view._initFrameSize();
        if (true !== forceOrEvent && view._isRotated === prevRotated && view._frameSize.width === prevFrameW && view._frameSize.height === prevFrameH) return;
        var width = view._originalDesignResolutionSize.width;
        var height = view._originalDesignResolutionSize.height;
        view._resizing = true;
        width > 0 && view.setDesignResolutionSize(width, height, view._resolutionPolicy);
        view._resizing = false;
        view.emit("canvas-resize");
        view._resizeCallback && view._resizeCallback.call();
      },
      _orientationChange: function _orientationChange() {
        cc.view._orientationChanging = true;
        cc.view._resizeEvent();
        cc.sys.browserType === cc.sys.BROWSER_TYPE_SAFARI && cc.sys.isMobile && setTimeout((function() {
          window.innerHeight > window.innerWidth && window.scrollTo(0, 1);
        }), 500);
      },
      _resize: function _resize() {
        cc.view._resizeEvent(false);
      },
      resizeWithBrowserSize: function resizeWithBrowserSize(enabled) {
        if (enabled) {
          if (!this._resizeWithBrowserSize) {
            this._resizeWithBrowserSize = true;
            window.addEventListener("resize", this._resize);
            window.addEventListener("orientationchange", this._orientationChange);
          }
        } else if (this._resizeWithBrowserSize) {
          this._resizeWithBrowserSize = false;
          window.removeEventListener("resize", this._resize);
          window.removeEventListener("orientationchange", this._orientationChange);
        }
      },
      setResizeCallback: function setResizeCallback(callback) {
        false;
        "function" !== typeof callback && null != callback || (this._resizeCallback = callback);
      },
      setOrientation: function setOrientation(orientation) {
        orientation &= cc.macro.ORIENTATION_AUTO;
        if (orientation && this._orientation !== orientation) {
          this._orientation = orientation;
          var designWidth = this._originalDesignResolutionSize.width;
          var designHeight = this._originalDesignResolutionSize.height;
          this.setDesignResolutionSize(designWidth, designHeight, this._resolutionPolicy);
        }
      },
      _initFrameSize: function _initFrameSize() {
        var locFrameSize = this._frameSize;
        var w = __BrowserGetter.availWidth(cc.game.frame);
        var h = __BrowserGetter.availHeight(cc.game.frame);
        var isLandscape = w >= h;
        if ((false, !cc.sys.isMobile) || isLandscape && this._orientation & cc.macro.ORIENTATION_LANDSCAPE || !isLandscape && this._orientation & cc.macro.ORIENTATION_PORTRAIT) {
          locFrameSize.width = w;
          locFrameSize.height = h;
          cc.game.container.style["-webkit-transform"] = "rotate(0deg)";
          cc.game.container.style.transform = "rotate(0deg)";
          this._isRotated = false;
        } else {
          locFrameSize.width = h;
          locFrameSize.height = w;
          cc.game.container.style["