
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/Host.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '037d4AvGBBHv7bkyLQMs/AF', 'Host');
// Script/Host.js

"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _ServerConfig = _interopRequireDefault(require("./ServerConfig"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var Host = /*#__PURE__*/function () {
  function Host() {
    this.isWechat = cc.sys.platform === cc.sys.WECHAT_GAME;
    this.isQQ = this.isWechat && _ServerConfig["default"].subPlatform === 'qq';
    this.isJkw = cc.sys.platform === cc.sys.JKW_GAME;
    this.isAndroid = cc.sys.platform === cc.sys.OS_ANDROID || cc.sys.platform === 3;
  } // 基础-系统-系统信息


  var _proto = Host.prototype;

  _proto.getSystemInfoSync = function getSystemInfoSync() {
    if (this.isWechat) {
      return wx.getSystemInfoSync();
    } else if (this.isJkw) {
      cc.log('host.getSystemInfoSync');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().getSystemInfoSync();
      }
    } else if (this.isAndroid) {
      return {
        screenWidth: cc.view.getDesignResolutionSize().width,
        screenHeight: cc.view.getDesignResolutionSize().height,
        safeArea: cc.sys.getSafeAreaRect()
      };
    }
  };

  _proto.getSystemInfo = function getSystemInfo(object) {
    if (this.isWechat) {
      return wx.getSystemInfo(object);
    } else if (this.isJkw) {
      cc.log('host.getSystemInfo');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().getSystemInfo();
      }
    } else if (this.isAndroid) {
      cc.log('host.getSystemInfo');
    }
  } // 基础-更新
  ;

  _proto.getUpdateManager = function getUpdateManager() {
    if (this.isWechat) {
      return wx.getUpdateManager();
    } else if (this.isJkw) {
      cc.log('host.getUpdateManager');
      return {
        onCheckForUpdate: function onCheckForUpdate(callback) {},
        onUpdateFailed: function onUpdateFailed(callback) {},
        onUpdateReady: function onUpdateReady(callback) {}
      };
    } else if (this.isAndroid) {
      cc.log('host.getUpdateManager');
      return {
        onCheckForUpdate: function onCheckForUpdate(callback) {},
        onUpdateFailed: function onUpdateFailed(callback) {},
        onUpdateReady: function onUpdateReady(callback) {}
      };
    }
  } // 基础-生命周期
  ;

  _proto.exitMiniProgram = function exitMiniProgram(object) {
    if (this.isWechat) {
      return wx.exitMiniProgram(object);
    } else if (this.isJkw) {
      cc.log('host.exitMiniProgram');
    } else if (this.isAndroid) {
      cc.log('host.exitMiniProgram');
    }
  } // 基础-应用级事件
  ;

  _proto.onAudioInterruptionEnd = function onAudioInterruptionEnd(callback) {
    if (this.isWechat) {
      return wx.onAudioInterruptionEnd(callback);
    } else if (this.isJkw) {
      cc.log('host.onAudioInterruptionBegin');
    } else if (this.isAndroid) {
      cc.log('host.onAudioInterruptionBegin');
    }
  };

  _proto.onAudioInterruptionBegin = function onAudioInterruptionBegin(callback) {
    if (this.isWechat) {
      return wx.onAudioInterruptionBegin(callback);
    } else if (this.isJkw) {
      cc.log('host.onAudioInterruptionBegin');
    } else if (this.isAndroid) {
      cc.log('host.onAudioInterruptionBegin');
    }
  };

  _proto.offAudioInterruptionEnd = function offAudioInterruptionEnd(callback) {
    if (this.isWechat) {
      return wx.offAudioInterruptionEnd(callback);
    } else if (this.isJkw) {
      cc.log('host.onAudioInterruptionBegin');
    } else if (this.isAndroid) {
      cc.log('host.onAudioInterruptionBegin');
    }
  };

  _proto.offAudioInterruptionBegin = function offAudioInterruptionBegin(callback) {
    if (this.isWechat) {
      return wx.offAudioInterruptionBegin(callback);
    } else if (this.isJkw) {
      cc.log('host.onAudioInterruptionBegin');
    } else if (this.isAndroid) {
      cc.log('host.onAudioInterruptionBegin');
    }
  } // 基础-订阅消息
  ;

  _proto.requestSubscribeSystemMessage = function requestSubscribeSystemMessage(object) {
    if (this.isWechat) {
      return wx.requestSubscribeSystemMessage(object);
    } else if (this.isJkw) {
      cc.log('host.requestSubscribeSystemMessage');
    } else if (this.isAndroid) {
      cc.log('host.requestSubscribeSystemMessage');
    }
  };

  _proto.requestSubscribeMessage = function requestSubscribeMessage(object) {
    if (this.isWechat) {
      return wx.requestSubscribeMessage(object);
    } else if (this.isJkw) {
      cc.log('host.requestSubscribeMessage');
    } else if (this.isAndroid) {
      cc.log('host.requestSubscribeMessage');
    }
  } // 渲染-帧率
  ;

  _proto.setPreferredFramesPerSecond = function setPreferredFramesPerSecond(fps) {
    if (this.isWechat) {
      return wx.setPreferredFramesPerSecond(fps);
    } else if (this.isJkw) {
      cc.log('host.setPreferredFramesPerSecond');
    } else if (this.isAndroid) {
      cc.log('host.setPreferredFramesPerSecond');
    }
  } // 广告
  ;

  _proto.createRewardedVideoAd = function createRewardedVideoAd(object) {
    if (this.isWechat) {
      return wx.createRewardedVideoAd(object);
    } else if (this.isJkw) {
      return AdSDK.createRewardedVideoAd(object.adUnitId, _ServerConfig["default"].videoAdId, 2);
    } else if (this.isAndroid) {
      cc.log('host.createRewardedVideoAd');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offClose: function offClose(callback) {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onClose: function onClose(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    }
  };

  _proto.createInterstitialAd = function createInterstitialAd(object) {
    if (this.isWechat) {
      return wx.createInterstitialAd(object);
    } else if (this.isJkw) {
      var obj = AdSDK.createInterstitialAd(object.adUnitId, _ServerConfig["default"].interstitialAdId, 2);
      obj.onClose = obj.onResize;
      obj.offClose = obj.offResize;
      return obj;
    } else if (this.isAndroid) {
      cc.log('host.createInterstitialAd');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offClose: function offClose(callback) {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onClose: function onClose(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    }
  };

  _proto.createBannerAd = function createBannerAd(object) {
    if (this.isWechat) {
      return wx.createBannerAd(object);
    } else if (this.isJkw) {
      cc.log('host.createBannerAd');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offClose: function offClose(callback) {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onClose: function onClose(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createBannerAd');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offClose: function offClose(callback) {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onClose: function onClose(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    }
  } // 界面-交互
  ;

  _proto.showToast = function showToast(object) {
    if (this.isWechat) {
      return wx.showToast(object);
    } else if (this.isJkw) {
      cc.log('host.showToast');
    } else if (this.isAndroid) {
      cc.log('host.showToast');
    }
  };

  _proto.showModal = function showModal(object) {
    if (this.isWechat) {
      return wx.showModal(object);
    } else if (this.isJkw) {
      cc.log('host.showModal');
    } else if (this.isAndroid) {
      cc.log('host.showModal');
    }
  };

  _proto.showLoading = function showLoading(object) {
    if (this.isWechat) {
      return wx.showLoading(object);
    } else if (this.isJkw) {
      cc.log('host.showLoading');
    } else if (this.isAndroid) {
      cc.log('host.showLoading');
    }
  };

  _proto.showActionSheet = function showActionSheet(object) {
    if (this.isWechat) {
      return wx.showActionSheet(object);
    } else if (this.isJkw) {
      cc.log('host.showActionSheet');
    } else if (this.isAndroid) {
      cc.log('host.showActionSheet');
    }
  };

  _proto.hideToast = function hideToast(object) {
    if (this.isWechat) {
      return wx.hideToast(object);
    } else if (this.isJkw) {
      cc.log('host.hideToast');
    } else if (this.isAndroid) {
      cc.log('host.hideToast');
    }
  };

  _proto.hideLoading = function hideLoading(object) {
    if (this.isWechat) {
      return wx.hideLoading(object);
    } else if (this.isJkw) {
      cc.log('host.hideLoading');
    } else if (this.isAndroid) {
      cc.log('host.hideLoading');
    }
  };

  _proto.connectSocket = function connectSocket(object) {
    if (this.isWechat) {
      return wx.connectSocket(object);
    } else if (this.isJkw) {
      cc.log('host.connectSocket');

      if (CC_PREVIEW || CC_BUILD) {
        return new WebSocket(object.url);
      }
    } else if (this.isAndroid) {
      cc.log('host.connectSocket');

      if (CC_PREVIEW || CC_BUILD) {
        return new WebSocket(object.url);
      }
    }
  };

  _proto.request = function request(object) {
    if (this.isWechat) {
      return wx.request(object);
    } else if (this.isJkw) {
      cc.log('host.request');

      if (CC_PREVIEW || CC_BUILD) {
        var xhr = cc.loader.getXMLHttpRequest();

        xhr.onreadystatechange = function () {
          if (xhr.readyState == 4) {
            cc.log('response:', xhr.status, xhr.responseURL);

            if (xhr.status >= 200 && xhr.status < 400) {
              var data = {
                data: xhr.status === 204 ? '' : JSON.parse(xhr.responseText),
                errMsg: "request:ok",
                statusCode: xhr.status
              };
              object.success && object.success(data);
            } else {
              object.fail && object.fail(xhr.status);
            }
          }
        };

        cc.log('request:', object.method, object.url);

        if (object.method.toUpperCase() === 'GET') {
          var url = object.url;

          if (object.data) {
            var first = true;
            Object.keys(object.data).forEach(function (key) {
              if (first) {
                url += '?' + key + '=' + encodeURIComponent(object.data[key]);
              } else {
                url += '&' + key + '=' + encodeURIComponent(object.data[key]);
                first = false;
              }
            });
          }

          xhr.open(object.method, url, true);
          Object.keys(object.header).forEach(function (key) {
            return xhr.setRequestHeader(key, object.header[key]);
          });
          xhr.send();
        } else {
          xhr.open(object.method, object.url, true);
          xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
          Object.keys(object.header).forEach(function (key) {
            return xhr.setRequestHeader(key, object.header[key]);
          });
          xhr.send(JSON.stringify(object.data));
        }
      }
    } else if (this.isAndroid) {
      cc.log('host.request');

      if (CC_PREVIEW || CC_BUILD) {
        var _xhr = cc.loader.getXMLHttpRequest();

        _xhr.onreadystatechange = function () {
          if (_xhr.readyState == 4) {
            cc.log('response:', _xhr.status, _xhr.responseURL);

            if (_xhr.status >= 200 && _xhr.status < 400) {
              var data = {
                data: _xhr.status === 204 ? '' : JSON.parse(_xhr.responseText),
                errMsg: "request:ok",
                statusCode: _xhr.status
              };
              object.success && object.success(data);
            } else {
              object.fail && object.fail(_xhr.status);
            }
          }
        };

        cc.log('request:', object.method, object.url);

        if (object.method.toUpperCase() === 'GET') {
          var _url = object.url;

          if (object.data) {
            var _first = true;
            Object.keys(object.data).forEach(function (key) {
              if (_first) {
                _url += '?' + key + '=' + encodeURIComponent(object.data[key]);
              } else {
                _url += '&' + key + '=' + encodeURIComponent(object.data[key]);
                _first = false;
              }
            });
          }

          _xhr.open(object.method, _url, true);

          Object.keys(object.header).forEach(function (key) {
            return _xhr.setRequestHeader(key, object.header[key]);
          });

          _xhr.send();
        } else {
          _xhr.open(object.method, object.url, true);

          _xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');

          Object.keys(object.header).forEach(function (key) {
            return _xhr.setRequestHeader(key, object.header[key]);
          });

          _xhr.send(JSON.stringify(object.data));
        }
      }
    }
  };

  _proto.showShareMenu = function showShareMenu(object) {
    if (object === void 0) {
      object = {};
    }

    if (this.isWechat) {
      return wx.showShareMenu(object);
    } else if (this.isJkw) {
      cc.log('host.showShareMenu');
    } else if (this.isAndroid) {
      cc.log('host.showShareMenu');
    }
  };

  _proto.request = function request(object) {
    if (this.isWechat) {
      return wx.request(object);
    } else if (this.isJkw) {
      cc.log('host.request');

      if (CC_PREVIEW || CC_BUILD) {
        var xhr = cc.loader.getXMLHttpRequest();

        xhr.onreadystatechange = function () {
          if (xhr.readyState == 4) {
            cc.log('response:', xhr.status, xhr.responseURL);

            if (xhr.status >= 200 && xhr.status < 400) {
              var data = {
                data: xhr.status === 204 ? '' : JSON.parse(xhr.responseText),
                errMsg: "request:ok",
                statusCode: xhr.status
              };
              object.success && object.success(data);
            } else {
              object.fail && object.fail(xhr.status);
            }
          }
        };

        cc.log('request:', object.method, object.url);
        xhr.open(object.method, object.url, true);
        xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
        Object.keys(object.header).forEach(function (key) {
          return xhr.setRequestHeader(key, object.header[key]);
        });
        xhr.send(JSON.stringify(object.data));
      }
    }
  };

  _proto.setStorageSync = function setStorageSync(key, data) {
    if (this.isWechat) {
      return wx.setStorageSync(key, data);
    } else if (this.isJkw) {
      cc.log('host.setStorageSync');
      return cc.sys.localStorage.setItem(key, JSON.stringify(data));
    } else if (this.isAndroid) {
      cc.log('host.setStorageSync');
      return cc.sys.localStorage.setItem(key, JSON.stringify(data));
    }
  };

  _proto.setStorage = function setStorage(object) {
    if (this.isWechat) {
      return wx.setStorage(object);
    } else if (this.isJkw) {
      cc.log('host.setStorage');

      try {
        cc.sys.localStorage.setItem(object.key, JSON.stringify(object.data));
        object.success && object.success();
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.setStorage');

      try {
        cc.sys.localStorage.setItem(object.key, JSON.stringify(object.data));
        object.success && object.success();
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.removeStorageSync = function removeStorageSync(key) {
    if (this.isWechat) {
      return wx.removeStorageSync(key);
    } else if (this.isJkw) {
      cc.log('host.removeStorageSync');
      return cc.sys.localStorage.removeItem(key);
    } else if (this.isAndroid) {
      cc.log('host.removeStorageSync');
      return cc.sys.localStorage.removeItem(key);
    }
  };

  _proto.removeStorage = function removeStorage(object) {
    if (this.isWechat) {
      return wx.removeStorage(object);
    } else if (this.isJkw) {
      cc.log('host.removeStorage');

      try {
        result = cc.sys.localStorage.removeItem(object.key);

        if (object.success) {
          object.success();
        }
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.removeStorage');

      try {
        result = cc.sys.localStorage.removeItem(object.key);

        if (object.success) {
          object.success();
        }
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.getStorageSync = function getStorageSync(key) {
    if (this.isWechat) {
      return wx.getStorageSync(key);
    } else if (this.isJkw) {
      cc.log('host.getStorageSync');

      var _result = cc.sys.localStorage.getItem(key);

      _result = _result === null ? '' : JSON.parse(_result);
      return _result;
    } else if (this.isAndroid) {
      cc.log('host.getStorageSync');

      var _result2 = cc.sys.localStorage.getItem(key);

      _result2 = _result2 === null ? '' : JSON.parse(_result2);
      return _result2;
    }
  };

  _proto.getStorageInfoSync = function getStorageInfoSync(object) {
    if (this.isWechat) {
      return wx.getStorageInfoSync(object);
    } else if (this.isJkw) {
      cc.log('host.getStorageInfoSync');
      var _result3 = {
        keys: [],
        currentSize: -1,
        limitSize: -1
      };

      for (var i = 0; i < cc.sys.localStorage.length; i++) {
        var value = cc.sys.localStorage.key(i);
        _result3.keys[i] = value === null ? '' : JSON.parse(value);
      }

      return _result3;
    } else if (this.isAndroid) {
      cc.log('host.getStorageInfoSync');
      var _result4 = {
        keys: [],
        currentSize: -1,
        limitSize: -1
      };

      for (var _i = 0; _i < cc.sys.localStorage.length; _i++) {
        var _value = cc.sys.localStorage.key(_i);

        _result4.keys[_i] = _value === null ? '' : JSON.parse(_value);
      }

      return _result4;
    }
  };

  _proto.getStorageInfo = function getStorageInfo(object) {
    if (this.isWechat) {
      return wx.getStorageInfo(object);
    } else if (this.isJkw) {
      cc.log('host.getStorageInfo');

      try {
        var _result5 = {
          keys: [],
          currentSize: -1,
          limitSize: -1
        };

        for (var i = 0; i < cc.sys.localStorage.length; i++) {
          var value = cc.sys.localStorage.key(i);
          _result5.keys[i] = value === null ? '' : JSON.parse(value);
        }

        object.success && object.success(_result5);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.getStorageInfo');

      try {
        var _result6 = {
          keys: [],
          currentSize: -1,
          limitSize: -1
        };

        for (var _i2 = 0; _i2 < cc.sys.localStorage.length; _i2++) {
          var _value2 = cc.sys.localStorage.key(_i2);

          _result6.keys[_i2] = _value2 === null ? '' : JSON.parse(_value2);
        }

        object.success && object.success(_result6);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.getStorage = function getStorage(object) {
    if (this.isWechat) {
      return wx.getStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getStorage');

      try {
        var _result7 = cc.sys.localStorage.getItem(key);

        _result7 = _result7 === null ? '' : JSON.parse(_result7);
        object.success && object.success(_result7);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.getStorage');

      try {
        var _result8 = cc.sys.localStorage.getItem(key);

        _result8 = _result8 === null ? '' : JSON.parse(_result8);
        object.success && object.success(_result8);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.clearStorageSync = function clearStorageSync() {
    if (this.isWechat) {
      return wx.clearStorageSync();
    } else if (this.isJkw) {
      cc.log('host.clearStorageSync');
      cc.sys.localStorage.clear();
    } else if (this.isAndroid) {
      cc.log('host.clearStorageSync');
      cc.sys.localStorage.clear();
    }
  };

  _proto.clearStorage = function clearStorage(object) {
    if (this.isWechat) {
      return wx.clearStorage(object);
    } else if (this.isJkw) {
      cc.log('host.clearStorage');

      try {
        var _result9 = cc.sys.localStorage.clear();

        object.success && object.success(_result9);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.clearStorage');

      try {
        var _result10 = cc.sys.localStorage.clear();

        object.success && object.success(_result10);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.getLaunchOptionsSync = function getLaunchOptionsSync() {
    if (this.isWechat) {
      return wx.getLaunchOptionsSync();
    } else if (this.isJkw) {
      cc.log('host.getLaunchOptionsSync');
      return {
        query: {},
        scene: -1,
        referrerInfo: {
          appId: 0
        }
      };
    } else if (this.isAndroid) {
      cc.log('host.getLaunchOptionsSync');
      return {
        query: {},
        scene: -1,
        referrerInfo: {
          appId: 0
        }
      };
    }
  } // 设备-剪切板
  ;

  _proto.setClipboardData = function setClipboardData(object) {
    if (this.isWechat) {
      return wx.setClipboardData(object);
    } else if (this.isJkw) {
      cc.log('host.setClipboardData');
    } else if (this.isAndroid) {
      cc.log('host.setClipboardData');
    }
  };

  _proto.getClipboardData = function getClipboardData(object) {
    if (this.isWechat) {
      return wx.getClipboardData(object);
    } else if (this.isJkw) {
      cc.log('host.getClipboardData');
    } else if (this.isAndroid) {
      cc.log('host.getClipboardData');
    }
  } // 开放接口-小程序跳转
  ;

  _proto.navigateToMiniProgram = function navigateToMiniProgram(object) {
    if (this.isWechat) {
      return wx.navigateToMiniProgram(object);
    } else if (this.isJkw) {
      cc.log('host.navigateToMiniProgram');
    } else if (this.isAndroid) {
      cc.log('host.navigateToMiniProgram');
    }
  } // 开放接口-用户信息
  ;

  _proto.getUserInfo = function getUserInfo(object) {
    if (this.isWechat) {
      return wx.getUserInfo(object);
    } else if (this.isJkw) {
      cc.log('host.getUserInfo');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().getUserInfo(object);
      }
    } else if (this.isAndroid) {
      cc.log('host.getUserInfo');
    }
  };

  _proto.getUserGameLabel = function getUserGameLabel(object) {
    if (this.isWechat) {
      return wx.getUserGameLabel(object);
    } else if (this.isJkw) {
      cc.log('host.getUserGameLabel');
    } else if (this.isAndroid) {
      cc.log('host.getUserGameLabel');
    }
  };

  _proto.createUserInfoButton = function createUserInfoButton(object) {
    if (this.isWechat) {
      return wx.createUserInfoButton(object);
    } else if (this.isJkw) {
      cc.log('host.createUserInfoButton');
      return {
        destory: function destory() {},
        hide: function hide() {},
        offTap: function offTap(callback) {},
        onTap: function onTap(callback) {},
        show: function show() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createUserInfoButton');
      return {
        destory: function destory() {},
        hide: function hide() {},
        offTap: function offTap(callback) {},
        onTap: function onTap(callback) {},
        show: function show() {}
      };
    }
  } // 开放接口-登陆
  ;

  _proto.login = function login(object) {
    if (this.isWechat) {
      return wx.login(object);
    } else if (this.isJkw) {
      cc.log('host.login');
      return object.success({
        code: '123'
      });
    } else if (this.isAndroid) {
      cc.log('host.login');
      return object.success({
        code: '123'
      });
    }
  };

  _proto.checkSession = function checkSession(object) {
    if (this.isWechat) {
      return wx.checkSession(object);
    } else if (this.isJkw) {
      cc.log('host.checkSession');
    } else if (this.isAndroid) {
      cc.log('host.checkSession');
    }
  } // 开放接口-授权
  ;

  _proto.authorize = function authorize(object) {
    if (this.isWechat) {
      return wx.authorize(object);
    } else if (this.isJkw) {
      cc.log('host.authorize');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().authorize(object);
      }
    } else if (this.isAndroid) {
      cc.log('host.authorize');
    }
  } // 开放接口-开放数据域
  ;

  _proto.onMessage = function onMessage(callback) {
    if (this.isWechat) {
      return wx.onMessage(callback);
    } else if (this.isJkw) {
      cc.log('host.onMessage');
    } else if (this.isAndroid) {
      cc.log('host.onMessage');
    }
  };

  _proto.getOpenDataContext = function getOpenDataContext() {
    if (this.isWechat) {
      return wx.getOpenDataContext();
    } else if (this.isJkw) {
      cc.log('host.getOpenDataContext');
      return {
        postMessage: function postMessage(message) {}
      };
    } else if (this.isAndroid) {
      cc.log('host.getOpenDataContext');
      return {
        postMessage: function postMessage(message) {}
      };
    }
  };

  _proto.shareMessageToFriend = function shareMessageToFriend(object) {
    if (this.isWechat) {
      return wx.shareMessageToFriend(object);
    } else if (this.isJkw) {
      cc.log('host.shareMessageToFriend');
    } else if (this.isAndroid) {
      cc.log('host.shareMessageToFriend');
    }
  };

  _proto.shareAppMessage = function shareAppMessage(object) {
    if (this.isWechat) {
      return wx.shareAppMessage(object);
    } else if (this.isJkw) {
      cc.log('host.shareAppMessage');
    } else if (this.isAndroid) {
      cc.log('host.shareAppMessage');
    }
  };

  _proto.setUserCloudStorage = function setUserCloudStorage(object) {
    if (this.isWechat) {
      return wx.setUserCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.setUserCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.setUserCloudStorage');
    }
  };

  _proto.setMessageToFriendQuery = function setMessageToFriendQuery(object) {
    if (this.isWechat) {
      return wx.setMessageToFriendQuery(object);
    } else if (this.isJkw) {
      cc.log('host.setMessageToFriendQuery');
    } else if (this.isAndroid) {
      cc.log('host.setMessageToFriendQuery');
    }
  };

  _proto.onShareMessageToFriend = function onShareMessageToFriend(object) {
    if (this.isWechat) {
      return wx.onShareMessageToFriend(object);
    } else if (this.isJkw) {
      cc.log('host.onShareMessageToFriend');
    } else if (this.isAndroid) {
      cc.log('host.onShareMessageToFriend');
    }
  };

  _proto.removeUserCloudStorage = function removeUserCloudStorage(object) {
    if (this.isWechat) {
      return wx.removeUserCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.removeUserCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.removeUserCloudStorage');
    }
  };

  _proto.onInteractiveStorageModified = function onInteractiveStorageModified(callback) {
    if (this.isWechat) {
      return wx.onInteractiveStorageModified(callback);
    } else if (this.isJkw) {
      cc.log('host.onInteractiveStorageModified');
    } else if (this.isAndroid) {
      cc.log('host.onInteractiveStorageModified');
    }
  };

  _proto.modifyFriendInteractiveStorage = function modifyFriendInteractiveStorage(object) {
    if (this.isWechat) {
      return wx.modifyFriendInteractiveStorage(object);
    } else if (this.isJkw) {
      cc.log('host.modifyFriendInteractiveStorage');
    } else if (this.isAndroid) {
      cc.log('host.modifyFriendInteractiveStorage');
    }
  };

  _proto.getUserInteractiveStorage = function getUserInteractiveStorage(object) {
    if (this.isWechat) {
      return wx.getUserInteractiveStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getUserInteractiveStorage');
    } else if (this.isAndroid) {
      cc.log('host.getUserInteractiveStorage');
    }
  };

  _proto.getUserCloudStorage = function getUserCloudStorage(object) {
    if (this.isWechat) {
      return wx.getUserCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getUserCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.getUserCloudStorage');
    }
  };

  _proto.getSharedCanvas = function getSharedCanvas() {
    if (this.isWechat) {
      return wx.getSharedCanvas();
    } else if (this.isJkw) {
      cc.log('host.getSharedCanvas');
    } else if (this.isAndroid) {
      cc.log('host.getSharedCanvas');
    }
  };

  _proto.getPotentialFriendList = function getPotentialFriendList(object) {
    if (this.isWechat) {
      return wx.getPotentialFriendList(object);
    } else if (this.isJkw) {
      cc.log('host.getPotentialFriendList');
    } else if (this.isAndroid) {
      cc.log('host.getPotentialFriendList');
    }
  };

  _proto.getGroupCloudStorage = function getGroupCloudStorage(object) {
    if (this.isWechat) {
      return wx.getGroupCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getGroupCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.getGroupCloudStorage');
    }
  };

  _proto.getFriendCloudStorage = function getFriendCloudStorage(object) {
    if (this.isWechat) {
      return wx.getFriendCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getFriendCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.getFriendCloudStorage');
    }
  } // 开放接口-设置
  ;

  _proto.openSetting = function openSetting(object) {
    if (this.isWechat) {
      return wx.openSetting(object);
    } else if (this.isJkw) {
      cc.log('host.openSetting');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().openSetting(object);
      }
    } else if (this.isAndroid) {
      cc.log('host.openSetting');
    }
  };

  _proto.getSetting = function getSetting(object) {
    if (this.isWechat) {
      return wx.getSetting(object);
    } else if (this.isJkw) {
      cc.log('host.getSetting');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().getSetting(object);
      }
    } else if (this.isAndroid) {
      cc.log('host.getSetting');
    }
  };

  _proto.createOpenSettingButton = function createOpenSettingButton(object) {
    if (this.isWechat) {
      return wx.createOpenSettingButton(object);
    } else if (this.isJkw) {
      cc.log('host.createOpenSettingButton');
    } else if (this.isAndroid) {
      cc.log('host.createOpenSettingButton');
    }
  } // 开放接口-客服消息
  ;

  _proto.openCustomerServiceConversation = function openCustomerServiceConversation(object) {
    if (this.isWechat) {
      return wx.openCustomerServiceConversation(object);
    } else if (this.isJkw) {
      cc.log('host.openCustomerServiceConversation');
    } else if (this.isAndroid) {
      cc.log('host.openCustomerServiceConversation');
    }
  } // 开放组件-游戏圈
  ;

  _proto.createGameClubButton = function createGameClubButton(object) {
    if (this.isWechat) {
      return wx.createGameClubButton(object);
    } else if (this.isJkw) {
      cc.log('host.createGameClubButton');
      return {
        destroy: function destroy() {},
        hide: function hide() {},
        offTap: function offTap(callback) {},
        onTap: function onTap(callback) {},
        show: function show() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createGameClubButton');
      return {
        destroy: function destroy() {},
        hide: function hide() {},
        offTap: function offTap(callback) {},
        onTap: function onTap(callback) {},
        show: function show() {}
      };
    }
  } // 推荐组件
  ;

  _proto.createGamePortal = function createGamePortal(object) {
    if (this.isWechat) {
      return wx.createGamePortal(object);
    } else if (this.isJkw) {
      cc.log('host.createGamePortal');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createGamePortal');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {}
      };
    }
  };

  _proto.createGameIcon = function createGameIcon(object) {
    if (this.isWechat) {
      return wx.createGameIcon(object);
    } else if (this.isJkw) {
      cc.log('host.createGameIcon');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createGameIcon');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {}
      };
    }
  };

  _proto.createGameBanner = function createGameBanner(object) {
    if (this.isWechat) {
      return wx.createGameBanner(object);
    } else if (this.isJkw) {
      cc.log('host.createGameBanner');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createGameBanner');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    }
  } // 媒体-音频
  ;

  _proto.createInnerAudioContext = function createInnerAudioContext() {
    if (this.isWechat) {
      return wx.createInnerAudioContext();
    } else if (this.isJkw) {
      cc.log('host.createInnerAudioContext');
    } else if (this.isAndroid) {
      cc.log('host.createInnerAudioContext');
    }
  } // 非官方-版本号比较
  ;

  _proto.compareVersion = function compareVersion(v1, v2) {
    v1 = v1.split('.');
    v2 = v2.split('.');
    var len = Math.max(v1.length, v2.length);

    while (v1.length < len) {
      v1.push('0');
    }

    while (v2.length < len) {
      v2.push('0');
    }

    for (var i = 0; i < len; i++) {
      var num1 = parseInt(v1[i]);
      var num2 = parseInt(v2[i]);

      if (num1 > num2) {
        return 1;
      } else if (num1 < num2) {
        return -1;
      }
    }

    return 0;
  }
  /**
   * 判断微信版本号是否和给定值相等
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.veq = function veq(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) === 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否和给定值不等
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vne = function vne(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) !== 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否大于给定值
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vgt = function vgt(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) > 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否小于于给定值
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vlt = function vlt(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) < 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否大于等于给定值
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vge = function vge(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) >= 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否小于等于给定值
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vle = function vle(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) <= 0) {
        return success();
      } else {
        return fail();
      }
    }
  };

  _proto.vsm = function vsm() {
    if (cc.sys.platform === cc.sys.WECHAT_GAME) {
      wx.showModal({
        title: '提示',
        content: '当前微信版本过低，无法使用该功能，请升级到最新微信版本后重试。'
      });
    }
  };

  _proto.vibrateShort = function vibrateShort(obj) {
    if (cc.sys.platform === cc.sys.WECHAT_GAME) {
      wx.vibrateShort();
    }
  };

  _proto.onShareAppMessage = function onShareAppMessage(fn) {
    if (cc.sys.platform === cc.sys.WECHAT_GAME) {
      if (typeof fn === 'function') {
        wx.onShareAppMessage(fn);
      } else {
        wx.onShareAppMessage();
      }
    }
  };

  _proto.promiseLoadBundle = function promiseLoadBundle(nameOrUrl) {
    if (this.isQQ) {
      return new Promise(function (resolve, reject) {
        qq.loadSubpackage({
          name: nameOrUrl,
          success: function success(res) {
            resolve();
          },
          fail: function fail(res) {
            console.warn(nameOrUrl + " Rejected!", res);
            reject();
          }
        });
      });
    } else {
      return new Promise(function (resolve, reject) {
        cc.assetManager.loadBundle(nameOrUrl, function (err, bundle) {
          if (err) {
            reject();
          }

          resolve();
        });
      });
    }
  };

  return Host;
}();

var _default = new Host();

exports["default"] = _default;
module.exports = exports["default"];

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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