"use strict";
cc._RF.push(module, '037d4AvGBBHv7bkyLQMs/AF', 'Host');
// Script/Host.js

"use strict";

exports.__esModule = true;
exports["default"] = void 0;

var _ServerConfig = _interopRequireDefault(require("./ServerConfig"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var Host = /*#__PURE__*/function () {
  function Host() {
    this.isWechat = cc.sys.platform === cc.sys.WECHAT_GAME;
    this.isQQ = this.isWechat && _ServerConfig["default"].subPlatform === 'qq';
    this.isJkw = cc.sys.platform === cc.sys.JKW_GAME;
    this.isAndroid = cc.sys.platform === cc.sys.OS_ANDROID || cc.sys.platform === 3;
  } // 基础-系统-系统信息


  var _proto = Host.prototype;

  _proto.getSystemInfoSync = function getSystemInfoSync() {
    if (this.isWechat) {
      return wx.getSystemInfoSync();
    } else if (this.isJkw) {
      cc.log('host.getSystemInfoSync');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().getSystemInfoSync();
      }
    } else if (this.isAndroid) {
      return {
        screenWidth: cc.view.getDesignResolutionSize().width,
        screenHeight: cc.view.getDesignResolutionSize().height,
        safeArea: cc.sys.getSafeAreaRect()
      };
    }
  };

  _proto.getSystemInfo = function getSystemInfo(object) {
    if (this.isWechat) {
      return wx.getSystemInfo(object);
    } else if (this.isJkw) {
      cc.log('host.getSystemInfo');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().getSystemInfo();
      }
    } else if (this.isAndroid) {
      cc.log('host.getSystemInfo');
    }
  } // 基础-更新
  ;

  _proto.getUpdateManager = function getUpdateManager() {
    if (this.isWechat) {
      return wx.getUpdateManager();
    } else if (this.isJkw) {
      cc.log('host.getUpdateManager');
      return {
        onCheckForUpdate: function onCheckForUpdate(callback) {},
        onUpdateFailed: function onUpdateFailed(callback) {},
        onUpdateReady: function onUpdateReady(callback) {}
      };
    } else if (this.isAndroid) {
      cc.log('host.getUpdateManager');
      return {
        onCheckForUpdate: function onCheckForUpdate(callback) {},
        onUpdateFailed: function onUpdateFailed(callback) {},
        onUpdateReady: function onUpdateReady(callback) {}
      };
    }
  } // 基础-生命周期
  ;

  _proto.exitMiniProgram = function exitMiniProgram(object) {
    if (this.isWechat) {
      return wx.exitMiniProgram(object);
    } else if (this.isJkw) {
      cc.log('host.exitMiniProgram');
    } else if (this.isAndroid) {
      cc.log('host.exitMiniProgram');
    }
  } // 基础-应用级事件
  ;

  _proto.onAudioInterruptionEnd = function onAudioInterruptionEnd(callback) {
    if (this.isWechat) {
      return wx.onAudioInterruptionEnd(callback);
    } else if (this.isJkw) {
      cc.log('host.onAudioInterruptionBegin');
    } else if (this.isAndroid) {
      cc.log('host.onAudioInterruptionBegin');
    }
  };

  _proto.onAudioInterruptionBegin = function onAudioInterruptionBegin(callback) {
    if (this.isWechat) {
      return wx.onAudioInterruptionBegin(callback);
    } else if (this.isJkw) {
      cc.log('host.onAudioInterruptionBegin');
    } else if (this.isAndroid) {
      cc.log('host.onAudioInterruptionBegin');
    }
  };

  _proto.offAudioInterruptionEnd = function offAudioInterruptionEnd(callback) {
    if (this.isWechat) {
      return wx.offAudioInterruptionEnd(callback);
    } else if (this.isJkw) {
      cc.log('host.onAudioInterruptionBegin');
    } else if (this.isAndroid) {
      cc.log('host.onAudioInterruptionBegin');
    }
  };

  _proto.offAudioInterruptionBegin = function offAudioInterruptionBegin(callback) {
    if (this.isWechat) {
      return wx.offAudioInterruptionBegin(callback);
    } else if (this.isJkw) {
      cc.log('host.onAudioInterruptionBegin');
    } else if (this.isAndroid) {
      cc.log('host.onAudioInterruptionBegin');
    }
  } // 基础-订阅消息
  ;

  _proto.requestSubscribeSystemMessage = function requestSubscribeSystemMessage(object) {
    if (this.isWechat) {
      return wx.requestSubscribeSystemMessage(object);
    } else if (this.isJkw) {
      cc.log('host.requestSubscribeSystemMessage');
    } else if (this.isAndroid) {
      cc.log('host.requestSubscribeSystemMessage');
    }
  };

  _proto.requestSubscribeMessage = function requestSubscribeMessage(object) {
    if (this.isWechat) {
      return wx.requestSubscribeMessage(object);
    } else if (this.isJkw) {
      cc.log('host.requestSubscribeMessage');
    } else if (this.isAndroid) {
      cc.log('host.requestSubscribeMessage');
    }
  } // 渲染-帧率
  ;

  _proto.setPreferredFramesPerSecond = function setPreferredFramesPerSecond(fps) {
    if (this.isWechat) {
      return wx.setPreferredFramesPerSecond(fps);
    } else if (this.isJkw) {
      cc.log('host.setPreferredFramesPerSecond');
    } else if (this.isAndroid) {
      cc.log('host.setPreferredFramesPerSecond');
    }
  } // 广告
  ;

  _proto.createRewardedVideoAd = function createRewardedVideoAd(object) {
    if (this.isWechat) {
      return wx.createRewardedVideoAd(object);
    } else if (this.isJkw) {
      return AdSDK.createRewardedVideoAd(object.adUnitId, _ServerConfig["default"].videoAdId, 2);
    } else if (this.isAndroid) {
      cc.log('host.createRewardedVideoAd');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offClose: function offClose(callback) {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onClose: function onClose(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    }
  };

  _proto.createInterstitialAd = function createInterstitialAd(object) {
    if (this.isWechat) {
      return wx.createInterstitialAd(object);
    } else if (this.isJkw) {
      var obj = AdSDK.createInterstitialAd(object.adUnitId, _ServerConfig["default"].interstitialAdId, 2);
      obj.onClose = obj.onResize;
      obj.offClose = obj.offResize;
      return obj;
    } else if (this.isAndroid) {
      cc.log('host.createInterstitialAd');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offClose: function offClose(callback) {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onClose: function onClose(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    }
  };

  _proto.createBannerAd = function createBannerAd(object) {
    if (this.isWechat) {
      return wx.createBannerAd(object);
    } else if (this.isJkw) {
      cc.log('host.createBannerAd');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offClose: function offClose(callback) {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onClose: function onClose(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createBannerAd');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offClose: function offClose(callback) {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onClose: function onClose(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    }
  } // 界面-交互
  ;

  _proto.showToast = function showToast(object) {
    if (this.isWechat) {
      return wx.showToast(object);
    } else if (this.isJkw) {
      cc.log('host.showToast');
    } else if (this.isAndroid) {
      cc.log('host.showToast');
    }
  };

  _proto.showModal = function showModal(object) {
    if (this.isWechat) {
      return wx.showModal(object);
    } else if (this.isJkw) {
      cc.log('host.showModal');
    } else if (this.isAndroid) {
      cc.log('host.showModal');
    }
  };

  _proto.showLoading = function showLoading(object) {
    if (this.isWechat) {
      return wx.showLoading(object);
    } else if (this.isJkw) {
      cc.log('host.showLoading');
    } else if (this.isAndroid) {
      cc.log('host.showLoading');
    }
  };

  _proto.showActionSheet = function showActionSheet(object) {
    if (this.isWechat) {
      return wx.showActionSheet(object);
    } else if (this.isJkw) {
      cc.log('host.showActionSheet');
    } else if (this.isAndroid) {
      cc.log('host.showActionSheet');
    }
  };

  _proto.hideToast = function hideToast(object) {
    if (this.isWechat) {
      return wx.hideToast(object);
    } else if (this.isJkw) {
      cc.log('host.hideToast');
    } else if (this.isAndroid) {
      cc.log('host.hideToast');
    }
  };

  _proto.hideLoading = function hideLoading(object) {
    if (this.isWechat) {
      return wx.hideLoading(object);
    } else if (this.isJkw) {
      cc.log('host.hideLoading');
    } else if (this.isAndroid) {
      cc.log('host.hideLoading');
    }
  };

  _proto.connectSocket = function connectSocket(object) {
    if (this.isWechat) {
      return wx.connectSocket(object);
    } else if (this.isJkw) {
      cc.log('host.connectSocket');

      if (CC_PREVIEW || CC_BUILD) {
        return new WebSocket(object.url);
      }
    } else if (this.isAndroid) {
      cc.log('host.connectSocket');

      if (CC_PREVIEW || CC_BUILD) {
        return new WebSocket(object.url);
      }
    }
  };

  _proto.request = function request(object) {
    if (this.isWechat) {
      return wx.request(object);
    } else if (this.isJkw) {
      cc.log('host.request');

      if (CC_PREVIEW || CC_BUILD) {
        var xhr = cc.loader.getXMLHttpRequest();

        xhr.onreadystatechange = function () {
          if (xhr.readyState == 4) {
            cc.log('response:', xhr.status, xhr.responseURL);

            if (xhr.status >= 200 && xhr.status < 400) {
              var data = {
                data: xhr.status === 204 ? '' : JSON.parse(xhr.responseText),
                errMsg: "request:ok",
                statusCode: xhr.status
              };
              object.success && object.success(data);
            } else {
              object.fail && object.fail(xhr.status);
            }
          }
        };

        cc.log('request:', object.method, object.url);

        if (object.method.toUpperCase() === 'GET') {
          var url = object.url;

          if (object.data) {
            var first = true;
            Object.keys(object.data).forEach(function (key) {
              if (first) {
                url += '?' + key + '=' + encodeURIComponent(object.data[key]);
              } else {
                url += '&' + key + '=' + encodeURIComponent(object.data[key]);
                first = false;
              }
            });
          }

          xhr.open(object.method, url, true);
          Object.keys(object.header).forEach(function (key) {
            return xhr.setRequestHeader(key, object.header[key]);
          });
          xhr.send();
        } else {
          xhr.open(object.method, object.url, true);
          xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
          Object.keys(object.header).forEach(function (key) {
            return xhr.setRequestHeader(key, object.header[key]);
          });
          xhr.send(JSON.stringify(object.data));
        }
      }
    } else if (this.isAndroid) {
      cc.log('host.request');

      if (CC_PREVIEW || CC_BUILD) {
        var _xhr = cc.loader.getXMLHttpRequest();

        _xhr.onreadystatechange = function () {
          if (_xhr.readyState == 4) {
            cc.log('response:', _xhr.status, _xhr.responseURL);

            if (_xhr.status >= 200 && _xhr.status < 400) {
              var data = {
                data: _xhr.status === 204 ? '' : JSON.parse(_xhr.responseText),
                errMsg: "request:ok",
                statusCode: _xhr.status
              };
              object.success && object.success(data);
            } else {
              object.fail && object.fail(_xhr.status);
            }
          }
        };

        cc.log('request:', object.method, object.url);

        if (object.method.toUpperCase() === 'GET') {
          var _url = object.url;

          if (object.data) {
            var _first = true;
            Object.keys(object.data).forEach(function (key) {
              if (_first) {
                _url += '?' + key + '=' + encodeURIComponent(object.data[key]);
              } else {
                _url += '&' + key + '=' + encodeURIComponent(object.data[key]);
                _first = false;
              }
            });
          }

          _xhr.open(object.method, _url, true);

          Object.keys(object.header).forEach(function (key) {
            return _xhr.setRequestHeader(key, object.header[key]);
          });

          _xhr.send();
        } else {
          _xhr.open(object.method, object.url, true);

          _xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');

          Object.keys(object.header).forEach(function (key) {
            return _xhr.setRequestHeader(key, object.header[key]);
          });

          _xhr.send(JSON.stringify(object.data));
        }
      }
    }
  };

  _proto.showShareMenu = function showShareMenu(object) {
    if (object === void 0) {
      object = {};
    }

    if (this.isWechat) {
      return wx.showShareMenu(object);
    } else if (this.isJkw) {
      cc.log('host.showShareMenu');
    } else if (this.isAndroid) {
      cc.log('host.showShareMenu');
    }
  };

  _proto.request = function request(object) {
    if (this.isWechat) {
      return wx.request(object);
    } else if (this.isJkw) {
      cc.log('host.request');

      if (CC_PREVIEW || CC_BUILD) {
        var xhr = cc.loader.getXMLHttpRequest();

        xhr.onreadystatechange = function () {
          if (xhr.readyState == 4) {
            cc.log('response:', xhr.status, xhr.responseURL);

            if (xhr.status >= 200 && xhr.status < 400) {
              var data = {
                data: xhr.status === 204 ? '' : JSON.parse(xhr.responseText),
                errMsg: "request:ok",
                statusCode: xhr.status
              };
              object.success && object.success(data);
            } else {
              object.fail && object.fail(xhr.status);
            }
          }
        };

        cc.log('request:', object.method, object.url);
        xhr.open(object.method, object.url, true);
        xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
        Object.keys(object.header).forEach(function (key) {
          return xhr.setRequestHeader(key, object.header[key]);
        });
        xhr.send(JSON.stringify(object.data));
      }
    }
  };

  _proto.setStorageSync = function setStorageSync(key, data) {
    if (this.isWechat) {
      return wx.setStorageSync(key, data);
    } else if (this.isJkw) {
      cc.log('host.setStorageSync');
      return cc.sys.localStorage.setItem(key, JSON.stringify(data));
    } else if (this.isAndroid) {
      cc.log('host.setStorageSync');
      return cc.sys.localStorage.setItem(key, JSON.stringify(data));
    }
  };

  _proto.setStorage = function setStorage(object) {
    if (this.isWechat) {
      return wx.setStorage(object);
    } else if (this.isJkw) {
      cc.log('host.setStorage');

      try {
        cc.sys.localStorage.setItem(object.key, JSON.stringify(object.data));
        object.success && object.success();
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.setStorage');

      try {
        cc.sys.localStorage.setItem(object.key, JSON.stringify(object.data));
        object.success && object.success();
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.removeStorageSync = function removeStorageSync(key) {
    if (this.isWechat) {
      return wx.removeStorageSync(key);
    } else if (this.isJkw) {
      cc.log('host.removeStorageSync');
      return cc.sys.localStorage.removeItem(key);
    } else if (this.isAndroid) {
      cc.log('host.removeStorageSync');
      return cc.sys.localStorage.removeItem(key);
    }
  };

  _proto.removeStorage = function removeStorage(object) {
    if (this.isWechat) {
      return wx.removeStorage(object);
    } else if (this.isJkw) {
      cc.log('host.removeStorage');

      try {
        result = cc.sys.localStorage.removeItem(object.key);

        if (object.success) {
          object.success();
        }
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.removeStorage');

      try {
        result = cc.sys.localStorage.removeItem(object.key);

        if (object.success) {
          object.success();
        }
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.getStorageSync = function getStorageSync(key) {
    if (this.isWechat) {
      return wx.getStorageSync(key);
    } else if (this.isJkw) {
      cc.log('host.getStorageSync');

      var _result = cc.sys.localStorage.getItem(key);

      _result = _result === null ? '' : JSON.parse(_result);
      return _result;
    } else if (this.isAndroid) {
      cc.log('host.getStorageSync');

      var _result2 = cc.sys.localStorage.getItem(key);

      _result2 = _result2 === null ? '' : JSON.parse(_result2);
      return _result2;
    }
  };

  _proto.getStorageInfoSync = function getStorageInfoSync(object) {
    if (this.isWechat) {
      return wx.getStorageInfoSync(object);
    } else if (this.isJkw) {
      cc.log('host.getStorageInfoSync');
      var _result3 = {
        keys: [],
        currentSize: -1,
        limitSize: -1
      };

      for (var i = 0; i < cc.sys.localStorage.length; i++) {
        var value = cc.sys.localStorage.key(i);
        _result3.keys[i] = value === null ? '' : JSON.parse(value);
      }

      return _result3;
    } else if (this.isAndroid) {
      cc.log('host.getStorageInfoSync');
      var _result4 = {
        keys: [],
        currentSize: -1,
        limitSize: -1
      };

      for (var _i = 0; _i < cc.sys.localStorage.length; _i++) {
        var _value = cc.sys.localStorage.key(_i);

        _result4.keys[_i] = _value === null ? '' : JSON.parse(_value);
      }

      return _result4;
    }
  };

  _proto.getStorageInfo = function getStorageInfo(object) {
    if (this.isWechat) {
      return wx.getStorageInfo(object);
    } else if (this.isJkw) {
      cc.log('host.getStorageInfo');

      try {
        var _result5 = {
          keys: [],
          currentSize: -1,
          limitSize: -1
        };

        for (var i = 0; i < cc.sys.localStorage.length; i++) {
          var value = cc.sys.localStorage.key(i);
          _result5.keys[i] = value === null ? '' : JSON.parse(value);
        }

        object.success && object.success(_result5);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.getStorageInfo');

      try {
        var _result6 = {
          keys: [],
          currentSize: -1,
          limitSize: -1
        };

        for (var _i2 = 0; _i2 < cc.sys.localStorage.length; _i2++) {
          var _value2 = cc.sys.localStorage.key(_i2);

          _result6.keys[_i2] = _value2 === null ? '' : JSON.parse(_value2);
        }

        object.success && object.success(_result6);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.getStorage = function getStorage(object) {
    if (this.isWechat) {
      return wx.getStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getStorage');

      try {
        var _result7 = cc.sys.localStorage.getItem(key);

        _result7 = _result7 === null ? '' : JSON.parse(_result7);
        object.success && object.success(_result7);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.getStorage');

      try {
        var _result8 = cc.sys.localStorage.getItem(key);

        _result8 = _result8 === null ? '' : JSON.parse(_result8);
        object.success && object.success(_result8);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.clearStorageSync = function clearStorageSync() {
    if (this.isWechat) {
      return wx.clearStorageSync();
    } else if (this.isJkw) {
      cc.log('host.clearStorageSync');
      cc.sys.localStorage.clear();
    } else if (this.isAndroid) {
      cc.log('host.clearStorageSync');
      cc.sys.localStorage.clear();
    }
  };

  _proto.clearStorage = function clearStorage(object) {
    if (this.isWechat) {
      return wx.clearStorage(object);
    } else if (this.isJkw) {
      cc.log('host.clearStorage');

      try {
        var _result9 = cc.sys.localStorage.clear();

        object.success && object.success(_result9);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    } else if (this.isAndroid) {
      cc.log('host.clearStorage');

      try {
        var _result10 = cc.sys.localStorage.clear();

        object.success && object.success(_result10);
      } catch (error) {
        object.fail && object.fail(error);
      }

      object.complete && object.complete();
    }
  };

  _proto.getLaunchOptionsSync = function getLaunchOptionsSync() {
    if (this.isWechat) {
      return wx.getLaunchOptionsSync();
    } else if (this.isJkw) {
      cc.log('host.getLaunchOptionsSync');
      return {
        query: {},
        scene: -1,
        referrerInfo: {
          appId: 0
        }
      };
    } else if (this.isAndroid) {
      cc.log('host.getLaunchOptionsSync');
      return {
        query: {},
        scene: -1,
        referrerInfo: {
          appId: 0
        }
      };
    }
  } // 设备-剪切板
  ;

  _proto.setClipboardData = function setClipboardData(object) {
    if (this.isWechat) {
      return wx.setClipboardData(object);
    } else if (this.isJkw) {
      cc.log('host.setClipboardData');
    } else if (this.isAndroid) {
      cc.log('host.setClipboardData');
    }
  };

  _proto.getClipboardData = function getClipboardData(object) {
    if (this.isWechat) {
      return wx.getClipboardData(object);
    } else if (this.isJkw) {
      cc.log('host.getClipboardData');
    } else if (this.isAndroid) {
      cc.log('host.getClipboardData');
    }
  } // 开放接口-小程序跳转
  ;

  _proto.navigateToMiniProgram = function navigateToMiniProgram(object) {
    if (this.isWechat) {
      return wx.navigateToMiniProgram(object);
    } else if (this.isJkw) {
      cc.log('host.navigateToMiniProgram');
    } else if (this.isAndroid) {
      cc.log('host.navigateToMiniProgram');
    }
  } // 开放接口-用户信息
  ;

  _proto.getUserInfo = function getUserInfo(object) {
    if (this.isWechat) {
      return wx.getUserInfo(object);
    } else if (this.isJkw) {
      cc.log('host.getUserInfo');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().getUserInfo(object);
      }
    } else if (this.isAndroid) {
      cc.log('host.getUserInfo');
    }
  };

  _proto.getUserGameLabel = function getUserGameLabel(object) {
    if (this.isWechat) {
      return wx.getUserGameLabel(object);
    } else if (this.isJkw) {
      cc.log('host.getUserGameLabel');
    } else if (this.isAndroid) {
      cc.log('host.getUserGameLabel');
    }
  };

  _proto.createUserInfoButton = function createUserInfoButton(object) {
    if (this.isWechat) {
      return wx.createUserInfoButton(object);
    } else if (this.isJkw) {
      cc.log('host.createUserInfoButton');
      return {
        destory: function destory() {},
        hide: function hide() {},
        offTap: function offTap(callback) {},
        onTap: function onTap(callback) {},
        show: function show() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createUserInfoButton');
      return {
        destory: function destory() {},
        hide: function hide() {},
        offTap: function offTap(callback) {},
        onTap: function onTap(callback) {},
        show: function show() {}
      };
    }
  } // 开放接口-登陆
  ;

  _proto.login = function login(object) {
    if (this.isWechat) {
      return wx.login(object);
    } else if (this.isJkw) {
      cc.log('host.login');
      return object.success({
        code: '123'
      });
    } else if (this.isAndroid) {
      cc.log('host.login');
      return object.success({
        code: '123'
      });
    }
  };

  _proto.checkSession = function checkSession(object) {
    if (this.isWechat) {
      return wx.checkSession(object);
    } else if (this.isJkw) {
      cc.log('host.checkSession');
    } else if (this.isAndroid) {
      cc.log('host.checkSession');
    }
  } // 开放接口-授权
  ;

  _proto.authorize = function authorize(object) {
    if (this.isWechat) {
      return wx.authorize(object);
    } else if (this.isJkw) {
      cc.log('host.authorize');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().authorize(object);
      }
    } else if (this.isAndroid) {
      cc.log('host.authorize');
    }
  } // 开放接口-开放数据域
  ;

  _proto.onMessage = function onMessage(callback) {
    if (this.isWechat) {
      return wx.onMessage(callback);
    } else if (this.isJkw) {
      cc.log('host.onMessage');
    } else if (this.isAndroid) {
      cc.log('host.onMessage');
    }
  };

  _proto.getOpenDataContext = function getOpenDataContext() {
    if (this.isWechat) {
      return wx.getOpenDataContext();
    } else if (this.isJkw) {
      cc.log('host.getOpenDataContext');
      return {
        postMessage: function postMessage(message) {}
      };
    } else if (this.isAndroid) {
      cc.log('host.getOpenDataContext');
      return {
        postMessage: function postMessage(message) {}
      };
    }
  };

  _proto.shareMessageToFriend = function shareMessageToFriend(object) {
    if (this.isWechat) {
      return wx.shareMessageToFriend(object);
    } else if (this.isJkw) {
      cc.log('host.shareMessageToFriend');
    } else if (this.isAndroid) {
      cc.log('host.shareMessageToFriend');
    }
  };

  _proto.shareAppMessage = function shareAppMessage(object) {
    if (this.isWechat) {
      return wx.shareAppMessage(object);
    } else if (this.isJkw) {
      cc.log('host.shareAppMessage');
    } else if (this.isAndroid) {
      cc.log('host.shareAppMessage');
    }
  };

  _proto.setUserCloudStorage = function setUserCloudStorage(object) {
    if (this.isWechat) {
      return wx.setUserCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.setUserCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.setUserCloudStorage');
    }
  };

  _proto.setMessageToFriendQuery = function setMessageToFriendQuery(object) {
    if (this.isWechat) {
      return wx.setMessageToFriendQuery(object);
    } else if (this.isJkw) {
      cc.log('host.setMessageToFriendQuery');
    } else if (this.isAndroid) {
      cc.log('host.setMessageToFriendQuery');
    }
  };

  _proto.onShareMessageToFriend = function onShareMessageToFriend(object) {
    if (this.isWechat) {
      return wx.onShareMessageToFriend(object);
    } else if (this.isJkw) {
      cc.log('host.onShareMessageToFriend');
    } else if (this.isAndroid) {
      cc.log('host.onShareMessageToFriend');
    }
  };

  _proto.removeUserCloudStorage = function removeUserCloudStorage(object) {
    if (this.isWechat) {
      return wx.removeUserCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.removeUserCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.removeUserCloudStorage');
    }
  };

  _proto.onInteractiveStorageModified = function onInteractiveStorageModified(callback) {
    if (this.isWechat) {
      return wx.onInteractiveStorageModified(callback);
    } else if (this.isJkw) {
      cc.log('host.onInteractiveStorageModified');
    } else if (this.isAndroid) {
      cc.log('host.onInteractiveStorageModified');
    }
  };

  _proto.modifyFriendInteractiveStorage = function modifyFriendInteractiveStorage(object) {
    if (this.isWechat) {
      return wx.modifyFriendInteractiveStorage(object);
    } else if (this.isJkw) {
      cc.log('host.modifyFriendInteractiveStorage');
    } else if (this.isAndroid) {
      cc.log('host.modifyFriendInteractiveStorage');
    }
  };

  _proto.getUserInteractiveStorage = function getUserInteractiveStorage(object) {
    if (this.isWechat) {
      return wx.getUserInteractiveStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getUserInteractiveStorage');
    } else if (this.isAndroid) {
      cc.log('host.getUserInteractiveStorage');
    }
  };

  _proto.getUserCloudStorage = function getUserCloudStorage(object) {
    if (this.isWechat) {
      return wx.getUserCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getUserCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.getUserCloudStorage');
    }
  };

  _proto.getSharedCanvas = function getSharedCanvas() {
    if (this.isWechat) {
      return wx.getSharedCanvas();
    } else if (this.isJkw) {
      cc.log('host.getSharedCanvas');
    } else if (this.isAndroid) {
      cc.log('host.getSharedCanvas');
    }
  };

  _proto.getPotentialFriendList = function getPotentialFriendList(object) {
    if (this.isWechat) {
      return wx.getPotentialFriendList(object);
    } else if (this.isJkw) {
      cc.log('host.getPotentialFriendList');
    } else if (this.isAndroid) {
      cc.log('host.getPotentialFriendList');
    }
  };

  _proto.getGroupCloudStorage = function getGroupCloudStorage(object) {
    if (this.isWechat) {
      return wx.getGroupCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getGroupCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.getGroupCloudStorage');
    }
  };

  _proto.getFriendCloudStorage = function getFriendCloudStorage(object) {
    if (this.isWechat) {
      return wx.getFriendCloudStorage(object);
    } else if (this.isJkw) {
      cc.log('host.getFriendCloudStorage');
    } else if (this.isAndroid) {
      cc.log('host.getFriendCloudStorage');
    }
  } // 开放接口-设置
  ;

  _proto.openSetting = function openSetting(object) {
    if (this.isWechat) {
      return wx.openSetting(object);
    } else if (this.isJkw) {
      cc.log('host.openSetting');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().openSetting(object);
      }
    } else if (this.isAndroid) {
      cc.log('host.openSetting');
    }
  };

  _proto.getSetting = function getSetting(object) {
    if (this.isWechat) {
      return wx.getSetting(object);
    } else if (this.isJkw) {
      cc.log('host.getSetting');

      if (CC_PREVIEW || CC_BUILD) {
        return loadRuntime().getSetting(object);
      }
    } else if (this.isAndroid) {
      cc.log('host.getSetting');
    }
  };

  _proto.createOpenSettingButton = function createOpenSettingButton(object) {
    if (this.isWechat) {
      return wx.createOpenSettingButton(object);
    } else if (this.isJkw) {
      cc.log('host.createOpenSettingButton');
    } else if (this.isAndroid) {
      cc.log('host.createOpenSettingButton');
    }
  } // 开放接口-客服消息
  ;

  _proto.openCustomerServiceConversation = function openCustomerServiceConversation(object) {
    if (this.isWechat) {
      return wx.openCustomerServiceConversation(object);
    } else if (this.isJkw) {
      cc.log('host.openCustomerServiceConversation');
    } else if (this.isAndroid) {
      cc.log('host.openCustomerServiceConversation');
    }
  } // 开放组件-游戏圈
  ;

  _proto.createGameClubButton = function createGameClubButton(object) {
    if (this.isWechat) {
      return wx.createGameClubButton(object);
    } else if (this.isJkw) {
      cc.log('host.createGameClubButton');
      return {
        destroy: function destroy() {},
        hide: function hide() {},
        offTap: function offTap(callback) {},
        onTap: function onTap(callback) {},
        show: function show() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createGameClubButton');
      return {
        destroy: function destroy() {},
        hide: function hide() {},
        offTap: function offTap(callback) {},
        onTap: function onTap(callback) {},
        show: function show() {}
      };
    }
  } // 推荐组件
  ;

  _proto.createGamePortal = function createGamePortal(object) {
    if (this.isWechat) {
      return wx.createGamePortal(object);
    } else if (this.isJkw) {
      cc.log('host.createGamePortal');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createGamePortal');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {}
      };
    }
  };

  _proto.createGameIcon = function createGameIcon(object) {
    if (this.isWechat) {
      return wx.createGameIcon(object);
    } else if (this.isJkw) {
      cc.log('host.createGameIcon');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createGameIcon');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {}
      };
    }
  };

  _proto.createGameBanner = function createGameBanner(object) {
    if (this.isWechat) {
      return wx.createGameBanner(object);
    } else if (this.isJkw) {
      cc.log('host.createGameBanner');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    } else if (this.isAndroid) {
      cc.log('host.createGameBanner');
      return {
        destroy: function destroy() {},
        load: function load() {},
        offError: function offError(callback) {},
        offLoad: function offLoad(callback) {},
        offResize: function offResize(callback) {},
        onError: function onError(callback) {},
        onLoad: function onLoad(callback) {},
        onResize: function onResize(callback) {},
        show: function show() {},
        hide: function hide() {}
      };
    }
  } // 媒体-音频
  ;

  _proto.createInnerAudioContext = function createInnerAudioContext() {
    if (this.isWechat) {
      return wx.createInnerAudioContext();
    } else if (this.isJkw) {
      cc.log('host.createInnerAudioContext');
    } else if (this.isAndroid) {
      cc.log('host.createInnerAudioContext');
    }
  } // 非官方-版本号比较
  ;

  _proto.compareVersion = function compareVersion(v1, v2) {
    v1 = v1.split('.');
    v2 = v2.split('.');
    var len = Math.max(v1.length, v2.length);

    while (v1.length < len) {
      v1.push('0');
    }

    while (v2.length < len) {
      v2.push('0');
    }

    for (var i = 0; i < len; i++) {
      var num1 = parseInt(v1[i]);
      var num2 = parseInt(v2[i]);

      if (num1 > num2) {
        return 1;
      } else if (num1 < num2) {
        return -1;
      }
    }

    return 0;
  }
  /**
   * 判断微信版本号是否和给定值相等
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.veq = function veq(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) === 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否和给定值不等
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vne = function vne(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) !== 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否大于给定值
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vgt = function vgt(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) > 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否小于于给定值
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vlt = function vlt(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) < 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否大于等于给定值
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vge = function vge(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) >= 0) {
        return success();
      } else {
        return fail();
      }
    }
  }
  /**
   * 判断微信版本号是否小于等于给定值
   * @param {String} version 版本号
   * @param {Callback} success 成功回调
   * @param {Callback} fail 失败回调
   */
  ;

  _proto.vle = function vle(version, success, fail) {
    if (success === void 0) {
      success = function success() {};
    }

    if (fail === void 0) {
      fail = function fail() {};
    }

    if (this.isWechat) {
      if (this.compareVersion(this.getSystemInfoSync().SDKVersion, version) <= 0) {
        return success();
      } else {
        return fail();
      }
    }
  };

  _proto.vsm = function vsm() {
    if (cc.sys.platform === cc.sys.WECHAT_GAME) {
      wx.showModal({
        title: '提示',
        content: '当前微信版本过低，无法使用该功能，请升级到最新微信版本后重试。'
      });
    }
  };

  _proto.vibrateShort = function vibrateShort(obj) {
    if (cc.sys.platform === cc.sys.WECHAT_GAME) {
      wx.vibrateShort();
    }
  };

  _proto.onShareAppMessage = function onShareAppMessage(fn) {
    if (cc.sys.platform === cc.sys.WECHAT_GAME) {
      if (typeof fn === 'function') {
        wx.onShareAppMessage(fn);
      } else {
        wx.onShareAppMessage();
      }
    }
  };

  _proto.promiseLoadBundle = function promiseLoadBundle(nameOrUrl) {
    if (this.isQQ) {
      return new Promise(function (resolve, reject) {
        qq.loadSubpackage({
          name: nameOrUrl,
          success: function success(res) {
            resolve();
          },
          fail: function fail(res) {
            console.warn(nameOrUrl + " Rejected!", res);
            reject();
          }
        });
      });
    } else {
      return new Promise(function (resolve, reject) {
        cc.assetManager.loadBundle(nameOrUrl, function (err, bundle) {
          if (err) {
            reject();
          }

          resolve();
        });
      });
    }
  };

  return Host;
}();

var _default = new Host();

exports["default"] = _default;
module.exports = exports["default"];

cc._RF.pop();