"use strict";
cc._RF.push(module, '079bcZq4oZM+ZaR08X6uxoX', 'inviteUI');
// Script/inviteUI.js

"use strict";

var _Host = _interopRequireDefault(require("./Host"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

cc.Class({
  "extends": cc.Component,
  properties: {
    wxSubContextView: {
      "default": null,
      type: cc.Node
    }
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {},
  init: function init() {
    this.initShareCanvas();
    this.initSubContext();
  },
  initSubContext: function initSubContext() {
    //设置定向分享参数（这里假设1代表的是邀请新玩家场景值）
    _Host["default"].vge('2.9.0', function () {
      _Host["default"].setMessageToFriendQuery({
        shareMessageToFriendScene: 1
      });
    });

    _Host["default"].vge('2.9.4', function () {
      _Host["default"].onShareMessageToFriend(function (res) {
        var tips = res.success ? '分享成功' : '分享失败';

        _Host["default"].showToast({
          title: tips,
          icon: 'none',
          duration: 2000
        });
      });
    });

    var openDataContext = _Host["default"].getOpenDataContext();

    console.log('test');
    openDataContext.postMessage({
      type: 'showInviteUI'
    });
    this.wxSubContextView.active = true;
    this.wxSubContextView.getComponent(cc.WXSubContextView).enabled = true;
    this.wxSubContextView.getComponent(cc.WXSubContextView).updateSubContextViewport();
  },

  /**
   * 隐藏分享界面
   */
  hideInvite: function hideInvite() {
    var openDataContext = _Host["default"].getOpenDataContext();

    openDataContext.postMessage({
      type: 'hideInviteUI'
    });
    this.wxSubContextView.active = false;
    this.wxSubContextView.getComponent(cc.WXSubContextView).enabled = false;
    this.wxSubContextView.getComponent(cc.WXSubContextView).updateSubContextViewport();
  },
  start: function start() {},
  getUserInteractiveData: function getUserInteractiveData() {
    // 获取用户的加密交互数据
    _Host["default"].vge('2.7.7', function () {
      _Host["default"].getUserInteractiveStorage({
        keyList: ['2'],
        success: function success(res) {
          var encryptedData = res.encryptedData;
          var iv = res.iv;
          api.shareToFriend(encryptedData, iv);
        }
      });
    });
  },
  initShareCanvas: function initShareCanvas() {
    var openDataContext = _Host["default"].getOpenDataContext();

    this.sharedCanvas = openDataContext.canvas;

    var _host$getSystemInfoSy = _Host["default"].getSystemInfoSync(),
        windowWidth = _host$getSystemInfoSy.windowWidth,
        windowHeight = _host$getSystemInfoSy.windowHeight; //WxSubContextView节点尺寸


    var width = 750;
    var height = 1334; //画布尺寸

    var canvasWidth = 750;
    var canvasHeight = 1334;
    var x = 0;
    var y = 0;
    var realWidth = width / canvasWidth * windowWidth;
    var realHeight = height / canvasHeight * windowHeight;
    var realX = x / canvasWidth * windowWidth;
    var realY = y / canvasHeight * windowHeight;
    openDataContext.postMessage({
      type: 'updateViewPort',
      box: {
        width: realWidth,
        height: realHeight,
        x: realX,
        y: realY
      }
    });
  },

  /**
   * 带参分享
   */
  inviteWeChatFriend: function inviteWeChatFriend() {
    wx.shareAppMessage({
      title: '点一下，玩一年，装备不花一分钱！',
      imageUrl: '',
      success: function success(res) {// 转发成功
      },
      fail: function fail(res) {// 转发失败
      }
    });
    this.hideInvite();
  }
});

cc._RF.pop();