

import { _decorator, Node, UITransform, BoxCollider2D, v2, PhysicsSystem2D, PHYSICS_2D_PTM_RATIO, Component } from 'cc';
import { Player } from './Player';

const { ccclass, property } = _decorator;


@ccclass('Main')
export class Main extends Component {

    onLoad() {

        this.initSetShowAssets();

        this._initPlayer();

        this._initFloorCollider2D();
    }

    initSetShowAssets() {
        PhysicsSystem2D.instance.enable = true;
        PhysicsSystem2D.instance.gravity = v2(0, -50 * PHYSICS_2D_PTM_RATIO);
    }



    /**初始化玩家 */
    private _initPlayer() {
        let player: Node = this.node.getChildByName("player");
        player.addComponent(Player);
    }

    /**初始化地板碰撞器 */
    private _initFloorCollider2D() {
        let floor: Node = this.node.getChildByName("map");
 
        floor.children.forEach((value: Node) => {
            let uiTransfrom: UITransform = value.getComponent(UITransform);
            let boxCollider2D: BoxCollider2D = floor.addComponent(BoxCollider2D);
            boxCollider2D.size = uiTransfrom.contentSize;
            boxCollider2D.offset = v2(value.position.x, value.position.y);
            boxCollider2D.apply();
        })
    }
}

