import { Node, Component, Contact2DType, EventKeyboard, input, Input, KeyCode, RigidBody2D, v2, v3, Vec2, Vec3, _decorator } from "cc";

const { ccclass, property } = _decorator;



@ccclass('Player')
export class Player extends Component {

    private _rigidbody: RigidBody2D = null;

    onLoad() {
        this._rigidbody = this.node.getComponent(RigidBody2D);
    }

    onEnable() {
        this.bindKeyboardEvent();
    }
    onDisable() {
        this.removeKeyboardEvent();
    }

    update() {
        this._move();
    }

    //#region 移动控制

    private _jump() {
        let point: Vec2 = v2();
        this._rigidbody.getWorldCenter(point);
        this._rigidbody.applyLinearImpulse(v2(0, 50), point, true);
    }

    private _move() {
        //左右移动控制
        if (this._moveDirection.x != 0) {
            let point: Vec2 = v2();
            this._rigidbody.getWorldCenter(point);
            this._rigidbody.applyLinearImpulse(v2(this._moveDirection.x ), point, true);
        }
    }

    //#endregion


    //#region 键盘事件

    /**老方向 */
    private _oldDirection: { w: boolean, s: boolean, a: boolean, d: boolean } = { w: false, s: false, a: false, d: false };
    /**移动方向 */
    private _moveDirection: Vec2 = v2();

    /**绑定键盘事件 */
    private bindKeyboardEvent() {
        input.on(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.on(Input.EventType.KEY_UP, this.onKeyUp, this);
    }
    /**移除键盘事件 */
    private removeKeyboardEvent() {
        input.off(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.off(Input.EventType.KEY_UP, this.onKeyUp, this);
    }
    private onKeyDown(event: EventKeyboard) {
        switch (event.keyCode) {
            case KeyCode.ARROW_UP:
            case KeyCode.KEY_W:
                this._oldDirection.w = true;
                this._moveDirection.y = 1;
                break;
            case KeyCode.ARROW_DOWN:
            case KeyCode.KEY_S:
                this._oldDirection.s = true;
                this._moveDirection.y = -1;
                break;
            case KeyCode.ARROW_LEFT:
            case KeyCode.KEY_A:
                this._oldDirection.a = true;
                this._moveDirection.x = -1;
                break;
            case KeyCode.ARROW_RIGHT:
            case KeyCode.KEY_D:
                this._oldDirection.d = true;
                this._moveDirection.x = 1;
                break;
            case KeyCode.SPACE:
                this._jump();
                break;
        }
    }
    private onKeyUp(event: EventKeyboard) {
        switch (event.keyCode) {
            case KeyCode.ARROW_UP:
            case KeyCode.KEY_W:
                this._oldDirection.w = false;
                this._moveDirection.y = this._oldDirection.s ? -1 : 0;
                break;
            case KeyCode.ARROW_DOWN:
            case KeyCode.KEY_S:
                this._oldDirection.s = false;
                this._moveDirection.y = this._oldDirection.w ? 1 : 0;
                break;
            case KeyCode.ARROW_LEFT:
            case KeyCode.KEY_A:
                this._oldDirection.a = false;
                this._moveDirection.x = this._oldDirection.d ? 1 : 0;
                break;
            case KeyCode.ARROW_RIGHT:
            case KeyCode.KEY_D:
                this._oldDirection.d = false;
                this._moveDirection.x = this._oldDirection.a ? -1 : 0;
                break;
        }
    }


    //#endregion
}