const fs = require('fs');
/**项目路径 */
var pro_path = '';

/// 执行如:node FilterProChinese.js -path /Users/workSpace/demo
// Parse arguments
var i = 2;
while (i < process.argv.length) {
    var arg = process.argv[i];
    switch (arg) {
        case '-path':
            pro_path = process.argv[i + 1];
            i += 2;
            break;
        default:
            i++;
            break;
    }
}
if (pro_path) {
    main();
} else {
    console.log('没有路径');
}


function main() {
    let allFiles = getDirAllFiles(pro_path);
    console.log('文件总数:', allFiles.length);
    if (!allFiles) return;
    if (allFiles.length === 0) {
        return;
    }
    let obj = getAllFiles(allFiles);
    /**所有预制中的字符串 */
    let AllPFStr = '';
    for (let i = 0; i < obj.allPFFilePaths.length; i++) {
        let filePath = obj.allPFFilePaths[i];
        // 同步读取文件内容
        let content = fs.readFileSync(filePath).toString();
        let contentObj = JSON.parse(content);
        for (let index = 0; index < contentObj.length; index++) {
            const element = contentObj[index];
            if (element['_N$string']) {
                AllPFStr += element['_N$string'];
            }
        }
    }
    /**所有脚本中的字符串 */
    let AllScStr = '';
    for (let i = 0; i < obj.allScriptFilePaths.length; i++) {
        let filePath = obj.allScriptFilePaths[i];
        // 同步读取文件内容
        let content = fs.readFileSync(filePath).toString();
        content = removeJsComments(content);
        AllScStr += content
        console.log('content:', content);
    }

    /**所有json字符串 */
    let AllJsonStr = '';
    for (let i = 0; i < obj.allJsonFilePaths.length; i++) {
        let filePath = obj.allJsonFilePaths[i];
        // 同步读取文件内容
        let content = fs.readFileSync(filePath).toString();
        AllJsonStr += content;
    }
    let reg = /[\u4E00-\u9FA5]/g;
    let allstr = AllJsonStr + AllScStr + AllPFStr;
    let chiStr = allstr.match(reg);
    let str = uniq(chiStr).join('');
    str += '。？！，、；：“”‘’（ ）[]{}．《》〈〉·_—/';
    str += 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
    str += `~!@#$%^&*()[]{}<>_+−=<>.,:;?-/\\|"'`;
    let mingl = `java -jar sfnttool.jar -s '${str}' SongTi.ttf sub.ttf`;
    console.log(mingl);
    return true;
}


function uniq(array) {
    var temp = []; //一个新的临时数组
    for (var i = 0; i < array.length; i++) {
        if (temp.indexOf(array[i]) == -1) {
            temp.push(array[i]);
        }
    }
    return temp;
}

function removeJsComments(code) {
    return code.replace(/(?:^|\n|\r)\s*\/\*[\s\S]*?\*\/\s*(?:\r|\n|$)/g, '\n').replace(/(?:^|\n|\r)\s*\/\/.*(?:\r|\n|$)/g, '\n');
}


/**
 * 递归遍历，获取指定文件夹下面的所有文件路径
 */
function getAllFiles(allFilePaths) {
    /**所有预制文件*/
    let allPFFilePaths = [];
    /**所有脚本文件 */
    let allScriptFilePaths = [];
    /**所有json文件 */
    let allJsonFilePaths = [];
    for (let index = 0; index < allFilePaths.length; index++) {
        const currentFilePath = allFilePaths[index];
        console.log('currentFilePath', currentFilePath);
        let regSc = /\.(js|ts)$/;
        let regPf = /\.(prefab)$/;
        let regJs = /\.(json)$/;

        if (regPf.test(currentFilePath)) {
            allPFFilePaths.push(currentFilePath);
        } else if (regJs.test(currentFilePath)) {
            allJsonFilePaths.push(currentFilePath);
        } else if (regSc.test(currentFilePath)) {
            allScriptFilePaths.push(currentFilePath);
        }
    }
    console.log('预制文件个数', allPFFilePaths.length);
    console.log('脚本文件个数', allScriptFilePaths.length);
    console.log('json文件个数', allJsonFilePaths.length);

    return {
        allPFFilePaths: [...allPFFilePaths],
        allScriptFilePaths: [...allScriptFilePaths],
        allJsonFilePaths: [...allJsonFilePaths]
    };
}

function getDirAllFiles(filePath) {
    let allFilePaths = [];
    if (fs.existsSync(filePath)) {
        const files = fs.readdirSync(filePath);
        for (let i = 0; i < files.length; i++) {
            let file = files[i]; // 文件名称（不包含文件路径）
            let currentFilePath = filePath + '/' + file;
            let stats = fs.lstatSync(currentFilePath);
            if (stats.isDirectory()) {
                allFilePaths = allFilePaths.concat(getDirAllFiles(currentFilePath));
            } else {
                allFilePaths.push(currentFilePath);
            }
        }
    } else {
        console.warn(`指定的目录${filePath}不存在！`);
        return null;
    }

    return allFilePaths;
}