import { _decorator, Component, Node, Prefab, instantiate, CCInteger, Layout, UITransform } from 'cc';
import { Tile } from './Tile';
const { ccclass, property } = _decorator;

@ccclass('Reel')
export class Reel extends Component {

    @property(Node)
    reelIn = null;

    private tileHieght = 0;

    @property(CCInteger)
    private _tileSum: number = 0;

    @property(CCInteger)
    get tileSum() {
        return this._tileSum;
    }

    set tileSum(inNum: number) {
        this._tileSum = Math.floor(inNum);
        this.resetReelView();
    }

    @property(CCInteger)
    _showTileNum: number = 1;

    @property(CCInteger)
    get showTileNum() {
        return this._showTileNum;
    }

    set showTileNum(inNum: number) {
        this._showTileNum = Math.floor(inNum);
        if (inNum >= 1 && this.tileSum > 0) {
            this.resetReelView();
            let layout: Layout = this.reelIn.getComponent(Layout);
            let sizeH = (inNum - 1) * layout.spacingY + inNum * this.tileHieght;
            this.node.getComponent(UITransform).height = sizeH;
        }
    }

    @property({ type: Prefab })
    _tilePrefab: Prefab = null;

    @property({ type: Prefab })
    get tilePrefab(): Prefab {
        return this._tilePrefab;
    }

    set tilePrefab(inPrefab: Prefab) {
        this._tilePrefab = inPrefab;
        this.resetReelView();
    }

    resetReelView() {
        // this.reelIn.destroyAllChildren();
        this._tilePrefab && this.createReel();
        // this._tilePrefab && this.shuffle();
    }

    createPrefabInstance(node: Node) {
        // @ts-ignore
        const prefabInfo = node._prefab;
        if (prefabInfo) {
            const prefabInstance = new Prefab._utils.PrefabInstance();
            prefabInstance.fileId = node.uuid;
            prefabInfo.instance = prefabInstance;
        }
    }

    createReel() {
        for (let index = 0; index < this.tileSum; index++) {
            const node = instantiate(this.tilePrefab);
            // this.createPrefabInstance(node);
            this.reelIn.addChild(node);
        }
    }

    shuffle() {
        for (let index = 0; index < this.reelIn.children.length; index++) {
            // this.reelIn.children[index].getComponent(Tile).randomTex();
            this.tileHieght = this.reelIn.children[index].getComponent(UITransform).height;
        }
    }
}


