import { _decorator, Component, Node, SpriteFrame, Sprite } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Tile')
export class Tile extends Component {

    @property(Sprite)
    tileSp: Sprite = null;

    @property([SpriteFrame])
    textures = [];

    /* 纹理总数 */
    get tileTexSum() {
        return this.textures.length;
    }

    setTileTex(index: number): void {
        // this.tileSp.spriteFrame = this.textures[index];
    }

    randomInt(min: number, max: number): number {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    };

    randomTex() {
        const index = this.randomInt(0, this.textures.length - 1);
        this.setTileTex(index);
        console.log("fjakfaefae33wfaf")
    }
}


