
import { getPointA2BAngle } from "../Framework/Utility/dx/getPointA2BAngle";
import { PointUtility } from "../Framework/Utility/PointUtility";

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Camera)
    camera: cc.Camera = null;

    @property(cc.Node)
    gameBg: cc.Node = null;

    @property(cc.Node)
    whiteBall: cc.Node = null;

    @property(cc.Node)
    targetBall: cc.Node = null;

    //瞄准辅助线 
    @property(cc.Node)
    boresightNode: cc.Node = null;
    boresight: cc.Graphics = null;

    //半径
    ballRadius: number = 25;
    //瞄准线
    boresightLength: number = 200;

    onLoad() {
        this.gameBg.on(cc.Node.EventType.TOUCH_START, this.onPowerTouch, this);
        this.gameBg.on(cc.Node.EventType.TOUCH_MOVE, this.onPowerTouch, this);
        this.gameBg.on(cc.Node.EventType.TOUCH_END, this.onPowerTouch, this);
    }

    start() {
        this.boresight = this.boresightNode.addComponent(cc.Graphics);
        this.boresight.lineWidth = 5;
        this.boresight.strokeColor = cc.Color.WHITE;
        this.boresight.fillColor = cc.color(0, 255, 0, 255);

    }

    onPowerTouch(evt: cc.Event.EventTouch) {
        this.boresight.clear();

        let pos = evt.getLocation();
        let whiteWorldPos = this.whiteBall.convertToWorldSpaceAR(cc.v2());
        let targetWorldPos = this.targetBall.convertToWorldSpaceAR(cc.v2());

        let distance = PointUtility.getInsertPointBetweenCircleAndLine(whiteWorldPos.x, whiteWorldPos.y, pos.x, pos.y, targetWorldPos.x, targetWorldPos.y, this.ballRadius * 2, whiteWorldPos);

        //画圆
        if (distance > 0) {
            let shootAngle = getPointA2BAngle(whiteWorldPos, pos);
            let posB = PointUtility.LengthenPoint(whiteWorldPos, shootAngle, distance);
            this.boresight.circle(posB.x, posB.y, this.ballRadius);

            let originPos = PointUtility.LengthenPoint(whiteWorldPos, shootAngle, this.ballRadius);
            let targetPos = PointUtility.LengthenPoint(originPos, shootAngle, distance - this.ballRadius);
            if (distance > this.ballRadius * 2)
                this.drawLine(originPos, shootAngle, distance - this.ballRadius * 2, false, 0, false, 0);

            let angle = getPointA2BAngle(targetPos, targetWorldPos);
            let curRangle = angle - shootAngle;
            if (Math.abs(curRangle) > 270) curRangle = Math.abs(Math.abs(curRangle) - 360);
            let curLength = this.boresightLength - Math.abs(curRangle) / 2;
            if (curLength > this.boresightLength - 10)
                curLength = this.boresightLength - 10;
            if (curLength < 0) curLength = 0;
            let distance1 = PointUtility.Distance(targetPos, targetWorldPos);
            let extendPos = PointUtility.LengthenPoint(targetPos, angle, distance1 + this.ballRadius + 2);
            this.drawLine(extendPos, angle, curLength, false, 0, false, 0);
            let originPos1 = PointUtility.LengthenPoint(whiteWorldPos, shootAngle, distance);
            let angle1 = shootAngle > angle ? angle + 90 : angle - 90;
            if (shootAngle < -90 && angle > 90) angle1 = angle + 90;
            else if (shootAngle > 90 && angle < -90) angle1 = angle - 90;
            let targetPos2 = PointUtility.LengthenPoint(originPos1, angle1, this.ballRadius);
            this.drawLine(targetPos2, angle1, this.boresightLength - curLength, false, 0, false, 0);
            this.boresight.stroke();
        }
    }


    /**封装画线api */
    protected drawLine(startPos: cc.Vec2, angle: number, length: number, showStartCircle?: boolean, startCircleR?: number, showEndCircle?: boolean, endCircleR?: number) {
        angle = cc.misc.degreesToRadians(angle);
        if (!startCircleR) startCircleR = 0;
        if (!endCircleR) endCircleR = 0;
        let velocity = cc.v2(Math.cos(angle), Math.sin(angle));
        let fromPos = velocity.mul(startCircleR).addSelf(startPos);
        if (showStartCircle) this.boresight.circle(startPos.x, startPos.y, startCircleR);
        this.boresight.moveTo(fromPos.x, fromPos.y);
        length = length - endCircleR;
        let targetPos = velocity.mul(length).addSelf(startPos);
        this.boresight.lineTo(targetPos.x, targetPos.y);
        let hitPos = velocity.mul(length + endCircleR).addSelf(startPos);
        if (showEndCircle) this.boresight.circle(hitPos.x, hitPos.y, endCircleR);
        return hitPos;
    }
}
