import * as fs from "fs";
import FileList from "./FileList.js";

export default class CompareFileList {

    _dir1 = "";
    _dir2 = "";
    _outDir = "";

    _fl1 = null;
    _fl2 = null;

    _arrName1 = [];
    _arrName2 = [];

    _mapName1 = new Map();
    _mapName2 = new Map();

    constructor( dir1, dir2, outDir ){
        const self = this;
        self._dir1 = dir1;
        self._dir2 = dir2;
        self._outDir = outDir;
    }

    initData(){
        console.log( "---------init Dir Data-----------" );
        const self = this;
        self._fl1 = new FileList();
        self._fl1.initData( self._dir1 );

        self._fl2 = new FileList();
        self._fl2.initData( self._dir2 );
    }

    initShorName(){
        console.log( "---------init short name-----------" );
        const self = this;
        self._arrName1 = self._fl1.getShortName();
        for( const name of self._arrName1 ){
            self._mapName1.set( name, false );
        }
        
        self._arrName2 = self._fl2.getShortName();
        for( const name of self._arrName2 ){
            self._mapName2.set( name, false );
        }
    }

    //创建文件夹
    createDir( dir ){
        if (!fs.existsSync(dir)) {
            fs.mkdirSync(dir, { recursive: true });
        }
    }

    //循环创建文件夹
    createDirDeep( basePath, arrDir ){
        let dir = basePath;
        for( const dirTmp of arrDir ){
            dir += dirTmp + "/";
            this.createDir( dir );
        }
    }

    createDirWithFileName( fileName ){
        const self = this
        const arrDir = fileName.split( "/" );
        if( arrDir.length > 1 ){
            arrDir.splice( arrDir.length - 1, 1 );
            self.createDirDeep( self._outDir, arrDir );
        }
    }

    compare(){
        console.log( "---------compare file list-----------" );
        const self = this;
        for( const name of self._arrName2 ){
            self._mapName1.set( name, true );
        }

        const arrLost2 = [];
        self._mapName1.forEach((bExist, name)=>{
            if( !bExist ){
                const filePath = self._fl1.getFilePath( name );
                arrLost2.push( filePath + "/" + name );
            }
        });
        if( arrLost2.length > 0 ){
            console.log( "------dir2 file lost in dir1------" );
            for( const name of arrLost2 ){
                console.log( name );

                self.createDirWithFileName( name );
                fs.copyFileSync( self._dir1 + name, self._outDir + name );
            }
            console.log( "" );
        }

        for( const name of self._arrName2 ){
            self._mapName2.set( name, true );
        }
        const arrLost1 = [];
        self._mapName2.forEach((bExist, name)=>{
            if( !bExist ){
                const filePath = self._fl2.getFilePath( name );
                arrLost1.push( filePath + "/" + name );
            }
        });
        if( arrLost1.length > 0 ){            
            console.log( "------dir1 file lost in dir2------" );
            for( const name of arrLost1 ){
                console.log( name );
            }
            console.log( "" );
        }
    }

    run(){
        console.log( "=========start compare file list=========" );
        const self = this;

        self.initData();
        self.initShorName();
        self.compare();        
        
        console.log( "=========compare file list finished=========" );
    }

}