import * as fs from "fs";

export default class DeleteEmptyDir {

    _dir = "";

    constructor( dir ){
        const self = this;
        self._dir = dir;
    }

    run(){
        console.log( "=========start delete empty dir=========" );
        const self = this;
        self.deleteEmpty( self._dir );
        console.log( "=========delete empty dir finished=========" );
    }

    deleteEmpty( dir ){
        const self = this;
        const files = fs.readdirSync( dir );

        for( const name of files ){
            const stat = fs.statSync( dir + name + "/" );
            if( !stat.isDirectory() ) continue;
            self.deleteEmpty( dir + name + "/" );
        }

        const files2 = fs.readdirSync( dir );
        if( files2.length == 0 ){
            console.log( "delete dir:" + dir );
            fs.rmdirSync( dir );
        }
    }

}