import * as fs from "fs";
import * as path from "path"

export default class FileTool {

    //判定文件存在
    static exist( filePath ){
        return fs.existsSync(filePath);
    }

    //创建文件夹
    static createDir( dir ){
        if (!fs.existsSync(dir)) {
            fs.mkdirSync(dir, { recursive: true });
        }
    }

    //循环创建文件夹
    static createDirDeep( basePath, arrDir ){
        let dir = basePath;
        for( const dirTmp of arrDir ){
            dir += dirTmp + "/";
            FileTool.createDir( dir );
        }
    }

    //根据文件名创建文件夹
    static createDirWithFileName( fileName ){
        let basePath = "./";
        const sIdx = fileName.indexOf( ":" );
        if( sIdx != -1 ){
            basePath = fileName.substr( 0, sIdx + 1 );
        }
        fileName = fileName.substr( sIdx+1 );

        const arrDir = fileName.split( "/" );
        if( arrDir.length > 1 ){
            arrDir.splice( arrDir.length - 1, 1 );
            FileTool.createDirDeep( basePath, arrDir );
        }
    }

    //读取文件
    static readFile( fileName, options = "utf8" ){
        return fs.readFileSync( fileName, options );
    }

    //读取json
    static readJsonInFile( fileName ){
        const str = FileTool.readFile( fileName );
        let jsonData = null;
        try {        
            jsonData = JSON.parse( str );
        } catch (error) {
            console.error( "JSON parse meta file error, file:" + fileName );
            console.error( error );
            return null;
        }
        return jsonData;
    }

    //写出文件
    static writeFile( fileName, data, options = null ){
        FileTool.createDirWithFileName( fileName );
        fs.writeFileSync( fileName, data, options );
    }

    //写出json
    static writeJsonToFile( fileName, jsonData ){
        FileTool.writeFile( fileName, JSON.stringify(jsonData, null, 2) );
    }

    //清空文件夹
    static deleteAllFilesSync(folderPath) {
        try {
            // 读取文件夹内容
            const files = fs.readdirSync(folderPath);
            
            // 遍历并删除每个文件
            files.forEach(file => {
            const filePath = path.join(folderPath, file);
            
            // 检查是否是文件（不是目录）
            if (fs.statSync(filePath).isFile()) {
                fs.unlinkSync(filePath);
            }
            });
            
            return true;
        } catch (err) {
            console.error('删除文件时出错:', err);
            return false;
        }
    }

}