
import * as xlsx from "node-xlsx";
import FileTool from "./FileTool.js";

export default class ReadExcelTxt {

    _excelPath = "";

    _szMap = [];

    constructor( excelPath ){
        const self = this;
        self._excelPath = excelPath;
    }

    readExcel(){
        const self = this;
        console.log( "---------read excel---------" );
        if( !FileTool.exist(self._excelPath) ){
            console.log( "file not exist !" );
            console.log( self._excelPath );
            return false;
        }

        const content = xlsx.parse( self._excelPath );
        const data = content[0].data;
        for( let i=2; i<data.length; ++i ){
            const row = data[i];
            const id = row[0];
            for( let j=3; j<row.length; ++j ){
                self.addTxt( j-3, id, row[j] );
            }
        }
        return true;
    }

    clearTxtDir(){
        console.log( "---------delete old file---------" );
        return FileTool.deleteAllFilesSync( "./txt/" );
    }

    writeTxt(){
        const self = this;
        console.log( "---------write txt---------" );
        for( let i=0; i<self._szMap.length; ++i ){
            FileTool.writeJsonToFile( `./txt/txt_${(i+3)}.json`, self._szMap[i] );
        }
    }

    addTxt( idx, id, str ){
        const self = this;
        if( self._szMap[idx] == null ){
            self._szMap[idx] = {};
        }

        const map = self._szMap[idx];
        map[ "txt_" + id ] = str;
    }

    run(){
        console.log( "=========start ReadExcelTxt=========" );
        const self = this;

        if( !self.clearTxtDir() ) return;
        if( !self.readExcel() ) return;
        self.writeTxt();

        console.log( "=========ReadExcelTxt finished=========\n\n" );
    }

}