import CopyPng from "./CopyPng.js";
import DeleteEmptyDir from "./DeleteEmptyDir.js";
import * as fs from "fs";
import PngFileDiff from "./PngFileDiff.js";
import CompareFileList from "./CompareFileList.js";
import FindTxtInSearch from "./FindTxtInSearch.js";
import CheckNotUsedRes from "./CheckNotUsedRes.js";
import { AutoAtlas } from "./AutoAtlas/AutoAtlas.js";
import ReadExcelTxt from "./ReadExcelTxt.js";

const printHelp = function(){
    const str = fs.readFileSync( "./README.txt", "utf-8" );
    console.log( str );
}

//导出所有的png
const copyPng = function( dir, arrExclude, outPath ){
    if( dir == null ){
        console.log( "please input dir !" );
        return;
    }

    if( outPath == null ){        
        console.log( "please input out dir !" );
        return;
    }

    const copy = new CopyPng();
    copy.setOutDir( outPath );
    copy.setPath( dir, arrExclude,  );
    copy.run();
}


//删除空文件夹
const deleteEmptyDir = function( dir ){
    if( dir == null ){
        console.error( "deleteEmptyDir dir is null" );
        return;
    }
    const tool = new DeleteEmptyDir( dir );
    tool.run();
}

//比对两个目录 导出enDir缺失图片
const pngFileDiff = function( cnDir, enDir, outDir ){
    if( cnDir == null ){
        console.log( "please input srcDir" );
        return;
    }

    if( enDir == null ){
        console.log( "please input srcDir2" );
        return;
    }

    if( outDir == null ){
        console.log( "please input outDir" );
        return;
    }

    const diff = new PngFileDiff();
    diff.setDir( cnDir, enDir, outDir );
    diff.run();
}

//对比两个目录的文件差异
const getFileLostInDir = function( dir1, dir2, outDir ){
    if( dir1 == null || dir2 == null || outDir == null ){
        console.log( "please input dir !" );
        return;
    }

    const tool = new CompareFileList( dir1, dir2, outDir );
    tool.run();
}

//通过代码搜索保存的文件 找到txt的key 再对比cnTxt 得到使用的txt 并保存
const findTxtKeyBySearchLog = function( logFile, cnTxt, outFile ){
    if( logFile == null || logFile == "" ){
        console.log( "please input log file path !" );
        return;
    }

    if( cnTxt == null || cnTxt == "" ){
        console.log( "please input cnTxt file" );
        return;
    }

    if( outFile == null || outFile == "" ){
        console.log( "please input out file path !" );
        return;
    }

    const tool = new FindTxtInSearch( logFile, cnTxt, outFile );
    tool.run();
}

//查找未使用的资源
const checkResNotUsed = function( assetDir, resDir ){
    if( assetDir == null || assetDir == "" ){
        console.log( "please input asset dir !" );
        return;
    }

    if( resDir == null || resDir == "" ){
        console.log( "please input res dir !" );
        return;
    }

    const tool = new CheckNotUsedRes( assetDir, resDir );
    tool.run();
}

//添加自动图集
const addAutoAtlas = function( assetDir ){
    if( assetDir == null || assetDir == "" ){
        console.log( "please input asset dir !" );
        return;
    }

    const tool = new AutoAtlas( assetDir );
    tool.run();
}

//excel 转 txt
const excel2txt = function( excelPath ){
    const tool = new ReadExcelTxt( excelPath );
    tool.run();
}

const runParams = process.argv.splice(2);
if( runParams[0] == "copyPng" ){
    const dirPath = runParams[1];
    let arrExclude = [];
    if( runParams[3] != null ){
        arrExclude = runParams[2].split( "&" );
    }
    copyPng( dirPath, runParams[2], arrExclude );
}
else if( runParams[0] == "deleteEmptyDir" ){
    deleteEmptyDir( runParams[1] );
}
else if( runParams[0] == "pngDiff" ){
    const cnDir = runParams[1];
    const enDir = runParams[2];
    const outDir = runParams[3];
    pngFileDiff( cnDir, enDir, outDir );
}
else if( runParams[0] == "getFileLostInDir" ){
    getFileLostInDir( runParams[1], runParams[2], runParams[3] );
}
else if( runParams[0] == "findTxtInSearch" ){
    findTxtKeyBySearchLog( runParams[1], runParams[2], runParams[3] );
}
else if( runParams[0] == "findNotUsedRes" ){
    checkResNotUsed( runParams[1], runParams[2] );
}else if( runParams[0] == "addAutoAtlas" ){
    addAutoAtlas( runParams[1] );
}else if( runParams[0] == "excel2txt" ){
    excel2txt( runParams[1] );
}
else{
    //printHelp();
    //console.log( "please input run params !\n" );
    excel2txt( "./excel/StringUI.xlsx" );
}