System.register(["__unresolved_0", "__unresolved_1"], function (_export, _context) {
  "use strict";

  var _req, _loader, _cjsExports, __cjsMetaURL;

  _export("default", void 0);

  return {
    setters: [function (_unresolved_) {
      _req = _unresolved_.__cjsMetaURL;
    }, function (_unresolved_2) {
      _loader = _unresolved_2.default;
    }],
    execute: function () {
      _loader.define(_context.meta.url, function (exports, _require, module, __filename, __dirname) {
        var require = _loader.createRequireWithReqMap({
          "./node": _req
        }, _require);

        (function () {
          Object.defineProperty(exports, "__esModule", {
            value: true
          });
          exports.Grid = void 0;

          var node_1 = require("./node");

          var Grid = /*#__PURE__*/function () {
            function Grid(aParams) {
              // Set the general properties
              if (aParams.width && aParams.height) {
                this.width = aParams.width;
                this.height = aParams.height;
                this.numberOfFields = this.width * this.height;
              } else if (aParams.matrix) {
                this.width = aParams.matrix[0].length;
                this.height = aParams.matrix.length;
                this.numberOfFields = this.width * this.height;
              } // Create and generate the matrix


              this.gridNodes = this.buildGridWithNodes(aParams.matrix || undefined, this.width, this.height, aParams.densityOfObstacles || 0);
            }
            /**
             * Build grid, fill it with nodes and return it.
             * @param matrix [ 0 or 1: 0 = walkable; 1 = not walkable ]
             * @param width [grid width]
             * @param height [grid height]
             * @param densityOfObstacles [density of non walkable fields]
             */


            var _proto = Grid.prototype;

            _proto.buildGridWithNodes = function buildGridWithNodes(matrix, width, height, densityOfObstacles) {
              var newGrid = [];
              var id = 0; // Generate an empty matrix

              for (var y = 0; y < height; y++) {
                newGrid[y] = [];

                for (var x = 0; x < width; x++) {
                  newGrid[y][x] = new node_1.Node({
                    id: id,
                    position: {
                      x: x,
                      y: y
                    }
                  });
                  id++;
                }
              }
              /**
               * If we have not loaded a predefined matrix,
               * loop through our grid and set random obstacles.
               */


              if (matrix === undefined) {
                for (var _y = 0; _y < height; _y++) {
                  for (var _x = 0; _x < width; _x++) {
                    var rndNumber = Math.floor(Math.random() * 10) + 1;

                    if (rndNumber > 10 - densityOfObstacles) {
                      newGrid[_y][_x].setIsWalkable(false);
                    } else {
                      newGrid[_y][_x].setIsWalkable(true);
                    }
                  }
                }

                return newGrid;
              }
              /**
               * In case we have a matrix loaded.
               * Load up the informations of the matrix.
               */


              for (var _y2 = 0; _y2 < height; _y2++) {
                for (var _x2 = 0; _x2 < width; _x2++) {
                  if (matrix[_y2][_x2]) {
                    newGrid[_y2][_x2].setIsWalkable(false);
                  } else {
                    newGrid[_y2][_x2].setIsWalkable(true);
                  }
                }
              }

              return newGrid;
            }
            /**
             * Return a specific node.
             * @param position [position on the grid]
             */
            ;

            _proto.getNodeAt = function getNodeAt(position) {
              return this.gridNodes[position.y][position.x];
            }
            /**
             * Check if specific node walkable.
             * @param position [position on the grid]
             */
            ;

            _proto.isWalkableAt = function isWalkableAt(position) {
              return this.gridNodes[position.y][position.x].getIsWalkable();
            }
            /**
             * Check if specific node is on the grid.
             * @param position [position on the grid]
             */
            ;

            _proto.isOnTheGrid = function isOnTheGrid(position) {
              return position.x >= 0 && position.x < this.width && position.y >= 0 && position.y < this.height;
            }
            /**
             * Get surrounding nodes.
             * @param currentXPos [x-position on the grid]
             * @param currentYPos [y-position on the grid]
             * @param diagnonalMovementAllowed [is diagnonal movement allowed?]
             */
            ;

            _proto.getSurroundingNodes = function getSurroundingNodes(currentPosition, diagnonalMovementAllowed) {
              var surroundingNodes = [];

              for (var y = currentPosition.y - 1; y <= currentPosition.y + 1; y++) {
                for (var x = currentPosition.x - 1; x <= currentPosition.x + 1; x++) {
                  if (this.isOnTheGrid({
                    x: x,
                    y: y
                  })) {
                    if (this.isWalkableAt({
                      x: x,
                      y: y
                    })) {
                      if (diagnonalMovementAllowed) {
                        surroundingNodes.push(this.getNodeAt({
                          x: x,
                          y: y
                        }));
                      } else {
                        if (x == currentPosition.x || y == currentPosition.y) {
                          surroundingNodes.push(this.getNodeAt({
                            x: x,
                            y: y
                          }));
                        }
                      }
                    } else {
                      continue;
                    }
                  } else {
                    continue;
                  }
                }
              }

              return surroundingNodes;
            };

            _proto.setGrid = function setGrid(newGrid) {
              this.gridNodes = newGrid;
            }
            /**
             * Reset the grid
             */
            ;

            _proto.resetGrid = function resetGrid() {
              for (var y = 0; y < this.gridNodes.length; y++) {
                for (var x = 0; x < this.gridNodes[y].length; x++) {
                  this.gridNodes[y][x].setIsOnClosedList(false);
                  this.gridNodes[y][x].setIsOnOpenList(false);
                  this.gridNodes[y][x].setParent(undefined);
                  this.gridNodes[y][x].setFGHValuesToZero();
                }
              }
            }
            /**
             * Get all the nodes of the grid.
             */
            ;

            _proto.getGridNodes = function getGridNodes() {
              return this.gridNodes;
            }
            /**
             * Get a clone of the grid
             */
            ;

            _proto.clone = function clone() {
              var cloneGrid = [];
              var id = 0;

              for (var y = 0; y < this.height; y++) {
                cloneGrid[y] = [];

                for (var x = 0; x < this.width; x++) {
                  cloneGrid[y][x] = new node_1.Node({
                    id: id,
                    position: {
                      x: x,
                      y: y
                    },
                    walkable: this.gridNodes[y][x].getIsWalkable()
                  });
                  id++;
                }
              }

              return cloneGrid;
            };

            return Grid;
          }();

          exports.Grid = Grid;
        })();

        _export("default", _cjsExports = module.exports);
      });

      _export("__cjsMetaURL", __cjsMetaURL = _context.meta.url);
    }
  };
});
//# sourceMappingURL=grid.js.map