System.register(["__unresolved_0"], function (_export, _context) {
  "use strict";

  var _loader, _cjsExports, __cjsMetaURL;

  _export("default", void 0);

  return {
    setters: [function (_unresolved_) {
      _loader = _unresolved_.default;
    }],
    execute: function () {
      _loader.define(_context.meta.url, function (exports, _require, module, __filename, __dirname) {
        var require = _loader.createRequireWithReqMap({}, _require);

        (function () {
          /**
           * Resources:
           * http://theory.stanford.edu/~amitp/GameProgramming/Heuristics.html
           * https://en.wikipedia.org/wiki/Taxicab_geometry
           * https://en.wikipedia.org/wiki/Euclidean_distance
           * https://en.wikipedia.org/wiki/Chebyshev_distance
           * http://www.gameaipro.com/GameAIPro/GameAIPro_Chapter17_Pathfinding_Architecture_Optimizations.pdf
           * https://github.com/riscy/a_star_on_grids#heuristics
           */
          Object.defineProperty(exports, "__esModule", {
            value: true
          });
          exports.calculateHeuristic = void 0;
          /**
           * Calculate for two positions the heuristic function.
           * @param heuristicFunction
           * @param pos0
           * @param pos1
           * @param weight
           */

          function calculateHeuristic(heuristicFunction, pos0, pos1, weight) {
            var dx = Math.abs(pos1.x - pos0.x);
            var dy = Math.abs(pos1.y - pos0.y);

            switch (heuristicFunction) {
              // TODO: Remove Manhatten in next major release
              case 'Manhatten':
              case 'Manhattan':
                /**
                 * Calculate the Manhattan distance.
                 * Generally: Overestimates distances because diagonal movement not taken into accout.
                 * Good for a 4-connected grid (diagonal movement not allowed)
                 */
                return (dx + dy) * weight;

              case 'Euclidean':
                /**
                 * Calculate the Euclidean distance.
                 * Generally: Underestimates distances, assuming paths can have any angle.
                 * Can be used f.e. when units can move at any angle.
                 */
                return Math.sqrt(dx * dx + dy * dy) * weight;

              case 'Chebyshev':
                /**
                 * Calculate the Chebyshev distance.
                 * Should be used when diagonal movement is allowed.
                 * D * (dx + dy) + (D2 - 2 * D) * Math.min(dx, dy)
                 * D = 1 and D2 = 1
                 * => (dx + dy) - Math.min(dx, dy)
                 * This is equivalent to Math.max(dx, dy)
                 */
                return Math.max(dx, dy) * weight;

              case 'Octile':
                /**
                 * Calculate the Octile distance.
                 * Should be used on an 8-connected grid (diagonal movement allowed).
                 * D * (dx + dy) + (D2 - 2 * D) * Math.min(dx, dy)
                 * D = 1 and D2 = sqrt(2)
                 * => (dx + dy) - 0.58 * Math.min(dx, dy)
                 */
                return (dx + dy - 0.58 * Math.min(dx, dy)) * weight;
            }
          }

          exports.calculateHeuristic = calculateHeuristic;
        })();

        _export("default", _cjsExports = module.exports);
      });

      _export("__cjsMetaURL", __cjsMetaURL = _context.meta.url);
    }
  };
});
//# sourceMappingURL=heuristic.js.map