"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.onBeforeBuildAssets = exports.throwError = void 0;
const PACKAGE_NAME = 'fix-compress';
function log(...arg) {
    return console.log(`[${PACKAGE_NAME}] `, ...arg);
}
exports.throwError = true;
const onBeforeBuildAssets = function (options, result) {
    return __awaiter(this, void 0, void 0, function* () {
        if (Editor.App.version !== '3.8.0') {
            return;
        }
        // @ts-ignore
        const bundles = result.__task.bundleManager.bundles;
        bundles.forEach((bundle) => {
            function removeAsset(assetUuid) {
                if (!assetUuid) {
                    return;
                }
                this._assets.delete(assetUuid);
                this._rootAssets.delete(assetUuid);
                delete this._scenes[assetUuid];
                this._jsonAsset.delete(assetUuid);
                this._scripts.delete(assetUuid);
                delete this.redirect[assetUuid];
                this.removeFromGroups(assetUuid);
                if (this.compressTask[assetUuid]) {
                    console.debug('remove image compress task ' + assetUuid);
                    result.__task.bundleManager.imageCompressManager && (result.__task.bundleManager.imageCompressManager.removeTask(assetUuid));
                }
                delete this.compressTask[assetUuid];
                delete this.compressRes[assetUuid];
            }
            bundle.removeAsset = removeAsset.bind(bundle);
        });
    });
};
exports.onBeforeBuildAssets = onBeforeBuildAssets;
