import { _decorator, Camera, Component, director, Node, UITransform, view } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {
	private mapDivId: string = "amap-container";

    protected onLoad() {
		// 创建地图容器div
        if (!document.getElementById(this.mapDivId)) {
			 let contentSize = this.getComponent(UITransform).contentSize;

			// 获取节点世界坐标
			const node = this.node;
			const worldPos = node.getWorldPosition();
			// 将世界坐标转换为屏幕坐标（像素）
			const camera = director.getScene().getComponentInChildren(Camera);
			let screenPos;
			if (camera) {
				screenPos = camera.worldToScreen(worldPos);
			}

			// 获取GameDiv在页面上的偏移
			const gameDiv = document.getElementById('GameDiv');
			if (!gameDiv) return;

			// 注意：Cocos 的 y=0 在底部，DOM 的 y=0 在顶部，需要做一次翻转
			const viewHeight = view.getVisibleSize().height;
			const domLeft = screenPos.x - contentSize.width / 2;
			const domTop = viewHeight - screenPos.y - contentSize.height / 2;

			const div = document.createElement('div');
			div.id = this.mapDivId;
			div.style.position = 'absolute';
			// div.style.left = domLeft + 'px';
			// div.style.top = domTop + 'px';
			div.style.width = contentSize.width + 'px';
			div.style.height = contentSize.height + 'px';
			div.style.zIndex = '100'; // 保证在上层
			gameDiv.appendChild(div); // 挂载到GameDiv下

			// this.mapContainer.addChild(div);
        }
	}
    start() {
        console.log('NewComponent start');
       		// 初始化高德地图
        const key = '7c9f83ec606517223cf3171946b8da8e';
		this.loadAmapScript(key, () => {
			if ((window as any).AMap) {
				const map = new (window as any).AMap.Map(this.mapDivId, {
					zoom: 11,
					center: [116.397428, 39.90923],
				});

				for(let i = 0; i < 100; i++) {
					const marker = new (window as any).AMap.Marker({
						position: [116.397428+i, 39.90923], // 标注经纬度
						label: {
							content: '这里是天安门' + i,
							direction: 'top' // 可选：top/bottom/left/right/center
						},
						// icon:"/assets/package/native/70/70c12e46-c3be-4de2-ae23-9b1a78356412.png",
						icon: 'https://webapi.amap.com/theme/v1.3/markers/n/mark_b.png',
						anchor: 'center'
					});

					marker.on('click', () => {
						// alert(`你点击了经纬度为 [${i}] 的标记点！`);
						// 这里写你的回调逻辑
					});
					map.add(marker);
				}

			} else {
				console.error('AMap SDK 未加载');
			}
		});
	}

    update(deltaTime: number) {
        
    }

    private loadAmapScript(key: string, callback: () => void) {
		if ((window as any).AMap) {
			callback();
			return;
		}
		const script = document.createElement('script');
		script.type = 'text/javascript';
		script.src = `https://webapi.amap.com/maps?v=2.0&key=${key}`;
		script.onload = () => {
			callback();
		};
		document.head.appendChild(script);
	}
}


