import {_decorator, Component, Node, RichText, resources, JsonAsset} from 'cc';
import {VirtualScrollView} from "db://assets/script/VirtualScrollView";

const {ccclass, property} = _decorator;

@ccclass('Main')
export class Main extends Component {
    @property(VirtualScrollView)
    public vList: VirtualScrollView | null = null;

    onLoad() {
        resources.load('text', (err, jsonAsset: JsonAsset) => {
            if (err) {
                console.error('加载JSON配置文件失败:', err);
                return;
            }
            const configData = jsonAsset.json;
            let dataList = this.splitContentIntelligently(configData.value);
            this.vList.totalCount = dataList.length;

            this.vList.getItemTypeIndexFn = (index: number) => {
                return 0;
            };

            this.vList.renderItemFn = (itemNode: Node, index: number) => {
                itemNode.getComponent(RichText).string = dataList[index]
            };

            this.vList.enabled = true
        });
    }

    getRandomSpace(q: number): number {
        return Math.floor(Math.random() * (q + 1));
    }

    /**
     * 智能分割内容，考虑换行和文本结构
     */
    private splitContentIntelligently(content: string): string[] {
        const segments: string[] = [];

        // 首先按段落分割
        const paragraphs = content.split('\n');

        let paragraphWithNewline = "";
        for (let i = 0; i < paragraphs.length; i++) {
            const paragraph = paragraphs[i];
            paragraphWithNewline += paragraph + "\n";
            if (paragraphWithNewline.length > 100) {
                segments.push(paragraphWithNewline)
                paragraphWithNewline = ""
            }
        }
        return segments;
    }
}


