// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Node)
    box:cc.Node = null;

    @property(cc.Label)
    label: cc.Label = null;

    @property(cc.Node)
    star: cc.Node = null;
    @property(cc.Node)
    monster :cc.Node = null;

    private direction = 1;
    private eular:cc.Vec3 = null;

    // LIFE-CYCLE CALLBACKS:
    onSlideChange(e){
        this.eular.y = 90 * e.progress;
        this.box.eulerAngles = this.eular;
    }
    // onLoad () {}

    start () {
        this.direction = 1;
        this.eular = cc.v3(0,0,0);
    }

    update (dt) {
        let max = 50;
        if(this.star.z>max){
            this.direction = -1;
        }
        if(this.star.z<-max){
            this.direction = 1;
        }

        this.star.z += this.direction;
        this.monster.z += this.direction;

        this.label.string = 'z: '+this.star.z + '';
    }
}
