import { _decorator, Color, Component, GraphicsComponent, Label, Node, v3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('debuger')
export class debuger extends Component {
    @property(GraphicsComponent)
    g: GraphicsComponent
    @property(Label)
    output: Label
    private isUpdating: boolean
    start() {
        this.isUpdating = true
        this.scheduleOnce(() => {
            this.isUpdating = false
            this.g.clear()
            for (let index = 0; index < 100; index++) {
                this.node.position = this.node.position.clone().add(v3(0, -1, 0))
            }
            this.isUpdating = true

            this.output.string = '正确：图片和红线绘制在同一位置'
        }, 1)
    }

    update(deltaTime: number) {
        if (this.isUpdating == false) return
        // 取消注释：解除bug
        this.g.node.invalidateChildren(Node.TransformBit.POSITION);

        this.g.clear()
        this.g.strokeColor = Color.RED
        this.g.lineWidth = 5

        this.g.moveTo(0, 0)
        this.g.lineTo(300, 0)
        this.g.stroke()
    }
}


