
const { ccclass, property } = cc._decorator;

@ccclass
export default class Effect_Dibble extends cc.Component {

    /** xy 为左右位置，zw为下上位置 */
    // @property(cc.Vec4)
    // hole0: cc.Vec4 = null;

    @property(cc.Vec4)
    private _hole0: cc.Vec4 = null;
    @property(cc.Vec4)
    public get hole0(): cc.Vec4 { return this._hole0; }
    public set hole0(v: cc.Vec4) { this._hole0 = v; this.refreshMaterial(); };

    @property(cc.Vec4)
    private _hole1: cc.Vec4 = null;
    @property(cc.Vec4)
    public get hole1(): cc.Vec4 { return this._hole1; }
    public set hole1(v: cc.Vec4) { this._hole1 = v; this.refreshMaterial(); };

    @property
    private _round0: number = -1;
    @property
    public get round0(): number { return this._round0; }
    public set round0(v: number) { this._round0 = v; this.refreshMaterial(); }

    @property
    private _round1: number = -1;
    @property
    public get round1(): number { return this._round1; }
    public set round1(v: number) { this._round1 = v; this.refreshMaterial(); }

    @property
    private _direction: number = -1;
    @property
    public get direction(): number { return this._direction; }
    public set direction(v: number) { this._direction = v; this.refreshMaterial(); };

    start() {
        this.refreshMaterial();
    }

    refreshMaterial() {
        let sprite = this.getComponent(cc.Sprite);
        sprite = this.node.getComponent(cc.Sprite);
        let material = sprite.getMaterial(0);

        //@ts-ignore
        if (material && material.effectAsset.name == 'Effect_Dibble') {
            //@ts-ignore
            material.setProperty('u_tex_size', [this.node.width, this.node.height]);
            if (this.hole0 != null) material.setProperty('u_hole0_lrbt', [this.hole0.x, this.hole0.y, this.hole0.z, this.hole0.w]);
            if (this.hole1 != null) material.setProperty('u_hole1_lrbt', [this.hole1.x, this.hole1.y, this.hole1.z, this.hole1.w]);
            if (this.direction != null) material.setProperty('u_direction', this.direction);
            if (this.round0 != null) material.setProperty('u_round0', this.round0);
            if (this.round1 != null) material.setProperty('u_round1', this.round1);
            sprite.setMaterial(0, material);
        }
    }
}
