import * as cc from "cc"
import {PlayerMovement} from "db://assets/Scripts/PlayerMovement";

@cc._decorator.ccclass("PlayerCollision")
export class PlayerCollision extends cc.Component {

    collider: cc.BoxCollider;

    start() {
        this.collider = this.node.getComponent(cc.BoxCollider);
        this.collider.on('onCollisionEnter', this.onCollisionEnter, this);
        this.collider.on('onTriggerEnter', this.onTriggerEnter, this);
    }

    protected onDestroy() {
        this.collider.off('onCollisionEnter', this.onCollisionEnter, this);
        this.collider.off('onTriggerEnter', this.onTriggerEnter, this);
    }

    update(deltaTime: number) {}

    onCollisionEnter(event: cc.ICollisionEvent) {
        // console.log('hit');
        if (event.otherCollider.node.name == "Obstacle") {
            let movement = this.node.getComponent(PlayerMovement);
            movement.enabled = false;

            cc.director.getScene().emit("level_failed");
            // cc.director.loadScene(cc.director.getScene().name);
        }
    }

    onTriggerEnter(event: cc.ITriggerEvent) {
        console.log("You Win");
        let movement = this.node.getComponent(PlayerMovement);
        movement.enabled = false;

        cc.director.getScene().emit('level_successful');
    }
}