import {director, _decorator, CCFloat, Component, EventKeyboard, Input, input, KeyCode, RigidBody, Vec3} from 'cc';
import cc from "cc";

const { ccclass, property } = _decorator;

@ccclass('PlayerMovement')
export class PlayerMovement extends Component {

    @property(RigidBody)
    rigidBody: RigidBody = null;

    @property(CCFloat)
    speed: number = 5; // 移动速度

    @property(CCFloat)
    forwardForce: number = 0;

    @property(CCFloat)
    sideForce: number = 0;


    isLeftDown: boolean = false;

    isRightDown: boolean = false;
    start() {
        input.on(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.on(Input.EventType.KEY_UP, this.onKeyUp, this);
    }

    update(deltaTime: number) {
        this.rigidBody.applyForce(new Vec3(0, 0, -this.forwardForce * deltaTime));

        if (this.isRightDown) {
            this.rigidBody.applyForce(new Vec3(this.sideForce * deltaTime, 0, 0));
        }

        if (this.isLeftDown) {
            this.rigidBody.applyForce(new Vec3(-this.sideForce * deltaTime, 0, 0));
        }

        if (this.node.position.y < -10) {
            console.log("You lose!");
            this.enabled = false;
            // director.loadScene(director.getScene().name);
            director.getScene().emit("level_failed");
        }
    }

    // @brief 组件销毁时被调用
    protected onDestroy() {
        input.off(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.off(Input.EventType.KEY_UP, this.onKeyUp, this);
    }

    onKeyDown(event: EventKeyboard) {
        if (event.keyCode == KeyCode.KEY_A) {
            this.isLeftDown = true;
            // console.log("KeyDown A");
        }

        if (event.keyCode == KeyCode.KEY_D) {
            this.isRightDown = true;
            // console.log("KeyDown D");
        }
    }

    onKeyUp(event: EventKeyboard) {
        if (event.keyCode == KeyCode.KEY_A) {
            this.isLeftDown = false;
            // console.log("KeyUp A");
        }

        if (event.keyCode == KeyCode.KEY_D) {
            this.isRightDown = false;
            // console.log("KeyUp D");
        }
    }
}


