import { _decorator, Component, Node, director } from 'cc';
import cc from "cc";
const { ccclass, property } = _decorator;

@ccclass('UIManage')
export class UIManage extends Component {

    @property(Node)
    uiLevelFailure: Node;

    @property(Node)
    uiLevelSuccess: Node;

    @property(Node)
    uiLevelComplete: Node;

    start() {
        director.getScene().on('level_failed', this.onEvent_LevelFailed, this);
        director.getScene().on('level_successful', this.onEvent_LevelSuccessful, this);
    }

    update(deltaTime: number) {
        
    }

    onButtonReplay() {
        director.loadScene(director.getScene().name);
    }

    onButtonMainMenu() {
        director.loadScene("MainMenu");
    }

    onButtonNext() {
        let currentScene = director.getScene().name;

        switch (currentScene) {
            case "Level-001":
                director.loadScene("Level-002");
                break;
            case "Level-002":
                director.loadScene("Level-003");
                break;
        }
    }

    onEvent_LevelFailed() {
        this.uiLevelFailure.active = true;
    }

    onEvent_LevelSuccessful() {
        if (director.getScene().name == "Level-003") {
            this.uiLevelComplete.active = true;
        } else {
            this.uiLevelSuccess.active = true;
        }
    }
}


