import { _decorator, animation, Button, cclegacy, Component, Label, Node, profiler, resources, sp } from 'cc';
const { ccclass, property } = _decorator;


@ccclass('test')
export class test extends Component {

    @property({ type: Label, tooltip: '显示批次信息' })
    dcLabel: Label = null;
    
    @property({ type: Node, tooltip: '节点' })
    root: Node = null;
    spineNodeArray: sp.Skeleton[] = [];
    
    protected onLoad(): void {
        if(this.root){
            let spineArray = this.root.getComponentsInChildren(sp.Skeleton);
            for(let j=0; j<spineArray.length; j++){
                let spine = spineArray[j];
                this.spineNodeArray.push(spine);
            }
        }
    }
    
    start() {
        profiler.hideStats();
        profiler.showStats();
    }

    update(deltaTime: number) {
        let state = null;
        if(cclegacy.profiler.stats){
            state = cclegacy.profiler.stats;
        }else{
            state = cclegacy.profiler._stats;
        }
        let dc = state.draws.counter._value;
        let fps =  Math.floor(state.fps.counter._averageValue);
        if (this.dcLabel) {
            this.dcLabel.string = `dc: ${dc}`;
        }
    }

    onIssue(){
        for(let i=0; i<this.spineNodeArray.length; i++){
            let spine = this.spineNodeArray[i];
            if(i%2===1){
                spine.node.active = false;
                spine.node.active = true;
            }
        }
    }

    onReset(){
        for(let i=0; i<this.spineNodeArray.length; i++){
            let spine = this.spineNodeArray[i];
            spine.node.active = false;
            spine.node.active = true;
        }
    }
}


