import { _decorator, Component, Node } from 'cc';
const { ccclass, property } = _decorator;

const OUTOFRANGE = 50; //子弹活动范围

@ccclass('Bullet')
export class Bullet extends Component {
    @property
    private _bulletSpeed = 0;

    start() {

    }

    update(deltaTime: number) {
        const pos = this.node.position;
        const moveLength = pos.z - this._bulletSpeed;
        this.node.setPosition(pos.x, pos.y, moveLength);

        //销毁子弹
        if(moveLength > OUTOFRANGE){
            this.node.destroy();
            console.log('bullet destroy');
        }
    }

    show(speed:number){
        this._bulletSpeed = speed
        console.log("===============this",this._bulletSpeed);
    }
}


