import { _decorator, Component, Node, Prefab, instantiate } from 'cc';
import { Bullet } from '../bullet/Bullet';
import { BulletOne } from '../bullet/BulletOne';
const { ccclass, property } = _decorator;

@ccclass('GameManager')
export class GameManager extends Component {
    @property(Node)
    public playerPlane: Node = null;
    @property(Prefab)
    public bullet01: Prefab = null;
    @property(Prefab)
    public bullet02: Prefab = null;
    @property(Prefab)
    public bullet03: Prefab = null;
    @property(Prefab)
    public bullet04: Prefab = null;
    @property(Prefab)
    public bullet05: Prefab = null;
    @property
    public shootTime = 0.3;

    @property
    public bulletSpeed = 1;

    @property(Node)
    public bulletRoot:Node = null;

    private _currShootTime = 0;
    private _isShooting = false;

    _init(){
        this._currShootTime = this.shootTime
    }

    start() {
        this._init();
    }

    update(deltaTime: number) {
        this._currShootTime += deltaTime;
        if(this._isShooting && this._currShootTime > this.shootTime){
            //创建子弹
            this.createPlayerBullet();
            //时间归零
            this._currShootTime = 0;
        }
    }

    public createPlayerBullet(){
        const bullet = instantiate(this.bullet01);
        bullet.setParent(this.bulletRoot);
        //设置子弹应该在的位置
        const pos = this.playerPlane.position;
        bullet.setPosition(pos.x, pos.y, pos.z - 7);
        //设置子弹速度
        const bulletOneComp = bullet.getComponent(BulletOne);
        const bulletComp = bullet.getComponent(Bullet)
        console.log('this.bulletComp ===='+ bulletComp);
        console.log('this.bulletOneComp01 ===='+ bulletOneComp);
        // bulletOneComp.bulletSpeed = this.bulletSpeed;
        // bulletComp.show(this.bulletSpeed);
        bulletOneComp.bulletSpeed = this.bulletSpeed;
    }

    public isShooting(value: boolean){
        this._isShooting = value;
    }
}


