import { _decorator, Component, Node, SystemEvent, EventTouch,Touch, input, Input } from 'cc';
import { GameManager } from '../framework/GameManager';
const { ccclass, property } = _decorator;

@ccclass('UiMain')
export class UiMain extends Component {
    @property
    public planeSpeed = 1;

    @property(Node)
    public playerPlane:Node = null;

    @property(GameManager)
    public gameManager:GameManager = null;

    start() {
        this.node.on(Input.EventType.TOUCH_START,this._touchStart,this);
        this.node.on(Input.EventType.TOUCH_MOVE,this._touchMove,this);
        this.node.on(Input.EventType.TOUCH_END,this._touchEnd,this);
    }

    _touchStart(touch:Touch,event:EventTouch){
        this.gameManager.isShooting(true);
    }


    _touchMove(touch:Touch,event:EventTouch){
        const delta = touch.getDelta();
        let pos = this.playerPlane.position;
        this.playerPlane.setPosition(pos.x + 0.01 * this.planeSpeed * delta.x, pos.y, pos.z - 0.01 * this.planeSpeed * delta.y);
    }

    _touchEnd(touch:Touch,event:EventTouch){
        this.gameManager.isShooting(false);
    }
    
}


