import { Sample } from "./Sample";
import { resources, sys } from "cc";
import { _decorator } from "cc";
const { ccclass } = _decorator;

/**
 * 地图路径配置
 */
@ccclass("FightMapPath")
export class FightMapPath extends Sample {

    // 数据文件名
    public filePath: string;

    // 内存数据
    // 当前关卡的地图数量
    public mapNumber: number;
    // 地图二维数组
    public mapArrays: Array<Array<string>>;
    // boss关所在坐标
    public bossX: number;
    public bossY: number;

    public init(jsonTable: any): void {
        super.init(jsonTable);
        if (jsonTable.filePath) {
            this.filePath = jsonTable.filePath;
            this.parasFile();
        }
        else {
            console.warn(" FightMapPath has no filePath, sid=" + this.sid);
        }

    }

    /**
        * 读取文件
        */
    public parasFile() {
        resources.load("fightMapPath/" + this.filePath, (err, res) => {
            if (err) {
                console.warn(" load fightMapPath " + this.filePath + " err, message=" + err);
                return;
            }
            let text = res.toString();
            let texts = text.split("\n");
            // console.log(" text="+text+", "+this.filePath);
            
            this.mapArrays = new Array(texts.length);
            let count = 0;
            for (let index = 0; index < texts.length; index++) {
                const element = texts[index];
                const elements = element.split("\t");
                this.mapArrays[index] = new Array<string>(elements.length);
                for (let i = 0; i < elements.length; i++) {
                    const e = elements[i];
                    const mt = e;
                    this.mapArrays[index][i] = mt;
                    if (mt === "0") {
                        count++;
                    }
                    if (mt.startsWith("2")) {
                        this.bossX = i;
                        this.bossY = index;
                    }
                }
            }
            this.mapNumber = count;

            // console.log("-======================================================");

            // for (let index = 0; index < this.mapArrays.length; index++) {
            //     const element = this.mapArrays[index];

            //     let s = "";
            //     for (let i = 0; i < element.length; i++) {
            //         const e = element[i];
            //         s += e + "\t";
            //     }
            //     console.log(s + "\n");


            // }

            // console.log("+======================================================");


        });
    }



}
