import { Sample } from "../Sample";
import { queue, map, asc, desc } from "../../../Comparator";
import { _decorator } from "cc";
const { ccclass } = _decorator;

/**
 * 任务
 */
@ccclass("Mission")
export class Mission extends Sample {
	/**
	 * 完成任务所需要的值
	 */
	public needValue: number;
	/**
	 * 任务类型
	 */
	public type: number;
	/**
	 * 任务描述
	 */
	public des: string;

	// 要保存的值
	public value: number = 0;
	// 是否已经完成
	public isFinish: boolean = false;
	// 是否已经领取过奖励了
	public isGetAwarded: boolean = false;

	public getValue(): number {
		return this.value;
	}

	public init(jsonTable: any): void {
		super.init(jsonTable);
		this.needValue = Number(jsonTable.needValue);
		this.des = jsonTable.des;
		this.type = Number(jsonTable.type);
	}

	/** 更新完成值 */
	public updateValue(value: number) {
		this.value = value;
		if (this.value >= this.needValue)
			this.isFinish = true;
		else
			this.isFinish = false;
	}

	public getStorageData(): Object {
		let obj = super.getStorageData();
		obj["value"] = this.value;
		obj["isGetAwared"] = this.isGetAwarded;
		return obj;
	}

	/** 任务的排序器 */
	public static missionComparator = queue([
		map(m => m.isGetAwarded, asc),
		map(m => m.isFinish, desc),
		map(m => m.value, desc)
	]);

}
