import { Prop } from "../Prop";
import { _decorator } from "cc";
import { LinkedList } from "../../../../Collections";
import { Gem } from "../Gem";
const { ccclass } = _decorator;
/**
 * 装备
 */
@ccclass("Equip")
export class Equip extends Prop {
	/**
	 * 装备等级
	 */
	public level: number;
	/**
	 * 装备类型
	 */
	public equipType: number;


	// 内存数据

	/**
	 * 装备基础属性(模版属性)
	 */
	private baseAttrs = new Map<number, number>();
	/**
	 * 随机属性
	 */
	private randomAttrs = new Map<number, number>();

	/**
	 * 装备的宝石列表
	 */
	private gemList: LinkedList<Gem>;


	public constructor() {
		super();
	}

	public init(jsonTable: any): void {
		super.init(jsonTable);
		this.equipType = Number(jsonTable.equipType);

		for (let index = 1; index < 30; index++) {
			this.baseAttrs.set(index, index * 2);
		}

	}

	public getEquipType(): number {
		return this.equipType;
	}

	

	/**
	 * 获得基础属性的值
	 * @param type 属性类型
	 * @returns 
	 */
	public getBaseAttr(type: number): number {
		let n = this.baseAttrs.get(type);
		if (!n)
			return 0;
		return n;
	}
	/**
	 * 获得随机生成的属性的值
	 * @param type 属性类型
	 * @returns 
	 */
	public getRandomAttr(type: number): number {
		let n = this.randomAttrs.get(type);
		if (!n)
			return 0;
		return n;
	}
}