import { Sample } from "../Sample";
import { _decorator } from "cc";
const { ccclass } = _decorator;
/**
 * 道具
 */
@ccclass("Prop")
export class Prop extends Sample {
    // 道具类型
    public propType: number;
    // 图标
    public icon: string;
    // 描述
    public des: string;
    // 出售获得金币奖励
    public sellGold: number;


    //------------- 内存数据
    /**
     * 道具UID
     */
    private uid: number;
    // 数量
    private count = 1;

    public init(jsonTable: any): void {
        super.init(jsonTable);
        this.propType = Number(jsonTable.propType);
        this.icon = jsonTable.icon;
        this.des = jsonTable.des;
        this.sellGold = Number(jsonTable.sellGold);
    }

    public getUid(): number {
        return this.uid;
    }

    public getPropType(): number {
        return this.propType;
    }

    public getIcon(): string {
        return this.icon;
    }

    public getCount(): number {
        return this.count;
    }

    public setCount(count: number) {
        this.count = count;
    }

}