import { Sample } from "../Sample";

import { Skill } from "../Skill/Skill";

import SampleManager from "../SampleManager";

/**
 * 角色信息
 */
export class Role extends Sample {
	// 头像
	public icon: string;
	// 血量
	public maxLife: number;
	// 物理攻击
	public atk: number;
	// 物理防御
	public def: number;
	// 携带的技能
	public skills: string;
	// 携带的基础武器
	public weaponSid: number;

	// 内存数据
	public skillArray: Skill[] = new Array(4);

	public constructor() {
		super();
	}

	public init(jsonTable: any): void {
		super.init(jsonTable);
		this.icon = jsonTable.icon;
		this.maxLife = Number(jsonTable.maxLife);
		this.atk = Number(jsonTable.atk);
		this.def = Number(jsonTable.def);
		this.skills = jsonTable.skills;
		this.weaponSid = Number(jsonTable.weaponSid);

		// 初始化技能
		let array = this.skills.split(",");
		for (let i = 0; i < array.length; i++) {
			let skill = SampleManager.getSample(Skill, Number(array[i]));
			if (!skill) {
				console.warn(" role skill error: role.sid=" + this.sid + ", skill.sid=" + array[i]);
			} else {
				this.skillArray[i] = skill;
			}
		}
		// 初始化武器
		// if (this.weaponSid)
		// 	this.weapon = SampleManager.getSample(Weapon, this.weaponSid) as Weapon;
	}

	public clone(): any {
		let obj = super.clone();
		// 将技能列表
		if (this.skillArray && this.skillArray.length > 0) {
			obj["skillArray"] = [4];
			for (let i = 0, len = this.skillArray.length; i < len; i++) {
				if (this.skillArray[i])
					obj["skillArray"][i] = this.skillArray[i].clone();
			}
		}
		return obj;
	}

}