/**
 * 模板
 */
import { Component, _decorator } from "cc";
const { ccclass } = _decorator;

@ccclass("Sample")
export class Sample extends Component {
	public sid: number;
	public sampleName: string;

	public init(jsonTable: any): void {
		this.sid = Number(jsonTable.sid);
		this.sampleName = jsonTable.name;
	}

	public clone(): any {
		let obj = Object.create(this);
		for (let key in this) {
			if (this.hasOwnProperty(key)) {
				if (typeof this[key] === 'object' && obj[key] !== null) {
					continue;
				} else {
					obj[key] = this[key];
				}
			}
		}
		return obj;
	}

	/**
	 * 获得要存储的信息
	 */
	public getStorageData(): Object {
		let obj = {};
		obj["sid"] = this.sid;
		return obj;
	}
}