import { Sample } from "../Sample";
import Utils from "../../../Utils";

/**
 * 技能类型 1 普通攻击, 2 技能攻击, 3 给自己加buff, 4给敌方加buff
 */
export const SKILL_NORMAL = 1, SKILL_MAGIC = 2, SKILL_BUFF = 3;

/**
 * 技能特效运动方式 1.原地 2.飞行 3.天空坠落
 */
export const EFFECT_NORMAL = 1, EFFECT_FLY = 2, EFFECT_COME_DOWN = 3;

/**
 * 技能
 */
export class Skill extends Sample {
    /** 图标 */
    public iconName: string;
    /** 技能类型 */
    public type: number;
    /** 技能特效运动方式() */
    public effectKind: number;
    /** 技能cd */
    public cdTime: number;
    /** 技能伤害范围 */
    public damageRange: number;
    /** 特效json文件 */
    public effectJson: string;
    /** 特效图片 */
    public effectImg: string;
    /** 特效播放次数 */
    public effectPlayCount: number;
    /** 物理攻击系数 */
    public atkFactor: number;

    //内存数据
    /** cd开始时间 */
    public cdStartTime: number;

    public init(jsonTable: any): void {
        super.init(jsonTable);
        this.iconName = jsonTable.iconName;
        this.type = Number(jsonTable.type);
        this.cdTime = Number(jsonTable.cdTime);
        this.damageRange = Number(jsonTable.damageRange);
        this.effectJson = jsonTable.effectJson;
        this.effectImg = jsonTable.effectImg;
        this.effectPlayCount = Number(jsonTable.effectPlayCount);
        this.effectKind = Number(jsonTable.effectKind);
        this.atkFactor = Number(jsonTable.atkFactor);
    }

    /**
     * 进入cd
     */
    public startCD() {
        this.cdStartTime = Utils.getLocalSecondTime();
    }

    /** 
     * 检查技能cd是否可用
      */
    public isCanUse(): boolean {
        if (!this.cdStartTime || this.cdStartTime == 0)
            return true;
        let allCDTime = Number(this.cdStartTime + this.cdTime);
        return allCDTime < Utils.getLocalSecondTime();
    }
}