import { Sample } from "./Sample";
import { Award } from "./Award";
import SampleManager from "./SampleManager";
import { FightMapPath } from "./FightMapPath";
import { _decorator } from "cc";
const { ccclass } = _decorator;
/**
 * 关卡
 */
@ccclass("Stage")
export class Stage extends Sample {

    // 关卡类型
    public type: number;

    // 当前关卡的路径配置sid
    public mapPathSid: number;

    // 关卡奖励内容
    public awards: string;


    // 内存数据
    public awardArray: Award[];

    public init(jsonTable: any): void {
        super.init(jsonTable);
        this.type = Number(jsonTable.type);
        
        if (jsonTable.mapPathSid) {
            this.mapPathSid = Number(jsonTable.mapPathSid);
        } else {
            console.warn(" stage error has no mapPathSid, sid=" + this.sid);
        }

        // 初始化奖励
        // let array = this.awards.split(",");
        // this.awardArray = new Array(array.length);
        // for (let i = 0; i < array.length; i++) {
        //     let award = SampleManager.getSample(Award, Number(array[i]));
        //     if (!award) {
        //         console.warn(" Stage award error: Stage.sid=" + this.sid + ", award.sid=" + array[i]);
        //     } else {
        //         this.awardArray[i] = award;
        //     }
        // }
    }

    /**
     * 获得当前关卡的地图路径信息
     */
    public getMapPath(): FightMapPath {
        return SampleManager.getSample(FightMapPath, this.mapPathSid);
    }


}