import { _decorator } from "cc";
const { ccclass } = _decorator;
/**
 * Uid管理器
 */
@ccclass("UidManager")
export class UidManager {

    private uidMap = new Map<number, number>();

    public getUid(type: number): number {
        let uid = this.uidMap.get(type);
        if (!uid)
            uid = 0;
        uid++;
        this.uidMap.set(type, uid);
        return uid;
    }

    public getStorageData(): Object {
        let values = "";
        this.uidMap.forEach((value, key) => {
            values += key + "," + value + ";";
        });
        return values;
    }

    public fillData(obj: Object) {
        let values = obj.toString();
        if (values) {
            values.split(";").forEach(value => {
                let key = Number(value.split(":")[0]);
                let v = Number(value.split(":")[1]);
                this.uidMap.set(key, v);
            });
        }
    }
}

