
import { _decorator, Component, Node, ValueType } from 'cc';
const { ccclass, property } = _decorator;

/**
 * 战斗小地图数据类. 只记录点击过的数据.
 */
@ccclass('FightMapData')
export class FightMapData {
    // 坐标
    x: number;
    y: number;
    // 是否是boss
    isBoss: boolean;

    // 地图prefab名称
    mapPrefabName: string;

    // 上下左右是否有地图
    pathValue: string;

    // 地图内数据, 就是键值对, 键是物件id, 值是他的进度
    dataMap: Map<number, number>;

    constructor(x: number, y: number) {
        this.x = x;
        this.y = y;
        this.dataMap = new Map<number, number>();
    }

    /**
     * 设置某编号物件的进度值
     */
    setItemValue(num: number, progress: number) {
        this.dataMap.set(num, progress);
    }

    /**
     * 获取某编号的物件的进度值
     */
    getItemValue(num: number): number {

        // console.log("   getItemValue=" + this.dataMap.has(num));

        // this.dataMap.forEach((key, value) => {
        //     console.log(" value=" + key + "_" + value);
        // })

        if (this.dataMap.has(num))
            return this.dataMap.get(num);
        else return -1;
    }

    /**
     * 转换为json
     */
    getStorageData(): Object {
        let obj = {};
        obj["x"] = this.x;
        obj["y"] = this.y;
        obj["isBoss"] = this.isBoss;
        obj["mapPrefabName"] = this.mapPrefabName;
        obj["pathValue"] = this.pathValue;
        let itemData: Array<String> = new Array<String>();
        var i = 0;
        // console.log(" .. x=" + this.x + ", y=" + this.y + ", map.size=" + this.dataMap.size);

        this.dataMap.forEach((value, key) => {
            itemData[i++] = value + "_" + key;
            // console.log(" .. x=" + this.x + ", y=" + this.y + ", value=" + key + "_" + value);
        });

        // for (var key in this.dataMap.keys) {
        //     console.log(" .. key=" + key);
        //     if (this.dataMap.hasOwnProperty(key)) {
        //         var element = this.dataMap[key];
        //         itemData[i++] = key + "_" + element;

        //         console.log(" .. x=" + this.x + ", y=" + this.y + ", value=" + key + "_" + element);

        //     }
        // }
        obj["itemData"] = itemData;
        return obj;
    }

    /**
     * 填充数据
     */
    fillData(obj: Object) {
        this.isBoss = Boolean(obj["isBoss"]);
        this.mapPrefabName = obj["mapPrefabName"];
        this.pathValue = obj["pathValue"];
        let itemData: Array<String> = obj["itemData"];

        for (let index = 0; index < itemData.length; index++) {
            const element = itemData[index];
            let es = element.split("_");

            let value = Number(es[0]);
            let key = Number(es[1]);
            // console.log(" element=" + element + " ===" + es[0] + ", ===" + es[1] + ", key=" + key + ", value=" + value);
            this.dataMap.set(key, value);
        }


    }









}