
import { sys, _decorator } from 'cc';
import { Stage } from '../Data/Sample/Stage';
import { FightConsts } from './FightConsts';
import { FightMapData } from './FightMapData';
import { FightMapPath } from '../Data/Sample/FightMapPath';
import SampleManager from '../Data/Sample/SampleManager';
import { Consts } from '../Consts';


const { ccclass, property } = _decorator;

/**
 * 战斗场景数据(当前副本所有数据)
 */

@ccclass('FightScreenData')
export class FightScreenData {
    // 关卡
    stage: Stage;
    // 战斗地图数据
    private fightMapDataArrays: Array<Array<FightMapData>>;
    // 当前显示地图
    currentFightMapData: FightMapData;
    // 战斗地图数组宽高
    fightMapDataArraysWidth: number;
    fightMapDataArraysHeight: number;


    constructor() {

    }

    /**
     * 获得当前地图x
     */
    getCurrentFightMapX(): number {
        return this.currentFightMapData.x;
    }


    /**
     * 获得当前地图y
     */
    getCurrentFightMapY(): number {
        return this.currentFightMapData.y;
    }

    /**
     * 获得某坐标
     */
    getFightMapData(x: number, y: number): FightMapData {
        return this.fightMapDataArrays[y][x];
    }

    /**
     * 初始化地图
     */
    initMapData(stage: Stage) {
        console.log(" 新初始化...");

        this.stage = stage;
        // 根据数据初始化路径
        let fightMapPath = SampleManager.getSample(FightMapPath, this.stage.mapPathSid);
        if (!fightMapPath) {
            console.warn(" init map data error. stage.sid=" + this.stage.sid + ", mapPathSid=" + this.stage.mapPathSid);
            return;
        }
        this.fightMapDataArrays = new Array<Array<FightMapData>>(fightMapPath.mapArrays.length);
        this.fightMapDataArraysWidth = this.fightMapDataArrays.length;
        for (let index = 0; index < fightMapPath.mapArrays.length; index++) {
            const elements = fightMapPath.mapArrays[index];
            this.fightMapDataArraysHeight = elements.length;
            this.fightMapDataArrays[index] = new Array<FightMapData>(elements.length);
            for (let i = 0; i < elements.length; i++) {
                const v = elements[i];
                if (v === "0") {
                    this.fightMapDataArrays[index][i] = null;
                } else {
                    this.fightMapDataArrays[index][i] = new FightMapData(i, index);
                    this.fillFightMapData(this.fightMapDataArrays[index][i], v);
                }
            }
        }
        this.currentFightMapData = this.fightMapDataArrays[FightConsts.BORN_MAP_Y][FightConsts.BORN_MAP_X];
    }

    /**
     * 给每个地图填充数据
     */
    fillFightMapData(fightMapData: FightMapData, pathValue: string) {
        // 地图内prefab的名称
        if (!fightMapData)
            return;
        fightMapData.mapPrefabName = "prefab/item/fight/map_1";
        fightMapData.isBoss = pathValue.startsWith("2");
        fightMapData.pathValue = pathValue;

    }

    /**
     * 切换地图
     */
    switchMap(x: number, y: number): FightMapData {
        const fightMapData = this.fightMapDataArrays[y][x];
        if (fightMapData) {
            console.log(" 22222 switch  map y=" + y + ", x=" + x + ", data=" + fightMapData);

            this.currentFightMapData = fightMapData;
        }
        return fightMapData;
    }

    /**
     * 保存数据
     */
    saveData() {
        let jsData: Object = {};
        jsData["stageSid"] = this.stage.sid;
        jsData["currentX"] = this.currentFightMapData.x;
        jsData["currentY"] = this.currentFightMapData.y;
        jsData["fightMapDataArraysWidth"] = this.fightMapDataArraysWidth;
        jsData["fightMapDataArraysHeight"] = this.fightMapDataArraysHeight;

        let fightMapData: Array<Array<Object>> = new Array<Array<Object>>(this.fightMapDataArraysWidth);

        for (let index = 0; index < this.fightMapDataArrays.length; index++) {
            const elements = this.fightMapDataArrays[index];
            fightMapData[index] = new Array<Object>(elements.length);

            for (let i = 0; i < elements.length; i++) {
                const v = elements[i];
                if (v)
                    fightMapData[index][i] = v.getStorageData();
                else
                    fightMapData[index][i] = null;
            }
        }
        jsData["fightMapData"] = fightMapData;
        sys.localStorage.setItem(Consts.FIGHT_DATA + "_" + this.stage.sid, JSON.stringify(jsData));
    }

    /**
     * 加载并初始化数据
     * @returns 返回是否加载成功
     */
    loadInitData(sid: number): Boolean {
        var data = JSON.parse(sys.localStorage.getItem(Consts.FIGHT_DATA + "_" + sid));
        if (!data)
            return false;
        const stageSid = Number(data["stageSid"]);
        this.stage = SampleManager.getSample(Stage, stageSid);
        this.fightMapDataArraysWidth = Number(data["fightMapDataArraysWidth"]);
        this.fightMapDataArraysHeight = Number(data["fightMapDataArraysHeight"]);

        var fightMapData = data["fightMapData"] as Array<Array<Object>>;

        this.fightMapDataArrays = new Array<Array<FightMapData>>(this.fightMapDataArraysWidth);

        for (let index = 0; index < fightMapData.length; index++) {
            const elements = fightMapData[index];
            this.fightMapDataArrays[index] = new Array<FightMapData>(elements.length);

            for (let i = 0; i < elements.length; i++) {
                const v = elements[i];
                if (v) {
                    let fightMapData = new FightMapData(Number(v["x"]), Number(v["y"]));
                    fightMapData.fillData(v);
                    this.fightMapDataArrays[index][i] = fightMapData;
                }
                else
                    this.fightMapDataArrays[index][i] = null;
            }
        }
        const currentX = Number(data["currentX"]);
        const currentY = Number(data["currentY"]);

        this.currentFightMapData = this.getFightMapData(currentX, currentY);
        return true;
    }


    clearData(sid: number) {
        sys.localStorage.removeItem(Consts.FIGHT_DATA + "_" + sid);
    }



}
