import { Player } from "../Data/Player";
import { FightConsts } from "./FightConsts";

/**
 * 玩家战斗数据
 */
export class Fighter {
    // 等级
    public level: number;

    // 属性列表
    public attributes = {};

    // buff列表
    

    /**
     * 将数据初始化
     */
    public init(player: Player) {
        this.level = player.level;
        this.attributes[FightConsts.LIFE] = this.attributes[FightConsts.MAX_LIFE] = FightConsts.BASE_LIFE + player.getLife();
        this.attributes[FightConsts.ATTACK] = player.getAttack();
        this.attributes[FightConsts.DEF] = player.getDef();
        this.attributes[FightConsts.CRITRATE] = player.getCritRate();
        this.attributes[FightConsts.CRITDAMAGE] = player.getCritDamage();
        this.attributes[FightConsts.DODGE] = player.getDodge();
    }

    /**
     * 获得某项属性的值
     * @param attType 属性类型
     */
    public getAttValue(attType: number): number {
        return this.attributes[attType];
    }

}