
import { _decorator, Component, Node, v2, Vec2, Sprite, Prefab, instantiate, v3, Label } from 'cc';
import { BaseMap } from './UIFrame/BaseMap';
import { UIConfig } from './UIConfig';
import SceneMgr from './UIFrame/SceneMgr';
import WindowMgr from './UIFrame/WindowMgr';
import { Player } from './Data/Player';
import EventManager from './UIFrame/EventManager';
import { Consts } from './Consts';
import Utils from './Utils';
import SampleManager from './Data/Sample/SampleManager';
import { Stage } from './Data/Sample/Stage';
const { ccclass, property } = _decorator;

@ccclass("Home")
export class Home extends BaseMap {

    mapId = new Vec2(0, 0);

    @property(Node) ndProgress: Node = null;
    @property(Node) ndFight: Node = null;

    @property(Node) ndPackage: Node = null;
    @property(Node) ndProps: Node = null;

    @property(Node) ndPropRoot: Node = null;
    @property(Prefab) pfProp: Prefab = null;

    @property(Label) levelLabel: Label = null;
    @property(Label) moneyLabel: Label = null;
    @property(Label) diamondLabel: Label = null;




    start() {
        // 添加玩家数据准备好了的事件
        EventManager.addListener(Consts.PLAYER_DATA_READY, this.playerReady, this);

        let fillRange = 1;
        this.ndProgress.on(Node.EventType.TOUCH_END, () => {
            fillRange -= 0.1;
            this.ndProgress.getComponent(Sprite).fillRange = Math.max(0, fillRange);
        }, this);

        this.ndFight.on('click', () => {
            SceneMgr.open(UIConfig.LoadingPanel.prefabPath);
        }, this);

        this.ndProps.on('click', () => {
            let num = Math.floor(Math.random() * 6 + 2);
            for (let i = 0; i < num; i++) {
                let node = instantiate(this.pfProp);
                this.ndPropRoot.addChild(node);
                let x = Math.random() * 100;
                let y = Math.random() * 100;
                node.setPosition(v3(x, y, 0));
                this.scheduleOnce(() => {
                    node.removeFromParent();
                }, 2);
            }
        }, this);
    }


    public playerReady() {
        this.levelLabel.string = "等级:" + Player.getInstance().level;
        this.moneyLabel.string = "金币:" + Player.getInstance().gold;
        this.diamondLabel.string = "钻石:" + Player.getInstance().diamond;
    }

    // update (deltaTime: number) {
    //     // [4]
    // }

}