
import { _decorator, Component, Node, UITransform, Label, game } from 'cc';
import { Player } from './Data/Player';
import SampleManager, { initAllSample } from './Data/Sample/SampleManager';
import { ResourceManager } from './ResourceManager';
import { UIConfig } from './UIConfig';
import SceneMgr from './UIFrame/SceneMgr';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {

    /**
    * 定时记录本地时间
    */
    public static localTime: number = 0;

    async start() {
        this.schedule(Main.countTime, 1);
        await SceneMgr.open(UIConfig.MainScreen.prefabPath);
        // 初始化所有配置文件
        await initAllSample();
        await ResourceManager.atlasInit();

        // 加载玩家数据
        Player.init(new Player());

        // 初始化背包

    }

    static countTime() {
        Main.localTime++;
    }
}
