
import { _decorator, Component, Node, Vec2, v2 } from 'cc';
import { MapEvent, MapMoveData } from './UIFrame/BroadcastMap';
import MapConfig from './MapConfig';
import MapUtils from './UIFrame/MapUtils';
import { MoveDir } from './UIFrame/Types';
import { UIFixed } from './UIFrame/UIForm';
const { ccclass, property } = _decorator;

@ccclass('Navigaton')
export class Navigaton extends UIFixed {

    onLoad() {
        MapEvent.onAfterMove.on((data) => {
            console.log(data.targetMapId, data.currMapId)
            this.updateView(data.targetMapId);
        }, this);
    }

    onClickNavigaton(e, data) {
        let targetMapId = v2(0, 0);
        let dir = MoveDir.None;
        switch (data) {
            case 'left':
                targetMapId = MapUtils.getNextMap(MapConfig.currMapId.clone(), MoveDir.Left);
                dir = MoveDir.Right;
                break;
            case 'right':
                targetMapId = MapUtils.getNextMap(MapConfig.currMapId.clone(), MoveDir.Right);
                dir = MoveDir.Left;
                break;
            // case 'up':
            //     targetMapId = MapUtils.getNextMap(MapConfig.currMapId.clone(), MoveDir.Up);
            //     dir = MoveDir.Down;
            //     break;
            // case 'down':
            //     targetMapId = MapUtils.getNextMap(MapConfig.currMapId.clone(), MoveDir.Down);
            //     dir = MoveDir.Up;
            // break;
        }
        MapEvent.onAfterMove.dispatch({
            currMapId: MapConfig.currMapId,
            targetMapId: targetMapId,
            dir: dir
        });
    }

    updateView(mapId: Vec2) {
        let nextMapId = MapUtils.getNextMap(mapId.clone(), MoveDir.Left)
        this.node.getChildByName("left").active = !!(nextMapId && MapConfig.maps[MapUtils.getMapKey(nextMapId)]);

        nextMapId = MapUtils.getNextMap(mapId.clone(), MoveDir.Right);
        this.node.getChildByName("right").active = !!(nextMapId && MapConfig.maps[MapUtils.getMapKey(nextMapId)]);

        // nextMapId = MapUtils.getNextMap(mapId.clone(), MoveDir.Up)
        // this.node.getChildByName("up").active = !!(nextMapId && MapConfig.maps[MapUtils.getMapKey(nextMapId)]);

        // nextMapId = MapUtils.getNextMap(mapId.clone(), MoveDir.Down)
        // this.node.getChildByName("down").active = !!(nextMapId && MapConfig.maps[MapUtils.getMapKey(nextMapId)]);
    }

    start() {
        this.updateView(v2(0, 0));
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}
